/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.sbi.celldesigner.Application;
import jp.sbi.sbml.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class SBMLValidator {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String SBML_SCHEMA_FILEPATH_L1V1 = "schema/sbml-level-1-v1.xsd";
    public static final String SBML_SCHEMA_FILEPATH_L1V2 = "schema/sbml-level-1-v2.xsd";
    public static final String SBML_SCHEMA_FILEPATH_L2V1 = "schema/sbml-level-2-v1.xsd";
    public static final String SBML_SCHEMA_FILEPATH_EXTV3 = "schema/Celldesigner30.xsd";
    public static final String SBML_SCHEMA_FILEPATH_EXTV4 = "schema/Celldesigner.xsd";
    public static final String TEST_SBML_STRING_L1v1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><sbml xmlns=\"http://www.sbml.org/sbml/level1\" level=\"1\" version=\"1\"><model><listOfCompartments><compartment name=\"test\"/></listOfCompartments><listOfSpecies><specie name=\"test1\" compartment=\"test\" initialAmount=\"0\"/><specie name=\"test2\" compartment=\"test\" initialAmount=\"0\"/></listOfSpecies><listOfReactions><reaction name=\"test\"><listOfReactants><specieReference specie=\"test1\"/></listOfReactants><listOfProducts><specieReference specie=\"test2\"/></listOfProducts></reaction></listOfReactions></model></sbml>";
    public static final String TEST_SBML_STRING_L1v2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><sbml xmlns=\"http://www.sbml.org/sbml/level1\" level=\"1\" version=\"2\"><model><listOfCompartments><compartment name=\"test\"/></listOfCompartments><listOfSpecies><species name=\"test1\" compartment=\"test\" initialAmount=\"0\"/><species name=\"test2\" compartment=\"test\" initialAmount=\"0\"/></listOfSpecies><listOfReactions><reaction name=\"test\"><listOfReactants><speciesReference species=\"test1\"/></listOfReactants><listOfProducts><speciesReference species=\"test2\"/></listOfProducts></reaction></listOfReactions></model></sbml>";
    public static final String TEST_SBML_STRING_L2v1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><sbml xmlns=\"http://www.sbml.org/sbml/level2\" level=\"2\" version=\"1\"><model id=\"test\"></model></sbml>";
    private static String schemaFilepath = "schema/sbml-level-2-v1.xsd";
    private static boolean isEnableValidation = true;

    static {
        try {
            SBMLValidationMessage message = SBMLValidator.validate(TEST_SBML_STRING_L1v1);
            if (message.getNumErrors() + message.getNumFatals() > 0L) {
                SBMLValidator.setEnavleValidation(false);
                System.err.println(SBMLValidator.getValidationResultMessage(message));
                System.err.println("[SBMLValidator.static{}] Failed to validate SBML Level 1 Version 1. SBML validation is disabled");
            } else {
                message = SBMLValidator.validate(TEST_SBML_STRING_L1v2);
                if (message.getNumErrors() + message.getNumFatals() > 0L) {
                    SBMLValidator.setEnavleValidation(false);
                    System.err.println(SBMLValidator.getValidationResultMessage(message));
                    System.err.println("[SBMLValidator.static{}] Failed to validate SBML Level 1 Version 2. SBML validation is disabled");
                } else {
                    message = SBMLValidator.validate(TEST_SBML_STRING_L2v1);
                    if (message.getNumErrors() + message.getNumFatals() > 0L) {
                        SBMLValidator.setEnavleValidation(false);
                        System.err.println(SBMLValidator.getValidationResultMessage(message));
                        System.err.println("[SBMLValidator.static{}] Failed to validate SBML Level 2 Version 1. SBML validation is disabled");
                    } else {
                        System.out.println("[SBMLValidator.static{}] SBML validation by SBMLValidator is enabled");
                    }
                }
            }
            message = null;
        }
        catch (Exception e) {
            SBMLValidator.setEnavleValidation(false);
            System.err.print("[SBMLFiler.static{}] SBML validation is disabled : ");
        }
    }

    SBMLValidator() {
    }

    public static void setEnavleValidation(boolean b) {
        isEnableValidation = b;
    }

    public static boolean isEnableValidation() {
        return isEnableValidation;
    }

    private static void selectSBMLSchemaFilepath(File file) throws Exception {
        Document doc = XMLUtil.readDocument(file);
        Node node = XMLUtil.getChildNode(doc, "sbml");
        int level = Integer.parseInt(XMLUtil.getAttributeValue(node, "level"));
        int version = Integer.parseInt(XMLUtil.getAttributeValue(node, "version"));
        if (level == 1 && version == 1) {
            schemaFilepath = SBML_SCHEMA_FILEPATH_L1V1;
        } else if (level == 1 && version == 2) {
            schemaFilepath = SBML_SCHEMA_FILEPATH_L1V2;
        } else if (level == 2 && version == 1) {
            schemaFilepath = SBML_SCHEMA_FILEPATH_L2V1;
        } else {
            throw new Exception(String.valueOf(file.getName()) + " : SBML Level " + level + " Version " + version + " is not supported.");
        }
    }

    private static void selectSBMLSchemaFilepath(String str) throws Exception {
        Document doc = XMLUtil.readDocument(str);
        Node node = XMLUtil.getChildNode(doc, "sbml");
        int level = Integer.parseInt(XMLUtil.getAttributeValue(node, "level"));
        int version = Integer.parseInt(XMLUtil.getAttributeValue(node, "version"));
        if (level == 1 && version == 1) {
            schemaFilepath = SBML_SCHEMA_FILEPATH_L1V1;
        } else if (level == 1 && version == 2) {
            schemaFilepath = SBML_SCHEMA_FILEPATH_L1V2;
        } else if (level == 2 && version == 1) {
            schemaFilepath = SBML_SCHEMA_FILEPATH_L2V1;
        } else {
            throw new Exception(" : SBML Level " + level + " Version " + version + " is not supported.");
        }
    }

    public static SBMLValidationMessage validate(File file) throws Exception {
        if (!isEnableValidation) {
            return new SBMLValidationMessage();
        }
        SBMLValidator.selectSBMLSchemaFilepath(file);
        FileInputStream is = new FileInputStream(file);
        return SBMLValidator.validate(is);
    }

    public static SBMLValidationMessage validate(String str) throws Exception {
        if (!isEnableValidation) {
            return new SBMLValidationMessage();
        }
        SBMLValidator.selectSBMLSchemaFilepath(str);
        StringBufferInputStream is = new StringBufferInputStream(str);
        return SBMLValidator.validate(is);
    }

    public static SBMLValidationMessage validate(InputStream is) throws Exception {
        InputSource schemaPaths = new InputSource(new BufferedInputStream(Application.class.getResourceAsStream(schemaFilepath)));
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        docfactory.setNamespaceAware(true);
        docfactory.setIgnoringElementContentWhitespace(true);
        if (schemaPaths != null) {
            schemaPaths.setSystemId(Application.class.getResource(schemaFilepath).toExternalForm());
            docfactory.setValidating(true);
            docfactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            docfactory.setAttribute(JAXP_SCHEMA_SOURCE, schemaPaths);
        } else {
            System.err.println("Schema does not exist. Set validation off.");
        }
        DocumentBuilder builder = docfactory.newDocumentBuilder();
        SBMLErrorHandler handler = new SBMLErrorHandler();
        builder.setErrorHandler(handler);
        builder.parse(is);
        return handler.getSBMLValidationMessage();
    }

    public static String getValidationResultMessage(SBMLValidationMessage validationMessage) {
        int i;
        long warnings;
        if (validationMessage == null) {
            return null;
        }
        long fatals = validationMessage.getNumFatals();
        long errors = validationMessage.getNumErrors();
        if (errors + fatals + (warnings = validationMessage.getNumWarnings()) == 0L) {
            return "VALID";
        }
        String errMessage = new String();
        if (warnings > 0L) {
            errMessage = String.valueOf(errMessage) + "\n" + warnings + " WARNING found:" + "\n\n";
            i = 0;
            while ((long)i < warnings) {
                errMessage = String.valueOf(errMessage) + validationMessage.getWarning(i) + "\n";
                ++i;
            }
        }
        if (errors > 0L) {
            errMessage = String.valueOf(errMessage) + "\n" + errors + " ERROR found:" + "\n\n";
            i = 0;
            while ((long)i < errors) {
                errMessage = String.valueOf(errMessage) + validationMessage.getError(i) + "\n";
                ++i;
            }
        }
        if (fatals > 0L) {
            errMessage = String.valueOf(errMessage) + "\n" + fatals + " FATAL ERROR found:" + "\n\n";
            i = 0;
            while ((long)i < fatals) {
                errMessage = String.valueOf(errMessage) + validationMessage.getFatal(i) + "\n";
                ++i;
            }
        }
        return errMessage;
    }

    public static SBMLValidationMessage validateCellDesingerEx(File testFile) throws Exception {
        if (!isEnableValidation) {
            return new SBMLValidationMessage();
        }
        schemaFilepath = SBML_SCHEMA_FILEPATH_EXTV4;
        FileInputStream is = new FileInputStream(testFile);
        return SBMLValidator.validate(is);
    }

    public static class SBMLErrorHandler
    implements ErrorHandler {
        private SBMLValidationMessage validationMessage = new SBMLValidationMessage();

        public SBMLValidationMessage getSBMLValidationMessage() {
            return this.validationMessage;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = " Line(" + spe.getLineNumber() + ") " + spe.getMessage();
            return info;
        }

        @Override
        public void warning(SAXParseException spe) {
            String message = this.getParseExceptionInfo(spe);
            this.validationMessage.addWarning(message);
        }

        @Override
        public void error(SAXParseException spe) {
            String message = this.getParseExceptionInfo(spe);
            if (spe.getMessage().matches(".*'notes'.*")) {
                this.validationMessage.addWarning(message);
                return;
            }
            this.validationMessage.addError(message);
        }

        @Override
        public void fatalError(SAXParseException spe) {
            String message = this.getParseExceptionInfo(spe);
            this.validationMessage.addFatal(message);
        }
    }

    public static class SBMLValidationMessage {
        private Vector warnMessage = new Vector();
        private Vector errorMessage = new Vector();
        private Vector fatalMessage = new Vector();

        SBMLValidationMessage() {
        }

        public void addWarning(String str) {
            this.warnMessage.add(str);
        }

        public void addError(String str) {
            this.errorMessage.add(str);
        }

        public void addFatal(String str) {
            this.fatalMessage.add(str);
        }

        public long getNumWarnings() {
            return this.warnMessage.size();
        }

        public long getNumErrors() {
            return this.errorMessage.size();
        }

        public long getNumFatals() {
            return this.fatalMessage.size();
        }

        public String getWarning(int i) {
            if (i < 0 || (long)i >= this.getNumWarnings()) {
                return null;
            }
            return (String)this.warnMessage.get(i);
        }

        public String getError(int i) {
            if (i < 0 || (long)i >= this.getNumErrors()) {
                return null;
            }
            return (String)this.errorMessage.get(i);
        }

        public String getFatal(int i) {
            if (i < 0 || (long)i >= this.getNumFatals()) {
                return null;
            }
            return (String)this.fatalMessage.get(i);
        }
    }
}

