/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.lang.reflect.Constructor;
import jp.sbi.celldesigner.MainWindowAccess;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ListPanel;
import jp.sbi.sbml.util.ParameterListPanel;
import jp.sbi.sbml.util.RuleListPanel;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseDialogListener;
import jp.sbi.sbml.util.SBaseListPanel;
import jp.sbi.sbml.util.SpeciesListPanel;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;

public class SBMLPanelLists {
    public static final int LIST_OF_FUNCTION_DEFINITIONS = 0;
    public static final int LIST_OF_UNIT_DEFINITIONS = 1;
    public static final int LIST_OF_COMPARTMENTS = 2;
    public static final int LIST_OF_SPECIES = 3;
    public static final int LIST_OF_PARAMETERS = 4;
    public static final int LIST_OF_RULES = 5;
    public static final int LIST_OF_REACTIONS = 6;
    public static final int LIST_OF_EVENTS = 7;
    public static final int LIST_OF_SPECIES_TYPES = 14;
    public static final int LIST_OF_COMPARTMENT_TYPES = 15;
    public static final int SIZE_OF_LISTS = 12;
    public static final int DIFFER = 6;
    public static final int LIST_OF_MODIFIER = 9;
    public static final int LIST_OF_PROTEIN = 10;
    public static final int LIST_OF_GENE = 11;
    public static final int LIST_OF_RNA = 12;
    public static final int LIST_OF_ANTI_SENSE_RNA = 13;
    public static final int LIST_OF_INITIAL_ASSIGNMENTS = 16;
    public static final int LIST_OF_CONSTRAINTS = 17;
    private boolean[] isFirstShowing;
    private SBaseListPanel[] listPanel = new SBaseListPanel[12];
    private SBaseDialog[] elementDialogs = new SBaseDialog[12];
    private static final String[] panelClassName = new String[]{"FunctionDefinitionDialog", "UnitDefinitionDialog", "CompartmentDialog", "SpeciesDialog", "ParameterDialog", "RuleDialog", "ReactionDialog", "EventDialog", "SpeciesTypeDialog", "CompartmentTypeDialog", "InitialAssignmentDialog", "ConstraintDialog"};
    private static final String[] dialogClassNameForRule = new String[]{"AlgebraicRuleDialog", "SpeciesConcentrationRuleDialog", "CompartmentVolumeRuleDialog", "ParameterRuleDialog"};
    private static final String[] elementClassNameForRule = new String[]{"AlgebraicRule", "SpeciesConcentrationRule", "CompartmentVolumeRule", "ParameterRule"};
    private static final String[] listToolTip = new String[]{"list Of Function Definitions", "list Of Unit Definitions", "list Of Compartments", "list Of Species", "list Of Parameters", "list Of Rules", "list Of Reactions", "list Of Events", "list Of SpeciesTypes", "list Of CompartmentTypes", "list Of InitialAssignments", "list Of Constraints"};
    private static final String[] listTab = new String[]{"Functions", "UnitDefinitions", "Compartments", "Species", "Parameters", "Rules", "Reactions", "Events", "SpeciesTypes", "CompartmentTypes", "InitialAssignments", "Constraints"};
    private final int NONE = 501;
    private final int FRAME = 502;
    private final int DIALOG = 503;
    private MainWindowAccess mainwindowaccess = null;

    public SBMLPanelLists(MainWindowAccess access) {
        this.mainwindowaccess = access;
        this.initListPanels();
        this.initIsFirstShowing();
    }

    private void initListPanels() {
        int i = 0;
        while (i < 12) {
            block4: {
                this.listPanel[i] = i == 5 ? new RuleListPanel() : (i == 4 ? new ParameterListPanel() : (i == 3 ? new SpeciesListPanel() : new ListPanel()));
                this.listPanel[i].setName(listTab[i]);
                this.listPanel[i].setToolTipText(listToolTip[i]);
                this.listPanel[i].setMainWindowAccess(this.mainwindowaccess);
                SBaseDialog elementDialog = null;
                String dialogName = String.valueOf(this.getClass().getPackage().getName()) + "." + panelClassName[i];
                try {
                    Constructor<?> con = Class.forName(dialogName).getConstructor(Class.forName("java.awt.Frame"));
                    elementDialog = (SBaseDialog)con.newInstance(this.mainwindowaccess);
                }
                catch (Exception e) {
                    DebugPrinter.println(1, "SBMLPanelLists-initListDialogs-cannnot construct:" + panelClassName[i] + " ,skip");
                    System.err.println(e.getMessage());
                    break block4;
                }
                if (elementDialog != null) {
                    elementDialog.setTitle(LibSBMLUtil.getElementClassName("Model", i));
                    this.listPanel[i].setElementDialog(elementDialog);
                    this.elementDialogs[i] = elementDialog;
                }
            }
            ++i;
        }
        this.elementDialogs[6].addSBaseDialogListener(new ParameterListsReactionDilalogListener());
    }

    private void setListDialogs(Model model) {
        int i = 0;
        while (i < 12) {
            if (model != null) {
                if (i == 0) {
                    this.listPanel[i].setSBaseList((ListOf)model.getListOfFunctionDefinitions());
                } else if (i == 1) {
                    this.listPanel[i].setSBaseList((ListOf)model.getListOfUnitDefinitions());
                } else if (i == 2) {
                    this.listPanel[i].setSBaseList((ListOf)model.getListOfCompartments());
                } else if (i == 3) {
                    this.listPanel[i].setSBaseList((ListOf)model.getListOfSpecies());
                } else if (i == 4) {
                    this.listPanel[i].setSBaseList((ListOf)model.getListOfParameters());
                } else if (i == 5) {
                    this.listPanel[i].setSBaseList((ListOf)model.getListOfRules());
                } else if (i == 6) {
                    this.listPanel[i].setSBaseList((ListOf)model.getListOfReactions());
                } else if (i == 7) {
                    this.listPanel[i].setSBaseList((ListOf)model.getListOfEvents());
                } else if (i == 8) {
                    this.listPanel[i].setSBaseList((ListOf)model.getListOfSpeciesTypes());
                } else if (i == 9) {
                    this.listPanel[i].setSBaseList((ListOf)model.getListOfCompartmentTypes());
                } else if (i == 10) {
                    this.listPanel[i].setSBaseList((ListOf)model.getListOfInitialAssignments());
                } else if (i == 11) {
                    this.listPanel[i].setSBaseList((ListOf)model.getListOfConstraints());
                } else {
                    this.listPanel[i].setSBaseList(null);
                }
            } else {
                this.listPanel[i].setSBaseList(null);
            }
            ++i;
        }
    }

    private void initIsFirstShowing() {
        this.isFirstShowing = new boolean[12];
        int i = 0;
        while (i < 12) {
            this.isFirstShowing[i] = true;
            ++i;
        }
    }

    protected void updateChildDialog() {
        int i = 0;
        while (i < 12) {
            SBaseListPanel listDlg = this.listPanel[i];
            if (listDlg != null) {
                listDlg.updateDialog();
            }
            ++i;
        }
    }

    public void updateAllDialog() {
        this.updateChildDialog();
    }

    public void setModel(Model model) {
        this.setListDialogs(model);
    }

    public void setInitialLocationTarget(Component target) {
    }

    public void setListElementDialogMode(int mode) {
        int i = 0;
        while (i < 12) {
            if (i == 8 || i == 9) {
                this.listPanel[i].setElementDialogMode(1);
            } else {
                this.listPanel[i].setElementDialogMode(mode);
            }
            ++i;
        }
    }

    public SBaseListPanel getSBaseListPanel(int list_const) {
        if (list_const == 14 || list_const == 15 || list_const == 16 || list_const == 17) {
            return this.listPanel[list_const - 6];
        }
        if (list_const < 0 || list_const >= 12) {
            return null;
        }
        return this.listPanel[list_const];
    }

    public SBaseDialog getElementDialog(int list_const) {
        if (list_const == 14 || list_const == 15 || list_const == 16 || list_const == 17) {
            return this.elementDialogs[list_const - 6];
        }
        if (list_const < 0 || list_const >= 12) {
            return null;
        }
        return this.elementDialogs[list_const];
    }

    public void releaseAllPanels() {
        int i = 0;
        while (i < 12) {
            this.listPanel[i].releaseAll();
            this.listPanel[i] = null;
            this.elementDialogs[i] = null;
            ++i;
        }
        this.listPanel = null;
        this.elementDialogs = null;
    }

    protected class ParameterListsReactionDilalogListener
    implements SBaseDialogListener {
        protected ParameterListsReactionDilalogListener() {
        }

        @Override
        public void objectCreated(SBase sbase) {
            SBMLPanelLists.this.listPanel[4].updateDialog();
        }

        @Override
        public void objectUpdated(SBase sbase, String[] oldValues) {
            SBMLPanelLists.this.listPanel[4].updateDialog();
        }

        @Override
        public void dialogCanceled(SBase sbase) {
        }
    }
}

