/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.lang.reflect.Constructor;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ListDialog;
import jp.sbi.sbml.util.RuleListDialogLevel1;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseListDialog;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.Model;

public class SBMLDialogs {
    private boolean[] isFirstShowing;
    private SBaseListDialog[] listDialog = new SBaseListDialog[12];
    private SBaseDialog[] elementDialogs = new SBaseDialog[12];
    private static String[] dialogClassName = new String[]{"FunctionDefinitionDialog", "UnitDefinitionDialog", "CompartmentDialog", "SpeciesDialog", "ParameterDialog", "RuleDialog", "ReactionDialog", "EventDialog", "SpeciesTypeDialog", "CompartmentTypeDialog", "InitialAssignmentDialog", "ConstraintDialog"};
    private static String[] dialogClassNameForRule = new String[]{"AlgebraicRuleDialog", "SpeciesConcentrationRuleDialog", "CompartmentVolumeRuleDialog", "ParameterRuleDialog"};
    private static String[] elementClassNameForRule = new String[]{"AlgebraicRule", "SpeciesConcentrationRule", "CompartmentVolumeRule", "ParameterRule"};
    private Component positioningTarget;
    private final int NONE = 501;
    private final int FRAME = 502;
    private final int DIALOG = 503;

    public SBMLDialogs() {
        this.initListDialogs(null, 501);
        this.initIsFirstShowing();
        this.positioningTarget = null;
    }

    public SBMLDialogs(Frame owner) {
        this.initListDialogs(owner, 502);
        this.initIsFirstShowing();
        this.positioningTarget = owner;
    }

    public SBMLDialogs(Dialog owner) {
        this.initListDialogs(owner, 503);
        this.initIsFirstShowing();
        this.positioningTarget = owner;
    }

    private void initListDialogs(Component listOwner, int flag) {
        int i = 0;
        while (i < 12) {
            block12: {
                if (i == 5) {
                    this.listDialog[i] = flag == 502 ? new RuleListDialogLevel1((Frame)listOwner) : (flag == 503 ? new RuleListDialogLevel1((Dialog)listOwner) : new RuleListDialogLevel1());
                    this.listDialog[i].setTitle(LibSBMLUtil.getListTagName("Model", i));
                    int j = 0;
                    while (j < dialogClassNameForRule.length) {
                        block11: {
                            SBaseDialog elementDialog = null;
                            String dialogName = String.valueOf(this.getClass().getPackage().getName()) + "." + dialogClassNameForRule[j];
                            SBaseListDialog owner = this.listDialog[i];
                            try {
                                Constructor<?> con = Class.forName(dialogName).getConstructor(Class.forName("java.awt.Dialog"));
                                elementDialog = (SBaseDialog)con.newInstance(owner);
                            }
                            catch (Exception e) {
                                DebugPrinter.println(1, "SBMLDialogs-initListDialogs-cannnot construct:" + dialogClassNameForRule[j] + " ,skip");
                                break block11;
                            }
                            if (elementDialog != null) {
                                elementDialog.setTitle(elementClassNameForRule[j]);
                                this.listDialog[i].setElementDialog(elementDialog, j);
                            }
                        }
                        ++j;
                    }
                } else {
                    this.listDialog[i] = flag == 502 ? new ListDialog((Frame)listOwner) : (flag == 503 ? new ListDialog((Dialog)listOwner) : new ListDialog());
                    this.listDialog[i].setTitle(LibSBMLUtil.getListTagName("Model", i));
                    SBaseDialog elementDialog = null;
                    String dialogName = String.valueOf(this.getClass().getPackage().getName()) + "." + dialogClassName[i];
                    SBaseListDialog owner = this.listDialog[i];
                    try {
                        Constructor<?> con = Class.forName(dialogName).getConstructor(Class.forName("java.awt.Dialog"));
                        elementDialog = (SBaseDialog)con.newInstance(owner);
                    }
                    catch (Exception e) {
                        DebugPrinter.println(1, "SBMLDialogs-initListDialogs-cannnot construct:" + dialogClassName[i] + " ,skip");
                        break block12;
                    }
                    if (elementDialog != null) {
                        elementDialog.setTitle(LibSBMLUtil.getElementClassName("Model", i));
                        this.listDialog[i].setElementDialog(elementDialog);
                        this.elementDialogs[i] = elementDialog;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < 12) {
            this.listDialog[i].setModal(false);
            ++i;
        }
    }

    private void setListDialogs(Model model) {
        int i = 0;
        while (i < 12) {
            if (model != null) {
                if (i == 0) {
                    this.listDialog[i].setSBaseList((ListOf)model.getListOfFunctionDefinitions());
                } else if (i == 1) {
                    this.listDialog[i].setSBaseList((ListOf)model.getListOfUnitDefinitions());
                } else if (i == 2) {
                    this.listDialog[i].setSBaseList((ListOf)model.getListOfCompartments());
                } else if (i == 3) {
                    this.listDialog[i].setSBaseList((ListOf)model.getListOfSpecies());
                } else if (i == 4) {
                    this.listDialog[i].setSBaseList((ListOf)model.getListOfParameters());
                } else if (i == 5) {
                    this.listDialog[i].setSBaseList((ListOf)model.getListOfRules());
                } else if (i == 6) {
                    this.listDialog[i].setSBaseList((ListOf)model.getListOfReactions());
                } else if (i == 7) {
                    this.listDialog[i].setSBaseList((ListOf)model.getListOfEvents());
                } else if (i == 8) {
                    this.listDialog[i].setSBaseList((ListOf)model.getListOfSpeciesTypes());
                } else if (i == 9) {
                    this.listDialog[i].setSBaseList((ListOf)model.getListOfCompartmentTypes());
                } else if (i == 10) {
                    this.listDialog[i].setSBaseList((ListOf)model.getListOfInitialAssignments());
                } else if (i == 11) {
                    this.listDialog[i].setSBaseList((ListOf)model.getListOfConstraints());
                }
            } else {
                this.listDialog[i].setSBaseList(null);
            }
            ++i;
        }
    }

    private void initIsFirstShowing() {
        this.isFirstShowing = new boolean[12];
        int i = 0;
        while (i < 12) {
            this.isFirstShowing[i] = true;
            ++i;
        }
    }

    private void setListDialogPosition(int i) {
        if (this.listDialog[i] != null && this.isFirstShowing[i] && this.positioningTarget != null) {
            Point p = this.positioningTarget.getLocation();
            Dimension mysize = this.positioningTarget.getSize();
            Dimension dlgsize = this.listDialog[i].getSize();
            int x = p.x + (mysize.width - dlgsize.width) / 2;
            int y = p.y + (mysize.height - dlgsize.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.listDialog[i].setLocation(x, y);
            this.isFirstShowing[i] = false;
        }
    }

    protected void updateChildDialog() {
        int i = 0;
        while (i < 12) {
            SBaseListDialog listDlg = this.listDialog[i];
            if (listDlg != null) {
                listDlg.updateDialog();
            }
            ++i;
        }
    }

    public void setModel(Model model) {
        this.setListDialogs(model);
    }

    public void setInitialLocationTarget(Component target) {
        this.positioningTarget = target;
    }

    public void setListElementDialogMode(int mode) {
        int i = 0;
        while (i < 12) {
            this.listDialog[i].setElementDialogMode(mode);
            ++i;
        }
    }

    public SBaseListDialog getSBaseListDialog(int list_const) {
        if (list_const < 0 || list_const >= 12) {
            return null;
        }
        return this.listDialog[list_const];
    }

    public SBaseDialog getElementDialog(int list_const) {
        if (list_const < 0 || list_const >= 12) {
            return null;
        }
        return this.elementDialogs[list_const];
    }

    public void releaseAllDialogs() {
        int i = 0;
        while (i < 12) {
            this.listDialog[i].releaseAll();
            this.listDialog[i] = null;
            this.elementDialogs[i] = null;
            ++i;
        }
        this.listDialog = null;
        this.elementDialogs = null;
    }

    public void showListDialog(int i) {
        this.setListDialogPosition(i);
        this.listDialog[i].show();
    }
}

