/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.AlgebraicRuleDialog;
import jp.sbi.sbml.util.CompartmentVolumeRuleDialog;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ParameterRuleDialog;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseDialogListener;
import jp.sbi.sbml.util.SBaseListPanel;
import jp.sbi.sbml.util.SBaseListPanelListener;
import jp.sbi.sbml.util.SpeciesConcentrationRuleDialog;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.SBase;

public class RuleListPanelLevel1
extends SBaseListPanel {
    public static final int NEW_A_BUTTON = 0;
    public static final int NEW_S_BUTTON = 1;
    public static final int NEW_C_BUTTON = 2;
    public static final int NEW_P_BUTTON = 3;
    public static final int EDIT_BUTTON = 4;
    public static final int REMOVE_BUTTON = 5;
    public static final int CLEAR_BUTTON = 6;
    public static final int CLOSE_BUTTON = 7;
    public static final int SIZE_OF_BUTTONS = 8;
    private static final int ALGEBRAIC_RULE_DIALOG = 0;
    private static final int SPECIES_CONCENTRATION_RULE_DIALOG = 1;
    private static final int COMPARTMENT_VOLUME_RULE_DIALOG = 2;
    private static final int PARAMETER_RULE_DIALOG = 3;
    private static final int SIZE_OF_DIALOGS = 4;
    private static final String[] tagNames = new String[]{"algebraicRule", "speciesConcentrationRule", "compartmentVolumeRule", "parameterRule"};
    private SBaseDialog[] elementDlgs = new SBaseDialog[4];
    private boolean[] isFirstShowing;
    private MySBaseDialogListener[] elementDlgListeners = new MySBaseDialogListener[4];
    private JScrollPane scrollPane;
    private JButton newAlgebraicRuleButton;
    private JButton newSpeciesConcentrationRuleButton;
    private JButton newCompartmentVolumeRuleButton;
    private JButton newParameterRuleButton;
    private JButton editButton;
    private JButton removeButton;
    private JButton clearButton;
    private JButton closeButton;
    private JPanel buttonPanel;
    private static final int DEFAULT_DIALOG_WIDTH = 600;
    private boolean[] buttonFlag = new boolean[8];

    @Override
    public void valueSettedToCell(Object settedvalue, int rowIndex, int columnIndex) {
        SBase base = this.sbaseList.get((long)rowIndex);
        int kind = this.distinguishElement(base);
        if (kind == -1) {
            return;
        }
        SBaseDialog elementDlg = this.elementDlgs[kind];
        elementDlg.setObject(base);
        elementDlg.updateDialog();
        String val = (String)settedvalue;
        String form = (String)this.table.getValueAt(rowIndex, 1);
        String type = (String)this.table.getValueAt(rowIndex, 2);
        String species = (String)this.table.getValueAt(rowIndex, 3);
        String comp = (String)this.table.getValueAt(rowIndex, 4);
        String param = (String)this.table.getValueAt(rowIndex, 5);
        if (columnIndex == 1) {
            form = val;
        } else if (columnIndex == 2) {
            type = val;
        } else if (columnIndex == 3) {
            species = val;
        } else if (columnIndex == 4) {
            comp = val;
        } else if (columnIndex == 5) {
            param = val;
        }
        if (kind == 0) {
            AlgebraicRuleDialog dlg = (AlgebraicRuleDialog)elementDlg;
            dlg.setDialogByArg(form);
        } else if (kind == 1) {
            SpeciesConcentrationRuleDialog dlg = (SpeciesConcentrationRuleDialog)elementDlg;
            dlg.setDialogByArg(form, type, species);
        } else if (kind == 2) {
            CompartmentVolumeRuleDialog dlg = (CompartmentVolumeRuleDialog)elementDlg;
            dlg.setDialogByArg(form, type, comp);
        } else if (kind == 3) {
            ParameterRuleDialog dlg = (ParameterRuleDialog)elementDlg;
            dlg.setDialogByArg(form, type, param);
        }
        if (!elementDlg.update_actionPerformed()) {
            this.table.setRowSelectionInterval(rowIndex, rowIndex);
            this.tableedited = true;
        }
    }

    public RuleListPanelLevel1() {
        this.initPanel();
        this.initIsFirstShowing();
        this.initButtonFlag();
    }

    void table_mouseClicked(MouseEvent e) {
        boolean[] flagarray = null;
        JTableHeader header = this.table.getTableHeader();
        TableColumnModel columnmodel = header.getColumnModel();
        int columnIndex = -1;
        int k = 0;
        while (k < columnmodel.getColumnCount()) {
            TableColumn scolumn = columnmodel.getColumn(k);
            String headername = (String)scolumn.getHeaderValue();
            if (headername.compareTo("kind") == 0) {
                columnIndex = k;
                break;
            }
            ++k;
        }
        int i = 0;
        while (i < this.table.getRowCount()) {
            String kind = (String)this.table.getValueAt(i, columnIndex);
            if (kind.compareTo("Algebraic") == 0) {
                flagarray = this.editable;
            } else if (kind.compareTo("Species") == 0) {
                flagarray = this.editable1;
            } else if (kind.compareTo("Compartment") == 0) {
                flagarray = this.editable2;
            } else if (kind.compareTo("Parameter") == 0) {
                flagarray = this.editable3;
            }
            ++i;
        }
        if (e.getClickCount() == 2 && this.editButton.isEnabled()) {
            this.editButton_actionPerformed();
        }
    }

    private void initPanel() {
        this.newAlgebraicRuleButton = new JButton("NewA");
        this.newAlgebraicRuleButton.setMnemonic(65);
        this.newAlgebraicRuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleListPanelLevel1.this.newAlgebraicRuleButton_actionPerformed();
            }
        });
        this.newSpeciesConcentrationRuleButton = new JButton("NewS");
        this.newSpeciesConcentrationRuleButton.setMnemonic(83);
        this.newSpeciesConcentrationRuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleListPanelLevel1.this.newSpeciesConcentrationRuleButton_actionPerformed();
            }
        });
        this.newCompartmentVolumeRuleButton = new JButton("NewC");
        this.newCompartmentVolumeRuleButton.setMnemonic(67);
        this.newCompartmentVolumeRuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleListPanelLevel1.this.newCompartmentVolumeRuleButton_actionPerformed();
            }
        });
        this.newParameterRuleButton = new JButton("NewP");
        this.newParameterRuleButton.setMnemonic(80);
        this.newParameterRuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleListPanelLevel1.this.newParameterRuleButton_actionPerformed();
            }
        });
        this.editButton = new JButton("Edit");
        this.editButton.setMnemonic(69);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleListPanelLevel1.this.editButton_actionPerformed();
            }
        });
        this.removeButton = new JButton("Remove");
        this.removeButton.setMnemonic(82);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleListPanelLevel1.this.removeButton_actionPerformed();
            }
        });
        this.clearButton = new JButton("Clear All");
        this.clearButton.setMnemonic(76);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleListPanelLevel1.this.clearButton_actionPerformed();
            }
        });
        this.closeButton = new JButton("Close");
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.newAlgebraicRuleButton);
        this.buttonPanel.add(this.newSpeciesConcentrationRuleButton);
        this.buttonPanel.add(this.newCompartmentVolumeRuleButton);
        this.buttonPanel.add(this.newParameterRuleButton);
        this.buttonPanel.add(this.removeButton);
        this.buttonPanel.add(this.clearButton);
        this.keyListener = new SBaseListPanel.MyKeyListener(this);
        this.addKeyListener(this.keyListener);
        this.table = new JTable(){

            @Override
            public boolean isManagingFocus() {
                return false;
            }
        };
        this.table.addMouseListener(new RuleListPanel_mouseAdapter(this));
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setAutoscrolls(true);
        this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.selectionListener = new SBaseListPanel.MyListSelectionListener(this);
        this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonPanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.setSize(new Dimension(611, 240));
        this.changeButtonsEnability();
    }

    @Override
    public SBaseDialog getElementDialog() {
        return null;
    }

    @Override
    public SBaseDialog getElementDialog(int element_const) {
        if (element_const < 0 || element_const >= 4) {
            return null;
        }
        return this.elementDlgs[element_const];
    }

    @Override
    public void setElementDialog(SBaseDialog dialog) {
    }

    @Override
    public void setElementDialog(SBaseDialog dialog, int i) {
        if (dialog == null) {
            return;
        }
        this.elementDlgs[i] = dialog;
        this.elementDlgListeners[i] = new MySBaseDialogListener(i);
        dialog.addSBaseDialogListener(this.elementDlgListeners[i]);
        SBase sbase = dialog.createInitialObject();
        this.setElementDialogMode(this.elementDlgMode);
        this.initTableModel(sbase);
        this.changeButtonsEnability();
    }

    @Override
    public void setElementDialogMode(int mode) {
        this.elementDlgMode = mode;
        int i = 0;
        while (i < 4) {
            SBaseDialog elementDlg = this.elementDlgs[i];
            if (elementDlg != null) {
                if (this.elementDlgMode == 1) {
                    elementDlg.setModal(true);
                } else {
                    elementDlg.setModal(false);
                }
                if (elementDlg.hasChildListDialog()) {
                    elementDlg.setChildDialogMode(mode);
                }
            }
            ++i;
        }
    }

    @Override
    public void setSelfOperational(boolean isOperational) {
        RuleListPanelLevel1 c = this;
        boolean hasAdded = false;
        Component[] comp = c.getComponents();
        int i = 0;
        while (i < comp.length) {
            if (comp[i] == this.buttonPanel) {
                hasAdded = true;
            }
            ++i;
        }
        if (isOperational && !hasAdded) {
            c.add((Component)this.buttonPanel, "South");
        } else if (!isOperational && hasAdded) {
            c.remove(this.buttonPanel);
        }
        this.validate();
        i = 0;
        while (i < 4) {
            SBaseDialog elementDlg = this.elementDlgs[i];
            if (elementDlg != null && elementDlg.isShowing()) {
                elementDlg.setVisible(false);
            }
            ++i;
        }
        this.isSelfOperational = isOperational;
    }

    @Override
    public void setSBaseList(ListOf sbaseList) {
        this.sbaseList = sbaseList;
        int i = 0;
        while (i < 4) {
            SBaseDialog elementDlg = this.elementDlgs[i];
            if (elementDlg != null) {
                elementDlg.setNewObject();
                elementDlg.updateDialog();
            }
            ++i;
        }
        this.updateDialog();
    }

    @Override
    public void releaseAll() {
        this.sbaseList = null;
        int i = 0;
        while (i < 4) {
            SBaseDialog elementDlg = this.elementDlgs[i];
            if (elementDlg != null) {
                elementDlg.removeSBaseDialogListener(this.elementDlgListeners[i]);
                elementDlg = null;
            }
            ++i;
        }
        this.elementDlgs = null;
        i = 0;
        while (i < 4) {
            MySBaseDialogListener elementDlgListener = this.elementDlgListeners[i];
            if (elementDlgListener != null) {
                Object var2_2 = null;
            }
            ++i;
        }
        this.elementDlgListeners = null;
        this.table.getSelectionModel().removeListSelectionListener(this.selectionListener);
        this.selectionListener = null;
        this.removeKeyListener(this.keyListener);
        this.keyListener = null;
        this.listeners.clear();
        this.listeners = null;
    }

    @Override
    public void disableChildDialog() {
    }

    @Override
    public void setButtonVisible(int button_const, boolean isVisible) {
        this.buttonPanel.remove(this.newAlgebraicRuleButton);
        this.buttonPanel.remove(this.newSpeciesConcentrationRuleButton);
        this.buttonPanel.remove(this.newCompartmentVolumeRuleButton);
        this.buttonPanel.remove(this.newParameterRuleButton);
        this.buttonPanel.remove(this.removeButton);
        this.buttonPanel.remove(this.clearButton);
        this.buttonFlag[button_const] = isVisible;
        int i = 0;
        while (i < 8) {
            if (this.buttonFlag[i]) {
                if (i == 0) {
                    this.buttonPanel.add(this.newAlgebraicRuleButton);
                } else if (i == 1) {
                    this.buttonPanel.add(this.newSpeciesConcentrationRuleButton);
                } else if (i == 2) {
                    this.buttonPanel.add(this.newCompartmentVolumeRuleButton);
                } else if (i == 3) {
                    this.buttonPanel.add(this.newParameterRuleButton);
                } else if (i == 5) {
                    this.buttonPanel.add(this.removeButton);
                } else if (i == 6) {
                    this.buttonPanel.add(this.clearButton);
                }
            }
            ++i;
        }
        this.validate();
        this.repaint();
    }

    @Override
    protected void changeButtonsEnability() {
        this.newAlgebraicRuleButton.setEnabled(false);
        this.newSpeciesConcentrationRuleButton.setEnabled(false);
        this.newCompartmentVolumeRuleButton.setEnabled(false);
        this.newParameterRuleButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.closeButton.setEnabled(true);
        if (this.sbaseList == null) {
            return;
        }
        int i = 0;
        while (i < 4) {
            SBaseDialog elementDlg = this.elementDlgs[i];
            if (elementDlg == null) {
                return;
            }
            ++i;
        }
        this.newAlgebraicRuleButton.setEnabled(true);
        this.newSpeciesConcentrationRuleButton.setEnabled(true);
        this.newCompartmentVolumeRuleButton.setEnabled(true);
        this.newParameterRuleButton.setEnabled(true);
        if (this.sbaseList.size() > 0L) {
            this.clearButton.setEnabled(true);
            SBase[] selected = this.getSelectedElements();
            if (selected.length > 0) {
                this.removeButton.setEnabled(true);
                if (selected.length == 1) {
                    int kind = this.distinguishElement(selected[0]);
                    if (kind == -1) {
                        return;
                    }
                    SBaseDialog elementDlg = this.elementDlgs[kind];
                    if (elementDlg == null) {
                        return;
                    }
                    this.editButton.setEnabled(true);
                }
            }
        }
    }

    @Override
    protected void changeElementDialogEnability() {
        SBase[] selected = this.getSelectedElements();
        if (selected.length == 1) {
            int kind = this.distinguishElement(selected[0]);
            if (kind == -1) {
                return;
            }
            int i = 0;
            while (i < 4) {
                SBaseDialog elementDlg = this.elementDlgs[i];
                if (elementDlg != null && elementDlg.isShowing()) {
                    if (i == kind) {
                        elementDlg.setObject(this.getLastSelectedElement());
                    } else {
                        elementDlg.setObject(null);
                    }
                    elementDlg.updateDialog();
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < 4) {
                SBaseDialog elementDlg = this.elementDlgs[i];
                if (elementDlg != null && elementDlg.isShowing()) {
                    elementDlg.setObject(null);
                    elementDlg.updateDialog();
                }
                ++i;
            }
        }
    }

    @Override
    protected void updateChildDialog() {
        int i = 0;
        while (i < 4) {
            SBaseDialog elementDlg = this.elementDlgs[i];
            if (elementDlg != null) {
                elementDlg.updateDialog();
            }
            ++i;
        }
    }

    private void showElementDialog(int i) {
        SBaseDialog elementDlg = this.elementDlgs[i];
        if (elementDlg != null) {
            if (this.isFirstShowing[i]) {
                Point p = this.getLocation();
                Dimension mysize = this.getSize();
                Dimension dlgsize = elementDlg.getSize();
                int x = p.x + (mysize.width - dlgsize.width) / 2;
                int y = p.y + (mysize.height - dlgsize.height) / 2;
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                elementDlg.setLocation(x, y);
                this.isFirstShowing[i] = false;
            }
            elementDlg.show();
        }
    }

    private void initIsFirstShowing() {
        this.isFirstShowing = new boolean[4];
        int i = 0;
        while (i < 4) {
            this.isFirstShowing[i] = true;
            ++i;
        }
    }

    private int distinguishElement(Object sbase) {
        int kind = -1;
        if (sbase == null) {
            return kind;
        }
        if (((SBase)sbase).getClass().getName().equals(String.valueOf(sbase.getClass().getPackage().getName()) + "." + "AlgebraicRule")) {
            kind = 0;
        } else if (((SBase)sbase).getClass().getName().equals(String.valueOf(sbase.getClass().getPackage().getName()) + "." + "SpeciesConcentrationRule")) {
            kind = 1;
        } else if (((SBase)sbase).getClass().getName().equals(String.valueOf(sbase.getClass().getPackage().getName()) + "." + "CompartmentVolumeRule")) {
            kind = 2;
        } else if (((SBase)sbase).getClass().getName().equals(String.valueOf(sbase.getClass().getPackage().getName()) + "." + "ParameterRule")) {
            kind = 3;
        }
        return kind;
    }

    private void newAlgebraicRuleButton_actionPerformed() {
        if (this.sbaseList == null || this.elementDlgs[0] == null) {
            return;
        }
        this.table.clearSelection();
        SBaseDialog elementDlg = this.elementDlgs[0];
        elementDlg.setNewObject();
        elementDlg.updateDialog();
        this.showElementDialog(0);
    }

    private void newSpeciesConcentrationRuleButton_actionPerformed() {
        if (this.sbaseList == null || this.elementDlgs[1] == null) {
            return;
        }
        this.table.clearSelection();
        SBaseDialog elementDlg = this.elementDlgs[1];
        elementDlg.setNewObject();
        elementDlg.updateDialog();
        this.showElementDialog(1);
    }

    private void newCompartmentVolumeRuleButton_actionPerformed() {
        if (this.sbaseList == null || this.elementDlgs[2] == null) {
            return;
        }
        this.table.clearSelection();
        SBaseDialog elementDlg = this.elementDlgs[2];
        elementDlg.setNewObject();
        elementDlg.updateDialog();
        this.showElementDialog(2);
    }

    private void newParameterRuleButton_actionPerformed() {
        if (this.sbaseList == null || this.elementDlgs[3] == null) {
            return;
        }
        this.table.clearSelection();
        SBaseDialog elementDlg = this.elementDlgs[3];
        elementDlg.setNewObject();
        elementDlg.updateDialog();
        this.showElementDialog(3);
    }

    private void editButton_actionPerformed() {
        if (this.sbaseList == null) {
            return;
        }
        SBase[] selected = this.getSelectedElements();
        if (selected.length == 1) {
            int kind = this.distinguishElement(selected[0]);
            if (kind == -1) {
                return;
            }
            SBaseDialog elementDlg = this.elementDlgs[kind];
            if (elementDlg == null) {
                return;
            }
            elementDlg.setObject(selected[0]);
            elementDlg.updateDialog();
            this.showElementDialog(kind);
        }
    }

    @Override
    protected void removeButton_actionPerformed() {
        if (this.sbaseList == null) {
            return;
        }
        int[] index = this.table.getSelectedRows();
        SBase[] selected = this.getSelectedElements();
        if (selected.length > 0) {
            int i = 0;
            while (i < selected.length) {
                LibSBMLUtil.removeSBase(selected[i], this.sbaseList);
                ++i;
            }
            this.updateDialog();
            Vector list = (Vector)this.listeners.clone();
            int i2 = 0;
            while (i2 < list.size()) {
                SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i2);
                listener.elementsRemoved(selected, index);
                ++i2;
            }
        }
    }

    private void clearButton_actionPerformed() {
        if (this.sbaseList == null) {
            return;
        }
        SBase[] removed = LibSBMLUtil.toArray(this.sbaseList);
        int[] index = new int[removed.length];
        int i = 0;
        while (i < index.length) {
            index[i] = i;
            ++i;
        }
        this.sbaseList = new ListOf();
        Vector list = (Vector)this.listeners.clone();
        int i2 = 0;
        while (i2 < list.size()) {
            SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i2);
            listener.elementsRemoved(removed, index);
            ++i2;
        }
        this.updateDialog();
        i2 = 0;
        while (i2 < 4) {
            SBaseDialog elementDlg = this.elementDlgs[i2];
            if (elementDlg != null) {
                elementDlg.setObject(null);
                elementDlg.updateDialog();
            }
            ++i2;
        }
    }

    private void initButtonFlag() {
        int i = 0;
        while (i < 8) {
            this.buttonFlag[i] = true;
            ++i;
        }
    }

    @Override
    protected void initTableModel(SBase sbase) {
        if (sbase == null) {
            return;
        }
        String[] columnNames = new String[]{"kind", "form.", "type", "speci.", "comp.", "param."};
        int[] columnSizes = new int[]{80, 300, 70, 70, 70, 70};
        this.listTableModel = new SBaseListPanel.MyTableModel(this, columnNames);
        this.table.setModel(this.listTableModel);
        try {
            int dialog_witdh = 0;
            int i = 0;
            while (i < columnSizes.length) {
                TableColumn column = this.table.getColumnModel().getColumn(i);
                column.setPreferredWidth(columnSizes[i]);
                dialog_witdh += columnSizes[i];
                ++i;
            }
            this.setSize(dialog_witdh + 11, this.getSize().height);
            this.validate();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            DebugPrinter.println(1, e.getMessage());
        }
    }

    @Override
    public void showElementDialog(SBase sbase) {
    }

    private class MySBaseDialogListener
    implements SBaseDialogListener {
        String dlgName = "";
        int dlgNumber;

        public MySBaseDialogListener(int i) {
            this.dlgName = tagNames[i];
            this.dlgNumber = i;
        }

        @Override
        public void objectCreated(SBase sbase) {
            if (sbase == null) {
                return;
            }
            DebugPrinter.println(2, String.valueOf(this.dlgName) + ":objectCreated()");
            RuleListPanelLevel1.this.sbaseList.appendAndOwn(sbase);
            RuleListPanelLevel1.this.updateDialog();
            SBaseDialog elementDlg = RuleListPanelLevel1.this.elementDlgs[this.dlgNumber];
            if (elementDlg == null) {
                return;
            }
            if (RuleListPanelLevel1.this.elementDlgMode == 1 && !elementDlg.hasChildListDialog()) {
                elementDlg.setVisible(false);
            }
            Vector list = (Vector)RuleListPanelLevel1.this.listeners.clone();
            int i = 0;
            while (i < list.size()) {
                SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i);
                listener.elementAdded(sbase);
                ++i;
            }
        }

        @Override
        public void objectUpdated(SBase sbase, String[] oldValues) {
            if (sbase == null) {
                return;
            }
            DebugPrinter.println(2, String.valueOf(this.dlgName) + ":objectUpdated()");
            RuleListPanelLevel1.this.listTableModel.fireTableRowsUpdated(0, (int)RuleListPanelLevel1.this.sbaseList.size() - 1);
            SBaseDialog elementDlg = RuleListPanelLevel1.this.elementDlgs[this.dlgNumber];
            if (elementDlg == null) {
                return;
            }
            if (RuleListPanelLevel1.this.elementDlgMode == 1 && !elementDlg.hasChildListDialog()) {
                elementDlg.setVisible(false);
            }
            Vector list = (Vector)RuleListPanelLevel1.this.listeners.clone();
            int i = 0;
            while (i < list.size()) {
                SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i);
                listener.elementUpdated(sbase, oldValues);
                ++i;
            }
        }

        @Override
        public void dialogCanceled(SBase sbase) {
            DebugPrinter.println(2, String.valueOf(this.dlgName) + ":dialogCanceled()");
            SBaseDialog elementDlg = RuleListPanelLevel1.this.elementDlgs[this.dlgNumber];
            if (elementDlg == null) {
                return;
            }
            elementDlg.setVisible(false);
        }
    }

    private class RuleListPanel_mouseAdapter
    extends MouseAdapter {
        RuleListPanelLevel1 adaptee;

        RuleListPanel_mouseAdapter(RuleListPanelLevel1 adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.adaptee.table_mouseClicked(e);
        }
    }
}

