/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.ListPanel;
import jp.sbi.sbml.util.RuleDialog;
import jp.sbi.sbml.util.SBaseListPanel;
import org.sbml.libsbml.SBase;

public class RuleListPanel
extends ListPanel {
    private JButton newAlgebraicRuleButton;
    private JButton newAssignmentRuleButton;
    private JButton newRateRuleButton;

    public RuleListPanel() {
    }

    public RuleListPanel(boolean isShowDialog) {
        super(isShowDialog);
    }

    @Override
    protected void initPanel() {
        ActionListener newButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleListPanel.this.newButton_actionPerformed(e);
            }
        };
        this.newAlgebraicRuleButton = new JButton("New Algebraic");
        this.newAlgebraicRuleButton.setMargin(SBaseListPanel.buttonInsets);
        this.newAlgebraicRuleButton.addActionListener(newButtonActionListener);
        this.newAssignmentRuleButton = new JButton("New Assignment");
        this.newAssignmentRuleButton.setMargin(SBaseListPanel.buttonInsets);
        this.newAssignmentRuleButton.addActionListener(newButtonActionListener);
        this.newRateRuleButton = new JButton("New Rate");
        this.newRateRuleButton.setMargin(SBaseListPanel.buttonInsets);
        this.newRateRuleButton.addActionListener(newButtonActionListener);
        this.editButton = new JButton("Edit");
        this.editButton.setMargin(SBaseListPanel.buttonInsets);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleListPanel.this.editButton_actionPerformed();
            }
        });
        this.removeButton = new JButton("Remove");
        this.removeButton.setMargin(SBaseListPanel.buttonInsets);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleListPanel.this.removeButton_actionPerformed();
            }
        });
        this.clearButton = new JButton("Clear All");
        this.clearButton.setMargin(SBaseListPanel.buttonInsets);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleListPanel.this.clearButton_actionPerformed();
            }
        });
        this.exportCSVButton = new JButton("Export");
        this.exportCSVButton.setMargin(SBaseListPanel.buttonInsets);
        this.exportCSVButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleListPanel.this.exportCSVButton_actionPerformed();
            }
        });
        this.buttonPanel = new JPanel(){

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        if (this.isShowDialog) {
            this.buttonPanel.add(this.newAlgebraicRuleButton);
            this.buttonPanel.add(this.newAssignmentRuleButton);
            this.buttonPanel.add(this.newRateRuleButton);
            this.buttonPanel.add(this.editButton);
            this.buttonPanel.add(this.removeButton);
            this.buttonPanel.add(this.clearButton);
            this.buttonPanel.add(this.exportCSVButton);
        }
        this.keyListener = new SBaseListPanel.MyKeyListener(this);
        this.addKeyListener(this.keyListener);
        this.table = new JTable(){

            @Override
            public boolean isManagingFocus() {
                return false;
            }
        };
        this.scrollPane = new JScrollPane(this.table){

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.scrollPane.setAutoscrolls(true);
        this.selectionListener = new SBaseListPanel.MyListSelectionListener(this);
        this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.table.addMouseListener(new ListPanel.ListPanel_mouseAdapter(this));
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonPanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.setSize(new Dimension(611, 240));
        this.changeButtonsEnability();
    }

    @Override
    public void setButtonVisible(int button_const, boolean isVisible) {
        this.buttonPanel.remove(this.newAlgebraicRuleButton);
        this.buttonPanel.remove(this.newAssignmentRuleButton);
        this.buttonPanel.remove(this.newRateRuleButton);
        this.buttonPanel.remove(this.editButton);
        this.buttonPanel.remove(this.removeButton);
        this.buttonPanel.remove(this.clearButton);
        this.buttonPanel.remove(this.exportCSVButton);
        this.buttonFlag[button_const] = isVisible;
        int i = 0;
        while (i < 5) {
            if (this.buttonFlag[i]) {
                if (i == 0) {
                    this.buttonPanel.add(this.newAlgebraicRuleButton);
                    this.buttonPanel.add(this.newAssignmentRuleButton);
                    this.buttonPanel.add(this.newRateRuleButton);
                } else if (i == 1) {
                    this.buttonPanel.add(this.editButton);
                } else if (i == 2) {
                    this.buttonPanel.add(this.removeButton);
                } else if (i == 3) {
                    this.buttonPanel.add(this.clearButton);
                }
            } else if (i == 4) {
                this.buttonPanel.add(this.exportCSVButton);
            }
            ++i;
        }
        this.validate();
        this.repaint();
    }

    @Override
    protected void changeButtonsEnability() {
        this.newAlgebraicRuleButton.setEnabled(false);
        this.newAssignmentRuleButton.setEnabled(false);
        this.newRateRuleButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.exportCSVButton.setEnabled(false);
        if (this.sbaseList == null) {
            return;
        }
        if (this.elementDlg != null) {
            this.newAlgebraicRuleButton.setEnabled(true);
            this.newAssignmentRuleButton.setEnabled(true);
            this.newRateRuleButton.setEnabled(true);
            this.exportCSVButton.setEnabled(true);
        }
        if (this.sbaseList.size() > 0L) {
            this.clearButton.setEnabled(true);
            int[] index = this.table.getSelectedRows();
            if (index.length > 0) {
                this.removeButton.setEnabled(true);
                if (this.elementDlg != null && index.length == 1) {
                    this.editButton.setEnabled(true);
                }
            }
        }
    }

    @Override
    protected void newButton_actionPerformed(ActionEvent e) {
        if (this.sbaseList == null || this.elementDlg == null) {
            return;
        }
        Object obj = e.getSource();
        if (obj == this.newAlgebraicRuleButton) {
            ((RuleDialog)this.elementDlg).setMode(0);
        } else if (obj == this.newAssignmentRuleButton) {
            ((RuleDialog)this.elementDlg).setMode(1);
        } else if (obj == this.newRateRuleButton) {
            ((RuleDialog)this.elementDlg).setMode(2);
        }
        this.table.clearSelection();
        this.elementDlg.setNewObject();
        this.elementDlg.updateDialog();
        this.showElementDialog();
    }

    public static String[] getRuleListPanelNames() {
        return new String[]{"subtype", "math", "variable type", "variable"};
    }

    @Override
    protected void initTableModel(SBase sbase) {
        String[] columnNames = RuleListPanel.getRuleListPanelNames();
        int[] columnSizes = new int[]{80, 300, 80, 70};
        this.listTableModel = new SBaseListPanel.MyTableModel(this, columnNames);
        this.table.setModel(this.listTableModel);
        this.table.getTableHeader().addMouseListener(new ListPanel.TableMouseListener());
        try {
            int dialog_witdh = 0;
            int i = 0;
            while (i < columnSizes.length) {
                TableColumn column = this.table.getColumnModel().getColumn(i);
                column.setPreferredWidth(columnSizes[i]);
                dialog_witdh += columnSizes[i];
                ++i;
            }
            this.setSize(dialog_witdh + 11, this.getSize().height);
            this.validate();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            DebugPrinter.println(1, e.getMessage());
        }
    }
}

