/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.MathEditPanel;
import jp.sbi.sbml.util.MathEditor;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.AlgebraicRule;
import org.sbml.libsbml.AssignmentRule;
import org.sbml.libsbml.RateRule;
import org.sbml.libsbml.Rule;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.libsbml;

public class RuleDialog
extends SBaseDialog
implements MathEditor {
    public static final int VARIABLE_NONE = 0;
    public static final int VARIABLE_SPECIES = 1;
    public static final int VARIABLE_COMPARTMENT = 2;
    public static final int VARIABLE_PARAMETER = 3;
    public static final int ALGEBRAICRULE_MODE = 0;
    public static final int ASSIGNMENTRULE_MODE = 1;
    public static final int RATERULE_MODE = 2;
    private JRadioButton algebraicRuleRadio;
    private JRadioButton assignmentRuleRadio;
    private JRadioButton rateRuleRadio;
    private JRadioButton speciesRadio;
    private JRadioButton compartmentRadio;
    private JRadioButton parameterRadio;
    private JComboBox variableComboBox;
    private JTextField mathTextField;
    private MathEditPanel mathPanel;
    public static final String STR_SPECIES = "Species";
    public static final String STR_COMPARTMENT = "Compartment";
    public static final String STR_PARAMETER = "Parameter";

    public RuleDialog() {
    }

    public RuleDialog(Dialog owner) {
        super(owner);
    }

    public RuleDialog(Frame owner) {
        super(owner);
    }

    public void setMode(int mode) {
        switch (mode) {
            case 0: {
                this.algebraicRuleRadio.setSelected(true);
                break;
            }
            case 1: {
                this.assignmentRuleRadio.setSelected(true);
                break;
            }
            case 2: {
                this.rateRuleRadio.setSelected(true);
                break;
            }
            default: {
                System.out.println("ERROR: RuleDialog.setMode() : wrong mode set");
            }
        }
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        int bakLabelWidth = this.LABEL_WIDTH;
        int bakButtonMargin = this.BUTTON_MARGIN;
        int bakTextWidth = this.TEXT_WIDTH;
        this.LABEL_WIDTH = 80;
        this.BUTTON_MARGIN += 22;
        this.TEXT_WIDTH = 400;
        this.BUTTON_WIDTH = 90;
        this.setLayoutConstants();
        int yline = this.VERTICAL_MARGIN;
        JLabel subtypeLabel = new JLabel("subtype");
        subtypeLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)subtypeLabel, null);
        this.algebraicRuleRadio = new JRadioButton("algebraic");
        this.algebraicRuleRadio.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT));
        this.algebraicRuleRadio.addActionListener(this.radioListener);
        this.mainPanel.add((Component)this.algebraicRuleRadio, null);
        this.assignmentRuleRadio = new JRadioButton("assignment");
        this.assignmentRuleRadio.addActionListener(this.radioListener);
        this.assignmentRuleRadio.setBounds(new Rectangle(this.TEXT_POSITION_X + this.BUTTON_WIDTH + this.BUTTON_MARGIN, yline, this.BUTTON_WIDTH + 30, this.LINE_HEIGHT));
        this.mainPanel.add((Component)this.assignmentRuleRadio, null);
        this.rateRuleRadio = new JRadioButton("rate");
        this.rateRuleRadio.setBounds(new Rectangle(this.TEXT_POSITION_X + 2 * this.BUTTON_WIDTH + 2 * this.BUTTON_MARGIN, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT));
        this.rateRuleRadio.addActionListener(this.radioListener);
        this.mainPanel.add((Component)this.rateRuleRadio, null);
        ButtonGroup subtypeButtonGroup = new ButtonGroup();
        subtypeButtonGroup.add(this.algebraicRuleRadio);
        subtypeButtonGroup.add(this.assignmentRuleRadio);
        subtypeButtonGroup.add(this.rateRuleRadio);
        this.algebraicRuleRadio.setSelected(true);
        JLabel mathLabel = new JLabel("math");
        mathLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)mathLabel, null);
        this.mathPanel = new MathEditPanel();
        int mpheight = this.mathPanel.createUI(this.TEXT_WIDTH, this.LINE_HEIGHT, this.BASELINE_SKIP);
        this.mathPanel.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, mpheight));
        this.mathTextField = this.mathPanel.getTextField();
        this.mathTextField.setEditable(true);
        this.mathTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.mathPanel, null);
        JLabel variableTypeLabel = new JLabel("variable type");
        variableTypeLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += mpheight + this.BASELINE_SKIP - this.LINE_HEIGHT, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)variableTypeLabel, null);
        this.speciesRadio = new JRadioButton(STR_SPECIES);
        this.speciesRadio.addActionListener(new MyRuleRadioButtonListener());
        this.speciesRadio.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT));
        this.speciesRadio.addActionListener(this.radioListener);
        this.mainPanel.add((Component)this.speciesRadio, null);
        this.compartmentRadio = new JRadioButton(STR_COMPARTMENT);
        this.compartmentRadio.addActionListener(new MyRuleRadioButtonListener());
        this.compartmentRadio.addActionListener(this.radioListener);
        this.compartmentRadio.setBounds(new Rectangle(this.TEXT_POSITION_X + this.BUTTON_WIDTH + this.BUTTON_MARGIN, yline, this.BUTTON_WIDTH + 30, this.LINE_HEIGHT));
        this.mainPanel.add((Component)this.compartmentRadio, null);
        this.parameterRadio = new JRadioButton(STR_PARAMETER);
        this.parameterRadio.addActionListener(new MyRuleRadioButtonListener());
        this.parameterRadio.setBounds(new Rectangle(this.TEXT_POSITION_X + 2 * this.BUTTON_WIDTH + 2 * this.BUTTON_MARGIN, yline, this.BUTTON_WIDTH + 30, this.LINE_HEIGHT));
        this.parameterRadio.addActionListener(this.radioListener);
        this.mainPanel.add((Component)this.parameterRadio, null);
        ButtonGroup variableTypeButtonGroup = new ButtonGroup();
        variableTypeButtonGroup.add(this.speciesRadio);
        variableTypeButtonGroup.add(this.compartmentRadio);
        variableTypeButtonGroup.add(this.parameterRadio);
        this.speciesRadio.setSelected(true);
        JLabel variableLabel = new JLabel("variable");
        variableLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)variableLabel, null);
        this.variableComboBox = new JComboBox();
        this.variableComboBox.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.variableComboBox.setEditable(false);
        this.variableComboBox.addActionListener(this.radioListener);
        this.mainPanel.add((Component)this.variableComboBox, null);
        this.LABEL_WIDTH = bakLabelWidth;
        this.BUTTON_MARGIN = bakButtonMargin;
        this.TEXT_WIDTH = bakTextWidth;
        this.BUTTON_POSITION_Y = yline += this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        if (this.algebraicRuleRadio.isSelected()) {
            return new AlgebraicRule();
        }
        if (this.assignmentRuleRadio.isSelected()) {
            return new AssignmentRule();
        }
        return new RateRule();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            this.speciesRadio.setSelected(true);
            this.resetVariableComboBox();
            return;
        }
        if (sbase instanceof AlgebraicRule) {
            AlgebraicRule ar = (AlgebraicRule)sbase;
            this.algebraicRuleRadio.setSelected(true);
            String math = ar.getFormula();
            this.mathTextField.setText(math);
            this.mathTextField.setCaretPosition(math.length());
            this.speciesRadio.setEnabled(false);
            this.compartmentRadio.setEnabled(false);
            this.parameterRadio.setEnabled(false);
            this.variableComboBox.removeAllItems();
            this.variableComboBox.setEnabled(false);
        } else if (sbase instanceof AssignmentRule) {
            AssignmentRule as = (AssignmentRule)sbase;
            this.assignmentRuleRadio.setSelected(true);
            String math = as.getFormula();
            this.mathTextField.setText(math);
            this.mathTextField.setCaretPosition(math.length());
            this.speciesRadio.setEnabled(true);
            this.compartmentRadio.setEnabled(true);
            this.parameterRadio.setEnabled(true);
            String var = as.getVariable();
            String type = LibSBMLUtil.getRateRuleL1TypeString((Rule)as);
            if (type.equals(STR_SPECIES) || type.equals("")) {
                this.speciesRadio.setSelected(true);
            } else if (type.equals(STR_COMPARTMENT)) {
                this.compartmentRadio.setSelected(true);
            } else if (type.equals(STR_PARAMETER)) {
                this.parameterRadio.setSelected(true);
            }
            this.resetVariableComboBox();
            this.variableComboBox.setSelectedItem(var);
            if (type.equals(STR_SPECIES) && this.variableComboBox.getSelectedIndex() == -1) {
                this.isEdited = true;
                this.updateApproveLabel();
            }
        } else if (sbase instanceof RateRule) {
            RateRule rr = (RateRule)sbase;
            this.rateRuleRadio.setSelected(true);
            String math = rr.getFormula();
            this.mathTextField.setText(math);
            this.mathTextField.setCaretPosition(math.length());
            this.speciesRadio.setEnabled(true);
            this.compartmentRadio.setEnabled(true);
            this.parameterRadio.setEnabled(true);
            String var = rr.getVariable();
            String type = LibSBMLUtil.getRateRuleL1TypeString((Rule)rr);
            if (type.equals(STR_SPECIES) || type.equals("")) {
                this.speciesRadio.setSelected(true);
            } else if (type.equals(STR_COMPARTMENT)) {
                this.compartmentRadio.setSelected(true);
            } else if (type.equals(STR_PARAMETER)) {
                this.parameterRadio.setSelected(true);
            }
            this.resetVariableComboBox();
            this.variableComboBox.setSelectedItem(var);
            if (type.equals(STR_SPECIES) && this.variableComboBox.getSelectedIndex() == -1) {
                this.isEdited = true;
                this.updateApproveLabel();
            }
        }
        this.mathPanel.clearSelectedItemText();
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        SBModel sbModel = null;
        try {
            sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            if (sbModel == null || sbModel.getModel() == null) {
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        if (sbase instanceof AlgebraicRule) {
            AlgebraicRule ar = (AlgebraicRule)sbase;
            String math = this.mathTextField.getText();
            String oldMath = new String(ar.getFormula());
            String newMath = new String(math);
            try {
                if (libsbml.parseFormula((String)math) == null) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new Exception("malformed math string");
            }
            if (LibSBMLUtil.haveConstantValueInMath(libsbml.parseFormula((String)math))) {
                throw new Exception(LibSBMLUtil.getHaveConstantValueInMathErroMessage("math"));
            }
            LibSBMLUtil.checkTheNumberOfArgumentsForFunctionDefinition(libsbml.parseFormula((String)math), sbModel.getModel(), null);
            ar.setFormula(math);
            LibSBMLUtil.changetoAstTimeNode(ar.getMath());
            if (!newMath.equals(oldMath)) {
                HashMap hashRuleNotes = sbModel.getHashRuleNotes();
                this.changeNotesforIdChange(hashRuleNotes, oldMath, newMath);
            }
        } else if (sbase instanceof AssignmentRule) {
            AssignmentRule as = (AssignmentRule)sbase;
            String math = this.mathTextField.getText();
            String oldMath = new String(as.getFormula());
            String newMath = new String(math);
            try {
                if (libsbml.parseFormula((String)math) == null) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new Exception("malformed math string");
            }
            if (LibSBMLUtil.haveConstantValueInMath(libsbml.parseFormula((String)math))) {
                throw new Exception(LibSBMLUtil.getHaveConstantValueInMathErroMessage("math"));
            }
            String var = (String)this.variableComboBox.getSelectedItem();
            try {
                SId.check(var);
            }
            catch (Exception e) {
                throw new Exception("malformed variable string");
            }
            LibSBMLUtil.checkTheNumberOfArgumentsForFunctionDefinition(libsbml.parseFormula((String)math), sbModel.getModel(), null);
            as.setFormula(math);
            LibSBMLUtil.changetoAstTimeNode(as.getMath());
            if (!newMath.equals(oldMath)) {
                HashMap hashRuleNotes = sbModel.getHashRuleNotes();
                this.changeNotesforIdChange(hashRuleNotes, oldMath, newMath);
            }
            if (this.speciesRadio.isSelected()) {
                as.setVariable(var);
                as.setL1TypeCode(24);
            } else if (this.compartmentRadio.isSelected()) {
                as.setVariable(var);
                as.setL1TypeCode(25);
            } else if (this.parameterRadio.isSelected()) {
                as.setVariable(var);
                as.setL1TypeCode(26);
            }
        } else if (sbase instanceof RateRule) {
            RateRule rr = (RateRule)sbase;
            String math = this.mathTextField.getText();
            String oldMath = new String(rr.getFormula());
            String newMath = new String(math);
            try {
                if (libsbml.parseFormula((String)math) == null) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new Exception("malformed math string");
            }
            if (LibSBMLUtil.haveConstantValueInMath(libsbml.parseFormula((String)math))) {
                throw new Exception(LibSBMLUtil.getHaveConstantValueInMathErroMessage("math"));
            }
            String var = (String)this.variableComboBox.getSelectedItem();
            try {
                SId.check(var);
            }
            catch (Exception e) {
                throw new Exception("malformed variable string");
            }
            LibSBMLUtil.checkTheNumberOfArgumentsForFunctionDefinition(libsbml.parseFormula((String)math), sbModel.getModel(), null);
            rr.setFormula(math);
            LibSBMLUtil.changetoAstTimeNode(rr.getMath());
            if (!newMath.equals(oldMath)) {
                HashMap hashRuleNotes = sbModel.getHashRuleNotes();
                this.changeNotesforIdChange(hashRuleNotes, oldMath, newMath);
            }
            if (this.speciesRadio.isSelected()) {
                rr.setVariable(var);
            } else if (this.compartmentRadio.isSelected()) {
                rr.setVariable(var);
            } else if (this.parameterRadio.isSelected()) {
                rr.setVariable(var);
            }
            if (this.speciesRadio.isSelected()) {
                rr.setL1TypeCode(24);
            } else if (this.compartmentRadio.isSelected()) {
                rr.setL1TypeCode(25);
            } else if (this.parameterRadio.isSelected()) {
                rr.setL1TypeCode(26);
            }
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.algebraicRuleRadio.setEnabled(false);
        this.assignmentRuleRadio.setEnabled(false);
        this.rateRuleRadio.setEnabled(false);
        this.speciesRadio.setEnabled(isEnabled);
        this.compartmentRadio.setEnabled(isEnabled);
        this.parameterRadio.setEnabled(isEnabled);
        this.variableComboBox.setEnabled(isEnabled);
        this.mathTextField.setEditable(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    @Override
    public MathEditPanel getMathEditPanel() {
        return this.mathPanel;
    }

    private void resetVariableComboBox() {
        try {
            this.variableComboBox.removeAllItems();
            if (this.algebraicRuleRadio.isSelected()) {
                return;
            }
            Vector list = new Vector();
            if (this.speciesRadio.isSelected()) {
                if (this.editingSBase != null) {
                    list = LibSBMLUtil.getIDListOfSpeciesOrCompartmentOrParameter(this.editingSBase, STR_SPECIES);
                } else if (this.algebraicRuleRadio.isSelected()) {
                    list = LibSBMLUtil.getIDListOfSpeciesOrCompartmentOrParameter((SBase)new AlgebraicRule(), STR_SPECIES);
                } else if (this.assignmentRuleRadio.isSelected()) {
                    list = LibSBMLUtil.getIDListOfSpeciesOrCompartmentOrParameter((SBase)new AssignmentRule(), STR_SPECIES);
                } else if (this.rateRuleRadio.isSelected()) {
                    list = LibSBMLUtil.getIDListOfSpeciesOrCompartmentOrParameter((SBase)new RateRule(), STR_SPECIES);
                }
            } else if (this.compartmentRadio.isSelected()) {
                list = LibSBMLUtil.getIDListOfSpeciesOrCompartmentOrParameter(this.editingSBase, STR_COMPARTMENT);
            } else if (this.parameterRadio.isSelected()) {
                list = LibSBMLUtil.getIDListOfSpeciesOrCompartmentOrParameter(this.editingSBase, STR_PARAMETER);
            }
            int i = 0;
            while (i < list.size()) {
                this.variableComboBox.addItem(list.get(i));
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateVariableComboBox(SBModel sbmodel, int actionCode, SBase otherChangedSBase) {
        if (sbmodel == null) {
            return;
        }
        if (sbmodel.getModel() == null) {
            return;
        }
        if (otherChangedSBase == null) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.variableComboBox == null) {
            return;
        }
        if (!this.variableComboBox.isEnabled()) {
            return;
        }
        String oldSelected = null;
        if (this.variableComboBox.getItemCount() > 0) {
            oldSelected = (String)this.variableComboBox.getSelectedItem();
        }
        if (otherChangedSBase instanceof Species) {
            Species sp;
            Species otherSp = (Species)otherChangedSBase;
            String newSelect = otherSp.getId();
            this.resetVariableComboBox();
            if (actionCode != 1 && actionCode == 2 && oldSelected != null && !"".equals(oldSelected) && (sp = sbmodel.getModel().getSpecies(oldSelected)) == null) {
                oldSelected = newSelect;
            }
            if (this.variableComboBox.getItemCount() <= 0) {
                return;
            }
            this.variableComboBox.setSelectedIndex(0);
            if (oldSelected != null && !"".equals(oldSelected)) {
                this.variableComboBox.setSelectedItem(oldSelected);
            }
        }
    }

    protected class MyRuleRadioButtonListener
    implements ActionListener {
        protected MyRuleRadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RuleDialog.this.resetVariableComboBox();
        }
    }
}

