/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Constructor;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.AnyInput;
import jp.sbi.sbml.util.KineticLawDialog;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ListPanel;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseDialogListener;
import jp.sbi.sbml.util.SBaseListDialogListener;
import jp.sbi.sbml.util.SBaseListPanel;
import jp.sbi.sbml.util.SpeciesReferenceDialog;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;

public class ReactionDialog
extends SBaseDialog {
    public static final int LIST_OF_REACTANTS = 0;
    public static final int LIST_OF_PRODUCTS = 1;
    public static final int LIST_OF_MODIFIERS = 2;
    public static final int SIZE_OF_LISTS = 3;
    public static final String REACTANTS = "Reactants";
    public static final String PRODUCTS = "Products";
    public static final String MODIFIERS = "Modifiers";
    private JTextField idTextField;
    private JTextField nameTextField;
    private JRadioButton reversibleRadio;
    private JRadioButton reversibleFalseRadio;
    private JRadioButton fastRadio;
    private JRadioButton fastFalseRadio;
    private JButton reactantListDlgButton;
    private JButton productListDlgButton;
    private JButton modifierListDlgButton;
    private JTextArea kineticLawElementsTextArea;
    private JButton kineticLawCreateButton;
    private JButton kineticLawDeleteButton;
    private JFrame frame;
    private JTabbedPane jTabbedPane = new JTabbedPane();
    private boolean[] isFirstShowing;
    private boolean isKineticLawFirstShowing = true;
    private boolean useKeyListenerToTextFields = false;
    private boolean useActionListenerToRadioButtons = false;
    SBaseListPanel[] listPanel = new SBaseListPanel[3];
    private SBaseDialog[] elementDialogs = new SBaseDialog[3];
    SBaseDialog kineticLawDialog;
    private MySBaseDialogListener elementDlgListener;
    private MyKeyListener myKeyListener;
    private static String[] dialogClassName = new String[]{"SpeciesReferenceDialog", "SpeciesReferenceDialog", "ModifierSpeciesReferenceDialog"};
    private static String[] ListName = new String[]{"listOfReactants", "listOfProducts", "listOfModifiers"};

    public int getSelectedRow(String type) {
        int index = 0;
        if (type.equals(REACTANTS)) {
            index = 0;
        } else if (type.equals(PRODUCTS)) {
            index = 1;
        }
        return this.listPanel[index].getSelectedRow();
    }

    public ReactionDialog() {
        this.initListDialogs();
        if (this.useKeyListenerToTextFields) {
            this.addListenerToTextFields();
        }
        this.initIsFirstShowing();
    }

    public ReactionDialog(Dialog owner) {
        super(owner);
        this.initListDialogs();
        if (this.useKeyListenerToTextFields) {
            this.addListenerToTextFields();
        }
        this.initIsFirstShowing();
    }

    public ReactionDialog(Frame owner) {
        super(owner);
        this.initListDialogs();
        if (this.useKeyListenerToTextFields) {
            this.addListenerToTextFields();
        }
        this.initIsFirstShowing();
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        JLabel idLabel = new JLabel("id");
        idLabel.setBounds(new Rectangle(10, 10, 60, 20));
        this.mainPanel.add((Component)idLabel, null);
        this.idTextField = new JTextField();
        this.idTextField.setBounds(new Rectangle(80, 10, 200, 20));
        this.idTextField.setEditable(true);
        this.idTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.idTextField, null);
        JLabel nameLabel = new JLabel("name");
        nameLabel.setBounds(new Rectangle(10, 34, 60, 20));
        this.mainPanel.add((Component)nameLabel, null);
        this.nameTextField = new JTextField();
        this.nameTextField.setBounds(new Rectangle(80, 34, 200, 20));
        this.nameTextField.setEditable(true);
        this.nameTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.nameTextField, null);
        JLabel reversibleLabel = new JLabel("reversible");
        reversibleLabel.setBounds(new Rectangle(10, 58, 120, 20));
        this.mainPanel.add((Component)reversibleLabel, null);
        this.reversibleRadio = new JRadioButton("true");
        this.reversibleRadio.setBounds(new Rectangle(80, 58, 60, 20));
        this.reversibleRadio.addActionListener(this.radioListener);
        this.mainPanel.add((Component)this.reversibleRadio, null);
        this.reversibleFalseRadio = new JRadioButton("false");
        this.reversibleFalseRadio.setBounds(new Rectangle(150, 58, 90, 20));
        this.reversibleFalseRadio.addActionListener(this.radioListener);
        this.mainPanel.add((Component)this.reversibleFalseRadio, null);
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.reversibleRadio);
        bg1.add(this.reversibleFalseRadio);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (ReactionDialog.this.reversibleRadio.hasFocus() || ReactionDialog.this.reversibleFalseRadio.hasFocus()) {
                    switch (e.getKeyCode()) {
                        case 39: {
                            ReactionDialog.this.reversibleFalseRadio.setSelected(true);
                            ReactionDialog.this.reversibleFalseRadio.grabFocus();
                            break;
                        }
                        case 37: {
                            ReactionDialog.this.reversibleRadio.setSelected(true);
                            ReactionDialog.this.reversibleRadio.grabFocus();
                        }
                    }
                }
            }
        });
        JLabel fastLabel = new JLabel("fast");
        fastLabel.setBounds(new Rectangle(10, 82, 120, 20));
        this.mainPanel.add((Component)fastLabel, null);
        this.fastRadio = new JRadioButton("true");
        this.fastRadio.setBounds(new Rectangle(80, 82, 60, 20));
        this.fastRadio.addActionListener(this.radioListener);
        this.mainPanel.add((Component)this.fastRadio, null);
        this.fastFalseRadio = new JRadioButton("false");
        this.fastFalseRadio.setBounds(new Rectangle(150, 82, 90, 20));
        this.fastFalseRadio.addActionListener(this.radioListener);
        this.mainPanel.add((Component)this.fastFalseRadio, null);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.fastRadio);
        bg2.add(this.fastFalseRadio);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (ReactionDialog.this.fastRadio.hasFocus() || ReactionDialog.this.fastFalseRadio.hasFocus()) {
                    switch (e.getKeyCode()) {
                        case 39: {
                            ReactionDialog.this.fastFalseRadio.setSelected(true);
                            ReactionDialog.this.fastFalseRadio.grabFocus();
                            break;
                        }
                        case 37: {
                            ReactionDialog.this.fastRadio.setSelected(true);
                            ReactionDialog.this.fastRadio.grabFocus();
                        }
                    }
                }
            }
        });
        JLabel kineticLawLabel = new JLabel("KineticLaw");
        kineticLawLabel.setBounds(new Rectangle(10, 300, 160, 20));
        this.mainPanel.add((Component)kineticLawLabel, null);
        this.kineticLawCreateButton = new JButton("Create");
        this.kineticLawCreateButton.setMnemonic(67);
        this.kineticLawCreateButton.setBounds(new Rectangle(180, 300, 100, 20));
        this.kineticLawCreateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReactionDialog.this.CreateButton_actionPerformed();
            }
        });
        this.kineticLawCreateButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ReactionDialog.this.rootPane.setDefaultButton(ReactionDialog.this.kineticLawCreateButton);
            }
        });
        this.mainPanel.add((Component)this.kineticLawCreateButton, null);
        this.kineticLawDeleteButton = new JButton("Delete"){

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.kineticLawElementsTextArea = new JTextArea(""){

            @Override
            public boolean isManagingFocus() {
                return false;
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.LABEL_WIDTH = 60;
        this.TEXT_WIDTH = 371;
        this.setLayoutConstants();
        this.BUTTON_POSITION_Y = 100 + 10 * this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new Reaction();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        Reaction reaction = (Reaction)sbase;
        String id = reaction.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        String name = reaction.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
        boolean b1 = reaction.getReversible();
        this.reversibleRadio.setSelected(b1);
        this.reversibleFalseRadio.setSelected(!b1);
        boolean b2 = reaction.getFast();
        this.fastRadio.setSelected(b2);
        this.fastFalseRadio.setSelected(!b2);
        int i = 0;
        while (i < 3) {
            this.listPanel[i].setParentSBase((SBase)reaction);
            ++i;
        }
        ((SpeciesReferenceDialog)this.elementDialogs[0]).setReaction(reaction);
        ((SpeciesReferenceDialog)this.elementDialogs[0]).setParentDialog(this);
        ((SpeciesReferenceDialog)this.elementDialogs[1]).setReaction(reaction);
        ((SpeciesReferenceDialog)this.elementDialogs[1]).setParentDialog(this);
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        Reaction reaction = (Reaction)sbase;
        String str = this.idTextField.getText();
        try {
            SId.check(str);
            reaction.setId(str);
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed id string");
        }
        str = this.nameTextField.getText();
        reaction.setName(str);
        boolean b1 = this.reversibleRadio.isSelected();
        reaction.setReversible(b1);
        boolean b2 = this.fastRadio.isSelected();
        reaction.setFast(b2);
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.idTextField.setEnabled(false);
        this.nameTextField.setEnabled(false);
        this.reversibleRadio.setEnabled(false);
        this.reversibleFalseRadio.setEnabled(false);
        this.fastRadio.setEnabled(isEnabled);
        this.fastFalseRadio.setEnabled(isEnabled);
        this.changeListDialogsEnablility(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
        int i = 0;
        while (i < 3) {
            this.listPanel[i].releaseAll();
            this.listPanel[i] = null;
            this.listPanel = null;
            ++i;
        }
        if (this.useKeyListenerToTextFields) {
            this.removeListenerFromTextFields();
        }
        if (this.kineticLawDialog != null) {
            this.kineticLawDialog.removeSBaseDialogListener(this.elementDlgListener);
            this.kineticLawDialog = null;
        }
    }

    @Override
    protected boolean hasChildListDialog() {
        return true;
    }

    @Override
    protected void setChildDialogMode(int mode) {
        int i = 0;
        while (i < 3) {
            this.listPanel[i].setEnabled(true);
            this.listPanel[i].setVisible(true);
            ++i;
        }
        if (this.kineticLawDialog != null) {
            this.kineticLawDialog.setChildDialogMode(1);
            if (mode == 1) {
                this.kineticLawDialog.setModal(true);
            } else {
                this.kineticLawDialog.setModal(false);
            }
        }
    }

    @Override
    protected void updateChildDialog() {
        int i = 0;
        while (i < 3) {
            SBaseListPanel listPnl = this.listPanel[i];
            if (listPnl != null) {
                listPnl.updateDialog();
            }
            ++i;
        }
        if (this.kineticLawDialog != null) {
            this.kineticLawDialog.updateDialog();
        }
        this.repaint();
    }

    public void updateKineticLawDialog() {
        if (this.kineticLawDialog.isShowing() && this.kineticLawDialog.getObject() != null) {
            ((KineticLawDialog)this.kineticLawDialog).setListPanels((KineticLaw)this.kineticLawDialog.getObject());
        }
    }

    private void initListDialogs() {
        int i = 0;
        while (i < 3) {
            block8: {
                SBaseDialog elementDialog;
                block7: {
                    this.listPanel[i] = new ListPanel();
                    this.listPanel[i].setName(dialogClassName[i]);
                    this.listPanel[i].setToolTipText(dialogClassName[i]);
                    this.listPanel[i].setMainWindowAccess(null);
                    elementDialog = null;
                    String dialogName = String.valueOf(this.getClass().getPackage().getName()) + "." + dialogClassName[i];
                    try {
                        Constructor<?> con = Class.forName(dialogName).getConstructor(Class.forName("java.awt.Frame"));
                        JFrame frameTemp = this.frame;
                        if (frameTemp == null) {
                            frameTemp = MainWindow.getLastInstance();
                        }
                        elementDialog = (SBaseDialog)con.newInstance(frameTemp);
                        if (i == 0) {
                            ((SpeciesReferenceDialog)elementDialog).setType(REACTANTS);
                            break block7;
                        }
                        if (i != 1) break block7;
                        ((SpeciesReferenceDialog)elementDialog).setType(PRODUCTS);
                    }
                    catch (Exception e) {
                        DebugPrinter.println(1, "SBMLPanelLists-initListDialogs-cannnot construct:" + dialogClassName[i] + " ,skip");
                        System.err.println(e.getMessage());
                        break block8;
                    }
                }
                if (elementDialog != null) {
                    elementDialog.setTitle(LibSBMLUtil.getElementClassName("Reaction", i));
                    this.listPanel[i].setElementDialog(elementDialog);
                    this.listPanel[i].setElementDialogMode(2);
                    this.elementDialogs[i] = elementDialog;
                }
                this.listPanel[i].setPreferredSize(new Dimension(420, 150));
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.jTabbedPane.add(ListName[i], this.listPanel[i]);
            this.jTabbedPane.setToolTipTextAt(this.jTabbedPane.getTabCount() - 1, this.listPanel[i].getToolTipText());
            ++i;
        }
        this.jTabbedPane.setBorder(BorderFactory.createEtchedBorder(1));
        this.jTabbedPane.setBounds(new Rectangle(10, 118, 440, 170));
        this.jTabbedPane.setSelectedIndex(0);
        this.mainPanel.add((Component)this.jTabbedPane, null);
        this.kineticLawDialog = new KineticLawDialog(this);
        this.kineticLawDialog.setTitle("KineticLaw");
        this.elementDlgListener = new MySBaseDialogListener();
        this.kineticLawDialog.addSBaseDialogListener(this.elementDlgListener);
        this.changeListDialogsEnablility(false);
    }

    private void changeListDialogsEnablility(boolean isEnabled) {
        int i = 0;
        while (i < 3) {
            if (!isEnabled) {
                this.listPanel[i].setSBaseList(null);
                this.listPanel[i].disableChildDialog();
            }
            ++i;
        }
        if (!isEnabled) {
            this.kineticLawDialog.setObject(null);
            this.kineticLawDialog.updateDialog();
        }
    }

    private void setListDialogs(Reaction reaction) {
        this.changeListDialogsEnablility(reaction != null);
        if (reaction == null) {
            return;
        }
        int i = 0;
        while (i < 3) {
            if (i == 0) {
                this.listPanel[i].setSBaseList((ListOf)reaction.getListOfReactants());
            } else if (i == 1) {
                this.listPanel[i].setSBaseList((ListOf)reaction.getListOfProducts());
            } else if (i == 2) {
                this.listPanel[i].setSBaseList((ListOf)reaction.getListOfModifiers());
            }
            ++i;
        }
        if (reaction.getKineticLaw() == null) {
            this.kineticLawDialog.setObject(null);
        } else {
            this.kineticLawDialog.setObject((SBase)reaction.getKineticLaw());
        }
        this.kineticLawDialog.updateDialog();
    }

    private void CreateButton_actionPerformed() {
        Reaction reaction = (Reaction)super.getObject();
        if (reaction.getKineticLaw() == null) {
            reaction.setKineticLaw((KineticLaw)this.kineticLawDialog.createInitialObject());
        }
        this.kineticLawDialog.setObject((SBase)reaction.getKineticLaw());
        ((KineticLawDialog)this.kineticLawDialog).updateDrawPanel();
        this.kineticLawDialog.updateDialog();
        this.changeButtonsState();
        this.showKineticLawDialog();
    }

    private void DeleteButton_actionPerformed() {
        ((Reaction)super.getObject()).unsetKineticLaw();
        this.changeButtonsState();
        this.kineticLawDialog.setObject(null);
        this.kineticLawDialog.updateDialog();
    }

    private void showKineticLawElements() {
        KineticLaw kineticLaw = ((Reaction)super.getObject()).getKineticLaw();
        this.kineticLawElementsTextArea.append("formula = " + kineticLaw.getFormula() + "\n");
        this.kineticLawElementsTextArea.append("timeUnits = " + kineticLaw.getTimeUnits() + "\n");
        this.kineticLawElementsTextArea.append("substanceUnits = " + kineticLaw.getSubstanceUnits());
    }

    private void addListenerToTextFields() {
        AnyInput annotationInput;
        this.myKeyListener = new MyKeyListener();
        this.idTextField.addKeyListener(this.myKeyListener);
        this.nameTextField.addKeyListener(this.myKeyListener);
        AnyInput notesInput = super.getAnyInput(1001);
        if (notesInput != null) {
            notesInput.getComponent().addKeyListener(this.myKeyListener);
        }
        if ((annotationInput = super.getAnyInput(1002)) != null) {
            annotationInput.getComponent().addKeyListener(this.myKeyListener);
        }
    }

    private void removeListenerFromTextFields() {
        AnyInput annotationInput;
        this.idTextField.removeKeyListener(this.myKeyListener);
        this.nameTextField.removeKeyListener(this.myKeyListener);
        AnyInput notesInput = super.getAnyInput(1001);
        if (notesInput != null) {
            notesInput.getComponent().removeKeyListener(this.myKeyListener);
        }
        if ((annotationInput = super.getAnyInput(1002)) != null) {
            annotationInput.getComponent().removeKeyListener(this.myKeyListener);
        }
        this.myKeyListener = null;
    }

    private void changeButtonsState() {
        this.kineticLawCreateButton.setEnabled(false);
        this.kineticLawDeleteButton.setEnabled(false);
        this.kineticLawCreateButton.setText("Create");
        this.kineticLawElementsTextArea.setText("");
        this.kineticLawCreateButton.setMnemonic(67);
        Reaction reaction = (Reaction)super.getObject();
        if (reaction == null) {
            return;
        }
        if (reaction.getKineticLaw() == null) {
            this.kineticLawCreateButton.setEnabled(true);
        } else {
            this.showKineticLawElements();
            this.kineticLawCreateButton.setEnabled(true);
            this.kineticLawDeleteButton.setEnabled(true);
            this.kineticLawCreateButton.setText("Edit");
            this.kineticLawCreateButton.setMnemonic(69);
        }
    }

    private void radioButton_actionPerformed() {
        try {
            this.updateObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setListDialogPosition(int i) {
    }

    private void initIsFirstShowing() {
        this.isFirstShowing = new boolean[3];
        int i = 0;
        while (i < 3) {
            this.isFirstShowing[i] = true;
            ++i;
        }
    }

    private void setKineticLawDialogPosition() {
        if (this.kineticLawDialog != null && this.isKineticLawFirstShowing) {
            Point p = this.getLocation();
            Dimension mysize = this.getSize();
            Dimension dlgsize = this.kineticLawDialog.getSize();
            int x = p.x + (mysize.width - dlgsize.width) / 2;
            int y = p.y + (mysize.height - dlgsize.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.kineticLawDialog.setLocation(x, y);
            this.isKineticLawFirstShowing = false;
        }
    }

    private void showListDialog(int i) {
        this.setListDialogPosition(i);
        this.listPanel[i].show();
    }

    private void showKineticLawDialog() {
        this.setKineticLawDialogPosition();
        this.kineticLawDialog.show();
    }

    public void showKineticLawDialog(SBase sbase) {
        this.CreateButton_actionPerformed();
    }

    @Override
    public void setObject(SBase sbase) {
        super.setObject(sbase);
        this.setListDialogs((Reaction)sbase);
        this.changeButtonsState();
    }

    @Override
    public void setNewObject() {
        super.setNewObject();
        this.setListDialogs((Reaction)super.getObject());
        this.changeButtonsState();
    }

    public SBaseListPanel getSBaseListPanel(int list_const) {
        if (list_const < 0 || list_const >= 3) {
            return null;
        }
        return this.listPanel[list_const];
    }

    public SBaseDialog getKineticLawDialog() {
        return this.kineticLawDialog;
    }

    public SBaseDialog getChildDialog(String dlgName) {
        if (this.elementDialogs == null || this.elementDialogs.length != 3) {
            return null;
        }
        if (REACTANTS.equals(dlgName)) {
            return this.elementDialogs[0];
        }
        if (PRODUCTS.equals(dlgName)) {
            return this.elementDialogs[1];
        }
        if (MODIFIERS.equals(dlgName)) {
            return this.elementDialogs[2];
        }
        return null;
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            try {
                ReactionDialog.this.updateObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class MyListListener
    implements SBaseListDialogListener {
        String listName = "";
        int listNumber;

        public MyListListener(int i) {
            this.listName = LibSBMLUtil.getListTagName("Reaction", i);
            this.listNumber = i;
        }

        @Override
        public void elementAdded(SBase sbase) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementAdded()");
            try {
                ReactionDialog.this.updateObject();
            }
            catch (Exception e) {
                DebugPrinter.println(1, "ReactionDialog.MyListListener.elementAdded: " + this.listName + " failed.");
            }
        }

        @Override
        public void elementUpdated(SBase sbase, String[] oldValues) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementUpdated()");
            try {
                ReactionDialog.this.updateObject();
            }
            catch (Exception e) {
                DebugPrinter.println(1, "ReactionDialog.MyListListener.elementUpdated: " + this.listName + " failed.");
            }
        }

        @Override
        public void elementsRemoved(SBase[] sbases, int[] index) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementsRemoved()" + sbases.length);
            try {
                ReactionDialog.this.updateObject();
            }
            catch (Exception e) {
                DebugPrinter.println(1, "ReactionDialog.MyListListener.elementsRemoved: " + this.listName + " failed.");
            }
        }

        @Override
        public void elementsSelected(SBase[] sbases) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementsSelected()" + sbases.length);
        }

        @Override
        public void elementsDeselected() {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementsDeselected()");
        }

        @Override
        public void dialogClosed() {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":dialogClosed()");
            ReactionDialog.this.listPanel[this.listNumber].setVisible(false);
        }

        @Override
        public void elementMousePressed(SBase sb) {
        }
    }

    private class MySBaseDialogListener
    implements SBaseDialogListener {
        private MySBaseDialogListener() {
        }

        @Override
        public void objectCreated(SBase sbase) {
            try {
                ReactionDialog.this.updateObject();
            }
            catch (Exception e) {
                DebugPrinter.println(1, "ReactionDialog.MySBaseDialogListener.objectCreated failed.");
            }
        }

        @Override
        public void objectUpdated(SBase sbase, String[] oldValues) {
            if (sbase == null) {
                return;
            }
            ReactionDialog.this.changeButtonsState();
            if (ReactionDialog.this.kineticLawDialog.isModal()) {
                ReactionDialog.this.kineticLawDialog.setVisible(false);
            }
            try {
                ReactionDialog.this.updateObject();
            }
            catch (Exception e) {
                DebugPrinter.println(1, "ReactionDialog.MySBaseDialogListener.objectUpdated failed.");
            }
        }

        @Override
        public void dialogCanceled(SBase sbase) {
            ReactionDialog.this.kineticLawDialog.setVisible(false);
        }
    }
}

