/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.sbml.util.InnerSettingPanel;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class PopupSettingDialog
extends JDialog {
    private static PopupSettingDialog instance = null;
    private JButton buttonOK;
    private JButton buttonClose;
    private InnerSettingPanel speciesPanel;
    private InnerSettingPanel compartmentPanel;
    private InnerSettingPanel reactionPanel;
    private JTabbedPane tab;
    protected static final String[] listPanel = new String[]{"Species", "Reactions", "Compartments"};

    private PopupSettingDialog() {
        super(MainWindow.getLastInstance());
        this.setModal(true);
        this.init();
    }

    public static PopupSettingDialog getInstance() {
        if (instance == null) {
            instance = new PopupSettingDialog();
        }
        return instance;
    }

    private void init() {
        this.setTitle("Popup Setting");
        this.setSize(260, 400);
        this.getContentPane().setLayout(new BorderLayout());
        this.setResizable(false);
        this.createCenterPanel();
        this.createSouthPanel();
    }

    private void createCenterPanel() {
        this.speciesPanel = new InnerSettingPanel(listPanel[0]);
        this.reactionPanel = new InnerSettingPanel(listPanel[1]);
        this.compartmentPanel = new InnerSettingPanel(listPanel[2]);
        this.tab = new JTabbedPane();
        this.tab.add(this.speciesPanel);
        this.tab.add(this.reactionPanel);
        this.tab.add(this.compartmentPanel);
        this.getContentPane().add((Component)this.tab, "Center");
    }

    private void createSouthPanel() {
        JPanel southPanel = new JPanel();
        JPanel innerSouthPanel = new JPanel();
        this.buttonOK = new JButton("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PopupSettingDialog.this.buttonOK_actionPerformed(arg0);
            }
        });
        this.buttonClose = new JButton("Close");
        this.buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PopupSettingDialog.this.buttonClose_actionPerformed(arg0);
            }
        });
        innerSouthPanel.add(this.buttonOK);
        innerSouthPanel.add(this.buttonClose);
        southPanel.add((Component)innerSouthPanel, "Center");
        this.getContentPane().add((Component)southPanel, "South");
    }

    private void buttonOK_actionPerformed(ActionEvent arg0) {
        this.setVisible(false);
    }

    private void buttonClose_actionPerformed(ActionEvent arg0) {
        this.setVisible(false);
    }

    public static String getPopupString(SBase sbase) {
        PopupSettingDialog d = PopupSettingDialog.getInstance();
        String s = "";
        InnerSettingPanel panel = null;
        if (sbase instanceof Species) {
            panel = d.getSpeciesPanel();
        } else if (sbase instanceof Reaction) {
            panel = d.getReactionPanel();
        } else if (sbase instanceof Compartment) {
            panel = d.getCompartmentPanel();
        }
        s = panel.getSelectedRadioButtonString(sbase);
        return s;
    }

    private InnerSettingPanel getSpeciesPanel() {
        return this.speciesPanel;
    }

    private InnerSettingPanel getCompartmentPanel() {
        return this.compartmentPanel;
    }

    private InnerSettingPanel getReactionPanel() {
        return this.reactionPanel;
    }
}

