/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.FileDialog;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFrame;

public class PoliteFileDialog {
    public static String getSelectedFilePath(String title, final String extension, int purpose) {
        String path = null;
        String sFile = null;
        FileDialog fileDialog = new FileDialog(new JFrame());
        fileDialog.setTitle(title);
        if (System.getProperty("os.name").indexOf("Windows") >= 0) {
            fileDialog.setFile(extension);
        }
        fileDialog.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        });
        fileDialog.setMode(purpose);
        fileDialog.setModal(true);
        fileDialog.setVisible(true);
        sFile = fileDialog.getFile();
        if (sFile == null) {
            return null;
        }
        if (sFile.equalsIgnoreCase(extension)) {
            return null;
        }
        String dir = fileDialog.getDirectory() != null ? fileDialog.getDirectory() : "";
        path = PoliteFileDialog.getSuffix(sFile).equalsIgnoreCase(PoliteFileDialog.getSuffix(extension)) ? String.valueOf(dir) + sFile : String.valueOf(dir) + sFile + extension;
        return path;
    }

    public static String getSuffix(String fileName) {
        if (fileName == null) {
            return null;
        }
        int point = fileName.lastIndexOf(".");
        if (point != -1) {
            return fileName.substring(point + 1);
        }
        return fileName;
    }

    public static String getPrefix(String fileName) {
        if (fileName == null) {
            return null;
        }
        int point = fileName.lastIndexOf(".");
        if (point != -1) {
            return fileName.substring(0, point);
        }
        return fileName;
    }

    public static void main(String[] args) {
        String s = PoliteFileDialog.getSelectedFilePath("test", ".xml", 1);
        System.out.println(s);
        System.exit(0);
    }
}

