/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ListPanel;
import jp.sbi.sbml.util.SBaseListPanel;
import jp.sbi.sbml.util.SBaseListPanelListener;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;

public class ParameterListPanel
extends ListPanel {
    private ListOf sorterSBaseList = null;

    @Override
    public SBase[] getSelectedElements() {
        if (this.sbaseList == null) {
            return new SBase[0];
        }
        if (this.sorterSBaseList == null) {
            return new SBase[0];
        }
        int[] cnt = this.table.getSelectedRows();
        Vector<SBase> temp = new Vector<SBase>();
        int i = 0;
        while (i < cnt.length) {
            SBase sb = this.sorterSBaseList.get((long)cnt[i]);
            if (this.isInSBaseList(sb)) {
                temp.add(sb);
            }
            ++i;
        }
        SBase[] array = new SBase[temp.size()];
        int i2 = 0;
        while (i2 < temp.size()) {
            array[i2] = (SBase)temp.elementAt(i2);
            ++i2;
        }
        return array;
    }

    @Override
    protected void table_mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        if (e.getClickCount() == 2) {
            int pressedRow;
            if (this.editButton.isEnabled() && (pressedRow = this.table.rowAtPoint(e.getPoint())) >= 0 && (long)pressedRow < this.sorterSBaseList.size() && this.isInSBaseList(this.sorterSBaseList.get((long)pressedRow))) {
                this.editButton_actionPerformed();
            }
        } else {
            SBase[] selected = this.getSelectedElements();
            if (selected.length == 0) {
                Vector list = (Vector)this.listeners.clone();
                int i = 0;
                while (i < list.size()) {
                    SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i);
                    listener.elementsDeselectedByList();
                    ++i;
                }
            }
        }
    }

    @Override
    protected void tableMousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        int pressedRow = this.table.rowAtPoint(e.getPoint());
        if (pressedRow >= 0 && (long)pressedRow < this.sorterSBaseList.size()) {
            SBase sb = this.sorterSBaseList.get((long)pressedRow);
            SBase[] selected = this.getSelectedElements();
            if (selected.length == 0) {
                Vector list = (Vector)this.listeners.clone();
                int i = 0;
                while (i < list.size()) {
                    SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i);
                    listener.elementsDeselectedByList();
                    ++i;
                }
                return;
            }
            Vector list = (Vector)this.listeners.clone();
            int i = 0;
            while (i < list.size()) {
                SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i);
                listener.elementMousePressed(sb);
                ++i;
            }
        }
    }

    @Override
    protected void initTableModel(SBase sbase) {
        if (sbase == null) {
            return;
        }
        String[] columnNames = LibSBMLUtil.fieldShortNames(sbase);
        int[] columnSizes = LibSBMLUtil.fieldColumnSizes(sbase);
        this.listTableModel = new MyTableModel(columnNames);
        this.table.setModel(this.listTableModel);
        this.table.getTableHeader().addMouseListener(new TableMouseListener());
        try {
            int dialog_witdh = 0;
            int i = 0;
            while (i < columnSizes.length) {
                TableColumn column = this.table.getColumnModel().getColumn(i);
                column.setPreferredWidth(columnSizes[i]);
                dialog_witdh += columnSizes[i];
                ++i;
            }
            this.setSize(dialog_witdh + 11, this.getSize().height);
            this.validate();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            DebugPrinter.println(1, e.getMessage());
        }
    }

    private boolean isInSBaseList(SBase sbase) {
        if (!(sbase instanceof Parameter)) {
            return false;
        }
        if (this.sbaseList == null) {
            return false;
        }
        Parameter p = (Parameter)sbase;
        if (p.getId() == null || "".equals(p.getId())) {
            return false;
        }
        int size = (int)this.sbaseList.size();
        String newIDforsbaseList = LibSBMLUtil.getHashKey(p, p.getId());
        int i = 0;
        while (i < size) {
            Parameter parameterfromsbaseList = (Parameter)this.sbaseList.get((long)i);
            String newIDforsorterSBaseList = LibSBMLUtil.getHashKey(parameterfromsbaseList, parameterfromsbaseList.getId());
            if (newIDforsbaseList.equals(newIDforsorterSBaseList)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public SBase getLastSelectedElement() {
        if (this.sorterSBaseList == null) {
            return null;
        }
        int i = this.table.getSelectedRow();
        if (this.isInSBaseList(this.sorterSBaseList.get((long)i))) {
            return this.sorterSBaseList.get((long)i);
        }
        return null;
    }

    @Override
    public void setSBaseList(ListOf sbaseList) {
        this.sbaseList = sbaseList;
        if (sbaseList != null) {
            Model model = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel();
            ListOfReactions reactions = model.getListOfReactions();
            ((MyTableModel)this.listTableModel).setListOfReactions((ListOf)reactions);
        } else {
            ((MyTableModel)this.listTableModel).setListOfReactions(null);
        }
        if (this.elementDlg != null) {
            this.elementDlg.setNewObject();
            this.elementDlg.updateDialog();
        }
        this.updateDialog();
    }

    @Override
    public void updateDialog() {
        if (this.listTableModel == null) {
            return;
        }
        if (this.sbaseList != null) {
            Model model = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel();
            ListOfReactions reactions = model.getListOfReactions();
            ((MyTableModel)this.listTableModel).setListOfReactions((ListOf)reactions);
        } else {
            ((MyTableModel)this.listTableModel).setListOfReactions(null);
        }
        this.listTableModel.fireTableDataChanged();
        this.changeButtonsEnability();
        if (this.isShowing()) {
            this.repaint();
        }
        this.updateChildDialog();
    }

    @Override
    public void valueSettedToCell(Object settedvalue, int rowIndex, int columnIndex) {
        try {
            try {
                this.bCallMeInDoubleClickingEdited = true;
                super.valueSettedToCell(settedvalue, rowIndex, columnIndex);
            }
            catch (Exception exception) {
                this.bCallMeInDoubleClickingEdited = false;
            }
        }
        finally {
            this.bCallMeInDoubleClickingEdited = false;
        }
    }

    public void SelectionChangedforKineticLawParameter() {
        try {
            SBModel model = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            int[] cnt = this.table.getSelectedRows();
            if (cnt == null || cnt.length > 1) {
                return;
            }
            if (cnt.length == 0) {
                model.panelchange(null, false);
                return;
            }
            SBase sbase = this.sorterSBaseList.get((long)cnt[0]);
            if (!(sbase instanceof Parameter)) {
                return;
            }
            Parameter p = (Parameter)sbase;
            if (p.getId() == null || "".equals(p.getId())) {
                return;
            }
            if (this.sbaseList == null || this.sbaseList.size() == 0L) {
                return;
            }
            String newIDforsbaseList = LibSBMLUtil.getHashKey(p, p.getId());
            boolean isLocal = true;
            int size = (int)this.sbaseList.size();
            int n = 0;
            while (n < size) {
                Parameter parameterfromsbaseList = (Parameter)this.sbaseList.get((long)n);
                String newIDforsorterSBaseList = LibSBMLUtil.getHashKey(parameterfromsbaseList, parameterfromsbaseList.getId());
                if (newIDforsbaseList.equals(newIDforsorterSBaseList)) {
                    isLocal = false;
                    break;
                }
                ++n;
            }
            if (isLocal) {
                SBase[] sbases = new SBase[]{sbase};
                model.setPanelSelectedSbase(sbases);
                MainWindow.getLastInstance().componentSelectionChanged();
                model.setPanelSelectedSbase(null);
            }
        }
        catch (Exception myErr) {
            return;
        }
    }

    public int sizeOfSorterSBaseList() {
        if (this.sorterSBaseList == null) {
            return 0;
        }
        return (int)this.sorterSBaseList.size();
    }

    public ListOf getSorterSBaseList() {
        return this.sorterSBaseList;
    }

    @Override
    public void doChangeTabbedPane(SBModel sbModel) {
        if (sbModel != null && this.sbaseList instanceof ListOfParameters) {
            if (this.getSelectedElements() != null && this.getSelectedElements().length == 1) {
                sbModel.setPanelSelectedSbase(this.getSelectedElements());
                MainWindow.getLastInstance().componentSelectionChanged();
                sbModel.setPanelSelectedSbase(null);
            } else if (this.table.getSelectedRows() != null && this.table.getSelectedRows().length == 1) {
                int[] cnt = this.table.getSelectedRows();
                if (cnt == null || cnt.length > 1) {
                    return;
                }
                SBase sbase = this.sorterSBaseList.get((long)cnt[0]);
                SBase[] sbases = new SBase[]{sbase};
                sbModel.setPanelSelectedSbase(sbases);
                MainWindow.getLastInstance().componentSelectionChanged();
                sbModel.setPanelSelectedSbase(null);
            } else {
                sbModel.panelchange(null, true);
            }
        }
    }

    protected class MyTableModel
    extends SBaseListPanel.MyTableModel {
        private ListOf listOfReactions;
        private int[][] rowMap;

        MyTableModel(String[] columnNames) {
            super(ParameterListPanel.this, columnNames);
            this.listOfReactions = null;
            this.rowMap = null;
            this.setSorterSBaseList();
        }

        void setListOfReactions(ListOf list) {
            this.listOfReactions = list;
            int reactions = 0;
            if (this.listOfReactions != null) {
                reactions = (int)this.listOfReactions.size();
            }
            int[] rows = new int[reactions];
            int rowsum = 0;
            int r = 0;
            while (r < reactions) {
                ListOfParameters localParameters;
                Reaction reaction = (Reaction)this.listOfReactions.get((long)r);
                KineticLaw sb = reaction.getKineticLaw();
                rows[r] = sb == null ? 0 : ((localParameters = sb.getListOfParameters()) == null ? 0 : (int)localParameters.size());
                rowsum += rows[r];
                ++r;
            }
            this.rowMap = new int[rowsum][2];
            int row = 0;
            int r2 = 0;
            while (r2 < reactions) {
                int s = 0;
                while (s < rows[r2]) {
                    this.rowMap[row][0] = r2;
                    this.rowMap[row][1] = s++;
                    ++row;
                }
                ++r2;
            }
            this.setSorterSBaseList();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return LibSBMLUtil.getListOfValueAt(ParameterListPanel.this.sorterSBaseList, row, col);
        }

        private void setSorterSBaseList() {
            int i;
            if (ParameterListPanel.this.sorterSBaseList != null) {
                ParameterListPanel.this.sorterSBaseList = null;
            }
            ParameterListPanel.this.sorterSBaseList = new ListOf();
            if (ParameterListPanel.this.sbaseList != null) {
                i = 0;
                while ((long)i < ParameterListPanel.this.sbaseList.size()) {
                    ParameterListPanel.this.sorterSBaseList.append((SBase)((Parameter)ParameterListPanel.this.sbaseList.get((long)i)));
                    ++i;
                }
            }
            if (this.rowMap != null) {
                i = 0;
                while (i < this.rowMap.length) {
                    Reaction r = (Reaction)this.listOfReactions.get((long)this.rowMap[i][0]);
                    ListOfParameters localparams = r.getKineticLaw().getListOfParameters();
                    ParameterListPanel.this.sorterSBaseList.append((SBase)((Parameter)localparams.get((long)this.rowMap[i][1])));
                    ++i;
                }
            }
        }

        @Override
        public int getRowCount() {
            int rowcount = 0;
            if (ParameterListPanel.this.sbaseList != null) {
                rowcount = (int)((long)rowcount + ParameterListPanel.this.sbaseList.size());
            }
            if (this.rowMap != null) {
                rowcount += this.rowMap.length;
            }
            return rowcount;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (ParameterListPanel.this.isDialogVisiable) {
                return false;
            }
            if (ParameterListPanel.this.editable != null) {
                String scope = (String)ParameterListPanel.this.table.getValueAt(row, 0);
                if (scope.startsWith("global")) {
                    return ParameterListPanel.this.editable[column];
                }
                if (scope.startsWith("local")) {
                    return false;
                }
            }
            return false;
        }
    }

    protected class TableMouseListener
    extends ListPanel.TableMouseListener {
        protected TableMouseListener() {
        }

        @Override
        protected void sort(ListOf originalList, SBModel sbModel, String panelName, String colName, boolean isRestoreSelectedRows) {
            if (!ParameterListPanel.this.bCanRespond) {
                return;
            }
            try {
                String[] selectedIds = this.getSelectedIdsBackup(ParameterListPanel.this.sorterSBaseList);
                ListSelectionModel selectedModel = ParameterListPanel.this.table.getSelectionModel();
                super.sort(ParameterListPanel.this.sorterSBaseList, sbModel, panelName, colName, false);
                this.restoreSelectedRows(ParameterListPanel.this.sorterSBaseList, selectedModel, selectedIds);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

