/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.util.KineticLawDialog;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ListPanel;
import jp.sbi.sbml.util.ReactionDialog;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.ListOfUnitDefinitions;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.UnitDefinition;
import org.sbml.libsbml.libsbml;

public class ParameterDialog
extends SBaseDialog {
    private JTextField idTextField;
    private JTextField nameTextField;
    private JTextField valueTextField;
    private JRadioButton constantRadio;
    private JRadioButton constantFalseRadio;
    private JComboBox unitsCombo;
    private String beforeID;

    public ParameterDialog() {
    }

    public ParameterDialog(Dialog owner) {
        super(owner);
    }

    public ParameterDialog(Frame owner) {
        super(owner);
    }

    public void setDialogByArg(String id, String name, String value, String units) {
        this.idTextField.setText(id);
        this.nameTextField.setText(name);
        this.valueTextField.setText(value);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        JLabel idLabel = new JLabel("id");
        idLabel.setBounds(new Rectangle(10, 10, 60, 20));
        this.mainPanel.add((Component)idLabel, null);
        this.idTextField = new JTextField();
        this.idTextField.setBounds(new Rectangle(75, 10, 300, 20));
        this.idTextField.setEditable(true);
        this.idTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.idTextField, null);
        JLabel nameLabel = new JLabel("name");
        nameLabel.setBounds(new Rectangle(10, 34, 60, 20));
        this.mainPanel.add((Component)nameLabel, null);
        this.nameTextField = new JTextField();
        this.nameTextField.setBounds(new Rectangle(75, 34, 300, 20));
        this.nameTextField.setEditable(true);
        this.nameTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.nameTextField, null);
        JLabel valueLabel = new JLabel("value");
        valueLabel.setBounds(new Rectangle(10, 58, 60, 20));
        this.mainPanel.add((Component)valueLabel, null);
        this.valueTextField = new JTextField();
        this.valueTextField.setBounds(new Rectangle(75, 58, 300, 20));
        this.valueTextField.setEditable(true);
        this.valueTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.valueTextField, null);
        JLabel unitsLabel = new JLabel("units");
        unitsLabel.setBounds(new Rectangle(10, 82, 60, 20));
        this.mainPanel.add((Component)unitsLabel, null);
        this.unitsCombo = new JComboBox();
        this.unitsCombo.setEditable(false);
        this.unitsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemevent) {
                ParameterDialog.this.okButton.setEnabled(true);
                ParameterDialog.this.cancelButton.setEnabled(true);
            }
        });
        this.unitsCombo.setBounds(new Rectangle(75, 82, 300, 20));
        this.mainPanel.add((Component)this.unitsCombo, null);
        JLabel constantLabel = new JLabel("constant");
        constantLabel.setBounds(new Rectangle(10, 106, 60, 20));
        this.mainPanel.add((Component)constantLabel, null);
        this.constantRadio = new JRadioButton("true");
        this.constantRadio.setBounds(new Rectangle(75, 106, 60, 20));
        this.constantRadio.addActionListener(this.radioListener);
        this.mainPanel.add((Component)this.constantRadio, null);
        this.constantFalseRadio = new JRadioButton("false");
        this.constantFalseRadio.setBounds(new Rectangle(145, 106, 70, 20));
        this.constantFalseRadio.addActionListener(this.radioListener);
        this.mainPanel.add((Component)this.constantFalseRadio, null);
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.constantRadio);
        bg1.add(this.constantFalseRadio);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (ParameterDialog.this.constantRadio.hasFocus() || ParameterDialog.this.constantFalseRadio.hasFocus()) {
                    switch (e.getKeyCode()) {
                        case 39: {
                            ParameterDialog.this.constantFalseRadio.setSelected(true);
                            ParameterDialog.this.constantFalseRadio.grabFocus();
                            break;
                        }
                        case 37: {
                            ParameterDialog.this.constantRadio.setSelected(true);
                            ParameterDialog.this.constantRadio.grabFocus();
                        }
                    }
                }
            }
        });
        this.LABEL_WIDTH = 60;
        this.TEXT_WIDTH = 300;
        this.setLayoutConstants();
        this.BUTTON_POSITION_Y = 10 + 6 * this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new Parameter();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        Parameter parameter = (Parameter)sbase;
        String id = parameter.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        String name = parameter.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
        double value = parameter.getValue();
        String s1 = LibSBMLUtil.trimDecimalEndZeroToString(value);
        this.valueTextField.setText(s1);
        this.valueTextField.setCaretPosition(s1.length());
        String units = parameter.getUnits();
        ListOfUnitDefinitions list = null;
        try {
            Model model = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel();
            list = model.getListOfUnitDefinitions();
        }
        catch (Exception ex) {
            return;
        }
        this.unitsCombo.removeAllItems();
        String[] strSBMLUnits = LibSBMLUtil.strListofSBMLKind;
        int cntforSBMLUnits = 0;
        int cntforBuiltinUnits = 0;
        int i = 0;
        if (list != null) {
            while ((long)i < list.size()) {
                this.unitsCombo.addItem(((UnitDefinition)list.get((long)i)).getId());
                if (list.get((long)i).getId().equals(units)) {
                    this.unitsCombo.setSelectedIndex(i + cntforSBMLUnits + cntforBuiltinUnits);
                }
                ++i;
            }
        }
        if (strSBMLUnits != null) {
            while (cntforSBMLUnits < strSBMLUnits.length) {
                this.unitsCombo.addItem(strSBMLUnits[cntforSBMLUnits]);
                if (strSBMLUnits[cntforSBMLUnits].equals(units)) {
                    this.unitsCombo.setSelectedIndex(i + cntforSBMLUnits + cntforBuiltinUnits);
                }
                ++cntforSBMLUnits;
            }
        }
        if (this.unitsCombo.getSelectedIndex() == -1) {
            this.unitsCombo.setSelectedIndex(0);
        }
        if (this.getParent() instanceof KineticLawDialog) {
            this.constantRadio.setEnabled(false);
            this.constantFalseRadio.setEnabled(false);
            this.constantRadio.setSelected(true);
            this.constantFalseRadio.setSelected(false);
        } else {
            this.constantRadio.setEnabled(true);
            this.constantFalseRadio.setEnabled(true);
            boolean b1 = parameter.getConstant();
            this.constantRadio.setSelected(b1);
            this.constantFalseRadio.setSelected(!b1);
        }
        this.beforeID = id;
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        Parameter parameter = (Parameter)sbase;
        String str = this.idTextField.getText();
        boolean isSameIDError = false;
        if (this.getParent() instanceof KineticLawDialog) {
            KineticLawDialog kk = (KineticLawDialog)this.getParent();
            try {
                SId.check(str);
                if (str.equals(this.beforeID)) {
                    parameter.setId(str);
                }
                if (kk.isExistParameterID(str)) {
                    isSameIDError = true;
                    throw new SIdFormatException();
                }
                parameter.setId(str);
            }
            catch (SIdFormatException e) {
                if (isSameIDError) {
                    throw new Exception("Same id exists.");
                }
                throw new Exception("malformed id string");
            }
        } else {
            try {
                SId.check(str);
                SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
                int selected = sbModel.getSBMLPanelListsSelectedRow(4);
                int i = 0;
                while ((long)i < sbModel.getModel().getNumParameters()) {
                    Parameter param;
                    if (!(!this.bCallMeWithRowID ? i == selected : i == this.iSelectedRowID) && (param = sbModel.getModel().getParameter((long)i)).getId().equals(str)) {
                        isSameIDError = true;
                        throw new SIdFormatException();
                    }
                    ++i;
                }
                parameter.setId(str);
            }
            catch (SIdFormatException e) {
                if (isSameIDError) {
                    throw new Exception("Same id exists.");
                }
                throw new Exception("malformed id string");
            }
        }
        String oldID = new String(this.beforeID);
        String newID = new String(str);
        this.beforeID = str;
        str = this.nameTextField.getText();
        parameter.setName(str);
        str = this.valueTextField.getText();
        if (str.equals("")) {
            parameter.setValue(0.0);
        } else {
            try {
                double d = Double.parseDouble(str);
                parameter.setValue(d);
            }
            catch (NumberFormatException e) {
                throw new Exception("value must be a real");
            }
        }
        str = (String)this.unitsCombo.getSelectedItem();
        try {
            if (str != null && !str.equals("")) {
                SId.check(str);
            }
            parameter.setUnits(str);
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed units string");
        }
        boolean b1 = this.constantRadio.isSelected();
        parameter.setConstant(b1);
        if (!newID.equals(oldID)) {
            SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            HashMap hashParameterNotes = sbModel.getHashParameterNotes();
            String newKey = LibSBMLUtil.getHashKey(parameter, newID);
            String oldKey = LibSBMLUtil.getHashKey(parameter, oldID);
            this.changeNotesforIdChange(hashParameterNotes, oldKey, newKey);
            if (this.getParent() instanceof KineticLawDialog) {
                KineticLawDialog kl = (KineticLawDialog)this.getParent();
                if (kl.getParent() instanceof ReactionDialog) {
                    ReactionDialog reactionDialog = (ReactionDialog)kl.getParent();
                    Reaction reaction = (Reaction)reactionDialog.getObject();
                    LibSBMLUtil.replaceMathID(sbModel, oldID, newID, 2, reaction.getId());
                    if (kl.getMathEditPanel() != null && kl.getMathEditPanel().getTextField() != null && kl.getMathEditPanel().getTextField().getText() != null && reaction.getKineticLaw() != null && reaction.getKineticLaw().getFormula() != null) {
                        try {
                            ASTNode nd = libsbml.parseFormula((String)kl.getMathEditPanel().getTextField().getText());
                            if (nd != null) {
                                String strMath = LibSBMLUtil.changeASTNodeName(nd, oldID, newID, 2);
                                kl.getMathEditPanel().getTextField().setText(strMath);
                                kl.getMathEditPanel().setDisplay();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            } else {
                LibSBMLUtil.replaceMathID(sbModel, oldID, newID, 3, "");
            }
        }
        if (this.getParent() instanceof KineticLawDialog) {
            KineticLawDialog kk = (KineticLawDialog)this.getParent();
            ReactionDialog rr = (ReactionDialog)kk.getParent();
            parameter.setAnnotation(LibSBMLUtil.addEnclosedAnnotationTags(((Reaction)rr.getObject()).getId()));
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.idTextField.setEnabled(isEnabled);
        this.nameTextField.setEnabled(isEnabled);
        this.valueTextField.setEnabled(isEnabled);
        this.unitsCombo.setEnabled(isEnabled);
        this.constantRadio.setEnabled(isEnabled);
        this.constantFalseRadio.setEnabled(isEnabled);
        this.okButton.setEnabled(isEnabled);
        this.cancelButton.setEnabled(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    @Override
    protected void okButton_actionPerformed() {
        Parameter backup = null;
        try {
            if (this.editingSBase != null && this.editingSBase instanceof Parameter && this.getParent() instanceof KineticLawDialog) {
                KineticLawDialog kwParent = (KineticLawDialog)this.getParent();
                ListPanel paraPanel = (ListPanel)kwParent.getSBaseListPanel(1);
                Parameter p = (Parameter)this.editingSBase;
                backup = p.cloneObject();
                if (this.isNewObject) {
                    this.setObjectFromDialog((SBase)p);
                    paraPanel.getSBaseList().appendAndOwn((SBase)p);
                    paraPanel.updateDialog();
                    paraPanel.table.setRowSelectionInterval((int)paraPanel.getSBaseList().size() - 1, (int)paraPanel.getSBaseList().size() - 1);
                    this.isNewObject = false;
                    kwParent.putParameterID(p.getId());
                } else {
                    String oldId = new String(p.getId());
                    this.setObjectFromDialog((SBase)p);
                    paraPanel.listTableModel.fireTableRowsUpdated(0, (int)paraPanel.getSBaseList().size() - 1);
                    if (!kwParent.isExistParameterID(p.getId())) {
                        kwParent.removeParameterID(oldId);
                        kwParent.putParameterID(p.getId());
                    }
                    if (paraPanel.isShowing()) {
                        paraPanel.repaint();
                    }
                }
                kwParent.setHaveChangedFlag();
                this.isEdited = false;
                this.updateApproveLabel();
                kwParent.someFieldIsEdited();
            } else {
                super.okButton_actionPerformed();
            }
            return;
        }
        catch (Exception ex) {
            ((Parameter)this.editingSBase).setId(backup.getId());
            ((Parameter)this.editingSBase).setName(backup.getName());
            ((Parameter)this.editingSBase).setValue(backup.getValue());
            ((Parameter)this.editingSBase).setUnits(backup.getUnits());
            ((Parameter)this.editingSBase).setConstant(backup.getConstant());
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
            return;
        }
    }

    protected void superOkButton_actionPerformed() {
        super.okButton_actionPerformed();
    }
}

