/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.sbml.Notes;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.XMLNode;

public class NotesDialog
extends JDialog {
    public static final String URI_HTML = "http://www.w3.org/1999/xhtml";
    public static final boolean printNonCDNotes = false;
    public static final int APPROVE_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private Frame owner;
    private boolean isFirstShowing = true;
    private int lastOption = 0;
    private Notes editingNotes = null;
    private JTextArea textArea;
    private JButton okButton;
    private JButton cancelButton;
    private String notesString = "";
    private SBase target;

    public NotesDialog(Frame owner, String title) {
        super(owner);
        super.setTitle(title);
        this.owner = owner;
        this.initDialog();
    }

    private void initDialog() {
        final JRootPane rootPane = this.getRootPane();
        JLabel beginHtmlLabel = new JLabel("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        JLabel beginBodyLabel = new JLabel("<body>");
        JLabel endBodyLabel = new JLabel("</body>");
        JLabel endHtmlLabel = new JLabel("</html>");
        JLabel[] labels = new JLabel[]{beginHtmlLabel, beginBodyLabel, endBodyLabel, endHtmlLabel};
        int i = 0;
        while (i < labels.length) {
            labels[i].setHorizontalAlignment(10);
            labels[i].setHorizontalTextPosition(10);
            labels[i].setIconTextGap(0);
            ++i;
        }
        this.textArea = new JTextArea();
        this.textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(NotesDialog.this.okButton);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setAutoscrolls(true);
        JPanel notesPanel = new JPanel();
        notesPanel.setVisible(true);
        notesPanel.setLayout(new BoxLayout(notesPanel, 3));
        notesPanel.add(beginHtmlLabel);
        notesPanel.add(beginBodyLabel);
        notesPanel.add(scrollPane);
        notesPanel.add(endBodyLabel);
        notesPanel.add(endHtmlLabel);
        notesPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic(79);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotesDialog.this.okButton_selected();
            }
        });
        this.okButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(NotesDialog.this.okButton);
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic(67);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotesDialog.this.cancelButton_selected();
            }
        });
        this.cancelButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(NotesDialog.this.cancelButton);
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.add((Component)this.okButton, null);
        buttonPane.add((Component)this.cancelButton, null);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)notesPanel, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setSize(400, 270);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NotesDialog.this.cancelButton_selected();
            }
        });
    }

    private void setComponentsEnabled() {
        this.textArea.setEditable(false);
        this.okButton.setEnabled(false);
    }

    public void releaseAll() {
        this.owner = null;
    }

    public void setText(String notesString) {
        this.notesString = notesString;
    }

    public String getText() {
        return this.notesString;
    }

    public void setEditingNotes(Notes notes) {
        this.editingNotes = notes;
    }

    public int showDialog() {
        this.textArea.setText(this.editingNotes.getText());
        if (this.isFirstShowing) {
            Point p = this.owner.getLocation();
            Dimension he = this.owner.getSize();
            Dimension me = this.getSize();
            int x = p.x + (he.width - me.width) / 2;
            int y = p.y + (he.height - me.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.setLocation(x, y);
            this.isFirstShowing = false;
        }
        this.show();
        return this.lastOption;
    }

    @Override
    public void show() {
        this.getRootPane().setDefaultButton(this.okButton);
        super.show();
    }

    private void okButton_selected() {
        XMLNode xn;
        String ntext = this.textArea.getText();
        if (!ntext.matches("^\\s*$") && (xn = XMLNode.convertStringToXMLNode((String)ntext)) == null) {
            String errmsg = "Invalid XHTML string.\nPlease make sure that the notes string is a well-formed XML string\nwhich can be contained in a <body> tag.\n\nIf you want to represent the following characters as themselves,\nplease escape them as follows:\n &  --> &amp; \n <  --> &lt; \n >  --> &gt; \n";
            JOptionPane.showMessageDialog(this, errmsg, "Error", 0);
            return;
        }
        this.editingNotes.setText(ntext);
        this.editingNotes = null;
        this.lastOption = 1;
        ((MainWindow)this.owner).componentSelectionChanged();
        MainWindow.getLastInstance().getCurrentModel().getSBModel().setPanelSelectedSbase(null);
        this.dispose();
        MainWindow.getLastInstance().SBaseChanged(this.target);
        MainWindow.getLastInstance().getCurrentModel().setHasAnySBaseChangedFlg(true);
    }

    public void cancelButton_selected() {
        this.editingNotes = null;
        this.lastOption = 2;
        MainWindow.getLastInstance().getCurrentModel().getSBModel().setPanelSelectedSbase(null);
        this.dispose();
    }

    public boolean isEditing() {
        return this.editingNotes != null;
    }

    public SBase getTarget() {
        return this.target;
    }

    public void setTarget(SBase target) {
        this.target = target;
    }
}

