/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.ModifierSpeciesReference;
import org.sbml.libsbml.SBase;

public class ModifierSpeciesReferenceDialog
extends SBaseDialog {
    private JTextField speciesTextField;

    public ModifierSpeciesReferenceDialog() {
    }

    public ModifierSpeciesReferenceDialog(Dialog owner) {
        super(owner);
    }

    public ModifierSpeciesReferenceDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        JLabel speciesLabel = new JLabel("species");
        speciesLabel.setBounds(new Rectangle(10, 10, 120, 20));
        this.mainPanel.add((Component)speciesLabel, null);
        this.speciesTextField = new JTextField();
        this.speciesTextField.setBounds(new Rectangle(70, 10, 300, 20));
        this.speciesTextField.setEditable(true);
        this.speciesTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.speciesTextField, null);
        this.LABEL_WIDTH = 50;
        this.TEXT_WIDTH = 300;
        this.setLayoutConstants();
        this.BUTTON_POSITION_Y = 10 + 2 * this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new ModifierSpeciesReference();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        ModifierSpeciesReference modifierSpeciesReference = (ModifierSpeciesReference)sbase;
        String species = modifierSpeciesReference.getSpecies();
        this.speciesTextField.setText(species);
        this.speciesTextField.setCaretPosition(species.length());
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        ModifierSpeciesReference modifierSpeciesReference = (ModifierSpeciesReference)sbase;
        String str = this.speciesTextField.getText();
        try {
            SId.check(str);
            modifierSpeciesReference.setSpecies(str);
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed species string");
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.speciesTextField.setEnabled(false);
        this.okButton.setEnabled(isEnabled);
        this.cancelButton.setEnabled(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }
}

