/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.util.AnyInput;
import jp.sbi.sbml.util.SBMLDialogs;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseListDialog;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;

public class ModelDialog
extends SBaseDialog {
    private JTextField idTextField;
    private JTextField nameTextField;
    private JButton functionDefinitionDlgButton;
    private JButton unitDefinitionListDlgButton;
    private JButton compartmentListDlgButton;
    private JButton speciesListDlgButton;
    private JButton parameterListDlgButton;
    private JButton ruleListDlgButton;
    private JButton reactionListDlgButton;
    private JButton eventListDlgButton;
    private SBMLDialogs sbmlDialogs;
    private boolean useKeyListenerToTextFields = false;
    private MyKeyListener myKeyListener;

    public ModelDialog() {
        if (this.useKeyListenerToTextFields) {
            this.addListenerToTextFields();
        }
        this.sbmlDialogs = new SBMLDialogs(this);
    }

    public ModelDialog(Dialog owner) {
        super(owner);
        if (this.useKeyListenerToTextFields) {
            this.addListenerToTextFields();
        }
        this.sbmlDialogs = new SBMLDialogs(this);
    }

    public ModelDialog(Frame owner) {
        super(owner);
        if (this.useKeyListenerToTextFields) {
            this.addListenerToTextFields();
        }
        this.sbmlDialogs = new SBMLDialogs(this);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        JLabel idLabel = new JLabel("id");
        idLabel.setBounds(new Rectangle(10, 10, 60, 20));
        this.mainPanel.add((Component)idLabel, null);
        this.idTextField = new JTextField();
        this.idTextField.setBounds(new Rectangle(70, 10, 200, 20));
        this.idTextField.setEditable(true);
        this.idTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.idTextField, null);
        JLabel nameLabel = new JLabel("name");
        nameLabel.setBounds(new Rectangle(10, 34, 60, 20));
        this.mainPanel.add((Component)nameLabel, null);
        this.nameTextField = new JTextField();
        this.nameTextField.setBounds(new Rectangle(70, 34, 200, 20));
        this.nameTextField.setEditable(true);
        this.nameTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.nameTextField, null);
        JLabel listOfFunctionDefinitionsLabel = new JLabel("listOfFunctionDefinitions");
        listOfFunctionDefinitionsLabel.setBounds(new Rectangle(10, 70, 160, 20));
        this.mainPanel.add((Component)listOfFunctionDefinitionsLabel, null);
        this.functionDefinitionDlgButton = new JButton("Show list..");
        this.functionDefinitionDlgButton.setBounds(new Rectangle(170, 70, 100, 20));
        this.functionDefinitionDlgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelDialog.this.listDlgButton_actionPerformed(0);
            }
        });
        this.functionDefinitionDlgButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModelDialog.this.rootPane.setDefaultButton(ModelDialog.this.functionDefinitionDlgButton);
            }
        });
        this.mainPanel.add((Component)this.functionDefinitionDlgButton, null);
        JLabel listOfUnitDefinitionsLabel = new JLabel("listOfUnitDefinitions");
        listOfUnitDefinitionsLabel.setBounds(new Rectangle(10, 100, 160, 20));
        this.mainPanel.add((Component)listOfUnitDefinitionsLabel, null);
        this.unitDefinitionListDlgButton = new JButton("Show list..");
        this.unitDefinitionListDlgButton.setBounds(new Rectangle(170, 100, 100, 20));
        this.unitDefinitionListDlgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelDialog.this.listDlgButton_actionPerformed(1);
            }
        });
        this.unitDefinitionListDlgButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModelDialog.this.rootPane.setDefaultButton(ModelDialog.this.unitDefinitionListDlgButton);
            }
        });
        this.mainPanel.add((Component)this.unitDefinitionListDlgButton, null);
        JLabel listOfCompartmentsLabel = new JLabel("listOfCompartments");
        listOfCompartmentsLabel.setBounds(new Rectangle(10, 130, 160, 20));
        this.mainPanel.add((Component)listOfCompartmentsLabel, null);
        this.compartmentListDlgButton = new JButton("Show list..");
        this.compartmentListDlgButton.setBounds(new Rectangle(170, 130, 100, 20));
        this.compartmentListDlgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelDialog.this.listDlgButton_actionPerformed(2);
            }
        });
        this.compartmentListDlgButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModelDialog.this.rootPane.setDefaultButton(ModelDialog.this.compartmentListDlgButton);
            }
        });
        this.mainPanel.add((Component)this.compartmentListDlgButton, null);
        JLabel speciesListLabel = new JLabel("listOfSpecies");
        speciesListLabel.setBounds(new Rectangle(10, 160, 160, 20));
        this.mainPanel.add((Component)speciesListLabel, null);
        this.speciesListDlgButton = new JButton("Show list..");
        this.speciesListDlgButton.setBounds(new Rectangle(170, 160, 100, 20));
        this.speciesListDlgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelDialog.this.listDlgButton_actionPerformed(3);
            }
        });
        this.speciesListDlgButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModelDialog.this.rootPane.setDefaultButton(ModelDialog.this.speciesListDlgButton);
            }
        });
        this.mainPanel.add((Component)this.speciesListDlgButton, null);
        JLabel listOfParametersLabel = new JLabel("listOfParameters");
        listOfParametersLabel.setBounds(new Rectangle(10, 190, 160, 20));
        this.mainPanel.add((Component)listOfParametersLabel, null);
        this.parameterListDlgButton = new JButton("Show list..");
        this.parameterListDlgButton.setBounds(new Rectangle(170, 190, 100, 20));
        this.parameterListDlgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelDialog.this.listDlgButton_actionPerformed(4);
            }
        });
        this.parameterListDlgButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModelDialog.this.rootPane.setDefaultButton(ModelDialog.this.parameterListDlgButton);
            }
        });
        this.mainPanel.add((Component)this.parameterListDlgButton, null);
        JLabel listOfRulesLabel = new JLabel("listOfRules");
        listOfRulesLabel.setBounds(new Rectangle(10, 220, 160, 20));
        this.mainPanel.add((Component)listOfRulesLabel, null);
        this.ruleListDlgButton = new JButton("Show list..");
        this.ruleListDlgButton.setBounds(new Rectangle(170, 220, 100, 20));
        this.ruleListDlgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelDialog.this.listDlgButton_actionPerformed(5);
            }
        });
        this.ruleListDlgButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModelDialog.this.rootPane.setDefaultButton(ModelDialog.this.ruleListDlgButton);
            }
        });
        this.mainPanel.add((Component)this.ruleListDlgButton, null);
        JLabel listOfReactionsLabel = new JLabel("listOfReactions");
        listOfReactionsLabel.setBounds(new Rectangle(10, 250, 160, 20));
        this.mainPanel.add((Component)listOfReactionsLabel, null);
        this.reactionListDlgButton = new JButton("Show list..");
        this.reactionListDlgButton.setBounds(new Rectangle(170, 250, 100, 20));
        this.reactionListDlgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelDialog.this.listDlgButton_actionPerformed(6);
            }
        });
        this.reactionListDlgButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModelDialog.this.rootPane.setDefaultButton(ModelDialog.this.reactionListDlgButton);
            }
        });
        this.mainPanel.add((Component)this.reactionListDlgButton, null);
        JLabel listOfEventsLabel = new JLabel("listOfEvents");
        listOfEventsLabel.setBounds(new Rectangle(10, 280, 160, 20));
        this.mainPanel.add((Component)listOfEventsLabel, null);
        this.eventListDlgButton = new JButton("Show list..");
        this.eventListDlgButton.setBounds(new Rectangle(170, 280, 100, 20));
        this.eventListDlgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelDialog.this.listDlgButton_actionPerformed(7);
            }
        });
        this.eventListDlgButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModelDialog.this.rootPane.setDefaultButton(ModelDialog.this.eventListDlgButton);
            }
        });
        this.mainPanel.add((Component)this.eventListDlgButton, null);
        this.LABEL_WIDTH = 50;
        this.TEXT_WIDTH = 200;
        this.setLayoutConstants();
        this.BUTTON_POSITION_Y = 10 + 13 * this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new Model();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        Model model = (Model)sbase;
        String id = model.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        String name = model.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        Model model = (Model)sbase;
        String str = this.idTextField.getText();
        try {
            SId.check(str);
            model.setId(str);
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed id string");
        }
        str = this.nameTextField.getText();
        model.setName(str);
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.idTextField.setEnabled(isEnabled);
        this.nameTextField.setEnabled(isEnabled);
        if (isEnabled) {
            this.sbmlDialogs.setModel((Model)super.getObject());
        } else {
            this.sbmlDialogs.setModel(null);
        }
    }

    @Override
    protected void releaseAllMembers() {
        this.sbmlDialogs.releaseAllDialogs();
        this.sbmlDialogs = null;
        this.removeListenerFromTextFields();
    }

    @Override
    protected boolean hasChildListDialog() {
        return true;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
        this.sbmlDialogs.updateChildDialog();
    }

    private void listDlgButton_actionPerformed(int i) {
        this.sbmlDialogs.showListDialog(i);
    }

    private void addListenerToTextFields() {
        AnyInput annotationInput;
        this.myKeyListener = new MyKeyListener();
        this.idTextField.addKeyListener(this.myKeyListener);
        this.nameTextField.addKeyListener(this.myKeyListener);
        AnyInput notesInput = super.getAnyInput(1001);
        if (notesInput != null) {
            notesInput.getComponent().addKeyListener(this.myKeyListener);
        }
        if ((annotationInput = super.getAnyInput(1002)) != null) {
            annotationInput.getComponent().addKeyListener(this.myKeyListener);
        }
    }

    private void removeListenerFromTextFields() {
        AnyInput annotationInput;
        this.idTextField.removeKeyListener(this.myKeyListener);
        this.nameTextField.removeKeyListener(this.myKeyListener);
        AnyInput notesInput = super.getAnyInput(1001);
        if (notesInput != null) {
            notesInput.getComponent().removeKeyListener(this.myKeyListener);
        }
        if ((annotationInput = super.getAnyInput(1002)) != null) {
            annotationInput.getComponent().removeKeyListener(this.myKeyListener);
        }
        this.myKeyListener = null;
    }

    @Override
    public void setObject(SBase sbase) {
        super.setObject(sbase);
        this.sbmlDialogs.setModel((Model)sbase);
    }

    @Override
    public void setNewObject() {
        super.setNewObject();
        this.sbmlDialogs.setModel((Model)super.getObject());
    }

    public void setListElementDialogMode(int mode) {
        this.sbmlDialogs.setListElementDialogMode(mode);
    }

    public SBaseListDialog getSBaseListDialog(int list_const) {
        return this.sbmlDialogs.getSBaseListDialog(list_const);
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            try {
                ModelDialog.this.updateObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

