/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MessageDialog
extends JDialog {
    private static MessageDialog uniquInstance = null;
    private static JLabel titleLabel = new JLabel();
    private static JTextArea textArea = new JTextArea(0, 80){

        @Override
        public boolean isManagingFocus() {
            return false;
        }
    };
    private static JButton closeButton = new JButton("OK");

    private MessageDialog(Dialog owner) {
        super(owner);
    }

    public static MessageDialog getInstance(Dialog owner) {
        if (uniquInstance == null) {
            uniquInstance = new MessageDialog(owner);
            uniquInstance.setModal(false);
            textArea.setEditable(false);
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setAutoscrolls(true);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setVisible(true);
            closeButton.setMnemonic(67);
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    uniquInstance.dispose();
                }
            });
            buttonPanel.add(closeButton);
            Container contentPane = uniquInstance.getContentPane();
            contentPane.add((Component)titleLabel, "North");
            contentPane.add((Component)buttonPanel, "South");
            contentPane.add((Component)scrollPane, "Center");
            int width = 500;
            int height = 400;
            uniquInstance.setSize(width, height);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            uniquInstance.setLocation((int)((screenSize.getWidth() - (double)width) / 2.0), (int)((screenSize.getHeight() - (double)height) / 2.0));
        }
        return uniquInstance;
    }

    public static void showMessageDialog(Dialog owner, String title, String messageTitle, String message) {
        MessageDialog.getInstance(owner);
        uniquInstance.setTitle(title);
        titleLabel.setText(messageTitle);
        textArea.setText(message);
        uniquInstance.getRootPane().setDefaultButton(closeButton);
        uniquInstance.show();
    }
}

