/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jp.sbi.sbml.util.IconUtil;
import jp.sbi.sbml.util.MathEditButtonsPanel;
import jp.sbi.sbml.util.MathEditPanel;
import jp.sbi.sbml.util.ObservableAspect;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class MathEditPanel2
extends MathEditPanel {
    public static final int MATH_TEXT_1 = 1;
    public static final int MATH_TEXT_2 = 2;
    private JButton copyButton1;
    private JButton copyButton2;
    private JTextField mathTextField1 = new JTextField();
    private JTextField mathTextField2 = new JTextField();
    private boolean copyButton1Enable = false;
    private boolean copyButton2Enable = false;
    private SBase selectedItem = null;
    private JTextField selectedItemText;
    private MathEditButtonsPanel buttonsPanel1;
    private MathEditButtonsPanel buttonsPanel2;

    @Override
    public int createUI(int width, int lineHeight, int baseLineSkip) {
        super.setLayout(null);
        super.setOpaque(true);
        super.setBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)));
        int hmargin = 4;
        int wmargin = 4;
        int y = 4;
        int textWidth = width - 8;
        this.mathTextField1.setBounds(new Rectangle(4, y, textWidth, lineHeight));
        this.mathTextField1.addFocusListener(this);
        this.add((Component)this.mathTextField1, null);
        y += baseLineSkip;
        this.copyButton1 = new JButton("copy");
        int copybuttonWidthTemp = (int)this.copyButton1.getPreferredSize().getWidth();
        this.copyButton1.addActionListener(this);
        ImageIcon icon1 = IconUtil.getIcon("copy_math_up2.png");
        this.copyButton1.setIcon(icon1);
        this.copyButton1.setBounds(new Rectangle((width - 50) / 2, y, copybuttonWidthTemp, lineHeight));
        this.copyButton1.setMargin(new Insets(2, 2, 2, 2));
        this.buttonsPanel1 = new MathEditButtonsPanel(this, this.copyButton1);
        this.selectedItemText = new JTextField();
        this.selectedItemText.setEditable(false);
        this.selectedItemText.setBounds(new Rectangle(4, y += baseLineSkip, textWidth, lineHeight));
        this.add((Component)this.selectedItemText, null);
        this.copyButton2 = new JButton("copy");
        this.copyButton2.addActionListener(this);
        ImageIcon icon2 = IconUtil.getIcon("copy_math_down2.png");
        this.copyButton2.setIcon(icon2);
        this.copyButton2.setBounds(new Rectangle((width - 50) / 2, y += baseLineSkip, copybuttonWidthTemp, lineHeight));
        this.copyButton2.setMargin(new Insets(2, 2, 2, 2));
        this.add((Component)this.copyButton2, null);
        this.buttonsPanel2 = new MathEditButtonsPanel(this, this.copyButton2);
        this.mathTextField2.setBounds(new Rectangle(4, y += baseLineSkip, textWidth, lineHeight));
        this.mathTextField2.addFocusListener(this);
        this.add((Component)this.mathTextField2, null);
        this.setPreferredSize(new Dimension(width, y += lineHeight + 4));
        return y;
    }

    @Override
    public JTextField getTextField() {
        return null;
    }

    public JTextField getTextField(int index) {
        if (index == 1) {
            return this.mathTextField1;
        }
        if (index == 2) {
            return this.mathTextField2;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        String str1 = this.buttonsPanel1.getStringForAction(s);
        String str2 = this.buttonsPanel2.getStringForAction(s);
        if (str1 != null || s == this.copyButton1) {
            String str = s == this.copyButton1 ? this.selectedItemText.getText() : str1;
            Document doc = this.mathTextField1.getDocument();
            int is = this.mathTextField1.getSelectionStart();
            int ie = this.mathTextField1.getSelectionEnd();
            if (is >= 0 && ie > is) {
                try {
                    doc.remove(is, ie - is);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            try {
                doc.insertString(is, str, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.mathTextField1.requestFocus();
        } else if (str2 != null || s == this.copyButton2) {
            String str = s == this.copyButton2 ? this.selectedItemText.getText() : str2;
            Document doc = this.mathTextField2.getDocument();
            int is = this.mathTextField2.getSelectionStart();
            int ie = this.mathTextField2.getSelectionEnd();
            if (is >= 0 && ie > is) {
                try {
                    doc.remove(is, ie - is);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            try {
                doc.insertString(is, str, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.mathTextField2.requestFocus();
        }
    }

    @Override
    public void update(Observable observable, Object aspect) {
        ObservableAspect oa = (ObservableAspect)aspect;
        switch (oa.getType()) {
            case 1: {
                this.copyButton1Enable = true;
                this.copyButton2Enable = true;
                this.selectedItem = (SBase)oa.getObject();
                this.selectedItemText.setText(((Species)this.selectedItem).getId());
                this.copyButtonUpdate();
                break;
            }
            case 2: {
                this.copyButton1Enable = true;
                this.copyButton2Enable = true;
                this.selectedItem = (SBase)oa.getObject();
                this.selectedItemText.setText(((Parameter)this.selectedItem).getId());
                this.copyButtonUpdate();
                break;
            }
            case 3: {
                this.copyButton1Enable = true;
                this.copyButton2Enable = true;
                this.selectedItem = (SBase)oa.getObject();
                this.selectedItemText.setText(((Parameter)this.selectedItem).getId());
                this.copyButtonUpdate();
                break;
            }
            case 4: {
                this.copyButton1Enable = true;
                this.copyButton2Enable = true;
                this.selectedItem = (SBase)oa.getObject();
                this.selectedItemText.setText(((Compartment)this.selectedItem).getId());
                this.copyButtonUpdate();
                break;
            }
            case 9: {
                this.copyButton1Enable = false;
                this.copyButton2Enable = false;
                this.selectedItem = null;
                this.selectedItemText.setText("");
                this.copyButtonUpdate();
            }
        }
    }

    @Override
    public void copyButtonUpdate() {
        boolean enable11 = this.mathTextField1.isEnabled();
        boolean enable12 = this.mathTextField1.hasFocus();
        this.copyButton1.setEnabled(enable11 && enable12 && this.copyButton1Enable);
        this.buttonsPanel1.enableButtons(enable11 && enable12);
        boolean enable21 = this.mathTextField2.isEnabled();
        boolean enable22 = this.mathTextField2.hasFocus();
        this.copyButton2.setEnabled(enable21 && enable22 && this.copyButton2Enable);
        this.buttonsPanel2.enableButtons(enable21 && enable22);
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object s = e.getSource();
        if (s == this.mathTextField1 || s == this.mathTextField2) {
            this.copyButtonUpdate();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Component c;
        Object s = e.getSource();
        if (s == this.mathTextField1) {
            Component c2 = e.getOppositeComponent();
            if (!this.buttonsPanel1.contains(c2) && c2 != this.copyButton1) {
                this.copyButtonUpdate();
            }
        } else if (s == this.mathTextField2 && !this.buttonsPanel2.contains(c = e.getOppositeComponent()) && c != this.copyButton2) {
            this.copyButtonUpdate();
        }
    }

    @Override
    public void clearSelectedItemText() {
        if (this.selectedItemText != null) {
            this.selectedItemText.setText("");
        }
    }
}

