/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.sbml.util.IconUtil;
import jp.sbi.sbml.util.KineticLawDialog;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.MathEditButtonsPanel;
import jp.sbi.sbml.util.ObservableAspect;
import jp.sbi.sbml.util.ReactionDialog;
import net.sourceforge.jeuclid.swing.JMathComponent;
import net.sourceforge.jeuclid.util.ResourceEntityResolver;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.libsbml;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class MathEditPanel
extends JPanel
implements Observer,
FocusListener,
ActionListener {
    private JButton copyButton;
    private JTextField mathTextField = new JTextField();
    private boolean copyButtonEnable = false;
    private SBase selectedItem = null;
    private JTextField selectedItemText;
    private MathEditButtonsPanel buttonsPanel;
    protected static final int COPYBUTTON_WIDTH = 50;
    private KineticLawDialog parent;
    private JLabel mathTextFieldFakeLabel;
    private JCheckBox ckbMath = new JCheckBox();
    private JCheckBox ckbName = new JCheckBox();
    private String strId;
    private String strName;
    private org.w3c.dom.Document idDocument;
    private org.w3c.dom.Document nameDocument;
    private JPanel imagePanel;
    private JMathComponent jMathCom;
    private JLabel messageLabel;
    private boolean bFocusBacktoMathTextField = false;
    private static final char[] CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '_'};
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public MathEditPanel(KineticLawDialog parent) {
        this.parent = parent;
    }

    public MathEditPanel() {
    }

    public int createUI(int width, int lineHeight, int baseLineSkip) {
        super.setLayout(null);
        super.setOpaque(true);
        super.setBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)));
        int hmargin = 4;
        int wmargin = 4;
        int y = 4;
        int textWidth = width - 8;
        this.mathTextField.setBounds(new Rectangle(4, y, textWidth, lineHeight));
        this.mathTextField.addFocusListener(this);
        this.add((Component)this.mathTextField, null);
        int y1 = 0;
        int x1 = 10;
        this.jMathCom = new JMathComponent();
        this.jMathCom.setBounds(0, 0, textWidth, lineHeight);
        this.imagePanel = new JPanel(new BorderLayout());
        this.imagePanel.setBounds(new Rectangle(4, y, textWidth, lineHeight * 2));
        this.imagePanel.setBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)));
        this.imagePanel.setBackground(Color.white);
        this.imagePanel.updateUI();
        this.setJMathVisible();
        this.add(this.imagePanel);
        this.imagePanel.setVisible(false);
        this.mathTextFieldFakeLabel = new JLabel();
        this.mathTextFieldFakeLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (((MathEditPanel)MathEditPanel.this).parent.editingSBase == null) {
                    return;
                }
                MathEditPanel.this.setMathTextFieldVisible(true);
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }
        });
        y += baseLineSkip;
        this.copyButton = new JButton("copy");
        int copybuttonWidthTemp = (int)this.copyButton.getPreferredSize().getWidth();
        this.copyButton.addActionListener(this);
        ImageIcon icon = IconUtil.getIcon("copy_math_up2.png");
        this.copyButton.setIcon(icon);
        this.copyButton.setBounds(new Rectangle((width - 50) / 2 - x1, y + y1, copybuttonWidthTemp, lineHeight));
        this.copyButton.setMargin(new Insets(2, 2, 2, 2));
        this.buttonsPanel = new MathEditButtonsPanel(this, this.copyButton);
        this.selectedItemText = new JTextField();
        this.selectedItemText.setEditable(false);
        this.selectedItemText.setBounds(new Rectangle(4, (y += baseLineSkip) + y1, textWidth, lineHeight));
        this.add((Component)this.selectedItemText, null);
        this.setPreferredSize(new Dimension(width, y += lineHeight + 4));
        return y + y1;
    }

    public int createUI1(int width, int lineHeight, int baseLineSkip, JCheckBox ckbMath, JCheckBox ckbName, JLabel messageLabel) {
        if (ckbMath == null) {
            ckbMath = new JCheckBox();
        }
        if (ckbName == null) {
            ckbName = new JCheckBox();
        }
        super.setLayout(new GridBagLayout());
        super.setOpaque(true);
        super.setBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)));
        GridBagConstraints c = new GridBagConstraints();
        int hmargin = 4;
        int wmargin = 4;
        int y = 4;
        int textWidth = width - 8;
        this.mathTextField.setBounds(new Rectangle(4, y, textWidth, lineHeight));
        this.mathTextField.setPreferredSize(new Dimension(textWidth, lineHeight));
        this.mathTextField.addFocusListener(this);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.ipadx = 0;
        c.gridwidth = 0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.mathTextField, c);
        int y1 = 25;
        int x1 = 10;
        this.jMathCom = new JMathComponent();
        this.jMathCom.setBounds(0, 0, textWidth, lineHeight);
        this.imagePanel = new JPanel(new BorderLayout());
        this.imagePanel.setBounds(new Rectangle(4, y, textWidth, lineHeight * 2));
        this.imagePanel.setBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)));
        this.imagePanel.setBackground(Color.white);
        this.imagePanel.updateUI();
        this.setJMathVisible();
        c.ipady = 20;
        this.add((Component)this.imagePanel, c);
        this.mathTextFieldFakeLabel = new JLabel();
        c.fill = 2;
        c.ipady = 0;
        this.add((Component)this.mathTextFieldFakeLabel, c);
        this.mathTextFieldFakeLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (((MathEditPanel)MathEditPanel.this).parent.editingSBase == null) {
                    return;
                }
                MathEditPanel.this.setMathTextFieldVisible(true);
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }
        });
        y += baseLineSkip;
        this.copyButton = new JButton("copy ");
        int copyButtonWidth = (int)this.copyButton.getPreferredSize().getWidth();
        this.copyButton.addActionListener(this);
        ImageIcon icon = IconUtil.getIcon("copy_math_up2.png");
        this.copyButton.setIcon(icon);
        this.copyButton.setBounds(new Rectangle((width - 50) / 2 - x1, y + y1, copyButtonWidth, lineHeight));
        this.copyButton.setMargin(new Insets(2, 2, 2, 2));
        this.ckbMath = ckbMath;
        this.ckbMath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MathEditPanel.this.actionPerformed_mathCheckBox();
            }
        });
        this.ckbName = ckbName;
        this.ckbName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MathEditPanel.this.actionPerformed_nameCheckBox();
            }
        });
        this.messageLabel = messageLabel;
        this.buttonsPanel = new MathEditButtonsPanel(this, this.copyButton);
        this.setPreferredSize(new Dimension(width, (y += baseLineSkip) - 600));
        return y + y1;
    }

    public boolean isFakeLabelVisible() {
        return this.mathTextFieldFakeLabel.isVisible();
    }

    public void setPanelVisible(boolean aFlag) {
        this.resetMathCheckBox();
        this.resetNameCheckBox();
    }

    public JTextField getTextField() {
        return this.mathTextField;
    }

    public JTextField getSelectedItemText() {
        return this.selectedItemText;
    }

    public void setCopyButtonEnable(boolean boo) {
        this.copyButtonEnable = boo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        String str = this.buttonsPanel.getStringForAction(s);
        if (str == null && s == this.copyButton) {
            str = this.selectedItemText.getText();
        }
        if (str != null) {
            Document doc = this.mathTextField.getDocument();
            int is = this.mathTextField.getSelectionStart();
            int ie = this.mathTextField.getSelectionEnd();
            if (is >= 0 && ie > is) {
                try {
                    doc.remove(is, ie - is);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            try {
                doc.insertString(is, str, null);
                if (this.parent != null) {
                    this.parent.functionPanel.setListSelected(0);
                    this.createColoredHTML();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.mathTextField.requestFocus();
        }
    }

    private void convertFormula(String strMath, String protocol) throws TransformerConfigurationException, TransformerException, ParserConfigurationException, IOException, SAXException {
        KineticLaw kineticLaw = new KineticLaw();
        String strName = new String();
        if (!this.ckbName.isSelected()) {
            if (this.strId != null && this.strId.equals(strMath) && this.idDocument != null) {
                this.diplayImagePanel(this.idDocument);
                return;
            }
            kineticLaw.setMath(libsbml.parseFormula((String)strMath));
        } else {
            strName = this.getNameString(strMath);
            if (this.strName != null && this.strName.equals(strName) && this.nameDocument != null) {
                this.diplayImagePanel(this.nameDocument);
                return;
            }
            kineticLaw.setMath(libsbml.parseFormula((String)strName));
        }
        String math = kineticLaw.toSBML().replaceAll("<kineticLaw>", "").replaceAll("</kineticLaw>", "");
        if (protocol == null || protocol.length() == 0) {
            String ptl = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";
            math = ptl.concat(math);
        } else {
            math = protocol.concat(math);
        }
        StringReader srMath = new StringReader(math);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource("mmlctop2_0.xsl"));
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(new StreamSource(srMath), new StreamResult(baos));
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
        parser.setEntityResolver((EntityResolver)new ResourceEntityResolver());
        org.w3c.dom.Document document = parser.parse(bais);
        this.diplayImagePanel(document);
        if (!this.ckbName.isSelected()) {
            this.strId = strMath;
            this.idDocument = document;
        } else {
            this.strName = strName;
            this.nameDocument = document;
        }
    }

    void setJMathVisible() {
        try {
            if (this.ckbMath == null) {
                this.imagePanel.setVisible(false);
                return;
            }
            this.imagePanel.setVisible(true);
        }
        catch (Exception e) {
            this.imagePanel.setVisible(false);
        }
    }

    void resetJMathVisible() {
        if (this.imagePanel != null && this.jMathCom != null) {
            this.jMathCom.setDocument(null);
            this.imagePanel.add((Component)this.jMathCom);
            this.imagePanel.setVisible(false);
        }
    }

    @Override
    public void update(Observable observable, Object aspect) {
        ObservableAspect oa = (ObservableAspect)aspect;
        if (this.selectedItemText == null) {
            this.selectedItemText = new JTextField();
        }
        switch (oa.getType()) {
            case 1: {
                this.copyButtonEnable = true;
                this.selectedItem = (SBase)oa.getObject();
                if (this.parent == null || !(this.parent instanceof KineticLawDialog)) {
                    this.selectedItemText.setText(((Species)this.selectedItem).getId());
                } else {
                    this.parent.setMathTextField(((Species)this.selectedItem).getId());
                }
                this.copyButtonUpdate();
                break;
            }
            case 2: {
                this.copyButtonEnable = true;
                this.selectedItem = (SBase)oa.getObject();
                if (this.parent == null || !(this.parent instanceof KineticLawDialog)) {
                    this.selectedItemText.setText(((Parameter)this.selectedItem).getId());
                } else if (this.parent instanceof KineticLawDialog) {
                    this.parent.setMathTextField(((Parameter)this.selectedItem).getId());
                }
                this.copyButtonUpdate();
                break;
            }
            case 3: {
                this.copyButtonEnable = true;
                this.selectedItem = (SBase)oa.getObject();
                if (this.parent == null || !(this.parent instanceof KineticLawDialog)) {
                    this.selectedItemText.setText(((Parameter)this.selectedItem).getId());
                } else {
                    this.parent.setMathTextField(((Parameter)this.selectedItem).getId());
                }
                this.copyButtonUpdate();
                break;
            }
            case 4: {
                this.copyButtonEnable = true;
                this.selectedItem = (SBase)oa.getObject();
                this.selectedItemText.setText(((Compartment)this.selectedItem).getId());
                this.copyButtonUpdate();
                break;
            }
            case 9: {
                this.copyButtonEnable = false;
                this.selectedItem = null;
                this.selectedItemText.setText("");
                this.copyButtonUpdate();
            }
        }
    }

    public void copyButtonUpdate() {
        boolean enable = this.mathTextField.isEnabled();
        boolean enable2 = this.mathTextField.hasFocus();
        this.copyButton.setEnabled(enable && enable2 && this.copyButtonEnable);
        this.buttonsPanel.enableButtons(enable && enable2);
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object s = e.getSource();
        if (s == this.mathTextField) {
            this.copyButtonUpdate();
        }
        this.setMathTextFieldVisible(true);
    }

    public boolean isFocusBacktoMathTextField() {
        return this.bFocusBacktoMathTextField;
    }

    public void setFocusBacktoMathTextField(boolean bFocusBacktoMathTextField) {
        this.bFocusBacktoMathTextField = bFocusBacktoMathTextField;
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object s = e.getSource();
        if (s == this.mathTextField) {
            if (e.getOppositeComponent() != null && e.getOppositeComponent() instanceof JComponent) {
                JComponent com = (JComponent)e.getOppositeComponent();
                if (com.getTopLevelAncestor() instanceof MainWindow) {
                    this.setFocusBacktoMathTextField(true);
                    this.mathTextField.requestFocus();
                } else if (this.isFocusBacktoMathTextField()) {
                    this.setFocusBacktoMathTextField(false);
                    this.mathTextField.requestFocus();
                } else if (com.getTopLevelAncestor() instanceof KineticLawDialog) {
                    return;
                }
            } else {
                this.setFocusBacktoMathTextField(true);
                this.mathTextField.requestFocus();
            }
        }
        this.setMathTextFieldVisible(false);
    }

    public void setMathTextFieldVisible(boolean boo) {
        if (this.parent == null) {
            return;
        }
        if (this.mathTextField != null && this.mathTextField.getText().equals("")) {
            this.setDisplayEmpty();
            return;
        }
        if (boo) {
            if (this.ckbMath.isSelected() || this.ckbName.isSelected()) {
                return;
            }
            this.mathTextFieldFakeLabel.setVisible(false);
            this.mathTextField.setVisible(true);
            this.mathTextField.requestFocus();
            this.imagePanel.setVisible(false);
        } else {
            this.setDisplay();
        }
    }

    public void resetMathTextField() {
        this.mathTextFieldFakeLabel.setVisible(false);
        this.mathTextField.setVisible(true);
        this.mathTextField.setEnabled(false);
        this.mathTextField.updateUI();
    }

    public void createColoredHTML() {
        int w = 0;
        w = this.parent != null ? this.getWidth() - 8 : 300;
        String str = this.mathTextField.getText();
        if (!str.equals("")) {
            StringBuffer html = new StringBuffer("<html><table width=\"" + w + "\" border=\"0\" bordercolor=\"#FFFF00\">");
            if (this.ckbName.isSelected()) {
                html.append("<tr bgcolor=\"#EBEBE4\">");
            } else {
                html.append("<tr bgcolor=\"WHITE\">");
            }
            if (str.length() < 43) {
                html.append("<font size=\"3\">");
            } else if (str.length() < 86) {
                html.append("<font size=\"2\">");
            } else {
                html.append("<font size=\"1\">");
            }
            char[] chars = str.toCharArray();
            boolean isID = false;
            int startIndex = 0;
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (isID) {
                    if (!MathEditPanel.isChar(c) && !MathEditPanel.isDigit(c)) {
                        isID = false;
                        String id = str.substring(startIndex, i);
                        html.append("<font color=\"#" + this.getColor(id) + "\">" + this.getID(id));
                        html.append("<font color=\"BLACK\">" + c);
                    }
                } else if (!MathEditPanel.isChar(c) && !MathEditPanel.isDigit(c)) {
                    html.append("<font color=\"BLACK\">" + c);
                } else {
                    isID = true;
                    startIndex = i;
                }
                ++i;
            }
            if (isID) {
                String id = str.substring(startIndex, chars.length);
                html.append("<font color=\"#" + this.getColor(id) + "\">" + this.getID(id));
            }
            html.append("</font></tr></table></html>");
            this.mathTextFieldFakeLabel.setText(html.toString());
            this.mathTextFieldFakeLabel.setBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)));
        }
    }

    private String getColor(String id) {
        ReactionDialog rr = (ReactionDialog)this.parent.getParent();
        Reaction target = (Reaction)rr.getObject();
        int i = 0;
        while ((long)i < target.getNumReactants()) {
            if (target.getReactant(id) != null) {
                return this.getWebColor(Color.RED);
            }
            ++i;
        }
        i = 0;
        while ((long)i < target.getNumProducts()) {
            if (target.getProduct(id) != null) {
                return this.getWebColor(Color.BLUE);
            }
            ++i;
        }
        i = 0;
        while ((long)i < target.getNumModifiers()) {
            if (target.getModifier(id) != null) {
                return this.getWebColor(Color.GREEN);
            }
            ++i;
        }
        return this.getWebColor(Color.BLACK);
    }

    private String getWebColor(Color color) {
        String webColor = "";
        String str = "0" + Integer.toHexString(color.getRed());
        webColor = String.valueOf(webColor) + str.substring(str.length() - 2);
        str = "0" + Integer.toHexString(color.getGreen());
        webColor = String.valueOf(webColor) + str.substring(str.length() - 2);
        str = "0" + Integer.toHexString(color.getBlue());
        webColor = String.valueOf(webColor) + str.substring(str.length() - 2);
        return webColor;
    }

    private String getID(String id) {
        if (this.ckbName.isSelected()) {
            return LibSBMLUtil.replaceName(id);
        }
        return id;
    }

    private static boolean isChar(char c) {
        int i = 0;
        while (i < CHARS.length) {
            if (CHARS[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isDigit(char c) {
        int i = 0;
        while (i < DIGITS.length) {
            if (DIGITS[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void resetNameCheckBox() {
        this.ckbName.setSelected(false);
    }

    public void resetMathCheckBox() {
        this.ckbMath.setSelected(false);
    }

    public KineticLawDialog getParentKineticLawDialog() {
        return this.parent;
    }

    void actionPerformed_mathCheckBox() {
        this.setDisplay();
    }

    void actionPerformed_nameCheckBox() {
        this.setDisplay();
    }

    public void setDisplay() {
        if (this.mathTextField == null || "".equals(this.mathTextField.getText().trim())) {
            this.setDisplayEmpty();
        } else if (this.ckbMath.isSelected()) {
            this.setDisplayImage();
            this.getFormulaImage();
        } else {
            this.setDisplayHtml();
            this.getColoredHtml();
        }
        if (this.ckbMath.isSelected() || this.ckbName.isSelected()) {
            this.messageLabel.setVisible(true);
        } else {
            this.messageLabel.setVisible(false);
        }
        this.updateUI();
    }

    private void setDisplayHtml() {
        this.mathTextField.setVisible(false);
        this.mathTextFieldFakeLabel.setVisible(true);
        this.imagePanel.setVisible(false);
    }

    private void setDisplayImage() {
        this.mathTextField.setVisible(false);
        this.mathTextFieldFakeLabel.setVisible(false);
        this.imagePanel.setVisible(true);
        this.imagePanel.setBackground(new Color(235, 235, 228));
    }

    private void setDisplayEmpty() {
        if (!this.ckbMath.isSelected() && !this.ckbName.isSelected() && this.parent.getObject() != null) {
            this.mathTextField.setEnabled(true);
        } else {
            this.mathTextField.setEnabled(false);
        }
        this.mathTextField.setVisible(true);
        this.mathTextFieldFakeLabel.setVisible(false);
        this.imagePanel.setVisible(false);
    }

    private void getColoredHtml() {
        try {
            this.createColoredHTML();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void getFormulaImage() {
        try {
            this.convertFormula(this.mathTextField.getText(), "");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private String getNameString(String idString) {
        StringBuffer nameStringBuf = new StringBuffer();
        char[] chars = idString.toCharArray();
        boolean isID = false;
        int startIndex = 0;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (isID) {
                if (!MathEditPanel.isChar(c) && !MathEditPanel.isDigit(c)) {
                    isID = false;
                    String id = idString.substring(startIndex, i);
                    nameStringBuf.append(this.getID(id));
                    nameStringBuf.append(c);
                }
            } else if (!MathEditPanel.isChar(c) && !MathEditPanel.isDigit(c)) {
                nameStringBuf.append(c);
            } else {
                isID = true;
                startIndex = i;
            }
            ++i;
        }
        if (isID) {
            String id = idString.substring(startIndex, chars.length);
            nameStringBuf.append(this.getID(id));
        }
        return nameStringBuf.toString();
    }

    private void diplayImagePanel(org.w3c.dom.Document document) {
        this.jMathCom.setDocument(document);
        this.jMathCom.setDebug(false);
        this.imagePanel.setVisible(true);
        this.imagePanel.add((Component)this.jMathCom);
        this.jMathCom.updateUI();
        this.imagePanel.updateUI();
    }

    public boolean getMathCheckValue() {
        return this.ckbMath.isSelected();
    }

    public void setMathCheckValue(boolean flag) {
        this.ckbMath.setSelected(flag);
    }

    public boolean getNameCheckValue() {
        return this.ckbName.isSelected();
    }

    public void setNameCheckValue(boolean flag) {
        this.ckbName.setSelected(flag);
    }

    public void clearSelectedItemText() {
        if (this.selectedItemText != null) {
            this.selectedItemText.setText("");
        }
    }
}

