/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import jp.sbi.sbml.util.MathEditPanel;

public class MathEditButtonsPanel {
    private static final String PLUS_STR = "+";
    private static final String MINUS_STR = "-";
    private static final String ASTER_STR = "*";
    private static final String SLASH_STR = "/";
    private static final String LEFT_PAREN_STR = "(";
    private static final String RIGHT_PAREN_STR = ")";
    private final String[] strs = new String[]{"+", "-", "*", "/", "(", ")"};
    private HashMap strMapByButton;
    private HashSet buttons;
    private JButton copyButton;
    private JPanel parent;
    private JToggleButton mathButton;

    public MathEditButtonsPanel(JPanel parent, JButton copyButton) {
        if (parent != null && parent instanceof MathEditPanel && ((MathEditPanel)parent).getParentKineticLawDialog() != null) {
            this.MathEditButtonsPanelInKineticLawDialog(parent, copyButton);
            return;
        }
        this.copyButton = copyButton;
        this.parent = parent;
        Rectangle r = copyButton.getBounds();
        int y = r.y;
        int w = r.height;
        int adjustment = 4;
        int dx = w + 2;
        int x = 10;
        this.copyButton.setBounds(x, y, r.width + adjustment, r.height);
        x += r.width + dx - x;
        this.parent.add((Component)copyButton, null);
        copyButton.setEnabled(false);
        this.strMapByButton = new HashMap();
        this.buttons = new HashSet();
        int i = 0;
        while (i < this.strs.length) {
            JButton button = new JButton(this.strs[i]);
            button.setBounds(x, y, w + adjustment + 26, w);
            button.setMargin(new Insets(2, 0, 2, 0));
            button.addActionListener((ActionListener)((Object)parent));
            this.parent.add((Component)button, null);
            x += dx + 28;
            this.strMapByButton.put(button, this.strs[i]);
            this.buttons.add(button);
            ++i;
        }
    }

    public MathEditButtonsPanel(JPanel parent, JButton copyButton, JToggleButton mathButton) {
        this.copyButton = copyButton;
        this.parent = parent;
        this.mathButton = mathButton;
        Rectangle r = copyButton.getBounds();
        int y = r.y;
        int w = r.height;
        int dx = w + 2;
        int x = 3;
        this.copyButton.setBounds(x, y, r.width, r.height);
        x += r.width + dx;
        this.parent.add((Component)copyButton, null);
        copyButton.setEnabled(false);
        r = mathButton.getBounds();
        y = r.y;
        w = r.height;
        dx = w + 2;
        this.mathButton.setBounds(x, y, r.width, r.height);
        x += r.width + dx;
        this.parent.add((Component)mathButton, null);
        mathButton.setEnabled(true);
        this.strMapByButton = new HashMap();
        this.buttons = new HashSet();
        int i = 0;
        while (i < this.strs.length) {
            JButton button = new JButton(this.strs[i]);
            button.setBounds(x, y, w, w);
            button.setMargin(new Insets(2, 2, 2, 2));
            button.addActionListener((ActionListener)((Object)parent));
            this.parent.add((Component)button, null);
            x += dx;
            this.strMapByButton.put(button, this.strs[i]);
            this.buttons.add(button);
            ++i;
        }
    }

    private void MathEditButtonsPanelInKineticLawDialog(JPanel parent, JButton copyButton) {
        this.copyButton = copyButton;
        this.parent = parent;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 1;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.ipadx = 0;
        c.anchor = 10;
        Rectangle r = copyButton.getBounds();
        int y = r.y;
        int w = r.height;
        int dx = w + 2;
        int x = 3;
        this.copyButton.setBounds(x, y, r.width, r.height);
        x += r.width + 2;
        this.copyButton.setPreferredSize(new Dimension(r.width, r.height));
        this.copyButton.setMinimumSize(new Dimension(r.width, r.height));
        c.fill = 10;
        copyButton.setEnabled(false);
        this.strMapByButton = new HashMap();
        this.buttons = new HashSet();
        int i = 0;
        while (i < this.strs.length) {
            JButton button = new JButton(this.strs[i]);
            button.setBounds(x, y, w + 30, w);
            button.setMargin(new Insets(2, 0, 2, 0));
            button.setPreferredSize(new Dimension(w + 30, w));
            button.addActionListener((ActionListener)((Object)parent));
            button.setEnabled(false);
            c.gridx = 2 + i;
            c.ipadx = 5;
            c.anchor = 10;
            buttonPanel.add((Component)button, c);
            x += dx + 30;
            this.strMapByButton.put(button, this.strs[i]);
            this.buttons.add(button);
            ++i;
        }
        c.gridy = 1;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.ipadx = 0;
        c.anchor = 10;
        this.parent.add((Component)buttonPanel, c);
    }

    public String getStringForAction(Object source) {
        try {
            return (String)this.strMapByButton.get(source);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean contains(Component button) {
        return this.buttons.contains(button);
    }

    public void enableButtons(boolean enable) {
        for (JButton button : this.buttons) {
            button.setEnabled(enable);
        }
    }
}

