/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBEventRecorder;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNADialog2;
import jp.sbi.celldesigner.sbmlExtension.GeneDialog2;
import jp.sbi.celldesigner.sbmlExtension.ProteinDialog2;
import jp.sbi.celldesigner.sbmlExtension.RNADialog2;
import jp.sbi.celldesigner.util.CelldUtil;
import jp.sbi.celldesigner.util.ReturnValue;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.CompartmentDialog;
import jp.sbi.sbml.util.ConstraintDialog;
import jp.sbi.sbml.util.EventDialog;
import jp.sbi.sbml.util.FunctionDefinitionDialog;
import jp.sbi.sbml.util.InitialAssignmentDialog;
import jp.sbi.sbml.util.KineticLawDialog;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ParameterDialog;
import jp.sbi.sbml.util.ParameterListPanel;
import jp.sbi.sbml.util.Preference;
import jp.sbi.sbml.util.ReactionDialog;
import jp.sbi.sbml.util.RuleDialog;
import jp.sbi.sbml.util.RuleListPanel;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseDialogListener;
import jp.sbi.sbml.util.SBaseListPanel;
import jp.sbi.sbml.util.SBaseListPanelListener;
import jp.sbi.sbml.util.SpeciesDialog;
import jp.sbi.sbml.util.UnitDefinitionDialog;
import net.sourceforge.jeuclid.swing.JMathComponent;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.CompartmentType;
import org.sbml.libsbml.Constraint;
import org.sbml.libsbml.Event;
import org.sbml.libsbml.EventAssignment;
import org.sbml.libsbml.FunctionDefinition;
import org.sbml.libsbml.InitialAssignment;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfCompartmentTypes;
import org.sbml.libsbml.ListOfCompartments;
import org.sbml.libsbml.ListOfConstraints;
import org.sbml.libsbml.ListOfEvents;
import org.sbml.libsbml.ListOfFunctionDefinitions;
import org.sbml.libsbml.ListOfInitialAssignments;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.ListOfRules;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.ListOfSpeciesTypes;
import org.sbml.libsbml.ListOfUnitDefinitions;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.ModifierSpeciesReference;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.Rule;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesReference;
import org.sbml.libsbml.SpeciesType;
import org.sbml.libsbml.Unit;
import org.sbml.libsbml.UnitDefinition;
import org.sbml.libsbml.libsbml;

public class ListPanel
extends SBaseListPanel {
    public static final int NEW_BUTTON = 0;
    public static final int EDIT_BUTTON = 1;
    public static final int REMOVE_BUTTON = 2;
    public static final int CLEAR_ALL_BUTTON = 3;
    public static final int EXPORT_CSV_BUTTON = 4;
    protected final int SIZE_OF_BUTTONS = 5;
    protected boolean bCallMeInDoubleClickingEdited = false;
    protected SBaseDialog elementDlg;
    private boolean isFirstShowing = true;
    private MySBaseDialogListener elementDlgListener;
    protected JScrollPane scrollPane;
    private JButton newButton;
    protected JButton editButton;
    protected JButton removeButton;
    protected JButton clearButton;
    private JToggleButton jtoggleButton = new JToggleButton();
    protected JButton exportCSVButton;
    private static final String SELECTED = "Species ID";
    private static final String UNSELECTED = "Species Name";
    protected JPanel buttonPanel;
    protected boolean isShowDialog = true;
    protected String SORT_STATUS = "";
    protected static final int DEFAULT_PANEL_WIDTH = 600;
    protected boolean[] buttonFlag = new boolean[5];

    public void setLisDialogVisiable(boolean value) {
        this.isDialogVisiable = value;
    }

    public TableColumnModel getColumnModel() {
        return this.table.getColumnModel();
    }

    @Override
    public void valueSettedToCell(Object settedvalue, int rowIndex, int columnIndex) {
        SBaseDialog dlg;
        SBase base = this.sbaseList.get((long)rowIndex);
        this.elementDlg.setObject(base);
        this.elementDlg.updateDialog();
        int iLitsChangedItemPtr = -1;
        if (this instanceof ParameterListPanel && this.bCallMeInDoubleClickingEdited) {
            try {
                int iListTotalCnt = (int)this.sbaseList.size();
                JTableHeader header = this.table.getTableHeader();
                TableColumnModel columnmodel = header.getColumnModel();
                int scopeindex = columnmodel.getColumnIndex("scope");
                int idindex = columnmodel.getColumnIndex("id");
                int nameindex = columnmodel.getColumnIndex("name");
                int valueindex = columnmodel.getColumnIndex("value");
                int unitsindex = columnmodel.getColumnIndex("units");
                int constantindex = columnmodel.getColumnIndex("constant");
                String tblScope = (String)this.table.getValueAt(rowIndex, scopeindex);
                String tblId = (String)this.table.getValueAt(rowIndex, idindex);
                String tblName = (String)this.table.getValueAt(rowIndex, nameindex);
                String tblValue = (String)this.table.getValueAt(rowIndex, valueindex);
                String tblUnits = (String)this.table.getValueAt(rowIndex, unitsindex);
                String tblConstant = (String)this.table.getValueAt(rowIndex, constantindex);
                int j = 0;
                while (j < iListTotalCnt) {
                    Parameter tmpParam = (Parameter)this.sbaseList.get((long)j);
                    String tmpScope = LibSBMLUtil.getParameterScope(tmpParam);
                    String tmpId = tmpParam.getId();
                    String tmpName = tmpParam.getName();
                    String tmpValue = LibSBMLUtil.trimDecimalEndZeroToString(tmpParam.getValue());
                    String tmpUnits = tmpParam.getUnits();
                    String tmpConstant = "" + tmpParam.getConstant();
                    if (tmpScope.equals(tblScope) && tmpId.equals(tblId) && tmpName.equals(tblName) && tmpValue.equals(tblValue) && tmpUnits.equals(tblUnits) && tmpConstant.equals(tblConstant)) {
                        iLitsChangedItemPtr = j;
                        break;
                    }
                    ++j;
                }
                if (iLitsChangedItemPtr == -1) {
                    JOptionPane.showMessageDialog(this, "The data which you selected is not in system.", "System Error Message", 0);
                    return;
                }
                base = (Parameter)this.sbaseList.get((long)iLitsChangedItemPtr);
                this.elementDlg.setObject(base);
                this.elementDlg.updateDialog();
            }
            catch (Exception iListTotalCnt) {
                // empty catch block
            }
        }
        String val = (String)settedvalue;
        if (this.elementDlg instanceof CompartmentDialog) {
            int nameindex = 1;
            int volumeindex = 4;
            int unitindex = 5;
            String volume = (String)this.table.getValueAt(rowIndex, volumeindex);
            String unit = (String)this.table.getValueAt(rowIndex, unitindex);
            if (columnIndex == nameindex) {
                this.mainwindowaccess.getCurrentModel().editIdentityDialog(val);
            } else {
                if (columnIndex == volumeindex) {
                    Compartment compartment;
                    if (base instanceof Compartment && !Double.isNaN((compartment = (Compartment)base).getSize())) {
                        volume = val;
                    }
                } else if (columnIndex == unitindex) {
                    unit = val;
                }
                CompartmentDialog dlg2 = (CompartmentDialog)this.elementDlg;
                dlg2.setDialogByArg(volume, unit);
                if (!this.elementDlg.update_actionPerformed()) {
                    this.table.setRowSelectionInterval(rowIndex, rowIndex);
                    this.tableedited = true;
                }
            }
        } else if (this.elementDlg instanceof SpeciesDialog) {
            int initialamountindex = 6;
            int chargeindex = 11;
            String initialamount = (String)this.table.getValueAt(rowIndex, initialamountindex);
            String charge = (String)this.table.getValueAt(rowIndex, chargeindex);
            if (columnIndex == initialamountindex) {
                initialamount = val;
            } else if (columnIndex == chargeindex) {
                charge = val;
            }
            SpeciesDialog dlg3 = (SpeciesDialog)this.elementDlg;
            dlg3.setDialogByArg(initialamount, "", charge);
            if (!this.elementDlg.update_actionPerformed()) {
                this.table.setRowSelectionInterval(rowIndex, rowIndex);
                this.tableedited = true;
            }
        } else if (this.elementDlg instanceof ProteinDialog2) {
            dlg = (ProteinDialog2)this.elementDlg;
            ((ProteinDialog2)dlg).setDialogByArg(val);
            if (!((ProteinDialog2)dlg).update_actionPerformed()) {
                this.table.setRowSelectionInterval(rowIndex, rowIndex);
                this.tableedited = true;
            }
        } else if (this.elementDlg instanceof GeneDialog2) {
            dlg = (GeneDialog2)this.elementDlg;
            ((GeneDialog2)dlg).setDialogByArg(val);
            if (!((GeneDialog2)dlg).update_actionPerformed()) {
                this.table.setRowSelectionInterval(rowIndex, rowIndex);
                this.tableedited = true;
            }
        } else if (this.elementDlg instanceof RNADialog2) {
            dlg = (RNADialog2)this.elementDlg;
            ((RNADialog2)dlg).setDialogByArg(val);
            if (!((RNADialog2)dlg).update_actionPerformed()) {
                this.table.setRowSelectionInterval(rowIndex, rowIndex);
                this.tableedited = true;
            }
        } else if (this.elementDlg instanceof AntiSenseRNADialog2) {
            dlg = (AntiSenseRNADialog2)this.elementDlg;
            ((AntiSenseRNADialog2)dlg).setDialogByArg(val);
            if (!((AntiSenseRNADialog2)dlg).update_actionPerformed()) {
                this.table.setRowSelectionInterval(rowIndex, rowIndex);
                this.tableedited = true;
            }
        } else if (this.elementDlg instanceof ReactionDialog) {
            this.mainwindowaccess.getCurrentModel().editIdentityDialog(val);
        } else if (this.elementDlg instanceof UnitDefinitionDialog) {
            dlg = (UnitDefinitionDialog)this.elementDlg;
            int idindex = 0;
            int nameindex = 1;
            String id = (String)this.table.getValueAt(rowIndex, idindex);
            String name = (String)this.table.getValueAt(rowIndex, nameindex);
            if (columnIndex == idindex && id != null && (id.equals("substance") || id.equals("volume") || id.equals("area") || id.equals("length") || id.equals("time"))) {
                return;
            }
            if (columnIndex == idindex) {
                id = val;
            } else if (columnIndex == nameindex) {
                name = val;
            }
            ((UnitDefinitionDialog)dlg).setDialogByArg(id, name);
            if (!this.elementDlg.update_actionPerformed()) {
                this.table.setRowSelectionInterval(rowIndex, rowIndex);
                this.tableedited = true;
            }
        } else if (this.elementDlg instanceof ParameterDialog) {
            dlg = (ParameterDialog)this.elementDlg;
            JTableHeader header = this.table.getTableHeader();
            TableColumnModel columnmodel = header.getColumnModel();
            int scopeindex = columnmodel.getColumnIndex("scope");
            int idindex = columnmodel.getColumnIndex("id");
            int nameindex = columnmodel.getColumnIndex("name");
            int valueindex = columnmodel.getColumnIndex("value");
            int unitsindex = columnmodel.getColumnIndex("units");
            int constantindex = columnmodel.getColumnIndex("constant");
            String id = (String)this.table.getValueAt(rowIndex, idindex);
            String name = (String)this.table.getValueAt(rowIndex, nameindex);
            String value = (String)this.table.getValueAt(rowIndex, valueindex);
            String units = (String)this.table.getValueAt(rowIndex, unitsindex);
            if (columnIndex == idindex) {
                id = val;
            } else if (columnIndex == nameindex) {
                name = val;
            } else if (columnIndex == valueindex) {
                value = val;
            } else if (columnIndex == unitsindex) {
                units = val;
            }
            ((ParameterDialog)dlg).setDialogByArg(id, name, value, units);
            try {
                try {
                    ((ParameterDialog)dlg).bCallMeWithRowID = true;
                    ((ParameterDialog)dlg).iSelectedRowID = iLitsChangedItemPtr;
                    Parameter parameter = new Parameter();
                    ((ParameterDialog)dlg).setObjectFromDialog((SBase)parameter);
                    ((ParameterDialog)dlg).setObjectFromDialog(((ParameterDialog)dlg).editingSBase);
                    if (!dlg.update_actionPerformed()) {
                        this.table.setRowSelectionInterval(rowIndex, rowIndex);
                        this.tableedited = true;
                    }
                    MainWindow.getLastInstance().getCurrentModel().getSBModel().getSBMLPanelLists().getSBaseListPanel(4).updateDialog();
                }
                catch (Exception exception) {
                    ((ParameterDialog)dlg).bCallMeWithRowID = false;
                }
            }
            finally {
                ((ParameterDialog)dlg).bCallMeWithRowID = false;
            }
        }
    }

    public ListPanel() {
        this.initPanel();
        this.initButtonFlag();
    }

    public ListPanel(boolean isShowDialog) {
        this.isShowDialog = isShowDialog;
        this.initPanel();
        this.initButtonFlag();
    }

    protected void table_mouseClicked(MouseEvent e) {
        if ((this.sbaseList instanceof ListOfFunctionDefinitions || this.sbaseList instanceof ListOfUnitDefinitions || this.sbaseList instanceof ListOfRules || this.sbaseList instanceof ListOfEvents || this.sbaseList instanceof ListOfSpeciesTypes || this.sbaseList instanceof ListOfCompartmentTypes || this.sbaseList instanceof ListOfInitialAssignments || this.sbaseList instanceof ListOfConstraints) && SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        if (e.getClickCount() == 2) {
            if (!this.isShowDialog) {
                return;
            }
            if (this.editButton.isEnabled()) {
                this.editButton_actionPerformed();
            }
        } else {
            SBase[] selected = this.getSelectedElements();
            if (selected.length == 0) {
                Vector list = (Vector)this.listeners.clone();
                int i = 0;
                while (i < list.size()) {
                    SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i);
                    listener.elementsDeselectedByList();
                    ++i;
                }
            }
        }
    }

    protected void tableMousePressed(MouseEvent e) {
        if ((this.sbaseList instanceof ListOfFunctionDefinitions || this.sbaseList instanceof ListOfUnitDefinitions || this.sbaseList instanceof ListOfRules || this.sbaseList instanceof ListOfEvents || this.sbaseList instanceof ListOfSpeciesTypes || this.sbaseList instanceof ListOfCompartmentTypes || this.sbaseList instanceof ListOfInitialAssignments || this.sbaseList instanceof ListOfConstraints) && SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        if (this.sbaseList instanceof ListOf && MainWindow.isFocusedKineticLaw() && SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        int pressedRow = this.table.rowAtPoint(e.getPoint());
        if (pressedRow >= 0) {
            SBase sb = this.sbaseList.get((long)pressedRow);
            Vector list = (Vector)this.listeners.clone();
            int i = 0;
            while (i < list.size()) {
                SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i);
                listener.elementMousePressed(sb);
                ++i;
            }
        }
    }

    protected void initPanel() {
        this.newButton = new JButton("New");
        this.newButton.setMargin(SBaseListPanel.buttonInsets);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPanel.this.newButton_actionPerformed(e);
            }
        });
        this.editButton = new JButton("Edit");
        this.editButton.setMargin(SBaseListPanel.buttonInsets);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPanel.this.editButton_actionPerformed();
            }
        });
        this.removeButton = new JButton("Remove");
        this.removeButton.setMargin(SBaseListPanel.buttonInsets);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListPanel.this.elementDlg != null && ListPanel.this.elementDlg instanceof ParameterDialog && ListPanel.this.elementDlg.getParent() instanceof KineticLawDialog) {
                    ListPanel.this.removeTableList();
                    return;
                }
                ListPanel.this.removeButton_actionPerformed();
            }
        });
        this.clearButton = new JButton("Clear All");
        this.clearButton.setMargin(SBaseListPanel.buttonInsets);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListPanel.this.elementDlg != null && ListPanel.this.elementDlg instanceof ParameterDialog && ListPanel.this.elementDlg.getParent() instanceof KineticLawDialog) {
                    ListPanel.this.clearTableList();
                    return;
                }
                ListPanel.this.clearButton_actionPerformed();
            }
        });
        this.jtoggleButton.setText(SELECTED);
        this.jtoggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ListPanel.this.actionPerformed_jtoggleButton();
            }
        });
        this.exportCSVButton = new JButton("Export");
        this.exportCSVButton.setMargin(SBaseListPanel.buttonInsets);
        this.exportCSVButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPanel.this.exportCSVButton_actionPerformed();
            }
        });
        this.buttonPanel = new JPanel(){

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        if (this.isShowDialog) {
            this.buttonPanel.add(this.newButton);
            this.buttonPanel.add(this.editButton);
            this.buttonPanel.add(this.removeButton);
            this.buttonPanel.add(this.clearButton);
            this.buttonPanel.add(this.jtoggleButton);
            this.buttonPanel.add(this.exportCSVButton);
        }
        this.keyListener = new SBaseListPanel.MyKeyListener(this);
        this.addKeyListener(this.keyListener);
        this.table = new JTable(){

            @Override
            public boolean isManagingFocus() {
                return false;
            }
        };
        this.table.setAutoResizeMode(0);
        this.scrollPane = new JScrollPane(this.table){

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.scrollPane.setAutoscrolls(true);
        this.selectionListener = new SBaseListPanel.MyListSelectionListener(this);
        this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.table.addMouseListener(new ListPanel_mouseAdapter(this));
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonPanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.setSize(new Dimension(611, 240));
        this.changeButtonsEnability();
    }

    @Override
    public SBaseDialog getElementDialog() {
        return this.elementDlg;
    }

    @Override
    public SBaseDialog getElementDialog(int element_const) {
        return null;
    }

    @Override
    public void setElementDialog(SBaseDialog dialog) {
        if (dialog == null) {
            return;
        }
        this.elementDlg = dialog;
        this.elementDlgListener = new MySBaseDialogListener();
        this.elementDlg.addSBaseDialogListener(this.elementDlgListener);
        this.setElementDialogMode(this.elementDlgMode);
        SBase sbase = this.elementDlg.createInitialObject();
        this.initTableModel(sbase);
        this.changeButtonsEnability();
    }

    @Override
    public void setElementDialog(SBaseDialog dialog, int i) {
    }

    @Override
    public void setElementDialogMode(int mode) {
        this.elementDlgMode = mode;
        if (this.elementDlg != null) {
            if (this.elementDlgMode == 1) {
                this.elementDlg.setModal(true);
            } else {
                this.elementDlg.setModal(false);
            }
            if (this.elementDlg.hasChildListDialog()) {
                this.elementDlg.setChildDialogMode(mode);
            }
        }
    }

    @Override
    public void setSelfOperational(boolean isOperational) {
        ListPanel c = this;
        boolean hasAdded = false;
        Component[] comp = c.getComponents();
        int i = 0;
        while (i < comp.length) {
            if (comp[i] == this.buttonPanel) {
                hasAdded = true;
            }
            ++i;
        }
        if (isOperational && !hasAdded) {
            c.add((Component)this.buttonPanel, "South");
        } else if (!isOperational && hasAdded) {
            c.remove(this.buttonPanel);
        }
        this.validate();
        if (this.elementDlg != null && this.elementDlg.isShowing()) {
            this.elementDlg.setVisible(false);
        }
        this.isSelfOperational = isOperational;
    }

    @Override
    public void setSBaseList(ListOf sbaseList) {
        this.sbaseList = sbaseList;
        if (this.elementDlg != null) {
            this.elementDlg.setNewObject();
            this.elementDlg.updateDialog();
        }
        this.updateDialog();
    }

    @Override
    public void releaseAll() {
        this.sbaseList = null;
        if (this.elementDlg != null) {
            this.elementDlg.removeSBaseDialogListener(this.elementDlgListener);
            this.elementDlg = null;
        }
        this.elementDlgListener = null;
        this.table.getSelectionModel().removeListSelectionListener(this.selectionListener);
        this.selectionListener = null;
        this.removeKeyListener(this.keyListener);
        this.keyListener = null;
        this.listeners.clear();
        this.listeners = null;
    }

    @Override
    public void disableChildDialog() {
        this.elementDlg.setObject(null);
        this.elementDlg.updateDialog();
    }

    @Override
    public void setButtonVisible(int button_const, boolean isVisible) {
        this.buttonPanel.remove(this.newButton);
        this.buttonPanel.remove(this.editButton);
        this.buttonPanel.remove(this.removeButton);
        this.buttonPanel.remove(this.clearButton);
        if (!this.getName().equals("Reactions")) {
            this.buttonPanel.remove(this.jtoggleButton);
        }
        this.buttonPanel.remove(this.exportCSVButton);
        this.buttonFlag[button_const] = isVisible;
        int i = 0;
        while (i < 5) {
            if (this.buttonFlag[i]) {
                if (i == 0) {
                    this.buttonPanel.add(this.newButton);
                } else if (i == 1) {
                    this.buttonPanel.add(this.editButton);
                } else if (i == 2) {
                    this.buttonPanel.add(this.removeButton);
                } else if (i == 3) {
                    this.buttonPanel.add(this.clearButton);
                } else if (i == 4) {
                    this.buttonPanel.add(this.exportCSVButton);
                }
            }
            ++i;
        }
        this.validate();
        this.repaint();
    }

    public void setJTobggleButtonVisible(boolean boo) {
        this.jtoggleButton.setVisible(boo);
        this.buttonPanel.remove(this.jtoggleButton);
    }

    @Override
    protected void changeButtonsEnability() {
        this.newButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.exportCSVButton.setEnabled(false);
        if (this.sbaseList == null) {
            return;
        }
        if (this.elementDlg != null) {
            this.newButton.setEnabled(true);
            this.exportCSVButton.setEnabled(true);
        }
        if (this.sbaseList.size() > 0L) {
            this.clearButton.setEnabled(true);
            int[] index = this.table.getSelectedRows();
            if (index.length > 0) {
                SBase[] selected;
                this.removeButton.setEnabled(true);
                if (this.elementDlg != null && index.length == 1) {
                    try {
                        Object obj = null;
                        if (this.getName().toLowerCase().equals("species") ? (obj = this.getValueAt(this.table.getSelectedRows()[0], "class")) != null && obj instanceof String && ((String)obj).toUpperCase().equals("TAG".toUpperCase()) : this.getName().toLowerCase().equals("reactions") && (obj = this.getValueAt(this.table.getSelectedRows()[0], "type")) != null && obj instanceof String && ((String)obj).toUpperCase().equals("DIRECT_SINGLE_LINE".toUpperCase())) {
                            return;
                        }
                    }
                    catch (Exception obj) {
                        // empty catch block
                    }
                    selected = this.getSelectedElements();
                    if (selected != null && selected.length == 1) {
                        this.editButton.setEnabled(true);
                    }
                }
                if (this.getName().toLowerCase().equals("parameters")) {
                    selected = this.getSelectedElements();
                    if (selected.length == 0) {
                        this.removeButton.setEnabled(false);
                    }
                } else if (this.getName().toLowerCase().equals("unitdefinitions")) {
                    selected = this.getSelectedElements();
                    int cnt = 0;
                    while (cnt < selected.length) {
                        String strSId;
                        SBase sBase = selected[cnt];
                        if (sBase instanceof UnitDefinition && ("substance".equals(strSId = sBase.getId()) || "volume".equals(strSId) || "area".equals(strSId) || "length".equals(strSId) || "time".equals(strSId))) {
                            this.removeButton.setEnabled(false);
                            break;
                        }
                        ++cnt;
                    }
                }
            }
            if (this.getName().toLowerCase().equals("unitdefinitions") && this.sbaseList.size() <= 5L) {
                this.clearButton.setEnabled(false);
            }
        }
    }

    @Override
    protected void changeElementDialogEnability() {
        int[] index = this.table.getSelectedRows();
        if (index.length <= 0) {
            return;
        }
        if (this.elementDlg != null && this.elementDlg.isShowing()) {
            if (index.length != 1) {
                this.elementDlg.setObject(null);
                this.elementDlg.updateDialog();
            } else {
                try {
                    Object obj = null;
                    if (this.getName().toLowerCase().equals("species")) {
                        obj = this.getValueAt(this.table.getSelectedRows()[0], "class");
                        if (obj != null && obj instanceof String && ((String)obj).toUpperCase().equals("TAG".toUpperCase())) {
                            this.elementDlg.setObject(null);
                            this.elementDlg.updateDialog();
                            return;
                        }
                    } else if (this.getName().toLowerCase().equals("reactions") && (obj = this.getValueAt(this.table.getSelectedRows()[0], "type")) != null && obj instanceof String && ((String)obj).toUpperCase().equals("DIRECT_SINGLE_LINE".toUpperCase())) {
                        this.elementDlg.setObject(null);
                        this.elementDlg.updateDialog();
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.elementDlg.setObject(this.getLastSelectedElement());
                this.elementDlg.updateDialog();
            }
        }
    }

    @Override
    protected void updateChildDialog() {
        if (this.elementDlg != null) {
            this.elementDlg.updateDialog();
        }
    }

    protected void showElementDialog() {
        if (this.elementDlg != null) {
            if (this.isFirstShowing) {
                int x = 200;
                int y = 150;
                this.elementDlg.setLocation(x, y);
                this.isFirstShowing = false;
            }
            this.elementDlg.show();
        }
    }

    protected void newButton_actionPerformed(ActionEvent e) {
        if (this.sbaseList == null || this.elementDlg == null) {
            return;
        }
        this.table.clearSelection();
        this.elementDlg.setNewObject();
        this.elementDlg.updateDialog();
        this.showElementDialog();
    }

    protected void editButton_actionPerformed() {
        if (this.sbaseList == null || this.elementDlg == null) {
            return;
        }
        SBase[] selected = this.getSelectedElements();
        if (selected.length == 1 && this.elementDlg != null) {
            try {
                Object obj = null;
                if (this.getName().toLowerCase().equals("species") ? (obj = this.getValueAt(this.table.getSelectedRows()[0], "class")) != null && obj instanceof String && ((String)obj).toUpperCase().equals("TAG".toUpperCase()) : this.getName().toLowerCase().equals("reactions") && (obj = this.getValueAt(this.table.getSelectedRows()[0], "type")) != null && obj instanceof String && ((String)obj).toUpperCase().equals("DIRECT_SINGLE_LINE".toUpperCase())) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isDialogVisiable = true;
            this.elementDlg.setParentListPanel(this);
            this.elementDlg.setObject(selected[0]);
            this.elementDlg.updateDialog();
            this.showElementDialog();
        }
    }

    public void editButton_action() {
        this.editButton_actionPerformed();
    }

    @Override
    protected void removeButton_actionPerformed() {
        if (this.sbaseList == null) {
            return;
        }
        SBModel sbmodel = null;
        Model model = null;
        try {
            sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            model = sbmodel.getModel();
            if (model == null) {
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        if (MainWindow.getLastInstance() != null && MainWindow.getLastInstance().getTargetControlPanelWindow() != null) {
            String msg = "It becomes impossible to take ControlPanel and adjustment.\nControlPanel is shutdown. Is it all right?";
            int rtn = JOptionPane.showConfirmDialog(null, msg);
            if (rtn != 0) {
                return;
            }
            MainWindow win = MainWindow.getLastInstance();
            win.removeListOfCP(win.getTargetControlPanelWindow());
        }
        int[] index = this.table.getSelectedRows();
        SBase[] selected = this.getSelectedElements();
        if (selected != null && selected.length > 0) {
            int i;
            block34: {
                Vector<String> vectSelectedId = new Vector<String>();
                if (selected[0] instanceof SpeciesType || selected[0] instanceof CompartmentType || selected[0] instanceof UnitDefinition) {
                    int i2 = 0;
                    while (i2 < selected.length) {
                        String sid = selected[i2].getId();
                        if (sid != null) {
                            vectSelectedId.add(new String(sid));
                        }
                        ++i2;
                    }
                }
                String TITLE = "Warning";
                String message = "Are you sure to REMOVE.";
                if (selected[0] instanceof UnitDefinition) {
                    ReturnValue rtn = ListPanel.checkOrupdateOfUnitDefinitionID(model, vectSelectedId, "", false);
                    if (rtn == null || rtn.bError || !rtn.bSuccess && !rtn.bYesConfirmed) {
                        return;
                    }
                    if (rtn.bSuccess && JOptionPane.showConfirmDialog(null, message, TITLE, 0) != 0) {
                        return;
                    }
                } else if (JOptionPane.showConfirmDialog(null, message, TITLE, 0) != 0) {
                    return;
                }
                if (this.elementDlg instanceof EventDialog) {
                    ((EventDialog)this.elementDlg).initAndColoseAllOfDialogs();
                } else if (this.elementDlg instanceof FunctionDefinitionDialog || this.elementDlg instanceof UnitDefinitionDialog || this.elementDlg instanceof ParameterDialog || this.elementDlg instanceof InitialAssignmentDialog || this.elementDlg instanceof ConstraintDialog || this.elementDlg instanceof RuleDialog) {
                    this.elementDlg.cancelDialog();
                }
                int i3 = 0;
                while (i3 < selected.length) {
                    LibSBMLUtil.removeSBase(selected[i3], this.sbaseList);
                    MainWindow.getLastInstance().SBaseDeleted(selected[i3]);
                    ++i3;
                }
                try {
                    String type;
                    if (selected[0] instanceof SpeciesType) {
                        ListOfSpecies list = model.getListOfSpecies();
                        if (list == null || list.size() <= 0L) break block34;
                        i = 0;
                        while ((long)i < list.size()) {
                            try {
                                Species sp = (Species)list.get((long)i);
                                type = sp.getSpeciesType();
                                if (type != null && vectSelectedId.contains(type)) {
                                    sp.setSpeciesType("");
                                }
                            }
                            catch (Exception sp) {
                                // empty catch block
                            }
                            ++i;
                        }
                        break block34;
                    }
                    if (selected[0] instanceof CompartmentType) {
                        ListOfCompartments list = model.getListOfCompartments();
                        if (list == null || list.size() <= 0L) break block34;
                        i = 0;
                        while ((long)i < list.size()) {
                            try {
                                Compartment c = (Compartment)list.get((long)i);
                                type = c.getCompartmentType();
                                if (type != null && vectSelectedId.contains(type)) {
                                    c.setCompartmentType("");
                                }
                            }
                            catch (Exception c) {
                                // empty catch block
                            }
                            ++i;
                        }
                        break block34;
                    }
                    if (selected[0] instanceof UnitDefinition) {
                        ListPanel.checkOrupdateOfUnitDefinitionID(model, vectSelectedId, "", true);
                    }
                }
                catch (Exception list) {
                    // empty catch block
                }
            }
            Vector list = (Vector)this.listeners.clone();
            i = 0;
            while (i < list.size()) {
                SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i);
                listener.elementsRemoved(selected, index);
                ++i;
            }
        } else {
            return;
        }
        this.updateDialog();
        MainWindow.getLastInstance().getCurrentModel().setHasAnySBaseChangedFlg(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void clearButton_actionPerformed() {
        int i;
        int[] index;
        SBase[] removed;
        block35: {
            if (this.sbaseList == null) {
                return;
            }
            SBModel sbmodel = null;
            Model model = null;
            try {
                sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
                model = sbmodel.getModel();
                if (model == null) {
                    return;
                }
            }
            catch (Exception ex) {
                return;
            }
            removed = LibSBMLUtil.toArray(this.sbaseList);
            if (removed == null || removed.length <= 0) {
                return;
            }
            int[] indexTmp = new int[removed.length];
            index = new int[removed.length];
            int i2 = 0;
            while (i2 < index.length) {
                index[i2] = i2;
                ++i2;
            }
            int iInit = -1;
            int i3 = 0;
            while (i3 < indexTmp.length) {
                indexTmp[i3] = -1;
                ++i3;
            }
            String TITLE = "Warning";
            String message = "Are you sure to CLEAR ALL.";
            Vector<String> vectSelectedId = new Vector<String>();
            if (removed[0] instanceof UnitDefinition) {
                SBase[] realremove = new SBase[removed.length - LibSBMLUtil.strListofBuiltinUnits.length];
                int realremoveIndex = 0;
                int cnt = 0;
                while (cnt < removed.length) {
                    SBase sBase = removed[cnt];
                    String strSId = sBase.getId();
                    if (!("substance".equals(strSId) || "volume".equals(strSId) || "area".equals(strSId) || "length".equals(strSId) || "time".equals(strSId))) {
                        realremove[realremoveIndex++] = sBase;
                        indexTmp[cnt] = cnt;
                    }
                    ++cnt;
                }
                removed = realremove;
                if (removed.length <= 0) return;
                index = new int[removed.length];
                int i4 = 0;
                int j = 0;
                while (i4 < indexTmp.length) {
                    if (indexTmp[i4] != -1) {
                        index[j++] = indexTmp[i4];
                    }
                    ++i4;
                }
                i4 = 0;
                while (i4 < removed.length) {
                    String strid = removed[i4].getId();
                    if (strid != null) {
                        vectSelectedId.add(new String(strid));
                    }
                    ++i4;
                }
                ReturnValue rtn = ListPanel.checkOrupdateOfUnitDefinitionID(model, vectSelectedId, "", false);
                if (rtn == null || rtn.bError || !rtn.bSuccess && !rtn.bYesConfirmed) {
                    return;
                }
                if (rtn.bSuccess && JOptionPane.showConfirmDialog(null, message, TITLE, 0) != 0) {
                    return;
                }
            } else if (JOptionPane.showConfirmDialog(null, message, TITLE, 0) != 0) {
                return;
            }
            if (this.elementDlg instanceof EventDialog) {
                ((EventDialog)this.elementDlg).initAndColoseAllOfDialogs();
            } else if (this.elementDlg instanceof FunctionDefinitionDialog || this.elementDlg instanceof UnitDefinitionDialog || this.elementDlg instanceof ParameterDialog || this.elementDlg instanceof InitialAssignmentDialog || this.elementDlg instanceof ConstraintDialog || this.elementDlg instanceof RuleDialog) {
                this.elementDlg.cancelDialog();
            }
            int i5 = 0;
            while (i5 < removed.length) {
                LibSBMLUtil.removeSBase(removed[i5], this.sbaseList);
                MainWindow.getLastInstance().SBaseDeleted(removed[i5]);
                ++i5;
            }
            try {
                if (removed[0] instanceof SpeciesType) {
                    ListOfSpecies list = model.getListOfSpecies();
                    if (list == null || list.size() <= 0L) break block35;
                    i = 0;
                    while ((long)i < list.size()) {
                        try {
                            Species sp = (Species)list.get((long)i);
                            sp.setSpeciesType("");
                        }
                        catch (Exception sp) {
                            // empty catch block
                        }
                        ++i;
                    }
                    break block35;
                }
                if (removed[0] instanceof CompartmentType) {
                    ListOfCompartments list = model.getListOfCompartments();
                    if (list == null || list.size() <= 0L) break block35;
                    i = 0;
                    while ((long)i < list.size()) {
                        try {
                            Compartment c = (Compartment)list.get((long)i);
                            c.setCompartmentType("");
                        }
                        catch (Exception c) {
                            // empty catch block
                        }
                        ++i;
                    }
                    break block35;
                }
                if (removed[0] instanceof UnitDefinition) {
                    ListPanel.checkOrupdateOfUnitDefinitionID(model, vectSelectedId, "", true);
                }
            }
            catch (Exception list) {
                // empty catch block
            }
        }
        Vector list = (Vector)this.listeners.clone();
        i = 0;
        while (i < list.size()) {
            SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i);
            listener.elementsRemoved(removed, index);
            ++i;
        }
        this.updateDialog();
        if (this.elementDlg != null) {
            this.elementDlg.setObject(null);
            this.elementDlg.updateDialog();
        }
        MainWindow.getLastInstance().getCurrentModel().setHasAnySBaseChangedFlg(true);
    }

    void actionPerformed_jtoggleButton() {
        if (this.jtoggleButton.getText().equals(SELECTED)) {
            this.jtoggleButton.setText(UNSELECTED);
            LibSBMLUtil.isViewSpeciesID = false;
        } else {
            this.jtoggleButton.setText(SELECTED);
            LibSBMLUtil.isViewSpeciesID = true;
        }
        this.updateUI();
    }

    protected void exportCSVButton_actionPerformed() {
        MainWindow.getLastInstance().exportListToCSV();
        String log = "Export List to CSV.";
        SBEventRecorder.addLog(log);
    }

    private void initButtonFlag() {
        int i = 0;
        while (i < 5) {
            this.buttonFlag[i] = true;
            ++i;
        }
    }

    @Override
    protected void initTableModel(SBase sbase) {
        if (sbase == null) {
            return;
        }
        String[] columnNames = LibSBMLUtil.fieldShortNames(sbase);
        int[] columnSizes = LibSBMLUtil.fieldColumnSizes(sbase);
        this.listTableModel = new SBaseListPanel.MyTableModel(this, columnNames, this);
        this.table.setModel(this.listTableModel);
        this.table.getTableHeader().addMouseListener(new TableMouseListener());
        try {
            int dialog_witdh = 0;
            int i = 0;
            while (i < columnSizes.length) {
                TableColumn column = this.table.getColumnModel().getColumn(i);
                if (sbase instanceof Event && "timeUnits".equals(column.getHeaderValue())) {
                    LibSBMLUtil.hideTableColumn(column);
                } else {
                    column.setPreferredWidth(columnSizes[i]);
                    dialog_witdh += columnSizes[i];
                }
                ++i;
            }
            this.setSize(dialog_witdh + 11, this.getSize().height);
            this.validate();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            DebugPrinter.println(1, e.getMessage());
        }
    }

    @Override
    public void showElementDialog(SBase sbase) {
        if (this.sbaseList == null || this.elementDlg == null) {
            return;
        }
        String id = "";
        if (sbase instanceof Species) {
            id = ((Species)sbase).getId();
        } else if (sbase instanceof Reaction) {
            id = ((Reaction)sbase).getId();
        } else if (sbase instanceof Compartment) {
            id = ((Compartment)sbase).getId();
        } else if (sbase instanceof Event) {
            id = ((Event)sbase).getId();
        } else if (sbase instanceof UnitDefinition) {
            id = ((UnitDefinition)sbase).getId();
        } else if (sbase instanceof FunctionDefinition) {
            id = ((FunctionDefinition)sbase).getId();
        } else if (sbase instanceof Parameter) {
            id = ((Parameter)sbase).getId();
        } else if (sbase instanceof SpeciesType) {
            id = ((SpeciesType)sbase).getId();
        } else if (sbase instanceof CompartmentType) {
            id = ((CompartmentType)sbase).getId();
        } else if (sbase instanceof InitialAssignment) {
            id = ((InitialAssignment)sbase).getSymbol();
        } else if (sbase instanceof Constraint) {
            id = libsbml.formulaToString((ASTNode)((Constraint)sbase).getMath());
        }
        int i = 0;
        while ((long)i < this.sbaseList.size()) {
            SBase sb = this.sbaseList.get((long)i);
            String sbid = "";
            if (sb instanceof Species) {
                sbid = ((Species)sb).getId();
            } else if (sb instanceof Reaction) {
                sbid = ((Reaction)sb).getId();
            } else if (sb instanceof Compartment) {
                sbid = ((Compartment)sb).getId();
            } else if (sb instanceof Event) {
                sbid = ((Event)sb).getId();
            } else if (sb instanceof UnitDefinition) {
                sbid = ((UnitDefinition)sb).getId();
            } else if (sb instanceof FunctionDefinition) {
                sbid = ((FunctionDefinition)sb).getId();
            } else if (sb instanceof Parameter) {
                sbid = ((Parameter)sb).getId();
            } else if (sb instanceof SpeciesType) {
                sbid = ((SpeciesType)sb).getId();
            } else if (sb instanceof CompartmentType) {
                sbid = ((CompartmentType)sb).getId();
            } else if (sb instanceof InitialAssignment) {
                sbid = ((InitialAssignment)sb).getSymbol();
            } else if (sb instanceof Constraint) {
                sbid = libsbml.formulaToString((ASTNode)((Constraint)sb).getMath());
            }
            if (sbid.equals(id)) {
                this.selectElement(new int[]{i});
                break;
            }
            ++i;
        }
        this.isDialogVisiable = true;
        this.elementDlg.setParentListPanel(this);
        this.elementDlg.setObject(sbase);
        this.elementDlg.updateDialog();
        this.showElementDialog();
    }

    protected void removeTableList() {
        if (this.sbaseList == null) {
            return;
        }
        if (MainWindow.getLastInstance() != null && MainWindow.getLastInstance().getTargetControlPanelWindow() != null) {
            if (JOptionPane.showConfirmDialog(null, "Do you want to close ControlPanel?", "Confirm", 0) != 0) {
                return;
            }
            MainWindow win = MainWindow.getLastInstance();
            win.removeListOfCP(win.getTargetControlPanelWindow());
        }
        SBase[] selected = this.getSelectedElements();
        KineticLawDialog kwParent = (KineticLawDialog)this.elementDlg.getParent();
        if (selected.length > 0) {
            int i = 0;
            while (i < selected.length) {
                LibSBMLUtil.removeSBase(selected[i], this.sbaseList);
                kwParent.setHaveChangedFlag();
                kwParent.removeParameterID(((Parameter)selected[i]).getId());
                ++i;
            }
            this.updateDialog();
            kwParent.someFieldIsEdited();
        }
    }

    protected void removeButtonActionInKineticLawDialog(Parameter p) {
        if (this.sbaseList == null) {
            return;
        }
        LibSBMLUtil.removeSBase((SBase)p, this.sbaseList);
        MainWindow.getLastInstance().SBaseDeleted((SBase)p);
        Vector list = (Vector)this.listeners.clone();
        int i = 0;
        while (i < list.size()) {
            SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i);
            listener.elementsRemoved(null, null);
            ++i;
        }
        this.updateDialog();
    }

    protected void clearTableList() {
        if (this.sbaseList == null) {
            return;
        }
        SBase[] removed = LibSBMLUtil.toArray(this.sbaseList);
        int[] index = new int[removed.length];
        int i = 0;
        while (i < index.length) {
            index[i] = i;
            LibSBMLUtil.removeSBase(removed[i], this.sbaseList);
            ++i;
        }
        if (index.length > 0) {
            KineticLawDialog kwParent = (KineticLawDialog)this.elementDlg.getParent();
            kwParent.setHaveChangedFlag();
            kwParent.clearParameterID();
            this.updateDialog();
            kwParent.someFieldIsEdited();
        }
    }

    protected void clearButtonActionInKineticLawDialog() {
        if (this.sbaseList == null) {
            return;
        }
        SBase[] removed = LibSBMLUtil.toArray(this.sbaseList);
        int[] index = new int[removed.length];
        int i = 0;
        while (i < index.length) {
            index[i] = i;
            LibSBMLUtil.removeSBase(removed[i], this.sbaseList);
            MainWindow.getLastInstance().SBaseDeleted(removed[i]);
            ++i;
        }
        Vector list = (Vector)this.listeners.clone();
        int i2 = 0;
        while (i2 < list.size()) {
            SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i2);
            listener.elementsRemoved(removed, index);
            ++i2;
        }
        this.updateDialog();
        if (this.elementDlg != null) {
            this.elementDlg.setObject(null);
            this.elementDlg.updateDialog();
        }
    }

    public static int showWarningDialog(String action) {
        String TITLE = "Warning";
        String message = "The data, which you want to " + action + ", have been used " + "\n" + "by [Species] or [Compartments] or [Parameters]." + "\n" + "\n" + "Are you sure to " + action + " them?";
        int value = JOptionPane.showConfirmDialog(null, message, TITLE, 0);
        return value;
    }

    public static ReturnValue checkOrupdateOfUnitDefinitionID(Model model, Vector vectSelectedId, String strNewUnits, boolean update) {
        ListOfCompartments listCompartments;
        ListOfSpecies listSpecies;
        ListOfReactions listofReaction;
        ListOfParameters listParametersfrommodel;
        ParameterListPanel parameterListPanel;
        ListOf listParameters;
        ReturnValue rtn = new ReturnValue();
        if (model == null) {
            rtn.bError = true;
            return rtn;
        }
        if (vectSelectedId == null || vectSelectedId.size() == 0) {
            rtn.bError = true;
            return rtn;
        }
        if (strNewUnits == null) {
            strNewUnits = "";
        }
        if ((listParameters = (parameterListPanel = (ParameterListPanel)MainWindow.getLastInstance().getCurrentModel().getSBModel().getSBMLPanelLists().getSBaseListPanel(4)).getSorterSBaseList()) != null && listParameters.size() > 0L) {
            int i = 0;
            while ((long)i < listParameters.size()) {
                block40: {
                    try {
                        Parameter pam = (Parameter)listParameters.get((long)i);
                        String strUnit = pam.getUnits();
                        if (strUnit == null || !vectSelectedId.contains(strUnit)) break block40;
                        if (update) {
                            if (strNewUnits.equals("")) {
                                pam.setUnits("substance");
                            } else {
                                pam.setUnits(strNewUnits);
                            }
                            break block40;
                        }
                        rtn.bSuccess = false;
                        rtn.bYesConfirmed = ListPanel.showWarningDialog("remove") != 1;
                        return rtn;
                    }
                    catch (Exception pam) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        if ((listParametersfrommodel = model.getListOfParameters()) != null && listParametersfrommodel.size() > 0L) {
            int i = 0;
            while ((long)i < listParametersfrommodel.size()) {
                block41: {
                    try {
                        Parameter pam = (Parameter)listParametersfrommodel.get((long)i);
                        String strUnit = pam.getUnits();
                        if (strUnit == null || !vectSelectedId.contains(strUnit)) break block41;
                        if (update) {
                            if (strNewUnits.equals("")) {
                                pam.setUnits("substance");
                            } else {
                                pam.setUnits(strNewUnits);
                            }
                            break block41;
                        }
                        rtn.bSuccess = false;
                        rtn.bYesConfirmed = ListPanel.showWarningDialog("remove") != 1;
                        return rtn;
                    }
                    catch (Exception pam) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        if ((listofReaction = model.getListOfReactions()) != null && listofReaction.size() > 0L) {
            int i = 0;
            while ((long)i < listofReaction.size()) {
                try {
                    ListOfParameters listofParameterofKineticLaw;
                    Reaction rea = (Reaction)listofReaction.get((long)i);
                    KineticLaw klaw = rea.getKineticLaw();
                    if (klaw != null && (listofParameterofKineticLaw = klaw.getListOfParameters()) != null && listofParameterofKineticLaw.size() > 0L) {
                        int cnt = 0;
                        while ((long)cnt < listofParameterofKineticLaw.size()) {
                            Parameter pamforKin = (Parameter)listofParameterofKineticLaw.get((long)cnt);
                            String strUnitforKin = pamforKin.getUnits();
                            if (strUnitforKin != null && vectSelectedId.contains(strUnitforKin)) {
                                if (update) {
                                    if (strNewUnits.equals("")) {
                                        pamforKin.setUnits("substance");
                                    } else {
                                        pamforKin.setUnits(strNewUnits);
                                    }
                                } else {
                                    rtn.bSuccess = false;
                                    rtn.bYesConfirmed = ListPanel.showWarningDialog("remove") != 1;
                                    return rtn;
                                }
                            }
                            ++cnt;
                        }
                    }
                }
                catch (Exception rea) {
                    // empty catch block
                }
                ++i;
            }
        }
        if ((listSpecies = model.getListOfSpecies()) != null && listSpecies.size() > 0L) {
            int cntSpecies = 0;
            while ((long)cntSpecies < listSpecies.size()) {
                block42: {
                    try {
                        Species sp = (Species)listSpecies.get((long)cntSpecies);
                        String strUnit = sp.getSubstanceUnits();
                        if (strUnit == null || strUnit.trim().equals("")) break block42;
                        if (vectSelectedId.contains(strUnit)) {
                            if (update) {
                                sp.setSubstanceUnits(strNewUnits);
                                break block42;
                            }
                            rtn.bSuccess = false;
                            rtn.bYesConfirmed = ListPanel.showWarningDialog("remove") != 1;
                            return rtn;
                        }
                        String[] strsingleSubUnits = strUnit.split("/");
                        if (strsingleSubUnits.length < 1 || strsingleSubUnits[0] == null || !vectSelectedId.contains(strsingleSubUnits[0])) break block42;
                        if (update) {
                            sp.setSubstanceUnits(strNewUnits);
                            break block42;
                        }
                        rtn.bSuccess = false;
                        rtn.bYesConfirmed = ListPanel.showWarningDialog("remove") != 1;
                        return rtn;
                    }
                    catch (Exception sp) {
                        // empty catch block
                    }
                }
                ++cntSpecies;
            }
        }
        if ((listCompartments = model.getListOfCompartments()) != null && listCompartments.size() > 0L) {
            int i = 0;
            while ((long)i < listCompartments.size()) {
                block43: {
                    try {
                        Compartment cmt = (Compartment)listCompartments.get((long)i);
                        String strUnit = cmt.getUnits();
                        if (strUnit == null || !vectSelectedId.contains(strUnit)) break block43;
                        if (update) {
                            cmt.setUnits(strNewUnits);
                            LibSBMLUtil.setDefaultUnitsValueOf(cmt);
                            CompartmentDialog.changeUnitsOfSpeciesWhenCompartmentDimensionsChanged(cmt, false);
                            break block43;
                        }
                        rtn.bSuccess = false;
                        rtn.bYesConfirmed = ListPanel.showWarningDialog("remove") != 1;
                        return rtn;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        rtn.bSuccess = true;
        return rtn;
    }

    @Override
    protected void doActionOfShowPopupMenu(MouseEvent e) {
        int pressedRow;
        if (!e.isPopupTrigger()) {
            return;
        }
        if (this.table == null) {
            return;
        }
        SBase[] selected = this.getSelectedElements();
        if (selected.length != 1) {
            return;
        }
        int[] index = this.table.getSelectedRows();
        if (index[0] != (pressedRow = this.table.rowAtPoint(e.getPoint()))) {
            return;
        }
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    protected void doActionOfEditingMiriamInfo() {
        SBModelFrame currentSBFrame = MainWindow.getLastInstance().getCurrentModel().getSBModel().getSbframe();
        if (currentSBFrame != null) {
            SBase selectedsbase = currentSBFrame.getSelectedSBase();
            MainWindow.getLastInstance().showMiriamInfoFrm(selectedsbase);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.sbaseList instanceof ListOfSpeciesTypes) {
            if (!(arg instanceof SBModel)) {
                return;
            }
            SBModel sbmd = (SBModel)arg;
            CelldUtil.autoUpdateListofSpeciesType(sbmd);
        }
    }

    class ListPanel_mouseAdapter
    extends MouseAdapter {
        ListPanel adaptee;

        ListPanel_mouseAdapter(ListPanel adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.adaptee.table_mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ListPanel.this.tableMousePressed(e);
        }
    }

    private class MySBaseDialogListener
    implements SBaseDialogListener {
        private MySBaseDialogListener() {
        }

        @Override
        public void objectCreated(SBase sbase) {
            if (sbase == null) {
                return;
            }
            ListPanel.this.sbaseList.appendAndOwn(sbase);
            ListPanel.this.updateDialog();
            if (ListPanel.this.elementDlgMode == 1 && !ListPanel.this.elementDlg.hasChildListDialog()) {
                ListPanel.this.elementDlg.setVisible(false);
            }
            Vector list = (Vector)ListPanel.this.listeners.clone();
            int i = 0;
            while (i < list.size()) {
                SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i);
                listener.elementAdded(sbase);
                ++i;
            }
            if (sbase instanceof Parameter) {
                ListPanel.this.table.setRowSelectionInterval((int)ListPanel.this.sbaseList.size() - 1, (int)ListPanel.this.sbaseList.size() - 1);
            }
        }

        @Override
        public void objectUpdated(SBase sbase, String[] oldValues) {
            if (sbase == null) {
                return;
            }
            if (ListPanel.this instanceof ParameterListPanel) {
                ParameterListPanel parameterListPanel = (ParameterListPanel)ListPanel.this;
                ListPanel.this.listTableModel.fireTableRowsUpdated(0, parameterListPanel.sizeOfSorterSBaseList() - 1);
            } else {
                ListPanel.this.listTableModel.fireTableRowsUpdated(0, (int)ListPanel.this.sbaseList.size() - 1);
            }
            if (ListPanel.this.elementDlgMode == 1 && !ListPanel.this.elementDlg.hasChildListDialog()) {
                ListPanel.this.elementDlg.setVisible(false);
            }
            Vector list = (Vector)ListPanel.this.listeners.clone();
            int i = 0;
            while (i < list.size()) {
                SBaseListPanelListener listener = (SBaseListPanelListener)list.elementAt(i);
                listener.elementUpdated(sbase, oldValues);
                ++i;
            }
        }

        @Override
        public void dialogCanceled(SBase sbase) {
            ListPanel.this.elementDlg.setVisible(false);
        }
    }

    class PanelRenderer
    extends JPanel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setLayout(new BorderLayout());
            this.removeAll();
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            if (value != null && value instanceof JMathComponent) {
                this.add((Component)((JMathComponent)value), "West");
                this.repaint();
            }
            return this;
        }
    }

    protected class TableMouseListener
    implements MouseListener {
        private static final String SORT_ASC = "_ASC";
        private static final String SORT_DESC = "_DESC";
        private static final int SORT_NO = 0;
        protected static final int SORT_ASC_STATE = 1;
        protected static final int SORT_DESC_STATE = 2;
        private static final String PROTEINS = "Proteins";
        private static final String GENES = "Genes";
        private static final String RNAs = "RNAs";
        private static final String ASRNAS = "asRNAs";
        private static final String SIdType = "sid";
        private static final String StringType = "string";
        private static final String BooleanType = "boolean";
        private static final String IntegerType = "integer";
        private static final String DoubleType = "double";
        private static final String SIdArrayType = "sidarray";

        protected TableMouseListener() {
        }

        protected String getNewSortState(String colName) {
            String newSortState = "";
            String oldSortState = ListPanel.this.SORT_STATUS.toUpperCase();
            newSortState = (String.valueOf(colName.toUpperCase()) + SORT_ASC).equals(oldSortState) ? String.valueOf(colName.toUpperCase()) + SORT_DESC : ((String.valueOf(colName.toUpperCase()) + SORT_DESC).equals(oldSortState) ? String.valueOf(colName.toUpperCase()) + SORT_ASC : String.valueOf(colName.toUpperCase()) + SORT_ASC);
            return newSortState;
        }

        protected int getNewSortType(String colName) {
            int sortType = 0;
            String oldSortState = ListPanel.this.SORT_STATUS.toUpperCase();
            sortType = (String.valueOf(colName.toUpperCase()) + SORT_ASC).equals(oldSortState) ? 2 : ((String.valueOf(colName.toUpperCase()) + SORT_DESC).equals(oldSortState) ? 1 : 1);
            return sortType;
        }

        private String getMethodName(String panelName) {
            String get = "get";
            if (PROTEINS.equals(panelName)) {
                return String.valueOf(get) + "Protein";
            }
            if (GENES.equals(panelName)) {
                return String.valueOf(get) + "Gene";
            }
            if (RNAs.equals(panelName)) {
                return String.valueOf(get) + "RNA";
            }
            if (ASRNAS.equals(panelName)) {
                return String.valueOf(get) + "AntiSenseRNA";
            }
            return "";
        }

        protected void appendSBase(ListOf list, SBase base) throws Exception {
            if (base instanceof Species) {
                list.appendAndOwn((SBase)((Species)base));
            } else if (base instanceof Compartment) {
                list.appendAndOwn((SBase)((Compartment)base));
            } else if (base instanceof Reaction) {
                list.appendAndOwn((SBase)((Reaction)base));
            } else if (base instanceof FunctionDefinition) {
                list.appendAndOwn((SBase)((FunctionDefinition)base));
            } else if (base instanceof UnitDefinition) {
                list.appendAndOwn((SBase)((UnitDefinition)base));
            } else if (base instanceof Event) {
                list.appendAndOwn((SBase)((Event)base));
            } else if (base instanceof Parameter) {
                list.appendAndOwn((SBase)((Parameter)base));
            } else if (base instanceof Rule) {
                list.appendAndOwn((SBase)((Rule)base));
            } else if (base instanceof EventAssignment) {
                list.appendAndOwn((SBase)((EventAssignment)base));
            } else if (base instanceof KineticLaw) {
                list.appendAndOwn((SBase)((KineticLaw)base));
            } else if (base instanceof SpeciesReference) {
                list.appendAndOwn((SBase)((SpeciesReference)base));
            } else if (base instanceof ModifierSpeciesReference) {
                list.appendAndOwn((SBase)((ModifierSpeciesReference)base));
            } else if (base instanceof Unit) {
                list.appendAndOwn((SBase)((Unit)base));
            } else if (base instanceof SpeciesType) {
                list.appendAndOwn((SBase)((SpeciesType)base));
            } else if (base instanceof CompartmentType) {
                list.appendAndOwn((SBase)((CompartmentType)base));
            } else if (base instanceof InitialAssignment) {
                list.appendAndOwn((SBase)((InitialAssignment)base));
            } else if (base instanceof Constraint) {
                list.appendAndOwn((SBase)((Constraint)base));
            } else {
                throw new Exception("the list of panel is not supported");
            }
        }

        private String getKey(SBase base) throws Exception {
            if (base instanceof Species) {
                return ((Species)base).getId();
            }
            if (base instanceof Compartment) {
                return ((Compartment)base).getId();
            }
            if (base instanceof Reaction) {
                return ((Reaction)base).getId();
            }
            if (base instanceof FunctionDefinition) {
                return base.toSBML();
            }
            if (base instanceof UnitDefinition) {
                return base.toSBML();
            }
            if (base instanceof Event) {
                return base.toSBML();
            }
            if (base instanceof Parameter) {
                Parameter parameter = (Parameter)base;
                return LibSBMLUtil.getHashKey(parameter, parameter.getId());
            }
            if (base instanceof Rule) {
                return base.toSBML();
            }
            if (base instanceof EventAssignment) {
                return ((EventAssignment)base).getVariable();
            }
            if (base instanceof KineticLaw) {
                return ((KineticLaw)base).getFormula();
            }
            if (base instanceof SpeciesReference) {
                return ((SpeciesReference)base).getSpecies();
            }
            if (base instanceof ModifierSpeciesReference) {
                return ((ModifierSpeciesReference)base).getSpecies();
            }
            if (base instanceof Unit) {
                return String.valueOf(((Unit)base).getKind());
            }
            if (base instanceof SpeciesType) {
                return String.valueOf(((SpeciesType)base).getId());
            }
            if (base instanceof CompartmentType) {
                return String.valueOf(((CompartmentType)base).getId());
            }
            if (base instanceof InitialAssignment) {
                return String.valueOf(((InitialAssignment)base).getSymbol());
            }
            if (base instanceof Constraint) {
                return String.valueOf(libsbml.formulaToString((ASTNode)((Constraint)base).getMath()));
            }
            throw new Exception("the list of panel is not supported");
        }

        protected int getRealIndex(String colName, SBase sbase) {
            String[] columnNames = null;
            if (sbase instanceof Rule) {
                columnNames = RuleListPanel.getRuleListPanelNames();
            } else {
                columnNames = LibSBMLUtil.fieldShortNames(sbase);
                if (sbase instanceof Species) {
                    LibSBMLUtil.changePositionOfCompartment(columnNames, null);
                }
            }
            int i = 0;
            while (i < columnNames.length) {
                if (colName.equals(columnNames[i])) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        protected String[] getSelectedIdsBackup(ListOf originalList) throws Exception {
            int[] selectedRows = ListPanel.this.table.getSelectedRows();
            String[] selectedIds = new String[selectedRows.length];
            int i = 0;
            while (i < selectedRows.length) {
                selectedIds[i] = this.getKey(originalList.get((long)selectedRows[i]));
                ++i;
            }
            return selectedIds;
        }

        protected void restoreSelectedRows(ListOf list, ListSelectionModel model, String[] selectedIds) throws Exception {
            int[] newSelectedRows = new int[selectedIds.length];
            int count = 0;
            int i = 0;
            while ((long)i < list.size()) {
                int k = 0;
                while (k < selectedIds.length) {
                    if (selectedIds[k].equals(this.getKey(list.get((long)i)))) {
                        newSelectedRows[count++] = i;
                        break;
                    }
                    ++k;
                }
                ++i;
            }
            model.clearSelection();
            i = 0;
            while (i < newSelectedRows.length) {
                model.addSelectionInterval(newSelectedRows[i], newSelectedRows[i]);
                ++i;
            }
            ListPanel.this.table.setSelectionModel(model);
        }

        private Hashtable getTypeTable(String panelName, String colName) {
            String[][] species = new String[16][2];
            String[][] proteins = new String[4][2];
            String[][] genes = new String[4][2];
            String[][] rnas = new String[4][2];
            String[][] asrnas = new String[4][2];
            String[][] reactions = new String[10][2];
            String[][] compartments = new String[9][2];
            String[][] parameters = new String[7][2];
            String[][] functions = new String[5][2];
            String[][] units = new String[4][2];
            String[][] rules = new String[5][2];
            String[][] events = new String[8][2];
            String[][] speciesTypes = new String[2][2];
            String[][] compartmentTypes = new String[2][2];
            String[][] initialAssignments = new String[2][2];
            String[][] constraints = new String[2][2];
            species[0][0] = "class";
            species[1][0] = "positionToCompartment";
            species[2][0] = "id";
            species[3][0] = "name";
            species[4][0] = "compartment";
            species[5][0] = "quantity type";
            species[6][0] = "initialQuantity";
            species[7][0] = "substanceUnits";
            species[8][0] = "spatialSizeUnits";
            species[9][0] = "hasOnlySubstanceUnits";
            species[10][0] = "b.c.";
            species[11][0] = "charge";
            species[12][0] = "constants";
            species[13][0] = "notes";
            species[14][0] = "speciesType";
            species[15][0] = "included";
            species[0][1] = StringType;
            species[1][1] = StringType;
            species[2][1] = SIdType;
            species[3][1] = StringType;
            species[4][1] = SIdType;
            species[5][1] = StringType;
            species[6][1] = DoubleType;
            species[7][1] = SIdType;
            species[8][1] = SIdType;
            species[9][1] = BooleanType;
            species[10][1] = BooleanType;
            species[11][1] = IntegerType;
            species[12][1] = BooleanType;
            species[13][1] = StringType;
            species[14][1] = SIdType;
            species[15][1] = StringType;
            proteins[0][0] = "id";
            proteins[1][0] = "type";
            proteins[2][0] = "name";
            proteins[3][0] = "notes";
            proteins[0][1] = SIdType;
            proteins[1][1] = StringType;
            proteins[2][1] = StringType;
            proteins[3][1] = StringType;
            genes[0][0] = "id";
            genes[1][0] = "type";
            genes[2][0] = "name";
            genes[3][0] = "notes";
            genes[0][1] = SIdType;
            genes[1][1] = StringType;
            genes[2][1] = StringType;
            genes[3][1] = StringType;
            rnas[0][0] = "id";
            rnas[1][0] = "type";
            rnas[2][0] = "name";
            rnas[3][0] = "notes";
            rnas[0][1] = SIdType;
            rnas[1][1] = StringType;
            rnas[2][1] = StringType;
            rnas[3][1] = StringType;
            asrnas[0][0] = "id";
            asrnas[1][0] = "type";
            asrnas[2][0] = "name";
            asrnas[3][0] = "notes";
            asrnas[0][1] = SIdType;
            asrnas[1][1] = StringType;
            asrnas[2][1] = StringType;
            asrnas[3][1] = StringType;
            reactions[0][0] = "type";
            reactions[1][0] = "id";
            reactions[2][0] = "name";
            reactions[3][0] = "reversible";
            reactions[4][0] = "fast";
            reactions[5][0] = "reactants";
            reactions[6][0] = "products";
            reactions[7][0] = "modifiers";
            reactions[8][0] = "math";
            reactions[9][0] = "notes";
            reactions[0][1] = StringType;
            reactions[1][1] = SIdType;
            reactions[2][1] = StringType;
            reactions[3][1] = BooleanType;
            reactions[4][1] = BooleanType;
            reactions[5][1] = SIdArrayType;
            reactions[6][1] = SIdArrayType;
            reactions[7][1] = SIdArrayType;
            reactions[8][1] = StringType;
            reactions[9][1] = StringType;
            compartments[0][0] = "id";
            compartments[1][0] = "name";
            compartments[2][0] = "spatialDimensions";
            compartments[3][0] = "size";
            compartments[4][0] = "units";
            compartments[5][0] = "outside";
            compartments[6][0] = "constant";
            compartments[7][0] = "notes";
            compartments[8][0] = "compartmentType";
            compartments[0][1] = SIdType;
            compartments[1][1] = StringType;
            compartments[2][1] = IntegerType;
            compartments[3][1] = DoubleType;
            compartments[4][1] = SIdType;
            compartments[5][1] = SIdType;
            compartments[6][1] = BooleanType;
            compartments[7][1] = StringType;
            compartments[8][1] = SIdType;
            parameters[0][0] = "scope";
            parameters[1][0] = "id";
            parameters[2][0] = "name";
            parameters[3][0] = "value";
            parameters[4][0] = "units";
            parameters[5][0] = "constant";
            parameters[6][0] = "notes";
            parameters[0][1] = StringType;
            parameters[1][1] = SIdType;
            parameters[2][1] = StringType;
            parameters[3][1] = DoubleType;
            parameters[4][1] = SIdType;
            parameters[5][1] = BooleanType;
            parameters[6][1] = StringType;
            functions[0][0] = "id";
            functions[1][0] = "name";
            functions[2][0] = "arguments";
            functions[3][0] = "math";
            functions[4][0] = "notes";
            functions[0][1] = SIdType;
            functions[1][1] = StringType;
            functions[2][1] = StringType;
            functions[3][1] = StringType;
            functions[4][1] = StringType;
            units[0][0] = "id";
            units[1][0] = "name";
            units[2][0] = "units";
            units[3][0] = "notes";
            units[0][1] = SIdType;
            units[1][1] = StringType;
            units[2][1] = StringType;
            units[3][1] = StringType;
            rules[0][0] = "subtype";
            rules[1][0] = "math";
            rules[2][0] = "variable type";
            rules[3][0] = "variable";
            rules[4][0] = "notes";
            rules[0][1] = StringType;
            rules[1][1] = StringType;
            rules[2][1] = StringType;
            rules[3][1] = SIdType;
            rules[4][1] = StringType;
            events[0][0] = "id";
            events[1][0] = "name";
            events[2][0] = "trigger";
            events[3][0] = "delay";
            events[4][0] = "timeUnits";
            events[5][0] = "useValuesFromTriggerTime";
            events[6][0] = "variables";
            events[7][0] = "notes";
            events[0][1] = SIdType;
            events[1][1] = StringType;
            events[2][1] = StringType;
            events[3][1] = StringType;
            events[4][1] = SIdType;
            events[5][1] = BooleanType;
            events[6][1] = SIdType;
            events[7][1] = StringType;
            speciesTypes[0][0] = "id";
            speciesTypes[1][0] = "name";
            speciesTypes[0][1] = SIdType;
            speciesTypes[1][1] = StringType;
            compartmentTypes[0][0] = "id";
            compartmentTypes[1][0] = "name";
            compartmentTypes[0][1] = SIdType;
            compartmentTypes[1][1] = StringType;
            initialAssignments[0][0] = "symbol";
            initialAssignments[1][0] = "math";
            initialAssignments[0][1] = SIdType;
            initialAssignments[1][1] = StringType;
            constraints[0][0] = "math";
            constraints[1][0] = "message";
            constraints[0][1] = StringType;
            constraints[1][1] = StringType;
            String[] panelNames = new String[]{"Species", PROTEINS, GENES, RNAs, ASRNAS, "Reactions", "Compartments", "Parameters", "Functions", "UnitDefinitions", "Rules", "Events", "SpeciesTypes", "CompartmentTypes", "InitialAssignments", "Constraints"};
            Hashtable<String, String> table = new Hashtable<String, String>();
            int row = species.length;
            int r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[0].toLowerCase()) + "." + species[r][0].toLowerCase(), species[r][1].toLowerCase());
                ++r;
            }
            row = proteins.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[1].toLowerCase()) + "." + proteins[r][0].toLowerCase(), proteins[r][1].toLowerCase());
                ++r;
            }
            row = genes.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[2].toLowerCase()) + "." + genes[r][0].toLowerCase(), genes[r][1].toLowerCase());
                ++r;
            }
            row = rnas.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[3].toLowerCase()) + "." + rnas[r][0].toLowerCase(), rnas[r][1].toLowerCase());
                ++r;
            }
            row = asrnas.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[4].toLowerCase()) + "." + asrnas[r][0].toLowerCase(), asrnas[r][1].toLowerCase());
                ++r;
            }
            row = reactions.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[5].toLowerCase()) + "." + reactions[r][0].toLowerCase(), reactions[r][1].toLowerCase());
                ++r;
            }
            row = compartments.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[6].toLowerCase()) + "." + compartments[r][0].toLowerCase(), compartments[r][1].toLowerCase());
                ++r;
            }
            row = parameters.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[7].toLowerCase()) + "." + parameters[r][0].toLowerCase(), parameters[r][1].toLowerCase());
                ++r;
            }
            row = functions.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[8].toLowerCase()) + "." + functions[r][0].toLowerCase(), functions[r][1].toLowerCase());
                ++r;
            }
            row = units.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[9].toLowerCase()) + "." + units[r][0].toLowerCase(), units[r][1].toLowerCase());
                ++r;
            }
            row = rules.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[10].toLowerCase()) + "." + rules[r][0].toLowerCase(), rules[r][1].toLowerCase());
                ++r;
            }
            row = events.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[11].toLowerCase()) + "." + events[r][0].toLowerCase(), events[r][1].toLowerCase());
                ++r;
            }
            row = speciesTypes.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[12].toLowerCase()) + "." + speciesTypes[r][0].toLowerCase(), speciesTypes[r][1].toLowerCase());
                ++r;
            }
            row = compartmentTypes.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[13].toLowerCase()) + "." + compartmentTypes[r][0].toLowerCase(), compartmentTypes[r][1].toLowerCase());
                ++r;
            }
            row = initialAssignments.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[14].toLowerCase()) + "." + initialAssignments[r][0].toLowerCase(), initialAssignments[r][1].toLowerCase());
                ++r;
            }
            row = constraints.length;
            r = 0;
            while (r < row) {
                table.put(String.valueOf(panelNames[15].toLowerCase()) + "." + constraints[r][0].toLowerCase(), constraints[r][1].toLowerCase());
                ++r;
            }
            return table;
        }

        private String getType(String panelName, String colName) {
            Hashtable table = this.getTypeTable(panelName, colName);
            String type = String.valueOf(table.get(String.valueOf(panelName.toLowerCase()) + "." + colName.toLowerCase())).toLowerCase();
            return type;
        }

        private String getLeftString(String s) {
            char[] charString = s.toCharArray();
            String leftString = "";
            int i = 0;
            while (i < charString.length) {
                try {
                    Integer.parseInt(String.valueOf(charString[i]));
                    break;
                }
                catch (Exception e) {
                    leftString = String.valueOf(leftString) + String.valueOf(charString[i]);
                    ++i;
                }
            }
            return leftString;
        }

        private int getLeftNumber(String s) {
            char[] charString = s.toCharArray();
            String leftString = "";
            int i = 0;
            while (i < charString.length) {
                try {
                    Integer.parseInt(String.valueOf(charString[i]));
                    leftString = String.valueOf(leftString) + String.valueOf(charString[i]);
                }
                catch (Exception e) {
                    break;
                }
                ++i;
            }
            try {
                return Integer.parseInt(leftString);
            }
            catch (Exception e) {
                return -1;
            }
        }

        private int getLeftNumberLength(String s) {
            char[] charString = s.toCharArray();
            String leftString = "";
            int i = 0;
            while (i < charString.length) {
                try {
                    Integer.parseInt(String.valueOf(charString[i]));
                    leftString = String.valueOf(leftString) + String.valueOf(charString[i]);
                }
                catch (Exception e) {
                    break;
                }
                ++i;
            }
            return leftString.length();
        }

        private int compareSId(String normalString, String minmaxString) {
            int minmaxLeftNum;
            int normalLeftNum;
            if (normalString.length() == 0 && minmaxString.length() > 0) {
                return -1;
            }
            if (normalString.length() > 0 && minmaxString.length() == 0) {
                return 1;
            }
            if (normalString.length() == 0 && minmaxString.length() == 0) {
                return 0;
            }
            String normalBegin = String.valueOf(normalString.charAt(0));
            String minmaxBegin = String.valueOf(minmaxString.charAt(0));
            boolean isNormalBeginByNumber = false;
            boolean isMinMaxBeginByNumber = false;
            try {
                Integer.parseInt(normalBegin);
                isNormalBeginByNumber = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Integer.parseInt(minmaxBegin);
                isMinMaxBeginByNumber = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isNormalBeginByNumber ^ isMinMaxBeginByNumber) {
                return normalString.compareTo(minmaxString);
            }
            String s1 = normalString;
            String s2 = minmaxString;
            if (!isNormalBeginByNumber) {
                String minmaxLeftString;
                String normalLeftString = this.getLeftString(s1);
                int result = normalLeftString.compareTo(minmaxLeftString = this.getLeftString(s2));
                if (result != 0) {
                    return result;
                }
                s1 = s1.substring(normalLeftString.length());
                s2 = s2.substring(minmaxLeftString.length());
            }
            if ((normalLeftNum = this.getLeftNumber(s1)) < (minmaxLeftNum = this.getLeftNumber(s2))) {
                return -1;
            }
            if (normalLeftNum > minmaxLeftNum) {
                return 1;
            }
            s1 = s1.substring(this.getLeftNumberLength(s1));
            s2 = s2.substring(this.getLeftNumberLength(s2));
            return this.compareSId(s1, s2);
        }

        private int compareMultiId(String normalString, String minmaxString) {
            String[] minmaxStrings;
            if (normalString.trim().length() == 0 && minmaxString.trim().length() > 0) {
                return -1;
            }
            if (normalString.trim().length() > 0 && minmaxString.trim().length() == 0) {
                return 1;
            }
            if (normalString.trim().length() == 0 && minmaxString.trim().length() == 0) {
                return 0;
            }
            String[] normalStrings = normalString.split(",");
            int length = normalStrings.length;
            if (length > (minmaxStrings = minmaxString.split(",")).length) {
                length = minmaxStrings.length;
            }
            int i = 0;
            while (i < length) {
                int result = this.compareSId(normalStrings[i], minmaxStrings[i]);
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            if (normalStrings.length == minmaxStrings.length) {
                return 0;
            }
            if (length == normalStrings.length) {
                return -1;
            }
            return 1;
        }

        protected int compareValue(String strCompareType, String normalString, String minmaxString) {
            String type = strCompareType;
            if (IntegerType.equals(type) || DoubleType.equals(type)) {
                double minmaxDouble;
                double normalDouble = Double.parseDouble(normalString);
                if (normalDouble > (minmaxDouble = Double.parseDouble(minmaxString))) {
                    return 1;
                }
                if (normalDouble < minmaxDouble) {
                    return -1;
                }
                return 0;
            }
            if (StringType.equals(type) || BooleanType.equals(type)) {
                return normalString.compareTo(minmaxString);
            }
            if (SIdType.equals(type)) {
                return this.compareSId(normalString, minmaxString);
            }
            if (SIdArrayType.equals(type)) {
                return this.compareMultiId(normalString, minmaxString);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sort(ListOf originalList, SBModel sbModel, String panelName, String colName, boolean isRestoreSelectedRows) {
            if (!ListPanel.this.bCanRespond) {
                return;
            }
            String string = ListPanel.this.SORT_STATUS;
            synchronized (string) {
                long startTime = System.currentTimeMillis();
                try {
                    String strCompareType = this.getType(panelName, colName);
                    String methodName = this.getMethodName(panelName);
                    int sortType = this.getNewSortType(String.valueOf(panelName) + "_" + colName);
                    String newSortState = this.getNewSortState(String.valueOf(panelName) + "_" + colName);
                    ListSelectionModel selectedModel = null;
                    String[] selectedIds = null;
                    if (isRestoreSelectedRows) {
                        selectedModel = ListPanel.this.table.getSelectionModel();
                        selectedIds = this.getSelectedIdsBackup(originalList);
                    }
                    ListOf newSortList = new ListOf();
                    Class<?> modelClass = sbModel.getClass();
                    Class[] parameterTypes = new Class[]{String.class};
                    Method getMethod = null;
                    if (!"".equals(methodName)) {
                        getMethod = modelClass.getMethod(methodName, parameterTypes);
                    }
                    int index = 0;
                    index = getMethod != null ? this.getRealIndex(colName, (SBase)getMethod.invoke((Object)sbModel, originalList.get(0L).getId())) : this.getRealIndex(colName, originalList.get(0L));
                    while (originalList.size() > 1L) {
                        String minmaxValue;
                        int firstRow = 0;
                        SBase minmaxSBase = originalList.get((long)firstRow);
                        long minmaxRow = firstRow;
                        if (getMethod != null) {
                            Object[] minmaxArguments = new Object[]{minmaxSBase.getId()};
                            minmaxValue = LibSBMLUtil.toStrings((SBase)getMethod.invoke((Object)sbModel, minmaxArguments))[index];
                        } else {
                            minmaxValue = LibSBMLUtil.toStrings(minmaxSBase)[index];
                        }
                        long secondRow = firstRow + 1;
                        long iBaseRow = firstRow;
                        while (secondRow < originalList.size()) {
                            String normalString;
                            boolean condition = false;
                            SBase normalSBase = originalList.get(secondRow);
                            if (getMethod != null) {
                                SBase normalSpecies = normalSBase;
                                Object[] normalArguments = new Object[]{normalSpecies.getId()};
                                normalString = LibSBMLUtil.toStrings((SBase)getMethod.invoke((Object)sbModel, normalArguments))[index];
                            } else {
                                normalString = LibSBMLUtil.toStrings(normalSBase)[index];
                            }
                            switch (sortType) {
                                case 2: {
                                    condition = this.compareValue(strCompareType, normalString, minmaxValue) > 0;
                                    break;
                                }
                                case 1: {
                                    boolean bl = condition = this.compareValue(strCompareType, normalString, minmaxValue) < 0;
                                }
                            }
                            if (condition) {
                                minmaxValue = normalString;
                                minmaxRow = secondRow;
                                minmaxSBase = normalSBase;
                                iBaseRow = secondRow;
                            }
                            ++secondRow;
                        }
                        if (minmaxSBase instanceof Constraint || minmaxSBase instanceof Parameter) {
                            this.appendSBase(newSortList, originalList.remove(iBaseRow));
                            continue;
                        }
                        this.appendSBase(newSortList, originalList.remove(minmaxSBase.getId()));
                    }
                    if (originalList.size() == 1L) {
                        this.appendSBase(newSortList, originalList.remove(0L));
                    }
                    long nsize = newSortList.size();
                    int i = 0;
                    while ((long)i < nsize) {
                        this.appendSBase(originalList, newSortList.remove(0L));
                        ++i;
                    }
                    if (isRestoreSelectedRows) {
                        this.restoreSelectedRows(originalList, selectedModel, selectedIds);
                    }
                    ListPanel.this.SORT_STATUS = newSortState;
                }
                catch (Exception strCompareType) {
                    // empty catch block
                }
                if (Preference.isDebug) {
                    long endTime = System.currentTimeMillis();
                    System.out.println("endTime   @ ListPanel sort(ListOf originalList,SBModel sbModel,String panelName,String colName,boolean isRestoreSelectedRows): " + endTime);
                    long ms = endTime - startTime;
                    System.out.println("elapsed   @ ListPanel sort(ListOf originalList,SBModel sbModel,String panelName,String colName,boolean isRestoreSelectedRows): " + ms + " ms   <<========");
                    int iseconds = (int)(ms / 1000L);
                    String strMs = "" + ms;
                    String strSecs = "000" + strMs;
                    System.out.println("elapsed   @ ListPanel sort(ListOf originalList,SBModel sbModel,String panelName,String colName,boolean isRestoreSelectedRows): " + iseconds + "." + strSecs.substring(strSecs.length() - 3, strSecs.length() - 1) + " seconds");
                    System.out.println();
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() != 1) {
                return;
            }
            if (ListPanel.this.sbaseList == null) {
                return;
            }
            SBModel sbModel = null;
            try {
                sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
                if (sbModel == null) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
            try {
                if (arg0.getSource() instanceof JTableHeader) {
                    JTableHeader header = (JTableHeader)arg0.getSource();
                    int index = header.getColumnModel().getColumnIndexAtX(arg0.getX());
                    String colName = String.valueOf(header.getColumnModel().getColumn(index).getHeaderValue());
                    this.sort(ListPanel.this.sbaseList, sbModel, ListPanel.this.getName(), colName, true);
                }
            }
            catch (Exception e) {
                return;
            }
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }
}

