/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.util.ObjectHistoryManager;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.EventDialog;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.Preference;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseDialogListener;
import jp.sbi.sbml.util.SBaseListDialog;
import jp.sbi.sbml.util.SBaseListDialogListener;
import jp.sbi.sbml.util.UnitDefinitionDialog;
import org.sbml.libsbml.EventAssignment;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.Unit;

public class ListDialog
extends SBaseListDialog
implements MouseListener {
    public static final int NEW_BUTTON = 0;
    public static final int EDIT_BUTTON = 1;
    public static final int REMOVE_BUTTON = 2;
    public static final int CLEAR_ALL_BUTTON = 3;
    public static final int CLOSE_BUTTON = 4;
    public static final int SIZE_OF_BUTTONS = 5;
    private SBaseDialog elementDlg;
    private boolean isFirstShowing = true;
    private MySBaseDialogListener elementDlgListener;
    private JScrollPane scrollPane;
    private JButton newButton;
    private JButton editButton;
    private JButton removeButton;
    private JButton clearButton;
    private JButton closeButton;
    private JPanel buttonPanel;
    private JRootPane rootPane = this.getRootPane();
    public static final int DEFAULT_DIALOG_WIDTH = 450;
    public static final int DEFAULT_DIALOG_HEIGHT = 240;
    private boolean[] buttonFlag = new boolean[5];
    private ObjectHistoryManager[] lstHisManager;

    public ListDialog() {
        this.initDialog();
        this.initButtonFlag();
    }

    public ListDialog(Dialog owner) {
        super(owner);
        this.initDialog();
        this.initButtonFlag();
    }

    public ListDialog(Frame owner) {
        super(owner);
        this.initDialog();
        this.initButtonFlag();
    }

    private void initDialog() {
        this.newButton = new JButton("New");
        this.newButton.setMnemonic(78);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListDialog.this.newButton_actionPerformed();
            }
        });
        this.newButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ListDialog.this.rootPane.setDefaultButton(ListDialog.this.newButton);
            }
        });
        this.editButton = new JButton("Edit");
        this.editButton.setMnemonic(69);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListDialog.this.editButton_actionPerformed();
            }
        });
        this.editButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ListDialog.this.rootPane.setDefaultButton(ListDialog.this.editButton);
            }
        });
        this.removeButton = new JButton("Remove");
        this.removeButton.setMnemonic(82);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListDialog.this.removeButton_actionPerformed();
            }
        });
        this.removeButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ListDialog.this.rootPane.setDefaultButton(ListDialog.this.removeButton);
            }
        });
        this.clearButton = new JButton("Clear All");
        this.clearButton.setMnemonic(67);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListDialog.this.clearButton_actionPerformed();
            }
        });
        this.clearButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ListDialog.this.rootPane.setDefaultButton(ListDialog.this.clearButton);
            }
        });
        this.closeButton = new JButton("Close");
        this.closeButton.setMnemonic(87);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListDialog.this.closeButton_actionPerformed();
            }
        });
        this.closeButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ListDialog.this.rootPane.setDefaultButton(ListDialog.this.closeButton);
            }
        });
        this.buttonPanel = new JPanel(){

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.buttonPanel.add(this.newButton);
        this.buttonPanel.add(this.editButton);
        this.buttonPanel.add(this.removeButton);
        this.buttonPanel.add(this.clearButton);
        this.buttonPanel.add(this.closeButton);
        this.keyListener = new SBaseListDialog.MyKeyListener(this);
        this.addKeyListener(this.keyListener);
        this.table = new JTable(){

            @Override
            public boolean isManagingFocus() {
                return false;
            }
        };
        this.scrollPane = new JScrollPane(this.table){

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.scrollPane.setAutoscrolls(true);
        this.selectionListener = new SBaseListDialog.MyListSelectionListener(this);
        this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.table.addMouseListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setSize(new Dimension(450, 240));
        this.changeButtonsEnability();
    }

    @Override
    public SBaseDialog getElementDialog() {
        return this.elementDlg;
    }

    @Override
    public SBaseDialog getElementDialog(int element_const) {
        return null;
    }

    @Override
    public void setElementDialog(SBaseDialog dialog) {
        if (dialog == null) {
            return;
        }
        this.elementDlg = dialog;
        this.elementDlgListener = new MySBaseDialogListener();
        this.elementDlg.addSBaseDialogListener(this.elementDlgListener);
        this.setElementDialogMode(this.elementDlgMode);
        SBase sbase = this.elementDlg.createInitialObject();
        this.initTableModel(sbase);
        this.changeButtonsEnability();
    }

    @Override
    public void setElementDialog(SBaseDialog dialog, int i) {
    }

    @Override
    public void setElementDialogMode(int mode) {
        this.elementDlgMode = mode;
        if (this.elementDlg != null) {
            if (this.elementDlgMode == 1) {
                this.elementDlg.setModal(true);
            } else {
                this.elementDlg.setModal(false);
            }
            if (this.elementDlg.hasChildListDialog()) {
                this.elementDlg.setChildDialogMode(mode);
            }
        }
    }

    @Override
    public void setSelfOperational(boolean isOperational) {
        Container c = this.getContentPane();
        boolean hasAdded = false;
        Component[] comp = c.getComponents();
        int i = 0;
        while (i < comp.length) {
            if (comp[i] == this.buttonPanel) {
                hasAdded = true;
            }
            ++i;
        }
        if (isOperational && !hasAdded) {
            c.add((Component)this.buttonPanel, "South");
        } else if (!isOperational && hasAdded) {
            c.remove(this.buttonPanel);
        }
        this.validate();
        if (this.elementDlg != null && this.elementDlg.isShowing()) {
            this.elementDlg.setVisible(false);
        }
        this.isSelfOperational = isOperational;
    }

    @Override
    public void setSBaseList(ListOf sbaseList) {
        this.sbaseList = sbaseList;
        if (this.getParent() instanceof EventDialog) {
            EventDialog evdlg = (EventDialog)this.getParent();
            if (sbaseList == null) {
                this.lstHisManager = new ObjectHistoryManager[0];
            } else {
                int sz = (int)sbaseList.size();
                this.lstHisManager = new ObjectHistoryManager[sz];
                int i = 0;
                while (i < sz) {
                    ObjectHistoryManager his;
                    SBase sbase = sbaseList.get((long)i);
                    this.lstHisManager[i] = his = new ObjectHistoryManager(sbase, sbase, evdlg.givemeNextActionCounter());
                    ++i;
                }
            }
        }
        if (this.elementDlg != null) {
            this.elementDlg.setNewObject();
            this.elementDlg.updateDialog();
        }
        this.updateDialog();
    }

    public void setSBaseListDirectly(ListOf sbaseList) {
        this.sbaseList = sbaseList;
    }

    @Override
    public void releaseAll() {
        this.sbaseList = null;
        if (this.elementDlg != null) {
            this.elementDlg.removeSBaseDialogListener(this.elementDlgListener);
            this.elementDlg = null;
        }
        this.elementDlgListener = null;
        this.table.getSelectionModel().removeListSelectionListener(this.selectionListener);
        this.selectionListener = null;
        this.removeKeyListener(this.keyListener);
        this.keyListener = null;
        this.listeners.clear();
        this.listeners = null;
    }

    @Override
    public void disableChildDialog() {
        this.elementDlg.setObject(null);
        this.elementDlg.updateDialog();
    }

    @Override
    public void setButtonVisible(int button_const, boolean isVisible) {
        this.buttonPanel.remove(this.newButton);
        this.buttonPanel.remove(this.editButton);
        this.buttonPanel.remove(this.removeButton);
        this.buttonPanel.remove(this.clearButton);
        this.buttonPanel.remove(this.closeButton);
        this.buttonFlag[button_const] = isVisible;
        int i = 0;
        while (i < 5) {
            if (this.buttonFlag[i]) {
                if (i == 0) {
                    this.buttonPanel.add(this.newButton);
                } else if (i == 1) {
                    this.buttonPanel.add(this.editButton);
                } else if (i == 2) {
                    this.buttonPanel.add(this.removeButton);
                } else if (i == 3) {
                    this.buttonPanel.add(this.clearButton);
                } else if (i == 4) {
                    this.buttonPanel.add(this.closeButton);
                }
            }
            ++i;
        }
        this.validate();
        this.repaint();
    }

    public ObjectHistoryManager[] getObjectHistoryManager() {
        return this.lstHisManager;
    }

    private void removeSelectedRows(int[] index, SBase[] selected) {
        if (index == null || index.length <= 0) {
            return;
        }
        if (selected == null || selected.length <= 0) {
            return;
        }
        if (index.length != selected.length) {
            return;
        }
        int i = 0;
        while (i < selected.length) {
            if (this.getParent() instanceof EventDialog) {
                if (this.sbaseList == null) {
                    this.sbaseList = new ListOf();
                }
                EventDialog evdlg = (EventDialog)this.getParent();
                ObjectHistoryManager.updateNewstHisData(this.lstHisManager, selected[i], null, evdlg.givemeNextActionCounter());
            }
            LibSBMLUtil.removeSBase(selected[i], this.sbaseList);
            ++i;
        }
        if (this.elementDlg != null) {
            EventAssignment bakEvasInDlg;
            boolean bUpdateChildDlg = false;
            if (this.sbaseList == null || this.sbaseList.size() <= 0L) {
                bUpdateChildDlg = true;
            } else if (this.getParent() instanceof EventDialog && (bakEvasInDlg = (EventAssignment)this.elementDlg.getObjectBak()) != null) {
                int i2 = 0;
                while (i2 < selected.length) {
                    EventAssignment evasInLstDlg = (EventAssignment)selected[i2];
                    if (evasInLstDlg.getVariable().equals(bakEvasInDlg.getVariable())) {
                        bUpdateChildDlg = true;
                        break;
                    }
                    ++i2;
                }
            }
            if (bUpdateChildDlg) {
                this.elementDlg.setObject(null);
                this.elementDlg.updateDialog();
                this.elementDlg.setVisible(false);
            }
        }
        if (this.getParent() instanceof EventDialog) {
            ((EventDialog)this.getParent()).someFieldIsEdited();
            this.updateDialog();
            return;
        }
        this.updateDialog();
        Vector list = (Vector)this.listeners.clone();
        int i3 = 0;
        while (i3 < list.size()) {
            SBaseListDialogListener listener = (SBaseListDialogListener)list.elementAt(i3);
            listener.elementsRemoved(selected, index);
            ++i3;
        }
    }

    @Override
    protected void changeButtonsEnability() {
        this.newButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.closeButton.setEnabled(true);
        if (this.sbaseList == null) {
            return;
        }
        if (this.elementDlg != null) {
            this.newButton.setEnabled(true);
        }
        if (this.sbaseList.size() > 0L) {
            this.clearButton.setEnabled(true);
            int[] index = this.table.getSelectedRows();
            if (index.length > 0) {
                this.removeButton.setEnabled(true);
                if (this.elementDlg != null && index.length == 1) {
                    this.editButton.setEnabled(true);
                }
            }
        }
        this.changeButtonEnabilityForUnit();
    }

    @Override
    protected void changeElementDialogEnability() {
        int[] index = this.table.getSelectedRows();
        if (this.elementDlg != null && this.elementDlg.isShowing()) {
            if (index.length != 1) {
                this.elementDlg.setObject(null);
                this.elementDlg.updateDialog();
            } else {
                this.elementDlg.setObject(this.getLastSelectedElement());
                this.elementDlg.updateDialog();
            }
        }
    }

    @Override
    protected void updateChildDialog() {
        if (this.elementDlg != null) {
            this.elementDlg.updateDialog();
        }
    }

    private void showElementDialog() {
        if (this.elementDlg != null) {
            if (this.isFirstShowing) {
                Point p = this.getLocation();
                Dimension mysize = this.getSize();
                Dimension dlgsize = this.elementDlg.getSize();
                int x = p.x + (mysize.width - dlgsize.width) / 2;
                int y = this.getLocation().y;
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                this.elementDlg.setLocation(x, y);
                this.isFirstShowing = false;
            }
            this.elementDlg.show();
        }
    }

    private void newButton_actionPerformed() {
        if (this.sbaseList == null || this.elementDlg == null) {
            return;
        }
        this.table.clearSelection();
        this.elementDlg.setNewObject();
        this.elementDlg.updateDialog();
        this.showElementDialog();
    }

    private void editButton_actionPerformed() {
        if (this.sbaseList == null || this.elementDlg == null) {
            return;
        }
        SBase[] selected = this.getSelectedElements();
        if (selected.length == 1 && this.elementDlg != null) {
            this.elementDlg.setObject(selected[0]);
            this.elementDlg.updateDialog();
            this.showElementDialog();
        }
    }

    @Override
    protected void removeButton_actionPerformed() {
        if (this.sbaseList == null) {
            return;
        }
        String strSId = "";
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        if (this.getParent() instanceof UnitDefinitionDialog) {
            UnitDefinitionDialog unitDefinitionDialog = (UnitDefinitionDialog)this.getParent();
            if (unitDefinitionDialog.editingSBase != null) {
                strSId = unitDefinitionDialog.editingSBase.getId();
            }
            if (!UnitDefinitionDialog.beSureToChangeAllOtherSBasesUsedTheUnits(sbModel, strSId, "", 0, "remove")) {
                return;
            }
        }
        int[] index = this.table.getSelectedRows();
        SBase[] selected = this.getSelectedElements();
        this.removeSelectedRows(index, selected);
    }

    private void clearButton_actionPerformed() {
        if (this.sbaseList == null) {
            return;
        }
        String strSId = "";
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        if (this.getParent() instanceof UnitDefinitionDialog) {
            UnitDefinitionDialog unitDefinitionDialog = (UnitDefinitionDialog)this.getParent();
            if (unitDefinitionDialog.editingSBase != null) {
                strSId = unitDefinitionDialog.editingSBase.getId();
            }
            if (!UnitDefinitionDialog.beSureToChangeAllOtherSBasesUsedTheUnits(sbModel, strSId, "", 0, "remove")) {
                return;
            }
        }
        SBase[] removed = LibSBMLUtil.toArray(this.sbaseList);
        int[] index = new int[removed.length];
        int i = 0;
        while (i < index.length) {
            index[i] = i;
            ++i;
        }
        this.removeSelectedRows(index, removed);
    }

    private void closeButton_actionPerformed() {
        if (this.sbaseList == null) {
            return;
        }
        Vector list = (Vector)this.listeners.clone();
        int i = 0;
        while (i < list.size()) {
            SBaseListDialogListener listener = (SBaseListDialogListener)list.elementAt(i);
            listener.dialogClosed();
            ++i;
        }
    }

    private void initButtonFlag() {
        int i = 0;
        while (i < 5) {
            this.buttonFlag[i] = true;
            ++i;
        }
    }

    @Override
    protected void initTableModel(SBase sbase) {
        if (sbase == null) {
            return;
        }
        String[] columnNames = LibSBMLUtil.fieldShortNames(sbase);
        int[] columnSizes = LibSBMLUtil.fieldColumnSizes(sbase);
        this.listTableModel = new SBaseListDialog.MyTableModel(this, columnNames);
        this.table.setModel(this.listTableModel);
        try {
            int dialog_witdh = 0;
            int i = 0;
            while (i < columnSizes.length) {
                TableColumn column = this.table.getColumnModel().getColumn(i);
                if (sbase instanceof Unit && "offset".equals(column.getHeaderValue())) {
                    LibSBMLUtil.hideTableColumn(column);
                } else {
                    column.setPreferredWidth(columnSizes[i]);
                    dialog_witdh += columnSizes[i];
                }
                ++i;
            }
            this.validate();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            DebugPrinter.println(1, e.getMessage());
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int pressedRow = this.table.rowAtPoint(e.getPoint());
        if (pressedRow >= 0) {
            SBase sb = this.sbaseList.get((long)pressedRow);
            Vector list = (Vector)this.listeners.clone();
            int i = 0;
            while (i < list.size()) {
                SBaseListDialogListener listener = (SBaseListDialogListener)list.elementAt(i);
                listener.elementMousePressed(sb);
                ++i;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    private void changeButtonEnabilityForUnit() {
        if (this.getParent() instanceof UnitDefinitionDialog) {
            UnitDefinitionDialog unitDefinitionDialog = (UnitDefinitionDialog)this.getParent();
            if (!unitDefinitionDialog.isNewObject && unitDefinitionDialog.editingSBase != null) {
                String strSId = unitDefinitionDialog.editingSBase.getId();
                if ("substance".equals(strSId) || "volume".equals(strSId) || "area".equals(strSId) || "length".equals(strSId) || "time".equals(strSId)) {
                    this.newButton.setEnabled(false);
                    this.removeButton.setEnabled(false);
                    this.clearButton.setEnabled(false);
                } else {
                    SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
                    if (sbModel != null && !UnitDefinitionDialog.beSureToChangeAllOtherSBasesUsedTheUnits(sbModel, strSId, "", 0, "init")) {
                        this.newButton.setEnabled(false);
                        this.removeButton.setEnabled(false);
                        this.clearButton.setEnabled(false);
                    }
                }
            }
        }
    }

    private class MySBaseDialogListener
    implements SBaseDialogListener {
        private MySBaseDialogListener() {
        }

        @Override
        public void objectCreated(SBase sbase) {
            if (sbase == null) {
                return;
            }
            if (Preference.isDebug) {
                System.out.println("objectCreated = " + sbase);
            }
            if (sbase instanceof Species) {
                ListDialog.this.sbaseList.appendAndOwn((SBase)((Species)sbase));
            } else if (sbase instanceof Unit) {
                ListDialog.this.sbaseList.appendAndOwn((SBase)((Unit)sbase));
            } else if (sbase instanceof EventAssignment) {
                ListDialog.this.sbaseList.appendAndOwn((SBase)((EventAssignment)sbase));
            }
            ListDialog.this.updateDialog();
            if (ListDialog.this.elementDlgMode == 1 && !ListDialog.this.elementDlg.hasChildListDialog()) {
                ListDialog.this.elementDlg.setVisible(false);
            }
            Vector list = (Vector)ListDialog.this.listeners.clone();
            int i = 0;
            while (i < list.size()) {
                SBaseListDialogListener listener = (SBaseListDialogListener)list.elementAt(i);
                listener.elementAdded(sbase);
                ++i;
            }
        }

        @Override
        public void objectUpdated(SBase sbase, String[] oldValues) {
            if (sbase == null) {
                return;
            }
            ListDialog.this.listTableModel.fireTableRowsUpdated(0, (int)ListDialog.this.sbaseList.size() - 1);
            if (ListDialog.this.elementDlgMode == 1 && !ListDialog.this.elementDlg.hasChildListDialog()) {
                ListDialog.this.elementDlg.setVisible(false);
            }
            Vector list = (Vector)ListDialog.this.listeners.clone();
            int i = 0;
            while (i < list.size()) {
                SBaseListDialogListener listener = (SBaseListDialogListener)list.elementAt(i);
                listener.elementUpdated(sbase, oldValues);
                ++i;
            }
        }

        @Override
        public void dialogCanceled(SBase sbase) {
            ListDialog.this.elementDlg.setVisible(false);
        }
    }
}

