/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.table.TableColumn;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.fric.graphics.draw.GElement;
import jp.sbi.celldesigner.ClosedCompartmentAlias;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MiriamMainPanel;
import jp.sbi.celldesigner.OpenedCompartmentAlias;
import jp.sbi.celldesigner.SBMLControl;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.miriam.MIRIAM;
import jp.sbi.celldesigner.miriam.MiriamUtils;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.BindingRegion;
import jp.sbi.celldesigner.sbmlExtension.CompartmentAnnotation;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegion;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidue;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.RNA;
import jp.sbi.celldesigner.sbmlExtension.ReactionAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesReferenceAnnotation;
import jp.sbi.celldesigner.symbol.species.Degraded;
import jp.sbi.celldesigner.symbol.species.Phenotype;
import jp.sbi.celldesigner.util.CelldUtil;
import jp.sbi.sbml.Any;
import jp.sbi.sbml.MiriamDefinition;
import jp.sbi.sbml.MiriamSubDefinition;
import jp.sbi.sbml.Notes;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.SpecInfo;
import jp.sbi.sbml.util.ASTErrorNode;
import jp.sbi.sbml.util.ConstraintDialog;
import jp.sbi.sbml.util.EventDialog;
import jp.sbi.sbml.util.FunctionDefinitionDialog;
import jp.sbi.sbml.util.KineticLawDialog;
import jp.sbi.sbml.util.MathEditPanel;
import jp.sbi.sbml.util.ReactionDialog;
import jp.sbi.sbml.util.SBMLPanelLists;
import jp.sbi.sbml.util.SBaseListPanel;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.AlgebraicRule;
import org.sbml.libsbml.AssignmentRule;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.CompartmentType;
import org.sbml.libsbml.Constraint;
import org.sbml.libsbml.Delay;
import org.sbml.libsbml.Event;
import org.sbml.libsbml.EventAssignment;
import org.sbml.libsbml.FunctionDefinition;
import org.sbml.libsbml.InitialAssignment;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfCompartments;
import org.sbml.libsbml.ListOfConstraints;
import org.sbml.libsbml.ListOfEventAssignments;
import org.sbml.libsbml.ListOfEvents;
import org.sbml.libsbml.ListOfFunctionDefinitions;
import org.sbml.libsbml.ListOfInitialAssignments;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.ListOfRules;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.ListOfSpeciesReferences;
import org.sbml.libsbml.ListOfUnitDefinitions;
import org.sbml.libsbml.ListOfUnits;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.ModifierSpeciesReference;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.RateRule;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.Rule;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLError;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.SimpleSpeciesReference;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesReference;
import org.sbml.libsbml.SpeciesType;
import org.sbml.libsbml.Trigger;
import org.sbml.libsbml.Unit;
import org.sbml.libsbml.UnitDefinition;
import org.sbml.libsbml.XMLAttributes;
import org.sbml.libsbml.XMLNamespaces;
import org.sbml.libsbml.XMLNode;
import org.sbml.libsbml.XMLToken;
import org.sbml.libsbml.XMLTriple;
import org.sbml.libsbml.libsbml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LibSBMLUtil {
    public static final String strXmlns_bqbiol = "xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\"";
    public static final String strXmlns_bqmodel = "xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\"";
    public static final String strXmlns_dc = "xmlns:dc=\"http://purl.org/dc/elements/1.1/\"";
    public static final String strXmlns_dcterms = "xmlns:dcterms=\"http://purl.org/dc/terms/\"";
    public static final String strXmlns_rdf = "xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"";
    public static final String strXmlns_vCard = "xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\"";
    public static final String strXml_TagSplit = ":";
    public static final String strXmlTagPrefix_rdf = "rdf";
    public static final String strXmlTagPrefix_dc = "dc";
    public static final String strXmlTagPrefix_vCard = "vCard";
    public static final String strXmlTagPrefix_dcterms = "dcterms";
    public static final String strXmlTag_annotation = "annotation";
    public static final String strXmlTag_Resource = "\"Resource\"";
    public static final String strXmlTag_RDF = "RDF";
    public static final String strXmlTag_Description = "Description";
    public static final String strXmlTag_creator = "creator";
    public static final String strXmlTag_Bag = "Bag";
    public static final String strXmlTag_li = "li";
    public static final String strXmlTag_N = "N";
    public static final String strXmlTag_Family = "Family";
    public static final String strXmlTag_Given = "Given";
    public static final String strXmlTag_EMAIL = "EMAIL";
    public static final String strXmlTag_ORG = "ORG";
    public static final String strXmlTag_Orgname = "Orgname";
    public static final String strXmlTag_created = "created";
    public static final String strXmlTag_W3CDTF = "W3CDTF";
    public static final String strXmlTag_modified = "modified";
    public static final String strXmlTag_about = "about";
    public static final String strXmlTag_parseType = "parseType";
    private static boolean enableDebugLibSBML3 = false;
    private static DocumentBuilderFactory dbfactory;
    private static DocumentBuilder builder;
    private static final boolean IsEnabledCheckUnitConsistency = false;
    private static final boolean IsEnabledCheckSBOConsistency = false;
    private static final boolean IsEnabledCheckModelingPractice = true;
    private static final boolean IsEnabledCheckOverdetermined = true;
    private static final boolean IsEnabledCheckMathMLConsistency = true;
    private static final boolean IsEnabledCheckGeneralConsistency = true;
    private static final boolean IsEnabledCheckIdentifierConsistency = true;
    public static final String ErroMessage_CONSTANTOfMath = "CONSTANT haven't been supported, in";
    public static final String strAlgebraic = "Algebraic";
    public static final String strAssignment = "Assignment";
    public static final String strRate = "Rate";
    public static final boolean defaultUseValuesFromTriggerTime = true;
    private static boolean isLocalParamUnitOfTime;
    private static boolean isLocalParamUnitOfT;
    private static boolean isGlobalParamUnitOfTime;
    private static boolean isGlobalParamUnitOfT;
    private static boolean hasLocalParamTime;
    private static boolean hasLocalParamT;
    private static boolean hasGlobalParamTime;
    private static boolean hasGlobalParamT;
    private static final String[] model_elementClassName;
    private static final String[] unit_definition_elementClassName;
    private static final String[] reaction_elementClassName;
    private static final String[] kineticlaw_elementClassName;
    private static final String[] event_elementClassName;
    private static final String[] unit_definition_listTagName;
    private static final String[] kineticlaw_listTagName;
    private static final String[] event_listTagName;
    private static final String[] model_listTagName;
    private static final String[] reaction_listTagName;
    public static final String ANNOTATION = "annotation";
    public static final String TAG_CELLDESIGNER_PREFIX = "celldesigner";
    public static final String TAG_CELLDESIGNER_EXTENSIONTOPLEVEL = "extension";
    public static final String TAG_START_ANNOTATION = "<annotation xmlns:celldesigner=\"http://www.sbml.org/2001/ns/celldesigner\">";
    public static final String TAG_END_ANNOTATION = "</annotation>";
    public static final String NOTES = "notes";
    public static final String TAG_START_CELLDESIGNER = "<celldesigner:";
    public static final String TAG_END_CELLDESIGNER = "</celldesigner:";
    public static final String POSITION_TO_COMPARTMENT = "positionToCompartment";
    public static final String COMPLEX_SPECIES = "complexSpecies";
    public static final String SPECIES_IDENTITY = "speciesIdentity";
    public static final String HETERODIMER_IDENTITY = "heterodimerIdentity";
    public static final String HYPOTHETICAL = "hypothetical";
    public static final String PROTEIN_REFERENCE = "proteinReference";
    public static final String GENE_REFERENCE = "geneReference";
    public static final String RNA_REFERENCE = "rnaReference";
    public static final String ASRNA_REFERENCE = "antisensernaReference";
    public static final String CLASS = "class";
    public static final String STATE = "state";
    public static final String STRUCTURALSTATE = "structuralState";
    public static final String ANGLE = "angle";
    public static final String MODIFICATION = "modification";
    public static final String HOMODIMER = "homodimer";
    public static final String LIST_OF_MODIFICATION = "listOfModification";
    public static final String LIST_OF_STRUCTURALSTATE = "listOfStructuralState";
    public static final String RESIDUE = "residue";
    public static final String xmltagAutoTag = "AutoTag";
    public static final String INFO = "info";
    public static final String LABEL1 = "prefix";
    public static final String LABEL2 = "label";
    public static final String Complex_InnerIncludedSpeciesInfo = "included";
    public static final String startMark = "<";
    public static final String endMark1 = ">";
    public static final String LineChangeMark = "\n";
    public static final String Mark1 = "\"";
    public static final String Mark2 = "#";
    public static final String Mark3 = "=";
    public static final String Mark4 = "/";
    public static final String Mark5 = " ";
    public static final String Mark6 = "[";
    public static final String Mark7 = "]";
    public static final String Mark8 = ".";
    public static final String Mark9 = ",";
    public static final String Mark10 = ":";
    public static final String rdfOfRdfOfAnnotationTag = "rdf:RDF";
    public static final String urlOfRdfOfRdfOfAnnotationTag1 = "xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\"";
    public static final String urlOfRdfOfRdfOfAnnotationTag2 = "xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"";
    public static final String descriptionOfRdfOfAnnotationTag = "rdf:Description";
    public static final String bagOfRdfOfBqbiolOfDescriptionOfRdfOfAnnotationTag = "rdf:Bag";
    public static final String liOfBagOfRdfOfBqbiolOfDescriptionOfRdfOfAnnotationTagTagName = "rdf:li";
    public static final String rdfOfAnnotationTag = "rdf:";
    public static final String aboutOfRdfOfAnnotationTag = "about";
    public static final String resourceOfRdfOfAnnotationTag = "resource";
    public static final String speciesNameFontSizeTag = "font";
    public static final String speciesNameFontSizeLabel = "size";
    private static final String[] ATTR_NAME_MODIFIERSPECIES_REF;
    private static final String[] ATTR_NAME_SPECIES_1_1;
    private static final String[] ATTR_NAME_SPECIES_1_2;
    private static final String[] ATTR_NAME_SPECIES_2_1;
    private static final String[] ATTR_NAME_EVENT;
    private static final String[] ATTR_NAME_COMPARTMENT_1;
    private static final String[] ATTR_NAME_COMPARTMENT_2;
    private static final String[] ATTR_NAME_FUNCTION;
    private static final String[] ATTR_NAME_MODIFICATION_RESIDUE;
    private static final String[] ATTR_NAME_BINDINGREGION;
    private static final String[] ATTR_NAME_MODIFICATION_REGION;
    private static final String[] ATTR_NAME_EXTENSION_SPECIES;
    private static final String[] ATTR_NAME_SPECIES_1;
    private static final String[] ATTR_NAME_SPECIES_2;
    private static final String[] ATTR_NAME_KINETICLAW_1;
    private static final String[] ATTR_NAME_KINETICLAW_2;
    private static final String[] ATTR_NAME_PARAMETER_RULE_1;
    private static final String[] ATTR_NAME_PARAMETER_RULE_2;
    private static final String[] ATTR_NAME_UNITDEFINITION_1;
    private static final String[] ATTR_NAME_UNITDEFINITION_2;
    private static final String[] ATTR_NAME_PARAMETER_1;
    private static final String[] ATTR_NAME_PARAMETER_2;
    private static final String[] ATTR_NAME_RATE_RULE_1;
    private static final String[] ATTR_NAME_RATE_RULE_2;
    private static final String[] ATTR_NAME_ALGEBRAIC_RULE;
    private static final String[] ATTR_NAME_EVENT_ASSIGNMENT;
    private static final String[] ATTR_NAME_MODEL_1;
    private static final String[] ATTR_NAME_MODEL_2;
    private static final String[] ATTR_NAME_COMPARTMENTVOLUME_RULE;
    private static final String[] ATTR_NAME_REACTION_1;
    private static final String[] ATTR_NAME_REACTION_2;
    private static final String[] ATTR_NAME_ASSIGNMENT_RULE_1;
    private static final String[] ATTR_NAME_ASSIGNMENT_RULE_2;
    private static final String[] ATTR_NAME_SBMLDOCUMENT;
    private static final String[] ATTR_NAME_SPECIES_CONCENTRATION_RULE_1;
    private static final String[] ATTR_NAME_SPECIES_CONCENTRATION_RULE_2;
    private static final String[] ATTR_NAME_UNIT_1;
    private static final String[] ATTR_NAME_UNIT_2;
    private static final String[] ATTR_NAME_SPECIES_TYPE;
    private static final String[] ATTR_NAME_COMPARTMENT_TYPE;
    private static final String[] ATTR_NAME_INITIAL_ASSIGNMENTS;
    private static final String[] ATTR_NAME_CONSTRAINTS;
    private static SpecInfo specInfo;
    public static final String GLOBAL = "global";
    public static final String LOCAL_REACTION = "local:Reaction";
    public static boolean isViewSpeciesID;
    public static final int iNoErrDetected = -1;
    public static final String strappend = "<:>";
    public static final String[] strListofSBMLKind;
    public static final String strMember1 = "substance";
    public static final String strMember2 = "volume";
    public static final String strMember3 = "area";
    public static final String strMember4 = "length";
    public static final String strMember5 = "time";
    public static final String[] strListofBuiltinUnits;
    public static final String substanceUnits1 = "substance";
    public static final String substanceUnits2 = "mole";
    public static final String substanceUnits3 = "item";
    public static final String substanceUnits4 = "gram";
    public static final String substanceUnits5 = "kilogram";
    public static final String substanceUnits6 = "dimensionless";
    public static final String[] strListofSubstanceUnits;
    public static final String strSizebuffer = "/";
    public static final String strRemove = "remove";
    public static final String strUpdate = "update";
    public static final String strInit = "init";
    public static final String unitsForCompartmentOf1_1 = "length";
    public static final String unitsForCompartmentOf1_2 = "metre";
    public static final String unitsForCompartmentOf1_3 = "dimensionless";
    public static final String[] strListofUnitsForCompartment1;
    public static final String unitsForCompartmentOf2_1 = "area";
    public static final String unitsForCompartmentOf2_2 = "dimensionless";
    public static final String[] strListofUnitsForCompartment2;
    public static final String unitsForCompartmentOf3_1 = "volume";
    public static final String unitsForCompartmentOf3_2 = "litre";
    public static final String[] strListofUnitsForCompartment3;
    public static final int specieschangeId = 1;
    public static final int parameterlocalchangeId = 2;
    public static final int parameterglobalchangeId = 3;
    public static final int functionchangeId = 4;
    public static final String strParameters = "Parameters";
    public static final String strLocalParameters = "LocalParameters";
    public static final String strFunctionDefinitions = "FunctionDefinitions";
    public static final String strUnitDefinitions = "UnitDefinitions";
    public static final String strRules = "Rules";
    public static final String strEvents = "Events";
    public static final String strSpeciesTypes = "SpeciesTypes";
    public static final String strCompartmentTypes = "CompartmentTypes";
    public static final String strInitialAssignments = "InitialAssignments";
    public static final String strConstraints = "Constraints";
    private static HashMap substanceUnitsOfSpeciesRule;
    private static HashMap unitsOfCompartmentRule1;
    private static HashMap unitsOfCompartmentRule2;
    private static HashMap unitsOfCompartmentRule3;
    public static final int MIN_CALLED_TIMES = 1;
    public static final int MAX_CALLED_TIMES = 100;
    public static final double OK_MIN_LEN_MIN = 0.01;
    public static final double OK_MIN_LEN_MAX = 2.0;
    public static final double dOkMinLen = 0.5;
    public static final String strSpeciesReferenceReactantBuffer = "<RT>";
    public static final String strSpeciesReferenceProductBuffer = "<PD>";
    public static final String strModifierSpeciesReferenceBuffer = "<MF>";
    public static final String Erro_TheNumberOfArgumentsForFunctionDefinition = "The number of Arguments used in a call to a  \nfunction defined by a FunctionDefinition must equal \nthe number of Arguments accepted by that function.";
    public static final String strNameASTNodePattern = "name";

    static {
        isLocalParamUnitOfTime = false;
        isLocalParamUnitOfT = false;
        isGlobalParamUnitOfTime = false;
        isGlobalParamUnitOfT = false;
        hasLocalParamTime = false;
        hasLocalParamT = false;
        hasGlobalParamTime = false;
        hasGlobalParamT = false;
        dbfactory = DocumentBuilderFactory.newInstance();
        dbfactory.setNamespaceAware(true);
        dbfactory.setValidating(false);
        try {
            builder = dbfactory.newDocumentBuilder();
            builder.setErrorHandler(null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        model_elementClassName = new String[]{"FunctionDefinition", "UnitDefinition", "Compartment", "Species", "Parameter", "Rule", "Reaction", "Event", "SpeciesType", "CompartmentType", "InitialAssignment", "Constraint"};
        unit_definition_elementClassName = new String[]{"Unit"};
        reaction_elementClassName = new String[]{"SpeciesReference", "SpeciesReference", "ModifierSpeciesReference"};
        kineticlaw_elementClassName = new String[]{"Parameter"};
        event_elementClassName = new String[]{"EventAssignment"};
        unit_definition_listTagName = new String[]{"listOfUnits"};
        kineticlaw_listTagName = new String[]{"listOfParameters"};
        event_listTagName = new String[]{"listOfEventAssignments"};
        model_listTagName = new String[]{"listOfFunctionDefinitions", "listOfUnitDefinitions", "listOfCompartments", "listOfSpecies", "listOfParameters", "listOfRules", "listOfReactions", "listOfEvents", "listOfSpeciesTypes", "listOfCompartmentTypes", "listOfInitialAssignments", "listOfConstraints"};
        reaction_listTagName = new String[]{"listOfReactants", "listOfProducts", "listOfModifiers"};
        ATTR_NAME_MODIFIERSPECIES_REF = new String[]{"species"};
        ATTR_NAME_SPECIES_1_1 = new String[]{"specie", "stoichiometry", "denominator"};
        ATTR_NAME_SPECIES_1_2 = new String[]{"species", "stoichiometry", "denominator"};
        ATTR_NAME_SPECIES_2_1 = new String[]{"species", "stoichiometry"};
        ATTR_NAME_EVENT = new String[]{"id", strNameASTNodePattern, "timeUnits"};
        ATTR_NAME_COMPARTMENT_1 = new String[]{strNameASTNodePattern, "volume", "units", "outside"};
        ATTR_NAME_COMPARTMENT_2 = new String[]{"id", strNameASTNodePattern, "spatialDimensions", speciesNameFontSizeLabel, "units", "outside", "constant"};
        ATTR_NAME_FUNCTION = new String[]{"id", strNameASTNodePattern};
        ATTR_NAME_MODIFICATION_RESIDUE = new String[]{"id", strNameASTNodePattern, "side", ANGLE};
        ATTR_NAME_BINDINGREGION = new String[]{"id", strNameASTNodePattern, speciesNameFontSizeLabel, ANGLE};
        ATTR_NAME_MODIFICATION_REGION = new String[]{"id", strNameASTNodePattern, "type", speciesNameFontSizeLabel, "pos", "active"};
        ATTR_NAME_EXTENSION_SPECIES = new String[]{"id", "type", strNameASTNodePattern};
        ATTR_NAME_SPECIES_1 = new String[]{strNameASTNodePattern, "compartment", "initialAmount", "units", "boundaryCondition", "charge"};
        ATTR_NAME_SPECIES_2 = new String[]{"id", strNameASTNodePattern, "compartment", "initialAmount", "initialConcentration", "substanceUnits", "spatialSizeUnits", "hasOnlySubstanceUnits", "boundaryCondition", "charge", "constant"};
        ATTR_NAME_KINETICLAW_1 = new String[]{"formula", "timeUnits", "substanceUnits"};
        ATTR_NAME_KINETICLAW_2 = new String[]{"timeUnits", "substanceUnits"};
        ATTR_NAME_PARAMETER_RULE_1 = new String[]{"formula", "type", strNameASTNodePattern};
        ATTR_NAME_PARAMETER_RULE_2 = new String[]{"formula", "type", "parameter"};
        ATTR_NAME_UNITDEFINITION_1 = new String[]{strNameASTNodePattern};
        ATTR_NAME_UNITDEFINITION_2 = new String[]{"id", strNameASTNodePattern};
        ATTR_NAME_PARAMETER_1 = new String[]{strNameASTNodePattern, "value", "units"};
        ATTR_NAME_PARAMETER_2 = new String[]{"id", strNameASTNodePattern, "value", "units", "constant"};
        ATTR_NAME_RATE_RULE_1 = new String[]{"formula", "type", ""};
        ATTR_NAME_RATE_RULE_2 = new String[]{"variable"};
        ATTR_NAME_ALGEBRAIC_RULE = new String[]{"formula"};
        ATTR_NAME_EVENT_ASSIGNMENT = new String[]{"variable"};
        ATTR_NAME_MODEL_1 = new String[]{strNameASTNodePattern};
        ATTR_NAME_MODEL_2 = new String[]{"id", strNameASTNodePattern};
        ATTR_NAME_COMPARTMENTVOLUME_RULE = new String[]{"formula", "type", "compartment"};
        ATTR_NAME_REACTION_1 = new String[]{strNameASTNodePattern, "reversible", "fast"};
        ATTR_NAME_REACTION_2 = new String[]{"id", strNameASTNodePattern, "reversible", "fast"};
        ATTR_NAME_ASSIGNMENT_RULE_1 = new String[]{"formula", "type", ""};
        ATTR_NAME_ASSIGNMENT_RULE_2 = new String[]{"variable"};
        ATTR_NAME_SBMLDOCUMENT = new String[]{"level", "version"};
        ATTR_NAME_SPECIES_CONCENTRATION_RULE_1 = new String[]{"formula", "type", "specie"};
        ATTR_NAME_SPECIES_CONCENTRATION_RULE_2 = new String[]{"formula", "type", "species"};
        ATTR_NAME_UNIT_1 = new String[]{"kind", "exponent", "scale"};
        ATTR_NAME_UNIT_2 = new String[]{"kind", "exponent", "scale", "multiplier", "offset"};
        ATTR_NAME_SPECIES_TYPE = new String[]{"id", strNameASTNodePattern};
        ATTR_NAME_COMPARTMENT_TYPE = new String[]{"id", strNameASTNodePattern};
        ATTR_NAME_INITIAL_ASSIGNMENTS = new String[]{"symbol", "math"};
        ATTR_NAME_CONSTRAINTS = new String[]{"math", "message"};
        specInfo = new SpecInfo();
        isViewSpeciesID = true;
        strListofSBMLKind = new String[]{libsbml.UnitKind_toString((int)0), libsbml.UnitKind_toString((int)1), libsbml.UnitKind_toString((int)2), libsbml.UnitKind_toString((int)4), libsbml.UnitKind_toString((int)5), libsbml.UnitKind_toString((int)6), libsbml.UnitKind_toString((int)7), libsbml.UnitKind_toString((int)8), libsbml.UnitKind_toString((int)9), libsbml.UnitKind_toString((int)10), libsbml.UnitKind_toString((int)11), libsbml.UnitKind_toString((int)12), libsbml.UnitKind_toString((int)13), libsbml.UnitKind_toString((int)14), libsbml.UnitKind_toString((int)15), libsbml.UnitKind_toString((int)17), libsbml.UnitKind_toString((int)18), libsbml.UnitKind_toString((int)19), libsbml.UnitKind_toString((int)21), libsbml.UnitKind_toString((int)22), libsbml.UnitKind_toString((int)23), libsbml.UnitKind_toString((int)24), libsbml.UnitKind_toString((int)25), libsbml.UnitKind_toString((int)26), libsbml.UnitKind_toString((int)27), libsbml.UnitKind_toString((int)28), libsbml.UnitKind_toString((int)29), libsbml.UnitKind_toString((int)30), libsbml.UnitKind_toString((int)31), libsbml.UnitKind_toString((int)32), libsbml.UnitKind_toString((int)33), libsbml.UnitKind_toString((int)34)};
        strListofBuiltinUnits = new String[]{"substance", "volume", "area", "length", strMember5};
        strListofSubstanceUnits = new String[]{"substance", substanceUnits2, substanceUnits3, substanceUnits4, substanceUnits5, "dimensionless"};
        strListofUnitsForCompartment1 = new String[]{"length", unitsForCompartmentOf1_2, "dimensionless"};
        strListofUnitsForCompartment2 = new String[]{"area", "dimensionless"};
        strListofUnitsForCompartment3 = new String[]{"volume", unitsForCompartmentOf3_2};
        substanceUnitsOfSpeciesRule = null;
        unitsOfCompartmentRule1 = null;
        unitsOfCompartmentRule2 = null;
        unitsOfCompartmentRule3 = null;
    }

    public static SBase removeSBase(SBase sbase, ListOf list) {
        if (sbase instanceof Species) {
            return LibSBMLUtil.removeSpecies(sbase, list);
        }
        if (sbase instanceof Reaction) {
            return LibSBMLUtil.removeReaction(sbase, list);
        }
        if (sbase instanceof Compartment) {
            return LibSBMLUtil.removeCompartment(sbase, list);
        }
        if (sbase instanceof EventAssignment) {
            return LibSBMLUtil.removeEventAssignment(sbase, list);
        }
        if (sbase instanceof Event) {
            return LibSBMLUtil.removeEvent(sbase, list);
        }
        if (sbase instanceof UnitDefinition) {
            return LibSBMLUtil.removeUnitDefinition(sbase, list);
        }
        if (sbase instanceof Unit) {
            return LibSBMLUtil.removeUnit(sbase, list);
        }
        if (sbase instanceof Rule) {
            return LibSBMLUtil.removeRule(sbase, list);
        }
        if (sbase instanceof FunctionDefinition) {
            return LibSBMLUtil.removeFunctionDefinition(sbase, list);
        }
        if (sbase instanceof Parameter) {
            return LibSBMLUtil.removeParameter(sbase, list);
        }
        if (sbase instanceof SpeciesType) {
            return LibSBMLUtil.removeSpeciesType(sbase, list);
        }
        if (sbase instanceof CompartmentType) {
            return LibSBMLUtil.removeCompartmentType(sbase, list);
        }
        if (sbase instanceof InitialAssignment) {
            return LibSBMLUtil.removeInitialAssignment(sbase, list);
        }
        if (sbase instanceof Constraint) {
            return LibSBMLUtil.removeConstraint(sbase, list);
        }
        return null;
    }

    private static SBase removeSpecies(SBase sbase, ListOf list) {
        String id = ((Species)sbase).getId();
        int i = 0;
        while ((long)i < list.size()) {
            Species c = (Species)list.get((long)i);
            if (id.equals(c.getId())) {
                return list.remove((long)i);
            }
            ++i;
        }
        return null;
    }

    private static SBase removeReaction(SBase sbase, ListOf list) {
        String id = ((Reaction)sbase).getId();
        int i = 0;
        while ((long)i < list.size()) {
            Reaction c = (Reaction)list.get((long)i);
            if (id.equals(c.getId())) {
                return list.remove((long)i);
            }
            ++i;
        }
        return null;
    }

    private static SBase removeEventAssignment(SBase sbase, ListOf list) {
        EventAssignment event = (EventAssignment)sbase;
        int i = 0;
        while ((long)i < list.size()) {
            EventAssignment c = (EventAssignment)list.get((long)i);
            if (c.getVariable().equals(event.getVariable()) && libsbml.formulaToString((ASTNode)c.getMath()).equals(libsbml.formulaToString((ASTNode)event.getMath()))) {
                return list.remove((long)i);
            }
            ++i;
        }
        return null;
    }

    private static SBase removeEvent(SBase sbase, ListOf list) {
        String id = ((Event)sbase).getId();
        int i = 0;
        while ((long)i < list.size()) {
            Event c = (Event)list.get((long)i);
            if (id.equals(c.getId())) {
                return list.remove((long)i);
            }
            ++i;
        }
        return null;
    }

    private static SBase removeUnitDefinition(SBase sbase, ListOf list) {
        String id = ((UnitDefinition)sbase).getId();
        int i = 0;
        while ((long)i < list.size()) {
            UnitDefinition c = (UnitDefinition)list.get((long)i);
            if (id.equals(c.getId())) {
                return list.remove((long)i);
            }
            ++i;
        }
        return null;
    }

    private static SBase removeFunctionDefinition(SBase sbase, ListOf list) {
        String id = ((FunctionDefinition)sbase).getId();
        int i = 0;
        while ((long)i < list.size()) {
            FunctionDefinition c = (FunctionDefinition)list.get((long)i);
            if (id.equals(c.getId())) {
                return list.remove((long)i);
            }
            ++i;
        }
        return null;
    }

    private static SBase removeCompartment(SBase sbase, ListOf list) {
        String id = ((Compartment)sbase).getId();
        int i = 0;
        while ((long)i < list.size()) {
            Compartment c = (Compartment)list.get((long)i);
            if (id.equals(c.getId())) {
                return list.remove((long)i);
            }
            ++i;
        }
        return null;
    }

    private static SBase removeParameter(SBase sbase, ListOf list) {
        String id = ((Parameter)sbase).getId();
        int i = 0;
        while ((long)i < list.size()) {
            Parameter c = (Parameter)list.get((long)i);
            if (id.equals(c.getId())) {
                return list.remove((long)i);
            }
            ++i;
        }
        return null;
    }

    private static SBase removeRule(SBase sbase, ListOf list) {
        Rule rule = (Rule)sbase;
        int i = 0;
        while ((long)i < list.size()) {
            Rule c = (Rule)list.get((long)i);
            if (rule instanceof AlgebraicRule && c instanceof AlgebraicRule ? c.getFormula().equals(rule.getFormula()) : (rule instanceof AssignmentRule && c instanceof AssignmentRule ? c.getFormula().equals(rule.getFormula()) : rule instanceof RateRule && c instanceof RateRule && c.getFormula().equals(rule.getFormula()))) {
                return list.remove((long)i);
            }
            ++i;
        }
        return null;
    }

    private static SBase removeUnit(SBase sbase, ListOf list) {
        Unit unit = (Unit)sbase;
        int i = 0;
        while ((long)i < list.size()) {
            Unit c = (Unit)list.get((long)i);
            if (c.getKind() == unit.getKind() && c.getExponent() == unit.getExponent() && c.getMultiplier() == unit.getMultiplier() && c.getScale() == unit.getScale() && c.getOffset() == unit.getOffset()) {
                return list.remove((long)i);
            }
            ++i;
        }
        return null;
    }

    private static SBase removeSpeciesType(SBase sbase, ListOf list) {
        String id = ((SpeciesType)sbase).getId();
        int i = 0;
        while ((long)i < list.size()) {
            SpeciesType st = (SpeciesType)list.get((long)i);
            if (id.equals(st.getId())) {
                return list.remove((long)i);
            }
            ++i;
        }
        return null;
    }

    private static SBase removeCompartmentType(SBase sbase, ListOf list) {
        String id = ((CompartmentType)sbase).getId();
        int i = 0;
        while ((long)i < list.size()) {
            CompartmentType ct = (CompartmentType)list.get((long)i);
            if (id.equals(ct.getId())) {
                return list.remove((long)i);
            }
            ++i;
        }
        return null;
    }

    private static SBase removeInitialAssignment(SBase sbase, ListOf list) {
        if (sbase == null) {
            return null;
        }
        if (list == null || list.size() < 1L) {
            return null;
        }
        String id = ((InitialAssignment)sbase).getSymbol();
        int i = 0;
        while ((long)i < list.size()) {
            InitialAssignment ia = (InitialAssignment)list.get((long)i);
            if (id.equals(ia.getSymbol())) {
                return list.remove((long)i);
            }
            ++i;
        }
        return null;
    }

    private static SBase removeConstraint(SBase sbase, ListOf list) {
        if (sbase == null) {
            return null;
        }
        if (list == null || list.size() < 1L) {
            return null;
        }
        String math = libsbml.formulaToString((ASTNode)((Constraint)sbase).getMath());
        int i = 0;
        while ((long)i < list.size()) {
            Constraint ia = (Constraint)list.get((long)i);
            if (math.equals(libsbml.formulaToString((ASTNode)ia.getMath()))) {
                return list.remove((long)i);
            }
            ++i;
        }
        return null;
    }

    public static synchronized SBase[] toArray(ListOf list) {
        if (list == null) {
            return new SBase[0];
        }
        SBase[] array = new SBase[(int)list.size()];
        int i = 0;
        while ((long)i < list.size()) {
            array[i] = list.get((long)i);
            ++i;
        }
        return array;
    }

    public static String getElementClassName(String sbase, int list_const) {
        if (sbase.equals("Model")) {
            if (list_const == 14 || list_const == 15 || list_const == 16 || list_const == 17) {
                return model_elementClassName[list_const - 6];
            }
            if (list_const < 0 || list_const >= 12) {
                return "";
            }
            return model_elementClassName[list_const];
        }
        if (sbase.equals("UnitDefinition")) {
            if (list_const < 0 || list_const >= 1) {
                return "";
            }
            return unit_definition_elementClassName[list_const];
        }
        if (sbase.equals("Reaction")) {
            if (list_const < 0 || list_const >= 3) {
                return "";
            }
            return reaction_elementClassName[list_const];
        }
        if (sbase.equals("KineticLaw")) {
            if (list_const < 0 || list_const >= 3) {
                return "";
            }
            return kineticlaw_elementClassName[list_const];
        }
        if (sbase.equals("Event")) {
            if (list_const < 0 || list_const >= 1) {
                return "";
            }
            return event_elementClassName[list_const];
        }
        return null;
    }

    public static String getListTagName(String sbase, int list_const) {
        if (sbase.equals("UnitDefinition")) {
            if (list_const < 0 || list_const >= 1) {
                return "";
            }
            return unit_definition_listTagName[list_const];
        }
        if (sbase.equals("KineticLaw")) {
            if (list_const < 0 || list_const >= 3) {
                return "";
            }
            return kineticlaw_listTagName[list_const];
        }
        if (sbase.equals("Event")) {
            if (list_const < 0 || list_const >= 1) {
                return "";
            }
            return event_listTagName[list_const];
        }
        if (sbase.equals("Model")) {
            if (list_const == 14 || list_const == 15 || list_const == 16 || list_const == 17) {
                return model_listTagName[list_const - 6];
            }
            if (list_const < 0 || list_const >= 12) {
                return "";
            }
            return model_listTagName[list_const];
        }
        if (sbase.equals("Reaction")) {
            if (list_const < 0 || list_const >= 3) {
                return "";
            }
            return reaction_listTagName[list_const];
        }
        return null;
    }

    public static String[] fieldShortNames(SBase sbase) {
        int j;
        String[] attr = LibSBMLUtil.getAttributeShortNames(sbase);
        String[] notesAttr = null;
        String[] annotAttr = null;
        int len = attr.length;
        Any notes = LibSBMLUtil.getNotes(sbase, null);
        Any annotation = LibSBMLUtil.getAnnotation(sbase, null);
        if (notes != null) {
            notesAttr = notes.getAttributeShortNames();
            len += notesAttr.length;
        }
        if (!(annotation == null || sbase instanceof Protein || sbase instanceof RNA || sbase instanceof Gene || sbase instanceof AntiSenseRNA)) {
            annotAttr = annotation.getAttributeShortNames();
            len += annotAttr.length;
        }
        String[] rtn = new String[len];
        int i = 0;
        if (annotAttr != null) {
            j = 0;
            while (j < annotAttr.length) {
                rtn[i++] = annotAttr[j];
                ++j;
            }
        }
        if (notesAttr != null) {
            j = 0;
            while (j < notesAttr.length) {
                rtn[i++] = notesAttr[j];
                ++j;
            }
        }
        j = 0;
        while (j < attr.length) {
            rtn[i++] = attr[j];
            ++j;
        }
        return rtn;
    }

    private static String[] getAttributeShortNames(SBase sbase) {
        if (sbase instanceof RNA) {
            return new String[]{"id", "type", strNameASTNodePattern};
        }
        if (sbase instanceof Gene) {
            return new String[]{"id", "type", strNameASTNodePattern};
        }
        if (sbase instanceof Protein) {
            return new String[]{"id", "type", strNameASTNodePattern};
        }
        if (sbase instanceof ModificationRegion) {
            return new String[]{"id", strNameASTNodePattern, "type", speciesNameFontSizeLabel, "pos"};
        }
        if (sbase instanceof AntiSenseRNA) {
            return new String[]{"id", "type", strNameASTNodePattern};
        }
        if (sbase instanceof Species) {
            return new String[]{"id", strNameASTNodePattern, "speciesType", "compartment", "quantity type", "initialQuantity", "substanceUnits", "spatialSizeUnits", "hasOnlySubstanceUnits", "b.c.", "charge", "constants"};
        }
        if (sbase instanceof SpeciesReference) {
            return new String[]{"species", "stoichiometry", "stoichiometryMath"};
        }
        if (sbase instanceof ModifierSpeciesReference) {
            return new String[]{"speci."};
        }
        if (sbase instanceof SimpleSpeciesReference) {
            return null;
        }
        if (sbase instanceof FunctionDefinition) {
            return new String[]{"id", strNameASTNodePattern, "arguments", "math"};
        }
        if (sbase instanceof Event) {
            return new String[]{"id", strNameASTNodePattern, "trigger", "delay", "timeUnits", "useValuesFromTriggerTime", "variables"};
        }
        if (sbase instanceof Compartment) {
            return new String[]{"id", strNameASTNodePattern, "compartmentType", "spatialDimensions", speciesNameFontSizeLabel, "units", "outside", "constant"};
        }
        if (sbase instanceof ModificationResidue) {
            return new String[]{"id", strNameASTNodePattern, "side", ANGLE};
        }
        if (sbase instanceof BindingRegion) {
            return new String[]{"id", strNameASTNodePattern, speciesNameFontSizeLabel, ANGLE};
        }
        if (sbase instanceof KineticLaw) {
            return new String[]{"math", "timeUnits", "substanceUnits"};
        }
        if (sbase instanceof UnitDefinition) {
            return new String[]{"id", strNameASTNodePattern, "units"};
        }
        if (sbase instanceof Parameter) {
            return new String[]{"scope", "id", strNameASTNodePattern, "value", "units", "constant"};
        }
        if (sbase instanceof RateRule) {
            return new String[]{"variable"};
        }
        if (sbase instanceof AlgebraicRule) {
            return new String[]{"math"};
        }
        if (sbase instanceof EventAssignment) {
            return new String[]{"variable", "math"};
        }
        if (sbase instanceof Model) {
            return new String[]{"id", strNameASTNodePattern};
        }
        if (sbase instanceof Reaction) {
            return new String[]{"id", strNameASTNodePattern, "reversible", "fast", "reactants", "products", "modifiers", "math"};
        }
        if (sbase instanceof AssignmentRule) {
            if (sbase.getElementName().equals("speciesConcentrationRule")) {
                return new String[]{"form.", "type", "speci."};
            }
            if (sbase.getElementName().equals("specieConcentrationRule")) {
                return new String[]{"form.", "type", "speci."};
            }
            if (sbase.getElementName().equals("compartmentVolumeRule")) {
                return new String[]{"form.", "type", "comp."};
            }
            if (sbase.getElementName().equals("ParameterRule")) {
                return new String[]{"form.", "type", "param."};
            }
            return new String[]{"variable"};
        }
        if (sbase instanceof SBMLDocument) {
            return new String[]{"level", "ver."};
        }
        if (sbase instanceof Unit) {
            return new String[]{"kind", "exponent", "scale", "multiplier", "offset"};
        }
        if (sbase instanceof SpeciesType) {
            return new String[]{"id", strNameASTNodePattern};
        }
        if (sbase instanceof CompartmentType) {
            return new String[]{"id", strNameASTNodePattern};
        }
        if (sbase instanceof InitialAssignment) {
            return new String[]{"symbol", "math"};
        }
        if (sbase instanceof Constraint) {
            return new String[]{"math", "message"};
        }
        return null;
    }

    public static int[] fieldColumnSizes(SBase sbase) {
        int j;
        int[] attr = LibSBMLUtil.getAttributeColumnSizes(sbase);
        int[] notesAttr = null;
        int[] annotAttr = null;
        int len = attr.length;
        Any notes = LibSBMLUtil.getNotes(sbase, null);
        Any annotation = LibSBMLUtil.getAnnotation(sbase, null);
        if (notes != null) {
            notesAttr = notes.getAttributeColumnSizes();
            len += notesAttr.length;
        }
        if (!(annotation == null || sbase instanceof Protein || sbase instanceof RNA || sbase instanceof Gene || sbase instanceof AntiSenseRNA)) {
            annotAttr = annotation.getAttributeColumnSizes();
            len += annotAttr.length;
        }
        int[] rtn = new int[len];
        int i = 0;
        if (annotAttr != null) {
            j = 0;
            while (j < annotAttr.length) {
                rtn[i++] = annotAttr[j];
                ++j;
            }
        }
        if (notesAttr != null) {
            j = 0;
            while (j < notesAttr.length) {
                rtn[i++] = notesAttr[j];
                ++j;
            }
        }
        j = 0;
        while (j < attr.length) {
            rtn[i++] = attr[j];
            ++j;
        }
        return rtn;
    }

    private static int[] getAttributeColumnSizes(SBase sbase) {
        if (sbase instanceof RNA) {
            return new int[]{40, 120, 200};
        }
        if (sbase instanceof Gene) {
            return new int[]{40, 120, 200};
        }
        if (sbase instanceof Protein) {
            return new int[]{40, 120, 200};
        }
        if (sbase instanceof ModificationRegion) {
            return new int[]{70, 150, 85, 10, 10};
        }
        if (sbase instanceof AntiSenseRNA) {
            return new int[]{40, 120, 200};
        }
        if (sbase instanceof Species) {
            return new int[]{40, 100, 80, 60, 60, 100, 40, 50, 50, 40, 40, 30, 40};
        }
        if (sbase instanceof SpeciesReference) {
            return new int[]{60, 60, 200};
        }
        if (sbase instanceof ModifierSpeciesReference) {
            return new int[]{400};
        }
        if (sbase instanceof SimpleSpeciesReference) {
            return null;
        }
        if (sbase instanceof Compartment) {
            return new int[]{60, 80, 110, 40, 60, 60, 60, 40};
        }
        if (sbase instanceof Event) {
            return new int[]{30, 30, 150, 150, 30, 60};
        }
        if (sbase instanceof FunctionDefinition) {
            return new int[]{30, 30, 50, 200};
        }
        if (sbase instanceof ModificationResidue) {
            return new int[]{70, 150, 85, 10};
        }
        if (sbase instanceof BindingRegion) {
            return new int[]{70, 150, 85, 10};
        }
        if (sbase instanceof KineticLaw) {
            return new int[]{300, 70, 70};
        }
        if (sbase instanceof UnitDefinition) {
            return new int[]{80, 80, 200};
        }
        if (sbase instanceof Parameter) {
            return new int[]{90, 60, 60, 60, 60, 60};
        }
        if (sbase instanceof RateRule) {
            return new int[]{200, 60};
        }
        if (sbase instanceof AlgebraicRule) {
            return new int[]{300};
        }
        if (sbase instanceof EventAssignment) {
            return new int[]{60, 280};
        }
        if (sbase instanceof Model) {
            return new int[]{70, 200};
        }
        if (sbase instanceof Reaction) {
            return new int[]{40, 60, 40, 40, 80, 80, 80, 200};
        }
        if (sbase instanceof AssignmentRule) {
            if (sbase.getElementName().equals("speciesConcentrationRule")) {
                return new int[]{300, 70, 70};
            }
            if (sbase.getElementName().equals("specieConcentrationRule")) {
                return new int[]{300, 70, 70};
            }
            if (sbase.getElementName().equals("compartmentVolumeRule")) {
                return new int[]{300, 70, 70};
            }
            if (sbase.getElementName().equals("ParameterRule")) {
                return new int[]{300, 70, 70};
            }
            return new int[]{200, 60};
        }
        if (sbase instanceof SBMLDocument) {
            return new int[]{40, 40};
        }
        if (sbase instanceof Unit) {
            return new int[]{80, 60, 60, 70, 70};
        }
        if (sbase instanceof SpeciesType) {
            return new int[]{80, 60};
        }
        if (sbase instanceof CompartmentType) {
            return new int[]{80, 60};
        }
        if (sbase instanceof InitialAssignment) {
            return new int[]{80, 100};
        }
        if (sbase instanceof Constraint) {
            return new int[]{100, 120};
        }
        return null;
    }

    public static String addNamespace(String xml, String name) {
        if (name.equals("annotation")) {
            String n;
            if (xml.indexOf("<annotation>") != -1) {
                StringBuffer buf = new StringBuffer("<annotation");
                Set set = SBModel.currentNameSpaceHash.keySet();
                for (String key : set) {
                    String n2 = (String)SBModel.currentNameSpaceHash.get(key);
                    if (n2.indexOf("http://www.sbml.org/sbml") != -1) continue;
                    if (key.equals("")) {
                        buf.append(" xmlns");
                    } else {
                        buf.append(" xmlns:");
                        buf.append(key);
                    }
                    buf.append("=\"");
                    buf.append(n2);
                    buf.append(Mark1);
                }
                buf.append(endMark1);
                return StringTool.replaceString(xml, "<annotation>", buf.toString());
            }
            if (xml == null || xml.equals("") || xml.indexOf(LineChangeMark) <= 0) {
                return xml;
            }
            String tag = xml.substring(0, xml.indexOf(LineChangeMark));
            String temptag = new String(tag);
            HashMap<String, String> hash = new HashMap<String, String>();
            while (tag.indexOf("xmlns:") != -1) {
                int index = tag.indexOf("xmlns:");
                String xmlns = tag.substring(index + "xmlns:".length(), tag.length());
                String key = xmlns.substring(0, xmlns.indexOf(Mark3));
                String forname = xmlns.substring((String.valueOf(key) + "=\"").length());
                n = forname.substring(0, forname.indexOf(Mark1));
                hash.put(key, n);
                tag = xmlns.substring((String.valueOf(key) + Mark3 + Mark1 + n + Mark1).length(), xmlns.length());
            }
            StringBuffer buf = new StringBuffer("<annotation");
            Set set = SBModel.currentNameSpaceHash.keySet();
            for (String key : set) {
                n = (String)SBModel.currentNameSpaceHash.get(key);
                if (n.indexOf("http://www.sbml.org/sbml") != -1) continue;
                if (key.equals("")) {
                    buf.append(" xmlns");
                } else {
                    buf.append(" xmlns:");
                    buf.append(key);
                }
                buf.append("=\"");
                buf.append(n);
                buf.append(Mark1);
            }
            set = hash.keySet();
            for (String key : set) {
                n = (String)hash.get(key);
                if (SBModel.currentNameSpaceHash.get(key) != null) continue;
                if (key.equals("")) {
                    buf.append(" xmlns");
                } else {
                    buf.append(" xmlns:");
                    buf.append(key);
                }
                buf.append("=\"");
                buf.append(n);
                buf.append(Mark1);
            }
            buf.append(endMark1);
            return StringTool.replaceString(xml, temptag, buf.toString());
        }
        if (name.equals(NOTES) && !xml.equals("")) {
            StringBuffer buf = new StringBuffer();
            buf.append(xml);
            return buf.toString();
        }
        return xml;
    }

    public static Any getNotes(SBase sbase, SpecInfo spec) {
        if (MainWindow.getLastInstance() == null || MainWindow.getLastInstance().getCurrentModel() == null) {
            return LibSBMLUtil.readNotesDOMTree(sbase, null);
        }
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        Any any = null;
        if (sbase instanceof Model) {
            Model model = (Model)sbase;
            HashMap hashModelNotes = sbModel.getHashModelNotes();
            any = (Any)hashModelNotes.get(model.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashModelNotes.put(model.getId(), any);
            }
        } else if (sbase instanceof Protein) {
            Protein base = (Protein)sbase;
            HashMap hashProteinNotes = sbModel.getHashProteinNotes();
            any = (Any)hashProteinNotes.get(base.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashProteinNotes.put(base.getId(), any);
            }
        } else if (sbase instanceof Gene) {
            Gene base = (Gene)sbase;
            HashMap hashGeneNotes = sbModel.getHashGeneNotes();
            any = (Any)hashGeneNotes.get(base.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashGeneNotes.put(base.getId(), any);
            }
        } else if (sbase instanceof RNA) {
            RNA base = (RNA)sbase;
            HashMap hashRNANotes = sbModel.getHashRNANotes();
            any = (Any)hashRNANotes.get(base.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashRNANotes.put(base.getId(), any);
            }
        } else if (sbase instanceof AntiSenseRNA) {
            AntiSenseRNA base = (AntiSenseRNA)sbase;
            HashMap hashAntiSenseRNANotes = sbModel.getHashAntiSenseRNANotes();
            any = (Any)hashAntiSenseRNANotes.get(base.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashAntiSenseRNANotes.put(base.getId(), any);
            }
        } else if (sbase instanceof Species) {
            Species species = (Species)sbase;
            HashMap hashSpeciesNotes = sbModel.getHashSpeciesNotes();
            any = (Any)hashSpeciesNotes.get(species.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                if (!sbModel.isNotRegiestNotesToSBModel && !sbModel.bSkipThisNote) {
                    hashSpeciesNotes.put(species.getId(), any);
                }
            }
        } else if (sbase instanceof Compartment) {
            Compartment compartment = (Compartment)sbase;
            HashMap hashCompartmentNotes = sbModel.getHashCompartmentNotes();
            any = (Any)hashCompartmentNotes.get(compartment.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashCompartmentNotes.put(compartment.getId(), any);
            }
        } else if (sbase instanceof Reaction) {
            Reaction reaction = (Reaction)sbase;
            HashMap hashReactionNotes = sbModel.getHashReactionNotes();
            any = (Any)hashReactionNotes.get(reaction.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashReactionNotes.put(reaction.getId(), any);
            }
        } else if (sbase instanceof Parameter) {
            Parameter parameter = (Parameter)sbase;
            String strkey = LibSBMLUtil.getHashKey(parameter, parameter.getId());
            HashMap hashParameterNotes = sbModel.getHashParameterNotes();
            any = (Any)hashParameterNotes.get(strkey);
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashParameterNotes.put(strkey, any);
            }
        } else if (sbase instanceof FunctionDefinition) {
            FunctionDefinition functionDefinition = (FunctionDefinition)sbase;
            HashMap hashFunctionNotes = sbModel.getHashFunctionNotes();
            any = (Any)hashFunctionNotes.get(functionDefinition.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashFunctionNotes.put(functionDefinition.getId(), any);
            }
        } else if (sbase instanceof UnitDefinition) {
            UnitDefinition unit = (UnitDefinition)sbase;
            HashMap hashUnitNotes = sbModel.getHashUnitNotes();
            any = (Any)hashUnitNotes.get(unit.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashUnitNotes.put(unit.getId(), any);
            }
        } else if (sbase instanceof Rule) {
            Rule rule = (Rule)sbase;
            HashMap hashRuleNotes = sbModel.getHashRuleNotes();
            any = (Any)hashRuleNotes.get(rule.getFormula());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashRuleNotes.put(rule.getFormula(), any);
            }
        } else if (sbase instanceof Event) {
            Event event = (Event)sbase;
            HashMap hashEventNotes = sbModel.getHashEventNotes();
            any = (Any)hashEventNotes.get(event.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashEventNotes.put(event.getId(), any);
            }
        } else if (sbase instanceof SpeciesType) {
            SpeciesType speciesType = (SpeciesType)sbase;
            HashMap hashSpeciesTypeNotes = sbModel.getHashSpeciesTypeNotes();
            any = (Any)hashSpeciesTypeNotes.get(speciesType.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashSpeciesTypeNotes.put(speciesType.getId(), any);
            }
        } else if (sbase instanceof CompartmentType) {
            CompartmentType compartmentType = (CompartmentType)sbase;
            HashMap hashCompartmentTypeNotes = sbModel.getHashCompartmentTypeNotes();
            any = (Any)hashCompartmentTypeNotes.get(compartmentType.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashCompartmentTypeNotes.put(compartmentType.getId(), any);
            }
        } else if (sbase instanceof InitialAssignment) {
            InitialAssignment initialAssignment = (InitialAssignment)sbase;
            HashMap hashInitialAssignmentNotes = sbModel.getHashInitialAssignmentNotes();
            any = (Any)hashInitialAssignmentNotes.get(initialAssignment.getSymbol());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashInitialAssignmentNotes.put(initialAssignment.getSymbol(), any);
            }
        } else if (sbase instanceof Constraint) {
            Constraint constraint = (Constraint)sbase;
            HashMap hashConstraintNotes = sbModel.getHashConstraintNotes();
            ASTNode math = constraint.getMath();
            String strMath = "";
            if (math != null) {
                strMath = libsbml.formulaToString((ASTNode)math);
            }
            if ((any = (Any)hashConstraintNotes.get(strMath)) == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashConstraintNotes.put(strMath, any);
            }
        } else if (sbase instanceof KineticLaw) {
            KineticLaw kineticLaw = (KineticLaw)sbase;
        }
        try {
            sbase.unsetNotes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return any;
    }

    public static Any getNotes(SBModel sbModel, SBase sbase, SpecInfo spec) {
        Any any = null;
        if (sbase instanceof Model) {
            Model model = (Model)sbase;
            HashMap hashModelNotes = sbModel.getHashModelNotes();
            any = (Any)hashModelNotes.get(model.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashModelNotes.put(model.getId(), any);
            }
        } else if (sbase instanceof Protein) {
            Protein base = (Protein)sbase;
            HashMap hashProteinNotes = sbModel.getHashProteinNotes();
            any = (Any)hashProteinNotes.get(base.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashProteinNotes.put(base.getId(), any);
            }
        } else if (sbase instanceof Gene) {
            Gene base = (Gene)sbase;
            HashMap hashGeneNotes = sbModel.getHashGeneNotes();
            any = (Any)hashGeneNotes.get(base.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashGeneNotes.put(base.getId(), any);
            }
        } else if (sbase instanceof RNA) {
            RNA base = (RNA)sbase;
            HashMap hashRNANotes = sbModel.getHashRNANotes();
            any = (Any)hashRNANotes.get(base.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashRNANotes.put(base.getId(), any);
            }
        } else if (sbase instanceof AntiSenseRNA) {
            AntiSenseRNA base = (AntiSenseRNA)sbase;
            HashMap hashAntiSenseRNANotes = sbModel.getHashAntiSenseRNANotes();
            any = (Any)hashAntiSenseRNANotes.get(base.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashAntiSenseRNANotes.put(base.getId(), any);
            }
        } else if (sbase instanceof Species) {
            Species species = (Species)sbase;
            HashMap hashSpeciesNotes = sbModel.getHashSpeciesNotes();
            any = (Any)hashSpeciesNotes.get(species.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashSpeciesNotes.put(species.getId(), any);
            }
        } else if (sbase instanceof Compartment) {
            Compartment compartment = (Compartment)sbase;
            HashMap hashCompartmentNotes = sbModel.getHashCompartmentNotes();
            any = (Any)hashCompartmentNotes.get(compartment.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashCompartmentNotes.put(compartment.getId(), any);
            }
        } else if (sbase instanceof Parameter) {
            Parameter parameter = (Parameter)sbase;
            String strkey = LibSBMLUtil.getHashKey(parameter, parameter.getId());
            HashMap hashParameterNotes = sbModel.getHashParameterNotes();
            any = (Any)hashParameterNotes.get(strkey);
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashParameterNotes.put(strkey, any);
            }
        } else if (sbase instanceof FunctionDefinition) {
            FunctionDefinition functionDefinition = (FunctionDefinition)sbase;
            HashMap hashFunctionNotes = sbModel.getHashFunctionNotes();
            any = (Any)hashFunctionNotes.get(functionDefinition.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashFunctionNotes.put(functionDefinition.getId(), any);
            }
        } else if (sbase instanceof UnitDefinition) {
            UnitDefinition unit = (UnitDefinition)sbase;
            HashMap hashUnitNotes = sbModel.getHashUnitNotes();
            any = (Any)hashUnitNotes.get(unit.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashUnitNotes.put(unit.getId(), any);
            }
        } else if (sbase instanceof Rule) {
            Rule rule = (Rule)sbase;
            HashMap hashRuleNotes = sbModel.getHashRuleNotes();
            any = (Any)hashRuleNotes.get(rule.getFormula());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashRuleNotes.put(rule.getFormula(), any);
            }
        } else if (sbase instanceof Event) {
            Event event = (Event)sbase;
            HashMap hashEventNotes = sbModel.getHashEventNotes();
            any = (Any)hashEventNotes.get(event.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashEventNotes.put(event.getId(), any);
            }
        } else if (sbase instanceof SpeciesType) {
            SpeciesType speciesType = (SpeciesType)sbase;
            HashMap hashSpeciesTypeNotes = sbModel.getHashSpeciesTypeNotes();
            any = (Any)hashSpeciesTypeNotes.get(speciesType.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashSpeciesTypeNotes.put(speciesType.getId(), any);
            }
        } else if (sbase instanceof CompartmentType) {
            CompartmentType compartmentType = (CompartmentType)sbase;
            HashMap hashCompartmentTypeNotes = sbModel.getHashCompartmentTypeNotes();
            any = (Any)hashCompartmentTypeNotes.get(compartmentType.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashCompartmentTypeNotes.put(compartmentType.getId(), any);
            }
        } else if (sbase instanceof InitialAssignment) {
            InitialAssignment initialAssignment = (InitialAssignment)sbase;
            HashMap hashInitialAssignmentNotes = sbModel.getHashInitialAssignmentNotes();
            any = (Any)hashInitialAssignmentNotes.get(initialAssignment.getSymbol());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashInitialAssignmentNotes.put(initialAssignment.getSymbol(), any);
            }
        } else if (sbase instanceof Constraint) {
            Constraint constraint = (Constraint)sbase;
            HashMap hashConstraintNotes = sbModel.getHashConstraintNotes();
            ASTNode math = constraint.getMath();
            String strMath = "";
            if (math != null) {
                strMath = libsbml.formulaToString((ASTNode)math);
            }
            if ((any = (Any)hashConstraintNotes.get(strMath)) == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashConstraintNotes.put(strMath, any);
            }
        } else if (sbase instanceof Reaction) {
            Reaction reaction = (Reaction)sbase;
            HashMap hashReactionNotes = sbModel.getHashReactionNotes();
            any = (Any)hashReactionNotes.get(reaction.getId());
            if (any == null) {
                any = LibSBMLUtil.readNotesDOMTree(sbase, spec);
                hashReactionNotes.put(reaction.getId(), any);
            }
        } else if (sbase instanceof KineticLaw) {
            KineticLaw kineticLaw = (KineticLaw)sbase;
        }
        try {
            sbase.unsetNotes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return any;
    }

    public static Any getAnnotation(SBModel sbModel, SBase sbase, SpecInfo spec) {
        Any any = null;
        if (sbase instanceof Protein || sbase instanceof Gene || sbase instanceof RNA || sbase instanceof AntiSenseRNA) {
            any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
        } else if (sbase instanceof Species) {
            Species species = (Species)sbase;
            HashMap hashSpeciesAnnotation = sbModel.getHashSpeciesAnnotation();
            any = (Any)hashSpeciesAnnotation.get(species.getId());
            if (any == null) {
                any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
                hashSpeciesAnnotation.put(species.getId(), any);
            }
        } else if (sbase instanceof Model) {
            Model model = (Model)sbase;
            HashMap hashModelAnnotation = sbModel.getHashModelAnnotation();
            any = (Any)hashModelAnnotation.get(model.getId());
            if (any == null) {
                any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
                hashModelAnnotation.put(model.getId(), any);
            }
        } else if (sbase instanceof Compartment) {
            Compartment compartment = (Compartment)sbase;
            HashMap hashCompartmentAnnotation = sbModel.getHashCompartmentAnnotation();
            any = (Any)hashCompartmentAnnotation.get(compartment.getId());
            if (any == null) {
                any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
                hashCompartmentAnnotation.put(compartment.getId(), any);
            }
        } else if (sbase instanceof Reaction) {
            Reaction reaction = (Reaction)sbase;
            HashMap hashReactionAnnotation = sbModel.getHashReactionAnnotation();
            any = (Any)hashReactionAnnotation.get(reaction.getId());
            if (any == null) {
                any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
                hashReactionAnnotation.put(reaction.getId(), any);
            }
        } else {
            return SBMLControl.factory.createAny(new Species().getClass().getName(), 1002);
        }
        try {
            if (!(sbase instanceof Parameter)) {
                boolean cfr_ignored_0 = sbase instanceof KineticLaw;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return any;
    }

    public static Any getAnnotation(SBase sbase, SpecInfo spec) {
        if (MainWindow.getLastInstance() == null || MainWindow.getLastInstance().getCurrentModel() == null) {
            return LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
        }
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        Any any = null;
        if (sbase instanceof Protein || sbase instanceof Gene || sbase instanceof RNA || sbase instanceof AntiSenseRNA) {
            any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
        } else if (sbase instanceof Species) {
            Species species = (Species)sbase;
            HashMap hashSpeciesAnnotation = sbModel.getHashSpeciesAnnotation();
            any = (Any)hashSpeciesAnnotation.get(species.getId());
            if (any == null) {
                any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
                hashSpeciesAnnotation.put(species.getId(), any);
            }
        } else if (sbase instanceof Model) {
            Model model = (Model)sbase;
            HashMap hashModelAnnotation = sbModel.getHashModelAnnotation();
            any = (Any)hashModelAnnotation.get(model.getId());
            if (any == null) {
                any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
                hashModelAnnotation.put(model.getId(), any);
            }
        } else if (sbase instanceof Compartment) {
            Compartment compartment = (Compartment)sbase;
            HashMap hashCompartmentAnnotation = sbModel.getHashCompartmentAnnotation();
            any = (Any)hashCompartmentAnnotation.get(compartment.getId());
            if (any == null) {
                any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
                hashCompartmentAnnotation.put(compartment.getId(), any);
            }
        } else if (sbase instanceof Reaction) {
            Reaction reaction = (Reaction)sbase;
            HashMap hashReactionAnnotation = sbModel.getHashReactionAnnotation();
            any = (Any)hashReactionAnnotation.get(reaction.getId());
            if (any == null) {
                any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
                hashReactionAnnotation.put(reaction.getId(), any);
            }
        }
        try {
            if (!(sbase instanceof Parameter)) {
                boolean cfr_ignored_0 = sbase instanceof KineticLaw;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return any;
    }

    public static Any getAnnotation(SBModel sbModel, Reaction parent, SBase sbase, String type, int index, SpecInfo spec) {
        Any any = null;
        if (sbase instanceof SpeciesReference) {
            HashMap hashSpeciesReferenceAnnotation;
            SpeciesReference ref = (SpeciesReference)sbase;
            if (type.equals("Reactants")) {
                HashMap hashSpeciesReferenceAnnotation2 = sbModel.getHashSpeciesReferenceReactantsAnnotation();
                any = (Any)hashSpeciesReferenceAnnotation2.get(LibSBMLUtil.getSpeciesReferenceReactantKey(parent.getId(), index));
                if (any == null) {
                    any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
                    hashSpeciesReferenceAnnotation2.put(LibSBMLUtil.getSpeciesReferenceReactantKey(parent.getId(), index), any);
                }
            } else if (type.equals("Products") && (any = (Any)(hashSpeciesReferenceAnnotation = sbModel.getHashSpeciesReferenceProductsAnnotation()).get(LibSBMLUtil.getSpeciesReferenceProductKey(parent.getId(), index))) == null) {
                any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
                hashSpeciesReferenceAnnotation.put(LibSBMLUtil.getSpeciesReferenceProductKey(parent.getId(), index), any);
            }
        } else if (sbase instanceof ModifierSpeciesReference) {
            ModifierSpeciesReference ref = (ModifierSpeciesReference)sbase;
            HashMap hashModifierSpeciesReferenceAnnotation = sbModel.getHashModifierSpeciesReferenceAnnotation();
            any = (Any)hashModifierSpeciesReferenceAnnotation.get(LibSBMLUtil.getSpeciesReferenceModifierKey(parent.getId(), index));
            if (any == null) {
                any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
                hashModifierSpeciesReferenceAnnotation.put(LibSBMLUtil.getSpeciesReferenceModifierKey(parent.getId(), index), any);
            }
        }
        try {
            if (!(sbase instanceof Parameter)) {
                boolean cfr_ignored_0 = sbase instanceof KineticLaw;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return any;
    }

    public static Any getAnnotation(Reaction parent, SBase sbase, String type, int index, SpecInfo spec) {
        if (MainWindow.getLastInstance() == null || MainWindow.getLastInstance().getCurrentModel() == null) {
            return LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
        }
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        Any any = null;
        if (sbase instanceof SpeciesReference) {
            HashMap hashSpeciesReferenceAnnotation;
            SpeciesReference ref = (SpeciesReference)sbase;
            if (type.equals("Reactants")) {
                HashMap hashSpeciesReferenceAnnotation2 = sbModel.getHashSpeciesReferenceReactantsAnnotation();
                any = (Any)hashSpeciesReferenceAnnotation2.get(LibSBMLUtil.getSpeciesReferenceReactantKey(parent.getId(), index));
                if (any == null) {
                    any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
                    hashSpeciesReferenceAnnotation2.put(LibSBMLUtil.getSpeciesReferenceReactantKey(parent.getId(), index), any);
                }
            } else if (type.equals("Products") && (any = (Any)(hashSpeciesReferenceAnnotation = sbModel.getHashSpeciesReferenceProductsAnnotation()).get(LibSBMLUtil.getSpeciesReferenceProductKey(parent.getId(), index))) == null) {
                any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
                hashSpeciesReferenceAnnotation.put(LibSBMLUtil.getSpeciesReferenceProductKey(parent.getId(), index), any);
            }
        } else if (sbase instanceof ModifierSpeciesReference) {
            ModifierSpeciesReference ref = (ModifierSpeciesReference)sbase;
            HashMap hashModifierSpeciesReferenceAnnotation = sbModel.getHashModifierSpeciesReferenceAnnotation();
            any = (Any)hashModifierSpeciesReferenceAnnotation.get(LibSBMLUtil.getSpeciesReferenceModifierKey(parent.getId(), index));
            if (any == null) {
                any = LibSBMLUtil.readAnnotationDOMTree(sbase, spec);
                hashModifierSpeciesReferenceAnnotation.put(LibSBMLUtil.getSpeciesReferenceModifierKey(parent.getId(), index), any);
            }
        }
        try {
            if (!(sbase instanceof Parameter)) {
                boolean cfr_ignored_0 = sbase instanceof KineticLaw;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return any;
    }

    private static Any readNotesDOMTree(SBase sbase, SpecInfo spec) {
        if (sbase == null) {
            return SBMLControl.factory.createAny(new Model().getClass().getName(), 1001);
        }
        try {
            String notes = LibSBMLUtil.addNamespace(sbase.getNotesString(), NOTES);
            if (enableDebugLibSBML3) {
                System.out.print("[DEBUG:notes] (sbase type) " + sbase.getElementName());
                if (sbase instanceof SimpleSpeciesReference) {
                    SimpleSpeciesReference ssr = (SimpleSpeciesReference)sbase;
                    System.out.println(" (species id) " + ssr.getSpecies());
                } else {
                    System.out.println(" (id) " + sbase.getId() + " (name) " + sbase.getName());
                }
                if (!notes.equals("")) {
                    System.out.println("----------------------------------------------------------------");
                    System.out.print(notes);
                    System.out.print("----------------------------------------------------------------");
                } else {
                    System.out.print("no notes string!!");
                }
                System.out.println(LineChangeMark);
            }
            if (notes.equals("") || notes.equals(Mark5)) {
                Any any = SBMLControl.factory.createAny(sbase.getClass().getName(), 1001);
                if (any != null) {
                    any.setParentSBase(sbase);
                }
                return SBMLControl.factory.createAny(sbase.getClass().getName(), 1001);
            }
            notes = notes.trim();
            StringReader sr = new StringReader(notes);
            InputSource is = new InputSource(sr);
            Document doc = builder.parse(new InputSource(new StringReader(notes)));
            Element root = doc.getDocumentElement();
            notes = null;
            is = null;
            sr = null;
            String className = sbase.getClass().getName();
            Any any = SBMLControl.factory.createAny(className, 1001);
            if (any != null) {
                any.readDOMTree(root);
                any.setParentSBase(sbase);
                doc = null;
                root = null;
                return any;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readKineticLawAnnotation(KineticLaw kin) {
        String annotation;
        String returnString;
        block12: {
            returnString = "";
            annotation = LibSBMLUtil.addNamespace(kin.getAnnotationString(), "annotation");
            if (!annotation.equals("") && !annotation.equals(Mark5)) break block12;
            return "";
        }
        try {
            StringReader sr = new StringReader(annotation);
            InputSource is = new InputSource(sr);
            Document doc = builder.parse(is);
            Element root = doc.getDocumentElement();
            NodeList childlistTop = root.getChildNodes();
            NodeList childlistCellD = null;
            NodeList childlist = null;
            int iLoopMaxTimes = 2;
            int iLoopMax = 2;
            boolean bCellDVerMaxThan401 = false;
            childlist = childlistTop;
            do {
                int childsize = childlist.getLength();
                int i = 0;
                while (i < childsize) {
                    Node node = childlist.item(i);
                    if (node.getNodeType() == 1 && ((Element)node).getPrefix() != null && ((Element)node).getPrefix().equals(TAG_CELLDESIGNER_PREFIX) && ((Element)node).getLocalName() != null && ((Element)node).getLocalName().equals(TAG_CELLDESIGNER_EXTENSIONTOPLEVEL)) {
                        childlistCellD = node.getChildNodes();
                        if (childlistCellD == null || childlist.getLength() <= 0) {
                            throw new Exception();
                        }
                        bCellDVerMaxThan401 = true;
                    } else if (node.getNodeType() == 1 && "http://www.sbml.org/2001/ns/celldesigner".equals(node.getNamespaceURI())) {
                        String str;
                        Element elem = (Element)node;
                        String tag = elem.getLocalName();
                        if (elem.getLocalName().equals("selectedFunction") && !(str = elem.getFirstChild().getNodeValue()).equals("")) {
                            try {
                                returnString = str;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    ++i;
                }
                if (!bCellDVerMaxThan401) return returnString;
                childlist = childlistCellD;
            } while (--iLoopMax > 0);
            return returnString;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static Any readAnnotationDOMTree(SBase sbase, SpecInfo spec) {
        if (sbase == null) {
            return SBMLControl.factory.createAny(new Model().getClass().getName(), 1002);
        }
        try {
            String annotation = LibSBMLUtil.addNamespace(sbase.getAnnotationString(), "annotation");
            if (enableDebugLibSBML3) {
                System.out.print("[DEBUG:annotation] (sbase type) " + sbase.getElementName());
                if (sbase instanceof SimpleSpeciesReference) {
                    SimpleSpeciesReference ssr = (SimpleSpeciesReference)sbase;
                    System.out.println(" (species id) " + ssr.getSpecies());
                } else {
                    System.out.println(" (id) " + sbase.getId() + " (name) " + sbase.getName());
                }
                if (!annotation.equals("")) {
                    System.out.println("----------------------------------------------------------------");
                    System.out.println(annotation);
                    System.out.print("----------------------------------------------------------------");
                } else {
                    System.out.print("no annotation string!!");
                }
                System.out.println(LineChangeMark);
            }
            if (annotation.equals("") || annotation.equals(Mark5)) {
                Any any = SBMLControl.factory.createAny(sbase.getClass().getName(), 1002);
                if (any != null) {
                    any.setParentSBase(sbase);
                }
                return any;
            }
            StringReader sr = new StringReader(annotation);
            InputSource is = new InputSource(sr);
            Document doc = builder.parse(is);
            Element root = doc.getDocumentElement();
            annotation = null;
            is = null;
            sr = null;
            String className = sbase.getClass().getName();
            Any any = SBMLControl.factory.createAny(className, 1002);
            if (any != null) {
                any.readDOMTree(root);
                any.setParentSBase(sbase);
                doc = null;
                root = null;
                return any;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void readDOMTree(SBase sbase, Element element, SpecInfo spec) throws Exception {
        if (element == null) {
            return;
        }
        String URI2 = element.getNamespaceURI();
        LibSBMLUtil.readNotesAndAnnotationDOMTree(sbase, element, spec);
        String[] names = LibSBMLUtil.getAttributeNames(sbase, spec);
        String[] values = new String[names.length];
        int i = 0;
        while (i < names.length) {
            values[i] = element.getAttributeNS(null, names[i]);
            ++i;
        }
        LibSBMLUtil.setAttributeValues(sbase, values, spec);
        if (LibSBMLUtil.hasChildNodes(sbase)) {
            LibSBMLUtil.readChildNodesDOMTree(sbase, element, spec);
        }
    }

    private static void readNotesAndAnnotationDOMTree(SBase sbase, Element element, SpecInfo spec) throws Exception {
        if (element == null) {
            return;
        }
        if (!element.hasChildNodes()) {
            return;
        }
        if (SBMLControl.factory == null) {
            return;
        }
        String URI2 = element.getNamespaceURI();
        String className = sbase.getClass().getName();
        Node node = element.getFirstChild();
        do {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(URI2)) continue;
            String name = node.getLocalName();
            if (name.equals(NOTES)) {
                Any any = SBMLControl.factory.createAny(className, 1001);
                if (any == null) continue;
                String s = ((jp.sbi.celldesigner.sbmlExtension.Notes)any).readDOMTreeReturnString((Element)node);
                sbase.setNotes(s);
            } else {
                if (!name.equals("annotation") && (!spec.isEqual(1, 1) || !name.equals("annotations"))) continue;
                StringBuffer buf = new StringBuffer();
                buf.append(TAG_START_ANNOTATION);
                buf.append(LineChangeMark);
                NodeList childlist = node.getChildNodes();
                int childsize = childlist.getLength();
                int i = 0;
                while (i < childsize) {
                    Node item = childlist.item(i);
                    if (item.getNodeType() == 1 && item.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                        String state;
                        String residue;
                        Element ggelem;
                        Node ggnode;
                        int h;
                        int ggchildsize;
                        NodeList grandgrandchild;
                        String str;
                        Node gnode;
                        int j;
                        int grandchildsize;
                        NodeList grandchild;
                        String readingSomeId;
                        String str2;
                        String tag2;
                        Element elem2;
                        Node node2;
                        int k;
                        int childsize2;
                        NodeList childlist2;
                        String s;
                        Element elem = (Element)item;
                        String tag = elem.getLocalName();
                        if (elem.getLocalName().equals(POSITION_TO_COMPARTMENT)) {
                            s = elem.getFirstChild().getNodeValue();
                            buf.append(TAG_START_CELLDESIGNER);
                            buf.append(POSITION_TO_COMPARTMENT);
                            buf.append(endMark1);
                            buf.append(s);
                            buf.append(TAG_END_CELLDESIGNER);
                            buf.append(POSITION_TO_COMPARTMENT);
                            buf.append(">\n");
                        } else if (elem.getLocalName().equals(COMPLEX_SPECIES)) {
                            s = elem.getFirstChild().getNodeValue();
                            buf.append(TAG_START_CELLDESIGNER);
                            buf.append(COMPLEX_SPECIES);
                            buf.append(endMark1);
                            buf.append(s);
                            buf.append(TAG_END_CELLDESIGNER);
                            buf.append(COMPLEX_SPECIES);
                            buf.append(">\n");
                        } else if (elem.getLocalName().equals(SPECIES_IDENTITY)) {
                            buf.append(TAG_START_CELLDESIGNER);
                            buf.append(SPECIES_IDENTITY);
                            buf.append(">\n");
                            childlist2 = elem.getChildNodes();
                            childsize2 = childlist2.getLength();
                            k = 0;
                            while (k < childsize2) {
                                node2 = childlist2.item(k);
                                if (node2.getNodeType() == 1 && node2.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                                    elem2 = (Element)node2;
                                    tag2 = elem2.getLocalName();
                                    if (tag2.equals(CLASS)) {
                                        str2 = elem2.getFirstChild().getNodeValue();
                                        buf.append(TAG_START_CELLDESIGNER);
                                        buf.append(CLASS);
                                        buf.append(endMark1);
                                        buf.append(str2);
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append(CLASS);
                                        buf.append(">\n");
                                    } else if (tag2.equals(strNameASTNodePattern)) {
                                        str2 = elem2.getFirstChild().getNodeValue();
                                        buf.append(TAG_START_CELLDESIGNER);
                                        buf.append("name>");
                                        buf.append(str2);
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append("name>\n");
                                    } else if (tag2.equals(HYPOTHETICAL)) {
                                        str2 = elem2.getFirstChild().getNodeValue();
                                        buf.append(TAG_START_CELLDESIGNER);
                                        buf.append(HYPOTHETICAL);
                                        buf.append(endMark1);
                                        buf.append(str2);
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append(HYPOTHETICAL);
                                        buf.append(">\n");
                                    } else if (tag2.equals(PROTEIN_REFERENCE)) {
                                        readingSomeId = elem2.getFirstChild().getNodeValue();
                                        buf.append(TAG_START_CELLDESIGNER);
                                        buf.append(PROTEIN_REFERENCE);
                                        buf.append(endMark1);
                                        buf.append(readingSomeId);
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append(PROTEIN_REFERENCE);
                                        buf.append(">\n");
                                    } else if (tag2.equals(GENE_REFERENCE)) {
                                        readingSomeId = elem2.getFirstChild().getNodeValue();
                                        buf.append(TAG_START_CELLDESIGNER);
                                        buf.append(GENE_REFERENCE);
                                        buf.append(endMark1);
                                        buf.append(readingSomeId);
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append(GENE_REFERENCE);
                                        buf.append(">\n");
                                    } else if (tag2.equals(RNA_REFERENCE)) {
                                        readingSomeId = elem2.getFirstChild().getNodeValue();
                                        buf.append(TAG_START_CELLDESIGNER);
                                        buf.append(RNA_REFERENCE);
                                        buf.append(endMark1);
                                        buf.append(readingSomeId);
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append(RNA_REFERENCE);
                                        buf.append(">\n");
                                    } else if (tag2.equals(ASRNA_REFERENCE)) {
                                        readingSomeId = elem2.getFirstChild().getNodeValue();
                                        buf.append(TAG_START_CELLDESIGNER);
                                        buf.append(ASRNA_REFERENCE);
                                        buf.append(endMark1);
                                        buf.append(readingSomeId);
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append(ASRNA_REFERENCE);
                                        buf.append(">\n");
                                    } else if (tag2.equals(STATE)) {
                                        buf.append("<celldesigner:state>\n");
                                        grandchild = elem2.getChildNodes();
                                        grandchildsize = grandchild.getLength();
                                        j = 0;
                                        while (j < grandchildsize) {
                                            gnode = grandchild.item(j);
                                            if (gnode.getNodeType() == 1 && gnode.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                                                if (gnode.getLocalName().equals(HOMODIMER)) {
                                                    str = gnode.getFirstChild().getNodeValue();
                                                    buf.append(TAG_START_CELLDESIGNER);
                                                    buf.append(HOMODIMER);
                                                    buf.append(endMark1);
                                                    buf.append(str);
                                                    buf.append(TAG_END_CELLDESIGNER);
                                                    buf.append(HOMODIMER);
                                                    buf.append(">\n");
                                                } else if (gnode.getLocalName().equals(LIST_OF_MODIFICATION) || gnode.getLocalName().equals("listOfModifications")) {
                                                    buf.append(TAG_START_CELLDESIGNER);
                                                    buf.append(LIST_OF_MODIFICATION);
                                                    buf.append(endMark1);
                                                    grandgrandchild = gnode.getChildNodes();
                                                    ggchildsize = grandgrandchild.getLength();
                                                    h = 0;
                                                    while (h < ggchildsize) {
                                                        ggnode = grandgrandchild.item(h);
                                                        if (ggnode.getNodeType() == 1 && ggnode.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && ggnode.getLocalName().equals(MODIFICATION)) {
                                                            ggelem = (Element)ggnode;
                                                            buf.append(LineChangeMark);
                                                            buf.append(TAG_START_CELLDESIGNER);
                                                            buf.append(MODIFICATION);
                                                            buf.append(Mark5);
                                                            residue = ggelem.getAttributeNS(null, RESIDUE);
                                                            if (!residue.equals("")) {
                                                                buf.append(Mark5);
                                                                buf.append(RESIDUE);
                                                                buf.append(" = \"");
                                                                buf.append(residue);
                                                                buf.append(Mark1);
                                                            }
                                                            if (!(state = ggelem.getAttributeNS(null, STATE)).equals("")) {
                                                                buf.append(Mark5);
                                                                buf.append(STATE);
                                                                buf.append(" = \"");
                                                                buf.append(state);
                                                                buf.append(Mark1);
                                                            }
                                                            buf.append("/>");
                                                        }
                                                        ++h;
                                                    }
                                                    buf.append(LineChangeMark);
                                                    buf.append(TAG_END_CELLDESIGNER);
                                                    buf.append(LIST_OF_MODIFICATION);
                                                    buf.append(">\n");
                                                } else if (gnode.getLocalName().equals(LIST_OF_STRUCTURALSTATE) || gnode.getLocalName().equals("listOfStructuralStates")) {
                                                    buf.append(TAG_START_CELLDESIGNER);
                                                    buf.append(LIST_OF_STRUCTURALSTATE);
                                                    buf.append(endMark1);
                                                    grandgrandchild = gnode.getChildNodes();
                                                    ggchildsize = grandgrandchild.getLength();
                                                    h = 0;
                                                    while (h < ggchildsize) {
                                                        ggnode = grandgrandchild.item(h);
                                                        if (ggnode.getNodeType() == 1 && ggnode.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && ggnode.getLocalName().equals(STRUCTURALSTATE)) {
                                                            ggelem = (Element)ggnode;
                                                            buf.append(LineChangeMark);
                                                            buf.append(TAG_START_CELLDESIGNER);
                                                            buf.append(STRUCTURALSTATE);
                                                            buf.append(Mark5);
                                                            String state2 = ggelem.getAttributeNS(null, STRUCTURALSTATE);
                                                            if (!state2.equals("")) {
                                                                buf.append(Mark5);
                                                                buf.append(STRUCTURALSTATE);
                                                                buf.append(" = \"");
                                                                buf.append(state2);
                                                                buf.append(Mark1);
                                                            }
                                                            buf.append("/>");
                                                        }
                                                        ++h;
                                                    }
                                                    buf.append(LineChangeMark);
                                                    buf.append(TAG_END_CELLDESIGNER);
                                                    buf.append(LIST_OF_STRUCTURALSTATE);
                                                    buf.append(">\n");
                                                }
                                            }
                                            ++j;
                                        }
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append(STATE);
                                        buf.append(">\n");
                                    }
                                }
                                ++k;
                            }
                            buf.append(TAG_END_CELLDESIGNER);
                            buf.append(SPECIES_IDENTITY);
                            buf.append(">\n");
                        } else if (elem.getLocalName().equals(HETERODIMER_IDENTITY)) {
                            buf.append(TAG_START_CELLDESIGNER);
                            buf.append(HETERODIMER_IDENTITY);
                            buf.append(">\n");
                            childlist2 = elem.getChildNodes();
                            childsize2 = childlist2.getLength();
                            k = 0;
                            while (k < childsize2) {
                                node2 = childlist2.item(k);
                                if (node2.getNodeType() == 1 && node2.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                                    elem2 = (Element)node2;
                                    tag2 = elem2.getLocalName();
                                    if (tag2.equals(CLASS)) {
                                        str2 = elem2.getFirstChild().getNodeValue();
                                        buf.append(TAG_START_CELLDESIGNER);
                                        buf.append(CLASS);
                                        buf.append(endMark1);
                                        buf.append(str2);
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append(CLASS);
                                        buf.append(">\n");
                                    } else if (tag2.equals(strNameASTNodePattern)) {
                                        str2 = elem2.getFirstChild().getNodeValue();
                                        buf.append(TAG_START_CELLDESIGNER);
                                        buf.append("name>");
                                        buf.append(str2);
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append("name>\n");
                                    } else if (tag2.equals(HYPOTHETICAL)) {
                                        str2 = elem2.getFirstChild().getNodeValue();
                                        buf.append(TAG_START_CELLDESIGNER);
                                        buf.append(HYPOTHETICAL);
                                        buf.append(endMark1);
                                        buf.append(str2);
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append(HYPOTHETICAL);
                                        buf.append(">\n");
                                    } else if (tag2.equals(PROTEIN_REFERENCE)) {
                                        readingSomeId = elem2.getFirstChild().getNodeValue();
                                        buf.append(TAG_START_CELLDESIGNER);
                                        buf.append(PROTEIN_REFERENCE);
                                        buf.append(endMark1);
                                        buf.append(readingSomeId);
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append(PROTEIN_REFERENCE);
                                        buf.append(">\n");
                                    } else if (tag2.equals(GENE_REFERENCE)) {
                                        readingSomeId = elem2.getFirstChild().getNodeValue();
                                        buf.append(TAG_START_CELLDESIGNER);
                                        buf.append(GENE_REFERENCE);
                                        buf.append(endMark1);
                                        buf.append(readingSomeId);
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append(GENE_REFERENCE);
                                        buf.append(">\n");
                                    } else if (tag2.equals(RNA_REFERENCE)) {
                                        readingSomeId = elem2.getFirstChild().getNodeValue();
                                        buf.append(TAG_START_CELLDESIGNER);
                                        buf.append(RNA_REFERENCE);
                                        buf.append(endMark1);
                                        buf.append(readingSomeId);
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append(RNA_REFERENCE);
                                        buf.append(">\n");
                                    } else if (tag2.equals(ASRNA_REFERENCE)) {
                                        readingSomeId = elem2.getFirstChild().getNodeValue();
                                        buf.append(TAG_START_CELLDESIGNER);
                                        buf.append(ASRNA_REFERENCE);
                                        buf.append(endMark1);
                                        buf.append(readingSomeId);
                                        buf.append(TAG_END_CELLDESIGNER);
                                        buf.append(ASRNA_REFERENCE);
                                        buf.append(">\n");
                                    } else if (tag2.equals(STATE)) {
                                        grandchild = elem2.getChildNodes();
                                        grandchildsize = grandchild.getLength();
                                        j = 0;
                                        while (j < grandchildsize) {
                                            gnode = grandchild.item(j);
                                            if (gnode.getNodeType() == 1 && gnode.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                                                if (gnode.getLocalName().equals(HOMODIMER)) {
                                                    str = gnode.getFirstChild().getNodeValue();
                                                    buf.append(TAG_START_CELLDESIGNER);
                                                    buf.append(HOMODIMER);
                                                    buf.append(endMark1);
                                                    buf.append(str);
                                                    buf.append(TAG_END_CELLDESIGNER);
                                                    buf.append(HOMODIMER);
                                                    buf.append(">\n");
                                                } else if (gnode.getLocalName().equals(LIST_OF_MODIFICATION) || gnode.getLocalName().equals("listOfModifications")) {
                                                    buf.append(TAG_START_CELLDESIGNER);
                                                    buf.append(LIST_OF_MODIFICATION);
                                                    buf.append(endMark1);
                                                    grandgrandchild = gnode.getChildNodes();
                                                    ggchildsize = grandgrandchild.getLength();
                                                    h = 0;
                                                    while (h < ggchildsize) {
                                                        ggnode = grandgrandchild.item(h);
                                                        if (ggnode.getNodeType() == 1 && ggnode.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && ggnode.getLocalName().equals(MODIFICATION)) {
                                                            ggelem = (Element)ggnode;
                                                            buf.append(TAG_START_CELLDESIGNER);
                                                            buf.append(MODIFICATION);
                                                            buf.append(Mark5);
                                                            residue = ggelem.getAttributeNS(null, RESIDUE);
                                                            if (!residue.equals("")) {
                                                                buf.append(RESIDUE);
                                                                buf.append(" = ");
                                                                buf.append(residue);
                                                            }
                                                            if (!(state = ggelem.getAttributeNS(null, STATE)).equals("")) {
                                                                buf.append(STATE);
                                                                buf.append(" = ");
                                                                buf.append(state);
                                                            }
                                                            buf.append(">\n");
                                                        }
                                                        ++h;
                                                    }
                                                    buf.append(TAG_END_CELLDESIGNER);
                                                    buf.append(LIST_OF_MODIFICATION);
                                                    buf.append(">\n");
                                                }
                                            }
                                            ++j;
                                        }
                                    }
                                }
                                ++k;
                            }
                            buf.append(TAG_END_CELLDESIGNER);
                            buf.append(HETERODIMER_IDENTITY);
                            buf.append(">\n");
                        }
                    }
                    ++i;
                }
                buf.append(TAG_END_ANNOTATION);
                buf.append(LineChangeMark);
                sbase.setAnnotation(LibSBMLUtil.addNamespace(buf.toString(), "annotation"));
            }
        } while ((node = node.getNextSibling()) != null);
    }

    private static String[] getAttributeNames(SBase sbase, SpecInfo spec) {
        if (sbase instanceof ModificationResidue) {
            return ATTR_NAME_MODIFICATION_RESIDUE;
        }
        if (sbase instanceof BindingRegion) {
            return ATTR_NAME_BINDINGREGION;
        }
        if (sbase instanceof RNA) {
            return ATTR_NAME_EXTENSION_SPECIES;
        }
        if (sbase instanceof Gene) {
            return ATTR_NAME_EXTENSION_SPECIES;
        }
        if (sbase instanceof Protein) {
            return ATTR_NAME_EXTENSION_SPECIES;
        }
        if (sbase instanceof ModificationRegion) {
            return ATTR_NAME_MODIFICATION_REGION;
        }
        if (sbase instanceof AntiSenseRNA) {
            return ATTR_NAME_EXTENSION_SPECIES;
        }
        if (sbase instanceof Species) {
            if (spec.getLevel() == 1) {
                return ATTR_NAME_SPECIES_1;
            }
            return ATTR_NAME_SPECIES_2;
        }
        if (sbase instanceof ModifierSpeciesReference) {
            return ATTR_NAME_MODIFIERSPECIES_REF;
        }
        if (sbase instanceof SpeciesReference) {
            if (spec.getLevel() == 1) {
                if (spec.getVersion() == 1) {
                    return ATTR_NAME_SPECIES_1_1;
                }
                return ATTR_NAME_SPECIES_1_2;
            }
            return ATTR_NAME_SPECIES_2_1;
        }
        if (sbase instanceof SimpleSpeciesReference) {
            return null;
        }
        if (sbase instanceof Event) {
            if (spec.getLevel() == 1) {
                return new String[0];
            }
            return ATTR_NAME_EVENT;
        }
        if (sbase instanceof Compartment) {
            if (spec.getLevel() == 1) {
                return ATTR_NAME_COMPARTMENT_1;
            }
            return ATTR_NAME_COMPARTMENT_2;
        }
        if (sbase instanceof FunctionDefinition) {
            if (spec.getLevel() == 1) {
                return new String[0];
            }
            return ATTR_NAME_FUNCTION;
        }
        if (sbase instanceof KineticLaw) {
            if (spec.getLevel() == 1) {
                return ATTR_NAME_KINETICLAW_1;
            }
            return ATTR_NAME_KINETICLAW_2;
        }
        if (sbase instanceof UnitDefinition) {
            if (spec.getLevel() == 1) {
                return ATTR_NAME_UNITDEFINITION_1;
            }
            return ATTR_NAME_UNITDEFINITION_2;
        }
        if (sbase instanceof Parameter) {
            if (spec.getLevel() == 1) {
                return ATTR_NAME_PARAMETER_1;
            }
            return ATTR_NAME_PARAMETER_2;
        }
        if (sbase instanceof RateRule) {
            if (spec.getLevel() == 1) {
                return ATTR_NAME_RATE_RULE_1;
            }
            return ATTR_NAME_RATE_RULE_2;
        }
        if (sbase instanceof AlgebraicRule) {
            if (spec.getLevel() == 1) {
                return ATTR_NAME_ALGEBRAIC_RULE;
            }
            return new String[0];
        }
        if (sbase instanceof EventAssignment) {
            if (spec.getLevel() == 1) {
                return new String[0];
            }
            return ATTR_NAME_EVENT_ASSIGNMENT;
        }
        if (sbase instanceof Model) {
            if (spec.getLevel() == 1) {
                return ATTR_NAME_MODEL_1;
            }
            return ATTR_NAME_MODEL_2;
        }
        if (sbase instanceof Reaction) {
            if (spec.getLevel() == 1) {
                return ATTR_NAME_REACTION_1;
            }
            return ATTR_NAME_REACTION_2;
        }
        if (sbase instanceof AssignmentRule) {
            if (sbase.getElementName().equals("speciesConcentrationRule")) {
                return ATTR_NAME_SPECIES_CONCENTRATION_RULE_2;
            }
            if (sbase.getElementName().equals("specieConcentrationRule")) {
                return ATTR_NAME_SPECIES_CONCENTRATION_RULE_1;
            }
            if (sbase.getElementName().equals("compartmentVolumeRule")) {
                return ATTR_NAME_COMPARTMENTVOLUME_RULE;
            }
            if (sbase.getElementName().equals("ParameterRule")) {
                if (spec.getLevel() == 1) {
                    return ATTR_NAME_PARAMETER_RULE_1;
                }
                return ATTR_NAME_PARAMETER_RULE_2;
            }
            if (spec.getLevel() == 1) {
                return ATTR_NAME_ASSIGNMENT_RULE_1;
            }
            return ATTR_NAME_ASSIGNMENT_RULE_2;
        }
        if (sbase instanceof SBMLDocument) {
            return ATTR_NAME_SBMLDOCUMENT;
        }
        if (sbase instanceof Unit) {
            if (spec.getLevel() == 1) {
                return ATTR_NAME_UNIT_1;
            }
            return ATTR_NAME_UNIT_2;
        }
        if (sbase instanceof SpeciesType) {
            if (spec.getLevel() == 1) {
                return new String[0];
            }
            return ATTR_NAME_SPECIES_TYPE;
        }
        if (sbase instanceof CompartmentType) {
            if (spec.getLevel() == 1) {
                return new String[0];
            }
            return ATTR_NAME_COMPARTMENT_TYPE;
        }
        if (sbase instanceof InitialAssignment) {
            if (spec.getLevel() == 1) {
                return new String[0];
            }
            return ATTR_NAME_INITIAL_ASSIGNMENTS;
        }
        if (sbase instanceof Constraint) {
            if (spec.getLevel() == 1) {
                return new String[0];
            }
            return ATTR_NAME_CONSTRAINTS;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setAttributeValues(SBase sbase, String[] values, SpecInfo spec) throws Exception {
        if (sbase instanceof ModificationResidue) {
            ModificationResidue s = (ModificationResidue)sbase;
            s.setId("");
            s.setName("");
            s.setType(RESIDUE);
            s.setSide("none");
            s.setAngle(Math.PI);
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (!values[1].equals("")) {
                s.setName(values[1]);
            }
            if (!values[2].equals("")) {
                s.setSide(values[2]);
            }
            if (values[3].equals("")) return;
            String str = values[3];
            double angle = Double.parseDouble(str);
            s.setAngle(angle);
            return;
        }
        if (sbase instanceof BindingRegion) {
            String str;
            BindingRegion s = (BindingRegion)sbase;
            s.setId("");
            s.setName("");
            s.setType("binding region");
            s.setSize(0.0);
            s.setAngle(Math.PI);
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (!values[1].equals("")) {
                s.setName(values[1]);
            }
            if (!values[2].equals("")) {
                str = values[2];
                double size = Double.parseDouble(str);
                s.setSize(size);
            }
            if (values[3].equals("")) return;
            str = values[3];
            double angle = Double.parseDouble(str);
            s.setAngle(angle);
            return;
        }
        if (sbase instanceof RNA) {
            RNA s = (RNA)sbase;
            try {
                SId.check("");
                s.setId("");
            }
            catch (SIdFormatException str) {
                // empty catch block
            }
            s.setName("");
            s.setType("");
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (!values[1].equals("")) {
                s.setType(values[1]);
            }
            if (values[2].equals("")) return;
            s.setName(values[2]);
            return;
        }
        if (sbase instanceof Gene) {
            Gene s = (Gene)sbase;
            try {
                SId.check("");
                s.setId("");
            }
            catch (SIdFormatException e) {
                // empty catch block
            }
            s.setName("");
            s.setType("");
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (!values[1].equals("")) {
                s.setType(values[1]);
            }
            if (values[2].equals("")) return;
            s.setName(values[2]);
            return;
        }
        if (sbase instanceof Protein) {
            Protein s = (Protein)sbase;
            try {
                SId.check("");
                s.setId("");
            }
            catch (SIdFormatException e) {
                // empty catch block
            }
            s.setName("");
            s.setType("");
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (!values[1].equals("")) {
                s.setType(values[1]);
            }
            if (values[2].equals("")) return;
            s.setName(values[2]);
            return;
        }
        if (sbase instanceof ModificationRegion) {
            String str;
            ModificationRegion s = (ModificationRegion)sbase;
            try {
                SId.check("");
                s.setId("");
            }
            catch (SIdFormatException e) {
                // empty catch block
            }
            s.setName("");
            s.setType("Modification Site");
            s.setSize(0.0);
            s.setPos(0.3);
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (!values[1].equals("")) {
                s.setName(values[1]);
            }
            if (!values[2].equals("")) {
                s.setType(values[2]);
            }
            if (!values[2].equals("") && !values[3].equals("")) {
                str = values[3];
                double size = Double.parseDouble(str);
                s.setSize(size);
            }
            if (!values[4].equals("")) {
                str = values[4];
                double pos = Double.parseDouble(str);
                s.setPos(pos);
            }
            if (!values[5].equals("")) {
                str = values[5];
                boolean active = Boolean.valueOf(str);
                s.setActive(active);
                return;
            } else {
                s.setActive(false);
            }
            return;
        }
        if (sbase instanceof AntiSenseRNA) {
            AntiSenseRNA s = (AntiSenseRNA)sbase;
            try {
                SId.check("");
                s.setId("");
            }
            catch (SIdFormatException str) {
                // empty catch block
            }
            s.setName("");
            s.setType("");
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (!values[1].equals("")) {
                s.setType(values[1]);
            }
            if (values[2].equals("")) return;
            s.setName(values[2]);
            return;
        }
        if (sbase instanceof Species) {
            Species s = (Species)sbase;
            s.setId("");
            s.setName("");
            s.setCompartment("");
            s.setSubstanceUnits("");
            s.setSpatialSizeUnits("");
            s.setHasOnlySubstanceUnits(false);
            s.setBoundaryCondition(false);
            s.setCharge(0);
            s.setConstant(false);
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (spec.getLevel() == 1) {
                if (!values[1].equals("")) {
                    SId.check(values[1]);
                    s.setCompartment(values[1]);
                }
                if (!values[2].equals("")) {
                    s.setInitialAmount(Double.parseDouble(values[2]));
                }
                if (!values[3].equals("")) {
                    SId.check(values[3]);
                    s.setSubstanceUnits(values[3]);
                }
                if (!values[4].equals("")) {
                    s.setBoundaryCondition(Boolean.valueOf(values[4]).booleanValue());
                }
                if (values[5].equals("")) return;
                s.setCharge(Integer.parseInt(values[5]));
                return;
            }
            if (spec.getLevel() != 2) return;
            if (!values[1].equals("")) {
                s.setName(values[1]);
            }
            if (!values[2].equals("")) {
                SId.check(values[2]);
                s.setCompartment(values[2]);
            }
            String quantity = "";
            if (!values[3].equals("") && values[4].equals("")) {
                quantity = values[3];
                s.setInitialAmount(Double.parseDouble(quantity));
            } else if (values[3].equals("") && !values[4].equals("")) {
                quantity = values[4];
                s.setInitialConcentration(Double.parseDouble(quantity));
            } else if (!values[3].equals("") && !values[4].equals("")) {
                throw new Exception("Both initialAmount and initialConcentration have values.");
            }
            if (!quantity.equals("")) {
                // empty if block
            }
            if (!values[5].equals("")) {
                SId.check(values[5]);
                s.setSubstanceUnits(values[5]);
            }
            if (!values[6].equals("")) {
                SId.check(values[6]);
                s.setSpatialSizeUnits(values[6]);
            }
            if (!values[7].equals("")) {
                s.setHasOnlySubstanceUnits(Boolean.valueOf(values[7]).booleanValue());
            }
            if (!values[8].equals("")) {
                s.setBoundaryCondition(Boolean.valueOf(values[8]).booleanValue());
            }
            if (!values[9].equals("")) {
                s.setCharge(Integer.parseInt(values[9]));
            }
            if (values[10].equals("")) return;
            s.setConstant(Boolean.valueOf(values[10]).booleanValue());
            return;
        }
        if (sbase instanceof ModifierSpeciesReference) {
            ModifierSpeciesReference s = (ModifierSpeciesReference)sbase;
            s.setSpecies("");
            if (values[0].equals("")) return;
            SId.check(values[0]);
            s.setSpecies(values[0]);
            return;
        }
        if (sbase instanceof SpeciesReference) {
            SpeciesReference s = (SpeciesReference)sbase;
            s.setSpecies("");
            if (!values[0].equals("")) {
                s.setSpecies(values[0]);
            }
            int stoichiometryLevel1 = 0;
            int denominatorLevel1 = 0;
            if (!values[1].equals("")) {
                if (spec.getLevel() == 1) {
                    stoichiometryLevel1 = Integer.parseInt(values[1]);
                } else {
                    s.setStoichiometry(Double.parseDouble(values[1]));
                }
            }
            if (spec.getLevel() == 1 && !values[2].equals("")) {
                denominatorLevel1 = Integer.parseInt(values[2]);
            }
            if (spec.getLevel() != 1 || denominatorLevel1 == 0 && (denominatorLevel1 != true || stoichiometryLevel1 != 1)) return;
            double stoichiometry = (double)stoichiometryLevel1 / (double)denominatorLevel1;
            s.setStoichiometry(stoichiometry);
            return;
        }
        if (sbase instanceof SimpleSpeciesReference) return;
        if (sbase instanceof Event) {
            Event s = (Event)sbase;
            s.setId("");
            s.setName("");
            s.setTrigger(null);
            s.setDelay(null);
            s.setTimeUnits("");
            s.setUseValuesFromTriggerTime(true);
            if (spec.getLevel() == 1) {
                return;
            }
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (!values[1].equals("")) {
                s.setName(values[1]);
            }
            if (values[2].equals("")) return;
            s.setTimeUnits(values[2]);
            return;
        }
        if (sbase instanceof Compartment) {
            Compartment s = (Compartment)sbase;
            s.setId("");
            s.setName("");
            s.setSpatialDimensions(3L);
            s.setUnits("");
            s.setOutside("");
            s.setConstant(true);
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (spec.getLevel() == 1) {
                if (values[1].equals("")) {
                    s.setSize(1.0);
                } else {
                    s.setSize(Double.parseDouble(values[1]));
                }
                if (!values[2].equals("")) {
                    SId.check(values[2]);
                    s.setUnits(values[2]);
                }
                if (values[3].equals("")) return;
                SId.check(values[3]);
                s.setOutside(values[3]);
                return;
            }
            if (spec.getLevel() != 2) return;
            if (!values[1].equals("")) {
                s.setName(values[1]);
            }
            if (!values[2].equals("")) {
                s.setSpatialDimensions((long)Integer.parseInt(values[2]));
            }
            if (!values[3].equals("")) {
                s.setVolume(Double.parseDouble(values[3]));
            }
            if (!values[4].equals("")) {
                SId.check(values[4]);
                s.setUnits(values[4]);
            }
            if (!values[5].equals("")) {
                SId.check(values[5]);
                s.setOutside(values[5]);
            }
            if (values[6].equals("")) return;
            s.setConstant(Boolean.valueOf(values[6]).booleanValue());
            return;
        }
        if (sbase instanceof FunctionDefinition) {
            FunctionDefinition s = (FunctionDefinition)sbase;
            s.setId("");
            s.setName("");
            s.setMath(null);
            if (spec.getLevel() == 1) {
                return;
            }
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (values[1].equals("")) return;
            s.setName(values[1]);
            return;
        }
        if (sbase instanceof KineticLaw) {
            KineticLaw s = (KineticLaw)sbase;
            s.setFormula("");
            s.setTimeUnits("");
            s.setSubstanceUnits("");
            if (spec.getLevel() == 1) {
                if (!values[0].equals("")) {
                    s.setFormula(values[0]);
                }
                if (!values[1].equals("")) {
                    SId.check(values[1]);
                    s.setTimeUnits(values[1]);
                }
                if (values[2].equals("")) return;
                SId.check(values[2]);
                s.setSubstanceUnits(values[2]);
                return;
            }
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setTimeUnits(values[0]);
            }
            if (values[1].equals("")) return;
            SId.check(values[1]);
            s.setSubstanceUnits(values[1]);
            return;
        }
        if (sbase instanceof UnitDefinition) {
            UnitDefinition s = (UnitDefinition)sbase;
            s.setId("");
            s.setName("");
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (spec.getLevel() != 2 || values[1].equals("")) return;
            s.setName(values[1]);
            return;
        }
        if (sbase instanceof Parameter) {
            Parameter s = (Parameter)sbase;
            s.setId("");
            s.setName("");
            s.setValue(0.0);
            s.setUnits("");
            s.setConstant(true);
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (spec.getLevel() == 1) {
                if (!values[1].equals("")) {
                    s.setValue(Double.parseDouble(values[1]));
                }
                if (values[2].equals("")) return;
                SId.check(values[2]);
                s.setUnits(values[2]);
                return;
            }
            if (spec.getLevel() != 2) return;
            if (!values[1].equals("")) {
                s.setName(values[1]);
            }
            if (!values[2].equals("")) {
                s.setValue(Double.parseDouble(values[2]));
            }
            if (!values[3].equals("")) {
                SId.check(values[3]);
                s.setUnits(values[3]);
            }
            if (values[4].equals("")) return;
            s.setConstant(Boolean.valueOf(values[4]).booleanValue());
            return;
        }
        if (sbase instanceof RateRule) {
            RateRule s = (RateRule)sbase;
            s.setVariable("");
            if (spec.getLevel() == 1) {
                if (!values[0].equals("")) {
                    s.setFormula(values[0]);
                }
                s.setVariable(values[2]);
                return;
            } else {
                s.setVariable(values[0]);
            }
            return;
        }
        if (sbase instanceof AlgebraicRule) {
            AlgebraicRule s = (AlgebraicRule)sbase;
            if (spec.getLevel() != 1 || values[0].equals("")) return;
            s.setFormula(values[0]);
            return;
        }
        if (sbase instanceof EventAssignment) {
            EventAssignment s = (EventAssignment)sbase;
            s.setVariable("");
            s.setMath(null);
            if (spec.getLevel() == 1) {
                return;
            }
            if (values[0].equals("")) return;
            s.setVariable(values[0]);
            return;
        }
        if (sbase instanceof Model) {
            Model s = (Model)sbase;
            s.setId("");
            s.setName("");
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (spec.getLevel() != 2 || values[1].equals("")) return;
            s.setName(values[1]);
            return;
        }
        if (sbase instanceof Reaction) {
            Reaction s = (Reaction)sbase;
            s.setId("");
            s.setName("");
            s.setReversible(true);
            s.setFast(false);
            if (!values[0].equals("")) {
                SId.check(values[0]);
                s.setId(values[0]);
            }
            if (spec.getLevel() == 1) {
                if (!values[1].equals("")) {
                    s.setReversible(Boolean.valueOf(values[1]).booleanValue());
                }
                if (values[2].equals("")) return;
                s.setFast(Boolean.valueOf(values[2]).booleanValue());
                return;
            } else {
                if (spec.getLevel() != 2) return;
                if (!values[1].equals("")) {
                    s.setName(values[1]);
                }
                if (!values[2].equals("")) {
                    s.setReversible(Boolean.valueOf(values[2]).booleanValue());
                }
                if (values[3].equals("")) return;
                s.setFast(Boolean.valueOf(values[3]).booleanValue());
            }
            return;
        }
        if (sbase instanceof AssignmentRule) {
            if (sbase.getElementName().equals("speciesConcentrationRule")) {
                AssignmentRule s = (AssignmentRule)sbase;
                s.setVariable("");
                if (!values[0].equals("")) {
                    s.setFormula(values[0]);
                }
                if (!values[1].equals("")) {
                    s.setL1TypeCode(Integer.parseInt(values[1]));
                }
                if (values[2].equals("")) return;
                SId.check(values[2]);
                s.setVariable(values[2]);
                return;
            } else if (sbase.getElementName().equals("specieConcentrationRule")) {
                AssignmentRule s = (AssignmentRule)sbase;
                s.setVariable("");
                if (!values[0].equals("")) {
                    s.setFormula(values[0]);
                }
                if (!values[1].equals("")) {
                    s.setL1TypeCode(Integer.parseInt(values[1]));
                }
                if (values[2].equals("")) return;
                SId.check(values[2]);
                s.setVariable(values[2]);
                return;
            } else if (sbase.getElementName().equals("compartmentVolumeRule")) {
                AssignmentRule s = (AssignmentRule)sbase;
                s.setVariable("");
                if (!values[0].equals("")) {
                    s.setFormula(values[0]);
                }
                if (!values[1].equals("")) {
                    s.setL1TypeCode(Integer.parseInt(values[1]));
                }
                if (values[2].equals("")) return;
                SId.check(values[2]);
                s.setVariable(values[2]);
                return;
            } else if (sbase.getElementName().equals("ParameterRule")) {
                AssignmentRule s = (AssignmentRule)sbase;
                s.setVariable("");
                if (!values[0].equals("")) {
                    s.setFormula(values[0]);
                }
                if (!values[1].equals("")) {
                    s.setL1TypeCode(Integer.parseInt(values[1]));
                }
                if (values[2].equals("")) return;
                s.setVariable(values[2]);
                return;
            } else {
                AssignmentRule s = (AssignmentRule)sbase;
                s.setVariable("");
                if (spec.getLevel() == 1) {
                    if (!values[0].equals("")) {
                        s.setFormula(values[0]);
                    }
                    if (!values[1].equals("")) {
                        s.setL1TypeCode(Integer.parseInt(values[1]));
                    }
                    s.setVariable(values[2]);
                    return;
                } else {
                    s.setVariable(values[0]);
                }
            }
            return;
        }
        if (sbase instanceof SBMLDocument) {
            SBMLDocument s = (SBMLDocument)sbase;
            if (!values[0].equals("")) {
                s.setLevelAndVersion((long)Integer.parseInt(values[0]), s.getVersion());
            }
            if (values[1].equals("")) return;
            s.setLevelAndVersion((long)Integer.parseInt(values[1]), s.getVersion());
            return;
        }
        if (sbase instanceof Unit) {
            Unit s = (Unit)sbase;
            s.setExponent(1);
            s.setScale(0);
            s.setMultiplier(1.0);
            s.setOffset(0.0);
            if (!values[0].equals("")) {
                s.setKind(libsbml.UnitKind_forName((String)values[0]));
            }
            if (!values[1].equals("")) {
                s.setExponent(Integer.parseInt(values[1]));
            }
            if (!values[2].equals("")) {
                s.setScale(Integer.parseInt(values[2]));
            }
            if (spec.getLevel() != 2) return;
            if (!values[3].equals("")) {
                s.setMultiplier(Double.parseDouble(values[3]));
            }
            if (values[4].equals("")) return;
            s.setOffset(Double.parseDouble(values[4]));
            return;
        }
        if (sbase instanceof SpeciesType) {
            SpeciesType st = (SpeciesType)sbase;
            st.setId("");
            st.setName("");
            if (spec.getLevel() == 1) {
                return;
            }
            if (values[0] != null) {
                SId.check(values[0]);
                st.setId(values[0]);
            }
            if (values[1] == null) return;
            st.setName(values[1]);
            return;
        }
        if (sbase instanceof CompartmentType) {
            CompartmentType ct = (CompartmentType)sbase;
            ct.setId("");
            ct.setName("");
            if (spec.getLevel() == 1) {
                return;
            }
            if (values[0] != null) {
                SId.check(values[0]);
                ct.setId(values[0]);
            }
            if (values[1] == null) return;
            ct.setName(values[1]);
            return;
        }
        if (sbase instanceof InitialAssignment) {
            ASTNode node;
            InitialAssignment ia = (InitialAssignment)sbase;
            ia.setSymbol("");
            ia.setMath(libsbml.parseFormula((String)""));
            if (spec.getLevel() == 1) {
                return;
            }
            if (values[0] != null) {
                SId.check(values[0]);
                ia.setSymbol(values[0]);
            }
            if (values[1] == null || values[1].trim().equals("") || (node = libsbml.parseFormula((String)values[1])) == null) return;
            ia.setMath(node);
            return;
        }
        if (!(sbase instanceof Constraint)) return;
        Constraint cs = (Constraint)sbase;
        cs.setMath(libsbml.parseFormula((String)""));
        ConstraintDialog.resetMsgStringOfConstraint(cs, "");
        if (spec.getLevel() == 1) {
            return;
        }
        if (values[0] == null || values[0].trim().equals("")) throw new Exception();
        ASTNode node = libsbml.parseFormula((String)values[0]);
        if (node == null) {
            throw new Exception();
        }
        cs.setMath(node);
        if (values[1] == null) return;
        ConstraintDialog.resetMsgStringOfConstraint(cs, values[1]);
    }

    private static boolean hasChildNodes(SBase sbase) {
        if (sbase instanceof ModificationResidue) {
            return false;
        }
        if (sbase instanceof BindingRegion) {
            return false;
        }
        if (sbase instanceof RNA) {
            return true;
        }
        if (sbase instanceof Gene) {
            return true;
        }
        if (sbase instanceof Protein) {
            return true;
        }
        if (sbase instanceof ModificationRegion) {
            return false;
        }
        if (sbase instanceof AntiSenseRNA) {
            return true;
        }
        if (sbase instanceof Species) {
            return false;
        }
        if (sbase instanceof ModifierSpeciesReference) {
            return false;
        }
        if (sbase instanceof SpeciesReference) {
            return true;
        }
        if (sbase instanceof SimpleSpeciesReference) {
            return false;
        }
        if (sbase instanceof Event) {
            return true;
        }
        if (sbase instanceof Compartment) {
            return false;
        }
        if (sbase instanceof FunctionDefinition) {
            return true;
        }
        if (sbase instanceof KineticLaw) {
            return true;
        }
        if (sbase instanceof UnitDefinition) {
            return true;
        }
        if (sbase instanceof Parameter) {
            return false;
        }
        if (sbase instanceof RateRule) {
            return true;
        }
        if (sbase instanceof AlgebraicRule) {
            return true;
        }
        if (sbase instanceof EventAssignment) {
            return true;
        }
        if (sbase instanceof Model) {
            return true;
        }
        if (sbase instanceof Reaction) {
            return true;
        }
        if (sbase instanceof AssignmentRule) {
            if (sbase.getElementName().equals("speciesConcentrationRule")) {
                return false;
            }
            if (sbase.getElementName().equals("specieConcentrationRule")) {
                return false;
            }
            if (sbase.getElementName().equals("compartmentVolumeRule")) {
                return false;
            }
            return !sbase.getElementName().equals("ParameterRule");
        }
        if (sbase instanceof SBMLDocument) {
            return true;
        }
        if (sbase instanceof Unit) {
            return false;
        }
        if (sbase instanceof SpeciesType) {
            return false;
        }
        if (sbase instanceof CompartmentType) {
            return false;
        }
        if (sbase instanceof InitialAssignment) {
            return false;
        }
        if (sbase instanceof Constraint) {
            return false;
        }
        return false;
    }

    private static void readChildNodesDOMTree(SBase sbase, Element element, SpecInfo spec) throws Exception {
        if (!(sbase instanceof ModifierSpeciesReference)) {
            if (sbase instanceof RNA) {
                RNA s = (RNA)sbase;
                s.readChildNodesDOMTree(element, spec);
            } else if (sbase instanceof Gene) {
                Gene s = (Gene)sbase;
                s.readChildNodesDOMTree(element, spec);
            } else if (sbase instanceof Protein) {
                Protein s = (Protein)sbase;
                s.readChildNodesDOMTree(element, spec);
            } else if (!(sbase instanceof ModificationRegion) && sbase instanceof AntiSenseRNA) {
                AntiSenseRNA s = (AntiSenseRNA)sbase;
                s.readChildNodesDOMTree(element, spec);
            }
        }
    }

    public static String[] toStrings(Reaction reaction, SBase sbase, String type, int index) {
        int j;
        if (sbase == null) {
            return null;
        }
        String[] attr = null;
        Any notes = LibSBMLUtil.getNotes(sbase, null);
        Any annotation = LibSBMLUtil.getAnnotation(reaction, sbase, type, index, null);
        if (sbase instanceof SimpleSpeciesReference) {
            SimpleSpeciesReference base = (SimpleSpeciesReference)sbase;
            String[] temp_attr = LibSBMLUtil.getAttributeValues(sbase, specInfo);
            attr = new String[temp_attr.length + 1];
            int i = 0;
            while (i < temp_attr.length) {
                attr[i] = temp_attr[i];
                ++i;
            }
            if (sbase instanceof SpeciesReference) {
                SpeciesReference ref = (SpeciesReference)sbase;
                String math_str = "";
                if (ref.getStoichiometryMath() != null) {
                    math_str = libsbml.formulaToString((ASTNode)ref.getStoichiometryMath().getMath());
                }
                attr[attr.length - 1] = math_str;
            } else {
                String math_str;
                attr[attr.length - 1] = math_str = "";
            }
        } else {
            attr = LibSBMLUtil.getAttributeValues(sbase, specInfo);
        }
        String[] notesAttr = null;
        String[] annotAttr = null;
        int len = attr.length;
        if (notes != null) {
            notesAttr = notes.getAttributeValues();
            len += notesAttr.length;
        }
        if (!(annotation == null || sbase instanceof Protein || sbase instanceof RNA || sbase instanceof Gene || sbase instanceof AntiSenseRNA)) {
            annotAttr = annotation.getAttributeValues();
            len += annotAttr.length;
        }
        String[] rtn = new String[len];
        int i = 0;
        if (annotAttr != null) {
            j = 0;
            while (j < annotAttr.length) {
                rtn[i++] = annotAttr[j];
                ++j;
            }
        }
        if (notesAttr != null) {
            j = 0;
            while (j < notesAttr.length) {
                rtn[i++] = notesAttr[j];
                ++j;
            }
        }
        j = 0;
        while (j < attr.length) {
            rtn[i++] = attr[j];
            ++j;
        }
        return rtn;
    }

    public static String[] toStrings(SBase sbase) {
        String[] attr2;
        String[] defAttr;
        String[] attr22;
        Species base;
        if (sbase == null) {
            return null;
        }
        String[] attr = null;
        Any notes = LibSBMLUtil.getNotes(sbase, null);
        Any annotation = LibSBMLUtil.getAnnotation(sbase, null);
        int positionToCompartmentIndex = -1;
        int includedIndex = -1;
        if (sbase instanceof Protein) {
            attr = LibSBMLUtil.getAttributeValues(sbase, specInfo);
        } else if (sbase instanceof Gene) {
            attr = LibSBMLUtil.getAttributeValues(sbase, specInfo);
        } else if (sbase instanceof RNA) {
            attr = LibSBMLUtil.getAttributeValues(sbase, specInfo);
        } else if (sbase instanceof AntiSenseRNA) {
            attr = LibSBMLUtil.getAttributeValues(sbase, specInfo);
        } else if (sbase instanceof Species) {
            base = (Species)sbase;
            String qtype = "";
            String ivalue = "";
            if (base.isSetInitialAmount()) {
                qtype = "Amount";
                ivalue = Double.toString(base.getInitialAmount());
            } else if (base.isSetInitialConcentration()) {
                qtype = "Concentration";
                ivalue = Double.toString(base.getInitialConcentration());
            }
            String[] attr23 = new String[]{base.getId(), base.getName(), base.getSpeciesType(), base.getCompartment(), qtype, ivalue, base.getSubstanceUnits(), base.getSpatialSizeUnits(), Boolean.toString(base.getHasOnlySubstanceUnits()), Boolean.toString(base.getBoundaryCondition()), Integer.toString(base.getCharge()), Boolean.toString(base.getConstant())};
            if (annotation != null && annotation instanceof SpeciesAnnotation) {
                String[] attrForChangePosition = new String[]{base.getId(), base.getName(), base.getSpeciesType(), base.getCompartment(), POSITION_TO_COMPARTMENT, Complex_InnerIncludedSpeciesInfo, qtype, ivalue, base.getSubstanceUnits(), base.getSpatialSizeUnits(), Boolean.toString(base.getHasOnlySubstanceUnits()), Boolean.toString(base.getBoundaryCondition()), Integer.toString(base.getCharge()), Boolean.toString(base.getConstant())};
                attr = attrForChangePosition;
                positionToCompartmentIndex = 4;
                includedIndex = 5;
            } else {
                attr = attr23;
            }
        } else if (sbase instanceof SimpleSpeciesReference) {
            base = (SimpleSpeciesReference)sbase;
            String[] temp_attr = LibSBMLUtil.getAttributeValues(sbase, specInfo);
            attr = new String[temp_attr.length + 1];
            int i = 0;
            while (i < temp_attr.length) {
                attr[i] = temp_attr[i];
                ++i;
            }
            if (sbase instanceof SpeciesReference) {
                SpeciesReference ref = (SpeciesReference)sbase;
                String math_str = "";
                if (ref.getStoichiometryMath() != null) {
                    math_str = libsbml.formulaToString((ASTNode)ref.getStoichiometryMath().getMath());
                }
                attr[attr.length - 1] = math_str;
            } else {
                String math_str;
                attr[attr.length - 1] = math_str = "";
            }
        } else if (sbase instanceof Event) {
            base = (Event)sbase;
            EventAssignment evs = base.getEventAssignment(0L);
            String idseq = "";
            if (evs != null) {
                idseq = evs.getVariable();
            }
            int i = 1;
            while ((long)i < base.getNumEventAssignments()) {
                EventAssignment s = base.getEventAssignment((long)i);
                idseq = String.valueOf(idseq) + Mark9 + s.getVariable();
                ++i;
            }
            String[] attr24 = new String[]{base.getId(), base.getName(), base.getTrigger() == null ? "" : libsbml.formulaToString((ASTNode)base.getTrigger().getMath()), base.getDelay() == null ? "" : libsbml.formulaToString((ASTNode)base.getDelay().getMath()), base.getTimeUnits(), Boolean.toString(base.getUseValuesFromTriggerTime()), idseq};
            attr = attr24;
        } else if (sbase instanceof FunctionDefinition) {
            base = (FunctionDefinition)sbase;
            String arguments = LibSBMLUtil.getFunctionDefinitionArguments(base.getMath());
            attr22 = new String[]{base.getId(), base.getName(), arguments, base.getMath() == null ? "" : libsbml.formulaToString((ASTNode)LibSBMLUtil.getFunctionDefinitionMath(base.getMath(), arguments))};
            attr = attr22;
        } else if (sbase instanceof UnitDefinition) {
            base = (UnitDefinition)sbase;
            defAttr = LibSBMLUtil.getAttributeValues(sbase, specInfo);
            attr22 = new String[defAttr.length + 1];
            int index = 0;
            index = 0;
            while (index < defAttr.length) {
                attr22[index] = defAttr[index];
                ++index;
            }
            int i = 0;
            while (i < 1) {
                if (base.getListOfUnits() == null) {
                    attr22[index] = "";
                } else {
                    String units = UnitDefinition.printUnits((UnitDefinition)base, (boolean)true);
                    if (units == null) {
                        units = "";
                    }
                    attr22[index] = units;
                }
                ++i;
                ++index;
            }
            attr = attr22;
        } else if (sbase instanceof Parameter) {
            base = (Parameter)sbase;
            String scope = LibSBMLUtil.getParameterScope((Parameter)base);
            String[] attr1 = LibSBMLUtil.getAttributeValues(sbase, specInfo);
            String[] attr25 = new String[1 + attr1.length];
            attr25[0] = scope;
            int i = 0;
            while (i < attr1.length) {
                attr25[i + 1] = attr1[i];
                ++i;
            }
            attr = attr25;
        } else if (sbase instanceof RateRule) {
            base = (RateRule)sbase;
            attr2 = new String[]{strRate, base.getFormula(), LibSBMLUtil.getRateRuleL1TypeString((Rule)base), base.getVariable()};
            attr = attr2;
        } else if (sbase instanceof AlgebraicRule) {
            base = (AlgebraicRule)sbase;
            attr2 = new String[]{strAlgebraic, base.getFormula(), "", ""};
            attr = attr2;
        } else if (sbase instanceof EventAssignment) {
            base = (EventAssignment)sbase;
            attr2 = new String[]{base.getVariable(), base.getMath() == null ? "" : libsbml.formulaToString((ASTNode)base.getMath())};
            attr = attr2;
        } else if (sbase instanceof Reaction) {
            base = (Reaction)sbase;
            defAttr = LibSBMLUtil.getAttributeValues(sbase, specInfo);
            attr22 = new String[defAttr.length + 3 + 1];
            int index = 0;
            index = 0;
            while (index < defAttr.length) {
                attr22[index] = defAttr[index];
                ++index;
            }
            int i = 0;
            while (i < 3) {
                SpeciesReference s;
                int j;
                String idseq;
                if (i == 0) {
                    if (base.getListOfReactants() == null || base.getNumReactants() == 0L) {
                        attr22[index] = "";
                    } else {
                        idseq = base.getReactant(0L).getSpecies();
                        j = 1;
                        while ((long)j < base.getNumReactants()) {
                            s = base.getReactant((long)j);
                            idseq = String.valueOf(idseq) + Mark9 + s.getSpecies();
                            ++j;
                        }
                        attr22[index] = idseq;
                    }
                } else if (i == 1) {
                    if (base.getListOfProducts() == null || base.getNumProducts() == 0L) {
                        attr22[index] = "";
                    } else {
                        idseq = base.getProduct(0L).getSpecies();
                        j = 1;
                        while ((long)j < base.getNumProducts()) {
                            s = base.getProduct((long)j);
                            idseq = String.valueOf(idseq) + Mark9 + s.getSpecies();
                            ++j;
                        }
                        attr22[index] = idseq;
                    }
                } else if (i == 2) {
                    if (base.getListOfModifiers() == null || base.getNumModifiers() == 0L) {
                        attr22[index] = "";
                    } else {
                        idseq = base.getModifier(0L).getSpecies();
                        j = 1;
                        while ((long)j < base.getNumModifiers()) {
                            s = base.getModifier((long)j);
                            idseq = String.valueOf(idseq) + Mark9 + s.getSpecies();
                            ++j;
                        }
                        attr22[index] = idseq;
                    }
                }
                ++i;
                ++index;
            }
            if (base.getKineticLaw() == null) {
                attr22[index] = "";
            } else if (isViewSpeciesID) {
                attr22[index] = base.getKineticLaw().getFormula();
            } else {
                try {
                    ASTNode math = base.getKineticLaw().getMath().deepCopy();
                    LibSBMLUtil.mathReplace(math);
                    attr22[index] = libsbml.formulaToString((ASTNode)math);
                }
                catch (Exception myErr) {
                    attr22[index] = "";
                }
            }
            attr = attr22;
        } else if (sbase instanceof AssignmentRule) {
            if (sbase.getElementName().equals("speciesConcentrationRule")) {
                base = (AssignmentRule)sbase;
                attr2 = new String[]{"Species", base.getFormula(), "base.getType()", base.getVariable(), "", ""};
                attr = attr2;
            } else if (sbase.getElementName().equals("specieConcentrationRule")) {
                base = (AssignmentRule)sbase;
                attr2 = new String[]{"Species", base.getFormula(), "base.getType()", base.getVariable(), "", ""};
                attr = attr2;
            } else if (sbase.getElementName().equals("compartmentVolumeRule")) {
                base = (AssignmentRule)sbase;
                attr2 = new String[]{"Compartment", base.getFormula(), "base.getType()", base.getVariable(), "", ""};
                attr = attr2;
            } else if (sbase.getElementName().equals("ParameterRule")) {
                base = (AssignmentRule)sbase;
                attr2 = new String[]{"Parameter", base.getFormula(), "base.getType()", "", "", base.getVariable()};
                attr = attr2;
            } else {
                base = (AssignmentRule)sbase;
                attr2 = new String[]{strAssignment, base.getFormula(), LibSBMLUtil.getRateRuleL1TypeString((Rule)base), base.getVariable()};
                attr = attr2;
            }
        } else {
            attr = sbase instanceof SpeciesType ? LibSBMLUtil.getAttributeValues(sbase, specInfo) : (sbase instanceof CompartmentType ? LibSBMLUtil.getAttributeValues(sbase, specInfo) : (sbase instanceof InitialAssignment ? LibSBMLUtil.getAttributeValues(sbase, specInfo) : (sbase instanceof Constraint ? LibSBMLUtil.getAttributeValues(sbase, specInfo) : LibSBMLUtil.getAttributeValues(sbase, specInfo))));
        }
        String[] notesAttr = null;
        String[] annotAttr = null;
        int len = attr.length;
        if (notes != null) {
            notesAttr = notes.getAttributeValues();
            len += notesAttr.length;
        }
        if (!(annotation == null || sbase instanceof Protein || sbase instanceof RNA || sbase instanceof Gene || sbase instanceof AntiSenseRNA)) {
            annotAttr = annotation.getAttributeValues();
            len += annotAttr.length;
            if (annotation instanceof SpeciesAnnotation && positionToCompartmentIndex > -1) {
                attr[positionToCompartmentIndex] = annotAttr[1];
                attr[includedIndex] = annotAttr[2];
                annotAttr = new String[]{annotAttr[0]};
                --len;
            }
        }
        String[] rtn = new String[len];
        int i = 0;
        if (annotAttr != null) {
            int j = 0;
            while (j < annotAttr.length) {
                rtn[i++] = annotAttr[j];
                ++j;
            }
        }
        if (notesAttr != null) {
            int j = 0;
            while (j < notesAttr.length) {
                rtn[i++] = notesAttr[j];
                ++j;
            }
        }
        int j = 0;
        while (j < attr.length) {
            rtn[i++] = attr[j];
            ++j;
        }
        return rtn;
    }

    private static String[] getAttributeValues(SBase sbase, SpecInfo spec) {
        if (sbase instanceof ModificationResidue) {
            ModificationResidue base = (ModificationResidue)sbase;
            return new String[]{base.getId(), base.getName(), base.getSide(), Double.toString(base.getAngle())};
        }
        if (sbase instanceof BindingRegion) {
            BindingRegion base = (BindingRegion)sbase;
            return new String[]{base.getId(), base.getName(), Double.toString(base.getSize()), Double.toString(base.getAngle())};
        }
        if (sbase instanceof RNA) {
            RNA base = (RNA)sbase;
            return new String[]{base.getId(), base.getType(), base.getName()};
        }
        if (sbase instanceof Gene) {
            Gene base = (Gene)sbase;
            return new String[]{base.getId(), base.getType(), base.getName()};
        }
        if (sbase instanceof Protein) {
            Protein base = (Protein)sbase;
            return new String[]{base.getId(), base.getType(), base.getName()};
        }
        if (sbase instanceof ModificationRegion) {
            ModificationRegion base = (ModificationRegion)sbase;
            return new String[]{base.getId(), base.getName(), base.getType(), Double.toString(base.getSize()), Double.toString(base.getPos())};
        }
        if (sbase instanceof AntiSenseRNA) {
            AntiSenseRNA base = (AntiSenseRNA)sbase;
            return new String[]{base.getId(), base.getType(), base.getName()};
        }
        if (sbase instanceof Species) {
            Species base = (Species)sbase;
            if (spec.getLevel() == 1) {
                return new String[]{base.getId(), base.getCompartment(), Double.toString(base.getInitialAmount()), base.getSubstanceUnits(), new Boolean(base.getBoundaryCondition()).toString(), Integer.toString(base.getCharge())};
            }
            return new String[]{base.getId(), base.getName(), base.getSpeciesType(), base.getCompartment(), base.isSetInitialAmount() ? Double.toString(base.getInitialAmount()) : "", base.isSetInitialConcentration() ? Double.toString(base.getInitialConcentration()) : "", base.getSubstanceUnits(), base.getSpatialSizeUnits(), Boolean.toString(base.getHasOnlySubstanceUnits()), Boolean.toString(base.getBoundaryCondition()), Integer.toString(base.getCharge()), Boolean.toString(base.getConstant())};
        }
        if (sbase instanceof ModifierSpeciesReference) {
            ModifierSpeciesReference base = (ModifierSpeciesReference)sbase;
            return new String[]{base.getSpecies()};
        }
        if (sbase instanceof SpeciesReference) {
            SpeciesReference base = (SpeciesReference)sbase;
            if (spec.getLevel() == 1) {
                int[] parsed = null;
                if (parsed == null) {
                    parsed = new int[]{1, 1};
                }
                return new String[]{base.getSpecies(), Integer.toString(parsed[0]), Integer.toString(parsed[1])};
            }
            String st_d_str = "";
            if (base.getStoichiometryMath() == null) {
                st_d_str = Double.toString(base.getStoichiometry());
            }
            return new String[]{base.getSpecies(), st_d_str};
        }
        if (sbase instanceof SimpleSpeciesReference) {
            return null;
        }
        if (sbase instanceof Event) {
            Event base = (Event)sbase;
            if (spec.getLevel() == 1) {
                return new String[0];
            }
            return new String[]{base.getId(), base.getName()};
        }
        if (sbase instanceof Compartment) {
            Compartment base = (Compartment)sbase;
            if (spec.getLevel() == 1) {
                return new String[]{base.getId(), !base.isSetSize() ? "" : Double.toString(base.getSize()), base.getUnits(), base.getOutside()};
            }
            return new String[]{base.getId(), base.getName(), base.getCompartmentType(), Long.toString(base.getSpatialDimensions()), !base.isSetVolume() ? "" : Double.toString(base.getVolume()), base.getUnits(), base.getOutside(), Boolean.toString(base.getConstant())};
        }
        if (sbase instanceof FunctionDefinition) {
            FunctionDefinition base = (FunctionDefinition)sbase;
            if (spec.getLevel() == 1) {
                return new String[0];
            }
            return new String[]{base.getId(), base.getName()};
        }
        if (sbase instanceof KineticLaw) {
            KineticLaw base = (KineticLaw)sbase;
            if (spec.getLevel() == 1) {
                return new String[]{base.getFormula(), base.getTimeUnits(), base.getSubstanceUnits()};
            }
            return new String[]{base.getTimeUnits(), base.getSubstanceUnits()};
        }
        if (sbase instanceof UnitDefinition) {
            UnitDefinition base = (UnitDefinition)sbase;
            if (spec.getLevel() == 1) {
                return new String[]{base.getId()};
            }
            return new String[]{base.getId(), base.getName()};
        }
        if (sbase instanceof Parameter) {
            Parameter base = (Parameter)sbase;
            if (spec.getLevel() == 1) {
                return new String[]{base.getId(), LibSBMLUtil.trimDecimalEndZeroToString(base.getValue()), base.getUnits()};
            }
            return new String[]{base.getId(), base.getName(), LibSBMLUtil.trimDecimalEndZeroToString(base.getValue()), base.getUnits(), new Boolean(base.getConstant()).toString()};
        }
        if (sbase instanceof RateRule) {
            RateRule base = (RateRule)sbase;
            if (spec.getLevel() == 1) {
                return new String[]{base.getFormula(), "base.type", base.getVariable()};
            }
            return new String[]{base.getVariable()};
        }
        if (sbase instanceof AlgebraicRule) {
            AlgebraicRule base = (AlgebraicRule)sbase;
            if (spec.getLevel() == 1) {
                return new String[]{base.getFormula()};
            }
            return new String[0];
        }
        if (sbase instanceof EventAssignment) {
            EventAssignment base = (EventAssignment)sbase;
            if (spec.getLevel() == 1) {
                return new String[0];
            }
            return new String[]{base.getVariable()};
        }
        if (sbase instanceof Model) {
            Model base = (Model)sbase;
            if (spec.getLevel() == 1) {
                return new String[]{base.getId()};
            }
            return new String[]{base.getId(), base.getName()};
        }
        if (sbase instanceof Reaction) {
            Reaction base = (Reaction)sbase;
            if (spec.getLevel() == 1) {
                return new String[]{base.getId(), new Boolean(base.getReversible()).toString(), new Boolean(base.getFast()).toString()};
            }
            return new String[]{base.getId(), base.getName(), new Boolean(base.getReversible()).toString(), new Boolean(base.getFast()).toString()};
        }
        if (sbase instanceof AssignmentRule) {
            if (sbase.getElementName().equals("speciesConcentrationRule")) {
                AssignmentRule base = (AssignmentRule)sbase;
                return new String[]{base.getFormula(), "base.getType()", base.getVariable()};
            }
            if (sbase.getElementName().equals("specieConcentrationRule")) {
                AssignmentRule base = (AssignmentRule)sbase;
                return new String[]{base.getFormula(), "base.getType()", base.getVariable()};
            }
            if (sbase.getElementName().equals("compartmentVolumeRule")) {
                AssignmentRule base = (AssignmentRule)sbase;
                return new String[]{base.getFormula(), "base.getType()", base.getVariable()};
            }
            if (sbase.getElementName().equals("ParameterRule")) {
                AssignmentRule base = (AssignmentRule)sbase;
                return new String[]{base.getFormula(), "base.getType()", base.getVariable()};
            }
            AssignmentRule base = (AssignmentRule)sbase;
            if (spec.getLevel() == 1) {
                return new String[]{base.getFormula(), "base.type", base.getVariable()};
            }
            return new String[]{base.getVariable()};
        }
        if (sbase instanceof SBMLDocument) {
            SBMLDocument base = (SBMLDocument)sbase;
            return new String[]{Long.toString(base.getLevel()), Long.toString(base.getVersion())};
        }
        if (sbase instanceof Unit) {
            Unit base = (Unit)sbase;
            if (spec.getLevel() == 1) {
                return new String[]{libsbml.UnitKind_toString((int)base.getKind()), Integer.toString(base.getExponent()), Integer.toString(base.getScale())};
            }
            return new String[]{libsbml.UnitKind_toString((int)base.getKind()), Integer.toString(base.getExponent()), Integer.toString(base.getScale()), Double.toString(base.getMultiplier()), Double.toString(base.getOffset())};
        }
        if (sbase instanceof SpeciesType) {
            SpeciesType base = (SpeciesType)sbase;
            if (spec.getLevel() == 1) {
                return new String[0];
            }
            return new String[]{base.getId(), base.getName()};
        }
        if (sbase instanceof CompartmentType) {
            CompartmentType base = (CompartmentType)sbase;
            if (spec.getLevel() == 1) {
                return new String[0];
            }
            return new String[]{base.getId(), base.getName()};
        }
        if (sbase instanceof InitialAssignment) {
            InitialAssignment base = (InitialAssignment)sbase;
            if (spec.getLevel() == 1) {
                return new String[0];
            }
            String mathStr = "";
            if (base.getMath() != null) {
                mathStr = libsbml.formulaToString((ASTNode)base.getMath());
            }
            return new String[]{base.getSymbol(), mathStr};
        }
        if (sbase instanceof Constraint) {
            String msgStr;
            Constraint base = (Constraint)sbase;
            if (spec.getLevel() == 1) {
                return new String[0];
            }
            String mathStr = "";
            if (base.getMath() != null) {
                mathStr = libsbml.formulaToString((ASTNode)base.getMath());
            }
            if ((msgStr = ConstraintDialog.getMsgStringOfConstraint(base)) == null) {
                msgStr = "";
            }
            return new String[]{mathStr, msgStr};
        }
        return null;
    }

    public static ArrayList getListOfIncludedSpecies(ListOf listOfSpecies) {
        ArrayList<Species> listOfIncludedSpecies = new ArrayList<Species>();
        String defaultCompartmentValue = "";
        int i = 0;
        while ((long)i < listOfSpecies.size()) {
            Species species = (Species)listOfSpecies.get((long)i);
            if (species.getCompartment().equals("")) {
                listOfIncludedSpecies.add(species);
            }
            ++i;
        }
        return listOfIncludedSpecies;
    }

    public static ArrayList getListOfIndependentSpecies(ListOf listOfSpecies) {
        ArrayList<Species> listOfIndependentSpecies = new ArrayList<Species>();
        String defaultCompartmentValue = "";
        int i = 0;
        while ((long)i < listOfSpecies.size()) {
            Species species = (Species)listOfSpecies.get((long)i);
            if (!species.getCompartment().equals("")) {
                listOfIndependentSpecies.add(species);
            }
            ++i;
        }
        return listOfIndependentSpecies;
    }

    public static void setParameterAnnotation(ListOf listOfReaction) {
        int i = 0;
        while ((long)i < listOfReaction.size()) {
            Reaction r = (Reaction)listOfReaction.get((long)i);
            if (r.getKineticLaw() != null) {
                KineticLaw k = r.getKineticLaw();
                int j = 0;
                while ((long)j < k.getNumParameters()) {
                    Parameter p = k.getParameter((long)j);
                    XMLNode miriamannotation = null;
                    if (p.getAnnotation() != null) {
                        miriamannotation = p.getAnnotation().getChild(0L).cloneObject();
                    }
                    p.setAnnotation(LibSBMLUtil.addEnclosedAnnotationTags(r.getId()));
                    if (miriamannotation != null) {
                        p.appendAnnotation(miriamannotation);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static String getParameterScope(Parameter base) {
        if (MainWindow.getLastInstance() == null) {
            return "local:Reaction()";
        }
        if (LibSBMLUtil.havaReactionIDInfomation(base)) {
            StringBuffer buf = new StringBuffer(LOCAL_REACTION);
            buf.append("(");
            buf.append(base.getAnnotation().getChild(0L).getChild(0L).toString());
            buf.append(")");
            return buf.toString();
        }
        return GLOBAL;
    }

    public static boolean havaReactionIDInfomation(Parameter base) {
        if (base == null) {
            return false;
        }
        XMLNode annotation = base.getAnnotation();
        if (annotation != null && annotation.getNumChildren() > 0L) {
            int i = 0;
            while ((long)i < annotation.getNumChildren()) {
                XMLNode dnode = annotation.getChild((long)i);
                if (TAG_CELLDESIGNER_PREFIX.equals(dnode.getPrefix()) && TAG_CELLDESIGNER_EXTENSIONTOPLEVEL.equals(dnode.getName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isSpeciesReactantOf(Species s, Reaction r) {
        int i = 0;
        while ((long)i < r.getListOfReactants().size()) {
            SpeciesReference sr = (SpeciesReference)r.getListOfReactants().get((long)i);
            if (sr.getSpecies().equals(s.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSpeciesProductOf(Species s, Reaction r) {
        int i = 0;
        while ((long)i < r.getListOfProducts().size()) {
            SpeciesReference sr = (SpeciesReference)r.getListOfProducts().get((long)i);
            if (sr.getSpecies().equals(s.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static double getStoichiometry(Species s, Reaction r, boolean isProduct) {
        ListOfSpeciesReferences lo = isProduct ? r.getListOfProducts() : r.getListOfReactants();
        int i = 0;
        while ((long)i < lo.size()) {
            SpeciesReference sr = (SpeciesReference)lo.get((long)i);
            if (sr.getSpecies().equals(s.getId())) {
                return sr.getStoichiometry();
            }
            ++i;
        }
        return 1.0;
    }

    public static void insertSBase(Model model, int type, int index, SBase base) {
        block21: {
            int i;
            ListOfParameters listOfParameters;
            block23: {
                int i2;
                ListOfReactions listOfReactions;
                block22: {
                    int i3;
                    ListOfCompartments listOfCompartment;
                    block20: {
                        int i4;
                        listOfCompartment = model.getListOfCompartments();
                        listOfParameters = model.getListOfParameters();
                        listOfReactions = model.getListOfReactions();
                        ListOfSpecies listOfSpecies = model.getListOfSpecies();
                        if (type != 3) break block20;
                        ArrayList<Species> newList = new ArrayList<Species>();
                        long lsize = listOfSpecies.size();
                        if (lsize == 0L) {
                            newList.add((Species)base);
                        } else {
                            i4 = 0;
                            while ((long)i4 < lsize) {
                                if (index == i4) {
                                    newList.add((Species)base);
                                }
                                newList.add((Species)listOfSpecies.remove(0L));
                                ++i4;
                            }
                        }
                        i4 = 0;
                        while (i4 < newList.size()) {
                            listOfSpecies.appendAndOwn((SBase)((Species)newList.get(i4)));
                            ++i4;
                        }
                        break block21;
                    }
                    if (type != 2) break block22;
                    ArrayList<Compartment> newList = new ArrayList<Compartment>();
                    long lsize = listOfCompartment.size();
                    if (lsize == 0L) {
                        newList.add((Compartment)base);
                    } else {
                        i3 = 0;
                        while ((long)i3 < lsize) {
                            if (index == i3) {
                                newList.add((Compartment)base);
                            }
                            newList.add((Compartment)listOfCompartment.remove(0L));
                            ++i3;
                        }
                    }
                    i3 = 0;
                    while (i3 < newList.size()) {
                        listOfCompartment.appendAndOwn((SBase)((Compartment)newList.get(i3)));
                        ++i3;
                    }
                    break block21;
                }
                if (type != 6) break block23;
                ArrayList<Reaction> newList = new ArrayList<Reaction>();
                long lsize = listOfReactions.size();
                if (lsize == 0L) {
                    newList.add((Reaction)base);
                } else {
                    i2 = 0;
                    while ((long)i2 < lsize) {
                        if (index == i2) {
                            newList.add((Reaction)base);
                        }
                        newList.add((Reaction)listOfReactions.remove(0L));
                        ++i2;
                    }
                }
                i2 = 0;
                while (i2 < newList.size()) {
                    listOfReactions.appendAndOwn((SBase)((Reaction)newList.get(i2)));
                    ++i2;
                }
                break block21;
            }
            if (type != 4) break block21;
            ArrayList<Parameter> newList = new ArrayList<Parameter>();
            long lsize = listOfParameters.size();
            if (lsize == 0L) {
                newList.add((Parameter)base);
            } else {
                i = 0;
                while ((long)i < lsize) {
                    if (index == i) {
                        newList.add((Parameter)base);
                    }
                    newList.add((Parameter)listOfParameters.remove(0L));
                    ++i;
                }
            }
            i = 0;
            while (i < newList.size()) {
                listOfParameters.appendAndOwn((SBase)((Parameter)newList.get(i)));
                ++i;
            }
        }
    }

    private static void mathReplace(ASTNode math) {
        int i = 0;
        while ((long)i < math.getNumChildren()) {
            ASTNode child = math.getChild((long)i);
            if (!(child.isNumber() || child.isOperator() || child.isFunction() || child.isConstant())) {
                String id = child.getName();
                String name = LibSBMLUtil.replaceName(id);
                child.setName(name);
            }
            LibSBMLUtil.mathReplace(child);
            ++i;
        }
    }

    public static String replaceName(String id) {
        ListOfSpecies lstSBase = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel().getListOfSpecies();
        int i = 0;
        while ((long)i < lstSBase.size()) {
            Species specie = (Species)lstSBase.get((long)i);
            if (specie.getId().equals(id)) {
                return specie.getName();
            }
            ++i;
        }
        return id;
    }

    public static String validMathCheck(ASTNode math, SBMLPanelLists sbmlPanelLists) {
        int i = 0;
        while ((long)i < math.getNumChildren()) {
            String element;
            ASTNode child = math.getChild((long)i);
            if (!(child.isNumber() || child.isOperator() || child.isFunction() || child.isConstant() || LibSBMLUtil.isExistID(element = child.getName(), sbmlPanelLists))) {
                return element;
            }
            String result = LibSBMLUtil.validMathCheck(child, sbmlPanelLists);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean validMathCheck(ASTNode math, SBMLPanelLists sbmlPanelLists, Vector astErrNodes) {
        i = 0;
        while ((long)i < math.getNumChildren()) {
            block6: {
                block5: {
                    child = math.getChild((long)i);
                    if (!child.isName()) break block5;
                    element = child.getName();
                    if (LibSBMLUtil.isExistID(element, sbmlPanelLists)) ** GOTO lbl-1000
                    astErrNodes.add(new ASTErrorNode(1, element));
                    break block6;
                }
                if (child.isLambda()) {
                    astErrNodes.add(new ASTErrorNode(2, child.getName()));
                } else if (child.isUnknown()) {
                    astErrNodes.add(new ASTErrorNode(0, child.getName()));
                } else lbl-1000:
                // 2 sources

                {
                    LibSBMLUtil.validMathCheck(child, sbmlPanelLists, astErrNodes);
                }
            }
            ++i;
        }
        return astErrNodes.size() > 0;
    }

    public static boolean isExistID(String id, SBMLPanelLists sbmlPanelLists) {
        Parameter param;
        ListOf lstSBaseC = sbmlPanelLists.getSBaseListPanel(2).getSBaseList();
        int i = 0;
        while ((long)i < lstSBaseC.size()) {
            Compartment com = (Compartment)lstSBaseC.get((long)i);
            if (com.getId().equals(id)) {
                return true;
            }
            ++i;
        }
        ListOf lstSBase = sbmlPanelLists.getSBaseListPanel(3).getSBaseList();
        int i2 = 0;
        while ((long)i2 < lstSBase.size()) {
            Species specie = (Species)lstSBase.get((long)i2);
            if (specie.getId().equals(id)) {
                return true;
            }
            ++i2;
        }
        ListOf lstSBaseRe = sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        int i3 = 0;
        while ((long)i3 < lstSBaseRe.size()) {
            Reaction reaction = (Reaction)lstSBaseRe.get((long)i3);
            if (reaction.getId().equals(id)) {
                return true;
            }
            if (reaction.getKineticLaw() != null) {
                KineticLaw kl = reaction.getKineticLaw();
                ListOfParameters listOfParamaters = kl.getListOfParameters();
                int k = 0;
                while ((long)k < listOfParamaters.size()) {
                    param = (Parameter)listOfParamaters.get((long)k);
                    if (param.getId().equals(id)) {
                        return true;
                    }
                    ++k;
                }
            }
            ++i3;
        }
        ListOf lstSBaseP = sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
        int i4 = 0;
        while ((long)i4 < lstSBaseP.size()) {
            Parameter param2 = (Parameter)lstSBaseP.get((long)i4);
            if (param2.getId().equals(id)) {
                return true;
            }
            ++i4;
        }
        ListOf lstSBaseE = sbmlPanelLists.getSBaseListPanel(7).getSBaseList();
        int i5 = 0;
        while ((long)i5 < lstSBaseE.size()) {
            Event event = (Event)lstSBaseE.get((long)i5);
            if (event.getId().equals(id)) {
                return true;
            }
            ++i5;
        }
        ListOf lstSBaseF = sbmlPanelLists.getSBaseListPanel(0).getSBaseList();
        int i6 = 0;
        while ((long)i6 < lstSBaseF.size()) {
            FunctionDefinition def = (FunctionDefinition)lstSBaseF.get((long)i6);
            if (def.getId().equals(id)) {
                return true;
            }
            ++i6;
        }
        ListOf lstSBaseR = sbmlPanelLists.getSBaseListPanel(5).getSBaseList();
        int i7 = 0;
        while ((long)i7 < lstSBaseR.size()) {
            param = (Rule)lstSBaseR.get((long)i7);
            ++i7;
        }
        ListOf lstSBaseU = sbmlPanelLists.getSBaseListPanel(1).getSBaseList();
        int i8 = 0;
        while ((long)i8 < lstSBaseU.size()) {
            UnitDefinition unit = (UnitDefinition)lstSBaseU.get((long)i8);
            if (unit.getId().equals(id)) {
                return true;
            }
            ++i8;
        }
        ListOf lstSBaseST = sbmlPanelLists.getSBaseListPanel(14).getSBaseList();
        int i9 = 0;
        while ((long)i9 < lstSBaseST.size()) {
            SpeciesType sType = (SpeciesType)lstSBaseST.get((long)i9);
            if (sType.getId().equals(id)) {
                return true;
            }
            ++i9;
        }
        ListOf lstSBaseCT = sbmlPanelLists.getSBaseListPanel(15).getSBaseList();
        int i10 = 0;
        while ((long)i10 < lstSBaseCT.size()) {
            CompartmentType cType = (CompartmentType)lstSBaseCT.get((long)i10);
            if (cType.getId().equals(id)) {
                return true;
            }
            ++i10;
        }
        ListOf lstSBaseIA = sbmlPanelLists.getSBaseListPanel(16).getSBaseList();
        int i11 = 0;
        while ((long)i11 < lstSBaseIA.size()) {
            InitialAssignment ia = (InitialAssignment)lstSBaseIA.get((long)i11);
            if (ia.getSymbol().equals(id)) {
                return true;
            }
            ++i11;
        }
        ListOf lstSBaseIC = sbmlPanelLists.getSBaseListPanel(17).getSBaseList();
        int i12 = 0;
        while ((long)i12 < lstSBaseIC.size()) {
            Constraint ia = (Constraint)lstSBaseIC.get((long)i12);
            if (libsbml.formulaToString((ASTNode)ia.getMath()).equals(id)) {
                return true;
            }
            ++i12;
        }
        return id.equals(strMember5) || id.equals("delay");
    }

    public static void checkFunctionDefinitionArgument(ASTNode math) throws Exception {
        if (math == null) {
            throw new Exception("FunctionDefinition is null");
        }
        if (!math.isLambda()) {
            throw new Exception("FunctionDefinition is not lambda");
        }
        int count = (int)math.getNumChildren();
        int i = 0;
        while (i < count - 1) {
            ASTNode child = math.getChild((long)i);
            if (!child.isName()) {
                throw new Exception(String.valueOf(libsbml.formulaToString((ASTNode)child)) + " is not a valid bound variable.");
            }
            ++i;
        }
    }

    public static String getFunctionDefinitionArguments(ASTNode math) {
        if (math == null || !math.isLambda()) {
            return "";
        }
        if (math.isLambda()) {
            if (math.getNumChildren() == 2L) {
                return libsbml.formulaToString((ASTNode)math.getLeftChild());
            }
            int count = (int)math.getNumChildren();
            StringBuffer arguments = new StringBuffer();
            int i = 0;
            while (i < count - 1) {
                ASTNode child = math.getChild((long)i);
                String name = "";
                name = child.isInteger() ? libsbml.formulaToString((ASTNode)child) : child.getName();
                arguments.append(name);
                if (i + 1 < count - 1) {
                    arguments.append(", ");
                }
                ++i;
            }
            return arguments.toString();
        }
        return null;
    }

    public static ASTNode getFunctionDefinitionMath(ASTNode math, String arguments) {
        if (math == null || !math.isLambda()) {
            return math;
        }
        String stringMath = libsbml.formulaToString((ASTNode)math);
        stringMath = stringMath.substring(("lambda(" + arguments + Mark9).length(), stringMath.length() - ")".length());
        return libsbml.parseFormula((String)stringMath);
    }

    public static final SBMLDocument getNotEnableAnnotationDocument(SBMLDocument target, SpecInfo outputSpec) {
        SBMLDocument doc = null;
        doc = outputSpec == null || outputSpec.getLevel() >= 2 ? LibSBMLUtil.getPureSBMLAnnotationDocument(target, outputSpec, false, true) : LibSBMLUtil.getPureSBMLAnnotationDocument(target, outputSpec, true, true);
        return doc;
    }

    public static final SBMLDocument getPureSBMLAnnotationDocument(SBMLDocument target, SpecInfo outputSpec, boolean withoutAnnotation, boolean withoutNotes) {
        String strAnno;
        String strAnno2;
        Notes notes;
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        long lTargetLevel = 0L;
        long lTargetVersion = 0L;
        if (outputSpec == null) {
            lTargetLevel = 2L;
            lTargetVersion = 4L;
        } else {
            lTargetLevel = outputSpec.getLevel();
            lTargetVersion = outputSpec.getVersion();
        }
        SBMLDocument doc = new SBMLDocument();
        doc.setLevelAndVersion(target.getLevel(), target.getVersion());
        doc.setMetaId(target.getMetaId());
        if (withoutAnnotation) {
            doc.setAnnotation("");
        } else {
            doc.setAnnotation(target.getAnnotationString());
        }
        if (withoutNotes) {
            doc.setNotes("");
        } else {
            doc.setNotes(target.getNotesString());
        }
        Set set = SBModel.currentNameSpaceHash.keySet();
        Iterator it = set.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                String key = (String)it.next();
                String n = (String)SBModel.currentNameSpaceHash.get(key);
                boolean isAdded = false;
                int i = 0;
                while (i < doc.getNamespaces().getLength()) {
                    XMLNamespaces xmlns = doc.getNamespaces();
                    if (xmlns.getPrefix(i).equals(key)) {
                        isAdded = true;
                        break;
                    }
                    ++i;
                }
                if (n == null || n.trim().toLowerCase().equals("http://www.sbml.org/2001/ns/celldesigner".toLowerCase()) || isAdded) continue;
                doc.getNamespaces().add(n, key);
            }
        }
        XMLNamespaces xmlnsDoc = doc.getNamespaces();
        Model model = new Model();
        Model targetModel = target.getModel();
        model.setName(targetModel.getName());
        model.setId(targetModel.getId());
        ModelAnnotation modelAnnotation = (ModelAnnotation)sbModel.getHashModelAnnotation().get(targetModel.getId());
        XMLNamespaces xmlnsModel = xmlnsDoc.cloneObject();
        LibSBMLUtil.setNS(xmlnsModel, (Any)modelAnnotation);
        modelAnnotation.updateAnnotation(sbModel, targetModel, xmlnsModel);
        model.setMetaId(targetModel.getMetaId());
        model.setSBOTerm(sbModel.getModel().getSBOTerm());
        HashMap<String, String> excludeSBMLDocumentXMLNamespaces = new HashMap<String, String>();
        String kk = TAG_CELLDESIGNER_PREFIX;
        String vv = "http://www.sbml.org/2001/ns/celldesigner";
        excludeSBMLDocumentXMLNamespaces.put(kk, vv);
        LibSBMLUtil.setNS(doc, (Any)modelAnnotation, excludeSBMLDocumentXMLNamespaces);
        Notes modelNotes = (Notes)LibSBMLUtil.getNotes((SBase)targetModel, new SpecInfo(target.getLevel(), target.getVersion()));
        if (modelNotes != null) {
            modelNotes.updateNotes((SBase)targetModel);
        } else if (targetModel.getNotes() != null) {
            targetModel.setNotes(LibSBMLUtil.convertNotesToCDNotes(targetModel.getNotes()));
        }
        model.setAnnotation(LibSBMLUtil.removeXMLNS(targetModel.getAnnotation()));
        model.setNotes(targetModel.getNotes());
        if (withoutAnnotation) {
            model.setAnnotation("");
        } else {
            String strAnno3 = model.getAnnotationString();
            model.setAnnotation(XMLNode.convertStringToXMLNode((String)LibSBMLUtil.removeCelldExtAnno(strAnno3)));
        }
        if (withoutNotes) {
            model.setNotes("");
        }
        HashMap hash = MainWindow.getLastInstance().getCurrentModel().getSBModel().getHashRepairSpecies();
        int i = 0;
        while ((long)i < targetModel.getNumCompartments()) {
            Compartment com = targetModel.getCompartment((long)i);
            Compartment newCom = com.cloneObject();
            CompartmentAnnotation compAnnotation = (CompartmentAnnotation)sbModel.getHashCompartmentAnnotation().get(newCom.getId());
            XMLNamespaces xmlnsCompartment = xmlnsDoc.cloneObject();
            LibSBMLUtil.setNS(xmlnsCompartment, (Any)compAnnotation);
            compAnnotation.updateAnnotation(newCom, xmlnsCompartment);
            LibSBMLUtil.setNS(doc, (Any)compAnnotation, excludeSBMLDocumentXMLNamespaces);
            notes = (Notes)sbModel.getHashCompartmentNotes().get(newCom.getId());
            if (notes != null) {
                notes.updateNotes((SBase)newCom);
            } else if (newCom.getNotes() != null) {
                newCom.setNotes(LibSBMLUtil.convertNotesToCDNotes(newCom.getNotes()));
            }
            newCom.setAnnotation(LibSBMLUtil.removeXMLNS(newCom.getAnnotation()));
            if (withoutAnnotation) {
                newCom.setAnnotation("");
            } else {
                strAnno2 = newCom.getAnnotationString();
                newCom.setAnnotation(LibSBMLUtil.removeCelldExtAnno(strAnno2));
            }
            if (withoutNotes) {
                newCom.setNotes("");
            }
            model.addCompartment(newCom);
            ++i;
        }
        i = 0;
        while ((long)i < targetModel.getNumSpecies()) {
            Species spSrc = targetModel.getSpecies((long)i);
            if (!spSrc.getCompartment().equals("") && hash.get(spSrc.getId()) == null) {
                Species sp = spSrc.cloneObject();
                if (lTargetLevel < 2L) {
                    sp.setSpatialSizeUnits("");
                }
                SpeciesAnnotation spAnnotation = (SpeciesAnnotation)sbModel.getHashSpeciesAnnotation().get(sp.getId());
                XMLNamespaces xmlnsSpecies = xmlnsDoc.cloneObject();
                LibSBMLUtil.setNS(xmlnsSpecies, (Any)spAnnotation);
                spAnnotation.updateAnnotation(sp, xmlnsSpecies);
                Vector ComplexVct = spAnnotation.getReferingAliases();
                int j = 0;
                while (j < ComplexVct.size()) {
                    if (ComplexVct.get(j) instanceof ComplexSpeciesAlias) {
                        ((ComplexSpeciesAlias)ComplexVct.get(j)).update();
                    }
                    ++j;
                }
                LibSBMLUtil.setNS(doc, (Any)spAnnotation, excludeSBMLDocumentXMLNamespaces);
                Notes notes2 = (Notes)sbModel.getHashSpeciesNotes().get(sp.getId());
                if (notes2 != null) {
                    notes2.updateNotes((SBase)sp);
                } else if (sp.getNotes() != null) {
                    sp.setNotes(LibSBMLUtil.convertNotesToCDNotes(sp.getNotes()));
                }
                sp.setAnnotation(LibSBMLUtil.removeXMLNS(sp.getAnnotation()));
                if (withoutAnnotation) {
                    sp.setAnnotation("");
                } else {
                    String strAnno4 = sp.getAnnotationString();
                    sp.setAnnotation(LibSBMLUtil.removeCelldExtAnno(strAnno4));
                }
                if (withoutNotes) {
                    sp.setNotes("");
                }
                model.addSpecies(sp);
            }
            ++i;
        }
        i = 0;
        while ((long)i < targetModel.getNumReactions()) {
            SpeciesReference ref;
            KineticLaw kin;
            Reaction re = targetModel.getReaction((long)i);
            Reaction newRe = re.cloneObject();
            ReactionAnnotation reAnnotation = (ReactionAnnotation)sbModel.getHashReactionAnnotation().get(newRe.getId());
            XMLNamespaces xmlnsReaction = xmlnsDoc.cloneObject();
            LibSBMLUtil.setNS(xmlnsReaction, (Any)reAnnotation);
            reAnnotation.updateAnnotation(newRe, xmlnsReaction);
            LibSBMLUtil.setNS(doc, (Any)reAnnotation, excludeSBMLDocumentXMLNamespaces);
            newRe.setAnnotation(LibSBMLUtil.removeXMLNS(newRe.getAnnotation()));
            notes = (Notes)sbModel.getHashReactionNotes().get(newRe.getId());
            if (notes != null) {
                notes.updateNotes((SBase)newRe);
            } else if (newRe.getNotes() != null) {
                newRe.setNotes(LibSBMLUtil.convertNotesToCDNotes(newRe.getNotes()));
            }
            if (withoutAnnotation) {
                newRe.setAnnotation("");
            } else {
                strAnno2 = newRe.getAnnotationString();
                newRe.setAnnotation(LibSBMLUtil.removeCelldExtAnno(strAnno2));
            }
            if (withoutNotes) {
                newRe.setNotes("");
            }
            if ((kin = newRe.getKineticLaw()) != null) {
                kin.setAnnotation("");
                int k = 0;
                while ((long)k < kin.getNumParameters()) {
                    Parameter p = kin.getParameter((long)k);
                    p.setAnnotation("");
                    ++k;
                }
                if (kin.getFormula() == null || kin.getFormula().equals("")) {
                    kin.setMath(new ASTNode());
                }
            }
            ArrayList<Integer> removelist = new ArrayList<Integer>();
            int k = 0;
            while ((long)k < newRe.getNumReactants()) {
                ref = newRe.getReactant((long)k);
                if (hash.get(ref.getSpecies()) != null) {
                    removelist.add(new Integer(k));
                }
                ++k;
            }
            k = 0;
            while (k < removelist.size()) {
                newRe.getListOfReactants().remove((long)((Integer)removelist.get(k)).intValue());
                ++k;
            }
            k = 0;
            while ((long)k < newRe.getNumReactants()) {
                ((SpeciesReference)newRe.getListOfReactants().get((long)k)).setAnnotation("");
                ++k;
            }
            removelist = new ArrayList();
            k = 0;
            while ((long)k < newRe.getNumProducts()) {
                ref = newRe.getProduct((long)k);
                if (hash.get(ref.getSpecies()) != null) {
                    removelist.add(new Integer(k));
                }
                ++k;
            }
            k = 0;
            while (k < removelist.size()) {
                newRe.getListOfProducts().remove((long)((Integer)removelist.get(k)).intValue());
                ++k;
            }
            k = 0;
            while ((long)k < newRe.getNumProducts()) {
                ((SpeciesReference)newRe.getListOfProducts().get((long)k)).setAnnotation("");
                ++k;
            }
            k = 0;
            while ((long)k < newRe.getNumModifiers()) {
                ((ModifierSpeciesReference)newRe.getListOfModifiers().get((long)k)).setAnnotation("");
                ++k;
            }
            model.addReaction(newRe);
            ++i;
        }
        i = 0;
        while ((long)i < targetModel.getNumParameters()) {
            Parameter para = targetModel.getParameter((long)i);
            Parameter newPara = para.cloneObject();
            if (withoutAnnotation) {
                newPara.setAnnotation("");
            } else {
                strAnno = newPara.getAnnotationString();
                newPara.setAnnotation(LibSBMLUtil.removeCelldExtAnno(strAnno));
            }
            if (withoutNotes) {
                newPara.setNotes("");
            }
            model.addParameter(newPara);
            ++i;
        }
        if (lTargetLevel >= 2L) {
            i = 0;
            while ((long)i < targetModel.getNumEvents()) {
                Event ev = targetModel.getEvent((long)i);
                Event newEv = ev.cloneObject();
                if (withoutAnnotation) {
                    newEv.setAnnotation("");
                } else {
                    strAnno = newEv.getAnnotationString();
                    newEv.setAnnotation(LibSBMLUtil.removeCelldExtAnno(strAnno));
                }
                if (lTargetVersion < 4L) {
                    newEv.setUseValuesFromTriggerTime(true);
                }
                if (withoutNotes) {
                    newEv.setNotes("");
                }
                model.addEvent(newEv);
                ++i;
            }
            i = 0;
            while ((long)i < targetModel.getNumFunctionDefinitions()) {
                FunctionDefinition fd = targetModel.getFunctionDefinition((long)i);
                FunctionDefinition newfd = fd.cloneObject();
                if (withoutAnnotation) {
                    newfd.setAnnotation("");
                } else {
                    strAnno = newfd.getAnnotationString();
                    newfd.setAnnotation(LibSBMLUtil.removeCelldExtAnno(strAnno));
                }
                if (withoutNotes) {
                    newfd.setNotes("");
                }
                model.addFunctionDefinition(newfd);
                ++i;
            }
        }
        i = 0;
        while ((long)i < targetModel.getNumRules()) {
            Rule ru = targetModel.getRule((long)i);
            Rule newru = ru.cloneObject();
            if (withoutAnnotation) {
                newru.setAnnotation("");
            } else {
                strAnno = newru.getAnnotationString();
                newru.setAnnotation(LibSBMLUtil.removeCelldExtAnno(strAnno));
            }
            if (withoutNotes) {
                newru.setNotes("");
            }
            model.addRule(newru);
            ++i;
        }
        i = 0;
        while ((long)i < targetModel.getNumUnitDefinitions()) {
            ListOfUnits units;
            UnitDefinition ud = targetModel.getUnitDefinition((long)i);
            UnitDefinition newud = ud.cloneObject();
            if (lTargetLevel <= 1L && (units = newud.getListOfUnits()) != null && units.size() > 0L) {
                int usize = (int)units.size();
                int j = 0;
                while (j < usize) {
                    Unit unit = (Unit)units.get((long)j);
                    unit.setMultiplier(1.0);
                    unit.setOffset(0.0);
                    ++j;
                }
            }
            if (withoutAnnotation) {
                newud.setAnnotation("");
            } else {
                strAnno = newud.getAnnotationString();
                newud.setAnnotation(LibSBMLUtil.removeCelldExtAnno(strAnno));
            }
            if (withoutNotes) {
                newud.setNotes("");
            }
            model.addUnitDefinition(newud);
            ++i;
        }
        if (lTargetLevel > 2L || lTargetLevel == 2L && lTargetVersion >= 2L) {
            InitialAssignment newia;
            InitialAssignment ia;
            i = 0;
            while ((long)i < targetModel.getNumSpeciesTypes()) {
                SpeciesType st = targetModel.getSpeciesType((long)i);
                SpeciesType newst = st.cloneObject();
                if (withoutAnnotation) {
                    newst.setAnnotation("");
                } else {
                    strAnno = newst.getAnnotationString();
                    newst.setAnnotation(LibSBMLUtil.removeCelldExtAnno(strAnno));
                }
                if (withoutNotes) {
                    newst.setNotes("");
                }
                model.addSpeciesType(newst);
                ++i;
            }
            i = 0;
            while ((long)i < targetModel.getNumCompartmentTypes()) {
                CompartmentType ct = targetModel.getCompartmentType((long)i);
                CompartmentType newct = ct.cloneObject();
                if (withoutAnnotation) {
                    newct.setAnnotation("");
                } else {
                    strAnno = newct.getAnnotationString();
                    newct.setAnnotation(LibSBMLUtil.removeCelldExtAnno(strAnno));
                }
                if (withoutNotes) {
                    newct.setNotes("");
                }
                model.addCompartmentType(newct);
                ++i;
            }
            i = 0;
            while ((long)i < targetModel.getNumInitialAssignments()) {
                ia = targetModel.getInitialAssignment((long)i);
                newia = ia.cloneObject();
                if (withoutAnnotation) {
                    newia.setAnnotation("");
                } else {
                    strAnno = newia.getAnnotationString();
                    newia.setAnnotation(LibSBMLUtil.removeCelldExtAnno(strAnno));
                }
                if (withoutNotes) {
                    newia.setNotes("");
                }
                model.addInitialAssignment(newia);
                ++i;
            }
            i = 0;
            while ((long)i < targetModel.getNumConstraints()) {
                ia = targetModel.getConstraint((long)i);
                newia = ia.cloneObject();
                if (withoutAnnotation) {
                    newia.setAnnotation("");
                } else {
                    strAnno = newia.getAnnotationString();
                    newia.setAnnotation(LibSBMLUtil.removeCelldExtAnno(strAnno));
                }
                if (withoutNotes) {
                    newia.setNotes("");
                }
                model.addConstraint((Constraint)newia);
                ++i;
            }
        }
        doc.setModel(model);
        doc.setLevelAndVersion(target.getLevel(), target.getVersion());
        return doc;
    }

    public static final void unsetAnnotation(Model m) {
        Species sp;
        m.unsetAnnotation();
        int i = 0;
        while ((long)i < m.getNumReactions()) {
            SpeciesReference rt;
            Reaction re = m.getReaction((long)i);
            re.unsetAnnotation();
            int j = 0;
            while ((long)j < re.getNumReactants()) {
                rt = re.getReactant((long)j);
                rt.unsetAnnotation();
                ++j;
            }
            j = 0;
            while ((long)j < re.getNumProducts()) {
                rt = re.getProduct((long)j);
                rt.unsetAnnotation();
                ++j;
            }
            j = 0;
            while ((long)j < re.getNumModifiers()) {
                ModifierSpeciesReference md = re.getModifier((long)j);
                md.unsetAnnotation();
                ++j;
            }
            if (re.isSetKineticLaw()) {
                KineticLaw kl = re.getKineticLaw();
                kl.unsetAnnotation();
                int j2 = 0;
                while ((long)j2 < kl.getNumParameters()) {
                    Parameter pa = kl.getParameter((long)j2);
                    pa.unsetAnnotation();
                    ++j2;
                }
            }
            ++i;
        }
        i = 0;
        while ((long)i < m.getNumSpecies()) {
            sp = m.getSpecies((long)i);
            sp.unsetAnnotation();
            ++i;
        }
        i = 0;
        while ((long)i < m.getNumCompartments()) {
            sp = m.getCompartment((long)i);
            sp.unsetAnnotation();
            ++i;
        }
        i = 0;
        while ((long)i < m.getNumFunctionDefinitions()) {
            sp = m.getFunctionDefinition((long)i);
            sp.unsetAnnotation();
            ++i;
        }
        i = 0;
        while ((long)i < m.getNumUnitDefinitions()) {
            sp = m.getUnitDefinition((long)i);
            sp.unsetAnnotation();
            ++i;
        }
        i = 0;
        while ((long)i < m.getNumParameters()) {
            sp = m.getParameter((long)i);
            sp.unsetAnnotation();
            ++i;
        }
        i = 0;
        while ((long)i < m.getNumRules()) {
            sp = m.getRule((long)i);
            sp.unsetAnnotation();
            ++i;
        }
        i = 0;
        while ((long)i < m.getNumInitialAssignments()) {
            sp = m.getInitialAssignment((long)i);
            sp.unsetAnnotation();
            ++i;
        }
        i = 0;
        while ((long)i < m.getNumEvents()) {
            sp = m.getEvent((long)i);
            sp.unsetAnnotation();
            int j = 0;
            while ((long)j < sp.getNumEventAssignments()) {
                EventAssignment ea = sp.getEventAssignment((long)j);
                ea.unsetAnnotation();
                ++j;
            }
            ++i;
        }
        i = 0;
        while ((long)i < m.getNumSpeciesTypes()) {
            sp = m.getSpeciesType((long)i);
            sp.unsetAnnotation();
            ++i;
        }
        i = 0;
        while ((long)i < m.getNumConstraints()) {
            sp = m.getConstraint((long)i);
            sp.unsetAnnotation();
            ++i;
        }
    }

    public static final String removeCelldExtAnno(String annoinput) {
        String rtn = "";
        if (annoinput == null) {
            rtn = "";
        } else {
            String tagStt = "<celldesigner:extension>";
            String tagEnd = "</celldesigner:extension>";
            boolean bhave = annoinput.contains("<celldesigner:extension>");
            if (bhave) {
                bhave = annoinput.contains("</celldesigner:extension>");
            }
            if (bhave) {
                String newAnno;
                String[] arrStt = annoinput.split("<celldesigner:extension>");
                String[] arrEnd = annoinput.split("</celldesigner:extension>");
                rtn = newAnno = String.valueOf(arrStt[0]) + arrEnd[1];
            } else {
                rtn = annoinput;
            }
        }
        rtn = new String(rtn);
        return rtn;
    }

    public static void addXMLNSToSBMLDocument(SBMLDocument sbmldoc, XMLNamespaces xmlnsp) {
        if (xmlnsp == null) {
            return;
        }
        XMLNamespaces xmlnspdoc = sbmldoc.getNamespaces();
        int i = 0;
        while (i < xmlnsp.getLength()) {
            if (xmlnspdoc.getPrefix(xmlnsp.getURI(i)).equals("")) {
                xmlnspdoc.add(xmlnsp.getURI(i), xmlnsp.getPrefix(i));
            }
            ++i;
        }
    }

    public static void addXMLNSToSBMLDocument(SBMLDocument sbmldoc, XMLNode annt) {
        if (annt == null) {
            return;
        }
        LibSBMLUtil.addXMLNSToSBMLDocument(sbmldoc, annt.getNamespaces());
    }

    private static void setNS(SBMLDocument doc, Any any) {
        LibSBMLUtil.setNS(doc, any, null);
    }

    private static void setNS(SBMLDocument doc, Any any, HashMap excludeHmp) {
        HashMap hashLocalNS = any.getLocalNS();
        if (hashLocalNS == null) {
            return;
        }
        Set set = hashLocalNS.keySet();
        Iterator it = set.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                String key = (String)it.next();
                String n = (String)hashLocalNS.get(key);
                try {
                    if (excludeHmp != null) {
                        boolean bIncludedK = excludeHmp.containsKey(key);
                        boolean bIncludedV = excludeHmp.containsValue(n);
                        if (bIncludedK && bIncludedV) {
                            continue;
                        }
                    }
                }
                catch (Exception bIncludedK) {
                    // empty catch block
                }
                boolean isAdded = false;
                int i = 0;
                while (i < doc.getNamespaces().getLength()) {
                    XMLNamespaces xmlns = doc.getNamespaces();
                    if (xmlns.getPrefix(i).equals(key)) {
                        isAdded = true;
                        break;
                    }
                    ++i;
                }
                if (isAdded) continue;
                doc.getNamespaces().add(n, key);
            }
        }
    }

    private static void setNS(XMLNamespaces xmlns, Any any) {
        LibSBMLUtil.setNS(xmlns, any, null);
    }

    private static void setNS(XMLNamespaces xmlns, Any any, HashMap excludeHmp) {
        HashMap hashLocalNS = any.getLocalNS();
        if (hashLocalNS == null) {
            return;
        }
        Set set = hashLocalNS.keySet();
        Iterator it = set.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                String key = (String)it.next();
                String n = (String)hashLocalNS.get(key);
                try {
                    if (excludeHmp != null) {
                        boolean bIncludedK = excludeHmp.containsKey(key);
                        boolean bIncludedV = excludeHmp.containsValue(n);
                        if (bIncludedK && bIncludedV) {
                            continue;
                        }
                    }
                }
                catch (Exception bIncludedK) {
                    // empty catch block
                }
                boolean isAdded = false;
                int i = 0;
                while (i < xmlns.getLength()) {
                    if (xmlns.getPrefix(i).equals(key)) {
                        isAdded = true;
                        break;
                    }
                    ++i;
                }
                if (isAdded) continue;
                xmlns.add(n, key);
            }
        }
    }

    public static SBMLDocument updateNotesAndAnnotation(SBMLDocument target, SBModel sbModel) {
        InitialAssignment ia;
        Notes notes;
        Notes notes2;
        XMLNamespaces xmlns;
        int i;
        boolean isAdded;
        SBMLDocument doc = new SBMLDocument();
        doc.setLevelAndVersion(target.getLevel(), target.getVersion());
        doc.setMetaId(target.getMetaId());
        doc.setAnnotation(target.getAnnotation());
        doc.setNotes(target.getNotes());
        Set set = SBModel.currentNameSpaceHash.keySet();
        Iterator it = set.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                String key = (String)it.next();
                String n = (String)SBModel.currentNameSpaceHash.get(key);
                isAdded = false;
                i = 0;
                while (i < doc.getNamespaces().getLength()) {
                    xmlns = doc.getNamespaces();
                    if (xmlns.getPrefix(i).equals(key)) {
                        isAdded = true;
                        break;
                    }
                    ++i;
                }
                if (isAdded) continue;
                doc.getNamespaces().add(n, key);
            }
        }
        String ns = ModelAnnotation.getOutputNamespace();
        String uri = "http://www.sbml.org/2001/ns/celldesigner";
        isAdded = false;
        i = 0;
        while (i < doc.getNamespaces().getLength()) {
            xmlns = doc.getNamespaces();
            if (xmlns.getPrefix(i).equals(ns)) {
                isAdded = true;
                break;
            }
            ++i;
        }
        if (!isAdded) {
            doc.getNamespaces().add(uri, ns);
        }
        XMLNamespaces xmlnsDoc = doc.getNamespaces();
        Model model = new Model();
        Model targetModel = target.getModel();
        model.setName(targetModel.getName());
        model.setId(targetModel.getId());
        ModelAnnotation modelAnnotation = (ModelAnnotation)sbModel.getHashModelAnnotation().get(targetModel.getId());
        XMLNamespaces xmlnsModel = xmlnsDoc.cloneObject();
        LibSBMLUtil.setNS(xmlnsModel, (Any)modelAnnotation);
        modelAnnotation.updateAnnotation(sbModel, targetModel, xmlnsModel);
        model.setMetaId(targetModel.getMetaId());
        model.setSBOTerm(sbModel.getModel().getSBOTerm());
        LibSBMLUtil.setNS(doc, (Any)modelAnnotation);
        Notes modelNotes = (Notes)LibSBMLUtil.getNotes((SBase)targetModel, new SpecInfo(target.getLevel(), target.getVersion()));
        if (modelNotes != null) {
            modelNotes.updateNotes((SBase)targetModel);
        } else if (targetModel.getNotes() != null) {
            targetModel.setNotes(LibSBMLUtil.convertNotesToCDNotes(targetModel.getNotes()));
        }
        model.setAnnotation(LibSBMLUtil.removeXMLNS(targetModel.getAnnotation()));
        model.setNotes(targetModel.getNotes());
        int i2 = 0;
        while ((long)i2 < targetModel.getNumCompartments()) {
            Compartment com = targetModel.getCompartment((long)i2);
            CompartmentAnnotation compAnnotation = (CompartmentAnnotation)sbModel.getHashCompartmentAnnotation().get(com.getId());
            XMLNamespaces xmlnsCompartment = xmlnsDoc.cloneObject();
            LibSBMLUtil.setNS(xmlnsCompartment, (Any)compAnnotation);
            compAnnotation.updateAnnotation(com, xmlnsCompartment);
            LibSBMLUtil.setNS(doc, (Any)compAnnotation);
            notes2 = (Notes)sbModel.getHashCompartmentNotes().get(com.getId());
            if (notes2 != null) {
                notes2.updateNotes((SBase)com);
            } else if (com.getNotes() != null) {
                com.setNotes(LibSBMLUtil.convertNotesToCDNotes(com.getNotes()));
            }
            com.setAnnotation(LibSBMLUtil.removeXMLNS(com.getAnnotation()));
            model.addCompartment(com);
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < targetModel.getNumSpecies()) {
            Species sp = targetModel.getSpecies((long)i2);
            if (!sp.getCompartment().equals("")) {
                SpeciesAnnotation spAnnotation = (SpeciesAnnotation)sbModel.getHashSpeciesAnnotation().get(sp.getId());
                XMLNamespaces xmlnsSpecies = xmlnsDoc.cloneObject();
                LibSBMLUtil.setNS(xmlnsSpecies, (Any)spAnnotation);
                spAnnotation.updateAnnotation(sp, xmlnsSpecies);
                Vector ComplexVct = spAnnotation.getReferingAliases();
                int j = 0;
                while (j < ComplexVct.size()) {
                    if (ComplexVct.get(j) instanceof ComplexSpeciesAlias) {
                        ((ComplexSpeciesAlias)ComplexVct.get(j)).update();
                    }
                    ++j;
                }
                LibSBMLUtil.setNS(doc, (Any)spAnnotation);
                Notes notes3 = (Notes)sbModel.getHashSpeciesNotes().get(sp.getId());
                if (notes3 != null) {
                    notes3.updateNotes((SBase)sp);
                } else if (sp.getNotes() != null) {
                    sp.setNotes(LibSBMLUtil.convertNotesToCDNotes(sp.getNotes()));
                }
                sp.setAnnotation(LibSBMLUtil.removeXMLNS(sp.getAnnotation()));
                model.addSpecies(sp);
            }
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < targetModel.getNumReactions()) {
            XMLNamespaces xmlnsSpeciesReference;
            SpeciesReference ref;
            Reaction re = targetModel.getReaction((long)i2);
            ReactionAnnotation reAnnotation = (ReactionAnnotation)sbModel.getHashReactionAnnotation().get(re.getId());
            XMLNamespaces xmlnsReaction = xmlnsDoc.cloneObject();
            LibSBMLUtil.setNS(xmlnsReaction, (Any)reAnnotation);
            reAnnotation.updateAnnotation(re, xmlnsReaction);
            LibSBMLUtil.setNS(doc, (Any)reAnnotation);
            re.setAnnotation(LibSBMLUtil.removeXMLNS(re.getAnnotation()));
            notes2 = (Notes)sbModel.getHashReactionNotes().get(re.getId());
            if (notes2 != null) {
                notes2.updateNotes((SBase)re);
            } else if (re.getNotes() != null) {
                re.setNotes(LibSBMLUtil.convertNotesToCDNotes(re.getNotes()));
            }
            KineticLaw kin = re.getKineticLaw();
            if (kin != null) {
                notes2 = (Notes)sbModel.getHashKineticLawNotes().get(re.getId());
                if (notes2 != null) {
                    notes2.updateNotes((SBase)kin);
                } else if (kin.getNotes() != null) {
                    kin.setNotes(LibSBMLUtil.convertNotesToCDNotes(kin.getNotes()));
                }
                XMLNode anntWithoutCellDesignerTag = LibSBMLUtil.removeCellDesignerAnnotation(kin.getAnnotation());
                String annotation = LibSBMLUtil.readKineticLawAnnotation(kin);
                if (!annotation.equals("") && !annotation.equals(Mark5)) {
                    kin.setAnnotation(LibSBMLUtil.addEnclosedAnnotationTags("<celldesigner:selectedFunction>" + annotation + "</celldesigner:selectedFunction>"));
                    LibSBMLUtil.addXMLNSToSBMLDocument(doc, kin.getAnnotation());
                    kin.setAnnotation(LibSBMLUtil.removeXMLNS(kin.getAnnotation()));
                } else {
                    kin.setAnnotation("");
                }
                if (anntWithoutCellDesignerTag != null) {
                    kin.appendAnnotation(anntWithoutCellDesignerTag);
                }
                int k = 0;
                while ((long)k < kin.getNumParameters()) {
                    Parameter p = kin.getParameter((long)k);
                    String strkey = LibSBMLUtil.getHashKey(p, p.getId());
                    Notes notesforp = (Notes)sbModel.getHashParameterNotes().get(strkey);
                    if (notesforp != null) {
                        notesforp.updateNotes((SBase)p);
                    } else if (p.getNotes() != null) {
                        p.setNotes(LibSBMLUtil.convertNotesToCDNotes(p.getNotes()));
                    }
                    p.setAnnotation("");
                    ++k;
                }
                if (kin.getFormula() == null || kin.getFormula().equals("")) {
                    kin.setMath(new ASTNode());
                }
            }
            int k = 0;
            while ((long)k < re.getNumReactants()) {
                ref = re.getReactant((long)k);
                SpeciesReferenceAnnotation refAnnotation = (SpeciesReferenceAnnotation)sbModel.getHashSpeciesReferenceReactantsAnnotation().get(LibSBMLUtil.getSpeciesReferenceReactantKey(re.getId(), k));
                xmlnsSpeciesReference = xmlnsDoc.cloneObject();
                LibSBMLUtil.setNS(xmlnsSpeciesReference, (Any)refAnnotation);
                refAnnotation.updateAnnotation((SimpleSpeciesReference)ref, xmlnsSpeciesReference);
                LibSBMLUtil.setNS(doc, (Any)refAnnotation);
                ref.setAnnotation(LibSBMLUtil.removeXMLNS(ref.getAnnotation()));
                ++k;
            }
            k = 0;
            while ((long)k < re.getNumProducts()) {
                ref = re.getProduct((long)k);
                SpeciesReferenceAnnotation refAnnotation = (SpeciesReferenceAnnotation)sbModel.getHashSpeciesReferenceProductsAnnotation().get(LibSBMLUtil.getSpeciesReferenceProductKey(re.getId(), k));
                xmlnsSpeciesReference = xmlnsDoc.cloneObject();
                LibSBMLUtil.setNS(xmlnsSpeciesReference, (Any)refAnnotation);
                refAnnotation.updateAnnotation((SimpleSpeciesReference)ref, xmlnsSpeciesReference);
                LibSBMLUtil.setNS(doc, (Any)refAnnotation);
                ref.setAnnotation(LibSBMLUtil.removeXMLNS(ref.getAnnotation()));
                ++k;
            }
            k = 0;
            while ((long)k < re.getNumModifiers()) {
                ref = re.getModifier((long)k);
                SpeciesReferenceAnnotation refAnnotation = (SpeciesReferenceAnnotation)sbModel.getHashModifierSpeciesReferenceAnnotation().get(LibSBMLUtil.getSpeciesReferenceModifierKey(re.getId(), k));
                xmlnsSpeciesReference = xmlnsDoc.cloneObject();
                LibSBMLUtil.setNS(xmlnsSpeciesReference, (Any)refAnnotation);
                refAnnotation.updateAnnotation((SimpleSpeciesReference)ref, xmlnsSpeciesReference);
                LibSBMLUtil.setNS(doc, (Any)refAnnotation);
                ref.setAnnotation(LibSBMLUtil.removeXMLNS(ref.getAnnotation()));
                ++k;
            }
            model.addReaction(re);
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < targetModel.getNumParameters()) {
            Parameter pa = targetModel.getParameter((long)i2);
            String strkey = LibSBMLUtil.getHashKey(pa, pa.getId());
            Notes notes4 = (Notes)sbModel.getHashParameterNotes().get(strkey);
            if (notes4 != null) {
                notes4.updateNotes((SBase)pa);
            } else if (pa.getNotes() != null) {
                pa.setNotes(LibSBMLUtil.convertNotesToCDNotes(pa.getNotes()));
            }
            model.addParameter(pa);
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < targetModel.getNumEvents()) {
            Event ev = targetModel.getEvent((long)i2);
            notes = (Notes)sbModel.getHashEventNotes().get(ev.getId());
            if (notes != null) {
                notes.updateNotes((SBase)ev);
            } else if (ev.getNotes() != null) {
                ev.setNotes(LibSBMLUtil.convertNotesToCDNotes(ev.getNotes()));
            }
            model.addEvent(ev);
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < targetModel.getNumFunctionDefinitions()) {
            FunctionDefinition fd = targetModel.getFunctionDefinition((long)i2);
            notes = (Notes)sbModel.getHashFunctionNotes().get(fd.getId());
            if (notes != null) {
                notes.updateNotes((SBase)fd);
            } else if (fd.getNotes() != null) {
                fd.setNotes(LibSBMLUtil.convertNotesToCDNotes(fd.getNotes()));
            }
            model.addFunctionDefinition(fd);
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < targetModel.getNumRules()) {
            Rule ru = targetModel.getRule((long)i2);
            notes = (Notes)sbModel.getHashRuleNotes().get(ru.getFormula());
            if (notes != null) {
                notes.updateNotes((SBase)ru);
            } else if (ru.getNotes() != null) {
                ru.setNotes(LibSBMLUtil.convertNotesToCDNotes(ru.getNotes()));
            }
            model.addRule(ru);
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < targetModel.getNumUnitDefinitions()) {
            UnitDefinition ud = targetModel.getUnitDefinition((long)i2);
            notes = (Notes)sbModel.getHashUnitNotes().get(ud.getId());
            if (notes != null) {
                notes.updateNotes((SBase)ud);
            } else if (ud.getNotes() != null) {
                ud.setNotes(LibSBMLUtil.convertNotesToCDNotes(ud.getNotes()));
            }
            model.addUnitDefinition(ud);
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < targetModel.getNumSpeciesTypes()) {
            SpeciesType st = targetModel.getSpeciesType((long)i2);
            notes = (Notes)sbModel.getHashSpeciesTypeNotes().get(st.getId());
            if (notes != null) {
                notes.updateNotes((SBase)st);
            } else if (st.getNotes() != null) {
                st.setNotes(LibSBMLUtil.convertNotesToCDNotes(st.getNotes()));
            }
            model.addSpeciesType(st);
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < targetModel.getNumCompartmentTypes()) {
            CompartmentType ct = targetModel.getCompartmentType((long)i2);
            notes = (Notes)sbModel.getHashCompartmentTypeNotes().get(ct.getId());
            if (notes != null) {
                notes.updateNotes((SBase)ct);
            } else if (ct.getNotes() != null) {
                ct.setNotes(LibSBMLUtil.convertNotesToCDNotes(ct.getNotes()));
            }
            model.addCompartmentType(ct);
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < targetModel.getNumInitialAssignments()) {
            ia = targetModel.getInitialAssignment((long)i2);
            notes = (Notes)sbModel.getHashInitialAssignmentNotes().get(ia.getSymbol());
            if (notes != null) {
                notes.updateNotes((SBase)ia);
            } else if (ia.getNotes() != null) {
                ia.setNotes(LibSBMLUtil.convertNotesToCDNotes(ia.getNotes()));
            }
            model.addInitialAssignment(ia);
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < targetModel.getNumConstraints()) {
            ia = targetModel.getConstraint((long)i2);
            ASTNode math = ia.getMath();
            String strMath = "";
            if (math != null) {
                strMath = libsbml.formulaToString((ASTNode)math);
            }
            if (strMath != null && !strMath.trim().equals("")) {
                notes2 = (Notes)sbModel.getHashConstraintNotes().get(strMath);
                if (notes2 != null) {
                    notes2.updateNotes((SBase)ia);
                } else if (ia.getNotes() != null) {
                    ia.setNotes(LibSBMLUtil.convertNotesToCDNotes(ia.getNotes()));
                }
            }
            model.addConstraint((Constraint)ia);
            ++i2;
        }
        LibSBMLUtil.changetoAstTimeNode(model);
        doc.setModel(model);
        return doc;
    }

    public static final String addEnclosedAnnotationTags(String str) {
        return LibSBMLUtil.addEnclosedAnnotationTags(str, null);
    }

    public static final String addEnclosedAnnotationTags(String str, String strOtherAnnotation) {
        if (strOtherAnnotation == null) {
            strOtherAnnotation = "";
        }
        String rtn = "<annotation xmlns:celldesigner=\"http://www.sbml.org/2001/ns/celldesigner\"><celldesigner:extension>" + str + TAG_END_CELLDESIGNER + TAG_CELLDESIGNER_EXTENSIONTOPLEVEL + endMark1 + strOtherAnnotation + TAG_END_ANNOTATION;
        return rtn;
    }

    public static String trimDecimalEndZeroToString(double num) {
        try {
            if (Math.abs(num) >= 0.001 && Math.abs(num) <= 0.009) {
                String str = Double.toString(num);
                int index = str.length() - 1;
                while (str.charAt(index) == '0') {
                    --index;
                }
                str = str.substring(0, index + 1);
                return str;
            }
            return Double.toString(num);
        }
        catch (NumberFormatException ex) {
            return new String();
        }
    }

    public static void changePositionOfCompartment(String[] columnNames, int[] columnSizes) {
        int positionToCompartmentPosition = 5;
        int includedPosition = 6;
        int iPositionToCompartment = -1;
        int iIncludedSizes = -1;
        try {
            if (columnSizes != null) {
                int i = 0;
                while (i < columnNames.length) {
                    if (columnNames[i].equals(POSITION_TO_COMPARTMENT)) {
                        iPositionToCompartment = columnSizes[i];
                    } else if (columnNames[i].equals(Complex_InnerIncludedSpeciesInfo)) {
                        iIncludedSizes = columnSizes[i];
                    }
                    ++i;
                }
            }
        }
        catch (Exception myErr) {
            return;
        }
        Vector<String> vect01 = new Vector<String>();
        Vector<Integer> vect02 = new Vector<Integer>();
        int i = 0;
        while (i < columnNames.length) {
            if (!columnNames[i].equals(POSITION_TO_COMPARTMENT) && !columnNames[i].equals(Complex_InnerIncludedSpeciesInfo)) {
                vect01.add(new String(columnNames[i]));
                if (columnSizes != null) {
                    vect02.add(columnSizes[i]);
                }
            }
            ++i;
        }
        if (iPositionToCompartment != -1) {
            vect01.add(5, POSITION_TO_COMPARTMENT);
            if (columnSizes != null) {
                vect02.add(5, iPositionToCompartment);
            }
        }
        if (iIncludedSizes != -1) {
            vect01.add(6, Complex_InnerIncludedSpeciesInfo);
            if (columnSizes != null) {
                vect02.add(6, iIncludedSizes);
            }
        }
        i = 0;
        while (i < vect01.size()) {
            columnNames[i] = (String)vect01.get(i);
            if (columnSizes != null) {
                columnSizes[i] = (Integer)vect02.get(i);
            }
            ++i;
        }
    }

    public static XMLNode removeXMLNS(XMLNode xmln) {
        if (xmln == null) {
            return xmln;
        }
        XMLNode newxmln = new XMLNode(new XMLToken(new XMLTriple(xmln.getName(), "", ""), new XMLAttributes()));
        int i = 0;
        while ((long)i < xmln.getNumChildren()) {
            newxmln.addChild(xmln.getChild((long)i));
            ++i;
        }
        return newxmln;
    }

    public static void disableSBMLConsistencyCheck(SBMLDocument sbmldoc) {
        sbmldoc.setConsistencyChecks(9, false);
        sbmldoc.setConsistencyChecks(14, false);
        sbmldoc.setConsistencyChecks(12, false);
        sbmldoc.setConsistencyChecks(10, false);
        sbmldoc.setConsistencyChecks(7, false);
        sbmldoc.setConsistencyChecks(8, false);
        sbmldoc.setConsistencyChecks(11, false);
    }

    public static void enableALLSBMLConsistencyCheck(SBMLDocument sbmldoc) {
        sbmldoc.setConsistencyChecks(9, true);
        sbmldoc.setConsistencyChecks(14, true);
        sbmldoc.setConsistencyChecks(12, true);
        sbmldoc.setConsistencyChecks(10, true);
        sbmldoc.setConsistencyChecks(7, true);
        sbmldoc.setConsistencyChecks(8, true);
        sbmldoc.setConsistencyChecks(11, true);
    }

    public static void setDefaultSBMLConsistencyCheck(SBMLDocument sbmldoc) {
        sbmldoc.setConsistencyChecks(9, false);
        sbmldoc.setConsistencyChecks(14, true);
        sbmldoc.setConsistencyChecks(12, true);
        sbmldoc.setConsistencyChecks(10, true);
        sbmldoc.setConsistencyChecks(7, true);
        sbmldoc.setConsistencyChecks(8, true);
        sbmldoc.setConsistencyChecks(11, false);
    }

    public static boolean checkSBMLConsistency(SBMLDocument sbmldoc) throws Exception {
        Object errorList = null;
        LibSBMLUtil.setDefaultSBMLConsistencyCheck(sbmldoc);
        long numerr = sbmldoc.checkConsistency();
        return numerr <= 0L;
    }

    public ArrayList<SBMLError> getSBMLErrorList(SBMLDocument sbmldoc) {
        ArrayList<SBMLError> errorList = null;
        if (sbmldoc == null) {
            return null;
        }
        long numerr = sbmldoc.getNumErrors();
        if (numerr > 0L) {
            errorList = new ArrayList<SBMLError>();
            int i = 0;
            while ((long)i < numerr) {
                errorList.add(sbmldoc.getError((long)i));
                ++i;
            }
        }
        return errorList;
    }

    public static ArrayList<SBMLError> getSBMLErrorFatalList(SBMLDocument sbmldoc) {
        return LibSBMLUtil.getSBMLErrorList(sbmldoc, 3L);
    }

    public static ArrayList<SBMLError> getSBMLErrorErrorList(SBMLDocument sbmldoc) {
        return LibSBMLUtil.getSBMLErrorList(sbmldoc, 2L);
    }

    public static ArrayList<SBMLError> getSBMLErrorWarningList(SBMLDocument sbmldoc) {
        return LibSBMLUtil.getSBMLErrorList(sbmldoc, 1L);
    }

    private static ArrayList<SBMLError> getSBMLErrorList(SBMLDocument sbmldoc, long severity) {
        ArrayList<SBMLError> errorList = null;
        if (sbmldoc == null) {
            return null;
        }
        long numerr = sbmldoc.getNumErrors();
        if (numerr > 0L) {
            errorList = new ArrayList<SBMLError>();
            int i = 0;
            while ((long)i < numerr) {
                SBMLError sbmlerr = sbmldoc.getError((long)i);
                long s = sbmlerr.getSeverity();
                if (s == severity) {
                    errorList.add(sbmlerr);
                }
                ++i;
            }
            if (errorList.size() == 0) {
                return null;
            }
        }
        return errorList;
    }

    public static String[] getSBMLErrorMessages(SBMLDocument sbmldoc) {
        String[] msgs = new String[]{"", "", ""};
        long numerr = sbmldoc.getNumErrors();
        int i = 0;
        while ((long)i < numerr) {
            SBMLError sbmlerr = sbmldoc.getError((long)i);
            String severity = LibSBMLUtil.getSeverityString(sbmlerr.getSeverity());
            if (severity.equals("Fatal")) {
                msgs[0] = String.valueOf(msgs[0]) + LibSBMLUtil.SBMLErrorToString(sbmlerr) + LineChangeMark;
            } else if (severity.equals("Error")) {
                msgs[1] = String.valueOf(msgs[1]) + LibSBMLUtil.SBMLErrorToString(sbmlerr) + LineChangeMark;
            } else {
                msgs[2] = String.valueOf(msgs[2]) + LibSBMLUtil.SBMLErrorToString(sbmlerr) + LineChangeMark;
            }
            ++i;
        }
        return msgs;
    }

    public static int checkSBMLConsistencyAndShowMessage(SBMLDocument sbmldoc, Component parent, Object[] options) {
        LibSBMLUtil.setDefaultSBMLConsistencyCheck(sbmldoc);
        long numerr = sbmldoc.checkConsistency();
        if (numerr > 0L) {
            String[] msg = LibSBMLUtil.getSBMLErrorMessages(sbmldoc);
            if (!msg[0].equals("") || !msg[1].equals("")) {
                return LibSBMLUtil.showConsistencyCheckMessageDialog("libSBML Consistency Check", msg, 0, parent, options);
            }
            return LibSBMLUtil.showConsistencyCheckMessageDialog("libSBML Consistency Check", msg, 2, parent, options);
        }
        return -1;
    }

    public static int checkSBMLConsistencyAndShowErrorMessage(SBMLDocument sbmldoc, Component parent, Object[] options) {
        String[] msg;
        LibSBMLUtil.setDefaultSBMLConsistencyCheck(sbmldoc);
        long numerr = sbmldoc.checkConsistency();
        if (!(numerr <= 0L || (msg = LibSBMLUtil.getSBMLErrorMessages(sbmldoc))[0].equals("") && msg[1].equals(""))) {
            return LibSBMLUtil.showConsistencyCheckMessageDialog("libSBML Consistency Check", msg, 0, parent, options);
        }
        return -1;
    }

    public static int checkSBMLFatalErrorAndShowErrorMessage(SBMLDocument sbmldoc, Component parent, Object[] options) {
        long numerr = sbmldoc.getNumErrors();
        if (numerr > 0L) {
            String[] msg = LibSBMLUtil.getSBMLErrorMessages(sbmldoc);
            return LibSBMLUtil.showConsistencyCheckMessageDialog("Fatal Error", msg, 0, parent, options);
        }
        return -1;
    }

    public static String SBMLErrorToString(SBMLError sbmlerr) {
        String formattedMsg = "";
        String line = Long.toString(sbmlerr.getLine());
        String column = Long.toString(sbmlerr.getColumn());
        String severity = LibSBMLUtil.getSeverityString(sbmlerr.getSeverity());
        String category = LibSBMLUtil.getCategoryString(sbmlerr.getCategory());
        String msg = sbmlerr.getMessage();
        formattedMsg = "line " + line + " [" + severity + "(" + category + ")] : " + msg;
        return formattedMsg;
    }

    public static String getSeverityString(long severity) {
        if (severity == 3L) {
            return "Fatal";
        }
        if (severity == 2L || severity == 4L) {
            return "Error";
        }
        if (severity == 0L) {
            return "Advirosy";
        }
        return "Warning";
    }

    public static String getCategoryString(long category) {
        if (category == 7L) {
            return "General Consistency";
        }
        if (category == 8L) {
            return "Identifier Consistency";
        }
        if (category == 0L) {
            return "Internal";
        }
        if (category == 10L) {
            return "MathML Consistency";
        }
        if (category == 14L) {
            return "Modeling Practice";
        }
        if (category == 12L) {
            return "Overdetermined Model";
        }
        if (category == 3L) {
            return "SBML";
        }
        if (category == 1L) {
            return "System";
        }
        if (category == 9L) {
            return "Units Consistency";
        }
        if (category == 4L) {
            return "SBML L1 Compatibility";
        }
        if (category == 5L) {
            return "SBML L2V1 Compatibility";
        }
        if (category == 6L) {
            return "SBML L2V2 Compatibility";
        }
        if (category == 13L) {
            return "SBML L2V3 Compatibility";
        }
        if (category == 2L) {
            return "XML";
        }
        return "Unkown";
    }

    public static int showConsistencyCheckMessageDialog(String title, String[] message, int mtype, Component parent, Object[] options) {
        int xsize = 640;
        int ysize = 320;
        JTextArea tareaFatal = null;
        JTextArea tareaError = null;
        JTextArea tareaWarning = null;
        JScrollPane scrpFatal = null;
        JScrollPane scrpError = null;
        JScrollPane scrpWarning = null;
        JTabbedPane jtab = new JTabbedPane();
        int tabnum = 0;
        if (!message[0].equals("")) {
            tareaFatal = new JTextArea(message[0]);
            tareaFatal.setLineWrap(true);
            tareaFatal.setWrapStyleWord(true);
            tareaFatal.setEditable(false);
            scrpFatal = new JScrollPane(20, 31);
            scrpFatal.getViewport().add(tareaFatal);
            scrpFatal.setPreferredSize(new Dimension(640, 320));
            jtab.add(scrpFatal);
            jtab.setTitleAt(tabnum++, "Fatal");
        }
        if (!message[1].equals("")) {
            tareaError = new JTextArea(message[1]);
            tareaError.setLineWrap(true);
            tareaError.setWrapStyleWord(true);
            tareaError.setEditable(false);
            scrpError = new JScrollPane(20, 31);
            scrpError.getViewport().add(tareaError);
            scrpError.setPreferredSize(new Dimension(640, 320));
            jtab.add(scrpError);
            jtab.setTitleAt(tabnum++, "Error");
        }
        if (!message[2].equals("")) {
            tareaWarning = new JTextArea(message[2]);
            tareaWarning.setLineWrap(true);
            tareaWarning.setWrapStyleWord(true);
            tareaWarning.setEditable(false);
            scrpWarning = new JScrollPane(20, 31);
            scrpWarning.getViewport().add(tareaWarning);
            scrpWarning.setPreferredSize(new Dimension(640, 320));
            jtab.add(scrpWarning);
            jtab.setTitleAt(tabnum++, "Warning");
        }
        jtab.setPreferredSize(new Dimension(640, 320));
        jtab.setVisible(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(jtab);
        JOptionPane jpane = new JOptionPane(panel, mtype);
        jpane.setOptions(options);
        JDialog dialog = jpane.createDialog(parent, title);
        dialog.setResizable(true);
        dialog.setVisible(true);
        Object selectedValue = jpane.getValue();
        int selected = 0;
        int i = 0;
        while (i < options.length) {
            if (options[i].equals(selectedValue)) {
                selected = i;
                break;
            }
            ++i;
        }
        return selected;
    }

    public static void createProteinGeneRNAAntiSenseRNANotes(SBModel sbmodel) {
        try {
            if (sbmodel == null) {
                return;
            }
            LibSBMLUtil.createProteinGeneRNAAntiSenseRNANotes(sbmodel, "GENERIC");
            LibSBMLUtil.createProteinGeneRNAAntiSenseRNANotes(sbmodel, "GENE");
            LibSBMLUtil.createProteinGeneRNAAntiSenseRNANotes(sbmodel, "RNA");
            LibSBMLUtil.createProteinGeneRNAAntiSenseRNANotes(sbmodel, "ANTISENSE_RNA");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void createProteinGeneRNAAntiSenseRNANotes(SBModel sbmodel, String type) {
        try {
            if (sbmodel == null || type == null) {
                return;
            }
            Object[] list = null;
            if ("GENERIC".equals(type)) {
                list = sbmodel.getHashProtein().values().toArray();
            } else if ("GENE".equals(type)) {
                list = sbmodel.getHashGene().values().toArray();
            } else if ("RNA".equals(type)) {
                list = sbmodel.getHashRNA().values().toArray();
            } else if ("ANTISENSE_RNA".equals(type)) {
                list = sbmodel.getHashAntiSenseRNA().values().toArray();
            }
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    SBase sbase = (SBase)list[i];
                    LibSBMLUtil.getNotes(sbmodel, sbase, null);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getRateRuleL1TypeString(Rule base) {
        String l1rtype = "";
        try {
            Model m = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel();
            if (m != null) {
                String var = base.getVariable();
                if (m.getSpecies(var) != null) {
                    l1rtype = "Species";
                } else if (m.getCompartment(var) != null) {
                    l1rtype = "Compartment";
                } else if (m.getParameter(var) != null) {
                    l1rtype = "Parameter";
                }
            }
        }
        catch (Exception myErr) {
            l1rtype = "";
        }
        return l1rtype;
    }

    public static Vector getIDListOfSpeciesOrCompartmentOrParameter(SBase objectSBase, String variabletype) {
        Vector<Object> idList;
        block14: {
            idList = new Vector<Object>();
            if (variabletype == null || variabletype.trim().equals("")) {
                return idList;
            }
            try {
                SBModel sbm = MainWindow.getLastInstance().getCurrentModel().getSBModel();
                Model m = sbm.getModel();
                if (m == null) break block14;
                ListOfSpecies list = null;
                if (variabletype.equals("Species")) {
                    list = m.getListOfSpecies();
                } else if (variabletype.equals("Compartment")) {
                    list = m.getListOfCompartments();
                } else if (variabletype.equals("Parameter")) {
                    list = m.getListOfParameters();
                }
                if (list == null) break block14;
                Vector<String> vct = new Vector<String>();
                int i = 0;
                while ((long)i < list.size()) {
                    block16: {
                        block15: {
                            Species species;
                            if (!(objectSBase instanceof Rule) || !(objectSBase instanceof AssignmentRule) && !(objectSBase instanceof RateRule) || !variabletype.equals("Species") || (species = (Species)list.get((long)i)) == null) break block15;
                            boolean bBoundaryCondition = species.getBoundaryCondition();
                            boolean bConstant = species.getConstant();
                            if (!bBoundaryCondition && !bConstant && CelldUtil.isSpeciesBeUsedInReactionLinks(sbm, species)) break block16;
                        }
                        vct.add(list.get((long)i).getId());
                    }
                    ++i;
                }
                if (variabletype.equals("Compartment")) {
                    vct.remove("default");
                }
                Object[] objs = vct.toArray();
                Arrays.sort(objs);
                int i2 = 0;
                while (i2 < objs.length) {
                    idList.add(objs[i2]);
                    ++i2;
                }
            }
            catch (Exception ex) {
                idList.clear();
            }
        }
        return idList;
    }

    public static String getInitialTypeString(InitialAssignment base) {
        String l1rtype = "";
        try {
            Model m = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel();
            if (m != null) {
                String var = base.getSymbol();
                if (m.getSpecies(var) != null) {
                    l1rtype = "Species";
                } else if (m.getCompartment(var) != null) {
                    l1rtype = "Compartment";
                } else if (m.getParameter(var) != null) {
                    l1rtype = "Parameter";
                }
            }
        }
        catch (Exception myErr) {
            l1rtype = "";
        }
        return l1rtype;
    }

    public static boolean checkCompartmentSize(ListOf lstofcp, JFrame ownerFrame) {
        String message;
        boolean noundef = false;
        SBMLDocument sbmldoc = lstofcp.getSBMLDocument();
        if (sbmldoc != null && sbmldoc.getLevel() == 1L) {
            return true;
        }
        ArrayList<Compartment> nosize_cplist = new ArrayList<Compartment>();
        ArrayList<Compartment> havasize_cplist = new ArrayList<Compartment>();
        long lstsize = lstofcp.size();
        int i = 0;
        while ((long)i < lstsize) {
            block19: {
                Compartment cp = (Compartment)lstofcp.get((long)i);
                Model targetModel = sbmldoc.getModel();
                int j = 0;
                while ((long)j < targetModel.getNumInitialAssignments()) {
                    if (!targetModel.getInitialAssignment((long)j).getId().equals(cp.getId())) {
                        ++j;
                        continue;
                    }
                    break block19;
                }
                j = 0;
                while ((long)j < targetModel.getNumRules()) {
                    if (!targetModel.getRule((long)j).getId().equals(cp.getId())) {
                        ++j;
                        continue;
                    }
                    break block19;
                }
                if (cp.getSpatialDimensions() > 0L) {
                    if (!cp.isSetVolume()) {
                        nosize_cplist.add(cp);
                    }
                } else if (cp.getSpatialDimensions() == 0L && cp.isSetVolume()) {
                    havasize_cplist.add(cp);
                }
            }
            ++i;
        }
        if (havasize_cplist.size() > 0) {
            String title = "Invalid size";
            message = "Some [size] of Compartments were disregarded, \nbecause Compartments which belongs to is 'Dimensionless'.";
            if (!MainWindow.isIgnorAllCheckAndMessageNotice()) {
                JOptionPane.showMessageDialog(ownerFrame, message, title, 2);
            }
            int i2 = 0;
            while (i2 < havasize_cplist.size()) {
                ((Compartment)havasize_cplist.get(i2)).unsetSize();
                ++i2;
            }
        }
        if (nosize_cplist.size() > 0) {
            String title = "Compartment's size attribute is undefined.";
            message = "'size' attribute is undefined in the following compartments.\nIs it OK to set the value to '1.0' ? \n\n";
            int i3 = 0;
            while (i3 < nosize_cplist.size()) {
                int index = i3 + 1;
                message = String.valueOf(message) + "   " + index + ". Compartment '" + ((Compartment)nosize_cplist.get(i3)).getId() + "'\n";
                ++i3;
            }
            int option = 0;
            if (!MainWindow.isIgnorAllCheckAndMessageNotice()) {
                option = JOptionPane.showOptionDialog(ownerFrame, message, title, 0, 2, null, new Object[]{"Yes", "No"}, "Yes");
            }
            if (option != 1) {
                int i4 = 0;
                while (i4 < nosize_cplist.size()) {
                    ((Compartment)nosize_cplist.get(i4)).setVolume(1.0);
                    ++i4;
                }
                noundef = true;
            }
        } else {
            noundef = true;
        }
        return noundef;
    }

    public static final XMLNode getChildNodeUsingTagName(XMLNode node, String tagname, boolean strictly) {
        if (node == null) {
            return null;
        }
        if (tagname == null || tagname.trim().equals("")) {
            return null;
        }
        if (strictly && tagname.equals(node.getName())) {
            return node;
        }
        if (node.getName() != null && tagname.trim().toLowerCase().equals(node.getName().trim().toLowerCase())) {
            return node;
        }
        int i = 0;
        while ((long)i < node.getNumChildren()) {
            XMLNode rtnNodeTmp = LibSBMLUtil.getChildNodeUsingTagName(node.getChild((long)i), tagname, strictly);
            if (rtnNodeTmp != null) {
                return rtnNodeTmp;
            }
            ++i;
        }
        return null;
    }

    public static final void mergeNotesToCDNotes(XMLNode from, XMLNode to) {
        block19: {
            if (from == null || to == null) {
                return;
            }
            XMLNode htmlnotes = LibSBMLUtil.getChildNodeUsingTagName(to, "html", false);
            XMLNode head = LibSBMLUtil.getChildNodeUsingTagName(htmlnotes, "head", false);
            XMLNode title = LibSBMLUtil.getChildNodeUsingTagName(head, "head", false);
            XMLNode body = LibSBMLUtil.getChildNodeUsingTagName(htmlnotes, "body", false);
            if (htmlnotes == null || body == null || head == null) {
                return;
            }
            String ename = from.getName();
            if (ename == null) break block19;
            if (ename.trim().toLowerCase().equals(NOTES)) {
                LibSBMLUtil.mergeNotesToCDNotes(from.getChild(0L), to);
            } else if (ename.trim().toLowerCase().equals("html")) {
                int i = 0;
                while ((long)i < from.getNumChildren()) {
                    LibSBMLUtil.mergeNotesToCDNotes(from.getChild((long)i), to);
                    ++i;
                }
            } else if (ename.trim().toLowerCase().equals("head")) {
                int i = 0;
                while ((long)i < from.getNumChildren()) {
                    if (from.getChild((long)i).getName().trim().toLowerCase().equals("title")) {
                        int j = 0;
                        while ((long)j < head.getNumChildren()) {
                            if (head.getChild((long)j).getName().trim().toLowerCase().equals("title")) {
                                head.removeChild((long)j);
                                break;
                            }
                            ++j;
                        }
                    }
                    head.addChild(from.getChild((long)i));
                    ++i;
                }
            } else if (ename.trim().toLowerCase().equals("body")) {
                int i = 0;
                while ((long)i < from.getNumChildren()) {
                    body.addChild(from.getChild((long)i));
                    ++i;
                }
            } else if (!ename.equals("")) {
                body.addChild(from);
            } else {
                int i = 0;
                while ((long)i < from.getNumChildren()) {
                    body.addChild(from.getChild((long)i));
                    ++i;
                }
            }
        }
    }

    public static XMLNode convertNotesToCDNotes(XMLNode from) {
        StringBuffer buf = new StringBuffer();
        buf.append("<notes>\n");
        buf.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
        buf.append("<head> <title/> </head>\n");
        buf.append("<body>\n");
        buf.append("</body>\n");
        buf.append("</html>");
        buf.append("</notes>\n");
        XMLNode to = XMLNode.convertStringToXMLNode((String)buf.toString());
        LibSBMLUtil.mergeNotesToCDNotes(from, to);
        return to;
    }

    public static void convertNotesToCDNotes(SBase sbase) {
        if (sbase != null && sbase.getNotes() != null) {
            sbase.setNotes(LibSBMLUtil.convertNotesToCDNotes(sbase.getNotes()));
        }
    }

    public static String getCDNotesBodyString(XMLNode xn) {
        XMLNode xn_html;
        String ntext = "";
        if (xn != null && (xn_html = xn.getChild(0L)) != null) {
            XMLNode xn_body = null;
            int i = 0;
            while ((long)i < xn_html.getNumChildren()) {
                XMLNode xn_tmp = xn_html.getChild((long)i);
                if (xn_tmp != null && xn_tmp.getName().equals("body")) {
                    xn_body = xn_tmp;
                    break;
                }
                ++i;
            }
            if (xn_body != null) {
                i = 0;
                while ((long)i < xn_body.getNumChildren()) {
                    String t = XMLNode.convertXMLNodeToString((XMLNode)xn_body.getChild((long)i));
                    if (t != null) {
                        ntext = String.valueOf(ntext) + t;
                    }
                    ++i;
                }
            }
        }
        return ntext;
    }

    public static void hideTableColumn(TableColumn column) {
        try {
            column.setMinWidth(0);
            column.setMaxWidth(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final boolean haveConstantValueInMath(Object obj) {
        return false;
    }

    public static final String getHaveConstantValueInMathErroMessage(String strItem) {
        if (strItem == null || strItem.equals("")) {
            return "";
        }
        return "CONSTANT haven't been supported, in [" + strItem + Mark7 + Mark8;
    }

    public static final String getHashKey(Parameter parameter, String strId) {
        if (parameter == null) {
            return null;
        }
        String strkey = String.valueOf(LibSBMLUtil.getParameterScope(parameter)) + strappend + strId;
        return strkey;
    }

    public static final String getListOfValueAt(Object listInput, int row, int col) {
        Object list;
        if (listInput == null) {
            return null;
        }
        SBase sbase = null;
        if (listInput instanceof ListOf) {
            list = (ListOf)listInput;
            if (row < 0 || (long)row >= list.size()) {
                return null;
            }
            sbase = list.get((long)row);
        } else if (listInput instanceof ArrayList) {
            list = (ArrayList)listInput;
            if (row < 0 || row >= ((ArrayList)list).size()) {
                return null;
            }
            Object obj = ((ArrayList)list).get(row);
            if (obj == null || !(obj instanceof SBase)) {
                return null;
            }
            sbase = (SBase)obj;
        } else {
            return null;
        }
        String[] values = LibSBMLUtil.toStrings(sbase);
        if (values == null) {
            return null;
        }
        if (col < 0 || col >= values.length) {
            return null;
        }
        return values[col];
    }

    public static final List getListOfIdForCondition(int kind, int exponent, boolean useExponentFlag) {
        ListOfUnitDefinitions listOfUnitDefinitions = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel().getListOfUnitDefinitions();
        ArrayList<String> returnListOfOfUnitDefinitions = new ArrayList<String>();
        int i = 0;
        while ((long)i < listOfUnitDefinitions.size()) {
            Unit unit;
            ListOfUnits listOfUnits;
            String strID;
            UnitDefinition unitDefinition = (UnitDefinition)listOfUnitDefinitions.get((long)i);
            if (!(unitDefinition.getId() == null || "substance".equals(strID = unitDefinition.getId()) || "volume".equals(strID) || "area".equals(strID) || "length".equals(strID) || strMember5.equals(strID) || (listOfUnits = unitDefinition.getListOfUnits()).size() != 1L || (unit = (Unit)listOfUnits.get(0L)).getKind() != kind)) {
                if (useExponentFlag) {
                    if (unit.getExponent() == exponent) {
                        returnListOfOfUnitDefinitions.add(strID);
                    }
                } else {
                    returnListOfOfUnitDefinitions.add(strID);
                }
            }
            ++i;
        }
        return returnListOfOfUnitDefinitions;
    }

    public static final void changeSubstanceUnitsbyCompartmentChanged(Species species, String stroldCompartmentID, String strnewCompartmentID) {
    }

    public static final Compartment getCompartmentUsingID(String strId) {
        try {
            ListOfCompartments compartments = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel().getListOfCompartments();
            int cnt = 0;
            while ((long)cnt < compartments.size()) {
                Compartment compartment = (Compartment)compartments.get((long)cnt);
                if (compartment.getId() != null && compartment.getId().equals(strId)) {
                    return compartment;
                }
                ++cnt;
            }
            return null;
        }
        catch (Exception myErr) {
            return null;
        }
    }

    public static final String[] getUnitsForCompartment(String spatialDimensions) {
        if (spatialDimensions == null) {
            return null;
        }
        if (spatialDimensions.equals("1")) {
            return strListofUnitsForCompartment1;
        }
        if (spatialDimensions.equals("2")) {
            return strListofUnitsForCompartment2;
        }
        if (spatialDimensions.equals("3")) {
            return strListofUnitsForCompartment3;
        }
        return null;
    }

    public static final void setDefaultUnitsValueOf(Compartment compartment) {
        if (compartment == null) {
            return;
        }
        int dim = (int)compartment.getSpatialDimensions();
        if (compartment.getUnits() == null || compartment.getUnits().trim().equals("")) {
            if (dim == 1) {
                compartment.setUnits(strListofUnitsForCompartment1[0]);
            } else if (dim == 2) {
                compartment.setUnits(strListofUnitsForCompartment2[0]);
            } else if (dim == 3) {
                compartment.setUnits(strListofUnitsForCompartment3[0]);
            }
        }
    }

    public static final void replaceMathID(SBModel sbModel, String stroldId, String strnewId, int panelkubun, String strReactionId) {
        if (sbModel == null) {
            return;
        }
        if (stroldId == null) {
            return;
        }
        if (strnewId == null) {
            return;
        }
        Model model = sbModel.getModel();
        if (model == null) {
            return;
        }
        boolean elementDialogCloseFlag = false;
        SBMLPanelLists sbmlPanelLists = sbModel.getSBMLPanelLists();
        if (panelkubun == 1 || panelkubun == 3 || panelkubun == 4) {
            int k;
            String strmath;
            EventDialog evd;
            int n = 0;
            while ((long)n < model.getNumFunctionDefinitions()) {
                ASTNode math2;
                String fcMath;
                FunctionDefinition fc = model.getFunctionDefinition((long)n);
                String arguments = "";
                if (fc.getMath() != null) {
                    arguments = LibSBMLUtil.getFunctionDefinitionArguments(fc.getMath());
                }
                ASTNode math = null;
                if (fc.getMath() != null) {
                    math = LibSBMLUtil.getFunctionDefinitionMath(fc.getMath(), arguments);
                }
                if ((fcMath = LibSBMLUtil.changeASTNodeName(math, stroldId, strnewId, panelkubun)) != null && !"".equals(fcMath.trim()) && (math2 = FunctionDefinitionDialog.getFunctionDefinitionMath(fcMath, arguments)) != null) {
                    fc.setMath(math2);
                }
                ++n;
            }
            LibSBMLUtil.updatePanel(sbmlPanelLists, 0, elementDialogCloseFlag);
            n = 0;
            while ((long)n < model.getNumRules()) {
                Rule rule = model.getRule((long)n);
                if (rule.getFormula() != null && !"".equals(rule.getFormula().trim())) {
                    String strmath2 = LibSBMLUtil.changeASTNodeName(libsbml.parseFormula((String)rule.getFormula()), stroldId, strnewId, panelkubun);
                    rule.setFormula(strmath2);
                }
                if (panelkubun != 4 && stroldId.equals(rule.getVariable())) {
                    rule.setVariable(strnewId);
                }
                ++n;
            }
            LibSBMLUtil.updatePanel(sbmlPanelLists, 5, elementDialogCloseFlag);
            n = 0;
            while ((long)n < model.getNumEvents()) {
                Event ent = model.getEvent((long)n);
                LibSBMLUtil.changeEventDataBodyIDToNewID(ent, stroldId, strnewId, panelkubun);
                ++n;
            }
            SBaseListPanel spPanel = sbmlPanelLists.getSBaseListPanel(7);
            if (spPanel != null && spPanel.getElementDialog() != null && spPanel.getElementDialog().isVisible() && (evd = (EventDialog)spPanel.getElementDialog()).getObject() != null) {
                LibSBMLUtil.changeEventDataBodyIDToNewID((Event)evd.getObject(), stroldId, strnewId, panelkubun);
            }
            LibSBMLUtil.updatePanel(sbmlPanelLists, 7, elementDialogCloseFlag);
            int n2 = 0;
            while ((long)n2 < model.getNumInitialAssignments()) {
                InitialAssignment ia = model.getInitialAssignment((long)n2);
                strmath = LibSBMLUtil.changeASTNodeName(ia.getMath(), stroldId, strnewId, panelkubun);
                ia.setMath(libsbml.parseFormula((String)strmath));
                if (panelkubun != 4 && stroldId.equals(ia.getSymbol())) {
                    ia.setSymbol(strnewId);
                }
                ++n2;
            }
            LibSBMLUtil.updatePanel(sbmlPanelLists, 16, elementDialogCloseFlag);
            n2 = 0;
            while ((long)n2 < model.getNumConstraints()) {
                Constraint ctt = model.getConstraint((long)n2);
                strmath = LibSBMLUtil.changeASTNodeName(ctt.getMath(), stroldId, strnewId, panelkubun);
                ctt.setMath(libsbml.parseFormula((String)strmath));
                ++n2;
            }
            LibSBMLUtil.updatePanel(sbmlPanelLists, 17, elementDialogCloseFlag);
            if (panelkubun == 1 || panelkubun == 4) {
                k = 0;
                while ((long)k < model.getNumReactions()) {
                    String math;
                    Reaction reaction = model.getReaction((long)k);
                    if (panelkubun == 1) {
                        SpeciesReference ref;
                        int j = 0;
                        while ((long)j < reaction.getNumReactants()) {
                            ref = reaction.getReactant((long)j);
                            if (ref.getSpecies().equals(stroldId)) {
                                ref.setSpecies(strnewId);
                            }
                            ++j;
                        }
                        j = 0;
                        while ((long)j < reaction.getNumProducts()) {
                            ref = reaction.getProduct((long)j);
                            if (ref.getSpecies().equals(stroldId)) {
                                ref.setSpecies(strnewId);
                            }
                            ++j;
                        }
                        j = 0;
                        while ((long)j < reaction.getNumModifiers()) {
                            ref = reaction.getModifier((long)j);
                            if (ref.getSpecies().equals(stroldId)) {
                                ref.setSpecies(strnewId);
                            }
                            ++j;
                        }
                    }
                    if (reaction.getKineticLaw() != null && (math = LibSBMLUtil.changeASTNodeName(reaction.getKineticLaw().getMath(), stroldId, strnewId, panelkubun)) != null && !"".equals(math)) {
                        reaction.getKineticLaw().setFormula(math);
                    }
                    ++k;
                }
                LibSBMLUtil.updatePanel(sbmlPanelLists, 6, elementDialogCloseFlag);
            } else if (panelkubun == 3) {
                k = 0;
                while ((long)k < model.getNumReactions()) {
                    boolean havaSameID = false;
                    Reaction reaction = model.getReaction((long)k);
                    if (reaction.getKineticLaw() != null) {
                        String math;
                        int kcnt = 0;
                        while ((long)kcnt < reaction.getKineticLaw().getNumParameters()) {
                            Parameter parameter = reaction.getKineticLaw().getParameter((long)kcnt);
                            if (stroldId.equals(parameter.getId())) {
                                havaSameID = true;
                                break;
                            }
                            ++kcnt;
                        }
                        if (!havaSameID && (math = LibSBMLUtil.changeASTNodeName(reaction.getKineticLaw().getMath(), stroldId, strnewId, panelkubun)) != null && !"".equals(math)) {
                            reaction.getKineticLaw().setFormula(math);
                        }
                    }
                    ++k;
                }
                LibSBMLUtil.updatePanel(sbmlPanelLists, 6, elementDialogCloseFlag);
            }
        }
    }

    public static final void updatePanel(SBMLPanelLists sbmlPanelLists, int listofname, boolean elementDialogCloseFlag) {
        if (sbmlPanelLists == null) {
            return;
        }
        SBaseListPanel spPanel = sbmlPanelLists.getSBaseListPanel(listofname);
        if (spPanel != null) {
            MathEditPanel mePanel = null;
            boolean mathCheck = false;
            boolean nameCheck = false;
            if (spPanel.getElementDialog() != null && spPanel.getElementDialog() instanceof ReactionDialog) {
                ReactionDialog reactionDialog = (ReactionDialog)spPanel.getElementDialog();
                if (reactionDialog.kineticLawDialog != null && reactionDialog.kineticLawDialog.isShowing()) {
                    KineticLawDialog kineticDialog = (KineticLawDialog)reactionDialog.kineticLawDialog;
                    mePanel = kineticDialog.getMathEditPanel();
                    mathCheck = mePanel.getMathCheckValue();
                    nameCheck = mePanel.getNameCheckValue();
                }
            }
            spPanel.updateDialog();
            if (mePanel != null && (mathCheck || nameCheck)) {
                mePanel.setMathCheckValue(mathCheck);
                mePanel.setNameCheckValue(nameCheck);
                mePanel.setDisplay();
            }
            if (elementDialogCloseFlag) {
                spPanel.getElementDialog().setVisible(false);
            }
        }
    }

    public static final String changeASTNodeName(ASTNode node, String oldId, String newId, int functionchangeId) {
        if (node == null) {
            return "";
        }
        if (oldId == null || oldId.equals("")) {
            return libsbml.formulaToString((ASTNode)node);
        }
        if (newId == null || newId.equals("")) {
            return libsbml.formulaToString((ASTNode)node);
        }
        int count = (int)node.getNumChildren();
        if (4 == functionchangeId) {
            if (node.isFunction() && oldId.equals(node.getName())) {
                node.setName(newId);
            }
        } else if (node.isName() && oldId.equals(node.getName())) {
            node.setName(newId);
        }
        if (count > 0) {
            int i = 0;
            while (i < count) {
                ASTNode child = node.getChild((long)i);
                LibSBMLUtil.changeASTNodeName(child, oldId, newId, functionchangeId);
                ++i;
            }
        }
        return libsbml.formulaToString((ASTNode)node);
    }

    public static final void changeEventDataBodyIDToNewID(Event ent, String stroldId, String strnewId, int functionchange) {
        String delayMath;
        String trigMath;
        if (ent == null) {
            return;
        }
        if (stroldId == null || stroldId.equals("")) {
            return;
        }
        if (strnewId == null || strnewId.equals("")) {
            return;
        }
        if (ent.getTrigger() != null && (trigMath = LibSBMLUtil.changeASTNodeName(ent.getTrigger().getMath(), stroldId, strnewId, functionchange)) != null && !"".equals(trigMath.trim())) {
            ent.setTrigger(new Trigger(libsbml.parseFormula((String)trigMath)));
        }
        if (ent.getDelay() != null && (delayMath = LibSBMLUtil.changeASTNodeName(ent.getDelay().getMath(), stroldId, strnewId, functionchange)) != null && !"".equals(delayMath.trim())) {
            ent.setDelay(new Delay(libsbml.parseFormula((String)delayMath)));
        }
        int cnt = 0;
        while ((long)cnt < ent.getNumEventAssignments()) {
            EventAssignment entassign = ent.getEventAssignment((long)cnt);
            String entassignMath = LibSBMLUtil.changeASTNodeName(entassign.getMath(), stroldId, strnewId, functionchange);
            if (entassignMath != null && !"".equals(entassignMath.trim())) {
                entassign.setMath(libsbml.parseFormula((String)entassignMath));
            }
            if (functionchange != 4 && stroldId.equals(entassign.getVariable())) {
                entassign.setVariable(strnewId);
            }
            ++cnt;
        }
    }

    public static Vector getMiriamsFromNode(Vector vecDatas, Element node, MiriamDefinition miriam) {
        block9: {
            if (vecDatas == null) {
                return new Vector();
            }
            if (node == null) {
                return new Vector();
            }
            NodeList children0 = node.getChildNodes();
            String tempvalue = "";
            boolean miriamaddedflag = false;
            if (children0 == null || children0.getLength() <= 0) break block9;
            int ui = 0;
            while (ui < children0.getLength()) {
                block10: {
                    Node n;
                    block13: {
                        String[] dataTypeAndID;
                        block12: {
                            block11: {
                                n = children0.item(ui);
                                if (n.getNodeName() == null) break block10;
                                if (!n.getNodeName().equals(descriptionOfRdfOfAnnotationTag)) break block11;
                                Element elem1 = (Element)n;
                                Vector vector1 = LibSBMLUtil.getMiriamsFromNode(vecDatas, elem1, miriam);
                                if (vector1 != null && vector1.size() > 0) {
                                    vecDatas = vector1;
                                }
                                break block10;
                            }
                            if (!n.getNodeName().equals(bagOfRdfOfBqbiolOfDescriptionOfRdfOfAnnotationTag)) break block12;
                            Element elem3 = (Element)n;
                            Vector vector2 = LibSBMLUtil.getMiriamsFromNode(vecDatas, elem3, miriam);
                            if (vector2 != null && vector2.size() > 0) {
                                vecDatas = vector2;
                            }
                            break block10;
                        }
                        if (!n.getNodeName().equals(liOfBagOfRdfOfBqbiolOfDescriptionOfRdfOfAnnotationTagTagName)) break block13;
                        if (n.getAttributes().getLength() < 1) break block10;
                        String value = n.getAttributes().item(0).toString();
                        tempvalue = value.substring(value.indexOf(Mark1) + 1, value.length() - 1);
                        if (miriam == null || miriam.getRelation() == null || miriam.getRelation().equals("") || (dataTypeAndID = MiriamUtils.makeDataTypeAndIDUsingUri(tempvalue)) == null) break block10;
                        miriamaddedflag = true;
                        String strID = dataTypeAndID[1];
                        String strURL = dataTypeAndID[0];
                        if (strURL == null || strURL.equals("") || strID == null || strID.equals("")) break block10;
                        Vector<MiriamSubDefinition> vecData = miriam.getDatas();
                        if (vecData == null) {
                            vecData = new Vector<MiriamSubDefinition>();
                        }
                        MiriamSubDefinition singleDate = new MiriamSubDefinition();
                        MIRIAM miriamtemp = MainWindow.getInstanceOfMIRIAM();
                        String strDataTypename = MiriamUtils.getNameOfMiriamDatatypeUsingUri(miriamtemp, strURL);
                        singleDate.strDataType = new String(strDataTypename);
                        singleDate.strId = new String(strID);
                        int iUrlLen = strURL.length();
                        singleDate.strUri = new String(String.valueOf(strURL) + tempvalue.substring(iUrlLen, iUrlLen + 1) + strID);
                        vecData.add(singleDate);
                        miriam.setDatas(vecData);
                        break block10;
                    }
                    int count = 0;
                    while (count < MIRIAM.vectEnumerationRelationOfMIRIAM.size()) {
                        String tagName = MIRIAM.vectEnumerationRelationOfMIRIAM.get(count);
                        if (n.getNodeName().equals(tagName)) {
                            MiriamDefinition miriamtemp = new MiriamDefinition();
                            miriamtemp.setRelation(n.getNodeName());
                            Element elem2 = (Element)n;
                            vecDatas = LibSBMLUtil.getMiriamsFromNode(vecDatas, elem2, miriamtemp);
                            break;
                        }
                        ++count;
                    }
                }
                ++ui;
            }
            if (miriamaddedflag) {
                vecDatas.add(miriam);
            }
        }
        return vecDatas;
    }

    public static StringBuffer getMiriamValueFromMiriams(StringBuffer buff0, SBase sbase, Vector listOfMiriam, boolean onlyhavaMiriam) {
        Unit unit;
        int intKind;
        Rule rule;
        InitialAssignment init;
        String strSym;
        Constraint con;
        String strMath;
        if (listOfMiriam == null || listOfMiriam.size() == 0) {
            return buff0;
        }
        if (sbase == null) {
            return buff0;
        }
        if (sbase instanceof Constraint ? (strMath = libsbml.formulaToString((ASTNode)(con = (Constraint)sbase).getMath())) == null || "".equals(strMath.trim()) : (sbase instanceof InitialAssignment ? (strSym = (init = (InitialAssignment)sbase).getSymbol()) == null || "".equals(strSym.trim()) : (sbase instanceof Rule ? (strMath = libsbml.formulaToString((ASTNode)(rule = (Rule)sbase).getMath())) == null || "".equals(strMath.trim()) : (sbase instanceof Unit ? (intKind = (unit = (Unit)sbase).getKind()) <= 0 : !(sbase instanceof KineticLaw) && !(sbase instanceof Protein) && !(sbase instanceof Gene) && !(sbase instanceof RNA) && !(sbase instanceof AntiSenseRNA) && !(sbase instanceof ModifierSpeciesReference) && !(sbase instanceof SpeciesReference) && sbase.getId() == null)))) {
            return buff0;
        }
        String strMetaId = sbase.getMetaId();
        if (strMetaId == null || strMetaId.trim().equals("")) {
            strMetaId = sbase.getId();
        }
        StringBuffer newBuffer = new StringBuffer(buff0);
        if (onlyhavaMiriam) {
            newBuffer.append("<rdf:RDF\n");
            newBuffer.append("xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\"\n");
            newBuffer.append("xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\"\n");
            newBuffer.append("xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n");
            newBuffer.append(">\n");
            newBuffer.append("<rdf:Description rdf:about=\"#" + strMetaId + Mark1 + endMark1 + LineChangeMark);
        }
        int i = 0;
        while (i < listOfMiriam.size()) {
            MiriamDefinition miriam = (MiriamDefinition)listOfMiriam.get(i);
            String strReaction = miriam.getRelation();
            if (MIRIAM.vectEnumerationRelationOfMIRIAM.contains(strReaction) && miriam.getDatas() != null && miriam.getDatas().size() > 0) {
                Vector vecData = miriam.getDatas();
                newBuffer.append(startMark + strReaction + endMark1 + LineChangeMark);
                newBuffer.append("<rdf:Bag>\n");
                int cnt = 0;
                while (cnt < vecData.size()) {
                    MiriamSubDefinition singleData = (MiriamSubDefinition)vecData.get(cnt);
                    String strURI = "";
                    if (singleData != null) {
                        strURI = new String(singleData.strUri);
                        newBuffer.append("<rdf:li rdf:resource=\"" + strURI + Mark1 + "/" + endMark1 + LineChangeMark);
                    }
                    ++cnt;
                }
            } else {
                return buff0;
            }
            newBuffer.append("</rdf:Bag>\n");
            newBuffer.append("</" + strReaction + endMark1 + LineChangeMark);
            ++i;
        }
        if (onlyhavaMiriam) {
            newBuffer.append("</rdf:Description>\n");
            newBuffer.append("</rdf:RDF>\n");
        }
        return newBuffer;
    }

    public static final Vector getMiriamDatasFromAnnotationOfSBase(SBase sbase) {
        XMLNode node;
        if (sbase == null) {
            return null;
        }
        Vector vecData = null;
        if (sbase.getAnnotation() != null && (node = sbase.getAnnotation()) != null && node.getNumChildren() > 0L) {
            XMLNode dnode = null;
            if (node.getNumChildren() > 1L) {
                int i = 0;
                while ((long)i < node.getNumChildren()) {
                    XMLNode child = node.getChild((long)i);
                    if (LibSBMLUtil.isRdfOfAnnotationNode(child)) {
                        dnode = child;
                        break;
                    }
                    ++i;
                }
            } else {
                XMLNode morechild = node.getChild(0L);
                if (LibSBMLUtil.isRdfOfAnnotationNode(morechild)) {
                    dnode = morechild;
                } else if (morechild != null && LibSBMLUtil.isRdfOfAnnotationNode(morechild.getChild(0L))) {
                    dnode = morechild.getChild(0L);
                }
            }
            vecData = MiriamMainPanel.getMiriamsFromXMLNode(new Vector(), dnode, null);
        }
        return vecData;
    }

    public static final boolean isRdfOfAnnotationNode(XMLNode node) {
        if (node == null) {
            return false;
        }
        if (node.getPrefix() == null) {
            return false;
        }
        if (node.getName() == null) {
            return false;
        }
        String strTag = String.valueOf(node.getPrefix()) + ":" + node.getName();
        return rdfOfRdfOfAnnotationTag.equals(strTag);
    }

    public static final void creatListPanelsNotes(SBModel sbmodel) {
        if (sbmodel == null) {
            return;
        }
        LibSBMLUtil.creatListPanelNotes(sbmodel, strParameters);
        LibSBMLUtil.creatListPanelNotes(sbmodel, strLocalParameters);
        LibSBMLUtil.creatListPanelNotes(sbmodel, strFunctionDefinitions);
        LibSBMLUtil.creatListPanelNotes(sbmodel, strUnitDefinitions);
        LibSBMLUtil.creatListPanelNotes(sbmodel, strRules);
        LibSBMLUtil.creatListPanelNotes(sbmodel, strEvents);
        LibSBMLUtil.creatListPanelNotes(sbmodel, strSpeciesTypes);
        LibSBMLUtil.creatListPanelNotes(sbmodel, strCompartmentTypes);
        LibSBMLUtil.creatListPanelNotes(sbmodel, strInitialAssignments);
        LibSBMLUtil.creatListPanelNotes(sbmodel, strConstraints);
    }

    public static final void creatListPanelNotes(SBModel sbmodel, String strType) {
        if (sbmodel == null || sbmodel.getModel() == null) {
            return;
        }
        if (strType == null || strType.equals("")) {
            return;
        }
        Model model = sbmodel.getModel();
        ListOfParameters list = null;
        if (strType.equals(strParameters)) {
            list = model.getListOfParameters();
        } else {
            if (strType.equals(strLocalParameters)) {
                ListOfReactions listReaction = model.getListOfReactions();
                if (listReaction != null) {
                    int t = 0;
                    while ((long)t < listReaction.size()) {
                        ListOfParameters kinParameters;
                        list = null;
                        Reaction reation = (Reaction)listReaction.get((long)t);
                        if (reation != null && reation.getKineticLaw() != null && (kinParameters = reation.getKineticLaw().getListOfParameters()) != null && kinParameters.size() > 0L) {
                            list = kinParameters;
                        }
                        if (list != null) {
                            int i = 0;
                            while ((long)i < list.size()) {
                                SBase sbase = list.get((long)i);
                                LibSBMLUtil.getNotes(sbmodel, sbase, null);
                                ++i;
                            }
                        }
                        ++t;
                    }
                }
                return;
            }
            if (strType.equals(strFunctionDefinitions)) {
                list = model.getListOfFunctionDefinitions();
            } else if (strType.equals(strUnitDefinitions)) {
                list = model.getListOfUnitDefinitions();
            } else if (strType.equals(strRules)) {
                list = model.getListOfRules();
            } else if (strType.equals(strEvents)) {
                list = model.getListOfEvents();
            } else if (strType.equals(strSpeciesTypes)) {
                list = model.getListOfSpeciesTypes();
            } else if (strType.equals(strCompartmentTypes)) {
                list = model.getListOfCompartmentTypes();
            } else if (strType.equals(strInitialAssignments)) {
                list = model.getListOfInitialAssignments();
            } else if (strType.equals(strConstraints)) {
                list = model.getListOfConstraints();
            }
        }
        if (list != null) {
            int i = 0;
            while ((long)i < list.size()) {
                SBase sbase = list.get((long)i);
                LibSBMLUtil.getNotes(sbmodel, sbase, null);
                ++i;
            }
        }
    }

    public static final String isValidSBMLUnitKind(String unitInput, boolean CaseSensitive) {
        if (unitInput == null) {
            return "";
        }
        String unit = unitInput.trim();
        if (unit.equals("")) {
            return "";
        }
        String unitLowerCase = unit.toLowerCase();
        String[] strArg = strListofSBMLKind;
        int i = 0;
        while (i < strArg.length) {
            String unitTmp = strArg[i];
            if (CaseSensitive ? unitTmp.equals(unit) : unitTmp.toLowerCase().equals(unitLowerCase)) {
                return new String(unitTmp);
            }
            ++i;
        }
        return "";
    }

    public static final boolean isValidSBMLUnitKind(int unitInput) {
        String[] strArg = strListofSBMLKind;
        int i = 0;
        while (i < strArg.length) {
            if (libsbml.UnitKind_forName((String)strArg[i]) == unitInput) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void checkCompartmentDimensionAndUnits(ListOf lstofcp, JFrame ownerFrame) {
        int i;
        if (lstofcp == null || lstofcp.size() == 0L) {
            return;
        }
        if (ownerFrame == null) {
            return;
        }
        ArrayList<Compartment> spatialDimensionsExceeded_cplist = new ArrayList<Compartment>();
        ArrayList<Compartment> spatialUnits_cplist = new ArrayList<Compartment>();
        ArrayList<Compartment> spatialUnits_cplist1 = new ArrayList<Compartment>();
        int i2 = 0;
        while ((long)i2 < lstofcp.size()) {
            Compartment cp = (Compartment)lstofcp.get((long)i2);
            if (cp.getSpatialDimensions() < 0L || cp.getSpatialDimensions() > 3L) {
                spatialDimensionsExceeded_cplist.add(cp);
            } else if (cp.getSpatialDimensions() == 0L) {
                if (cp.getUnits() != null && !cp.getUnits().equals("")) {
                    spatialUnits_cplist1.add(cp);
                }
            } else if (cp.getUnits() == null || cp.getUnits().equals("")) {
                spatialUnits_cplist.add(cp);
            }
            ++i2;
        }
        String message = "";
        String message1 = null;
        String message2 = null;
        String message3 = null;
        if (spatialDimensionsExceeded_cplist != null && spatialDimensionsExceeded_cplist.size() > 0) {
            message1 = "Some [spatialDimensions] of Compartment have been reset to Default value,\nbecause [spatialDimensions] of the Compartment in Xml file is invalid.\n";
            i = 0;
            while (i < spatialDimensionsExceeded_cplist.size()) {
                ((Compartment)spatialDimensionsExceeded_cplist.get(i)).setSpatialDimensions(LibSBMLUtil.getDefaultDimensionOfCompartment());
                ((Compartment)spatialDimensionsExceeded_cplist.get(i)).setUnits("");
                LibSBMLUtil.setDefaultUnitsValueOf((Compartment)spatialDimensionsExceeded_cplist.get(i));
                ++i;
            }
        }
        if (spatialUnits_cplist != null && spatialUnits_cplist.size() > 0) {
            message2 = "Some [units] of Compartment have been reset to Default value,\nbecause [spatialDimensions] of the Compartment is Not Zero.\n";
            i = 0;
            while (i < spatialUnits_cplist.size()) {
                LibSBMLUtil.setDefaultUnitsValueOf((Compartment)spatialUnits_cplist.get(i));
                ++i;
            }
        }
        if (spatialUnits_cplist1 != null && spatialUnits_cplist1.size() > 0) {
            message3 = "Some [units] of Compartment have been reset to Default value,\nbecause [spatialDimensions] of the Compartment is Zero.\n";
            i = 0;
            while (i < spatialUnits_cplist1.size()) {
                Compartment ct = (Compartment)spatialUnits_cplist1.get(i);
                ct.setUnits("");
                ++i;
            }
        }
        if (message1 != null && !message1.equals("")) {
            message = String.valueOf(message) + message1;
        }
        if (message2 != null && !message2.equals("")) {
            message = message != null && !message.equals("") ? String.valueOf(message) + LineChangeMark + message2 : String.valueOf(message) + message2;
        }
        if (message3 != null && !message3.equals("")) {
            message = message != null && !message.equals("") ? String.valueOf(message) + LineChangeMark + message3 : String.valueOf(message) + message3;
        }
        if (message != null && !message.equals("")) {
            String title = "Notice";
            LibSBMLUtil.showWarningDialog(title, message, ownerFrame);
        }
    }

    public static final void showWarningDialog(String title, String message, JFrame owner) {
        if (!MainWindow.isIgnorAllCheckAndMessageNotice()) {
            JOptionPane.showMessageDialog(owner, message, title, 1);
        }
    }

    public static final HashMap getSubstanceUnitsOfSpeciesRule() {
        if (substanceUnitsOfSpeciesRule == null) {
            substanceUnitsOfSpeciesRule = new HashMap();
            substanceUnitsOfSpeciesRule.put(substanceUnits2, 1);
            substanceUnitsOfSpeciesRule.put(substanceUnits3, 1);
            substanceUnitsOfSpeciesRule.put(substanceUnits4, 1);
            substanceUnitsOfSpeciesRule.put(substanceUnits5, 1);
            substanceUnitsOfSpeciesRule.put("dimensionless", null);
        }
        return substanceUnitsOfSpeciesRule;
    }

    public static final HashMap getUnitsOfCompartmentRule1() {
        if (unitsOfCompartmentRule1 == null) {
            unitsOfCompartmentRule1 = new HashMap();
            unitsOfCompartmentRule1.put(unitsForCompartmentOf1_2, 1);
            unitsOfCompartmentRule1.put("dimensionless", null);
        }
        return unitsOfCompartmentRule1;
    }

    public static final HashMap getUnitsOfCompartmentRule2() {
        if (unitsOfCompartmentRule2 == null) {
            unitsOfCompartmentRule2 = new HashMap();
            unitsOfCompartmentRule2.put(unitsForCompartmentOf1_2, 2);
            unitsOfCompartmentRule2.put("dimensionless", null);
        }
        return unitsOfCompartmentRule2;
    }

    public static final HashMap getUnitsOfCompartmentRule3() {
        if (unitsOfCompartmentRule3 == null) {
            unitsOfCompartmentRule3 = new HashMap();
            unitsOfCompartmentRule3.put(unitsForCompartmentOf3_2, 1);
            unitsOfCompartmentRule3.put(unitsForCompartmentOf1_2, 3);
            unitsOfCompartmentRule3.put("dimensionless", null);
        }
        return unitsOfCompartmentRule3;
    }

    public static final long getDefaultDimensionOfCompartment() {
        Compartment temp = new Compartment();
        return temp.getSpatialDimensions();
    }

    public static final Point2D.Double calPntInEdgeOfAreaBy1Pnts(Area areaSearching, Point2D.Double posInputedStart, Point2D.Double posInputedEnd, double dOkMinLen, int iCalledTimes) {
        Point2D.Double posStart = null;
        Point2D.Double posEnd = null;
        double dWidthOfInputArea = areaSearching.getBounds2D().getWidth();
        double dHeightOfInputArea = areaSearching.getBounds2D().getHeight();
        double dRofInputArea = Math.sqrt(dWidthOfInputArea * dWidthOfInputArea + dHeightOfInputArea * dHeightOfInputArea);
        if (iCalledTimes < 1 || iCalledTimes > 100) {
            return null;
        }
        int iNextCalledTimes = iCalledTimes + 1;
        if (areaSearching == null) {
            return null;
        }
        if (posInputedEnd == null) {
            return null;
        }
        posEnd = (Point2D.Double)posInputedEnd.clone();
        if (dOkMinLen < 0.01) {
            return null;
        }
        if (dOkMinLen > 2.0) {
            return null;
        }
        Point2D.Double pntInputedAreaMid = new Point2D.Double(areaSearching.getBounds2D().getCenterX(), areaSearching.getBounds2D().getCenterY());
        if (iCalledTimes == 1) {
            posStart = (Point2D.Double)pntInputedAreaMid.clone();
        } else {
            if (posInputedStart == null) {
                return null;
            }
            posStart = (Point2D.Double)posInputedStart.clone();
        }
        if (areaSearching.contains(posStart) && areaSearching.contains(posEnd)) {
            double dDelatX = posEnd.x - posStart.x;
            double dDelatY = posEnd.y - posStart.y;
            double dR = Math.abs(posEnd.distance(posStart));
            if (dRofInputArea < dOkMinLen) {
                return posEnd;
            }
            double dXR = dDelatX / dR;
            double dYR = dDelatY / dR;
            double dNewX = posStart.x + dRofInputArea * dXR;
            double dNewY = posStart.y + dRofInputArea * dYR;
            return LibSBMLUtil.calPntInEdgeOfAreaBy1Pnts(areaSearching, posStart, new Point2D.Double(dNewX, dNewY), dOkMinLen, iNextCalledTimes);
        }
        Point2D.Double pntMidPntOfInputed2Pnt = new Point2D.Double((posStart.x + posEnd.x) / 2.0, (posStart.y + posEnd.y) / 2.0);
        if (areaSearching.contains(pntMidPntOfInputed2Pnt)) {
            return LibSBMLUtil.calPntInEdgeOfAreaBy1Pnts(areaSearching, pntMidPntOfInputed2Pnt, posEnd, dOkMinLen, iNextCalledTimes);
        }
        double dLen11 = pntMidPntOfInputed2Pnt.distance(posEnd);
        if (dLen11 < dOkMinLen) {
            return pntMidPntOfInputed2Pnt;
        }
        return LibSBMLUtil.calPntInEdgeOfAreaBy1Pnts(areaSearching, posStart, pntMidPntOfInputed2Pnt, dOkMinLen, iNextCalledTimes);
    }

    public static final double getAngleByInfoCenterPoint(Object alias, Point2D.Double cntpnt, double agl) {
        Rectangle2D.Double myBounds;
        if (alias == null) {
            return agl;
        }
        if (cntpnt == null) {
            return agl;
        }
        if (alias instanceof ClosedCompartmentAlias) {
            myBounds = ((ClosedCompartmentAlias)alias).getFrameBounds();
        } else if (alias instanceof OpenedCompartmentAlias) {
            myBounds = ((OpenedCompartmentAlias)alias).getBounds();
        } else if (alias instanceof SpeciesAlias) {
            myBounds = ((SpeciesAlias)alias).getBounds();
        } else {
            return agl;
        }
        return LibSBMLUtil.getAngleByInfoCenterPointBounds(myBounds, cntpnt, agl);
    }

    public static final double getAngleByInfoCenterPointBounds(Rectangle2D myBounds, Point2D.Double cntpnt, double agl) {
        Point2D.Double pntFrameCenter = new Point2D.Double(myBounds.getCenterX(), myBounds.getCenterY());
        double r = cntpnt.distance(pntFrameCenter);
        double dX = cntpnt.getX() - pntFrameCenter.getX();
        double dY = cntpnt.getY() - pntFrameCenter.getY();
        if (r == 0.0) {
            return 0.0;
        }
        if (dY == 0.0) {
            if (dX > 0.0) {
                return 0.0;
            }
            return Math.PI;
        }
        if (dX == 0.0) {
            if (dY > 0.0) {
                return 1.5707963267948966;
            }
            return 4.71238898038469;
        }
        if (dX > 0.0 && dY > 0.0) {
            return Math.asin(dY / r);
        }
        if (dX < 0.0 && dY > 0.0) {
            dX = -dX;
            double angI = Math.asin(dY / r);
            return Math.PI - angI;
        }
        if (dX < 0.0 && dY < 0.0) {
            dX = -dX;
            dY = -dY;
            double angI = Math.asin(dY / r);
            return angI + Math.PI;
        }
        if (dX > 0.0 && dY < 0.0) {
            dY = -dY;
            double angI = Math.asin(dY / r);
            return -angI + Math.PI * 2;
        }
        return agl;
    }

    public static final double changetoStandandAngle(double agl) {
        if (agl < 0.0) {
            return LibSBMLUtil.changetoStandandAngle(agl + Math.PI * 2);
        }
        if (agl >= Math.PI * 2) {
            return LibSBMLUtil.changetoStandandAngle(agl - Math.PI * 2);
        }
        return agl;
    }

    public static final void updateContainParentForComplex(GElement copy) {
        ComplexSpeciesAlias complexSpeciesAlias;
        Vector contains;
        if (copy == null) {
            return;
        }
        if (copy instanceof ComplexSpeciesAlias && (contains = (complexSpeciesAlias = (ComplexSpeciesAlias)copy).getTargets()) != null) {
            int con = 0;
            while (con < contains.size()) {
                LibSBMLUtil.updateInfoParent((GElement)contains.elementAt(con));
                ++con;
            }
        }
    }

    public static final void updateInfoParent(GElement copy) {
        OpenedCompartmentAlias openedCompartmentAlias;
        if (copy == null) {
            return;
        }
        if (copy instanceof SpeciesAlias) {
            SpeciesAlias speciesAlias = (SpeciesAlias)copy;
            if (speciesAlias.getInfoBox() != null) {
                speciesAlias.getInfoBox().setInfoParent(speciesAlias);
            }
            if (copy instanceof ComplexSpeciesAlias) {
                LibSBMLUtil.updateContainParentForComplex(copy);
            }
        } else if (copy instanceof ClosedCompartmentAlias) {
            ClosedCompartmentAlias closedCompartmentAlias = (ClosedCompartmentAlias)copy;
            if (closedCompartmentAlias.getInfoBox() != null) {
                closedCompartmentAlias.getInfoBox().setInfoParent(closedCompartmentAlias);
            }
        } else if (copy instanceof OpenedCompartmentAlias && (openedCompartmentAlias = (OpenedCompartmentAlias)copy).getInfoBox() != null) {
            openedCompartmentAlias.getInfoBox().setInfoParent(openedCompartmentAlias);
        }
    }

    public static final boolean canShowUnitInfoAction(Object object) {
        boolean canShow = false;
        if (object == null) {
            return canShow;
        }
        if (object instanceof SpeciesSymbol && !(object instanceof Degraded) && !(object instanceof Phenotype)) {
            canShow = true;
        }
        return canShow;
    }

    public static final String getSpeciesReferenceReactantKey(String reactionId, long index) {
        if (reactionId == null) {
            return "";
        }
        return String.valueOf(reactionId) + strSpeciesReferenceReactantBuffer + index;
    }

    public static final String getSpeciesReferenceProductKey(String reactionId, long index) {
        if (reactionId == null) {
            return "";
        }
        return String.valueOf(reactionId) + strSpeciesReferenceProductBuffer + index;
    }

    public static final String getSpeciesReferenceModifierKey(String reactionId, long index) {
        if (reactionId == null) {
            return "";
        }
        return String.valueOf(reactionId) + strModifierSpeciesReferenceBuffer + index;
    }

    public static void checkTheNumberOfArgumentsForFunctionDefinition(ASTNode math, Model model, FunctionDefinition newestMe) throws Exception {
        if (!LibSBMLUtil.privateCheckTheNumberOfArgumentsForFunctionDefinition(math, model, newestMe)) {
            throw new Exception(Erro_TheNumberOfArgumentsForFunctionDefinition);
        }
    }

    private static boolean privateCheckTheNumberOfArgumentsForFunctionDefinition(ASTNode math, Model model, FunctionDefinition newestMe) {
        String funcId;
        boolean checkResult = true;
        if (math == null || model == null) {
            return checkResult;
        }
        int count = (int)math.getNumChildren();
        if (math.isFunction() && (funcId = math.getName()) != null && !funcId.equals("")) {
            try {
                long num2;
                FunctionDefinition temp;
                FunctionDefinition functionDefinition = model.getListOfFunctionDefinitions().get(funcId);
                if (newestMe != null && funcId.equals((temp = newestMe).getId())) {
                    functionDefinition = temp;
                }
                if (functionDefinition != null && (long)count != (num2 = functionDefinition.getNumArguments())) {
                    return false;
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (count > 0) {
            int i = 0;
            while (i < count) {
                ASTNode child = math.getChild((long)i);
                if (child.isFunction() && !(checkResult = LibSBMLUtil.privateCheckTheNumberOfArgumentsForFunctionDefinition(child, model, newestMe))) {
                    return checkResult;
                }
                ++i;
            }
        }
        return checkResult;
    }

    public static final boolean containsNamedASTNode(ASTNode node, String name) {
        ASTNode target = LibSBMLUtil.getNamedASTNode(node, strNameASTNodePattern, name);
        return target != null;
    }

    public static final ASTNode getNamedASTNode(ASTNode node, String pattern, String name) {
        String strnameTemp;
        if (node == null) {
            return null;
        }
        if (name == null || "".equals(name)) {
            return null;
        }
        if (strNameASTNodePattern.equals(pattern) && node.isName() && name.equals(strnameTemp = node.getName())) {
            return node;
        }
        int count = (int)node.getNumChildren();
        if (count > 0) {
            int i = 0;
            while (i < count) {
                ASTNode child = node.getChild((long)i);
                ASTNode target = LibSBMLUtil.getNamedASTNode(child, pattern, name);
                if (target != null) {
                    return target;
                }
                ++i;
            }
        }
        return null;
    }

    public static XMLNode removeCellDesignerAnnotation(XMLNode annotation) {
        XMLNode newAnnotation = new XMLNode(new XMLTriple("annotation"), new XMLAttributes());
        if (annotation == null || annotation.getNumChildren() == 0L) {
            return null;
        }
        int i = 0;
        while ((long)i < annotation.getNumChildren()) {
            XMLNode topLevelElement = annotation.getChild((long)i);
            if (!topLevelElement.getPrefix().equals(TAG_CELLDESIGNER_PREFIX)) {
                newAnnotation.addChild(topLevelElement);
            }
            ++i;
        }
        return newAnnotation;
    }

    public static boolean checkDuplicatedMetaId(String metaId, Model targetModel) {
        ArrayList<Object> arrayListOf = new ArrayList<Object>();
        arrayListOf.add(targetModel.getListOfFunctionDefinitions());
        arrayListOf.add(targetModel.getListOfUnitDefinitions());
        arrayListOf.add(targetModel.getListOfCompartmentTypes());
        arrayListOf.add(targetModel.getListOfCompartments());
        arrayListOf.add(targetModel.getListOfSpeciesTypes());
        arrayListOf.add(targetModel.getListOfSpecies());
        arrayListOf.add(targetModel.getListOfParameters());
        arrayListOf.add(targetModel.getListOfInitialAssignments());
        arrayListOf.add(targetModel.getListOfRules());
        arrayListOf.add(targetModel.getListOfConstraints());
        arrayListOf.add(targetModel.getListOfReactions());
        arrayListOf.add(targetModel.getListOfEvents());
        Iterator it = arrayListOf.iterator();
        while (it.hasNext()) {
            if (!LibSBMLUtil.checkDuplicatedMetaIdByList(metaId, (ListOf)it.next())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkDuplicatedMetaIdByList(String metaId, ListOf lof) {
        int i = 0;
        while ((long)i < lof.size()) {
            KineticLaw kl;
            SBase sb = lof.get((long)i);
            if (sb != null && sb.getMetaId().equals(metaId)) {
                return true;
            }
            if (sb instanceof Reaction && (kl = ((Reaction)sb).getKineticLaw()) != null && kl.getMetaId().equals(metaId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final void changeLocalParameterAnnoReactionID(Parameter base, String newID) {
        try {
            SId.check(newID);
        }
        catch (Exception myErr) {
            return;
        }
        if (LibSBMLUtil.havaReactionIDInfomation(base)) {
            String oldAnno = base.getAnnotationString();
            String newAnno = oldAnno.replaceAll(base.getAnnotation().getChild(0L).getChild(0L).toString(), newID);
            XMLNode annt = XMLNode.convertStringToXMLNode((String)newAnno);
            base.setAnnotation(annt);
            base.setAnnotation(newAnno);
        }
    }

    public static final void changetoAstTimeNode(ASTNode node) {
        int count;
        if (node == null) {
            return;
        }
        if (node.isName()) {
            String strnameTemp = node.getName().trim();
            if (strMember5.equals(strnameTemp)) {
                if (!hasGlobalParamTime && !hasLocalParamTime) {
                    node.setType(261);
                    return;
                }
            } else if ("t".equals(strnameTemp) && !hasGlobalParamT && !hasLocalParamT) {
                node.setType(261);
                return;
            }
        }
        if ((count = (int)node.getNumChildren()) > 0) {
            int i = 0;
            while (i < count) {
                LibSBMLUtil.changetoAstTimeNode(node.getChild((long)i));
                ++i;
            }
        }
    }

    public static final boolean hasParameter(Model model, String pid) {
        if (model.getParameter(pid) != null) {
            return true;
        }
        ListOfReactions reactions = model.getListOfReactions();
        if (reactions != null) {
            int i = 0;
            while ((long)i < reactions.size()) {
                Reaction reaction = reactions.get((long)i);
                if (reaction.getKineticLaw() != null && reaction.getKineticLaw().getParameter(pid) != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static final void changetoAstTimeNode(Model model) {
        ListOfReactions reactions;
        int j;
        ListOfEvents events;
        ListOfFunctionDefinitions functionDefinitions;
        ListOfInitialAssignments initialAssignments;
        ListOfConstraints constraints;
        ListOfRules rules;
        if (model.getParameter(strMember5) != null) {
            hasGlobalParamTime = true;
            if (model.getParameter(strMember5).getUnits().equals(strMember5)) {
                isGlobalParamUnitOfTime = true;
            }
        }
        if (model.getParameter("t") != null) {
            hasGlobalParamT = true;
            if (model.getParameter("t").getUnits().equals(strMember5)) {
                isGlobalParamUnitOfT = true;
            }
        }
        if ((rules = model.getListOfRules()) != null) {
            int i = 0;
            while ((long)i < rules.size()) {
                Rule rule = rules.get((long)i);
                LibSBMLUtil.changetoAstTimeNode(rule.getMath());
                ++i;
            }
        }
        if ((constraints = model.getListOfConstraints()) != null) {
            int i = 0;
            while ((long)i < constraints.size()) {
                Constraint constraint = constraints.get((long)i);
                LibSBMLUtil.changetoAstTimeNode(constraint.getMath());
                ++i;
            }
        }
        if ((initialAssignments = model.getListOfInitialAssignments()) != null) {
            int i = 0;
            while ((long)i < initialAssignments.size()) {
                InitialAssignment initialAssignment = initialAssignments.get((long)i);
                LibSBMLUtil.changetoAstTimeNode(initialAssignment.getMath());
                ++i;
            }
        }
        if ((functionDefinitions = model.getListOfFunctionDefinitions()) != null) {
            int i = 0;
            while ((long)i < functionDefinitions.size()) {
                FunctionDefinition functionDefinition = functionDefinitions.get((long)i);
                LibSBMLUtil.changetoAstTimeNode(functionDefinition.getMath());
                ++i;
            }
        }
        if ((events = model.getListOfEvents()) != null) {
            int i = 0;
            while ((long)i < events.size()) {
                ListOfEventAssignments eventAssignments;
                Event event = events.get((long)i);
                if (event.getDelay() != null) {
                    LibSBMLUtil.changetoAstTimeNode(event.getDelay().getMath());
                }
                if (event.getTrigger() != null) {
                    LibSBMLUtil.changetoAstTimeNode(event.getTrigger().getMath());
                }
                if ((eventAssignments = event.getListOfEventAssignments()) != null) {
                    j = 0;
                    while ((long)j < eventAssignments.size()) {
                        EventAssignment eventAssignment = eventAssignments.get((long)j);
                        LibSBMLUtil.changetoAstTimeNode(eventAssignment.getMath());
                        ++j;
                    }
                }
                ++i;
            }
        }
        if ((reactions = model.getListOfReactions()) != null) {
            int i = 0;
            while ((long)i < reactions.size()) {
                Reaction reaction = reactions.get((long)i);
                if (reaction.getKineticLaw() != null) {
                    if (reaction.getKineticLaw().getParameter(strMember5) != null) {
                        hasLocalParamTime = true;
                        if (reaction.getKineticLaw().getParameter(strMember5).getUnits().equals(strMember5)) {
                            isLocalParamUnitOfTime = true;
                        }
                    }
                    if (reaction.getKineticLaw().getParameter("t") != null) {
                        hasLocalParamT = true;
                        if (reaction.getKineticLaw().getParameter("t").getUnits().equals(strMember5)) {
                            isLocalParamUnitOfT = true;
                        }
                    }
                    LibSBMLUtil.changetoAstTimeNode(reaction.getKineticLaw().getMath());
                    hasLocalParamTime = false;
                    hasLocalParamT = false;
                    isLocalParamUnitOfTime = false;
                    isLocalParamUnitOfT = false;
                }
                j = 0;
                while ((long)j < reaction.getNumReactants()) {
                    if (reaction.getReactant((long)j).getStoichiometryMath() != null) {
                        LibSBMLUtil.changetoAstTimeNode(reaction.getReactant((long)j).getStoichiometryMath().getMath());
                    }
                    ++j;
                }
                j = 0;
                while ((long)j < reaction.getNumProducts()) {
                    if (reaction.getProduct((long)j).getStoichiometryMath() != null) {
                        LibSBMLUtil.changetoAstTimeNode(reaction.getProduct((long)j).getStoichiometryMath().getMath());
                    }
                    ++j;
                }
                ++i;
            }
        }
        hasGlobalParamTime = false;
        hasGlobalParamT = false;
        isGlobalParamUnitOfTime = false;
        isGlobalParamUnitOfT = false;
    }
}

