/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.util.Vector;
import javax.swing.JTextField;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.sbml.util.KineticLawDialog;
import jp.sbi.sbml.util.KineticLawPredefinedFunctionsDialog;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;

public class KineticLawPredefinedFunctionsManager {
    public static final String NON_PREDEFINED_FUNCTION = "NonPredefinedFunction";
    public static final String MASS_ACTION_KINETICS = "Mass_Action_Kinetics";
    public static final String IRREVERSIBLE_SIMPLE_MICHAELIS_MENTEN = "Irreversible_Simple_Michaelis-Menten";
    public static final String UNI_UNI_REVERSIBLE = "Uni-Uni_Reversible_Simple_Michaelis-Menten";
    public static final String UNI_UNI_REVERSIBLE_WITH = "Uni-Uni_Reversible_Simple_Michaelis-Menten_with_Haldane_adjustment";
    public static final String ISO_UNI_UNI = "Iso_Uni-Uni";
    public static final String HILL_KINETICS = "Hill_Kinetics";
    public static final String REVERSIBLE_HILL_KINETICS = "Reversible_Hill_Kinetics";
    public static final String REVERSIBLE_HILL_KINETICS_WITH_ONE = "Reversible_Hill_Kinetics_with_One_Modifiers";
    public static final String REVERSIBLE_HILL_KINETICS_WITH_TWO = "Reversible_Hill_Kinetics_with_Two_Modifiers";
    private static final int IRREVERSIBLE_SIMPLE_MICHAELIS_MENTEN_LENGTH = 3;
    private static final String K = "k";
    private static final String V = "v";

    public static String[] getParameterStrings(String functionName, Reaction target) {
        if (functionName.equals(MASS_ACTION_KINETICS)) {
            String[] obj = new String[(int)(target.getNumReactants() + 1L)];
            int i = 0;
            while ((long)i < target.getNumReactants()) {
                obj[i] = "S" + (i + 1);
                ++i;
            }
            obj[obj.length - 1] = K;
            return obj;
        }
        if (functionName.equals(IRREVERSIBLE_SIMPLE_MICHAELIS_MENTEN)) {
            String[] obj = new String[]{"S", "V", "K"};
            return obj;
        }
        return null;
    }

    public static void setDefaultData(String functionName, Reaction target, Vector listOfTextField) {
        if (functionName.equals(MASS_ACTION_KINETICS)) {
            int substrateNum = (int)target.getNumReactants();
            int i = 0;
            while (i < substrateNum) {
                JTextField f = (JTextField)listOfTextField.get(i);
                f.setText(target.getReactant((long)i).getSpecies());
                ++i;
            }
        } else if (functionName.equals(IRREVERSIBLE_SIMPLE_MICHAELIS_MENTEN)) {
            JTextField f = (JTextField)listOfTextField.get(0);
            f.setText(target.getReactant(0L).getSpecies());
        }
    }

    public static String createMath(KineticLawPredefinedFunctionsDialog parent, String functionName, Reaction target, Vector listOfTextField) {
        StringBuffer buf = new StringBuffer();
        if (functionName.equals(MASS_ACTION_KINETICS)) {
            int substrateNum = (int)target.getNumReactants();
            int i = 0;
            while (i < substrateNum) {
                JTextField f = (JTextField)listOfTextField.get(i);
                String text = f.getText();
                buf.append(text);
                buf.append("*");
                ++i;
            }
            JTextField paramK = (JTextField)listOfTextField.get(substrateNum);
            Parameter newParameter = KineticLawPredefinedFunctionsManager.createNewParameter(parent, target, paramK, K);
            parent.getKineticLawDialog().updateParameterPanel(newParameter);
            buf.append(newParameter.getId());
        } else if (functionName.equals(IRREVERSIBLE_SIMPLE_MICHAELIS_MENTEN)) {
            JTextField s = (JTextField)listOfTextField.get(0);
            JTextField v = (JTextField)listOfTextField.get(1);
            JTextField k = (JTextField)listOfTextField.get(2);
            String textS = s.getText();
            Parameter newParameterV = KineticLawPredefinedFunctionsManager.createNewParameter(parent, target, v, V);
            Parameter newParameterK = KineticLawPredefinedFunctionsManager.createNewParameter(parent, target, k, K);
            parent.getKineticLawDialog().updateParameterPanel(newParameterV);
            String textV = newParameterV.getId();
            parent.getKineticLawDialog().updateParameterPanel(newParameterK);
            String textK = newParameterK.getId();
            buf.append("(");
            buf.append(textV);
            buf.append("*");
            buf.append(textS);
            buf.append(")");
            buf.append("/");
            buf.append("(");
            buf.append(textK);
            buf.append("+");
            buf.append(textS);
            buf.append(")");
        }
        return buf.toString();
    }

    private static String createNewParameterID(KineticLawPredefinedFunctionsDialog parent, Reaction reaction, String kind) {
        int parameterID = 1;
        Model model = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel();
        KineticLawDialog kwDialog = parent.getKineticLawDialog();
        String id = "";
        boolean flg = false;
        while (!flg) {
            id = String.valueOf(kind) + parameterID++;
            boolean isExist = false;
            if (kwDialog.isExistParameterID(id)) {
                isExist = true;
            }
            if (isExist || model.getSpecies(id) != null || model.getReaction(id) != null || model.getCompartment(id) != null) continue;
            flg = true;
            break;
        }
        return id;
    }

    private static Parameter createNewParameter(KineticLawPredefinedFunctionsDialog parent, Reaction reaction, JTextField paramK, String kind) {
        Parameter parameter = new Parameter();
        parameter.setId(KineticLawPredefinedFunctionsManager.createNewParameterID(parent, reaction, kind));
        parameter.setName(parameter.getId());
        try {
            parameter.setValue(Double.parseDouble(paramK.getText()));
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("Invalid value.");
        }
        parameter.setAnnotation(LibSBMLUtil.addEnclosedAnnotationTags(reaction.getId()));
        return parameter;
    }

    private static void debugPrint(String[] args) {
        StringBuffer buf = new StringBuffer("args = [");
        int i = 0;
        while (i < args.length) {
            buf.append(args[i]);
            if (i + 1 < args.length) {
                buf.append(",");
            }
            ++i;
        }
        buf.append("]");
        System.out.println(buf.toString());
    }
}

