/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jp.sbi.sbml.util.ImagePanel;
import jp.sbi.sbml.util.KineticLawDialog;
import jp.sbi.sbml.util.KineticLawDialogFunctionPanel;
import jp.sbi.sbml.util.KineticLawPredefinedFunctionsManager;
import jp.sbi.sbml.util.ReactionDialog;
import org.sbml.libsbml.Reaction;

public class KineticLawPredefinedFunctionsDialog
extends JDialog {
    private KineticLawDialog parentDialog;
    private KineticLawDialogFunctionPanel parentPanel;
    private JButton buttonOK;
    private JButton buttonCancel;
    private final int SPACE = 10;
    private ImagePanel imagePanel;
    private JPanel detaPanel;
    private JPanel buttonPanel;
    private Vector listOfTextField;
    private Reaction target;

    public KineticLawDialog getKineticLawDialog() {
        return this.parentDialog;
    }

    public KineticLawPredefinedFunctionsDialog(KineticLawDialog parentDialog, KineticLawDialogFunctionPanel parentPanel) {
        super(parentDialog);
        this.setModal(true);
        this.parentDialog = parentDialog;
        this.parentPanel = parentPanel;
        this.init();
    }

    private void init() {
        this.createImagePanel();
        this.createButtonPanel();
        this.parentPanel.updateJListView();
    }

    private void createImagePanel() {
        this.imagePanel = new ImagePanel(230, 140);
        this.imagePanel.setBorder(new TitledBorder("Formula"));
        this.imagePanel.setPreferredSize(new Dimension(130, 130));
        this.imagePanel.setBackground(Color.white);
        this.getContentPane().add("North", this.imagePanel);
    }

    private void createButtonPanel() {
        if (this.buttonPanel != null) {
            this.remove(this.buttonPanel);
        }
        this.buttonPanel = new JPanel();
        this.buttonOK = new JButton("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                KineticLawPredefinedFunctionsDialog.this.buttonOK_actionPerformed();
            }
        });
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                KineticLawPredefinedFunctionsDialog.this.buttonCancel_actionPerformed();
            }
        });
        this.buttonPanel.add(this.buttonOK);
        this.buttonPanel.add(this.buttonCancel);
        this.getContentPane().add("South", this.buttonPanel);
    }

    public void updateDisplay(String imagePath) {
        this.updateImage(imagePath);
        this.updateInputPanel();
        this.toFront();
    }

    private void updateInputPanel() {
        ReactionDialog rr = (ReactionDialog)this.parentDialog.getParent();
        this.target = (Reaction)rr.getObject();
        String[] params = KineticLawPredefinedFunctionsManager.getParameterStrings(this.parentPanel.getSelectedFunction(), this.target);
        if (params == null) {
            return;
        }
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.detaPanel != null) {
            this.remove(this.detaPanel);
        }
        this.detaPanel = new JPanel();
        this.detaPanel.setLayout(layout);
        this.listOfTextField = new Vector();
        int i = 0;
        while (i < params.length) {
            String name = params[i];
            JLabel label = new JLabel(name);
            gbc.gridx = 0;
            gbc.gridy = i;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 20, 0, 0);
            layout.setConstraints(label, gbc);
            this.detaPanel.add(label);
            JTextField field = new JTextField();
            gbc.gridx = 1;
            gbc.gridy = i++;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 3.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(1, 0, 0, 5);
            layout.setConstraints(field, gbc);
            this.detaPanel.add(field);
            this.listOfTextField.add(field);
        }
        this.getContentPane().add("Center", this.detaPanel);
        this.setDefaultData(this.parentPanel.getSelectedFunction(), this.target, this.listOfTextField);
        this.createButtonPanel();
        this.setSize(240, 200 + 30 * params.length);
        this.validate();
    }

    private void setDefaultData(String functionName, Reaction reaction, Vector listOfTextField) {
        KineticLawPredefinedFunctionsManager.setDefaultData(functionName, reaction, listOfTextField);
    }

    private void updateImage(String imagePath) {
        this.imagePanel.setImage(imagePath);
        this.imagePanel.updateUI();
    }

    private void createMath() {
        String mathString = KineticLawPredefinedFunctionsManager.createMath(this, this.parentPanel.getSelectedFunction(), this.target, this.listOfTextField);
        this.parentPanel.setBeforeSelectedFunction();
        this.parentDialog.getMathEditPanel().getTextField().setText(mathString);
        this.parentDialog.getMathEditPanel().setDisplay();
    }

    private void buttonOK_actionPerformed() {
        try {
            int i = 0;
            while (i < this.listOfTextField.size()) {
                JTextField f = (JTextField)this.listOfTextField.get(i);
                if (f.getText().equals("")) {
                    return;
                }
                ++i;
            }
            this.createMath();
            this.setVisible(false);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
        }
    }

    private void buttonCancel_actionPerformed() {
        this.parentPanel.setListSelected(this.parentPanel.getBeforeSelectedFunction());
        this.setVisible(false);
    }
}

