/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.util.Vector;
import jp.sbi.sbml.util.Operator;

public class KineticLawFormulaEvaluator {
    private Operator[] operators;

    public KineticLawFormulaEvaluator(String formula) throws Exception {
        this.initOperators();
        Node node = new Node(formula);
        this.examine(node);
    }

    private void examine(Node node) throws Exception {
        String str = node.getString();
        if (node.hasChild()) {
            if (!node.hasOperator()) {
                throw new Exception();
            }
            if (node.getOperator().getKind() == 1) {
                throw new Exception();
            }
            if (node.getLeft() == null || node.getRight() == null) {
                throw new Exception();
            }
            this.examine(node.getLeft());
            this.examine(node.getRight());
        } else if (node.hasOperator()) {
            if (node.getOperator().getKind() == 2) {
                throw new Exception();
            }
            Operator[] operators = this.getOperators();
            String strOperator = node.getOperator().getOperator();
            int i = 5;
            while (i <= 54) {
                if (strOperator.equals(operators[i].getOperator())) {
                    String params = str.substring(strOperator.length());
                    params = node.removeBrackets(params);
                    Vector<Integer> commaVector = new Vector<Integer>();
                    int brackets = 0;
                    int j = 0;
                    while (j < params.length()) {
                        char c = params.charAt(j);
                        if (c == '(') {
                            ++brackets;
                        } else if (c == ')') {
                            --brackets;
                        } else if (c == ',' && brackets == 0) {
                            commaVector.add(new Integer(j));
                        }
                        ++j;
                    }
                    int count = commaVector.size() + 1;
                    if (i >= 5 && i <= 18 ? count != 1 : (i == 19 ? count != 2 : (i == 20 ? count != 3 : (i >= 21 && i <= 23 ? count != 4 : (i >= 24 && i <= 28 ? count != 5 : (i >= 29 && i <= 32 ? count != 6 : (i >= 33 && i <= 37 ? count != 7 : (i >= 38 && i <= 42 ? count != 8 : (i >= 43 && i <= 44 ? count != 9 : (i >= 45 && i <= 48 ? count != 10 : (i == 49 ? count != 13 : (i == 50 ? count != 14 : (i == 51 ? count != 18 : (i == 52 ? count < 4 : (i == 53 || i == 54) && count < 2)))))))))))))) {
                        throw new Exception();
                    }
                    int startIndex = 0;
                    int k = 0;
                    while (k < count) {
                        String param;
                        if (k == count - 1) {
                            param = params.substring(startIndex);
                        } else {
                            int index = (Integer)commaVector.get(k);
                            param = params.substring(startIndex, index);
                            startIndex = index + 1;
                        }
                        if (param == null || param.equals("")) {
                            throw new Exception();
                        }
                        Node paramNode = new Node(node, param);
                        this.examine(paramNode);
                        ++k;
                    }
                }
                ++i;
            }
        } else {
            if (str == null || str.equals("")) {
                if (node.hasParent()) {
                    throw new Exception();
                }
                return;
            }
            int l = 0;
            while (l < str.length()) {
                char c = str.charAt(l);
                if (!(c <= 'z' && c >= 'a' || c <= 'Z' && c >= 'A' || c <= '9' && c >= '0' || c == '_' || c == '.')) {
                    throw new Exception();
                }
                if (l == 0) {
                    if (c >= '0' && c <= '9' || c == '.') {
                        Double.parseDouble(str);
                        break;
                    }
                } else if (c == '.') {
                    throw new Exception();
                }
                ++l;
            }
        }
    }

    private void initOperators() {
        this.operators = new Operator[55];
        this.operators[0] = new Operator("+", 1, 2, 0);
        this.operators[1] = new Operator("-", 1, 2, 0);
        this.operators[2] = new Operator("*", 1, 2, 1);
        this.operators[3] = new Operator("/", 1, 2, 1);
        this.operators[4] = new Operator("^", 1, 2, 1);
        this.operators[5] = new Operator("abs", 3, 1, 2);
        this.operators[6] = new Operator("acos", 4, 1, 2);
        this.operators[7] = new Operator("asin", 4, 1, 2);
        this.operators[8] = new Operator("atan", 4, 1, 2);
        this.operators[9] = new Operator("ceil", 4, 1, 2);
        this.operators[10] = new Operator("cos", 3, 1, 2);
        this.operators[11] = new Operator("exp", 3, 1, 2);
        this.operators[12] = new Operator("floor", 5, 1, 2);
        this.operators[13] = new Operator("log10", 5, 1, 2);
        this.operators[14] = new Operator("log", 3, 1, 2);
        this.operators[15] = new Operator("sqrt", 4, 1, 2);
        this.operators[16] = new Operator("sqr", 3, 1, 2);
        this.operators[17] = new Operator("sin", 3, 1, 2);
        this.operators[18] = new Operator("tan", 3, 1, 2);
        this.operators[19] = new Operator("pow", 3, 1, 2);
        this.operators[20] = new Operator("uui", 3, 1, 2);
        this.operators[21] = new Operator("hilli", 5, 1, 2);
        this.operators[22] = new Operator("usii", 4, 1, 2);
        this.operators[23] = new Operator("uai", 3, 1, 2);
        this.operators[24] = new Operator("ucii", 4, 1, 2);
        this.operators[25] = new Operator("unii", 4, 1, 2);
        this.operators[26] = new Operator("uuci", 4, 1, 2);
        this.operators[27] = new Operator("uaii", 4, 1, 2);
        this.operators[28] = new Operator("ucti", 4, 1, 2);
        this.operators[29] = new Operator("uur", 3, 1, 2);
        this.operators[30] = new Operator("uuhr", 4, 1, 2);
        this.operators[31] = new Operator("umi", 3, 1, 2);
        this.operators[32] = new Operator("umai", 4, 1, 2);
        this.operators[33] = new Operator("isouur", 6, 1, 2);
        this.operators[34] = new Operator("hillr", 5, 1, 2);
        this.operators[35] = new Operator("usir", 4, 1, 2);
        this.operators[36] = new Operator("uhmi", 4, 1, 2);
        this.operators[37] = new Operator("ualii", 5, 1, 2);
        this.operators[38] = new Operator("ucir", 4, 1, 2);
        this.operators[39] = new Operator("unir", 4, 1, 2);
        this.operators[40] = new Operator("uucr", 4, 1, 2);
        this.operators[41] = new Operator("uar", 3, 1, 2);
        this.operators[42] = new Operator("uctr", 4, 1, 2);
        this.operators[43] = new Operator("umr", 3, 1, 2);
        this.operators[44] = new Operator("umar", 4, 1, 2);
        this.operators[45] = new Operator("hillmr", 6, 1, 2);
        this.operators[46] = new Operator("uhmr", 4, 1, 2);
        this.operators[47] = new Operator("ordubr", 6, 1, 2);
        this.operators[48] = new Operator("ordbur", 6, 1, 2);
        this.operators[49] = new Operator("ppbr", 4, 1, 2);
        this.operators[50] = new Operator("ordbbr", 6, 1, 2);
        this.operators[51] = new Operator("hillmmr", 7, 1, 2);
        this.operators[52] = new Operator("massr", 5, 1, 2);
        this.operators[53] = new Operator("massi", 5, 1, 2);
        this.operators[54] = new Operator("mass", 4, 1, 2);
    }

    protected Operator[] getOperators() {
        return this.operators;
    }

    private class Node {
        private String nodeString = null;
        private Operator nodeOperator = null;
        private Node nodeLeft = null;
        private Node nodeRight = null;
        private Node nodeParent = null;

        protected Node(String str) throws Exception {
            this.init(null, str);
        }

        protected Node(Node parent, String str) throws Exception {
            this.init(parent, str);
        }

        private void init(Node parent, String str) throws Exception {
            if (this.checkBrackets(str) != 0) {
                throw new Exception();
            }
            str = this.removeSpaces(str);
            str = this.removeBrackets(str);
            str = this.addZeroFirst(str);
            this.nodeParent = parent;
            this.nodeString = str;
            int brackets = 0;
            int startOperator = 0;
            int i = 0;
            while (i < str.length()) {
                Operator operator;
                if (str.charAt(i) == '(') {
                    ++brackets;
                } else if (str.charAt(i) == ')') {
                    --brackets;
                } else if (brackets == 0 && (operator = this.getOperator(this.nodeString, i)) != null) {
                    i += operator.getLength() - 1;
                    if (this.nodeOperator == null || this.nodeOperator.getPriority() >= operator.getPriority()) {
                        this.nodeOperator = operator;
                        startOperator = i;
                    }
                }
                ++i;
            }
            if (this.nodeOperator != null) {
                if (startOperator == 0 && this.nodeOperator.getKind() == 1) {
                    this.nodeLeft = null;
                    this.nodeRight = null;
                } else if (startOperator > 0 && this.nodeOperator.getKind() == 2) {
                    if (!str.substring(0, startOperator).equals("")) {
                        this.nodeLeft = new Node(this, str.substring(0, startOperator));
                    }
                    if (!str.substring(startOperator + this.nodeOperator.getOperator().length()).equals("")) {
                        this.nodeRight = new Node(this, str.substring(startOperator + this.nodeOperator.getOperator().length()));
                    }
                }
            }
        }

        private Operator getOperator(String str, int start) {
            Operator[] operators = KineticLawFormulaEvaluator.this.getOperators();
            String temp = str.substring(start);
            int i = 0;
            while (i < operators.length) {
                if (temp.startsWith(operators[i].getOperator())) {
                    return operators[i];
                }
                ++i;
            }
            return null;
        }

        private int checkBrackets(String str) {
            int strLength = str.length();
            int bracket = 0;
            int i = 0;
            while (i < strLength) {
                if (str.charAt(i) == '(' && bracket >= 0) {
                    ++bracket;
                } else if (str.charAt(i) == ')') {
                    --bracket;
                }
                ++i;
            }
            return bracket;
        }

        private String addZeroFirst(String str) {
            char c;
            if (str.length() > 0 && ((c = str.charAt(0)) == '+' || c == '-')) {
                return "0" + str;
            }
            return str;
        }

        boolean hasChild() {
            return this.nodeLeft != null || this.nodeRight != null;
        }

        boolean hasOperator() {
            return this.nodeOperator != null;
        }

        boolean hasParent() {
            return this.nodeParent != null;
        }

        Node getLeft() {
            return this.nodeLeft;
        }

        Node getRight() {
            return this.nodeRight;
        }

        Operator getOperator() {
            return this.nodeOperator;
        }

        Node getParent() {
            return this.nodeParent;
        }

        String getString() {
            return this.nodeString;
        }

        String removeBrackets(String str) {
            String res = str;
            if (str.length() > 2 && res.startsWith("(") && res.endsWith(")") && this.checkBrackets(str.substring(1, str.length() - 1)) == 0) {
                res = res.substring(1, res.length() - 1);
            }
            if (res != str) {
                return this.removeBrackets(res);
            }
            return res;
        }

        private String removeSpaces(String str) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (c != ' ') {
                    buf.append(c);
                }
                ++i;
            }
            return buf.toString();
        }
    }
}

