/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.sbi.sbml.util.ImagePanel;
import jp.sbi.sbml.util.KineticLawDialog;
import jp.sbi.sbml.util.KineticLawPredefinedFunctionsDialog;

public class KineticLawDialogFunctionPanel
extends JPanel {
    private KineticLawDialog parent;
    private String[] listData = new String[]{"NonPredefinedFunction", "Mass_Action_Kinetics", "Irreversible_Simple_Michaelis-Menten"};
    private JScrollPane scroll;
    private ImagePanel imagePanel;
    private JList list;
    private String beforeSelected;
    private String beforeSelectedFunction;
    private KineticLawPredefinedFunctionsDialog functionDialog;
    private JToggleButton toggleSelectedFunction;
    public static final String L_DISTANCE = "                ";
    public static final String R_DISTANCE = " ";

    public KineticLawDialogFunctionPanel(KineticLawDialog parent) {
        this.parent = parent;
        this.init();
    }

    public KineticLawDialogFunctionPanel(KineticLawDialog parent, JToggleButton toggleSelectedFunction) {
        this.parent = parent;
        this.toggleSelectedFunction = toggleSelectedFunction;
        this.beforeSelectedFunction = "";
        this.setSize(390, 130);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("                Predefined Functions "));
        this.add(this.toggleSelectedFunction);
        this.createImagePanel();
        this.createListPanel();
    }

    public void setPanelVisible(boolean aFlag) {
        this.scroll.setVisible(aFlag);
        this.imagePanel.setVisible(aFlag);
    }

    private void init() {
        this.beforeSelected = "";
        this.beforeSelectedFunction = "";
        this.setSize(390, 130);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("                Predefined Functions "));
        this.createImagePanel();
        this.createListPanel();
    }

    private void createImagePanel() {
        this.imagePanel = new ImagePanel(130, 130);
        this.imagePanel.setPreferredSize(new Dimension(130, 130));
        this.imagePanel.setBackground(Color.white);
        this.add("West", this.imagePanel);
    }

    private void createListPanel() {
        this.scroll = new JScrollPane();
        this.list = new JList<String>(this.listData);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                KineticLawDialogFunctionPanel.this.list_valueChanged(arg0);
            }
        });
        this.list.setSelectionForeground(Color.white);
        this.list.setSelectionBackground(Color.black);
        this.scroll.getViewport().add(this.list);
        this.add("Center", this.scroll);
    }

    private void list_valueChanged(ListSelectionEvent arg0) {
        if (this.parent.editingSBase == null) {
            return;
        }
        String selectedValue = (String)((JList)arg0.getSource()).getSelectedValue();
        if (selectedValue.equals(this.beforeSelected)) {
            return;
        }
        this.beforeSelected = selectedValue;
        this.updateImage();
        String imagePath = String.valueOf(this.beforeSelected) + ".png";
        if (this.beforeSelected.equals("NonPredefinedFunction")) {
            if (this.functionDialog != null && this.functionDialog.isShowing()) {
                this.functionDialog.setVisible(false);
            }
            this.beforeSelectedFunction = this.beforeSelected;
            return;
        }
        if (this.functionDialog == null) {
            this.functionDialog = new KineticLawPredefinedFunctionsDialog(this.parent, this);
        }
        this.functionDialog.updateDisplay(imagePath);
        if (!this.functionDialog.isShowing()) {
            this.updateJListView();
            this.functionDialog.setVisible(true);
        }
    }

    public void setBeforeSelectedFunction() {
        this.beforeSelectedFunction = this.getSelectedFunction();
    }

    public void setVisibleForFunctionDialog(boolean boo) {
        if (this.functionDialog != null) {
            this.functionDialog.setVisible(boo);
        }
    }

    public void updateJListView() {
        this.list.paintImmediately(0, 0, this.list.getWidth(), this.list.getHeight());
    }

    public void setListSelected(int index) {
        this.beforeSelected = "";
        this.list.setSelectedIndex(index);
    }

    public void setListSelected(String item) {
        int i = 0;
        while (i < this.listData.length) {
            String data = this.listData[i];
            if (data.equals(item)) {
                this.beforeSelected = data;
                this.list.setSelectedIndex(i);
                this.updateImage();
                return;
            }
            ++i;
        }
        this.beforeSelected = this.listData[0];
        this.list.setSelectedIndex(0);
        this.updateImage();
    }

    public String getSelectedFunction() {
        return this.beforeSelected;
    }

    public void updateImage() {
        String imagePath = String.valueOf(this.beforeSelected) + ".png";
        this.imagePanel.setImage(imagePath);
        this.imagePanel.updateUI();
    }

    public String getBeforeSelectedFunction() {
        return this.beforeSelectedFunction;
    }
}

