/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.util.Vector;
import javax.swing.JPanel;
import jp.fric.graphics.draw.GAtom;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GContainerTarget;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GEditable;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GGroup;
import jp.fric.graphics.draw.GGroupTarget;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GResizable;
import jp.fric.graphics.draw.GResizeHandle;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.sbml.util.KineticLawDialog;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class KineticLawDialogDrawPanel
extends JPanel
implements MouseListener {
    private GStructure g;
    private KineticLawDialog parent;
    private double drawScale;

    public KineticLawDialogDrawPanel(KineticLawDialog parent) {
        this.parent = parent;
    }

    public void setGStructure(GStructure g) {
        this.g = g;
        this.addMouseListener(this);
    }

    public void setDrawScale(double thisPanelWidth, double thisPanelHeight) {
        BigDecimal cents;
        BigDecimal sum = new BigDecimal("0.00");
        double scale = 1.0;
        double scale1 = 1.0;
        double scale2 = 1.0;
        if (364.0 / thisPanelWidth < 1.0) {
            cents = new BigDecimal(364);
            BigDecimal dwidth = new BigDecimal(thisPanelWidth);
            sum = sum.add(cents.divide(dwidth, 3, 5));
            scale1 = sum.doubleValue();
        }
        if (160.0 / thisPanelHeight < 1.0) {
            sum = new BigDecimal("0.00");
            cents = new BigDecimal(160);
            BigDecimal dheight = new BigDecimal(thisPanelHeight);
            sum = sum.add(cents.divide(dheight, 3, 5));
            scale2 = sum.doubleValue();
        }
        scale = scale1 >= scale2 ? scale2 : scale1;
        this.drawScale = scale;
    }

    @Override
    public void paintComponent(Graphics gr) {
        Graphics2D gr2 = (Graphics2D)gr;
        gr2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color col = gr2.getColor();
        gr2.setColor(Color.white);
        gr2.fillRect(0, 0, this.getWidth(), this.getHeight());
        gr2.setColor(col);
        if (this.g != null) {
            gr2.scale(this.drawScale, this.drawScale);
            this.g.draw(gr2);
        }
        gr2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        int y;
        int x;
        GElement gelement;
        if (this.g == null) {
            return;
        }
        this.g.deselectAll();
        Point2D.Double lp = new Point2D.Double();
        if (this.drawScale != 0.0) {
            lp.x = (double)arg0.getX() / this.drawScale;
            lp.y = (double)arg0.getY() / this.drawScale;
        }
        if ((gelement = this.getElement(x = (int)lp.x, y = (int)lp.y, null)) != null) {
            this.g.select(gelement, true, true, true);
        } else {
            this.g.deselectAll();
        }
        Species selectedSBase = null;
        if (gelement instanceof SpeciesAlias) {
            SpeciesAlias alias = (SpeciesAlias)gelement;
            if (alias.isIncludedInComplex()) {
                return;
            }
            selectedSBase = alias.getOriginalSpecies();
        }
        this.parent.setText((SBase)selectedSBase);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    protected GElement getElement(double x, double y, Vector skipElements) {
        GElement temp;
        GElement gelement = null;
        int i = 0;
        while (i < this.g.getSelecteds().size()) {
            GResizeHandle gresizehandle;
            GEditPoint geditpoint;
            GLinkedShape linkedShape;
            GElement selected = (GElement)this.g.getSelecteds().elementAt(i);
            if (selected instanceof GLink && (linkedShape = ((GLink)selected).getGLinkedShape()) instanceof GEditable && (geditpoint = ((GEditable)((Object)linkedShape)).getEditPoint(x, y)) != null) {
                gelement = geditpoint;
                break;
            }
            if (selected instanceof GResizable && (gresizehandle = ((GResizable)((Object)selected)).getHandle(x, y)) != null) {
                gelement = gresizehandle;
                break;
            }
            ++i;
        }
        if (gelement != null) {
            return gelement;
        }
        i = this.g.getLinks().size() - 1;
        while (i >= 0) {
            GElement link = (GElement)this.g.getLinks().elementAt(i);
            boolean skip = false;
            if (skipElements != null) {
                int j = 0;
                while (j < skipElements.size()) {
                    temp = (GElement)skipElements.elementAt(j);
                    if (link == temp) {
                        skip = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!skip && gelement == null && link.inShape(x, y)) {
                GEditPoint geditpoint;
                gelement = link;
                GGroup ggroup = this.getSurroundingGroup((GLink)gelement);
                if (ggroup != null) {
                    gelement = ggroup;
                    break;
                }
                GLinkedShape glinkedshape = ((GLink)link).getGLinkedShape();
                if (!(glinkedshape instanceof GEditable) || (geditpoint = ((GEditable)((Object)glinkedshape)).getEditPoint(x, y)) == null) break;
                gelement = geditpoint;
                break;
            }
            --i;
        }
        if (gelement != null) {
            return gelement;
        }
        i = this.g.getAtoms().size() - 1;
        while (i >= 0) {
            GElement atom = (GElement)this.g.getAtoms().elementAt(i);
            if (((GAtom)atom).getCurrentView() != 1) {
                boolean skip = false;
                if (skipElements != null) {
                    int j = 0;
                    while (j < skipElements.size()) {
                        temp = (GElement)skipElements.elementAt(j);
                        if (atom == temp) {
                            skip = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!skip && gelement == null && atom.inShape(x, y)) {
                    gelement = atom;
                    break;
                }
            }
            --i;
        }
        if (gelement != null) {
            return gelement;
        }
        i = this.g.getContainableAtoms().size() - 1;
        while (i >= 0) {
            GElement containeratom = (GElement)this.g.getContainableAtoms().elementAt(i);
            boolean skip = false;
            if (skipElements != null) {
                int j = 0;
                while (j < skipElements.size()) {
                    temp = (GElement)skipElements.elementAt(j);
                    if (containeratom == temp) {
                        skip = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!skip && gelement == null && containeratom.inShape(x, y)) {
                gelement = containeratom;
                GGroup ggroup = this.g.getParentGroup(containeratom);
                if (ggroup == null || !this.g.getGroups().contains(ggroup)) break;
                gelement = ggroup;
                break;
            }
            --i;
        }
        if (gelement != null) {
            return gelement;
        }
        i = this.g.getContainers().size() - 1;
        while (i >= 0) {
            GElement container = (GElement)this.g.getContainers().elementAt(i);
            boolean skip = false;
            if (skipElements != null) {
                int j = 0;
                while (j < skipElements.size()) {
                    temp = (GElement)skipElements.elementAt(j);
                    if (container == temp) {
                        skip = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!skip && container.onEdge(x, y)) {
                if (gelement == null) {
                    gelement = container;
                } else if (((GContainer)((Object)gelement)).includes((GContainerTarget)((Object)container)) > 0) {
                    gelement = container;
                }
            }
            --i;
        }
        return gelement;
    }

    private GGroup getSurroundingGroup(GLink glink) {
        GGroup ggroup = null;
        int i = 0;
        while (i < glink.targetSize()) {
            GGroup group;
            block9: {
                GLinkTarget glinktarget;
                block8: {
                    glinktarget = glink.getTargetAt(i);
                    if (glinktarget instanceof GGroupTarget) break block8;
                    return null;
                }
                group = this.g.getParentGroup((GElement)((Object)glinktarget));
                if (group != null) break block9;
                return null;
            }
            try {
                if (ggroup == null) {
                    ggroup = group;
                } else if (ggroup != group) {
                    return null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return ggroup;
    }
}

