/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Observable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GLinkConnectSchemeOwner;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedCurveAndLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.OpenedCompartmentAlias;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.sbmlExtension.CompartmentAnnotation;
import jp.sbi.celldesigner.sbmlExtension.ReactionAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesReferenceAnnotation;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.sbml.Any;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.KineticLawDialogDrawPanel;
import jp.sbi.sbml.util.KineticLawDialogFunctionPanel;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ListPanel;
import jp.sbi.sbml.util.MathEditPanel;
import jp.sbi.sbml.util.MathEditor;
import jp.sbi.sbml.util.ObservableAspect;
import jp.sbi.sbml.util.ParameterDialog;
import jp.sbi.sbml.util.ReactionDialog;
import jp.sbi.sbml.util.RuleListPanel;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseListPanel;
import jp.sbi.sbml.util.SBaseListPanelListener;
import jp.sbi.sbml.util.SpeciesListPanel;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesReference;
import org.sbml.libsbml.libsbml;

public class KineticLawDialog
extends SBaseDialog
implements MathEditor {
    public static final int SIZE_OF_LISTS = 3;
    private JTextField mathTextField;
    private JTextField timeUnitsTextField;
    private JTextField substanceUnitsTextField;
    private MathEditPanel mathPanel;
    private boolean[] isFirstShowing;
    private SBaseListPanel[] listPanel;
    private static String[] dialogClassName = new String[]{"SpeciesDialog", "ParameterDialog", "RuleDialog"};
    private JScrollPane scroll;
    protected KineticLawDialogDrawPanel drawPanel;
    private static final int DRAW_PANEL_POSITION = 200;
    private JTabbedPane jTabbedPane;
    private JPanel innerPanel;
    private JToggleButton toggleSelectedReaction;
    private JToggleButton toggleSelectedFunction;
    private static String[] ListName = new String[]{"Species", "Parameters", "Rules"};
    protected KineticLawDialogFunctionPanel functionPanel;
    protected static final int FUNCTION_PANEL_POSITION = 130;
    private JPanel topPanel;
    private JPanel buttonPanel;
    private ListOf parametersBackup = null;
    private HashMap parameterID = new HashMap();
    private boolean isChanged = false;
    public static final String NAME = "Name";
    public static final String MATH = "Math";
    public static final int INDEX_OF_PARAMETERS_PANEL = 1;
    private HashMap aliasesNameMap = new HashMap();
    public static final int DEFAULT_SPACE = 30;
    public static final int DEFAULT_LINK_LENGTH = 150;
    public static final int DEFAULT_REACTANT_DISTANCE = 30;
    public static final int DEFAULT_MODIFIER_DISTANCE = 10;
    public static final int DEFAULT_ID_DISTANCE = 10;
    public static final int MID_POINT_OFFSET = 10;
    public static final String downTriangle = "V";
    public static final String rightTriangle = ">";
    private int updateCount = 0;

    public KineticLawDialog() {
        this.initIsFirstShowing();
        this.setSize(new Dimension(600, this.getSize().height));
        this.setResizable(true);
    }

    public KineticLawDialog(Dialog owner) {
        super(owner);
        this.initIsFirstShowing();
        this.setSize(new Dimension(600, this.getSize().height));
        this.setResizable(true);
    }

    public KineticLawDialog(Frame owner) {
        super(owner);
        this.initIsFirstShowing();
        this.setSize(new Dimension(600, this.getSize().height));
        this.setResizable(true);
    }

    public void updatePanel() {
        int flg = 0;
        if (this.toggleSelectedReaction.isSelected()) {
            if (this.toggleSelectedFunction.isSelected()) {
                this.toggleSelectedReaction.setText(downTriangle);
                this.toggleSelectedFunction.setText(downTriangle);
                flg = 0;
            } else {
                this.toggleSelectedReaction.setText(downTriangle);
                this.toggleSelectedFunction.setText(rightTriangle);
                flg = 2;
            }
        } else if (this.toggleSelectedFunction.isSelected()) {
            this.toggleSelectedReaction.setText(rightTriangle);
            this.toggleSelectedFunction.setText(downTriangle);
            flg = 1;
        } else {
            this.toggleSelectedReaction.setText(rightTriangle);
            this.toggleSelectedFunction.setText(rightTriangle);
            flg = 3;
        }
        this.getContentPane().removeAll();
        this.resetDialogPanel(flg);
        this.mainPanel.validate();
        this.setContentPane(this.mainPanel);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int height = screenSize.height;
        double h = this.getSize().getHeight();
        double w = this.getSize().getWidth();
        switch (flg) {
            case 3: {
                h = height - 280;
                break;
            }
            case 1: {
                h = height - 150;
                break;
            }
            case 2: {
                h = height - 130;
                break;
            }
            default: {
                h = height - 30;
            }
        }
        this.setSize((int)w, (int)(h -= 48.0));
        this.repaint();
    }

    private int setInnerPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int y = 0;
        y += 10;
        JLabel formulaLabel = new JLabel("math");
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 5.0;
        c.weighty = 4.0;
        c.fill = 0;
        c.anchor = 18;
        c.insets = new Insets(10, 0, 0, 0);
        this.topPanel.add((Component)formulaLabel, c);
        JLabel messageLabel = new JLabel("View mode");
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 5.0;
        c.weighty = 4.0;
        c.fill = 0;
        c.anchor = 18;
        c.insets = new Insets(formulaLabel.getPreferredSize().height + 10, 0, 0, 0);
        messageLabel.setForeground(Color.MAGENTA);
        this.topPanel.add((Component)messageLabel, c);
        messageLabel.setVisible(true);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 5.0;
        c.weighty = 1.0;
        c.fill = 0;
        c.anchor = 14;
        c.insets = new Insets(30, 2, 20, 2);
        JCheckBox ckbMath = new JCheckBox();
        int ckbMathWidth = (int)(ckbMath.getPreferredSize().getWidth() * 3.0);
        ckbMath.setText(MATH);
        ckbMath.setBounds(0, 0, ckbMathWidth, this.LINE_HEIGHT);
        ckbMath.setPreferredSize(new Dimension(ckbMathWidth, this.LINE_HEIGHT));
        ckbMath.setEnabled(true);
        this.topPanel.add((Component)ckbMath, c);
        c.weightx = 10.0;
        c.anchor = 14;
        c.insets = new Insets(1, 0, 0, 2);
        JCheckBox ckbName = new JCheckBox();
        Rectangle r = ckbMath.getBounds();
        int ckbNameWidth = r.width;
        ckbName.setText(NAME);
        ckbName.setPreferredSize(new Dimension(ckbNameWidth, this.LINE_HEIGHT));
        ckbName.setEnabled(true);
        this.topPanel.add((Component)ckbName, c);
        this.mathPanel = new MathEditPanel(this);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 20.0;
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        this.topPanel.add((Component)this.mathPanel, c);
        int mpheight = this.mathPanel.createUI1(300, this.LINE_HEIGHT, this.BASELINE_SKIP, ckbMath, ckbName, messageLabel);
        this.docListener = new KineticLawDialogMyDocumentListener();
        this.mathTextField = this.mathPanel.getTextField();
        this.mathTextField.getDocument().addDocumentListener(this.docListener);
        this.mathTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
                KineticLawDialog.this.functionPanel.setListSelected(0);
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.timeUnitsTextField = new JTextField();
        this.substanceUnitsTextField = new JTextField();
        return y += mpheight + this.BASELINE_SKIP - this.LINE_HEIGHT;
    }

    protected void panel_mouseReleased(MouseEvent e, boolean isShowing) {
        if (isShowing) {
            this.mainPanel.requestFocus();
            String strTextMath = this.mathTextField.getText();
            ASTNode node = libsbml.parseFormula((String)strTextMath);
            if (node != null) {
                this.mathTextField.setText(libsbml.formulaToString((ASTNode)libsbml.parseFormula((String)strTextMath)));
            }
        }
    }

    @Override
    protected JPanel createDialogPanel() {
        int y = 0;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        y += 10;
        y = this.setInnerPanel();
        c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.ipady = 100;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 0, 5);
        this.mainPanel.add((Component)this.topPanel, c);
        this.toggleSelectedReaction = new JToggleButton(downTriangle);
        this.toggleSelectedReaction.setSelected(true);
        this.toggleSelectedReaction.setBounds(new Rectangle(10, 0, 60, 20));
        this.toggleSelectedReaction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                KineticLawDialog.this.updatePanel();
            }
        });
        this.innerPanel = new JPanel();
        this.scroll = new JScrollPane();
        this.drawPanel = new KineticLawDialogDrawPanel(this);
        this.innerPanel.setBorder(new TitledBorder("                SelectedReaction "));
        this.drawPanel.setBackground(Color.white);
        this.scroll.getViewport().add(this.drawPanel);
        this.scroll.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                KineticLawDialog.this.drawPanel.repaint();
            }
        });
        this.scroll.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                KineticLawDialog.this.drawPanel.repaint();
            }
        });
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.add(this.toggleSelectedReaction);
        this.innerPanel.add(this.scroll);
        c.gridy = 1;
        c.ipady = 240;
        this.mainPanel.add((Component)this.innerPanel, c);
        y += 205;
        this.toggleSelectedFunction = new JToggleButton(downTriangle);
        this.toggleSelectedFunction.setSelected(true);
        this.toggleSelectedFunction.setBounds(new Rectangle(10, 0, 60, 20));
        this.toggleSelectedFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                KineticLawDialog.this.updatePanel();
            }
        });
        this.functionPanel = new KineticLawDialogFunctionPanel(this, this.toggleSelectedFunction);
        c.weighty = 1.0;
        c.ipady = 180;
        c.gridy = 2;
        this.mainPanel.add((Component)this.functionPanel, c);
        y += 150;
        this.initListPanelAndDialog();
        this.jTabbedPane = new JTabbedPane();
        int i = 0;
        while (i < 3) {
            this.jTabbedPane.add(ListName[i], this.listPanel[i]);
            this.jTabbedPane.setToolTipTextAt(this.jTabbedPane.getTabCount() - 1, this.listPanel[i].getToolTipText());
            ++i;
        }
        this.jTabbedPane.setBorder(BorderFactory.createEtchedBorder(1));
        this.jTabbedPane.setSelectedIndex(0);
        c.ipady = 180;
        c.gridy = 3;
        this.mainPanel.add((Component)this.jTabbedPane, c);
        this.LABEL_WIDTH = 90;
        this.TEXT_WIDTH = 300;
        this.setLayoutConstants();
        this.BUTTON_POSITION_Y = (y += 150 + this.BASELINE_SKIP - this.LINE_HEIGHT + 20) - 24;
        this.buttonPanel = new JPanel();
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        c.gridy = 4;
        c.ipady = 100;
        c.anchor = 11;
        this.mainPanel.add((Component)this.buttonPanel, c);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (KineticLawDialog.rightTriangle.equals(KineticLawDialog.this.toggleSelectedReaction.getText()) && KineticLawDialog.rightTriangle.equals(KineticLawDialog.this.toggleSelectedFunction.getText())) {
                    KineticLawDialog.this.resetDialogPanel(4);
                }
                if (KineticLawDialog.this.mathPanel.isFakeLabelVisible()) {
                    KineticLawDialog.this.mathPanel.createColoredHTML();
                }
            }
        });
        this.mainPanel.addMouseListener(new KineticLawPanel_mouseAdapter(this));
        this.topPanel.addMouseListener(new KineticLawPanel_mouseAdapter(this));
        this.innerPanel.addMouseListener(new KineticLawPanel_mouseAdapter(this));
        this.functionPanel.addMouseListener(new KineticLawPanel_mouseAdapter(this));
        this.buttonPanel.addMouseListener(new KineticLawPanel_mouseAdapter(this));
        this.jTabbedPane.addMouseListener(new KineticLawPanel_mouseAdapter(this));
        return this.mainPanel;
    }

    protected void resetDialogPanel(int flg) {
        int y = 0;
        int dy = 0;
        double p = (double)this.getHeight() / this.getPreferredSize().getHeight();
        if (flg >= 4) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int height = screenSize.height;
            p = (double)this.getHeight() / (double)height - 0.63;
            dy = (int)(p * 200.0);
        }
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        y += 10;
        int hmargin = 4;
        int h = this.BASELINE_SKIP - hmargin;
        c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 0, 5);
        int t = 20;
        c.ipady = flg >= 3 ? 100 - dy - 48 : (flg == 1 || flg == 2 ? 100 - t : 120 - t);
        c.gridy = 0;
        this.mainPanel.add((Component)this.topPanel, c);
        y += h + hmargin;
        if (flg == 1 || flg >= 3) {
            c.ipady = 0;
            c.weighty = 0.0;
            this.scroll.setVisible(false);
        } else if (flg == 2) {
            c.weighty = 1.0;
            c.ipady = 180;
            this.scroll.setVisible(true);
        } else {
            c.weighty = 1.0;
            c.ipady = 240;
            this.scroll.setVisible(true);
        }
        c.gridy = 1;
        this.mainPanel.add((Component)this.innerPanel, c);
        y += 205;
        if (flg == 2 || flg >= 3) {
            c.weighty = 0.0;
            c.ipady = 0;
            this.functionPanel.setPanelVisible(false);
        } else if (flg == 1) {
            c.weighty = 1.0;
            c.ipady = 160;
            this.functionPanel.setPanelVisible(true);
        } else {
            c.weighty = 1.0;
            c.ipady = 180;
            this.functionPanel.setPanelVisible(true);
        }
        c.gridy = 2;
        this.mainPanel.add((Component)this.functionPanel, c);
        y += 150;
        c.weighty = 1.0;
        c.ipady = flg >= 4 ? 180 + dy * 2 : (flg >= 4 ? 220 : 180);
        c.gridy = 3;
        this.mainPanel.add((Component)this.jTabbedPane, c);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        c.gridy = 4;
        c.ipady = flg >= 3 ? 100 - (int)((double)dy * 1.3) - 4 * t : 100;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 11;
        this.mainPanel.add((Component)this.buttonPanel, c);
        if (flg >= 4) {
            this.getContentPane().removeAll();
            this.mainPanel.validate();
            this.setContentPane(this.mainPanel);
            this.validate();
        }
    }

    public GStructure getDrawGStructure(Reaction reaction, String modelID) {
        int distCount;
        int sourceCount;
        GLinkConnectSchemeOwner line;
        int k;
        Vector allTargets;
        ComplexSpeciesAlias complex;
        MonoSpeciesShape mono;
        SpeciesAlias alias;
        SpeciesAlias tmpAlias;
        Any anno;
        Species sp;
        SpeciesReference ref;
        SBMLDocument doc = new SBMLDocument();
        Model model = new Model();
        model.setId(modelID);
        doc.setModel(model);
        model.addReaction(reaction.cloneObject());
        GStructure g = new GStructure();
        g.setLinkNametag("re");
        g.setAtomNametag("sa");
        g.setContainableAtomNametag("csa");
        g.setContainerNametag("ca");
        g.setGroupNametag("g");
        Vector<CompartmentAlias> createdCompartmentAliases = new Vector<CompartmentAlias>();
        Vector createdAliass = new Vector();
        Vector containsAtoms = new Vector();
        Vector<SpeciesAlias> listOfSource = new Vector<SpeciesAlias>();
        Vector<SpeciesAlias> listOfDist = new Vector<SpeciesAlias>();
        Vector<SpeciesAlias> listOfModifier = new Vector<SpeciesAlias>();
        HashMap<Integer, SpeciesAlias> mapRefSources = new HashMap<Integer, SpeciesAlias>();
        HashMap<Integer, SpeciesAlias> mapRefDists = new HashMap<Integer, SpeciesAlias>();
        HashMap<Integer, SpeciesAlias> mapRefModifiers = new HashMap<Integer, SpeciesAlias>();
        HashMap<Integer, SpeciesAlias> map = new HashMap<Integer, SpeciesAlias>();
        int modifiersLength = 0;
        Model originModel = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel();
        int i = 0;
        while ((long)i < reaction.getNumReactants()) {
            ref = reaction.getReactant((long)i);
            sp = originModel.getSpecies(ref.getSpecies());
            anno = (SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(reaction, (SBase)ref, "Reactants", i, null);
            tmpAlias = this.getSpeciesAlias(createdAliass, containsAtoms, ((SpeciesReferenceAnnotation)anno).getSpecieAlias().getName());
            if (tmpAlias != null) {
                listOfSource.add(tmpAlias);
            } else {
                model.addSpecies(sp.cloneObject());
                alias = (SpeciesAlias)((SpeciesReferenceAnnotation)anno).getSpecieAlias().createCopy();
                alias.setName(((SpeciesReferenceAnnotation)anno).getSpecieAlias().getName());
                mapRefSources.put(new Integer(i), alias);
                mono = (MonoSpeciesShape)alias.getGFramedShape();
                mono.setIDString(sp.getId());
                if (alias instanceof ComplexSpeciesAlias) {
                    complex = (ComplexSpeciesAlias)alias;
                    allTargets = complex.getAllTargetsInMe(true);
                    k = 0;
                    while (k < allTargets.size()) {
                        if (allTargets.get(k) instanceof ComplexSpeciesAlias) {
                            containsAtoms.addElement(allTargets.get(k));
                        } else {
                            createdAliass.addElement(allTargets.get(k));
                        }
                        ++k;
                    }
                    containsAtoms.addElement(alias);
                } else {
                    createdAliass.addElement(alias);
                }
                map.put(new Integer((int)(model.getNumSpecies() - 1L)), alias);
                listOfSource.addElement(alias);
            }
            ++i;
        }
        i = 0;
        while ((long)i < reaction.getNumProducts()) {
            ref = reaction.getProduct((long)i);
            sp = originModel.getSpecies(ref.getSpecies());
            anno = (SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(reaction, (SBase)ref, "Products", i, null);
            tmpAlias = this.getSpeciesAlias(createdAliass, containsAtoms, ((SpeciesReferenceAnnotation)anno).getSpecieAlias().getName());
            if (tmpAlias != null) {
                listOfDist.add(tmpAlias);
            } else {
                model.addSpecies(sp.cloneObject());
                alias = (SpeciesAlias)((SpeciesReferenceAnnotation)anno).getSpecieAlias().createCopy();
                alias.setName(((SpeciesReferenceAnnotation)anno).getSpecieAlias().getName());
                mapRefDists.put(new Integer(i), alias);
                mono = (MonoSpeciesShape)alias.getGFramedShape();
                mono.setIDString(sp.getId());
                if (alias instanceof ComplexSpeciesAlias) {
                    complex = (ComplexSpeciesAlias)alias;
                    allTargets = complex.getAllTargetsInMe(true);
                    k = 0;
                    while (k < allTargets.size()) {
                        if (allTargets.get(k) instanceof ComplexSpeciesAlias) {
                            containsAtoms.addElement(allTargets.get(k));
                        } else {
                            createdAliass.addElement(allTargets.get(k));
                        }
                        ++k;
                    }
                    containsAtoms.addElement(alias);
                } else {
                    createdAliass.addElement(alias);
                }
                map.put(new Integer((int)(model.getNumSpecies() - 1L)), alias);
                listOfDist.addElement(alias);
            }
            ++i;
        }
        i = 0;
        while ((long)i < reaction.getNumModifiers()) {
            ref = reaction.getModifier((long)i);
            sp = originModel.getSpecies(ref.getSpecies());
            anno = (SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(reaction, (SBase)ref, "Modifiers", i, null);
            tmpAlias = this.getSpeciesAlias(createdAliass, containsAtoms, ((SpeciesReferenceAnnotation)anno).getSpecieAlias().getName());
            if (tmpAlias != null) {
                listOfModifier.add(tmpAlias);
            } else {
                model.addSpecies(sp.cloneObject());
                alias = (SpeciesAlias)((SpeciesReferenceAnnotation)anno).getSpecieAlias().createCopy();
                alias.setName(((SpeciesReferenceAnnotation)anno).getSpecieAlias().getName());
                mapRefModifiers.put(new Integer(i), alias);
                mono = (MonoSpeciesShape)alias.getGFramedShape();
                mono.setIDString(sp.getId());
                if (alias instanceof ComplexSpeciesAlias) {
                    complex = (ComplexSpeciesAlias)alias;
                    allTargets = complex.getAllTargetsInMe(true);
                    k = 0;
                    while (k < allTargets.size()) {
                        if (allTargets.get(k) instanceof ComplexSpeciesAlias) {
                            containsAtoms.addElement(allTargets.get(k));
                        } else {
                            createdAliass.addElement(allTargets.get(k));
                        }
                        ++k;
                    }
                    containsAtoms.addElement(alias);
                } else {
                    createdAliass.addElement(alias);
                }
                map.put(new Integer((int)(model.getNumSpecies() - 1L)), alias);
                listOfModifier.addElement(alias);
                modifiersLength = modifiersLength + (int)alias.getFrameBounds().width + 10;
            }
            ++i;
        }
        g.setAtoms(createdAliass);
        g.setContainableAtoms(containsAtoms);
        Vector createdAliasAll = new Vector();
        if (createdAliass != null && createdAliass.size() >= 0) {
            createdAliasAll.addAll(createdAliass);
        }
        if (containsAtoms != null && containsAtoms.size() >= 0) {
            createdAliasAll.addAll(containsAtoms);
        }
        if (modifiersLength > 0) {
            modifiersLength -= 10;
        }
        int i2 = 0;
        while ((long)i2 < model.getNumSpecies()) {
            sp = model.getSpecies((long)i2);
            if (model.getCompartment(sp.getCompartment()) == null) {
                Compartment compartment = new Compartment();
                compartment.setId(sp.getCompartment());
                CompartmentAnnotation anno2 = (CompartmentAnnotation)LibSBMLUtil.getAnnotation((SBase)compartment, null);
                int k2 = 0;
                while (k2 < anno2.getReferingAliases().size()) {
                    CompartmentAlias alias2 = (CompartmentAlias)anno2.getReferingAliases().get(k2);
                    if (!(alias2 instanceof OpenedCompartmentAlias)) {
                        createdCompartmentAliases.addElement(alias2);
                    }
                    ++k2;
                }
                model.addCompartment(compartment);
            }
            anno = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)sp, null);
            ((SpeciesAnnotation)anno).updateAnnotation(sp, doc.getNamespaces());
            ++i2;
        }
        g.setContainers(createdCompartmentAliases);
        Vector<ReactionLink> createdLinks = new Vector<ReactionLink>();
        ReactionAnnotation annotation = (ReactionAnnotation)LibSBMLUtil.getAnnotation((SBase)reaction, null);
        String name = annotation.getBaseLink().getName();
        ReactionLink baseLink = (ReactionLink)annotation.getBaseLink().createCopy();
        GLinkedShape shape = baseLink.getGLinkedShape();
        if (shape instanceof GLinkedCreaseLine) {
            line = (GLinkedCreaseLine)shape;
            ((GLinkedCreaseLine)line).removeCreasePoint(g);
        } else if (shape instanceof GLinkedLineComplex3) {
            line = (GLinkedLineComplex3)shape;
            ((GLinkedLineComplex3)line).removeCreasePoint(g);
        }
        baseLink.setName(name);
        baseLink.getParentReaction().setId(annotation.getBaseLink().getParentReaction().getId());
        baseLink.getParentReaction().setName(annotation.getBaseLink().getParentReaction().getName());
        createdLinks.addElement(baseLink);
        if (annotation.getType().equals("HETERODIMER_ASSOCIATION")) {
            sourceCount = 2;
            distCount = 1;
        } else if (annotation.getType().equals("DISSOCIATION") || annotation.getType().equals("TRUNCATION")) {
            sourceCount = 1;
            distCount = 2;
        } else if (baseLink.getGLinkedShape() instanceof GLogicGate) {
            sourceCount = 0;
            distCount = 1;
        } else {
            sourceCount = 1;
            distCount = 1;
        }
        int iC = 0;
        if (baseLink.getGLinkedShape() instanceof GLogicGate) {
            try {
                baseLink.setTargetAt((GLinkTarget)((GLogicGate)baseLink.getGLinkedShape()).getHeaderPoint(), iC, (GLinkPositionInfo)null);
            }
            catch (Exception k3) {
                // empty catch block
            }
            ++iC;
        }
        int i3 = 0;
        while (i3 < sourceCount) {
            try {
                baseLink.setTargetAt((GLinkTarget)((SpeciesAlias)listOfSource.get(i3)), iC, (GLinkPositionInfo)null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++iC;
            ++i3;
        }
        i3 = 0;
        while (i3 < distCount) {
            try {
                baseLink.setTargetAt((GLinkTarget)((SpeciesAlias)listOfDist.get(i3)), iC, (GLinkPositionInfo)null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++iC;
            ++i3;
        }
        int i4 = 0;
        while (i4 < annotation.getAddReactantLinks().size()) {
            name = ((GElement)annotation.getAddReactantLinks().get(i4)).getName();
            ReactionLink link = (ReactionLink)((GElement)annotation.getAddReactantLinks().get(i4)).createCopy();
            link.setName(name);
            createdLinks.addElement(link);
            try {
                link.setTargetAt((GLinkTarget)((SpeciesAlias)listOfSource.get(sourceCount + i4)), 0, (GLinkPositionInfo)null);
                link.setTargetAt((GLinkTarget)baseLink, 1, new GLinkPositionInfo(0, 0.0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < annotation.getAddProductLinks().size()) {
            name = ((GElement)annotation.getAddProductLinks().get(i4)).getName();
            ReactionLink link = (ReactionLink)((GElement)annotation.getAddProductLinks().get(i4)).createCopy();
            link.setName(name);
            createdLinks.addElement(link);
            try {
                link.setTargetAt((GLinkTarget)baseLink, 0, new GLinkPositionInfo(1, 0.0));
                link.setTargetAt((GLinkTarget)((SpeciesAlias)listOfDist.get(distCount + i4)), 1, (GLinkPositionInfo)null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i4;
        }
        int j = 0;
        int n = 0;
        int i5 = 0;
        while (i5 < annotation.getModificationLinks().size()) {
            name = ((GElement)annotation.getModificationLinks().get(i5)).getName();
            ReactionLink link = (ReactionLink)((GElement)annotation.getModificationLinks().get(i5)).createCopy();
            ReactionLink originLink = (ReactionLink)((GElement)annotation.getModificationLinks().get(i5));
            link.getParentReaction().setId(annotation.getBaseLink().getParentReaction().getId());
            link.getParentReaction().setName(annotation.getBaseLink().getParentReaction().getName());
            link.setName(name);
            if (link.getGLinkedShape() instanceof GLogicGate) {
                try {
                    GLogicGate gate = (GLogicGate)link.getGLinkedShape();
                    link.setTargetAt((GLinkTarget)gate.getHeaderPoint(), 0, (GLinkPositionInfo)null);
                    link.setTargetAt((GLinkTarget)baseLink, 1, new GLinkPositionInfo(3, 0.0));
                    createdLinks.addElement(link);
                    ReactionLink gateLink = link;
                    Vector children = ((GLogicGate)originLink.getGLinkedShape()).getChildrenLink();
                    int k4 = 0;
                    while (k4 < children.size()) {
                        SpeciesAlias alias3;
                        SpeciesAlias aliasCopy;
                        ReactionLink child = (ReactionLink)children.get(k4);
                        String childName = child.getName();
                        boolean isNotFound = true;
                        int m = 0;
                        while (m < createdLinks.size()) {
                            ReactionLink tmpLink = (ReactionLink)createdLinks.get(m);
                            if (tmpLink.getName().equals(childName)) {
                                link = tmpLink;
                                isNotFound = false;
                                break;
                            }
                            ++m;
                        }
                        if (isNotFound) {
                            name = child.getName();
                            link = (ReactionLink)child.createCopy();
                            link.getParentReaction().setId(annotation.getBaseLink().getParentReaction().getId());
                            link.getParentReaction().setName(annotation.getBaseLink().getParentReaction().getName());
                            link.setName(name);
                        }
                        if ((aliasCopy = this.getSpeciesAlias(createdAliass, containsAtoms, (alias3 = (SpeciesAlias)child.getTargetAt(0)).getName())) == null) {
                            aliasCopy = (SpeciesAlias)mapRefModifiers.get(new Integer(n));
                        }
                        link.setTargetAt((GLinkTarget)aliasCopy, 0, (GLinkPositionInfo)null);
                        link.setTargetAt((GLinkTarget)gateLink, 1, new GLinkPositionInfo(3, 0.0));
                        createdLinks.addElement(link);
                        ++k4;
                        ++n;
                    }
                }
                catch (Exception gate) {}
            } else {
                try {
                    ReactionLink des;
                    boolean isNotFound = true;
                    if (originLink.getTargetAt(1) instanceof ReactionLink && (des = (ReactionLink)originLink.getTargetAt(1)).getGLinkedShape() instanceof GLogicGate) {
                        isNotFound = false;
                    }
                    if (isNotFound) {
                        link.setTargetAt((GLinkTarget)((SpeciesAlias)listOfModifier.get(j)), 0, (GLinkPositionInfo)null);
                        link.setTargetAt((GLinkTarget)baseLink, 1, new GLinkPositionInfo(3, 0.0));
                    }
                    createdLinks.addElement(link);
                }
                catch (Exception isNotFound) {
                    // empty catch block
                }
                ++j;
            }
            ++i5;
            ++n;
        }
        if (baseLink.getGLinkedShape() instanceof GLogicGate) {
            Vector memberLinks = annotation.getBaseLink().getBaseLinkGateMembers();
            int i6 = 0;
            while (i6 < memberLinks.size()) {
                ReactionLink memberLink = (ReactionLink)memberLinks.get(i6);
                name = memberLink.getName();
                ReactionLink link = (ReactionLink)memberLink.createCopy();
                link.getParentReaction().setId(memberLink.getParentReaction().getId());
                link.getParentReaction().setName(memberLink.getParentReaction().getName());
                link.setName(name);
                try {
                    SpeciesAlias alias4 = (SpeciesAlias)memberLink.getTargetAt(0);
                    int k5 = 0;
                    while (k5 < createdAliasAll.size()) {
                        if (((SpeciesAlias)createdAliasAll.get(k5)).getName().equals(alias4.getName())) {
                            try {
                                link.setTargetAt((GLinkTarget)((SpeciesAlias)createdAliasAll.get(k5)), 0, (GLinkPositionInfo)null);
                                link.setTargetAt((GLinkTarget)baseLink, 1, new GLinkPositionInfo(3, 0.0));
                                createdLinks.addElement(link);
                                break;
                            }
                            catch (Exception k4) {
                                // empty catch block
                            }
                        }
                        ++k5;
                    }
                    if (k5 >= createdAliasAll.size()) {
                        try {
                            SpeciesAlias soruce = (SpeciesAlias)mapRefSources.get(new Integer(i6));
                            link.setTargetAt((GLinkTarget)soruce, 0, (GLinkPositionInfo)null);
                            link.setTargetAt((GLinkTarget)baseLink, 1, new GLinkPositionInfo(3, 0.0));
                            createdLinks.addElement(link);
                        }
                        catch (Exception soruce) {}
                    }
                }
                catch (Exception alias4) {
                    // empty catch block
                }
                ++i6;
            }
        }
        i = 0;
        while (i < createdLinks.size()) {
            ReactionLink links = (ReactionLink)createdLinks.get(i);
            shape = links.getGLinkedShape();
            if (shape instanceof GLinkedCreaseLine) {
                GLinkedCreaseLine line2 = (GLinkedCreaseLine)shape;
                line2.removeCreasePoint(g);
            } else if (shape instanceof GLinkedCurveAndLine) {
                GLinkedCurveAndLine line3 = (GLinkedCurveAndLine)shape;
                line3.setConnectPolicy(0);
                line3.setLineType(1);
                line3.removeCreasePoint(g);
            } else if (shape instanceof GLogicGate) {
                GLogicGate gate = (GLogicGate)shape;
                LinkedCreaseLine line4 = gate.getRealLine();
                line4.removeCreasePoint(g);
            }
            ++i;
        }
        g.setLinks(createdLinks);
        g.updateLinks();
        this.aliasesNameMap = new HashMap();
        int reactant_x = 60;
        int reactant_y = 30;
        int reactant_max_width = 0;
        Point2D.Double ord = new Point2D.Double(reactant_x, reactant_y);
        reactant_max_width = this.setDrawOrd(listOfSource, ord, false);
        reactant_x = (int)ord.x;
        reactant_y = (int)ord.y;
        int product_x = 0;
        product_x = modifiersLength > 150 ? reactant_x + reactant_max_width + modifiersLength : reactant_x + reactant_max_width + 150;
        int product_y = 30;
        int product_max_width = 0;
        ord = new Point2D.Double(product_x, product_y);
        product_max_width = this.setDrawOrd(listOfDist, ord, false);
        product_x = (int)ord.x;
        product_y = (int)ord.y;
        int modifier_x = 0;
        if (modifiersLength > 0) {
            modifier_x = modifiersLength > 150 ? reactant_x + reactant_max_width : reactant_x + reactant_max_width + (150 - modifiersLength) / 2;
        }
        int modifier_y = reactant_y > product_y ? reactant_y : product_y;
        int modifier_max_height = 0;
        ord = new Point2D.Double(modifier_x, modifier_y += 30);
        modifier_max_height = this.setDrawOrd(listOfModifier, ord, true);
        modifier_x = (int)ord.x;
        modifier_y = (int)ord.y;
        int documentsize_x = product_x > modifier_x ? product_x + product_max_width : modifier_x + product_max_width;
        int documentsize_y = modifier_y + modifier_max_height + 30;
        baseLink.update();
        g.setMaxDrawSize(new Rectangle2D.Double(0.0, 0.0, documentsize_x + 30, documentsize_y));
        int i7 = 0;
        while (i7 < createdLinks.size()) {
            ReactionLink links = (ReactionLink)createdLinks.get(i7);
            shape = links.getGLinkedShape();
            if (shape instanceof GLinkedLineComplex3) {
                GLinkedLineComplex3 line5 = (GLinkedLineComplex3)shape;
                GLinkedLine[] lines = line5.getLines();
                if (lines[0].getEndTarget() != null && lines[1].getEndTarget() != null && lines[2].getEndTarget() != null) {
                    Point2D.Double endPoint0 = lines[0].getEndTarget().targetPoint();
                    Point2D.Double endPoint1 = lines[1].getEndTarget().targetPoint();
                    Point2D.Double endPoint2 = lines[2].getEndTarget().targetPoint();
                    Point2D.Double midPoint = new Point2D.Double();
                    if (endPoint0 != null && endPoint1 != null && endPoint2 != null) {
                        midPoint.x = (endPoint0.x + endPoint1.x + endPoint2.x) / 3.0;
                        midPoint.y = (endPoint0.y + endPoint1.y + endPoint2.y) / 3.0;
                    }
                    line5.setMidCreasePoint(midPoint.x + 10.0, midPoint.y);
                }
            } else if (shape instanceof GLogicGate) {
                GLogicGate gate = (GLogicGate)shape;
                if (baseLink.getGLinkedShape() instanceof GLogicGate) {
                    double x = 0.0;
                    double y = 0.0;
                    x = (reactant_x + product_x + reactant_max_width) / 2;
                    y = 30 * (listOfSource.size() + listOfDist.size());
                    g.setGateHeadPosition(gate, new Point2D.Double(x, y));
                } else {
                    try {
                        double x = 0.0;
                        double y = 0.0;
                        int k6 = 0;
                        while (k6 < gate.getChildrenLink().size()) {
                            ReactionLink childLink = (ReactionLink)gate.getChildrenLink().get(k6);
                            SpeciesAlias sa = (SpeciesAlias)childLink.getTargetAt(0);
                            x += sa.getBounds().getCenterX();
                            ++k6;
                        }
                        y = modifier_y;
                        GLinkPositionInfo proLpi = new GLinkPositionInfo(2, 0.0);
                        ord = baseLink.getCoordinatesOfLinkPosition(proLpi);
                        x = (x + ord.x) / (double)(gate.getChildrenLink().size() + 1);
                        y = (y + ord.y) / 2.0;
                        g.setGateHeadPosition(gate, new Point2D.Double(x, y));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++i7;
        }
        g.updateLinks();
        return g;
    }

    protected void updateDrawPanel() {
        ReactionDialog rr = (ReactionDialog)this.getParent();
        Reaction reaction = (Reaction)rr.getObject();
        GStructure g = this.getDrawGStructure(reaction, "kineticLaw_dialog");
        this.drawPanel = new KineticLawDialogDrawPanel(this);
        this.drawPanel.setPreferredSize(new Dimension((int)g.getMaxDrawSize().width, (int)g.getMaxDrawSize().height));
        this.scroll.remove(this.drawPanel);
        this.scroll.setPreferredSize(new Dimension(364, 134));
        this.scroll.getViewport().add(this.drawPanel);
        this.scroll.updateUI();
        g.setContainers(new Vector());
        this.drawPanel.setGStructure(g);
        this.drawPanel.setDrawScale(364.0, 160.0);
        this.drawPanel.repaint();
        this.repaint();
        ++this.updateCount;
    }

    public void setText(SBase sbase) {
        String id = "";
        if (sbase instanceof Species) {
            Species species = (Species)sbase;
            id = species.getId();
        } else if (sbase instanceof Reaction) {
            Reaction reaction = (Reaction)sbase;
            id = reaction.getId();
        }
        this.setMathTextField(id);
    }

    @Override
    protected SBase createInitialObject() {
        return new KineticLaw();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        KineticLaw kineticLaw = (KineticLaw)sbase;
        String formula = kineticLaw.getFormula();
        this.mathTextField.setText(formula);
        this.mathTextField.setCaretPosition(formula.length());
        this.mathPanel.clearSelectedItemText();
        this.mathPanel.setPanelVisible(true);
        this.mathPanel.setDisplay();
        String timeUnits = kineticLaw.getTimeUnits();
        this.timeUnitsTextField.setText(timeUnits);
        this.timeUnitsTextField.setCaretPosition(timeUnits.length());
        String substanceUnits = kineticLaw.getSubstanceUnits();
        this.substanceUnitsTextField.setText(substanceUnits);
        this.substanceUnitsTextField.setCaretPosition(substanceUnits.length());
        if (this.editingSBase != null && this.isShowing() && this.updateCount == 0) {
            this.updateDrawPanel();
        } else {
            this.updateCount = 0;
        }
        this.functionPanel.setListSelected(LibSBMLUtil.readKineticLawAnnotation(kineticLaw));
        this.functionPanel.setVisibleForFunctionDialog(false);
    }

    public void resetPanel() {
        this.drawPanel = new KineticLawDialogDrawPanel(this);
        this.drawPanel.setPreferredSize(new Dimension(364, 134));
        this.scroll.remove(this.drawPanel);
        this.scroll.getViewport().add(this.drawPanel);
        this.scroll.updateUI();
        this.drawPanel.setGStructure(null);
        this.drawPanel.repaint();
        this.mathTextField.setText("");
        this.mathPanel.resetMathTextField();
        this.mathPanel.resetMathCheckBox();
        this.mathPanel.resetNameCheckBox();
    }

    public void updateParameterPanel(Parameter newParameter) {
        SBaseListPanel panel = this.listPanel[1];
        ParameterDialog dialog = (ParameterDialog)panel.getElementDialog();
        dialog.setNewObject();
        dialog.editingSBase = newParameter;
        try {
            dialog.setDialogFromObject((SBase)newParameter);
            dialog.okButton_actionPerformed();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        KineticLaw kineticLaw = (KineticLaw)sbase;
        SBModel sbModel = null;
        try {
            sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            if (sbModel == null || sbModel.getModel() == null) {
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        String str = this.mathTextField.getText();
        if (!str.equals("")) {
            try {
                if (libsbml.parseFormula((String)str) == null) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new Exception("malformed math string");
            }
        }
        if (LibSBMLUtil.haveConstantValueInMath(libsbml.parseFormula((String)str))) {
            throw new Exception(LibSBMLUtil.getHaveConstantValueInMathErroMessage("math"));
        }
        LibSBMLUtil.checkTheNumberOfArgumentsForFunctionDefinition(libsbml.parseFormula((String)str), sbModel.getModel(), null);
        kineticLaw.setFormula(str);
        LibSBMLUtil.changetoAstTimeNode(kineticLaw.getMath());
        try {
            kineticLaw.setTimeUnits("");
            kineticLaw.setSubstanceUnits("");
        }
        catch (Exception exception) {
            // empty catch block
        }
        kineticLaw.setAnnotation(LibSBMLUtil.addEnclosedAnnotationTags("<celldesigner:selectedFunction>" + this.functionPanel.getSelectedFunction() + "</celldesigner:selectedFunction>"));
        if (this.getParent() instanceof ReactionDialog) {
            ReactionDialog reactionDialog = (ReactionDialog)this.getParent();
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.mathTextField.setEnabled(isEnabled);
        this.timeUnitsTextField.setEnabled(isEnabled);
        this.substanceUnitsTextField.setEnabled(isEnabled);
        this.okButton.setEnabled(isEnabled);
        this.cancelButton.setEnabled(isEnabled);
        this.changeListPanelsEnablility(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
        int i = 0;
        while (i < 3) {
            this.listPanel[i].releaseAll();
            this.listPanel[i] = null;
            this.listPanel = null;
            ++i;
        }
    }

    @Override
    protected boolean hasChildListDialog() {
        return true;
    }

    @Override
    protected void setChildDialogMode(int mode) {
        int i = 0;
        while (i < 3) {
            this.listPanel[i].setElementDialogMode(mode);
            ++i;
        }
    }

    @Override
    protected void updateChildDialog() {
        int i = 0;
        while (i < 3) {
            SBaseListPanel listDlg = this.listPanel[i];
            if (listDlg != null) {
                listDlg.updateDialog();
            }
            ++i;
        }
    }

    private void initListPanelAndDialog() {
        if (this.listPanel == null) {
            this.listPanel = new SBaseListPanel[3];
        }
        int i = 0;
        while (i < 3) {
            block11: {
                if (i == 0) {
                    this.listPanel[i] = new SpeciesListPanel(false);
                    MainWindow.getLastInstance().AddSBaseListPanelListener(this.listPanel[i]);
                    this.listPanel[i].setEnabled(false);
                    this.listPanel[i].setName("");
                } else if (i == 1) {
                    this.listPanel[i] = new ListPanel();
                    this.listPanel[i].addSBaseListPanelListener(new MyListListener(i, this));
                    this.listPanel[i].setName("");
                    ListPanel panel = (ListPanel)this.listPanel[i];
                    panel.exportCSVButton.setVisible(false);
                } else if (i == 2) {
                    this.listPanel[i] = new RuleListPanel(false);
                    this.listPanel[i].setEnabled(false);
                    this.listPanel[i].setName("");
                }
                SBaseDialog elementDialog = null;
                String dialogName = String.valueOf(this.getClass().getPackage().getName()) + "." + dialogClassName[i];
                KineticLawDialog owner = this;
                try {
                    Constructor<?> con = Class.forName(dialogName).getConstructor(Class.forName("java.awt.Dialog"));
                    elementDialog = (SBaseDialog)con.newInstance(owner);
                }
                catch (Exception e) {
                    DebugPrinter.println(1, "KineticLawDialog-initListDialogs-cannnot construct:" + dialogClassName[i] + " ,skip");
                    break block11;
                }
                if (elementDialog != null) {
                    elementDialog.setTitle(LibSBMLUtil.getElementClassName("KineticLaw", 0));
                    this.listPanel[i].setElementDialog(elementDialog);
                    if (i == 1) {
                        ((ListPanel)this.listPanel[i]).setJTobggleButtonVisible(false);
                    }
                }
            }
            ++i;
        }
        this.changeListPanelsEnablility(false);
    }

    private void changeListPanelsEnablility(boolean isEnabled) {
        int i = 0;
        while (i < 3) {
            if (!isEnabled) {
                this.listPanel[i].setSBaseList(null);
                this.listPanel[i].disableChildDialog();
            }
            ++i;
        }
    }

    public void setListPanels(KineticLaw kineticLaw) {
        this.changeListPanelsEnablility(kineticLaw != null);
        if (kineticLaw == null) {
            return;
        }
        int i = 0;
        while (i < 3) {
            if (i == 0) {
                this.listPanel[i].setSBaseList((ListOf)MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel().getListOfSpecies());
            } else if (i == 1) {
                this.listPanel[i].setSBaseList((ListOf)kineticLaw.getListOfParameters());
                this.backupListOfParameters();
            } else if (i == 2) {
                this.listPanel[i].setSBaseList((ListOf)MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel().getListOfRules());
            }
            ++i;
        }
    }

    private void initIsFirstShowing() {
        this.isFirstShowing = new boolean[3];
        int i = 0;
        while (i < 3) {
            this.isFirstShowing[i] = true;
            ++i;
        }
    }

    @Override
    public void setObject(SBase sbase) {
        super.setObject(sbase);
        this.setListPanels((KineticLaw)sbase);
    }

    @Override
    public void setNewObject() {
        super.setNewObject();
        this.setListPanels((KineticLaw)super.getObject());
    }

    public SBaseListPanel getSBaseListPanel(int list_const) {
        if (list_const < 0 || list_const >= 3) {
            return null;
        }
        return this.listPanel[list_const];
    }

    @Override
    public MathEditPanel getMathEditPanel() {
        return this.mathPanel;
    }

    @Override
    protected void okButton_actionPerformed() {
        try {
            super.okButton_actionPerformed();
            KineticLaw kineticlawTmp = (KineticLaw)this.editingSBase;
            String strMath = kineticlawTmp.getFormula();
            String strTimeUnits = kineticlawTmp.getTimeUnits();
            String strSubstanceUnits = kineticlawTmp.getSubstanceUnits();
            if (!(this.mathTextField.getText().equals(strMath) && this.timeUnitsTextField.getText().equals(strTimeUnits) && this.substanceUnitsTextField.getText().equals(strSubstanceUnits))) {
                return;
            }
            ListPanel panel = (ListPanel)this.listPanel[1];
            ListOf tableList = panel.getSBaseList();
            if (!(tableList != null && tableList.size() != 0L || this.parametersBackup != null && this.parametersBackup.size() != 0L)) {
                super.okButton_actionPerformed();
                return;
            }
            boolean isUpdated = false;
            panel.releaseSBaseList();
            panel.setSBaseList(this.parametersBackup);
            ParameterDialog dialog = (ParameterDialog)panel.getElementDialog();
            if (dialog == null) {
                dialog = new ParameterDialog();
            }
            if (tableList == null || tableList.size() == 0L) {
                panel.clearButtonActionInKineticLawDialog();
                isUpdated = true;
            } else if (this.parametersBackup == null || this.parametersBackup.size() == 0L) {
                int i = 0;
                while ((long)i < tableList.size()) {
                    Parameter newPara = (Parameter)tableList.get((long)i);
                    dialog.setDialogFromObject((SBase)newPara);
                    dialog.setNewObject();
                    dialog.superOkButton_actionPerformed();
                    ++i;
                }
                isUpdated = true;
            } else {
                int i = 0;
                while ((long)i < this.parametersBackup.size()) {
                    this.putParameterID(((Parameter)this.parametersBackup.get((long)i)).getId());
                    ++i;
                }
                Vector<Parameter> removedId = new Vector<Parameter>();
                int i2 = 0;
                while ((long)i2 < this.parametersBackup.size()) {
                    Parameter oldPara = (Parameter)this.parametersBackup.get((long)i2);
                    boolean isNotFound = true;
                    int j = 0;
                    while ((long)j < tableList.size()) {
                        Parameter newPara = (Parameter)tableList.get((long)j);
                        if (newPara.getId().equals(oldPara.getId())) {
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        removedId.add(oldPara);
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < removedId.size()) {
                    panel.removeButtonActionInKineticLawDialog((Parameter)removedId.get(i2));
                    if (!isUpdated) {
                        isUpdated = true;
                    }
                    ++i2;
                }
                i2 = 0;
                while ((long)i2 < tableList.size()) {
                    Parameter newPara = (Parameter)tableList.get((long)i2);
                    Parameter oldPara = null;
                    boolean isNotFound = true;
                    int j = 0;
                    while ((long)j < panel.getSBaseList().size()) {
                        oldPara = (Parameter)panel.getSBaseList().get((long)j);
                        if (newPara.getId().equals(oldPara.getId())) {
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        dialog.setDialogFromObject((SBase)newPara);
                        dialog.setNewObject();
                        dialog.superOkButton_actionPerformed();
                        if (!isUpdated) {
                            isUpdated = true;
                        }
                    } else if (!newPara.getName().equals(oldPara.getName()) || newPara.getValue() != oldPara.getValue() || !newPara.getUnits().equals(oldPara.getUnits()) || newPara.getConstant() != oldPara.getConstant()) {
                        dialog.setDialogFromObject((SBase)newPara);
                        dialog.setObject((SBase)oldPara);
                        dialog.superOkButton_actionPerformed();
                        if (!isUpdated) {
                            isUpdated = true;
                        }
                    }
                    ++i2;
                }
            }
            this.backupListOfParameters();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void cancelButton_actionPerformed() {
        if (this.isChanged) {
            if (this.listPanel[1].getSBaseList() != null) {
                this.listPanel[1].getSBaseList().delete();
            }
            this.listPanel[1].setSBaseList(this.parametersBackup);
            this.isChanged = false;
            this.parameterID.clear();
        }
        super.cancelButton_actionPerformed();
    }

    private void backupListOfParameters() {
        this.isChanged = false;
        this.parameterID.clear();
        if (this.listPanel[1] != null) {
            this.parametersBackup = this.listPanel[1].getSBaseList();
            ListOf ls = new ListOf();
            int i = 0;
            while ((long)i < this.parametersBackup.size()) {
                ls.append((SBase)((Parameter)this.parametersBackup.get((long)i)));
                this.putParameterID(((Parameter)this.parametersBackup.get((long)i)).getId());
                ++i;
            }
            this.listPanel[1].setSBaseList(ls);
        }
    }

    public void setHaveChangedFlag() {
        if (!this.isChanged) {
            this.isChanged = true;
        }
    }

    public void putParameterID(String id) {
        this.parameterID.put(id, "");
    }

    public void removeParameterID(String id) {
        this.parameterID.remove(id);
    }

    public void clearParameterID() {
        this.parameterID.clear();
    }

    public boolean isExistParameterID(String id) {
        return this.parameterID.containsKey(id);
    }

    protected int setDrawOrd(Vector aliases, Point2D.Double ord, boolean isModifier) {
        int max_value = 0;
        int x = (int)ord.x;
        int y = (int)ord.y;
        int i = 0;
        while (i < aliases.size()) {
            SpeciesAlias alias = (SpeciesAlias)aliases.get(i);
            if (!this.aliasesNameMap.containsKey(alias.getName())) {
                this.aliasesNameMap.put(alias.getName(), alias.getName());
                double original_x = alias.getFrameBounds().x;
                double original_y = alias.getFrameBounds().y;
                alias.setFramePosition(x, y);
                MonoSpeciesShape mono = (MonoSpeciesShape)alias.getGFramedShape();
                mono.setIDStringPosition(x, y - 10);
                alias.update();
                if (alias instanceof ComplexSpeciesAlias) {
                    ComplexSpeciesAlias complex = (ComplexSpeciesAlias)alias;
                    Vector allTargets = complex.getAllTargetsInMe(true);
                    int k = 0;
                    while (k < allTargets.size()) {
                        SpeciesAlias innerAlias = (SpeciesAlias)allTargets.get(k);
                        Rectangle2D.Double inner_bounds = innerAlias.getFrameBounds();
                        double sabun_x = inner_bounds.x - original_x;
                        double sabun_y = inner_bounds.y - original_y;
                        innerAlias.setFramePosition((double)x + sabun_x, (double)y + sabun_y);
                        innerAlias.update();
                        ++k;
                    }
                }
                if (isModifier) {
                    x = (int)((double)x + (alias.getFrameBounds().width + 10.0));
                    if ((double)max_value < alias.getFrameBounds().height) {
                        max_value = (int)alias.getFrameBounds().height;
                    }
                } else {
                    y = (int)((double)y + (alias.getFrameBounds().height + 30.0));
                    if ((double)max_value < alias.getFrameBounds().width) {
                        max_value = (int)alias.getFrameBounds().width;
                    }
                }
            }
            ++i;
        }
        ord.x = x;
        ord.y = y;
        return max_value;
    }

    public SpeciesAlias getSpeciesAlias(Vector atoms, Vector containeratoms, String name) {
        SpeciesAlias tmpAlias;
        int i;
        if (atoms != null) {
            i = 0;
            while (i < atoms.size()) {
                tmpAlias = (SpeciesAlias)atoms.get(i);
                if (tmpAlias.getName().equals(name)) {
                    return tmpAlias;
                }
                ++i;
            }
        }
        if (containeratoms != null) {
            i = 0;
            while (i < containeratoms.size()) {
                tmpAlias = (SpeciesAlias)containeratoms.get(i);
                if (tmpAlias.getName().equals(name)) {
                    return tmpAlias;
                }
                ++i;
            }
        }
        return null;
    }

    public void setMathTextField(String id) {
        if (this.mathPanel.isFocusBacktoMathTextField() || this.mathTextField.isEnabled() && this.mathTextField.hasFocus()) {
            if (id != null && !"".equals(id)) {
                Document doc = this.mathTextField.getDocument();
                int is = this.mathTextField.getSelectionStart();
                int ie = this.mathTextField.getSelectionEnd();
                if (is >= 0 && ie >= is) {
                    try {
                        doc.remove(is, ie - is);
                        doc.insertString(is, id, null);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            this.mathTextField.requestFocus();
        }
    }

    protected class KineticLawDialogMyDocumentListener
    extends SBaseDialog.MyDocumentListener {
        protected KineticLawDialogMyDocumentListener() {
            super(KineticLawDialog.this);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            KineticLawDialog.this.setHaveChangedFlag();
            KineticLawDialog.this.someFieldIsEdited();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            KineticLawDialog.this.setHaveChangedFlag();
            KineticLawDialog.this.someFieldIsEdited();
        }
    }

    class KineticLawPanel_mouseAdapter
    extends MouseAdapter {
        KineticLawDialog adaptee;

        KineticLawPanel_mouseAdapter(KineticLawDialog adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.adaptee.panel_mouseReleased(e, this.adaptee.isShowing());
        }
    }

    private class MyListListener
    extends Observable
    implements SBaseListPanelListener {
        int listNumber;

        public MyListListener(int i, KineticLawDialog kld) {
            this.addObserver(kld.getMathEditPanel());
            this.listNumber = i;
        }

        @Override
        public void elementAdded(SBase sbase) {
            try {
                KineticLawDialog.this.updateObject();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(KineticLawDialog.this, e.getMessage(), "Error", 2);
            }
        }

        @Override
        public void elementUpdated(SBase sbase, String[] oldValues) {
            try {
                KineticLawDialog.this.updateObject();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(KineticLawDialog.this, e.getMessage(), "Error", 2);
            }
        }

        @Override
        public void elementsRemoved(SBase[] sbases, int[] index) {
            try {
                KineticLawDialog.this.updateObject();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(KineticLawDialog.this, e.getMessage(), "Error", 2);
            }
        }

        @Override
        public void elementsSelected(SBase[] sbases) {
        }

        @Override
        public void elementsDeselected() {
            this.setChanged();
            this.notifyObservers(new ObservableAspect(9));
            this.clearChanged();
        }

        @Override
        public void elementMousePressed(SBase sb) {
            Parameter p = (Parameter)sb;
            this.setChanged();
            this.notifyObservers(new ObservableAspect(3, p));
            this.clearChanged();
        }

        @Override
        public void elementsDeselectedByList() {
        }
    }
}

