/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.miriam.MiriamUtils;
import jp.sbi.celldesigner.sbmlExtension.Notes;
import jp.sbi.celldesigner.sbmlExtension.ReactionAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.sbml.MiriamDefinition;
import jp.sbi.sbml.MiriamSubDefinition;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.PopupSettingDialog;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

class InnerSettingPanel
extends JPanel {
    private static final int START_X = 10;
    private static final int END_X = 180;
    private final int HEIGHT = 20;
    private final int SPACE = 20;
    private Dimension size;
    private ButtonGroup g;

    public InnerSettingPanel(String name) {
        this.setName(name);
        this.init();
    }

    private void init() {
        this.setLayout(null);
        int componentCount = 1;
        this.g = new ButtonGroup();
        if (PopupSettingDialog.listPanel[0].equals(this.getName())) {
            JRadioButton check1 = new JRadioButton("class");
            check1.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check1);
            this.g.add(check1);
            JRadioButton check3 = new JRadioButton("id");
            check3.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check3);
            this.g.add(check3);
            JRadioButton check15 = new JRadioButton("speciesType");
            check15.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check15);
            this.g.add(check15);
            JRadioButton check5 = new JRadioButton("compartment");
            check5.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check5);
            this.g.add(check5);
            JRadioButton check16 = new JRadioButton("included");
            check16.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check16);
            this.g.add(check16);
            JRadioButton check7 = new JRadioButton("initialQuantity");
            check7.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check7);
            this.g.add(check7);
            JRadioButton checkRateLaw = new JRadioButton("rateLaw");
            checkRateLaw.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(checkRateLaw);
            this.g.add(checkRateLaw);
            JRadioButton check8 = new JRadioButton("substanceUnits");
            check8.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check8);
            this.g.add(check8);
            JRadioButton check9 = new JRadioButton("spatialSizeUnits");
            this.g.add(check9);
            JRadioButton check10 = new JRadioButton("hasOnlySubstanceUnits");
            check10.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check10);
            this.g.add(check10);
            JRadioButton check11 = new JRadioButton("b.c.");
            check11.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check11);
            this.g.add(check11);
            JRadioButton check12 = new JRadioButton("charge");
            this.g.add(check12);
            JRadioButton check13 = new JRadioButton("constants");
            check13.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check13);
            this.g.add(check13);
            JRadioButton check14 = new JRadioButton("notes");
            check14.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check14);
            this.g.add(check14);
            JRadioButton checkMIRIAM = new JRadioButton("MIRIAM");
            checkMIRIAM.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(checkMIRIAM);
            this.g.add(checkMIRIAM);
            check3.setSelected(true);
        } else if (PopupSettingDialog.listPanel[1].equals(this.getName())) {
            JRadioButton check1 = new JRadioButton("type");
            check1.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check1);
            this.g.add(check1);
            JRadioButton check2 = new JRadioButton("id");
            check2.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check2);
            this.g.add(check2);
            JRadioButton check4 = new JRadioButton("reversible");
            check4.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check4);
            this.g.add(check4);
            JRadioButton check5 = new JRadioButton("fast");
            check5.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check5);
            this.g.add(check5);
            JRadioButton check6 = new JRadioButton("reactants");
            check6.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check6);
            this.g.add(check6);
            JRadioButton check7 = new JRadioButton("products");
            check7.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check7);
            this.g.add(check7);
            JRadioButton check8 = new JRadioButton("modifiers");
            check8.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check8);
            this.g.add(check8);
            JRadioButton check9 = new JRadioButton("math");
            check9.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check9);
            this.g.add(check9);
            JRadioButton check10 = new JRadioButton("notes");
            check10.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check10);
            this.g.add(check10);
            JRadioButton checkMIRIAM = new JRadioButton("MIRIAM");
            checkMIRIAM.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(checkMIRIAM);
            this.g.add(checkMIRIAM);
            check2.setSelected(true);
        } else if (PopupSettingDialog.listPanel[2].equals(this.getName())) {
            JRadioButton check1 = new JRadioButton("id");
            check1.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check1);
            this.g.add(check1);
            JRadioButton check12 = new JRadioButton("name");
            check12.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check12);
            this.g.add(check12);
            JRadioButton check11 = new JRadioButton("compartmentType");
            check11.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check11);
            this.g.add(check11);
            JRadioButton check3 = new JRadioButton("spatialDimensions");
            check3.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check3);
            this.g.add(check3);
            JRadioButton check4 = new JRadioButton("size");
            check4.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check4);
            this.g.add(check4);
            JRadioButton check5 = new JRadioButton("units");
            check5.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check5);
            this.g.add(check5);
            JRadioButton check6 = new JRadioButton("outside");
            check6.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check6);
            this.g.add(check6);
            JRadioButton check7 = new JRadioButton("constant");
            check7.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check7);
            this.g.add(check7);
            JRadioButton check10 = new JRadioButton("notes");
            check10.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(check10);
            this.g.add(check10);
            JRadioButton checkMIRIAM = new JRadioButton("MIRIAM");
            checkMIRIAM.setBounds(new Rectangle(10, 20 * componentCount++, 180, 20));
            this.add(checkMIRIAM);
            this.g.add(checkMIRIAM);
            check1.setSelected(true);
        }
        this.setSize(new Dimension(220, 20 * componentCount + 20 + 70));
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public void setSize(Dimension size) {
        this.size = size;
    }

    public String getSelectedRadioButtonString(SBase sbase) {
        if (sbase == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Enumeration<AbstractButton> e = this.g.getElements();
        while (e.hasMoreElements()) {
            JRadioButton b = (JRadioButton)e.nextElement();
            if (!b.isSelected()) continue;
            if (sbase instanceof Species) {
                Species sp = (Species)sbase;
                if (b.getText().equals("class")) {
                    SpeciesAnnotation anno = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)sp, null);
                    MonoSpeciesProperty p = (MonoSpeciesProperty)anno.getSpeciesProperty();
                    buf.append("class");
                    buf.append(":");
                    buf.append(p.getType());
                    break;
                }
                if (b.getText().equals("id")) {
                    buf.append("id");
                    buf.append(":");
                    buf.append(sp.getId());
                    break;
                }
                if (b.getText().equals("speciesType")) {
                    buf.append("speciesType");
                    buf.append(":");
                    buf.append(sp.getSpeciesType());
                    break;
                }
                if (b.getText().equals("compartment")) {
                    buf.append("compartment");
                    buf.append(":");
                    buf.append(sp.getCompartment());
                    break;
                }
                if (b.getText().equals("included")) {
                    SpeciesAnnotation anno = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)sp, null);
                    String strIncluded = "";
                    try {
                        strIncluded = ComplexSpeciesAlias.getMembersRelationStr(anno.getReferingAliases().get(0));
                    }
                    catch (Exception myErr) {
                        strIncluded = "";
                    }
                    buf.append("included");
                    buf.append(":");
                    buf.append(strIncluded);
                    break;
                }
                if (b.getText().equals("initialQuantity")) {
                    buf.append("initialQuantity");
                    buf.append(":");
                    if (sp.isSetInitialAmount()) {
                        buf.append(sp.getInitialAmount());
                        break;
                    }
                    if (sp.isSetInitialConcentration()) {
                        buf.append(sp.getInitialConcentration());
                        break;
                    }
                    buf.append("Undefined");
                    break;
                }
                if (b.getText().equals("substanceUnits")) {
                    buf.append("substanceUnits");
                    buf.append(":");
                    buf.append(sp.getSubstanceUnits());
                    break;
                }
                if (b.getText().equals("spatialSizeUnits")) {
                    buf.append("spatialSizeUnits");
                    buf.append(":");
                    buf.append(sp.getSpatialSizeUnits());
                    break;
                }
                if (b.getText().equals("hasOnlySubstanceUnits")) {
                    buf.append("hasOnlySubstanceUnits");
                    buf.append(":");
                    buf.append(sp.getHasOnlySubstanceUnits());
                    break;
                }
                if (b.getText().equals("b.c.")) {
                    buf.append("b.c.");
                    buf.append(":");
                    buf.append(sp.getBoundaryCondition());
                    break;
                }
                if (b.getText().equals("charge")) {
                    buf.append("charge");
                    buf.append(":");
                    buf.append(sp.getCharge());
                    break;
                }
                if (b.getText().equals("constants")) {
                    buf.append("constants");
                    buf.append(":");
                    buf.append(sp.getConstant());
                    break;
                }
                if (b.getText().equals("notes")) {
                    Notes notes = (Notes)LibSBMLUtil.getNotes((SBase)sp, null);
                    buf.append("notes");
                    buf.append(":");
                    buf.append(notes.getText());
                    break;
                }
                if (b.getText().equals("MIRIAM")) {
                    buf.append("MIRIAM");
                    buf.append(":");
                    buf.append(InnerSettingPanel.getMiriamDataFormat((SBase)sp));
                    break;
                }
                if (!b.getText().equals("rateLaw")) break;
                buf.append("d" + sp.getId() + "/dt = ");
                SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
                buf.append(sbModel.generateRateLawString(sp));
                break;
            }
            if (sbase instanceof Reaction) {
                Reaction re = (Reaction)sbase;
                if (b.getText().equals("type")) {
                    ReactionAnnotation anno = (ReactionAnnotation)LibSBMLUtil.getAnnotation((SBase)re, null);
                    buf.append("type");
                    buf.append(":");
                    buf.append(anno.getType());
                    break;
                }
                if (b.getText().equals("id")) {
                    buf.append("id");
                    buf.append(":");
                    buf.append(re.getId());
                    break;
                }
                if (b.getText().equals("reversible")) {
                    buf.append("reversible");
                    buf.append(":");
                    buf.append(re.getReversible());
                    break;
                }
                if (b.getText().equals("fast")) {
                    buf.append("fast");
                    buf.append(":");
                    buf.append(re.getFast());
                    break;
                }
                if (b.getText().equals("reactants")) {
                    buf.append("reactants");
                    buf.append(":");
                    int i = 0;
                    while ((long)i < re.getNumReactants()) {
                        buf.append(re.getReactant((long)i).getSpecies());
                        if ((long)(i + 1) < re.getNumReactants()) {
                            buf.append(",");
                        }
                        ++i;
                    }
                    break;
                }
                if (b.getText().equals("products")) {
                    buf.append("products");
                    buf.append(":");
                    int i = 0;
                    while ((long)i < re.getNumProducts()) {
                        buf.append(re.getProduct((long)i).getSpecies());
                        if ((long)(i + 1) < re.getNumProducts()) {
                            buf.append(",");
                        }
                        ++i;
                    }
                    break;
                }
                if (b.getText().equals("modifiers")) {
                    buf.append("modifiers");
                    buf.append(":");
                    int i = 0;
                    while ((long)i < re.getNumModifiers()) {
                        buf.append(re.getModifier((long)i).getSpecies());
                        if ((long)(i + 1) < re.getNumModifiers()) {
                            buf.append(",");
                        }
                        ++i;
                    }
                    break;
                }
                if (b.getText().equals("math")) {
                    buf.append("math");
                    buf.append(":");
                    if (re.getKineticLaw() == null) break;
                    buf.append(re.getKineticLaw().getFormula());
                    break;
                }
                if (b.getText().equals("notes")) {
                    Notes notes = (Notes)LibSBMLUtil.getNotes((SBase)re, null);
                    buf.append("notes");
                    buf.append(":");
                    buf.append(notes.getText());
                    break;
                }
                if (!b.getText().equals("MIRIAM")) break;
                buf.append("MIRIAM");
                buf.append(":");
                buf.append(InnerSettingPanel.getMiriamDataFormat((SBase)re));
                break;
            }
            if (!(sbase instanceof Compartment)) break;
            Compartment cm = (Compartment)sbase;
            if (b.getText().equals("id")) {
                buf.append("id");
                buf.append(":");
                buf.append(cm.getId());
                break;
            }
            if (b.getText().equals("name")) {
                buf.append("name");
                buf.append(":");
                buf.append(cm.getName());
                break;
            }
            if (b.getText().equals("compartmentType")) {
                buf.append("compartmentType");
                buf.append(":");
                buf.append(cm.getCompartmentType());
                break;
            }
            if (b.getText().equals("spatialDimensions")) {
                buf.append("spatialDimensions");
                buf.append(":");
                buf.append(cm.getSpatialDimensions());
                break;
            }
            if (b.getText().equals("size")) {
                buf.append("size");
                buf.append(":");
                buf.append(cm.getSize());
                break;
            }
            if (b.getText().equals("units")) {
                buf.append("units");
                buf.append(":");
                buf.append(cm.getUnits());
                break;
            }
            if (b.getText().equals("outside")) {
                buf.append("outside");
                buf.append(":");
                buf.append(cm.getOutside());
                break;
            }
            if (b.getText().equals("constant")) {
                buf.append("units");
                buf.append(":");
                buf.append(cm.getConstant());
                break;
            }
            if (b.getText().equals("notes")) {
                Notes notes = (Notes)LibSBMLUtil.getNotes((SBase)cm, null);
                buf.append("notes");
                buf.append(":");
                buf.append(notes.getText());
                break;
            }
            if (!b.getText().equals("MIRIAM")) break;
            buf.append("MIRIAM");
            buf.append(":");
            buf.append(InnerSettingPanel.getMiriamDataFormat((SBase)cm));
            break;
        }
        return buf.toString();
    }

    public static StringBuffer getMiriamDataFormat(SBase sbase) {
        StringBuffer miriam = new StringBuffer();
        if (sbase == null) {
            return miriam;
        }
        Vector vMiriam = LibSBMLUtil.getMiriamDatasFromAnnotationOfSBase(sbase);
        if (vMiriam == null) {
            return miriam;
        }
        int i = 0;
        while (i < vMiriam.size()) {
            MiriamDefinition def = (MiriamDefinition)vMiriam.elementAt(i);
            String strRelation = MiriamUtils.changeMiriamIdFormat(def.getRelation(), false);
            Vector vData = def.getDatas();
            int j = 0;
            while (j < vData.size()) {
                miriam.append("   ");
                MiriamSubDefinition subDef = (MiriamSubDefinition)vData.elementAt(j);
                String strDataType = MiriamUtils.changeMiriamIdFormat(subDef.strDataType, false);
                String strId = MiriamUtils.changeMiriamIdFormat(subDef.strId, false);
                miriam.append(strRelation);
                miriam.append(": ");
                miriam.append(strDataType);
                miriam.append(": ");
                miriam.append(strId);
                ++j;
            }
            ++i;
        }
        return miriam;
    }
}

