/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.MathEditPanel;
import jp.sbi.sbml.util.MathEditor;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.InitialAssignment;
import org.sbml.libsbml.ListOfInitialAssignments;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.libsbml;

public class InitialAssignmentDialog
extends SBaseDialog
implements MathEditor {
    private JRadioButton speciesRadio;
    private JRadioButton compartmentRadio;
    private JRadioButton parameterRadio;
    private JComboBox variableComboBox;
    private JTextField mathTextField;
    private MathEditPanel mathPanel;
    public static final String STR_SPECIES = "Species";
    public static final String STR_COMPARTMENT = "Compartment";
    public static final String STR_PARAMETER = "Parameter";

    public InitialAssignmentDialog() {
    }

    public InitialAssignmentDialog(Dialog owner) {
        super(owner);
    }

    public InitialAssignmentDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.LABEL_WIDTH = 80;
        this.BUTTON_MARGIN += 22;
        this.TEXT_WIDTH = 400;
        this.BUTTON_WIDTH = 90;
        this.setLayoutConstants();
        int yline = this.VERTICAL_MARGIN;
        JLabel variableTypeLabel = new JLabel("symbol type");
        variableTypeLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)variableTypeLabel, null);
        this.speciesRadio = new JRadioButton(STR_SPECIES);
        this.speciesRadio.addActionListener(new MyInitialButtonListener());
        this.speciesRadio.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT));
        this.speciesRadio.addActionListener(this.radioListener);
        this.speciesRadio.setEnabled(true);
        this.mainPanel.add((Component)this.speciesRadio, null);
        this.compartmentRadio = new JRadioButton(STR_COMPARTMENT);
        this.compartmentRadio.addActionListener(new MyInitialButtonListener());
        this.compartmentRadio.addActionListener(this.radioListener);
        this.compartmentRadio.setBounds(new Rectangle(this.TEXT_POSITION_X + this.BUTTON_WIDTH + this.BUTTON_MARGIN, yline, this.BUTTON_WIDTH + 30, this.LINE_HEIGHT));
        this.compartmentRadio.setEnabled(true);
        this.mainPanel.add((Component)this.compartmentRadio, null);
        this.parameterRadio = new JRadioButton(STR_PARAMETER);
        this.parameterRadio.addActionListener(new MyInitialButtonListener());
        this.parameterRadio.setBounds(new Rectangle(this.TEXT_POSITION_X + 2 * this.BUTTON_WIDTH + 2 * this.BUTTON_MARGIN, yline, this.BUTTON_WIDTH + 30, this.LINE_HEIGHT));
        this.parameterRadio.addActionListener(this.radioListener);
        this.parameterRadio.setEnabled(true);
        this.mainPanel.add((Component)this.parameterRadio, null);
        ButtonGroup variableTypeButtonGroup = new ButtonGroup();
        variableTypeButtonGroup.add(this.speciesRadio);
        variableTypeButtonGroup.add(this.compartmentRadio);
        variableTypeButtonGroup.add(this.parameterRadio);
        this.speciesRadio.setSelected(true);
        JLabel variableLabel = new JLabel("symbol");
        variableLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)variableLabel, null);
        this.variableComboBox = new JComboBox();
        this.variableComboBox.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.variableComboBox.setEditable(false);
        this.variableComboBox.addActionListener(this.radioListener);
        this.mainPanel.add((Component)this.variableComboBox, null);
        JLabel mathLabel = new JLabel("math");
        mathLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)mathLabel, null);
        this.mathPanel = new MathEditPanel();
        int mpheight = this.mathPanel.createUI(this.TEXT_WIDTH, this.LINE_HEIGHT, this.BASELINE_SKIP);
        this.mathPanel.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, mpheight));
        this.mathTextField = this.mathPanel.getTextField();
        this.mathTextField.setEditable(true);
        this.mathTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.mathPanel, null);
        this.BUTTON_POSITION_Y = yline += mpheight + this.BASELINE_SKIP - this.LINE_HEIGHT;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new InitialAssignment();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            this.speciesRadio.setSelected(true);
            this.resetVariableComboBox();
            return;
        }
        InitialAssignment ia = (InitialAssignment)sbase;
        String symbol = ia.getSymbol();
        String type = LibSBMLUtil.getInitialTypeString(ia);
        if (type.equals(STR_COMPARTMENT)) {
            this.compartmentRadio.setSelected(true);
        } else if (type.equals(STR_PARAMETER)) {
            this.parameterRadio.setSelected(true);
        } else {
            this.speciesRadio.setSelected(true);
        }
        this.resetVariableComboBox();
        this.variableComboBox.setSelectedItem(symbol);
        ASTNode math = ia.getMath();
        this.mathTextField.setText("");
        if (math != null) {
            this.mathTextField.setText(libsbml.formulaToString((ASTNode)math));
            this.mathTextField.setCaretPosition(libsbml.formulaToString((ASTNode)math).length());
        }
        this.mathPanel.clearSelectedItemText();
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        SBModel sbmodel = null;
        try {
            sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            if (sbmodel == null || sbmodel.getModel() == null) {
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        String symbol = (String)this.variableComboBox.getSelectedItem();
        String math = this.mathTextField.getText();
        if (!InitialAssignmentDialog.checkDialogInputed(sbmodel.getModel(), sbase, symbol, math)) {
            return;
        }
        InitialAssignment ia = (InitialAssignment)sbase;
        String strOldSymbol = new String(ia.getSymbol());
        ia.setSymbol(symbol);
        ia.setMath(libsbml.parseFormula((String)math));
        LibSBMLUtil.changetoAstTimeNode(ia.getMath());
        if (symbol != null && !symbol.equals(strOldSymbol)) {
            HashMap hashInitialAssignmentNotes = sbmodel.getHashInitialAssignmentNotes();
            this.changeNotesforIdChange(hashInitialAssignmentNotes, strOldSymbol, symbol);
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        if (this.mainPanel != null) {
            this.speciesRadio.setEnabled(isEnabled);
            this.compartmentRadio.setEnabled(isEnabled);
            this.parameterRadio.setEnabled(isEnabled);
            this.variableComboBox.setEnabled(isEnabled);
            this.mathTextField.setEditable(isEnabled);
        }
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    @Override
    public MathEditPanel getMathEditPanel() {
        return this.mathPanel;
    }

    private void resetVariableComboBox() {
        try {
            this.variableComboBox.removeAllItems();
            Vector list = new Vector();
            if (this.speciesRadio.isSelected()) {
                list = LibSBMLUtil.getIDListOfSpeciesOrCompartmentOrParameter(this.editingSBase, STR_SPECIES);
            } else if (this.compartmentRadio.isSelected()) {
                list = LibSBMLUtil.getIDListOfSpeciesOrCompartmentOrParameter(this.editingSBase, STR_COMPARTMENT);
            } else if (this.parameterRadio.isSelected()) {
                list = LibSBMLUtil.getIDListOfSpeciesOrCompartmentOrParameter(this.editingSBase, STR_PARAMETER);
            }
            int i = 0;
            while (i < list.size()) {
                this.variableComboBox.addItem(list.get(i));
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final boolean checkDialogInputed(Model model, SBase sbase, String id, String math) throws Exception {
        ListOfInitialAssignments list;
        if (model == null) {
            return false;
        }
        try {
            SId.check(id);
        }
        catch (Exception e) {
            throw new Exception("malformed [symbol] string");
        }
        InitialAssignment ia = (InitialAssignment)sbase;
        if (!id.equals(ia.getSymbol()) && (list = model.getListOfInitialAssignments()) != null && list.size() > 0L) {
            int i = 0;
            while ((long)i < list.size()) {
                InitialAssignment idmt = (InitialAssignment)list.get((long)i);
                String sbl = idmt.getSymbol();
                if (id.equals(sbl)) {
                    throw new Exception("malformed [symbol] string");
                }
                ++i;
            }
        }
        if (libsbml.parseFormula((String)math) == null) {
            throw new Exception("malformed [math] string");
        }
        if (LibSBMLUtil.haveConstantValueInMath(libsbml.parseFormula((String)math))) {
            throw new Exception(LibSBMLUtil.getHaveConstantValueInMathErroMessage("math"));
        }
        if (LibSBMLUtil.containsNamedASTNode(libsbml.parseFormula((String)math), id)) {
            throw new Exception("The value which you specified in [Symbol] cannot be used in [math]. ");
        }
        LibSBMLUtil.checkTheNumberOfArgumentsForFunctionDefinition(libsbml.parseFormula((String)math), model, null);
        return true;
    }

    protected class MyInitialButtonListener
    implements ActionListener {
        protected MyInitialButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InitialAssignmentDialog.this.resetVariableComboBox();
        }
    }
}

