/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.math.BigDecimal;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import jp.sbi.sbml.util.IconUtil;

class ImagePanel
extends JPanel {
    private Image image;
    private int drawStartX;
    private int drawStartY;
    private int IMAGE_SIZE_X;
    private int IMAGE_SIZE_Y;

    public ImagePanel(int image_size_x, int image_size_y) {
        this.IMAGE_SIZE_X = image_size_x;
        this.IMAGE_SIZE_Y = image_size_y;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.update(g2);
    }

    public void update(Graphics2D g) {
        if (this.image != null) {
            g.drawImage(this.image, this.drawStartX, this.drawStartY, this);
        }
    }

    public void setImage(String imagePath) {
        BigDecimal cents;
        this.image = imagePath == null || imagePath.equals("") || imagePath.equals("NonPredefinedFunction.png") ? new ImageIcon(imagePath).getImage() : IconUtil.getIcon(imagePath).getImage();
        int width = this.image.getWidth(this);
        int height = this.image.getHeight(this);
        double scale = 1.0;
        double scale1 = 1.0;
        double scale2 = 1.0;
        BigDecimal sum = new BigDecimal("0.00");
        if (this.IMAGE_SIZE_X / width < 1) {
            cents = new BigDecimal(this.IMAGE_SIZE_X);
            BigDecimal dwidth = new BigDecimal(width);
            sum = sum.add(cents.divide(dwidth, 3, 5));
            scale1 = sum.doubleValue();
        }
        if (this.IMAGE_SIZE_Y / height < 1) {
            sum = new BigDecimal("0.00");
            cents = new BigDecimal(this.IMAGE_SIZE_Y);
            BigDecimal dheight = new BigDecimal(height);
            sum = sum.add(cents.divide(dheight, 3, 5));
            scale2 = sum.doubleValue();
        }
        scale = scale1 >= scale2 ? scale2 : scale1;
        width = (int)((double)width * scale);
        height = (int)((double)height * scale);
        this.image = this.image.getScaledInstance(width, height, 4);
        this.drawStartX = (this.IMAGE_SIZE_X - width) / 2;
        this.drawStartY = (this.IMAGE_SIZE_Y - height) / 2;
    }

    public int getIMAGE_SIZE_X() {
        return this.IMAGE_SIZE_X;
    }

    public void setIMAGE_SIZE_X(int image_size_x) {
        this.IMAGE_SIZE_X = image_size_x;
    }

    public int getIMAGE_SIZE_Y() {
        return this.IMAGE_SIZE_Y;
    }

    public void setIMAGE_SIZE_Y(int image_size_y) {
        this.IMAGE_SIZE_Y = image_size_y;
    }
}

