/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.MathEditPanel;
import jp.sbi.sbml.util.MathEditor;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.FunctionDefinition;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.libsbml;

public class FunctionDefinitionDialog
extends SBaseDialog
implements MathEditor {
    private JTextField idTextField;
    private JTextField nameTextField;
    private JTextField argumentsTextField;
    private JTextField mathTextField;
    private MathEditPanel mathPanel;

    public FunctionDefinitionDialog() {
    }

    public FunctionDefinitionDialog(Dialog owner) {
        super(owner);
    }

    public FunctionDefinitionDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected JPanel createDialogPanel() {
        JLabel idLabel = new JLabel("id");
        this.idTextField = new JTextField();
        this.idTextField.setEditable(true);
        this.idTextField.getDocument().addDocumentListener(this.docListener);
        JLabel nameLabel = new JLabel("name");
        this.nameTextField = new JTextField();
        this.nameTextField.setEditable(true);
        this.nameTextField.getDocument().addDocumentListener(this.docListener);
        JLabel argumentsLabel = new JLabel("arguments");
        this.argumentsTextField = new JTextField();
        this.argumentsTextField.setEditable(true);
        this.argumentsTextField.getDocument().addDocumentListener(this.docListener);
        JLabel mathLabel = new JLabel("math");
        this.mathPanel = new MathEditPanel();
        this.mathTextField = this.mathPanel.getTextField();
        this.mathTextField.getDocument().addDocumentListener(this.docListener);
        this.LABEL_WIDTH = 70;
        this.TEXT_WIDTH = 400;
        this.setLayoutConstants();
        int x1 = this.HORIZONTAL_MARGIN;
        int x2 = this.TEXT_POSITION_X;
        int yline = this.VERTICAL_MARGIN;
        idLabel.setBounds(x1, yline, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.idTextField.setBounds(x2, yline, this.TEXT_WIDTH, this.LINE_HEIGHT);
        nameLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.nameTextField.setBounds(x2, yline, this.TEXT_WIDTH, this.LINE_HEIGHT);
        argumentsLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.argumentsTextField.setBounds(x2, yline, this.TEXT_WIDTH, this.LINE_HEIGHT);
        mathLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        int mpheight = this.mathPanel.createUI(this.TEXT_WIDTH, this.LINE_HEIGHT, this.BASELINE_SKIP);
        this.mathPanel.setBounds(new Rectangle(x2, yline, this.TEXT_WIDTH, mpheight));
        this.BUTTON_POSITION_Y = yline += mpheight + this.BASELINE_SKIP - this.LINE_HEIGHT;
        this.setDefaultButtonsLayout();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.mainPanel.add((Component)idLabel, null);
        this.mainPanel.add((Component)this.idTextField, null);
        this.mainPanel.add((Component)nameLabel, null);
        this.mainPanel.add((Component)this.nameTextField, null);
        this.mainPanel.add((Component)argumentsLabel, null);
        this.mainPanel.add((Component)this.argumentsTextField, null);
        this.mainPanel.add((Component)mathLabel, null);
        this.mainPanel.add((Component)this.mathPanel, null);
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new FunctionDefinition();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        FunctionDefinition fd = (FunctionDefinition)sbase;
        String id = fd.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        String name = fd.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
        String arguments = "";
        if (fd.getMath() != null) {
            arguments = LibSBMLUtil.getFunctionDefinitionArguments(fd.getMath());
        }
        this.argumentsTextField.setText(arguments);
        this.argumentsTextField.setCaretPosition(arguments.length());
        String math = "";
        if (fd.getMath() != null) {
            math = libsbml.formulaToString((ASTNode)LibSBMLUtil.getFunctionDefinitionMath(fd.getMath(), arguments));
        }
        this.mathTextField.setText(math);
        this.mathTextField.setCaretPosition(math.length());
        this.mathPanel.clearSelectedItemText();
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        FunctionDefinition fd = (FunctionDefinition)sbase;
        FunctionDefinition clone = fd.cloneObject();
        SBModel sbModel = null;
        try {
            sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            if (sbModel == null || sbModel.getModel() == null) {
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        String oldID = new String(fd.getId());
        String newID = new String(this.idTextField.getText());
        try {
            String id = this.idTextField.getText();
            SId.check(id);
            clone.setId(this.idTextField.getText());
        }
        catch (Exception e) {
            throw new Exception("malformed id string");
        }
        clone.setName(this.nameTextField.getText());
        String math = this.mathTextField.getText();
        try {
            if (libsbml.parseFormula((String)math) == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new Exception("malformed math string");
        }
        if (LibSBMLUtil.haveConstantValueInMath(libsbml.parseFormula((String)math))) {
            throw new Exception(LibSBMLUtil.getHaveConstantValueInMathErroMessage("math"));
        }
        String arguments = this.argumentsTextField.getText();
        try {
            ASTNode an = FunctionDefinitionDialog.getFunctionDefinitionMath(math, arguments);
            if (an == null) {
                throw new Exception("FunctionDefinition's math is null");
            }
            LibSBMLUtil.checkFunctionDefinitionArgument(an);
            this.setFunctionDefinitionMath(clone, math, arguments);
        }
        catch (Exception e) {
            String err = e.getMessage();
            throw new Exception(String.valueOf(err) + "\n" + "Arguments should be like \"x\" or \"x,y\" etc.");
        }
        LibSBMLUtil.checkTheNumberOfArgumentsForFunctionDefinition(libsbml.parseFormula((String)math), sbModel.getModel(), clone);
        fd.setId(this.idTextField.getText());
        fd.setName(this.nameTextField.getText());
        this.setFunctionDefinitionMath(fd, math, arguments);
        LibSBMLUtil.changetoAstTimeNode(fd.getMath());
        if (!newID.equals(oldID)) {
            HashMap hashFunctionNotes = sbModel.getHashFunctionNotes();
            this.changeNotesforIdChange(hashFunctionNotes, oldID, newID);
            LibSBMLUtil.replaceMathID(sbModel, oldID, newID, 4, "");
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.idTextField.setEnabled(isEnabled);
        this.nameTextField.setEnabled(isEnabled);
        this.argumentsTextField.setEditable(isEnabled);
        this.mathTextField.setEnabled(isEnabled);
        this.okButton.setEnabled(isEnabled);
        this.cancelButton.setEnabled(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    @Override
    public MathEditPanel getMathEditPanel() {
        return this.mathPanel;
    }

    public void setFunctionDefinitionMath(FunctionDefinition fd, String math, String arguments) {
        if (arguments == null || arguments.equals("")) {
            fd.setMath(libsbml.parseFormula((String)math));
        } else {
            String stringMath = "lambda(" + arguments + "," + math + ")";
            ASTNode node_debug = libsbml.parseFormula((String)stringMath);
            fd.setMath(libsbml.parseFormula((String)stringMath));
        }
    }

    public static ASTNode getFunctionDefinitionMath(String math, String arguments) {
        String stringMath = "lambda(" + arguments + "," + math + ")";
        return libsbml.parseFormula((String)stringMath);
    }
}

