/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.util.ObjectHistoryManager;
import jp.sbi.celldesigner.util.SBaseComparator;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ListDialog;
import jp.sbi.sbml.util.MathEditPanel;
import jp.sbi.sbml.util.MathEditPanel2;
import jp.sbi.sbml.util.MathEditor;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseListDialog;
import jp.sbi.sbml.util.SBaseListDialogListener;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.Delay;
import org.sbml.libsbml.Event;
import org.sbml.libsbml.EventAssignment;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Trigger;
import org.sbml.libsbml.libsbml;

public class EventDialog
extends SBaseDialog
implements MathEditor {
    public static final int LIST_OF_EVENTASSIGNMENTS = 0;
    public static final int SIZE_OF_LISTS = 1;
    private JTextField idTextField;
    private JTextField nameTextField;
    private JTextField triggerTextField;
    private JTextField delayTextField;
    private JTextField timeUnitsField;
    private JButton eventAssignmentButton;
    private JRadioButton useValuesFromTriggerTimeRadio;
    private JRadioButton useValuesFromTriggerTimeFalseRadio;
    private MathEditPanel2 mathPanel;
    private boolean[] isFirstShowing;
    private SBaseListDialog[] listDialog = new SBaseListDialog[1];
    private static String[] dialogClassName = new String[]{"EventAssignmentDialog"};
    private long lActionCounter = 0L;

    public EventDialog() {
        this.initListDialogs();
        this.initIsFirstShowing();
    }

    public EventDialog(Dialog owner) {
        super(owner);
        this.initListDialogs();
        this.initIsFirstShowing();
    }

    public EventDialog(Frame owner) {
        super(owner);
        this.initListDialogs();
        this.initIsFirstShowing();
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.LABEL_WIDTH = 65;
        this.TEXT_WIDTH = 400;
        this.setLayoutConstants();
        int yline = this.VERTICAL_MARGIN;
        JLabel idLabel = new JLabel("id");
        idLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)idLabel, null);
        this.idTextField = new JTextField();
        this.idTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.idTextField.setEditable(true);
        this.idTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.idTextField, null);
        JLabel nameLabel = new JLabel("name");
        nameLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)nameLabel, null);
        this.nameTextField = new JTextField();
        this.nameTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.nameTextField.setEditable(true);
        this.nameTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.nameTextField, null);
        JLabel triggerLabel = new JLabel("trigger");
        triggerLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)triggerLabel, null);
        this.mathPanel = new MathEditPanel2();
        int mpheight = this.mathPanel.createUI(this.TEXT_WIDTH, this.LINE_HEIGHT, this.BASELINE_SKIP);
        this.mathPanel.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, mpheight));
        this.triggerTextField = this.mathPanel.getTextField(1);
        this.triggerTextField.setEditable(true);
        this.triggerTextField.getDocument().addDocumentListener(this.docListener);
        this.delayTextField = this.mathPanel.getTextField(2);
        this.delayTextField.setEditable(true);
        this.delayTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.mathPanel, null);
        JLabel delayLabel = new JLabel("delay");
        delayLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline + mpheight - this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)delayLabel, null);
        yline += mpheight - this.LINE_HEIGHT;
        this.timeUnitsField = new JTextField();
        int LABEL_WIDTH_1 = 130;
        JLabel useLabel = new JLabel("useValuesFromTriggerTime");
        useLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH + LABEL_WIDTH_1, this.LINE_HEIGHT));
        this.useValuesFromTriggerTimeRadio = new JRadioButton("true");
        this.useValuesFromTriggerTimeRadio.addActionListener(this.radioListener);
        this.useValuesFromTriggerTimeRadio.setBounds(this.TEXT_POSITION_X + LABEL_WIDTH_1, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        this.useValuesFromTriggerTimeFalseRadio = new JRadioButton("false");
        this.useValuesFromTriggerTimeFalseRadio.addActionListener(this.radioListener);
        this.useValuesFromTriggerTimeFalseRadio.setBounds(this.TEXT_POSITION_X + this.BUTTON_WIDTH + this.BUTTON_MARGIN + LABEL_WIDTH_1, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        ButtonGroup group = new ButtonGroup();
        group.add(this.useValuesFromTriggerTimeRadio);
        group.add(this.useValuesFromTriggerTimeFalseRadio);
        this.mainPanel.add((Component)useLabel, null);
        this.mainPanel.add((Component)this.useValuesFromTriggerTimeRadio, null);
        this.mainPanel.add((Component)this.useValuesFromTriggerTimeFalseRadio, null);
        JLabel eventAssignmentLabel = new JLabel("listOfEventAssignments");
        eventAssignmentLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH + 90, this.LINE_HEIGHT));
        this.mainPanel.add(eventAssignmentLabel);
        this.eventAssignmentButton = new JButton("Show list..");
        this.eventAssignmentButton.setBounds(new Rectangle(this.TEXT_POSITION_X + this.TEXT_WIDTH - this.SHOW_LIST_BUTTON_WIDTH, yline, this.SHOW_LIST_BUTTON_WIDTH, this.LINE_HEIGHT));
        this.eventAssignmentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventDialog.this.listDlgButton_actionPerformed(0);
            }
        });
        this.eventAssignmentButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EventDialog.this.rootPane.setDefaultButton(EventDialog.this.eventAssignmentButton);
            }
        });
        this.mainPanel.add((Component)this.eventAssignmentButton, null);
        this.BUTTON_POSITION_Y = yline += this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new Event();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        Event ev = (Event)sbase;
        String id = ev.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        String name = ev.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
        String trigger = "";
        if (ev.getTrigger() != null) {
            trigger = libsbml.formulaToString((ASTNode)ev.getTrigger().getMath());
        }
        this.triggerTextField.setText(trigger);
        this.triggerTextField.setCaretPosition(trigger.length());
        String delay = "";
        if (ev.getDelay() != null) {
            delay = libsbml.formulaToString((ASTNode)ev.getDelay().getMath());
        }
        this.delayTextField.setText(delay);
        this.delayTextField.setCaretPosition(delay.length());
        String timeUnits = ev.getTimeUnits();
        this.timeUnitsField.setText(timeUnits);
        this.timeUnitsField.setCaretPosition(timeUnits.length());
        boolean useValuesFromTriggerTime = ev.getUseValuesFromTriggerTime();
        this.useValuesFromTriggerTimeRadio.setSelected(useValuesFromTriggerTime);
        this.useValuesFromTriggerTimeFalseRadio.setSelected(!useValuesFromTriggerTime);
        this.mathPanel.clearSelectedItemText();
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        if (!(sbase instanceof Event)) {
            return;
        }
        Event ev = (Event)sbase;
        SBModel sbModel = null;
        try {
            sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            if (sbModel == null || sbModel.getModel() == null) {
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        this.checkInputedValueInThisDialog(sbModel.getModel());
        if (ev.getNumEventAssignments() == 0L) {
            throw new Exception("One or more EventAssignments must be added.");
        }
        String oldID = new String(ev.getId());
        String newID = new String(this.idTextField.getText());
        ev.setId(this.idTextField.getText());
        ev.setName(this.nameTextField.getText());
        String trigger = this.triggerTextField.getText();
        ev.setTrigger(new Trigger(libsbml.parseFormula((String)trigger)));
        String delay = this.delayTextField.getText();
        if (delay == null || "".equals(delay.trim())) {
            ev.setDelay(null);
        } else {
            ev.setDelay(new Delay(libsbml.parseFormula((String)delay)));
        }
        ev.setTimeUnits(this.timeUnitsField.getText());
        if (ev.getDelay() != null) {
            LibSBMLUtil.changetoAstTimeNode(ev.getDelay().getMath());
        }
        if (ev.getTrigger() != null) {
            LibSBMLUtil.changetoAstTimeNode(ev.getTrigger().getMath());
        }
        if (!newID.equals(oldID)) {
            HashMap hashUnitNotes = sbModel.getHashEventNotes();
            this.changeNotesforIdChange(hashUnitNotes, oldID, newID);
        }
        boolean b2 = this.useValuesFromTriggerTimeRadio.isSelected();
        ev.setUseValuesFromTriggerTime(b2);
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.idTextField.setEnabled(isEnabled);
        this.nameTextField.setEnabled(isEnabled);
        this.triggerTextField.setEnabled(isEnabled);
        this.delayTextField.setEnabled(isEnabled);
        this.timeUnitsField.setEnabled(isEnabled);
        this.changeListDialogsEnablility(isEnabled);
        this.useValuesFromTriggerTimeRadio.setEnabled(isEnabled);
        this.useValuesFromTriggerTimeFalseRadio.setEnabled(isEnabled);
        this.okButton.setEnabled(isEnabled);
        this.cancelButton.setEnabled(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
        int i = 0;
        while (i < 1) {
            this.listDialog[i].releaseAll();
            this.listDialog[i] = null;
            this.listDialog = null;
            ++i;
        }
    }

    @Override
    protected boolean hasChildListDialog() {
        return true;
    }

    @Override
    protected void setChildDialogMode(int mode) {
        int i = 0;
        while (i < 1) {
            this.listDialog[i].setElementDialogMode(mode);
            if (mode == 1) {
                this.listDialog[i].setModal(true);
            } else {
                this.listDialog[i].setModal(false);
            }
            ++i;
        }
    }

    @Override
    protected void updateChildDialog() {
        int i = 0;
        while (i < 1) {
            SBaseListDialog listDlg = this.listDialog[i];
            if (listDlg != null) {
                listDlg.updateDialog();
            }
            ++i;
        }
    }

    private void initListDialogs() {
        int i = 0;
        while (i < 1) {
            block4: {
                this.listDialog[i] = new ListDialog(this);
                this.listDialog[i].setTitle(LibSBMLUtil.getListTagName("Event", i));
                this.listDialog[i].addSBaseListDialogListener(new MyListListener(i));
                SBaseDialog elementDialog = null;
                String dialogName = String.valueOf(this.getClass().getPackage().getName()) + "." + dialogClassName[i];
                SBaseListDialog owner = this.listDialog[i];
                try {
                    Constructor<?> con = Class.forName(dialogName).getConstructor(Class.forName("java.awt.Dialog"));
                    elementDialog = (SBaseDialog)con.newInstance(owner);
                }
                catch (Exception e) {
                    DebugPrinter.println(1, "UnitDefinitionDialog-initListDialogs-cannnot construct:" + dialogClassName[i] + " ,skip");
                    break block4;
                }
                if (elementDialog != null) {
                    elementDialog.setTitle(LibSBMLUtil.getElementClassName("Event", i));
                    this.listDialog[i].setElementDialog(elementDialog);
                }
            }
            ++i;
        }
        this.changeListDialogsEnablility(false);
    }

    private void changeListDialogsEnablility(boolean isEnabled) {
        int i = 0;
        while (i < 1) {
            if (!isEnabled) {
                this.listDialog[i].setSBaseList(null);
                this.listDialog[i].disableChildDialog();
            }
            ++i;
        }
    }

    private void setListDialogs(Event event) {
        this.changeListDialogsEnablility(event != null);
        if (event == null) {
            return;
        }
        int i = 0;
        while (i < 1) {
            this.listDialog[i].setSBaseList((ListOf)event.getListOfEventAssignments());
            ++i;
        }
    }

    private void listDlgButton_actionPerformed(int i) {
        this.showListDialog(i);
    }

    private void setListDialogPosition(int i) {
        if (this.listDialog[i] != null && this.isFirstShowing[i]) {
            Point p = this.getLocation();
            Dimension mysize = this.getSize();
            Dimension dlgsize = this.listDialog[i].getSize();
            int x = p.x + (mysize.width - dlgsize.width) / 2;
            int y = this.getLocation().y;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.listDialog[i].setLocation(x, y);
            this.isFirstShowing[i] = false;
        }
    }

    private void initIsFirstShowing() {
        this.isFirstShowing = new boolean[1];
        int i = 0;
        while (i < 1) {
            this.isFirstShowing[i] = true;
            ++i;
        }
    }

    private void showListDialog(int i) {
        this.setListDialogPosition(i);
        this.listDialog[i].show();
        if (this.listDialog[i].getElementDialog() != null) {
            this.listDialog[i].getElementDialog().setVisible(false);
        }
    }

    @Override
    public void setObject(SBase sbase) {
        if (!(sbase instanceof Event)) {
            return;
        }
        this.resettActionCounter();
        this.sbEditingBak = sbase;
        this.editingSBase = sbase.cloneObject();
        this.isNewObject = false;
        this.setListDialogs((Event)this.editingSBase);
    }

    @Override
    public void setNewObject() {
        this.resettActionCounter();
        super.setNewObject();
        this.setListDialogs((Event)super.getObject());
    }

    public SBaseListDialog getSBaseListDialog(int list_const) {
        if (list_const < 0 || list_const >= 1) {
            return null;
        }
        return this.listDialog[list_const];
    }

    @Override
    public MathEditPanel getMathEditPanel() {
        return this.mathPanel;
    }

    public long getActionCounter() {
        return this.lActionCounter;
    }

    public long givemeNextActionCounter() {
        return this.lActionCounter++;
    }

    public void resettActionCounter() {
        this.lActionCounter = 0L;
        int i = 0;
        while (i < this.listDialog.length) {
            if (this.listDialog[i] instanceof ListDialog) {
                ListDialog lstDialog = (ListDialog)this.listDialog[i];
                lstDialog.setSBaseList(new ListOf());
                lstDialog.setVisible(false);
                SBaseDialog elementDlg = lstDialog.getElementDialog();
                elementDlg.setObject(null);
                elementDlg.setVisible(false);
                break;
            }
            ++i;
        }
    }

    public void doEventDialogUpdate() {
        SBase[] sel;
        int iSizeOld;
        ListDialog lstDialog = null;
        int i = 0;
        while (i < this.listDialog.length) {
            if (this.listDialog[i] instanceof ListDialog) {
                lstDialog = (ListDialog)this.listDialog[i];
                break;
            }
            ++i;
        }
        if (lstDialog == null) {
            return;
        }
        if (!(this.isNewObject || this.sbEditingBak != null && this.sbEditingBak instanceof Event)) {
            return;
        }
        SBModel sbModel = null;
        try {
            sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            if (sbModel == null || sbModel.getModel() == null) {
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        try {
            this.checkInputedValueInThisDialog(sbModel.getModel());
        }
        catch (Exception myErr) {
            return;
        }
        Event eventReal = new Event();
        String[] oldValues = null;
        int iTmp01 = 0;
        if (!this.isNewObject) {
            eventReal = (Event)this.sbEditingBak;
            oldValues = LibSBMLUtil.toStrings(this.sbEditingBak);
            iTmp01 = (int)eventReal.getListOfEventAssignments().size();
        }
        int iRemnantedSize = iSizeOld = iTmp01;
        Event eventWork = (Event)this.editingSBase;
        int iSizeWork = (int)eventWork.getListOfEventAssignments().size();
        if (iSizeWork <= 0) {
            return;
        }
        boolean[] bDone = new boolean[iSizeWork];
        int i2 = 0;
        while (i2 < iSizeWork) {
            bDone[i2] = false;
            ++i2;
        }
        ObjectHistoryManager[] lstHis = lstDialog.getObjectHistoryManager();
        lstHis = ObjectHistoryManager.removeUselessHisData(lstHis);
        if (iSizeOld > 0) {
            int i3;
            int iInit = -1;
            int[] iWillBeRemoveRowId = new int[iSizeOld];
            int i4 = 0;
            while (i4 < iSizeOld) {
                iWillBeRemoveRowId[i4] = -1;
                ++i4;
            }
            int iWillBeRemoveCount = 0;
            int i5 = 0;
            while (i5 < lstHis.length) {
                if (lstHis[i5].getNewestMe() == null) {
                    ++iWillBeRemoveCount;
                    iWillBeRemoveRowId[i5] = i5;
                }
                ++i5;
            }
            if (iWillBeRemoveCount > 0) {
                int[] iToBeRemoveRowId = new int[iWillBeRemoveCount];
                SBase[] sbaseToBeRemoveRows = new SBase[iToBeRemoveRowId.length];
                i3 = 0;
                while (i3 < sbaseToBeRemoveRows.length) {
                    iToBeRemoveRowId[i3] = -1;
                    sbaseToBeRemoveRows[i3] = null;
                    ++i3;
                }
                int j = 0;
                int i6 = 0;
                while (i6 < iWillBeRemoveRowId.length) {
                    if (iWillBeRemoveRowId[i6] != -1) {
                        iToBeRemoveRowId[j] = iWillBeRemoveRowId[i6];
                        sbaseToBeRemoveRows[j] = eventReal.getListOfEventAssignments().get((long)i6);
                        ++j;
                    }
                    ++i6;
                }
                i6 = sbaseToBeRemoveRows.length - 1;
                while (i6 >= 0) {
                    LibSBMLUtil.removeSBase(sbaseToBeRemoveRows[i6], (ListOf)eventReal.getListOfEventAssignments());
                    --i6;
                }
            }
            iRemnantedSize = iSizeOld - iWillBeRemoveCount;
            int[] iRemnantedRowId = new int[iRemnantedSize];
            int k = 0;
            i3 = 0;
            while (i3 < iWillBeRemoveRowId.length) {
                if (iWillBeRemoveRowId[i3] == -1) {
                    iRemnantedRowId[k] = i3;
                    ++k;
                }
                ++i3;
            }
            i3 = iRemnantedRowId.length - 1;
            while (i3 >= 0) {
                try {
                    if (!ObjectHistoryManager.isHaveNotBeenUpdated(lstHis[iRemnantedRowId[i3]])) {
                        EventAssignment evaNew = eventReal.getListOfEventAssignments().get((long)i3);
                        EventAssignment evaValue = eventWork.getListOfEventAssignments().get((long)i3);
                        evaNew.setVariable(evaValue.getVariable());
                        evaNew.setMath(evaValue.getMath());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --i3;
            }
        }
        int i222 = iRemnantedSize;
        while (i222 < iSizeWork) {
            EventAssignment evaReal = eventReal.createEventAssignment();
            EventAssignment evaWork = eventWork.getListOfEventAssignments().get((long)i222);
            evaReal.setVariable(evaWork.getVariable());
            evaReal.setMath(evaWork.getMath());
            ++i222;
        }
        try {
            this.setObjectFromDialog((SBase)eventReal);
        }
        catch (Exception i222) {
            // empty catch block
        }
        if (this.isNewObject) {
            super.fireMainWinListeners(0, (SBase)eventReal, null);
        } else {
            super.fireMainWinListeners(1, (SBase)eventReal, oldValues);
        }
        SBase selected = null;
        if (this.parentpanel != null && (sel = this.parentpanel.getSelectedElements()).length == 1) {
            selected = sel[0];
        }
        if (selected != null) {
            this.setObject(selected);
        } else {
            this.setNewObject();
            this.updateDialog();
        }
        this.setVisible(false);
        this.closeAllChildDialogs();
    }

    public void initAndColoseAllOfDialogs() {
        SBase next = this.createInitialObject();
        this.setDialogFromObject(next);
        this.setVisible(false);
        this.resettActionCounter();
    }

    public void closeAllChildDialogs() {
        int i = 0;
        while (i < this.listDialog.length) {
            if (this.listDialog[i] instanceof ListDialog) {
                ListDialog lstDialog = (ListDialog)this.listDialog[i];
                lstDialog.setVisible(false);
                SBaseDialog elementDlg = lstDialog.getElementDialog();
                elementDlg.setVisible(false);
            }
            ++i;
        }
    }

    private void checkInputedValueInThisDialog(Model model) throws Exception {
        Event ev = new Event();
        try {
            String id = this.idTextField.getText();
            if (!"".equals(id)) {
                SId.check(id);
            }
            ev.setId(id);
        }
        catch (Exception myErr) {
            throw new Exception("malformed [id] string");
        }
        String trigger = this.triggerTextField.getText();
        try {
            if (libsbml.parseFormula((String)trigger) == null) {
                throw new Exception();
            }
        }
        catch (Exception myErr) {
            throw new Exception("malformed [trigger] string");
        }
        if (LibSBMLUtil.haveConstantValueInMath(libsbml.parseFormula((String)trigger))) {
            throw new Exception(LibSBMLUtil.getHaveConstantValueInMathErroMessage("trigger"));
        }
        LibSBMLUtil.checkTheNumberOfArgumentsForFunctionDefinition(libsbml.parseFormula((String)trigger), model, null);
        String delay = this.delayTextField.getText();
        if (!"".equals(delay)) {
            try {
                if (libsbml.parseFormula((String)delay) == null) {
                    throw new Exception();
                }
            }
            catch (Exception myErr) {
                throw new Exception("malformed [delay] string");
            }
            if (LibSBMLUtil.haveConstantValueInMath(libsbml.parseFormula((String)delay))) {
                throw new Exception(LibSBMLUtil.getHaveConstantValueInMathErroMessage("delay"));
            }
            LibSBMLUtil.checkTheNumberOfArgumentsForFunctionDefinition(libsbml.parseFormula((String)delay), model, null);
        }
        if (this.useValuesFromTriggerTimeFalseRadio.isSelected() && (delay == null || "".equals(delay))) {
            throw new Exception("If an Event\u2019s useValuesFromTriggerTime attribute has the \nvalue \u201cfalse\u201d, then the Event must contain a Delay element.");
        }
    }

    protected boolean hadThisID(ListOf lst, Event evt) {
        if (lst == null || lst.size() <= 0L) {
            return false;
        }
        if (this.idTextField == null || this.idTextField.getText() == null) {
            return false;
        }
        int i = 0;
        while ((long)i < lst.size()) {
            Event temp = (Event)lst.get((long)i);
            if (temp != null && temp.getId() != null && temp.getId().equals(this.idTextField.getText())) {
                if (evt == null) {
                    return true;
                }
                if (!SBaseComparator.equals((SBase)temp, (SBase)evt)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private class MyListListener
    implements SBaseListDialogListener {
        String listName = "";
        int listNumber;

        public MyListListener(int i) {
            this.listName = LibSBMLUtil.getListTagName("Event", i);
            this.listNumber = i;
        }

        @Override
        public void elementAdded(SBase sbase) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementAdded()");
            try {
                EventDialog.this.updateObject();
            }
            catch (Exception e) {
                DebugPrinter.println(1, "EventDialog.MyListListener.elementAdded: " + this.listName + " failed.");
            }
        }

        @Override
        public void elementUpdated(SBase sbase, String[] oldValues) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementUpdated()");
            try {
                EventDialog.this.updateObject();
            }
            catch (Exception e) {
                DebugPrinter.println(1, "EventDialog.MyListListener.elementUpdated: " + this.listName + " failed.");
            }
        }

        @Override
        public void elementsRemoved(SBase[] sbases, int[] index) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementsRemoved()" + sbases.length);
            try {
                EventDialog.this.updateObject();
            }
            catch (Exception e) {
                DebugPrinter.println(1, "EventDialog.MyListListener.elementsRemoved: " + this.listName + " failed.");
            }
        }

        @Override
        public void elementsSelected(SBase[] sbases) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementsSelected()" + sbases.length);
        }

        @Override
        public void elementsDeselected() {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementsDeselected()");
        }

        @Override
        public void dialogClosed() {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":dialogClosed()");
            EventDialog.this.listDialog[this.listNumber].setVisible(false);
        }

        @Override
        public void elementMousePressed(SBase sb) {
        }
    }
}

