/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.util.SBaseComparator;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.MathEditPanel;
import jp.sbi.sbml.util.MathEditor;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.EventAssignment;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.libsbml;

public class EventAssignmentDialog
extends SBaseDialog
implements MathEditor {
    private JTextField variableTextField;
    private JTextField mathTextField;
    private MathEditPanel mathPanel;

    public EventAssignmentDialog() {
    }

    public EventAssignmentDialog(Dialog owner) {
        super(owner);
    }

    public EventAssignmentDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.LABEL_WIDTH = 60;
        this.TEXT_WIDTH = 400;
        this.setLayoutConstants();
        int yline = this.VERTICAL_MARGIN;
        JLabel variableLabel = new JLabel("variable");
        variableLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)variableLabel, null);
        this.variableTextField = new JTextField();
        this.variableTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.variableTextField.setEditable(true);
        this.variableTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.variableTextField, null);
        JLabel mathLabel = new JLabel("math");
        mathLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)mathLabel, null);
        this.mathPanel = new MathEditPanel();
        int mpheight = this.mathPanel.createUI(this.TEXT_WIDTH, this.LINE_HEIGHT, this.BASELINE_SKIP);
        this.mathPanel.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, mpheight));
        this.mathTextField = this.mathPanel.getTextField();
        this.mathTextField.setEditable(true);
        this.mathTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.mathPanel, null);
        this.BUTTON_POSITION_Y = yline += mpheight + this.BASELINE_SKIP - this.LINE_HEIGHT;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new EventAssignment();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        EventAssignment ea = (EventAssignment)sbase;
        String variable = ea.getVariable();
        this.variableTextField.setText(variable);
        this.variableTextField.setCaretPosition(variable.length());
        String math = "";
        if (ea.getMath() != null) {
            math = libsbml.formulaToString((ASTNode)ea.getMath());
        }
        this.mathTextField.setText(math);
        this.mathTextField.setCaretPosition(math.length());
        this.mathPanel.clearSelectedItemText();
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        EventAssignment ea = (EventAssignment)sbase;
        SBModel sbModel = null;
        try {
            sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            if (sbModel == null || sbModel.getModel() == null) {
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        String variable = this.variableTextField.getText();
        try {
            SId.check(variable);
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed [variable] string");
        }
        String math = this.mathTextField.getText();
        try {
            if (libsbml.parseFormula((String)math) == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new Exception("malformed math string");
        }
        if (LibSBMLUtil.haveConstantValueInMath(libsbml.parseFormula((String)math))) {
            throw new Exception(LibSBMLUtil.getHaveConstantValueInMathErroMessage("math"));
        }
        LibSBMLUtil.checkTheNumberOfArgumentsForFunctionDefinition(libsbml.parseFormula((String)math), sbModel.getModel(), null);
        ea.setId(variable);
        ea.setMath(libsbml.parseFormula((String)math));
        LibSBMLUtil.changetoAstTimeNode(ea.getMath());
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.variableTextField.setEnabled(isEnabled);
        this.mathTextField.setEnabled(isEnabled);
        this.okButton.setEnabled(isEnabled);
        this.cancelButton.setEnabled(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    @Override
    public MathEditPanel getMathEditPanel() {
        return this.mathPanel;
    }

    protected boolean hadThisID(ListOf lst, EventAssignment evasgn) {
        if (lst == null || lst.size() <= 0L) {
            return false;
        }
        if (this.variableTextField == null || this.variableTextField.getText() == null) {
            return false;
        }
        int i = 0;
        while ((long)i < lst.size()) {
            EventAssignment temp = (EventAssignment)lst.get((long)i);
            if (temp != null && temp.getVariable() != null && temp.getVariable().equals(this.variableTextField.getText())) {
                if (evasgn == null) {
                    return true;
                }
                if (!SBaseComparator.equals((SBase)temp, (SBase)evasgn)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

