/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.MathEditPanel;
import jp.sbi.sbml.util.MathEditor;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.Constraint;
import org.sbml.libsbml.ListOfConstraints;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.XMLNode;
import org.sbml.libsbml.libsbml;

public class ConstraintDialog
extends SBaseDialog
implements MathEditor,
DocumentListener {
    public static final String URI_HTML = "http://www.w3.org/1999/xhtml";
    public static final String strErrmsgOfInvalidMessage = "There are forbidden characters in the input.\nThe rule is as follows. \n\n &  --> &amp; \n <  --> &lt; \n >  --> &gt; \n \"  --> &quot; \n\nPress [Yes], It will be changed automatically. \nPress [No],  It's possible to rewrite it by myself. \n\n";
    public static final String strXmlTag01_MsgOfConstraint = "message";
    public static final String strXmlTag02_MsgOfConstraint = "p";
    public static final String strXmlTag02NameSpace_MsgOfConstraint = "xmlns=\"http://www.w3.org/1999/xhtml\"";
    public static final String[][] arrXmlTag_MsgOfConstraint = new String[][]{{"message", ""}, {"p", "xmlns=\"http://www.w3.org/1999/xhtml\""}};
    public static final int iBadXmlTag = -1;
    public static final int iMaxNest = arrXmlTag_MsgOfConstraint.length + 3;
    private JTextArea textField;
    private JTextField mathTextField;
    private MathEditPanel mathPanel;

    public ConstraintDialog() {
    }

    public ConstraintDialog(Dialog owner) {
        super(owner);
    }

    public ConstraintDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.LABEL_WIDTH = 80;
        this.TEXT_WIDTH = 400;
        int offer = 16;
        int LABEL_LINE_HEIGHT = 14;
        int TEXT_AREA_HEIGHT_TOP = 16;
        int TEXT_AREA_HEIGHT_BOTTOM = 72;
        this.setLayoutConstants();
        int yline = this.VERTICAL_MARGIN;
        JLabel mathLabel = new JLabel("math");
        mathLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)mathLabel, null);
        this.mathPanel = new MathEditPanel();
        int mpheight = this.mathPanel.createUI(this.TEXT_WIDTH, this.LINE_HEIGHT, this.BASELINE_SKIP);
        this.mathPanel.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, mpheight));
        this.mathTextField = this.mathPanel.getTextField();
        this.mathTextField.setEditable(true);
        this.mathTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.mathPanel, null);
        JLabel msgLabel = new JLabel(strXmlTag01_MsgOfConstraint);
        msgLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += mpheight + this.BASELINE_SKIP - this.LINE_HEIGHT, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)msgLabel, null);
        JLabel beginHtmlLabel = new JLabel("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        beginHtmlLabel.setBounds(new Rectangle(this.TEXT_POSITION_X + offer, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)beginHtmlLabel, null);
        JLabel beginBodyLabel = new JLabel("<body>");
        beginBodyLabel.setBounds(new Rectangle(this.TEXT_POSITION_X + offer, yline += LABEL_LINE_HEIGHT, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)beginBodyLabel, null);
        this.textField = new JTextArea();
        this.textField.getDocument().addDocumentListener(this);
        JScrollPane scrollPane = new JScrollPane(this.textField);
        scrollPane.setAutoscrolls(true);
        scrollPane.setBounds(new Rectangle(this.TEXT_POSITION_X, yline += TEXT_AREA_HEIGHT_TOP, this.TEXT_WIDTH, mpheight));
        this.mainPanel.add((Component)scrollPane, null);
        JLabel endBodyLabel = new JLabel("</body>");
        endBodyLabel.setBounds(new Rectangle(this.TEXT_POSITION_X + offer, yline += TEXT_AREA_HEIGHT_BOTTOM, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)endBodyLabel, null);
        JLabel endHtmlLabel = new JLabel("</html>");
        endHtmlLabel.setBounds(new Rectangle(this.TEXT_POSITION_X + offer, yline += LABEL_LINE_HEIGHT, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)endHtmlLabel, null);
        this.BUTTON_POSITION_Y = yline += this.LINE_HEIGHT;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new Constraint();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        String strMsg;
        if (sbase == null) {
            return;
        }
        Constraint cnt = (Constraint)sbase;
        ASTNode math = cnt.getMath();
        this.mathTextField.setText("");
        if (math != null) {
            this.mathTextField.setText(libsbml.formulaToString((ASTNode)math));
            this.mathTextField.setCaretPosition(libsbml.formulaToString((ASTNode)math).length());
        }
        if ((strMsg = ConstraintDialog.getMsgStringOfConstraint(cnt)) == null) {
            strMsg = "";
        }
        this.textField.setText(strMsg);
        this.textField.setCaretPosition(strMsg.length());
        this.mathPanel.clearSelectedItemText();
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        boolean msgflag;
        if (sbase == null) {
            return;
        }
        SBModel sbmodel = null;
        try {
            sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            if (sbmodel == null || sbmodel.getModel() == null) {
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        Constraint cnt = (Constraint)sbase;
        String msgstr = this.textField.getText();
        ASTNode oldmath = cnt.getMath();
        String strOldMath = "";
        if (oldmath != null) {
            strOldMath = new String(libsbml.formulaToString((ASTNode)oldmath));
        }
        String math = this.mathTextField.getText();
        if (!ConstraintDialog.checkDialogInputed(sbmodel.getModel(), sbase, math, msgstr)) {
            return;
        }
        String msgstr2 = null;
        if (!"".equals(msgstr.trim())) {
            msgstr2 = msgstr;
        }
        if (!(msgflag = ConstraintDialog.resetMsgStringOfConstraint(cnt, msgstr2))) {
            throw new Exception("malformed [message] string");
        }
        cnt.setMath(libsbml.parseFormula((String)math));
        LibSBMLUtil.changetoAstTimeNode(cnt.getMath());
        if (math != null && !math.equals(strOldMath)) {
            HashMap hashConstraintNotes = sbmodel.getHashConstraintNotes();
            this.changeNotesforIdChange(hashConstraintNotes, strOldMath, math);
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        if (this.mainPanel != null) {
            this.textField.setEditable(isEnabled);
            this.mathTextField.setEditable(isEnabled);
        }
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    @Override
    public MathEditPanel getMathEditPanel() {
        return this.mathPanel;
    }

    public static final boolean checkDialogInputed(Model model, SBase sbase, String math, String msg) throws Exception {
        ListOfConstraints list;
        if (model == null) {
            return false;
        }
        if (libsbml.parseFormula((String)math) == null) {
            throw new Exception("malformed [math] string");
        }
        if (LibSBMLUtil.haveConstantValueInMath(libsbml.parseFormula((String)math))) {
            throw new Exception(LibSBMLUtil.getHaveConstantValueInMathErroMessage("math"));
        }
        Constraint cntt = (Constraint)sbase;
        String formatmath = libsbml.formulaToString((ASTNode)libsbml.parseFormula((String)math));
        String oldmath = "";
        if (cntt.getMath() != null) {
            oldmath = libsbml.formulaToString((ASTNode)cntt.getMath());
        }
        if (!formatmath.equals(oldmath) && (list = model.getListOfConstraints()) != null && list.size() > 0L) {
            int i = 0;
            while ((long)i < list.size()) {
                Constraint cnst = (Constraint)list.get((long)i);
                String strmath = libsbml.formulaToString((ASTNode)cnst.getMath());
                if (formatmath.equals(strmath)) {
                    throw new Exception("malformed [math] string");
                }
                ++i;
            }
        }
        if (!ConstraintDialog.checkMessage(msg)) {
            return false;
        }
        LibSBMLUtil.checkTheNumberOfArgumentsForFunctionDefinition(libsbml.parseFormula((String)math), model, null);
        return true;
    }

    public static final boolean checkMessage(String msg) throws Exception {
        if (msg == null) {
            return true;
        }
        String strMsgCopy = new String(msg);
        strMsgCopy = StringTool.substitute(strMsgCopy, "&amp;", "");
        strMsgCopy = StringTool.substitute(strMsgCopy, "&lt;", "");
        strMsgCopy = StringTool.substitute(strMsgCopy, "&gt;", "");
        if (!(strMsgCopy = StringTool.substitute(strMsgCopy, "&quot;", "")).matches("^\\s*$")) {
            if (strMsgCopy.indexOf("&") != -1 || strMsgCopy.indexOf("<") != -1 || strMsgCopy.indexOf(">") != -1 || strMsgCopy.indexOf("\"") != -1) {
                throw new Exception(strErrmsgOfInvalidMessage);
            }
            XMLNode xn = XMLNode.convertStringToXMLNode((String)msg);
            if (xn == null) {
                String errmsg = "Invalid XHTML string.\nPlease make sure that the notes string is a well-formed XML string\nwhich can be contained in a <body> tag.\n";
                throw new Exception(errmsg);
            }
        }
        return true;
    }

    public static final boolean resetMsgStringOfConstraint(Constraint cnst, String msg) throws Exception {
        String strmsg = "";
        if (cnst == null) {
            return false;
        }
        if (msg == null || "".equals(msg.trim())) {
            cnst.setMessage(null);
            return true;
        }
        strmsg = new String(msg);
        StringBuffer buf = new StringBuffer();
        buf.append("<message>");
        buf.append("<p xmlns=\"http://www.w3.org/1999/xhtml\">");
        buf.append(StringTool.toEscape(StringTool.toNonEscape(strmsg)));
        buf.append("</p>");
        buf.append("</message>");
        XMLNode msgNode = null;
        try {
            msgNode = XMLNode.convertStringToXMLNode((String)buf.toString());
            if (msgNode == null) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        Constraint cnstTmp = new Constraint();
        cnstTmp.setMessage(msgNode);
        cnst.setMessage(msgNode);
        return true;
    }

    public static final String getMsgStringOfConstraint(Object obj) {
        return ConstraintDialog.getMsgStringOfConstraint(obj, 0);
    }

    private static final String getMsgStringOfConstraint(Object obj, int cnt) {
        if (cnt >= iMaxNest) {
            return null;
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof Constraint) {
            Constraint cnst = (Constraint)obj;
            if (cnst.getMessage() == null) {
                return null;
            }
            return ConstraintDialog.getMsgStringOfConstraint(cnst.getMessage(), cnt++);
        }
        if (obj instanceof XMLNode) {
            XMLNode node = (XMLNode)obj;
            if (ConstraintDialog.checkMsgXmlTagOfConstraint(node.getName()) == -1) {
                XMLNode child = node.getChild(0L);
                if (child != null && ConstraintDialog.checkMsgXmlTagOfConstraint(child.getName()) != -1) {
                    return ConstraintDialog.getMsgStringOfConstraint(child, cnt++);
                }
                try {
                    return XMLNode.convertXMLNodeToString((XMLNode)node);
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return ConstraintDialog.getMsgStringOfConstraint(node.getChild(0L), cnt++);
        }
        if (obj instanceof String) {
            return new String((String)obj);
        }
        return null;
    }

    public static final int checkMsgXmlTagOfConstraint(String tag) {
        if (tag == null) {
            return -1;
        }
        int i = 0;
        while (i < arrXmlTag_MsgOfConstraint.length) {
            if (tag.equals(arrXmlTag_MsgOfConstraint[i][0])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getMathText() {
        if (this.mathTextField == null) {
            return null;
        }
        return this.mathTextField.getText();
    }

    public String getMsgText() {
        if (this.textField == null) {
            return null;
        }
        return this.textField.getText();
    }

    public void setMsgText(String msg) {
        if (this.textField == null) {
            return;
        }
        if (msg == null) {
            this.textField.setText("");
        } else {
            this.textField.setText(msg);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.someFieldIsEdited();
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.someFieldIsEdited();
    }
}

