/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.util.KineticLawFormulaEvaluator;
import jp.sbi.sbml.util.SBaseDialog;
import org.sbml.libsbml.AssignmentRule;
import org.sbml.libsbml.SBase;

public class CompartmentVolumeRuleDialog
extends SBaseDialog {
    private JTextField formulaTextField;
    private JTextField typeTextField;
    private JTextField compartmentTextField;

    public CompartmentVolumeRuleDialog() {
    }

    public CompartmentVolumeRuleDialog(Dialog owner) {
        super(owner);
    }

    public CompartmentVolumeRuleDialog(Frame owner) {
        super(owner);
    }

    public void setDialogByArg(String formula, String type, String compartment) {
        this.formulaTextField.setText(formula);
        this.typeTextField.setText(type);
        this.compartmentTextField.setText(compartment);
    }

    @Override
    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        JLabel formulaLabel = new JLabel("formula");
        formulaLabel.setBounds(new Rectangle(10, 10, 120, 20));
        this.mainPanel.add((Component)formulaLabel, null);
        this.formulaTextField = new JTextField();
        this.formulaTextField.setBounds(new Rectangle(105, 10, 300, 20));
        this.formulaTextField.setEditable(true);
        this.formulaTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.formulaTextField, null);
        JLabel typeLabel = new JLabel("type");
        typeLabel.setBounds(new Rectangle(10, 34, 120, 20));
        this.mainPanel.add((Component)typeLabel, null);
        this.typeTextField = new JTextField();
        this.typeTextField.setBounds(new Rectangle(105, 34, 300, 20));
        this.typeTextField.setEditable(true);
        this.typeTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.typeTextField, null);
        JLabel compartmentLabel = new JLabel("compartment");
        compartmentLabel.setBounds(new Rectangle(10, 58, 120, 20));
        this.mainPanel.add((Component)compartmentLabel, null);
        this.compartmentTextField = new JTextField();
        this.compartmentTextField.setBounds(new Rectangle(105, 58, 300, 20));
        this.compartmentTextField.setEditable(true);
        this.compartmentTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.compartmentTextField, null);
        this.LABEL_WIDTH = 90;
        this.TEXT_WIDTH = 300;
        this.setLayoutConstants();
        this.BUTTON_POSITION_Y = 10 + 4 * this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        AssignmentRule ar = new AssignmentRule();
        ar.setL1TypeCode(25);
        return ar;
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        AssignmentRule compartmentVolumeRule = (AssignmentRule)sbase;
        String formula = compartmentVolumeRule.getFormula();
        this.formulaTextField.setText(formula);
        this.formulaTextField.setCaretPosition(formula.length());
        String type = "compartmentVolumeRule.getType()";
        this.typeTextField.setText(type);
        this.typeTextField.setCaretPosition(type.length());
        String compartment = compartmentVolumeRule.getModel().getCompartment(compartmentVolumeRule.getVariable()).getName();
        this.compartmentTextField.setText(compartment);
        this.compartmentTextField.setCaretPosition(compartment.length());
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        AssignmentRule compartmentVolumeRule = (AssignmentRule)sbase;
        String str = this.formulaTextField.getText();
        try {
            new KineticLawFormulaEvaluator(str);
            compartmentVolumeRule.setFormula(str);
        }
        catch (Exception e) {
            throw new Exception("malformed formula string");
        }
        str = this.typeTextField.getText();
        compartmentVolumeRule.setL1TypeCode(25);
        str = this.compartmentTextField.getText();
        try {
            SId.check(str);
            compartmentVolumeRule.setVariable(str);
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed compartment string");
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.formulaTextField.setEnabled(isEnabled);
        this.typeTextField.setEnabled(isEnabled);
        this.compartmentTextField.setEnabled(isEnabled);
        this.okButton.setEnabled(isEnabled);
        this.cancelButton.setEnabled(true);
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }
}

