/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.util.CompareSId;
import jp.sbi.sbml.SId;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.SBMLPanelLists;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseListPanel;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.CompartmentType;
import org.sbml.libsbml.ListOfCompartmentTypes;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;

public class CompartmentDialog
extends SBaseDialog {
    private JTextField idTextField;
    private JTextField nameTextField;
    private JTextField spatialDimensionsTextField;
    private JTextField sizeTextField;
    private JTextField outsideTextField;
    private JRadioButton constantRadio;
    private JRadioButton constantFalseRadio;
    private JComboBox compartmentTypeCombo;
    private JComboBox unitsCombo;

    public CompartmentDialog() {
    }

    public CompartmentDialog(Dialog owner) {
        super(owner);
    }

    public CompartmentDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected JPanel createDialogPanel() {
        int maxLabelWidth;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        JLabel spatialDimensionsLabel = new JLabel("spatialDimensions");
        this.LABEL_WIDTH = maxLabelWidth = (int)spatialDimensionsLabel.getPreferredSize().getWidth();
        this.TEXT_WIDTH = 200;
        this.setLayoutConstants();
        int yline = this.VERTICAL_MARGIN;
        JLabel idLabel = new JLabel("id");
        idLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)idLabel, null);
        this.idTextField = new JTextField();
        this.idTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.idTextField.setEditable(true);
        this.idTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.idTextField, null);
        JLabel nameLabel = new JLabel("name");
        nameLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)nameLabel, null);
        this.nameTextField = new JTextField();
        this.nameTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.nameTextField.setEditable(true);
        this.nameTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.nameTextField, null);
        JLabel compartmentTypeLabel = new JLabel("compartmentType");
        compartmentTypeLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)compartmentTypeLabel, null);
        this.compartmentTypeCombo = new JComboBox();
        this.compartmentTypeCombo.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.compartmentTypeCombo.setEditable(false);
        this.compartmentTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemevent) {
                CompartmentDialog.this.okButton.setEnabled(true);
                CompartmentDialog.this.cancelButton.setEnabled(true);
            }
        });
        this.mainPanel.add((Component)this.compartmentTypeCombo, null);
        spatialDimensionsLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)spatialDimensionsLabel, null);
        this.spatialDimensionsTextField = new JTextField();
        this.spatialDimensionsTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.spatialDimensionsTextField.setEditable(true);
        this.spatialDimensionsTextField.getDocument().addDocumentListener(new SBaseDialog.MyDocumentListener(this){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (CompartmentDialog.this.spatialDimensionsTextField.getText() != null && CompartmentDialog.this.editingSBase instanceof Compartment) {
                    CompartmentDialog.this.setUnitsAndSizeFieldValue((Compartment)CompartmentDialog.this.editingSBase, CompartmentDialog.this.spatialDimensionsTextField.getText());
                }
                CompartmentDialog.this.someFieldIsEdited();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (CompartmentDialog.this.spatialDimensionsTextField.getText() != null && CompartmentDialog.this.editingSBase instanceof Compartment) {
                    CompartmentDialog.this.setUnitsAndSizeFieldValue((Compartment)CompartmentDialog.this.editingSBase, CompartmentDialog.this.spatialDimensionsTextField.getText());
                }
                CompartmentDialog.this.someFieldIsEdited();
            }
        });
        this.mainPanel.add((Component)this.spatialDimensionsTextField, null);
        JLabel sizeLabel = new JLabel("size");
        sizeLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)sizeLabel, null);
        this.sizeTextField = new JTextField();
        this.sizeTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.sizeTextField.setEditable(true);
        this.sizeTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.sizeTextField, null);
        JLabel unitsLabel = new JLabel("units");
        unitsLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)unitsLabel, null);
        this.unitsCombo = new JComboBox();
        this.unitsCombo.setEditable(false);
        this.unitsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemevent) {
                CompartmentDialog.this.okButton.setEnabled(true);
                CompartmentDialog.this.cancelButton.setEnabled(true);
            }
        });
        this.unitsCombo.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)this.unitsCombo, null);
        JLabel outsideLabel = new JLabel("outside");
        outsideLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)outsideLabel, null);
        this.outsideTextField = new JTextField();
        this.outsideTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.outsideTextField.setEditable(true);
        this.outsideTextField.getDocument().addDocumentListener(this.docListener);
        this.mainPanel.add((Component)this.outsideTextField, null);
        JLabel constantLabel = new JLabel("constant");
        constantLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)constantLabel, null);
        this.constantRadio = new JRadioButton("true");
        this.constantRadio.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT));
        this.constantRadio.addActionListener(this.radioListener);
        this.mainPanel.add((Component)this.constantRadio, null);
        this.constantFalseRadio = new JRadioButton("false");
        this.constantFalseRadio.setBounds(new Rectangle(this.TEXT_POSITION_X + this.BUTTON_WIDTH + this.BUTTON_MARGIN, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT));
        this.constantFalseRadio.addActionListener(this.radioListener);
        this.mainPanel.add((Component)this.constantFalseRadio, null);
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.constantRadio);
        bg1.add(this.constantFalseRadio);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (CompartmentDialog.this.constantRadio.hasFocus() || CompartmentDialog.this.constantFalseRadio.hasFocus()) {
                    switch (e.getKeyCode()) {
                        case 39: {
                            CompartmentDialog.this.constantFalseRadio.setSelected(true);
                            CompartmentDialog.this.constantFalseRadio.grabFocus();
                            break;
                        }
                        case 37: {
                            CompartmentDialog.this.constantRadio.setSelected(true);
                            CompartmentDialog.this.constantRadio.grabFocus();
                        }
                    }
                }
            }
        });
        this.BUTTON_POSITION_Y = yline += this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    @Override
    protected SBase createInitialObject() {
        return new Compartment();
    }

    @Override
    protected void setDialogFromObject(SBase sbase) {
        if (sbase == null) {
            return;
        }
        Compartment compartment = (Compartment)sbase;
        String id = compartment.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        String name = compartment.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
        String compartmentType = compartment.getCompartmentType();
        ListOfCompartmentTypes list = null;
        try {
            Model model = MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel();
            list = model.getListOfCompartmentTypes();
        }
        catch (Exception ex) {
            return;
        }
        this.compartmentTypeCombo.removeAllItems();
        this.compartmentTypeCombo.addItem("");
        this.compartmentTypeCombo.setSelectedIndex(0);
        if (list != null) {
            int i = 0;
            while ((long)i < list.size()) {
                this.compartmentTypeCombo.addItem(((CompartmentType)list.get((long)i)).getId());
                if (list.get((long)i).getId().equals(compartmentType)) {
                    this.compartmentTypeCombo.setSelectedIndex(i + 1);
                }
                ++i;
            }
        }
        String spatialDimensions = Long.toString(compartment.getSpatialDimensions());
        this.spatialDimensionsTextField.setText(spatialDimensions);
        this.spatialDimensionsTextField.setCaretPosition(spatialDimensions.length());
        this.setUnitsAndSizeFieldValue(compartment, spatialDimensions);
        String outside = compartment.getOutside();
        this.outsideTextField.setText(outside);
        this.outsideTextField.setCaretPosition(outside.length());
        boolean b1 = compartment.getConstant();
        this.constantRadio.setSelected(b1);
        this.constantFalseRadio.setSelected(!b1);
    }

    public void setDialogByArg(String size, String units) {
        this.sizeTextField.setText(size);
        this.sizeTextField.setCaretPosition(size.length());
    }

    @Override
    protected void setObjectFromDialog(SBase sbase) throws Exception {
        if (sbase == null) {
            return;
        }
        Compartment compartment = (Compartment)sbase;
        String str = this.idTextField.getText();
        try {
            SId.check(str);
            compartment.setId(str);
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed id string");
        }
        str = this.nameTextField.getText();
        compartment.setName(str);
        str = (String)this.compartmentTypeCombo.getSelectedItem();
        compartment.setCompartmentType(str);
        if (this.isShowing()) {
            str = (String)this.unitsCombo.getSelectedItem();
            if (str == null) {
                str = "";
            }
            compartment.setUnits(str);
        }
        int olddim = (int)compartment.getSpatialDimensions();
        str = this.spatialDimensionsTextField.getText();
        try {
            int dim = Integer.parseInt(str);
            if (dim < 0 || 3 < dim) {
                throw new Exception();
            }
            compartment.setSpatialDimensions((long)dim);
        }
        catch (Exception e) {
            throw new Exception("spatial dimensions must be an integer in [0--3]");
        }
        str = this.sizeTextField.getText();
        if (str.equals("")) {
            compartment.unsetSize();
        } else {
            try {
                double d = Double.parseDouble(str);
                compartment.setSize(d);
            }
            catch (NumberFormatException e) {
                throw new Exception("size must be a real");
            }
        }
        str = this.outsideTextField.getText();
        try {
            if (!str.equals("")) {
                SId.check(str);
            }
            compartment.setOutside(str);
        }
        catch (SIdFormatException e) {
            throw new Exception("malformed outside string");
        }
        boolean b1 = this.constantRadio.isSelected();
        compartment.setConstant(b1);
        boolean changeDefaultFlag = false;
        CompartmentDialog.changeUnitsOfSpeciesWhenCompartmentDimensionsChanged(compartment, changeDefaultFlag);
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        SBMLPanelLists sbmlPanelLists = sbModel.getSBMLPanelLists();
        SBaseListPanel spPanel = sbmlPanelLists.getSBaseListPanel(3);
        if (spPanel != null) {
            spPanel.updateDialog();
        }
    }

    @Override
    protected void setComponentsEnabled(boolean isEnabled) {
        this.idTextField.setEnabled(false);
        this.nameTextField.setEnabled(false);
        this.spatialDimensionsTextField.setEnabled(isEnabled);
        this.sizeTextField.setEnabled(isEnabled);
        this.unitsCombo.setEnabled(isEnabled);
        this.outsideTextField.setEnabled(false);
        this.constantRadio.setEnabled(isEnabled);
        this.constantFalseRadio.setEnabled(isEnabled);
        this.okButton.setEnabled(isEnabled);
        this.cancelButton.setEnabled(isEnabled);
    }

    @Override
    protected void releaseAllMembers() {
    }

    @Override
    protected boolean hasChildListDialog() {
        return false;
    }

    @Override
    protected void setChildDialogMode(int mode) {
    }

    @Override
    protected void updateChildDialog() {
    }

    private void setUnitsAndSizeFieldValue(Compartment compartment, String spatialDimensions) {
        if (compartment == null) {
            return;
        }
        if (spatialDimensions == null) {
            this.unitsCombo.setEnabled(false);
            this.unitsCombo.addItem("");
            this.sizeTextField.setEnabled(false);
            this.sizeTextField.setText("");
            return;
        }
        String strSelectedUnits = "";
        try {
            int dim = Integer.parseInt(spatialDimensions);
            if ((long)dim == compartment.getSpatialDimensions()) {
                strSelectedUnits = compartment.getUnits();
            }
        }
        catch (Exception dim) {
            // empty catch block
        }
        String[] strUnits = null;
        this.unitsCombo.removeAllItems();
        if (spatialDimensions.equals("1") || spatialDimensions.equals("2") || spatialDimensions.equals("3")) {
            List listItem;
            this.unitsCombo.setEnabled(true);
            ArrayList<String> templist = new ArrayList<String>();
            this.sizeTextField.setEnabled(true);
            this.setSizeTextFieldWhenInitAndSpatialDimensionsChange(compartment);
            int i = 0;
            strUnits = LibSBMLUtil.getUnitsForCompartment(spatialDimensions);
            if (strUnits != null) {
                while (i < strUnits.length) {
                    this.unitsCombo.addItem(strUnits[i]);
                    if (strUnits[i].equals(strSelectedUnits)) {
                        this.unitsCombo.setSelectedIndex(i + templist.size());
                    }
                    ++i;
                }
            }
            if ((listItem = CompartmentDialog.getListOfIdFromUnitDefinitions(spatialDimensions)).size() > 1) {
                Collections.sort(listItem, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return CompareSId.compareSId((String)o1, (String)o2);
                    }
                });
            }
            int cnt = 0;
            while (cnt < listItem.size()) {
                String strId = (String)listItem.get(cnt);
                if (!templist.contains(strId) && (spatialDimensions.equals("1") && !"length".equals(strId) || spatialDimensions.equals("2") && !"area".equals(strId) || spatialDimensions.equals("3") && !"volume".equals(strId))) {
                    this.unitsCombo.addItem(strId);
                    if (strId != null && strId.equals(strSelectedUnits)) {
                        this.unitsCombo.setSelectedIndex(i + templist.size());
                    }
                    templist.add(strId);
                }
                ++cnt;
            }
            if (this.unitsCombo.getSelectedIndex() == -1) {
                this.unitsCombo.setSelectedIndex(0);
            }
        } else {
            this.unitsCombo.setEnabled(false);
            this.unitsCombo.addItem("");
            this.sizeTextField.setEnabled(false);
            this.sizeTextField.setText("");
            return;
        }
    }

    private void setSizeTextFieldWhenInitAndSpatialDimensionsChange(Compartment compartment) {
        if (compartment == null) {
            this.sizeTextField.setText(Double.toString(1.0));
            this.sizeTextField.setCaretPosition(Double.toString(1.0).length());
            return;
        }
        if (!compartment.isSetSize()) {
            this.sizeTextField.setText(Double.toString(1.0));
            this.sizeTextField.setCaretPosition(Double.toString(1.0).length());
        } else {
            double size = compartment.getSize();
            String s1 = Double.toString(size);
            this.sizeTextField.setText(s1);
            this.sizeTextField.setCaretPosition(s1.length());
        }
    }

    public static void changeUnitsOfSpeciesWhenCompartmentDimensionsChanged(Compartment compartment, boolean changeDefault) {
    }

    public static List getListOfIdFromUnitDefinitions(String spatialDimensions) {
        ArrayList listItem = new ArrayList();
        List listmetre = new ArrayList();
        List listlitre = new ArrayList();
        List listDimensionless = new ArrayList();
        if (spatialDimensions != null && (spatialDimensions.equals("1") || spatialDimensions.equals("2") || spatialDimensions.equals("3"))) {
            listmetre = LibSBMLUtil.getListOfIdForCondition(21, Integer.parseInt(spatialDimensions), true);
            if (spatialDimensions != null && spatialDimensions.equals("3")) {
                listlitre = LibSBMLUtil.getListOfIdForCondition(17, 1, true);
            }
            listDimensionless = LibSBMLUtil.getListOfIdForCondition(5, 0, false);
            listItem.addAll(listmetre);
            listItem.addAll(listlitre);
            listItem.addAll(listDimensionless);
        }
        return listItem;
    }
}

