/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.debug;

import edu.caltech.sbw.SBWException;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import jp.sbi.celldesigner.MyFileManager;
import jp.sbi.celldesigner.SBMLControl;
import jp.sbi.sbml.LibraryInfo;
import jp.sbi.sbml.debug.DebugPrinter;
import jp.sbi.sbml.debug.FileSelector;
import jp.sbi.sbml.debug.XtendCommentTag;
import jp.sbi.sbml.debug.XtendCommentTagInput;
import jp.sbi.sbml.debug.XtendTypeTag;
import jp.sbi.sbml.debug.XtendTypeTagInput;
import jp.sbi.sbml.util.DefaultAnyFactory;
import jp.sbi.sbml.util.DefaultAnyInputFactory;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ModelDialog;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseDialogListener;
import jp.sbi.sbml.util.SBaseListDialog;
import jp.sbi.sbml.util.SBaseListDialogListener;
import jp.sbi.sbw.SBWUtil;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLReader;
import org.sbml.libsbml.SBMLWriter;
import org.sbml.libsbml.SBase;

public class SBMLEdit
extends JFrame
implements SBaseDialogListener {
    private SBMLDocument currentDocument = null;
    private ModelDialog modelDlg = null;
    private FileSelector fileSelector;
    private File currentDocumentPath = null;
    private SBaseListDialogListener[] listListener = new SBaseListDialogListener[12];
    private JMenuItem menuFileNew;
    private JMenuItem menuFileOpen;
    private JMenuItem menuFileClose;
    private JMenuItem menuFileSave;
    private JMenuItem menuFileSaveAs;
    private JMenu menuFileLevel;
    private JRadioButtonMenuItem itemLevel1;
    private JRadioButtonMenuItem itemLevel2;
    private static boolean isTagExtended = false;
    private static boolean isModeNonModal = false;
    private SBWUtil sbwUtil = null;
    private static String jarPath = "";
    private JMenu menuSBW;
    private boolean flagSBW = false;
    MyFileManager filem;

    static {
        System.loadLibrary("sbmlj");
    }

    public static void main(String[] argv) {
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-debugStream")) {
                DebugPrinter.setStreams(argv[++i]);
            }
            if (argv[i].equals("-debugLevel")) {
                ++i;
                try {
                    DebugPrinter.setLevel(Integer.parseInt(argv[i]));
                }
                catch (NumberFormatException e) {
                    System.out.println("-level must be a number");
                    System.exit(0);
                }
            }
            if (argv[i].endsWith("SBWCore.jar")) {
                jarPath = argv[i];
            }
            if (argv[i].equals("-tagExtend")) {
                isTagExtended = true;
            }
            if (argv[i].equals("-nonModal")) {
                isModeNonModal = true;
            }
            ++i;
        }
        DebugPrinter.startMessage();
        new SBMLEdit();
    }

    private void appExit() {
        DebugPrinter.close();
        if (this.flagSBW) {
            try {
                SBWUtil.disconnect();
            }
            catch (Exception e) {
                DebugPrinter.println(1, e.toString());
            }
        }
        System.exit(0);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.appExit();
        }
    }

    private SBMLEdit() {
        this.fileSelector = new FileSelector(this, new String[]{"xml"}, "SBML file");
        SBMLControl sbmlcontrol = new SBMLControl();
        if (isTagExtended) {
            DefaultAnyFactory aFactory = new DefaultAnyFactory();
            aFactory.addAny("org.sbml.libsbml.Model", 1001, new XtendCommentTag());
            aFactory.addAny("org.sbml.libsbml.Species", 1002, new XtendTypeTag());
            SBMLControl.factory = aFactory;
            DefaultAnyInputFactory aiFactory = new DefaultAnyInputFactory();
            aiFactory.addAnyInput("jp.sbi.sbml.util.ModelDialog", 1001, new XtendCommentTagInput());
            aiFactory.addAnyInput("jp.sbi.sbml.util.SpeciesDialog", 1002, new XtendTypeTagInput());
            SBaseDialog.setAnyInputFactory(aiFactory);
        }
        this.modelDlg = new ModelDialog(this);
        this.modelDlg.setTitle("Model");
        this.modelDlg.addSBaseDialogListener(this);
        int i = 0;
        while (i < 12) {
            this.listListener[i] = new MyListListener(i);
            SBaseListDialog listDlg = this.modelDlg.getSBaseListDialog(i);
            if (listDlg != null) {
                listDlg.addSBaseListDialogListener(this.listListener[i]);
            }
            ++i;
        }
        if (isModeNonModal) {
            this.modelDlg.setListElementDialogMode(2);
            DebugPrinter.println(1, "elementDialog=NOT modal");
        } else {
            DebugPrinter.println(1, "elementDialog=each modal");
        }
        this.sbwUtil = new SBWUtil();
        try {
            SBWUtil.connect();
            this.flagSBW = true;
        }
        catch (Exception e) {
            ((SBWException)e).handleWithDialog();
            DebugPrinter.println(1, e.toString());
            this.sbwUtil = null;
        }
        this.initFrame();
        this.modelDlg.setLocation(0, this.getLocation().y + this.getSize().height);
        this.setVisible(true);
    }

    private void initFrame() {
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Image iconImage = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("icon2.gif"));
        this.setIconImage(iconImage);
        this.setTitle("SBMLEdit " + LibraryInfo.getVersion());
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menuFile = new JMenu("File");
        menuFile.setMnemonic(70);
        menuBar.add(menuFile);
        this.menuFileNew = new JMenuItem("New", 78);
        menuFile.add(this.menuFileNew);
        this.menuFileNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.menuFileNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SBMLEdit.this.newFile();
            }
        });
        this.menuFileOpen = new JMenuItem("Open", 79);
        menuFile.add(this.menuFileOpen);
        this.menuFileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.menuFileOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SBMLEdit.this.openFile();
            }
        });
        this.menuFileClose = new JMenuItem("Close", 67);
        menuFile.add(this.menuFileClose);
        this.menuFileClose.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.menuFileClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SBMLEdit.this.closeFile();
            }
        });
        menuFile.addSeparator();
        this.menuFileSave = new JMenuItem("Save", 83);
        menuFile.add(this.menuFileSave);
        this.menuFileSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.menuFileSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SBMLEdit.this.saveFile();
            }
        });
        this.menuFileSaveAs = new JMenuItem("Save As", 65);
        menuFile.add(this.menuFileSaveAs);
        this.menuFileSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SBMLEdit.this.saveAsFile();
            }
        });
        menuFile.addSeparator();
        this.menuFileLevel = new JMenu("Level");
        this.menuFileLevel.setMnemonic(76);
        menuFile.add(this.menuFileLevel);
        ButtonGroup levelGroup = new ButtonGroup();
        this.itemLevel1 = new JRadioButtonMenuItem("Level1");
        this.itemLevel2 = new JRadioButtonMenuItem("Level2");
        levelGroup.add(this.itemLevel1);
        levelGroup.add(this.itemLevel2);
        this.menuFileLevel.add(this.itemLevel1);
        this.menuFileLevel.add(this.itemLevel2);
        this.itemLevel2.setSelected(true);
        this.itemLevel1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SBMLEdit.this.setLevel(e);
            }
        });
        this.itemLevel2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SBMLEdit.this.setLevel(e);
            }
        });
        menuFile.addSeparator();
        JMenuItem menuFileExit = new JMenuItem("Exit", 88);
        menuFile.add(menuFileExit);
        menuFileExit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        menuFileExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SBMLEdit.this.appExit();
            }
        });
        if (this.flagSBW) {
            this.menuSBW = new JMenu("SBW");
            this.menuSBW.setMnemonic(83);
            this.menuSBW.setEnabled(false);
            try {
                SBWUtil.registerJMenu(this.menuSBW);
                menuBar.add(this.menuSBW);
            }
            catch (Exception e) {
                DebugPrinter.println(1, e.toString());
                this.sbwUtil = null;
                this.flagSBW = false;
            }
        }
        JMenu menuHelp = new JMenu("Help");
        menuHelp.setMnemonic(72);
        menuBar.add(menuHelp);
        JMenuItem menuHelpInfo = new JMenuItem("Information", 77);
        menuHelp.add(menuHelpInfo);
        menuHelpInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SBMLEdit.this.showInformationDialog();
            }
        });
        this.setLocation(0, 0);
        this.pack();
        Dimension size = this.getSize();
        if (size.width < 288) {
            this.setSize(288, size.height);
        }
        this.setResizable(false);
        this.changeMenuEnability();
    }

    private void showInformationDialog() {
        Window comp = this;
        if (this.modelDlg != null && this.modelDlg.isShowing()) {
            comp = this.modelDlg;
        }
        String str = "";
        str = String.valueOf(str) + LibraryInfo.getLibraryName() + " ";
        str = String.valueOf(str) + LibraryInfo.getVersion() + "\n";
        str = String.valueOf(str) + LibraryInfo.getLastUpdatedDate() + "\n";
        str = String.valueOf(str) + LibraryInfo.getCopyright() + "\n";
        JOptionPane.showMessageDialog(comp, str, "About this library", 1);
        this.repaint();
    }

    private void changeMenuEnability() {
        if (this.currentDocument != null) {
            this.menuFileClose.setEnabled(true);
            this.menuFileSave.setEnabled(true);
            this.menuFileSaveAs.setEnabled(true);
            this.menuFileLevel.setEnabled(true);
        } else {
            this.menuFileClose.setEnabled(false);
            this.menuFileSave.setEnabled(false);
            this.menuFileSaveAs.setEnabled(false);
            this.menuFileLevel.setEnabled(false);
        }
    }

    @Override
    public void objectCreated(SBase sbase) {
    }

    @Override
    public void objectUpdated(SBase sbase, String[] oldValues) {
        String[] newValues = LibSBMLUtil.toStrings(sbase);
        String str = "objectUpdated()";
        int i = 0;
        while (i < newValues.length) {
            str = String.valueOf(str) + "," + oldValues[i] + "->" + newValues[i];
            ++i;
        }
        DebugPrinter.println(2, str);
    }

    @Override
    public void dialogCanceled(SBase sbase) {
        this.closeFile();
    }

    private void newFile() {
        this.currentDocument = new SBMLDocument();
        this.currentDocument.getNamespaces().add("xmlns:sbmledit", "http://www.sbml.org/2002/ns/sbmledit");
        this.itemLevel2.setSelected(true);
        this.modelDlg.setObject((SBase)this.currentDocument.getModel());
        this.modelDlg.updateDialog();
        this.currentDocumentPath = null;
        if (!this.modelDlg.isShowing()) {
            this.modelDlg.show();
        }
        this.changeMenuEnability();
        if (this.flagSBW) {
            this.menuSBW.setEnabled(true);
            SBWUtil.setCurrentDocument(this.currentDocument);
        }
    }

    private void openFile() {
        File selected = this.fileSelector.getOpenPath();
        if (selected != null) {
            try {
                this.currentDocument = new SBMLDocument();
                this.currentDocument.getNamespaces().add("sbmledit", "http://www.sbml.org/2002/ns/sbmledit");
                SBMLReader reader = new SBMLReader();
                this.currentDocument = reader.readSBML(selected.getAbsolutePath());
                LibSBMLUtil.setParameterAnnotation((ListOf)this.currentDocument.getModel().getListOfReactions());
                if (this.currentDocument.getLevel() == 1L) {
                    this.currentDocument.setLevelAndVersion(2L, 4L);
                }
                this.itemLevel2.setSelected(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "File read fault: " + e.getMessage(), "Error", 2);
                this.closeFile();
                return;
            }
            this.modelDlg.setObject((SBase)this.currentDocument.getModel());
            this.modelDlg.updateDialog();
            this.currentDocumentPath = selected;
            if (!this.modelDlg.isShowing()) {
                this.modelDlg.show();
            }
            if (this.flagSBW) {
                this.menuSBW.setEnabled(true);
                SBWUtil.setCurrentDocument(this.currentDocument);
            }
        }
        this.changeMenuEnability();
    }

    private void saveFile() {
        if (this.currentDocument == null) {
            return;
        }
        if (this.currentDocumentPath == null) {
            File selected = this.fileSelector.getSavePath();
            if (selected == null) {
                return;
            }
            this.currentDocumentPath = selected;
        }
        try {
            SBMLWriter writer = new SBMLWriter();
            writer.writeSBML(this.currentDocument, this.currentDocumentPath.getAbsolutePath());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "File write fault: " + e.getMessage(), "Error", 2);
            return;
        }
        this.changeMenuEnability();
    }

    private void saveAsFile() {
        File selected = this.fileSelector.getSavePath();
        if (selected != null) {
            this.currentDocumentPath = selected;
            this.saveFile();
        }
    }

    private void closeFile() {
        this.currentDocument = null;
        this.currentDocumentPath = null;
        this.modelDlg.dispose();
        this.changeMenuEnability();
        if (this.flagSBW) {
            this.menuSBW.setEnabled(false);
            SBWUtil.setCurrentDocument(null);
        }
    }

    private void setLevel(ActionEvent e) {
        if (e.getSource() == this.itemLevel1) {
            this.currentDocument.setLevelAndVersion(1L, 2L);
        } else {
            this.currentDocument.setLevelAndVersion(2L, 4L);
        }
    }

    private class MyListListener
    implements SBaseListDialogListener {
        String listName = "";
        int listNumber;

        public MyListListener(int i) {
            this.listName = LibSBMLUtil.getListTagName("Model", i);
            this.listNumber = i;
        }

        @Override
        public void elementAdded(SBase sbase) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementAdded()");
        }

        @Override
        public void elementUpdated(SBase sbase, String[] oldValues) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementUpdated()");
        }

        @Override
        public void elementsRemoved(SBase[] sbases, int[] index) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementsRemoved()" + sbases.length);
        }

        @Override
        public void elementsSelected(SBase[] sbases) {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementsSelected()" + sbases.length);
        }

        @Override
        public void elementsDeselected() {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":elementsDeselected()");
        }

        @Override
        public void dialogClosed() {
            DebugPrinter.println(2, String.valueOf(this.listName) + ":dialogClosed()");
            SBaseListDialog listDlg = SBMLEdit.this.modelDlg.getSBaseListDialog(this.listNumber);
            listDlg.setVisible(false);
        }

        @Override
        public void elementMousePressed(SBase sb) {
        }
    }
}

