/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.debug;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jp.sbi.sbml.debug.ExampleFileFilter;

class FileSelector {
    private JFrame owner;
    private JFileChooser chooser;
    private ExampleFileFilter filter;
    private String currentOpeningDir = ".";
    private String currentSavingDir = ".";
    private String[] suffixes;

    public FileSelector(JFrame owner, String[] suffixes, String desc) {
        this.owner = owner;
        this.suffixes = suffixes;
        this.chooser = new JFileChooser();
        this.filter = new ExampleFileFilter(suffixes, desc);
        this.chooser.addChoosableFileFilter(this.filter);
        this.chooser.setFileFilter(this.filter);
        this.chooser.setFileSelectionMode(0);
    }

    public File getOpenPath() {
        this.chooser.setCurrentDirectory(new File(this.currentOpeningDir));
        int ret = this.chooser.showOpenDialog(this.owner);
        File selected = this.chooser.getSelectedFile();
        if (ret != 0 || selected == null) {
            this.owner.repaint();
            return null;
        }
        if (selected.isDirectory()) {
            this.owner.repaint();
            return null;
        }
        this.currentOpeningDir = selected.getParent();
        this.owner.repaint();
        return selected;
    }

    public File getSavePath() {
        File sameNameFile;
        this.chooser.setCurrentDirectory(new File(this.currentSavingDir));
        int ret = this.chooser.showSaveDialog(this.owner);
        File selected = this.chooser.getSelectedFile();
        if (ret != 0 || selected == null) {
            this.owner.repaint();
            return null;
        }
        if (selected.isDirectory()) {
            this.owner.repaint();
            return null;
        }
        this.currentSavingDir = selected.getParent();
        String filepath = selected.getPath();
        boolean isEndWithSuffix = false;
        int i = 0;
        while (i < this.suffixes.length) {
            if (filepath.endsWith("." + this.suffixes[i])) {
                isEndWithSuffix = true;
                break;
            }
            ++i;
        }
        if (!isEndWithSuffix) {
            filepath = filepath.concat("." + this.suffixes[0]);
            selected = new File(filepath);
        }
        if ((sameNameFile = new File(selected.getPath())).exists()) {
            String title = "Same name exists";
            String msg = "Do you replace " + sameNameFile.getName() + "\uff1f";
            int ans = JOptionPane.showConfirmDialog(this.chooser, msg, title, 1, 3, null);
            if (ans != 0) {
                this.owner.repaint();
                return null;
            }
        }
        this.owner.repaint();
        return selected;
    }
}

