/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.sbi.sbml.autoLayout.AutoLayout;
import jp.sbi.sbml.autoLayout.AutoLayoutResult;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.ListOfCompartments;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.Species;

public class SimpleLayout
implements AutoLayout {
    private double SPACE = 25.0;
    private double S_WIDTH = 80.0;
    private double S_HEIGHT = 23.0;
    private double C_WIDTH = 160.0;
    private double C_HEIGHT = 50.0;

    @Override
    public AutoLayoutResult doLayout(Model model) {
        Vector<CDummyAlias> cDummyAliases = new Vector<CDummyAlias>();
        Vector<SDummyAlias> sDummyAliases = new Vector<SDummyAlias>();
        CDummyAlias rootDefault = new CDummyAlias("default");
        ListOfCompartments listOfCompartments = model.getListOfCompartments();
        int i = 0;
        while ((long)i < listOfCompartments.size()) {
            Compartment c = (Compartment)listOfCompartments.get((long)i);
            CDummyAlias cAlias = new CDummyAlias(c.getId());
            if (!c.getOutside().equals("")) {
                cAlias.setOutside(c.getOutside());
            }
            cDummyAliases.add(cAlias);
            ++i;
        }
        i = 0;
        while (i < cDummyAliases.size()) {
            CDummyAlias cAlias = (CDummyAlias)cDummyAliases.elementAt(i);
            String outside = cAlias.getOutside();
            if (outside.equals("")) {
                rootDefault.addChild(cAlias);
            } else {
                int k = 0;
                while (k < cDummyAliases.size()) {
                    CDummyAlias cda = (CDummyAlias)cDummyAliases.elementAt(k);
                    if (cda != cAlias && cda.getId().equals(outside)) {
                        cda.addChild(cAlias);
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        ListOfSpecies listOfSpecies = model.getListOfSpecies();
        int i2 = 0;
        while ((long)i2 < listOfSpecies.size()) {
            Species s = (Species)listOfSpecies.get((long)i2);
            SDummyAlias sAlias = new SDummyAlias();
            sDummyAliases.add(sAlias);
            String compartment = s.getCompartment();
            if (compartment.equals("")) {
                rootDefault.addChild(sAlias);
            } else {
                int k = 0;
                while (k < cDummyAliases.size()) {
                    CDummyAlias cda = (CDummyAlias)cDummyAliases.elementAt(k);
                    if (cda.getId().equals(compartment)) {
                        cda.addChild(sAlias);
                        break;
                    }
                    ++k;
                }
            }
            ++i2;
        }
        Point2D.Double rootSize = rootDefault.calcSize(0.0, 0.0);
        AutoLayoutResult result = new AutoLayoutResult();
        Dimension documentSize = new Dimension((int)Math.max(SimpleLayout.D_SIZE.x, rootSize.x), (int)Math.max(SimpleLayout.D_SIZE.y, rootSize.y));
        result.setDocumentSize(documentSize);
        int i3 = 0;
        while (i3 < cDummyAliases.size()) {
            CDummyAlias cAlias = (CDummyAlias)cDummyAliases.elementAt(i3);
            result.addCompartmentBounds(cAlias.getBounds());
            ++i3;
        }
        i3 = 0;
        while (i3 < sDummyAliases.size()) {
            SDummyAlias sAlias = (SDummyAlias)sDummyAliases.elementAt(i3);
            result.addSpeciesBounds(sAlias.getBounds());
            ++i3;
        }
        return result;
    }

    class CDummyAlias {
        private String id;
        private String outside = "";
        private Vector children = new Vector();
        private Rectangle2D.Double bounds = null;

        private CDummyAlias(String id) {
            this.id = id;
        }

        private String getId() {
            return this.id;
        }

        private void setOutside(String outside) {
            this.outside = outside;
        }

        private String getOutside() {
            return this.outside;
        }

        private void addChild(Object dummyAlias) {
            this.children.add(dummyAlias);
        }

        private Point2D.Double calcSize(double px, double py) {
            double myWidth = 0.0;
            double myHeight = 0.0;
            Point2D.Double nextChildPosition = new Point2D.Double(px + SimpleLayout.this.SPACE, py + SimpleLayout.this.SPACE);
            double currentLowWidth = 0.0;
            double currentLowHeight = 0.0;
            int i = 0;
            while (i < this.children.size()) {
                Object child = this.children.elementAt(i);
                currentLowWidth += SimpleLayout.this.SPACE;
                Point2D.Double childSize = child instanceof SDummyAlias ? ((SDummyAlias)child).calcSize(nextChildPosition.x, nextChildPosition.y) : ((CDummyAlias)child).calcSize(nextChildPosition.x, nextChildPosition.y);
                if (myWidth < (currentLowWidth += childSize.x)) {
                    myWidth = currentLowWidth;
                }
                if (currentLowHeight < childSize.y) {
                    if (currentLowHeight == 0.0) {
                        myHeight += SimpleLayout.this.SPACE;
                    }
                    myHeight += childSize.y - currentLowHeight;
                    currentLowHeight = childSize.y;
                }
                nextChildPosition.x += childSize.x + SimpleLayout.this.SPACE;
                if (nextChildPosition.x > SimpleLayout.D_SIZE.x) {
                    nextChildPosition.x = px + SimpleLayout.this.SPACE;
                    nextChildPosition.y = py + myHeight + SimpleLayout.this.SPACE;
                    currentLowWidth = 0.0;
                    currentLowHeight = 0.0;
                }
                ++i;
            }
            myWidth += SimpleLayout.this.SPACE;
            myHeight += SimpleLayout.this.SPACE;
            if (myWidth < SimpleLayout.this.C_WIDTH) {
                myWidth = SimpleLayout.this.C_WIDTH;
            }
            if (myHeight < SimpleLayout.this.C_HEIGHT) {
                myHeight = SimpleLayout.this.C_HEIGHT;
            }
            this.bounds = new Rectangle2D.Double(px, py, myWidth, myHeight);
            return new Point2D.Double(myWidth, myHeight);
        }

        private Rectangle2D.Double getBounds() {
            return this.bounds;
        }
    }

    class SDummyAlias {
        private Rectangle2D.Double bounds = null;

        private SDummyAlias() {
        }

        private Point2D.Double calcSize(double px, double py) {
            double rx = (Math.random() - 0.5) * 4.0;
            double ry = (Math.random() - 0.5) * 4.0;
            this.bounds = new Rectangle2D.Double(px + rx, py + ry, SimpleLayout.this.S_WIDTH, SimpleLayout.this.S_HEIGHT);
            return new Point2D.Double(SimpleLayout.this.S_WIDTH, SimpleLayout.this.S_HEIGHT);
        }

        private Rectangle2D.Double getBounds() {
            return this.bounds;
        }
    }
}

