/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import jp.fric.mathematics.geometry.plane.RingShape;
import jp.fric.mathematics.graph.Edge;
import jp.fric.mathematics.graph.GraphAnalyzer;
import jp.fric.mathematics.graph.Ring;
import jp.fric.mathematics.graph.UndirectedGraph;
import jp.fric.mathematics.graph.Vertex;
import jp.fric.statistics.Histogram;
import jp.fric.util.DebugPrinter;
import jp.fric.util.ProgramersException;
import jp.fric.util.Queue;
import jp.sbi.sbml.autoLayout.AutoLayout;
import jp.sbi.sbml.autoLayout.AutoLayoutResult;
import jp.sbi.sbml.autoLayout.CompartmentDummy;
import jp.sbi.sbml.autoLayout.DummyAlias;
import jp.sbi.sbml.autoLayout.NodeDummy;
import jp.sbi.sbml.autoLayout.SpeciesDummy;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.ListOfCompartments;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.ListOfSpeciesReferences;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.ModifierSpeciesReference;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesReference;

public class GraphLayout
implements AutoLayout {
    protected static final double SPACE = 40.0;
    protected static final double SPREAD = 1.5707963267948966;
    private double spread = 1.5707963267948966;
    private static final String DEFAULT = "default";

    @Override
    public AutoLayoutResult doLayout(Model model) throws Exception {
        ArrayList<CompartmentDummy> cDummies = new ArrayList<CompartmentDummy>();
        ArrayList<SpeciesDummy> sDummies = new ArrayList<SpeciesDummy>();
        ArrayList nDummies = new ArrayList();
        CompartmentDummy rootDefault = new CompartmentDummy(DEFAULT);
        UndirectedGraph allg = new UndirectedGraph();
        ListOfCompartments listOfCompartments = model.getListOfCompartments();
        int i = 0;
        while ((long)i < listOfCompartments.size()) {
            Compartment c = (Compartment)listOfCompartments.get((long)i);
            String cid = c.getId();
            if (cid.equals(DEFAULT)) {
                cDummies.add(rootDefault);
            } else {
                CompartmentDummy cDummy = new CompartmentDummy(cid);
                if (c.getOutside().equals("")) {
                    cDummy.setOutside(DEFAULT);
                } else {
                    cDummy.setOutside(c.getOutside());
                }
                cDummies.add(cDummy);
            }
            ++i;
        }
        ListIterator ili = cDummies.listIterator(0);
        block9: while (ili.hasNext()) {
            CompartmentDummy cDummy = (CompartmentDummy)ili.next();
            if (cDummy.getId().equals(DEFAULT)) continue;
            String outside = cDummy.getOutside();
            if (outside.equals(DEFAULT)) {
                rootDefault.addChild(cDummy);
                continue;
            }
            ListIterator jli = cDummies.listIterator(0);
            while (jli.hasNext()) {
                CompartmentDummy cd = (CompartmentDummy)jli.next();
                if (cd == cDummy || !cd.getId().equals(outside)) continue;
                cd.addChild(cDummy);
                continue block9;
            }
        }
        ListOfSpecies listOfSpecies = model.getListOfSpecies();
        int i2 = 0;
        while ((long)i2 < listOfSpecies.size()) {
            Species s = (Species)listOfSpecies.get((long)i2);
            String compartment = s.getCompartment();
            if (compartment.equals("")) {
                compartment = DEFAULT;
            }
            SpeciesDummy sDummy = new SpeciesDummy(s.getId());
            sDummy.setOutside(compartment);
            sDummies.add(sDummy);
            allg.addVertex(sDummy);
            if (compartment.equals(DEFAULT)) {
                rootDefault.addChild(sDummy);
            } else {
                ListIterator jli = cDummies.listIterator(0);
                boolean found = false;
                while (jli.hasNext()) {
                    CompartmentDummy cd = (CompartmentDummy)jli.next();
                    if (!cd.getId().equals(compartment)) continue;
                    cd.addChild(sDummy);
                    found = true;
                    break;
                }
                if (!found) {
                    throw new Exception("Compartment (id=" + compartment + ") of Species (id=" + s.getId() + ") was not found.");
                }
            }
            ++i2;
        }
        ListOfReactions listOfReactions = model.getListOfReactions();
        int i3 = 0;
        while ((long)i3 < listOfReactions.size()) {
            block36: {
                int psize;
                int rsize;
                int msize;
                ListOfSpeciesReferences modifiers;
                ListOfSpeciesReferences products;
                ListOfSpeciesReferences reactants;
                Reaction r;
                block37: {
                    r = (Reaction)listOfReactions.get((long)i3);
                    reactants = r.getListOfReactants();
                    products = r.getListOfProducts();
                    modifiers = r.getListOfModifiers();
                    msize = (int)modifiers.size();
                    rsize = (int)reactants.size();
                    psize = (int)products.size();
                    if (rsize == 0 || psize == 0) break block36;
                    if (rsize != 1 || psize != 1 || msize != 0) break block37;
                    String rStr = ((SpeciesReference)reactants.get(0L)).getSpecies();
                    SpeciesDummy rSD = null;
                    ListIterator li = sDummies.listIterator(0);
                    while (li.hasNext()) {
                        rSD = (SpeciesDummy)li.next();
                        if (rStr.equals(rSD.getId())) break;
                    }
                    String pStr = ((SpeciesReference)products.get(0L)).getSpecies();
                    SpeciesDummy pSD = null;
                    li = sDummies.listIterator(0);
                    while (li.hasNext()) {
                        pSD = (SpeciesDummy)li.next();
                        if (pStr.equals(pSD.getId())) break;
                    }
                    if (rSD == pSD) break block36;
                    try {
                        allg.addEdge(rSD, pSD);
                    }
                    catch (Exception exception) {}
                    break block36;
                }
                NodeDummy nDummy = new NodeDummy(r.getId());
                allg.addVertex(nDummy);
                Histogram comps = new Histogram();
                DummyAlias rSD = null;
                int j = 0;
                while (j < rsize) {
                    String rStr = ((SpeciesReference)reactants.get((long)j)).getSpecies();
                    ListIterator li = sDummies.listIterator(0);
                    while (li.hasNext()) {
                        rSD = (SpeciesDummy)li.next();
                        if (rStr.equals(rSD.getId())) break;
                    }
                    comps.add(rSD.getOutside());
                    try {
                        allg.addEdge(rSD, nDummy);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++j;
                }
                DummyAlias pSD = null;
                int j2 = 0;
                while (j2 < psize) {
                    String pStr = ((SpeciesReference)products.get((long)j2)).getSpecies();
                    ListIterator li = sDummies.listIterator(0);
                    while (li.hasNext()) {
                        pSD = (SpeciesDummy)li.next();
                        if (pStr.equals(pSD.getId())) break;
                    }
                    comps.add(pSD.getOutside());
                    try {
                        allg.addEdge(nDummy, pSD);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++j2;
                }
                DummyAlias mSD = null;
                int j3 = 0;
                while (j3 < msize) {
                    String mStr = ((ModifierSpeciesReference)modifiers.get((long)j3)).getSpecies();
                    ListIterator li = sDummies.listIterator(0);
                    while (li.hasNext()) {
                        mSD = (SpeciesDummy)li.next();
                        if (mStr.equals(mSD.getId())) break;
                    }
                    comps.add(mSD.getOutside());
                    try {
                        allg.addEdge(nDummy, mSD);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++j3;
                }
                Object[] obj = comps.getMode();
                String compartment = (String)obj[0];
                nDummy.setOutside(compartment);
                if (compartment.equals(DEFAULT)) {
                    rootDefault.addChild(nDummy);
                } else {
                    ListIterator jli = cDummies.listIterator(0);
                    while (jli.hasNext()) {
                        CompartmentDummy cd = (CompartmentDummy)jli.next();
                        if (!cd.getId().equals(compartment)) continue;
                        cd.addChild(nDummy);
                        break;
                    }
                }
            }
            ++i3;
        }
        allg.resetAllVertexTagsBy(-1);
        rootDefault.setTreeLevel(0);
        rootDefault.abstractLinks();
        rootDefault.setAllTreeTag(-1);
        this.setBoxSize(rootDefault);
        rootDefault.setParentPosition(new Point2D.Double());
        Point2D.Double rootSize = rootDefault.getBoxSize();
        DebugPrinter.println(2, "default compartment " + rootSize.x + " " + rootSize.y);
        AutoLayoutResult result = new AutoLayoutResult();
        Dimension documentSize = new Dimension((int)Math.max(GraphLayout.D_SIZE.x, rootSize.x), (int)Math.max(GraphLayout.D_SIZE.y, rootSize.y));
        result.setDocumentSize(documentSize);
        ListIterator li = cDummies.listIterator(0);
        while (li.hasNext()) {
            CompartmentDummy cd = (CompartmentDummy)li.next();
            result.addCompartmentBounds(cd.getBounds());
            DebugPrinter.println(2, String.valueOf(li.previousIndex()) + " : " + cd.getBounds().getX() + " " + cd.getBounds().getY() + " " + cd.getBounds().getWidth() + " " + cd.getBounds().getHeight());
        }
        li = sDummies.listIterator(0);
        while (li.hasNext()) {
            SpeciesDummy sd = (SpeciesDummy)li.next();
            result.addSpeciesBounds(sd.getBounds());
            DebugPrinter.println(2, String.valueOf(li.previousIndex()) + " : " + sd.getBounds().getX() + " " + sd.getBounds().getY() + " " + sd.getBounds().getWidth() + " " + sd.getBounds().getHeight());
        }
        return result;
    }

    public Point2D.Double setBoxSize(CompartmentDummy cDummy) {
        UndirectedGraph children = cDummy.getChildren();
        double area = 0.0;
        ListIterator li = children.listIterator(0);
        while (li.hasNext()) {
            Point2D.Double p;
            DummyAlias v = (DummyAlias)li.next();
            if (v instanceof CompartmentDummy) {
                this.setBoxSize((CompartmentDummy)v);
                p = v.getBoxSize();
                area += 0.08 * (p.x * p.y);
                continue;
            }
            if (!(v instanceof SpeciesDummy)) continue;
            p = v.getBoxSize();
            area += p.x * p.y;
        }
        area = Math.sqrt(area);
        double width = 4.0 * area;
        double height = 3.0 * area;
        try {
            this.structureLayout(cDummy);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Point2D.Double boxSize = cDummy.setBoxSize();
        DebugPrinter.println(2, "box size in setBoxSize " + boxSize.x + " " + boxSize.y);
        return boxSize;
    }

    private void structureLayout(CompartmentDummy cDummy) throws ProgramersException {
        UndirectedGraph ug;
        UndirectedGraph children = cDummy.getChildren();
        children.toConnectedSubgraphs();
        children.sortSubgraphsGreater();
        int subgraphsize = children.getNumberOfSubgraphs();
        DebugPrinter.println(2, "Number of subgraphs = " + subgraphsize);
        int index = 0;
        while (index < subgraphsize) {
            ug = (UndirectedGraph)children.getConnectedSubgraph(index);
            DebugPrinter.println(2, "subgraph: " + index + "  size: " + ug.size());
            try {
                GraphAnalyzer.ringRecognize(ug);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ug.sortRingsListGreater();
            ++index;
        }
        children.resetVertexTraversed();
        index = 0;
        while (index < subgraphsize) {
            ug = (UndirectedGraph)children.getConnectedSubgraph(index);
            ug.resetAllVertexTagsBy(index);
            ++index;
        }
        index = 0;
        while (index < subgraphsize) {
            ug = (UndirectedGraph)children.getConnectedSubgraph(index);
            LinkedList rings = new LinkedList(ug.getRingsList());
            Queue q = new Queue();
            DummyAlias prof = new NodeDummy("profile_default");
            prof.setRelativeCoordinateByCenter(new Point2D.Double(0.0, 0.0));
            DummyAlias root = null;
            if (rings.size() > 0) {
                root = (DummyAlias)((Ring)rings.get(0)).get(0);
            } else {
                int maxlinks = Integer.MIN_VALUE;
                int rootindex = 0;
                ListIterator ugli = ug.listIterator(0);
                while (ugli.hasNext()) {
                    int links = ((Vertex)ugli.next()).getNumberOfLinkedVertex();
                    if (maxlinks >= links) continue;
                    maxlinks = links;
                    rootindex = ugli.previousIndex();
                }
                root = (DummyAlias)ug.get(rootindex);
                if (maxlinks > 5) {
                    this.spread = Math.PI * 2;
                }
            }
            root.setRelativeCoordinateByCenter(new Point2D.Double(40.0, 40.0));
            q.append(root);
            while (!q.isEmpty()) {
                DummyAlias v = (DummyAlias)q.serve();
                if (v.getTag() != index) {
                    throw new ProgramersException("ERROR, appended a vertex in other graph, not connected to the current graph.");
                }
                if (v.isTraversed()) continue;
                v.traversed();
                if (v.isInRing()) {
                    boolean found = false;
                    int ring_it_index = 0;
                    do {
                        found = false;
                        Ring r = null;
                        ListIterator li = rings.listIterator(ring_it_index);
                        while (li.hasNext()) {
                            r = (Ring)li.next();
                            if (!r.includes(v)) continue;
                            ring_it_index = li.previousIndex();
                            found = true;
                            li.remove();
                            break;
                        }
                        if (!found) continue;
                        DummyAlias s = null;
                        boolean another = false;
                        ListIterator rli = r.listIterator(0);
                        while (rli.hasNext()) {
                            s = (DummyAlias)rli.next();
                            if (!s.isCoordinateSet() || s == v || s.getTag() != index) continue;
                            another = true;
                            break;
                        }
                        if (another) {
                            DebugPrinter.println(2, "ring vertical");
                            this.ringLayoutVerticalToLine(r, v, s);
                        } else {
                            RingShape rs = v.getRingShape();
                            if (rs != null) {
                                NodeDummy vc = new NodeDummy("v_ring_center");
                                vc.setRelativeCoordinateByCenter(rs.getCenter());
                                DebugPrinter.println(2, "ring from center of another ring as source");
                                this.ringLayoutFromSource(r, v, vc);
                            } else {
                                DummyAlias prev = null;
                                boolean prevfound = false;
                                ListIterator vli = v.listIterator(0);
                                while (vli.hasNext()) {
                                    prev = (DummyAlias)((Edge)vli.next()).getEndPoint();
                                    if (!prev.isTraversed() || prev.getTag() != index) continue;
                                    prevfound = true;
                                    break;
                                }
                                if (prevfound) {
                                    DebugPrinter.println(2, "ring from traversed source");
                                    this.ringLayoutFromSource(r, v, prev);
                                } else {
                                    DebugPrinter.println(2, "ring from profile");
                                    this.ringLayoutFromSource(r, v, prof);
                                }
                            }
                        }
                        rli = r.listIterator(0);
                        while (rli.hasNext()) {
                            DummyAlias da = (DummyAlias)rli.next();
                            if (da.isTraversed()) continue;
                            q.append(da);
                        }
                    } while (found);
                }
                ArrayList<DummyAlias> sector = new ArrayList<DummyAlias>();
                ListIterator eli = v.listIterator(0);
                while (eli.hasNext()) {
                    DummyAlias e = (DummyAlias)((Edge)eli.next()).getEndPoint();
                    if (e.getTag() != index || e.isCoordinateSet()) continue;
                    sector.add(e);
                }
                if (sector.size() > 0) {
                    if (v.getRingShape() != null) {
                        Point2D.Double c = v.getRingShape().getCenter();
                        NodeDummy center = new NodeDummy("ring_center");
                        center.setRelativeCoordinateByCenter(c);
                        DebugPrinter.println(2, "sector form ring center");
                        this.sectorLayout(sector, v, center);
                    } else {
                        DummyAlias prev = null;
                        boolean prevfound = false;
                        ListIterator vli = v.listIterator(0);
                        while (vli.hasNext()) {
                            prev = (DummyAlias)((Edge)vli.next()).getEndPoint();
                            if (!prev.isTraversed() || prev.getTag() != index) continue;
                            prevfound = true;
                            break;
                        }
                        if (prevfound) {
                            DebugPrinter.println(2, "sector form traversed");
                            this.sectorLayout(sector, v, prev);
                        } else {
                            DebugPrinter.println(2, "sector form profile");
                            this.sectorLayout(sector, v, prof);
                        }
                    }
                    ListIterator sli = sector.listIterator(0);
                    while (sli.hasNext()) {
                        DummyAlias da = (DummyAlias)sli.next();
                        if (da.isTraversed()) continue;
                        q.append(da);
                    }
                }
                prof = v;
            }
            cDummy.calcBounds(ug);
            ++index;
        }
        children.resetAllVertexTagsBy(-1);
    }

    private Point2D.Double ringLayoutFromSource(Ring r, DummyAlias v, DummyAlias s) {
        ArrayList<Double> arcList = new ArrayList<Double>();
        double round = 0.0;
        int linkedindex = 0;
        ListIterator li = r.listIterator(0);
        while (li.hasNext()) {
            DummyAlias da = (DummyAlias)li.next();
            double arc = 0.0;
            if (da == v) {
                linkedindex = li.previousIndex();
            }
            arc = 1.4 * da.getLargerBoxSize() + 40.0;
            arcList.add(new Double(arc));
            round += arc;
        }
        double radius = round / (Math.PI * 2);
        double rinv = 1.0 / radius;
        int ringsize = arcList.size();
        double[] anglestep = new double[ringsize];
        int i = 0;
        while (i < ringsize) {
            int iprevious = (i - 1 + ringsize) % ringsize;
            double arc = 0.5 * (Double)arcList.get(i) * rinv;
            int n = iprevious;
            anglestep[n] = anglestep[n] + arc;
            int n2 = i++;
            anglestep[n2] = anglestep[n2] + arc;
        }
        Point2D.Double vcenter = v.getRelativeCoordinateOfCenter();
        Point2D.Double scenter = s.getRelativeCoordinateOfCenter();
        double vx = vcenter.x;
        double vy = vcenter.y;
        double sx = scenter.x;
        double sy = scenter.y;
        double[] center = this.unitVector(vx, vy, sx, sy);
        center[0] = vx + center[0] * radius;
        center[1] = vy + center[1] * radius;
        RingShape rs = new RingShape(center[0], center[1], radius);
        double angleadjust = 0.0;
        int i2 = 0;
        while (i2 < linkedindex) {
            angleadjust += anglestep[i2];
            ++i2;
        }
        angleadjust = Math.PI - angleadjust + center[2];
        double theta = 0.0;
        li = r.listIterator(0);
        while (li.hasNext()) {
            DummyAlias da = (DummyAlias)li.next();
            if (!da.isCoordinateSet()) {
                double x = center[0] + radius * Math.cos(theta + angleadjust);
                double y = center[1] + radius * Math.sin(theta + angleadjust);
                da.setRelativeCoordinateByCenter(new Point2D.Double(x, y));
            }
            if (da.getRingShape() == null) {
                da.setRingShape(rs);
            }
            theta += anglestep[li.previousIndex()];
        }
        return new Point2D.Double(center[0], center[1]);
    }

    private Point2D.Double ringLayoutVerticalToLine(Ring r, DummyAlias v, DummyAlias s) {
        int rotation_sign;
        Point2D.Double center_v;
        int center_rotation;
        int index_order;
        int i;
        ArrayList<Double> arcList = new ArrayList<Double>();
        double round = 0.0;
        int vindex = 0;
        int sindex = 0;
        ListIterator li = r.listIterator(0);
        while (li.hasNext()) {
            DummyAlias da = (DummyAlias)li.next();
            double arc = 0.0;
            if (da == v) {
                vindex = li.previousIndex();
            } else if (da == s) {
                sindex = li.previousIndex();
            }
            arc = 1.4 * da.getLargerBoxSize() + 40.0;
            arcList.add(new Double(arc));
            round += arc;
        }
        double radius = round / (Math.PI * 2);
        double rinv = 1.0 / radius;
        int ringsize = arcList.size();
        double[] anglestep = new double[ringsize];
        int i2 = 0;
        while (i2 < ringsize) {
            int iprevious = (i2 - 1 + ringsize) % ringsize;
            double arc = 0.5 * (Double)arcList.get(i2) * rinv;
            int n = iprevious;
            anglestep[n] = anglestep[n] + arc;
            int n2 = i2++;
            anglestep[n2] = anglestep[n2] + arc;
        }
        Point2D.Double vcenter = v.getRelativeCoordinateOfCenter();
        Point2D.Double scenter = s.getRelativeCoordinateOfCenter();
        double vx = vcenter.x;
        double vy = vcenter.y;
        double sx = scenter.x;
        double sy = scenter.y;
        DebugPrinter.println(2, "vindex:" + vindex);
        DebugPrinter.println(2, "sindex:" + sindex);
        DebugPrinter.println(2, "v:" + vx + " " + vy);
        DebugPrinter.println(2, "s:" + sx + " " + sy);
        double[] chord = this.unitVector(vx, vy, sx, sy);
        double[] center = this.unitVector(sy, vx, vy, sx);
        DebugPrinter.println(2, "e:" + center[0] + " " + center[1]);
        double dist = chord[3];
        double angleadjust = 0.0;
        int i3 = 0;
        while (i3 < vindex) {
            angleadjust += anglestep[i3];
            ++i3;
        }
        double anglearc = 0.0;
        if (vindex < sindex) {
            i = vindex;
            while (i < sindex) {
                anglearc += anglestep[i];
                ++i;
            }
            angleadjust = 0.5 * (Math.PI - anglearc) + chord[2] - angleadjust;
            index_order = 1;
        } else {
            i = sindex;
            while (i < vindex) {
                anglearc += anglestep[i];
                ++i;
            }
            angleadjust = 0.5 * (anglearc - Math.PI) + chord[2] - angleadjust;
            index_order = -1;
        }
        DebugPrinter.println(2, "|v-s| " + dist);
        DebugPrinter.println(2, "theta_0-v " + angleadjust);
        DebugPrinter.println(2, "theta_v-s " + anglearc);
        DebugPrinter.println(2, "theta_chord" + chord[2]);
        DebugPrinter.println(2, "theta_0 " + angleadjust);
        double perpsize = 0.5 * dist / Math.tan(0.5 * anglearc);
        double mx = 0.5 * (vx + sx);
        double my = 0.5 * (vy + sy);
        Point2D.Double cp_f = new Point2D.Double(mx + center[0] * perpsize, my + center[1] * perpsize);
        Point2D.Double cp_b = new Point2D.Double(mx - center[0] * perpsize, my - center[1] * perpsize);
        RingShape rs_v = v.getRingShape();
        RingShape rs_s = s.getRingShape();
        Point2D.Double cp = null;
        if (rs_v == null) {
            if (rs_s == null) {
                center_rotation = 1;
            } else {
                Point2D.Double center_s = rs_s.getCenter();
                center_rotation = center[0] * (center_s.x - sx) + center[1] * (center_s.y - sy) < 0.0 ? 1 : -1;
            }
        } else if (rs_s == null) {
            center_v = rs_v.getCenter();
            center_rotation = center[0] * (center_v.x - vx) + center[1] * (center_v.y - vy) < 0.0 ? 1 : -1;
        } else {
            center_v = rs_v.getCenter();
            Point2D.Double center_s = rs_s.getCenter();
            double c_cv = center[0] * (center_v.x - vx) + center[1] * (center_v.y - vy);
            double c_cs = center[0] * (center_s.x - sx) + center[1] * (center_s.y - sy);
            if (c_cv * c_cs > 0.0) {
                center_rotation = c_cv < 0.0 ? 1 : -1;
            } else {
                RingShape rs_f = new RingShape(cp_f, radius);
                RingShape rs_b = new RingShape(cp_b, radius);
                center_rotation = rs_f.overlappingAreaWith(rs_v) + rs_f.overlappingAreaWith(rs_s) < rs_b.overlappingAreaWith(rs_v) + rs_b.overlappingAreaWith(rs_s) ? 1 : -1;
            }
        }
        cp = center_rotation == 1 ? cp_f : cp_b;
        if (index_order * center_rotation > 0) {
            rotation_sign = -1;
            angleadjust = 2.0 * chord[2] - angleadjust;
        } else {
            rotation_sign = 1;
        }
        DebugPrinter.println(2, "c:" + cp.x + " " + cp.y);
        RingShape rs = new RingShape(cp, radius);
        double theta = 0.0;
        li = r.listIterator(0);
        while (li.hasNext()) {
            DummyAlias da = (DummyAlias)li.next();
            if (!da.isCoordinateSet()) {
                double x = cp.x + radius * Math.cos(theta + angleadjust);
                double y = cp.y + radius * Math.sin(theta + angleadjust);
                da.setRelativeCoordinateByCenter(new Point2D.Double(x, y));
            }
            if (da.getRingShape() == null) {
                da.setRingShape(rs);
            }
            theta += (double)rotation_sign * anglestep[li.previousIndex()];
        }
        return cp;
    }

    private void sectorLayout(ArrayList das, DummyAlias v, DummyAlias s) {
        double[] arcList = new double[das.size()];
        double totalarc = 0.0;
        double maxBox = Double.MIN_VALUE;
        ListIterator li = das.listIterator(0);
        while (li.hasNext()) {
            int index = li.nextIndex();
            DummyAlias da = (DummyAlias)li.next();
            arcList[index] = da.getLargerBoxSize() + 40.0;
            if (da.getLargerBoxSize() > maxBox) {
                maxBox = da.getLargerBoxSize();
            }
            totalarc += arcList[index];
        }
        double radius = totalarc / this.spread;
        DebugPrinter.println(2, "arc , radius: " + totalarc + " , " + radius);
        double rinv = 1.0 / radius;
        double[] anglestep = new double[arcList.length];
        int i = 0;
        while (i < anglestep.length) {
            int inext = (i + 1) % anglestep.length;
            anglestep[i] = 0.5 * (arcList[i] + arcList[inext]) * rinv;
            ++i;
        }
        if (radius < 0.7 * (v.getLargerBoxSize() + maxBox) + 40.0) {
            radius = 0.7 * (v.getLargerBoxSize() + maxBox) + 40.0;
        }
        DebugPrinter.println(2, "arc , radius: " + totalarc + " , " + radius);
        double totalangle = 0.0;
        int i2 = 0;
        while (i2 < anglestep.length - 1) {
            totalangle += anglestep[i2];
            ++i2;
        }
        DebugPrinter.println(2, "total angle: " + totalangle);
        Point2D.Double vcenter = v.getRelativeCoordinateOfCenter();
        Point2D.Double scenter = s.getRelativeCoordinateOfCenter();
        double vx = vcenter.x;
        double vy = vcenter.y;
        double sx = scenter.x;
        double sy = scenter.y;
        DebugPrinter.println(2, "v:" + vx + " " + vy);
        DebugPrinter.println(2, "s:" + sx + " " + sy);
        double[] center = this.unitVector(vx, vy, sx, sy);
        double angleadjust = center[2] - 0.5 * totalangle;
        DebugPrinter.println(2, "theta_0-c:" + center[2]);
        DebugPrinter.println(2, "theta_0-i:" + angleadjust);
        double theta = 0.0;
        li = das.listIterator(0);
        while (li.hasNext()) {
            DummyAlias da = (DummyAlias)li.next();
            if (!da.isCoordinateSet()) {
                double x = vx + radius * Math.cos(theta + angleadjust);
                double y = vy + radius * Math.sin(theta + angleadjust);
                da.setRelativeCoordinateByCenter(new Point2D.Double(x, y));
            }
            theta += anglestep[li.previousIndex()];
        }
        this.spread = 1.5707963267948966;
    }

    private double[] unitVector(double vx, double vy, double sx, double sy) {
        double x = vx - sx;
        double y = vy - sy;
        double norm = Math.sqrt(x * x + y * y);
        double ninv = 1.0 / norm;
        y *= ninv;
        double angle = 0.0;
        angle = 1.0 < x ? 0.0 : (x < -1.0 ? Math.PI : Math.acos(x *= ninv));
        if (y < 0.0) {
            angle = -angle;
        }
        return new double[]{x, y, angle, norm};
    }
}

