/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jp.fric.mathematics.graph.Edge;
import jp.fric.mathematics.graph.Graph;
import jp.fric.mathematics.graph.UndirectedGraph;
import jp.fric.mathematics.graph.Vertex;
import jp.fric.util.DebugPrinter;
import jp.sbi.sbml.autoLayout.DummyAlias;
import jp.sbi.sbml.autoLayout.NodeDummy;

class CompartmentDummy
extends DummyAlias {
    private UndirectedGraph children = new UndirectedGraph();
    private Rectangle2D.Double currentbounds = new Rectangle2D.Double();
    private Point2D.Double nextpoint;
    private final boolean RIGHT_APPEND = true;
    private final boolean BOTTOM_APPEND = false;
    private boolean appendmode;
    private static final double RATIO = Math.sqrt(0.5);

    public CompartmentDummy(String id) {
        super(id);
        this.nextpoint = new Point2D.Double(CompartmentDummy.BLANK.x, CompartmentDummy.BLANK.y);
        this.RIGHT_APPEND = true;
        this.BOTTOM_APPEND = false;
        this.appendmode = false;
        this.boxSize = new Point2D.Double(CompartmentDummy.C_SIZE.x, CompartmentDummy.C_SIZE.y);
    }

    public UndirectedGraph getChildren() {
        return this.children;
    }

    public void addChild(DummyAlias dummy) {
        this.children.addVertex(dummy);
    }

    public void setTreeLevel(int level) {
        super.setTag(level);
        ListIterator li = this.children.listIterator(0);
        while (li.hasNext()) {
            Vertex v = (Vertex)li.next();
            if (v instanceof CompartmentDummy) {
                ((CompartmentDummy)v).setTreeLevel(level + 1);
                continue;
            }
            v.setTag(level + 1);
        }
    }

    public void setAllTreeTag(int tag) {
        super.setTag(tag);
        ListIterator li = this.children.listIterator(0);
        while (li.hasNext()) {
            Vertex v = (Vertex)li.next();
            if (v instanceof CompartmentDummy) {
                ((CompartmentDummy)v).setAllTreeTag(tag);
                continue;
            }
            v.setTag(tag);
        }
    }

    public void abstractLinks() {
        ListIterator cli = this.children.listIterator(0);
        while (cli.hasNext()) {
            Vertex v = (Vertex)cli.next();
            if (v instanceof CompartmentDummy) {
                ((CompartmentDummy)v).abstractLinks();
            }
            ArrayList<Vertex> removelist = new ArrayList<Vertex>();
            ListIterator lli = v.listIterator(0);
            while (lli.hasNext()) {
                Vertex w = ((Edge)lli.next()).getEndPoint();
                if (this.children.contains(w) || w == this) continue;
                removelist.add(w);
                this.addEdge(w);
                w.removeEdge(v);
                w.addEdge(this);
            }
            lli = removelist.listIterator(0);
            while (lli.hasNext()) {
                v.removeEdge((Vertex)lli.next());
            }
        }
    }

    public void makeLinks() {
        ArrayList<Vertex> cDummies = new ArrayList<Vertex>();
        ListIterator cli = this.children.listIterator(0);
        while (cli.hasNext()) {
            Vertex v = (Vertex)cli.next();
            if (!(v instanceof CompartmentDummy)) continue;
            cDummies.add(v);
            ((CompartmentDummy)v).makeLinks();
        }
        if (cDummies.size() > 1) {
            LinkedList vlist;
            Vertex v;
            LinkedList listOfLinks = new LinkedList();
            int i = 0;
            while (i < cDummies.size()) {
                listOfLinks.add(new LinkedList());
                ++i;
            }
            ListIterator ili = cDummies.listIterator(0);
            ListIterator ilol = listOfLinks.listIterator(0);
            while (ili.hasNext()) {
                v = (Vertex)ili.next();
                vlist = (LinkedList)ilol.next();
                ListIterator eili = v.listIterator(0);
                while (eili.hasNext()) {
                    Vertex ve = ((Edge)eili.next()).getEndPoint();
                    if (v.getTag() < ve.getTag()) {
                        ListIterator jli = cDummies.listIterator(ili.nextIndex());
                        ListIterator jlol = listOfLinks.listIterator(ilol.nextIndex());
                        while (jli.hasNext()) {
                            Vertex w = (Vertex)jli.next();
                            LinkedList wlist = (LinkedList)jlol.next();
                            ListIterator ejli = w.listIterator(0);
                            while (ejli.hasNext()) {
                                Vertex we = (Vertex)ejli.next();
                                if (w.getTag() >= we.getTag() || !ve.isLinkedTo(we)) continue;
                                vlist.add(w);
                                wlist.add(v);
                            }
                        }
                        continue;
                    }
                    vlist.add(ve);
                }
            }
            ili = cDummies.listIterator(0);
            ilol = listOfLinks.listIterator(0);
            while (ili.hasNext()) {
                v = (Vertex)ili.next();
                v.clearEdge();
                vlist = (LinkedList)ilol.next();
                ListIterator li = vlist.listIterator(0);
                while (li.hasNext()) {
                    v.addEdge((Vertex)li.next());
                }
            }
        }
        ArrayList<Vertex> links = new ArrayList<Vertex>();
        cli = this.children.listIterator(0);
        while (cli.hasNext()) {
            Vertex v = (Vertex)cli.next();
            ListIterator jli = v.listIterator(0);
            while (jli.hasNext()) {
                Vertex w = ((Edge)jli.next()).getEndPoint();
                ListIterator kli = this.children.listIterator(0);
                boolean internallink = false;
                while (kli.hasNext()) {
                    if (w != (Vertex)kli.next()) continue;
                    internallink = true;
                    break;
                }
                if (internallink) continue;
                links.add(w);
            }
        }
        this.clearEdge();
        cli = links.listIterator(0);
        while (cli.hasNext()) {
            this.addEdge((Vertex)cli.next());
        }
    }

    @Override
    public Point2D.Double setBoxSize() {
        this.boxSize.x = Math.max(this.currentbounds.width + CompartmentDummy.BLANK.x, this.boxSize.x);
        this.boxSize.y = Math.max(this.currentbounds.height + CompartmentDummy.BLANK.y, this.boxSize.y);
        return this.boxSize;
    }

    public Point2D.Double setBoxSizeWithMargin(Point2D.Double margin) {
        this.boxSize.x = Math.max(this.currentbounds.width + margin.x, this.boxSize.x);
        this.boxSize.y = Math.max(this.currentbounds.height + margin.y, this.boxSize.y);
        return this.boxSize;
    }

    private void randomLayout(double width, double height) {
        ArrayList<Rectangle2D.Double> rects = new ArrayList<Rectangle2D.Double>();
        ListIterator li = this.children.listIterator(0);
        while (li.hasNext()) {
            DummyAlias v = (DummyAlias)li.next();
            if (v instanceof NodeDummy) {
                v.setRelativeCoordinate(new Point2D.Double(Math.round(0.5 * width), Math.round(0.5 * height)));
                continue;
            }
            Point2D.Double s = v.getBoxSize();
            double x = 0.0;
            double y = 0.0;
            boolean overlap = false;
            int safetycounter = 0;
            do {
                x = Math.round(width * Math.random());
                y = Math.round(height * Math.random());
                Rectangle2D.Double rect = new Rectangle2D.Double(x, y, s.x, s.y);
                ListIterator rli = rects.listIterator(0);
                overlap = false;
                while (rli.hasNext()) {
                    if (!rect.intersects((Rectangle2D)rli.next())) continue;
                    overlap = true;
                    break;
                }
                if (safetycounter >= 1000000) {
                    if (safetycounter == 1000000) {
                        DebugPrinter.println(2, "The loop jp.sbi.celldesigner.sbmlExtension.CompartmentDummy.calcSize seems to endless. Skip overlapping tests.");
                    }
                    overlap = false;
                }
                if (!overlap) {
                    rects.add(rect);
                }
                ++safetycounter;
            } while (overlap);
            v.setRelativeCoordinate(new Point2D.Double(x, y));
        }
    }

    private Rectangle2D.Double calcBounds() {
        if (this.children.size() == 0) {
            return new Rectangle2D.Double(CompartmentDummy.BLANK.x, CompartmentDummy.BLANK.y, 0.0, 0.0);
        }
        double minx = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double miny = Double.MAX_VALUE;
        double maxy = Double.MIN_VALUE;
        ListIterator li = this.children.listIterator(0);
        while (li.hasNext()) {
            DummyAlias da = (DummyAlias)li.next();
            Point2D.Double p = da.getRelativeCoordinate();
            Point2D.Double s = da.getBoxSize();
            if (p.x < minx) {
                minx = p.x;
            }
            if (p.y < miny) {
                miny = p.y;
            }
            if (p.x + s.x > maxx) {
                maxx = p.x + s.x;
            }
            if (!(p.y + s.y > maxy)) continue;
            maxy = p.y + s.y;
        }
        double qx = CompartmentDummy.BLANK.x - minx;
        double qy = CompartmentDummy.BLANK.y - miny;
        li = this.children.listIterator(0);
        while (li.hasNext()) {
            DummyAlias da = (DummyAlias)li.next();
            Point2D.Double p = da.getRelativeCoordinate();
            da.setRelativeCoordinate(new Point2D.Double(p.x + qx, p.y + qy));
        }
        return new Rectangle2D.Double(CompartmentDummy.BLANK.x, CompartmentDummy.BLANK.y, maxx - minx, maxy - miny);
    }

    public Rectangle2D.Double calcBounds(Graph ug) {
        if (ug.size() == 0) {
            return new Rectangle2D.Double(this.nextpoint.x, this.nextpoint.y, 0.0, 0.0);
        }
        double minx = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double miny = Double.MAX_VALUE;
        double maxy = Double.MIN_VALUE;
        ListIterator li = ug.listIterator(0);
        while (li.hasNext()) {
            DebugPrinter.println(2, " " + li.nextIndex());
            DummyAlias da = (DummyAlias)li.next();
            Point2D.Double r = da.getRelativeCoordinate();
            Point2D.Double s = da.getBoxSize();
            if (r.x < minx) {
                minx = r.x;
            }
            if (r.y < miny) {
                miny = r.y;
            }
            if (r.x + s.x > maxx) {
                maxx = r.x + s.x;
            }
            if (!(r.y + s.y > maxy)) continue;
            maxy = r.y + s.y;
        }
        double w = 2.0 * Math.ceil((maxx - minx) / 2.0);
        double h = 2.0 * Math.ceil((maxy - miny) / 2.0);
        DebugPrinter.println(2, "w x h: " + w + " x " + h);
        double boxx = this.currentbounds.getWidth();
        double boxy = this.currentbounds.getHeight();
        DebugPrinter.println(2, "current: " + boxx + " x " + boxy);
        DebugPrinter.println(2, "ratio  : " + RATIO);
        boolean renewal = false;
        if (this.appendmode) {
            if (boxy < this.nextpoint.y + h) {
                renewal = true;
            }
        } else if (boxx < this.nextpoint.x + w) {
            renewal = true;
        }
        if (renewal) {
            double rapp = Math.max(boxy, h + CompartmentDummy.BLANK.y) / (boxx + w + CompartmentDummy.BLANK.x);
            double bapp = (boxy + h + CompartmentDummy.BLANK.y) / Math.max(boxx, w + CompartmentDummy.BLANK.x);
            if (Math.abs(rapp - RATIO) < Math.abs(bapp - RATIO)) {
                this.appendmode = true;
                this.nextpoint.x = boxx + CompartmentDummy.BLANK.x;
                this.nextpoint.y = CompartmentDummy.BLANK.y;
            } else {
                this.appendmode = false;
                this.nextpoint.x = CompartmentDummy.BLANK.x;
                this.nextpoint.y = boxy + CompartmentDummy.BLANK.y;
            }
        }
        if (boxx < this.nextpoint.x + w) {
            boxx = this.nextpoint.x + w;
        }
        if (boxy < this.nextpoint.y + h) {
            boxy = this.nextpoint.y + h;
        }
        DebugPrinter.println(2, "renewal: " + boxx + " x " + boxy);
        this.currentbounds.setRect(0.0, 0.0, boxx, boxy);
        DebugPrinter.println(2, "renewal: " + this.currentbounds.getWidth() + " x " + this.currentbounds.getHeight());
        double qx = this.nextpoint.x - minx;
        double qy = this.nextpoint.y - miny;
        li = ug.listIterator(0);
        while (li.hasNext()) {
            DummyAlias da = (DummyAlias)li.next();
            Point2D.Double r = da.getRelativeCoordinate();
            da.setRelativeCoordinate(new Point2D.Double(Math.ceil(r.x + qx), Math.ceil(r.y + qy)));
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(this.nextpoint.x, this.nextpoint.y, w, h);
        if (this.appendmode) {
            this.nextpoint.y += h + CompartmentDummy.BLANK.y;
        } else {
            this.nextpoint.x += w + CompartmentDummy.BLANK.x;
        }
        DebugPrinter.println(2, "nextp: " + this.nextpoint.x + " x " + this.nextpoint.y);
        return rect;
    }

    @Override
    public void setParentPosition(Point2D.Double pp) {
        this.parentPosition = pp;
        Point2D.Double ap = new Point2D.Double(this.parentPosition.x + this.relativeCoordinate.x, this.parentPosition.y + this.relativeCoordinate.y);
        DebugPrinter.println(2, "box size in setParentPosition " + this.boxSize.x + " " + this.boxSize.y);
        this.bounds = new Rectangle2D.Double(ap.x, ap.y, this.boxSize.x, this.boxSize.y);
        ListIterator li = this.children.listIterator(0);
        while (li.hasNext()) {
            DummyAlias da = (DummyAlias)li.next();
            if (da instanceof CompartmentDummy) {
                ((CompartmentDummy)da).setParentPosition(ap);
                continue;
            }
            da.setParentPosition(ap);
        }
    }

    public void displayTree() {
        DebugPrinter.println(2, String.valueOf(this.getId()) + " : " + this.getTag());
        ListIterator li = this.children.listIterator(0);
        while (li.hasNext()) {
            DummyAlias da = (DummyAlias)li.next();
            if (da instanceof CompartmentDummy) {
                ((CompartmentDummy)da).displayTree();
                continue;
            }
            DebugPrinter.println(2, String.valueOf(da.getId()) + " : " + da.getTag());
        }
    }

    public void displaySubgraph(List ug) {
        DebugPrinter.println(2, "Subgraph listing");
        ListIterator li = ug.listIterator(0);
        while (li.hasNext()) {
            DummyAlias da = (DummyAlias)li.next();
            DebugPrinter.println(2, String.valueOf(da.getID()) + ":" + da.getId());
        }
    }
}

