/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml;

public class SpecInfo {
    public static final int DefaultSystemSpecInfoLEVEL = 2;
    public static final int DefaultSystemSpecInfoVERSION = 4;
    private int level = 2;
    private int version = 4;

    public SpecInfo() {
    }

    public SpecInfo(int level, int version) {
        if (SpecInfo.isLevelAndVersionBeenSupported(level, version)) {
            this.level = level;
            this.version = version;
        }
    }

    public SpecInfo(long level, long version) {
        if (SpecInfo.isLevelAndVersionBeenSupported(level, version)) {
            this.level = (int)level;
            this.version = (int)version;
        }
    }

    public int getLevel() {
        return this.level;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isEqual(int level, int version) {
        return level == this.level && version == this.version;
    }

    public final boolean isEqual(SpecInfo sInfo) {
        return this.isEqual(sInfo.getLevel(), sInfo.getVersion());
    }

    public static final boolean isLevelAndVersionBeenSupported(int level, int version) {
        if (level == 1 && version == 1) {
            return true;
        }
        if (level == 1 && version == 2) {
            return true;
        }
        if (level == 2 && version == 1) {
            return true;
        }
        if (level == 2 && version == 2) {
            return true;
        }
        if (level == 2 && version == 3) {
            return true;
        }
        return level == 2 && version == 4;
    }

    public static final boolean isLevelAndVersionBeenSupported(long level, long version) {
        return SpecInfo.isLevelAndVersionBeenSupported((int)level, (int)version);
    }

    public boolean setLevelAndVersion(int level, int version) {
        if (SpecInfo.isLevelAndVersionBeenSupported(level, version)) {
            this.level = level;
            this.version = version;
            return true;
        }
        return false;
    }

    public boolean setLevelAndVersion(long level, long version) {
        return this.setLevelAndVersion((int)level, (int)version);
    }
}

