/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml;

import jp.sbi.sbml.SIdFormatException;

public class SId {
    private static final char[] CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '_'};
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final String strSIdFormatExceptionVoidString = "SId:void string";
    public static final String strSIdFormatExceptionMalformedString = "SId:malformed string";

    private SId() {
    }

    public static void check(String str) throws SIdFormatException {
        if (str.equals("")) {
            throw new SIdFormatException(strSIdFormatExceptionVoidString);
        }
        boolean isOK = true;
        char[] chars = str.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (i == 0) {
                if (!SId.isChar(c)) {
                    isOK = false;
                    break;
                }
            } else if (!SId.isChar(c) && !SId.isDigit(c)) {
                isOK = false;
                break;
            }
            ++i;
        }
        if (!isOK) {
            throw new SIdFormatException(strSIdFormatExceptionMalformedString);
        }
    }

    private static boolean isChar(char c) {
        int i = 0;
        while (i < CHARS.length) {
            if (CHARS[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isDigit(char c) {
        int i = 0;
        while (i < DIGITS.length) {
            if (DIGITS[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean equals(String str1, String str2) throws SIdFormatException {
        if (str1.equals("")) {
            throw new SIdFormatException("str1 is void string");
        }
        if (str2.equals("")) {
            throw new SIdFormatException("str2 is void string");
        }
        SId.check(str1);
        SId.check(str2);
        return str1.equals(str2);
    }
}

