/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml;

import java.io.PrintWriter;
import java.util.HashMap;
import jp.sbi.sbml.Any;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.XMLUtil;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.XMLNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Notes
implements Any {
    protected String text = "";

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String[] getAttributeShortNames() {
        return new String[0];
    }

    @Override
    public int[] getAttributeColumnSizes() {
        return new int[0];
    }

    @Override
    public String[] getAttributeValues() {
        return new String[0];
    }

    @Override
    public boolean hasValue() {
        return !this.text.equals("");
    }

    public void readXML(Node node) throws Exception {
        char c;
        String tabedText = XMLUtil.getValue(node);
        char[] original = tabedText.toCharArray();
        int startIndex = 0;
        int endIndex = original.length;
        int i = 0;
        while (i < original.length) {
            c = original[i];
            if (c != '\t' && c != '\n' && c != '\r') break;
            ++i;
        }
        startIndex = i;
        i = original.length - 1;
        while (-1 < i) {
            c = original[i];
            if (c != '\t' && c != '\n' && c != '\r') break;
            --i;
        }
        endIndex = i + 1;
        if (startIndex < endIndex) {
            this.text = tabedText.substring(startIndex, endIndex);
        }
    }

    @Override
    public void readDOMTree(Element element) throws Exception {
        String URI2 = element.getNamespaceURI();
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        Node listNode = null;
        int j = 0;
        while (j < childsize) {
            Node temp = childlist.item(j);
            if (temp.getNodeType() == 3) {
                listNode = temp;
                break;
            }
            ++j;
        }
        if (listNode != null) {
            this.text = listNode.getNodeValue();
        }
    }

    public String readDOMTreeReturnString(Element element) throws Exception {
        String URI2 = element.getNamespaceURI();
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        Node listNode = null;
        int j = 0;
        while (j < childsize) {
            Node temp = childlist.item(j);
            if (temp.getNodeType() == 3) {
                listNode = temp;
                break;
            }
            ++j;
        }
        if (listNode != null) {
            return listNode.getNodeValue();
        }
        return null;
    }

    public void writeXML(String indent, PrintWriter pw) {
        pw.println(String.valueOf(indent) + this.text);
    }

    @Override
    public void writeDOMTree(Node node) throws Exception {
        Document doc = node.getOwnerDocument();
        node.appendChild(doc.createTextNode(this.text));
    }

    @Override
    public void releaseAllMembers() {
    }

    @Override
    public void setParentSBase(SBase sbase) {
    }

    public Notes createCopy() {
        return (Notes)this.clone();
    }

    public Object clone() {
        Notes n = new Notes();
        n.setText(this.text);
        return n;
    }

    public void updateNotes(SBase sbase) {
        if (sbase == null || this == null) {
            return;
        }
        String ntext = this.getText();
        if (this == null || ntext == null || ntext.equals("")) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
        buf.append("<head> <title/> </head>\n");
        buf.append("<!--Notes by CellDesigner-->\n");
        buf.append("<body>\n");
        buf.append(ntext);
        buf.append("\n");
        buf.append("</body>\n");
        buf.append("</html>");
        sbase.setNotes(buf.toString());
    }

    public XMLNode getCDNotes(SBase sbase) {
        if (sbase == null) {
            return null;
        }
        String ntext = this.getText();
        if (ntext == null || ntext.equals("")) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<notes>");
        buf.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
        buf.append("<head> <title/> </head>\n");
        buf.append("<!--Notes by CellDesigner-->\n");
        buf.append("<body>");
        buf.append(String.valueOf(ntext) + "\n");
        buf.append("</body>\n");
        buf.append("</html>");
        buf.append("</notes>");
        XMLNode cdnotes = XMLNode.convertStringToXMLNode((String)buf.toString());
        return cdnotes;
    }

    public String getCDNotesBodyString(SBase sbase) {
        XMLNode xn = this.getCDNotes(sbase);
        return LibSBMLUtil.getCDNotesBodyString(xn);
    }

    @Override
    public HashMap getLocalNS() {
        return null;
    }
}

