/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jp.sbi.celldesigner.util.OpenURLThread;

public class UpdateChecker {
    private final String URL_RELEASE = "http://celldesigner.org/version.txt";
    private final String URL_BETA = "http://celldesigner.org/version-beta32.txt";
    private final String TITLE = "Software Update";
    private String url = "http://celldesigner.org/version.txt";
    private int currentVersion = 43000;
    private int version;
    private String name;
    private String date;
    private String updateURL;
    private String description = "";
    private String newline = System.getProperty("line.separator");

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getUpdateURL() {
        return this.updateURL;
    }

    public String getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public void showUpdateDialog(JFrame frame) {
        String message = String.valueOf(this.name) + " is available!" + this.newline + this.newline + this.description + this.newline + this.newline + "Do you want to download it now?";
        int value = JOptionPane.showConfirmDialog(frame, message, "Software Update", 0);
        if (value == 0) {
            OpenURLThread ourlt = new OpenURLThread(this.updateURL);
            Thread t = new Thread(ourlt);
            t.start();
        }
    }

    public void showNoUpdateDialog(JFrame frame) {
        JOptionPane.showMessageDialog(frame, "There is no new update available.", "Software Update", 1);
    }

    public void showUpdateErrorDialog(JFrame frame) {
        JOptionPane.showMessageDialog(frame, "Can't get update information." + this.newline + "Please check your network settings.", "Software Update", 1);
    }

    public void checkUpdateInfo(JFrame frame, boolean fromMenu) {
        if (this.getUpdateInfo()) {
            if (this.getVersion() > this.currentVersion) {
                this.showUpdateDialog(frame);
            } else if (fromMenu) {
                this.showNoUpdateDialog(frame);
            }
        } else if (fromMenu) {
            this.showUpdateErrorDialog(frame);
        }
    }

    public boolean getUpdateInfo() {
        int timeout = 2000;
        try {
            URL url = new URL(this.url);
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            this.parseVersionInfo(br);
            br.close();
        }
        catch (IOException e) {
            System.out.println("Can not update because it can not access to Internet.");
            return false;
        }
        return true;
    }

    public void parseVersionInfo(BufferedReader br) throws IOException {
        String line;
        boolean isDescription = false;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            if (line.startsWith("version=")) {
                this.version = Integer.parseInt(line.replaceAll("version=", ""));
                continue;
            }
            if (line.startsWith("name=")) {
                this.name = line.replaceAll("name=", "");
                continue;
            }
            if (line.startsWith("date=")) {
                this.date = line.replaceAll("date=", "");
                continue;
            }
            if (line.startsWith("url=")) {
                this.updateURL = line.replaceAll("url=", "");
                continue;
            }
            if (line.startsWith("desc=")) {
                this.description = line.replaceAll("desc=", "");
                isDescription = true;
                continue;
            }
            if (!isDescription) continue;
            this.description = String.valueOf(this.description) + this.newline + line;
        }
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("http.proxyHost"));
        System.out.println(System.getProperty("http.proxyPort"));
        UpdateChecker up = new UpdateChecker();
        if (up.getUpdateInfo()) {
            if (up.getVersion() > up.currentVersion) {
                System.out.println("New version " + up.getVersion() + " is available!");
            }
            System.out.println("Version:    " + up.getVersion());
            System.out.println("Name:       " + up.getName());
            System.out.println("updateURL:  " + up.getUpdateURL());
            System.out.println("Date:       " + up.getDate());
            System.out.println(up.getDescription());
        } else {
            System.out.println("Update check failed...");
        }
        System.exit(0);
    }
}

