/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MyFileManager;
import jp.sbi.celldesigner.util.RecentFiles;

public class RecentFilesMenu
extends JMenu
implements ActionListener,
ChangeListener {
    private RecentFiles recentFiles = null;
    private MyFileManager filemanager = null;

    public RecentFilesMenu(JMenu menu, RecentFiles recentFiles, MyFileManager filemanager) {
        super("Recent Files");
        menu.add(this);
        this.recentFiles = recentFiles;
        this.recentFiles.addChangeListener(this);
        this.filemanager = filemanager;
        this.update();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String[] words = e.getActionCommand().split(":");
        String filename = this.recentFiles.getFileNameFromNewest(Integer.parseInt(words[0].trim()));
        this.filemanager.getOpenCommand(new File(filename));
        MainWindow lastInstance = MainWindow.getLastInstance();
        if (lastInstance != null) {
            lastInstance.changeCPMenuEnability();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.update();
    }

    private void update() {
        this.removeAll();
        Vector files = this.recentFiles.getDisplayableList();
        JMenuItem temp = null;
        int i = 0;
        while (i < files.size()) {
            String nameAndPath = (String)files.elementAt(i);
            temp = new JMenuItem(nameAndPath);
            if (i < 9) {
                temp.setMnemonic(49 + i);
            }
            temp.addActionListener(this);
            this.add(temp);
            ++i;
        }
    }
}

