/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RecentFiles {
    private LinkedList items = new LinkedList();
    private static final int defaultMaxItemNumber = 10;
    private int maxItemNumber = 10;
    private Vector listeners = null;

    public synchronized Object clone() {
        RecentFiles r = new RecentFiles();
        r.maxItemNumber = this.maxItemNumber;
        if (this.items == null) {
            return r;
        }
        ListIterator li = this.items.listIterator();
        while (li.hasNext()) {
            r.items.addLast(new String((String)li.next()));
        }
        return r;
    }

    public synchronized void add(String filename) {
        if (this.items == null) {
            this.items = new LinkedList();
        }
        if (filename == null || this.items.size() > 0 && filename.equals((String)this.items.getLast())) {
            return;
        }
        ListIterator li = this.items.listIterator(this.items.size());
        while (li.hasPrevious()) {
            String file = (String)li.previous();
            if (!filename.equals(file)) continue;
            li.remove();
        }
        this.items.addLast(filename);
        this.checkCount();
        this.fireListeners();
    }

    public synchronized void add(List filenameList) {
        if (this.items == null) {
            this.items = new LinkedList();
        }
        if (filenameList == null) {
            return;
        }
        ListIterator fli = filenameList.listIterator();
        while (fli.hasNext()) {
            Object obj = fli.next();
            if (obj == null) continue;
            String filename = (String)obj;
            ListIterator li = this.items.listIterator(this.items.size());
            while (li.hasPrevious()) {
                String file = (String)li.previous();
                if (!filename.equals(file)) continue;
                li.remove();
            }
            this.items.addLast(filename);
        }
        this.checkCount();
        this.fireListeners();
    }

    private synchronized void checkCount() {
        while (this.items.size() > this.maxItemNumber) {
            this.items.removeFirst();
        }
    }

    public Vector getAllItems() {
        return new Vector(this.items);
    }

    public synchronized String serialize() {
        if (this.items == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        ListIterator li = this.items.listIterator();
        while (li.hasNext()) {
            try {
                bw.write((String)li.next());
                if (!li.hasNext()) continue;
                bw.newLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            bw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    public Vector getDisplayableList() {
        int itemsize = this.items.size();
        int digits = 1;
        int i = itemsize;
        while ((i /= 10) >= 1) {
            ++digits;
        }
        String[][] list = new String[itemsize][2];
        ListIterator li = this.items.listIterator(this.items.size());
        while (li.hasPrevious()) {
            String filename = (String)li.previous();
            String separator = File.separator;
            if (separator.equals("\\")) {
                separator = "\\" + separator;
            }
            String[] words = filename.split(separator);
            String file = words[words.length - 1];
            String path = "";
            int i2 = 0;
            while (i2 < words.length - 1) {
                path = String.valueOf(path) + words[i2] + File.separator;
                ++i2;
            }
            list[itemsize - 1 - li.nextIndex()] = new String[]{file, path};
        }
        int paddingsize = digits;
        char[] paddingspace = new char[paddingsize];
        int i3 = 0;
        while (i3 < paddingsize) {
            paddingspace[i3] = 32;
            ++i3;
        }
        String text = null;
        Vector<String> displaylist = new Vector<String>(itemsize);
        int i4 = 0;
        while (i4 < itemsize) {
            String number = Integer.toString(i4 + 1);
            text = String.valueOf(new String(paddingspace, 0, digits - number.length())) + number + ": " + list[i4][0] + "  [ " + list[i4][1] + " ]";
            displaylist.addElement(text);
            ++i4;
        }
        return displaylist;
    }

    public String getFileNameFromNewest(int nth) {
        return (String)this.items.get(this.items.size() - nth);
    }

    public void setMaxItemNumber(int max) {
        if (max < 1) {
            this.maxItemNumber = 10;
        }
        this.maxItemNumber = max;
    }

    public int getMaxItemNumber() {
        return this.maxItemNumber;
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        int i = 0;
        while (i < this.listeners.size()) {
            if (listener == this.listeners.elementAt(i)) {
                return;
            }
            ++i;
        }
        this.listeners.addElement(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (listener == null || this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void removeAllChangeListeners() {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeAllElements();
        this.listeners = null;
    }

    private void fireListeners() {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        ChangeEvent e = new ChangeEvent(this);
        int i = 0;
        while (i < this.listeners.size()) {
            ((ChangeListener)this.listeners.elementAt(i)).stateChanged(e);
            ++i;
        }
    }
}

