/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.util;

import java.io.File;
import java.util.Vector;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBMLControl;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesProfile;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLReader;
import org.sbml.libsbml.SBMLWriter;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class ParseTest {
    public static void main(String[] args) {
        if (args.length != 1) {
            ParseTest.exit();
        }
        File filepath = new File(args[0]);
        File outputfile = new File(String.valueOf(filepath.getParent()) + File.separator + "parse-test.xml");
        new SBMLControl();
        SBMLDocument doc = new SBMLDocument();
        try {
            SBMLReader reader = new SBMLReader();
            doc = reader.readSBML(filepath.getAbsolutePath());
            LibSBMLUtil.setParameterAnnotation((ListOf)doc.getModel().getListOfReactions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SBModel sbmodel = null;
        try {
            sbmodel = new SBModel(doc, new SBFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SBFactory factory = new SBFactory();
        SpeciesAlias sa1 = (SpeciesAlias)factory.createObject("GENERIC");
        Species s1 = new Species();
        sa1.setOriginalSpecies(s1);
        ((SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)s1, null)).addReference(sa1);
        sa1.setFrameSize(80.0, 30.0);
        sa1.setFramePosition(10.0, 10.0);
        sa1.update();
        SpeciesAlias sa2 = (SpeciesAlias)factory.createObject("GENERIC");
        Species s2 = new Species();
        sa2.setOriginalSpecies(s2);
        ((SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)s2, null)).addReference(sa2);
        sa2.setFrameSize(80.0, 30.0);
        sa2.setFramePosition(200.0, 200.0);
        sa2.update();
        sbmodel.getGStructure().create(sa1);
        sbmodel.getGStructure().create(sa2);
        ReactionLink rl = (ReactionLink)factory.createObject("STATE_TRANSITION");
        Reaction r = new Reaction();
        rl.setParentReaction(r);
        rl.addSource((GLinkTarget)sa1, (GLinkPositionInfo)null);
        rl.addDestination((GLinkTarget)sa2, (GLinkPositionInfo)null);
        sbmodel.getGStructure().create(rl);
        Species target = new Species();
        Protein protein = new Protein();
        protein.setName("s4");
        protein.setType("TRUNCATED");
        MonoSpeciesProperty property = new MonoSpeciesProperty();
        property.setHomodimer(1);
        property.setHypothetical(false);
        property.setModifications(new Vector());
        property.setProtein(protein);
        property.setType("PROTEIN");
        ((SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)target, null)).setSpeciesProperty(property);
        SpeciesProfile targetProfile = null;
        try {
            targetProfile = SpeciesProfile.createProfile(target);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        targetProfile.setCompartment("default");
        targetProfile.setPositionToCompartment(4);
        Vector aliasVector = sbmodel.getGStructure().getAtoms();
        SpeciesAlias alias2 = null;
        for (SpeciesAlias alias2 : aliasVector) {
            SpeciesProfile profile;
            try {
                profile = SpeciesProfile.createProfile(alias2);
            }
            catch (Exception e) {
                System.err.println(e);
                continue;
            }
            if (targetProfile.corresponds(profile)) break;
            alias2 = null;
        }
        if (alias2 != null) {
            sbmodel.getGStructure().remove(alias2);
        }
        try {
            sbmodel.prepareSave();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            SBMLWriter writer = new SBMLWriter();
            writer.writeSBML(doc, outputfile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ParseTest.exit();
    }

    private static void exit() {
        System.out.println("Output end.");
        System.exit(0);
    }
}

