/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import jp.sbi.celldesigner.util.ObjectComparator;
import jp.sbi.celldesigner.util.SBaseComparator;
import org.sbml.libsbml.SBase;

public class ObjectHistoryManager {
    private long lSequence = 0L;
    private Object newestMe = null;
    private Object historyTree = null;

    public ObjectHistoryManager(Object me, Object his, long seq) {
        this.lSequence = seq;
        this.newestMe = me;
        this.historyTree = his;
    }

    public long getSequence() {
        return this.lSequence;
    }

    public void setSequence(long seq) {
        this.lSequence = seq;
    }

    public Object getNewestMe() {
        return this.newestMe;
    }

    public void setNewestMe(Object me) {
        this.newestMe = me;
    }

    public Object getHistoryTree() {
        return this.historyTree;
    }

    public void setHistoryTree(Object his) {
        this.historyTree = his;
    }

    public static Object getEndLeafOfHistoryTree(ObjectHistoryManager manager) {
        if (manager == null) {
            return null;
        }
        Object tree = manager.getHistoryTree();
        if (tree == null) {
            return null;
        }
        if (tree instanceof ObjectHistoryManager) {
            return ObjectHistoryManager.getEndLeafOfHistoryTree((ObjectHistoryManager)tree);
        }
        return tree;
    }

    public static boolean isHaveNotBeenUpdated(ObjectHistoryManager manager) throws Exception {
        if (manager == null) {
            throw new Exception();
        }
        return manager.getNewestMe() == manager.getHistoryTree();
    }

    public static boolean isDeletedLeaf(ObjectHistoryManager manager) throws Exception {
        if (manager == null) {
            throw new Exception();
        }
        return manager.getNewestMe() == null;
    }

    public static boolean isAddedLeaf(ObjectHistoryManager manager) throws Exception {
        if (manager == null) {
            throw new Exception();
        }
        return ObjectHistoryManager.getEndLeafOfHistoryTree(manager) == null;
    }

    public static boolean isStartByAddedThenEndByDeleted(ObjectHistoryManager manager) throws Exception {
        if (manager == null) {
            throw new Exception();
        }
        return ObjectHistoryManager.isAddedLeaf(manager) && ObjectHistoryManager.isDeletedLeaf(manager);
    }

    public static final ObjectHistoryManager updateNewstHisRec(ObjectHistoryManager manager, Object newest, long seq) {
        ObjectHistoryManager managerNew = new ObjectHistoryManager(newest, manager, seq);
        return managerNew;
    }

    public static final void updateNewstHisData(ObjectHistoryManager[] lstManager, Object old, Object newest, long seq) {
        if (lstManager == null) {
            return;
        }
        if (old == null) {
            return;
        }
        int i = 0;
        while (i < lstManager.length) {
            if (lstManager[i].newestMe instanceof SBase && old instanceof SBase && SBaseComparator.equals((SBase)lstManager[i].newestMe, (SBase)old)) {
                ObjectHistoryManager managerNew;
                lstManager[i] = managerNew = ObjectHistoryManager.updateNewstHisRec(lstManager[i], newest, seq);
                break;
            }
            ++i;
        }
    }

    public static final ObjectHistoryManager[] removeUselessHisData(ObjectHistoryManager[] lstManager) {
        if (lstManager == null || lstManager.length <= 0) {
            return lstManager;
        }
        int iSize = lstManager.length;
        boolean[] bUseful = new boolean[iSize];
        int i = 0;
        while (i < iSize) {
            bUseful[i] = false;
            ++i;
        }
        int iUsefulCounter = 0;
        int i2 = 0;
        while (i2 < iSize) {
            try {
                if (!ObjectHistoryManager.isStartByAddedThenEndByDeleted(lstManager[i2])) {
                    bUseful[i2] = true;
                    ++iUsefulCounter;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        ObjectHistoryManager[] lstManagerNew = new ObjectHistoryManager[iUsefulCounter];
        int j = 0;
        int i3 = 0;
        while (i3 < iSize) {
            if (bUseful[i3]) {
                lstManagerNew[j++] = lstManager[i3];
            }
            ++i3;
        }
        return lstManagerNew;
    }

    public static final Vector changeHisDataFromObjectSeqToActionSeq(ObjectHistoryManager[] lstManager) {
        ArrayList arrayList2;
        ArrayList arrayList;
        Vector rtn = new Vector();
        if (lstManager == null || lstManager.length <= 0) {
            return rtn;
        }
        int iSize = lstManager.length;
        HashMap map = new HashMap();
        int i = 0;
        while (i < iSize) {
            ObjectHistoryManager.putAllOfHisDataToHashmap(map, lstManager[i]);
            ++i;
        }
        ArrayList ents = arrayList = (arrayList2 = new ArrayList(map.entrySet()));
        Collections.sort(ents, new ObjectComparator());
        int i2 = 0;
        while (i2 < ents.size()) {
            Map.Entry me = ents.get(i2);
            String key = (String)me.getKey();
            Object value = map.get(key);
            rtn.add(value);
            ++i2;
        }
        return rtn;
    }

    public static final void putAllOfHisDataToHashmap(HashMap map, ObjectHistoryManager manager) {
        if (map == null) {
            map = new HashMap<String, ObjectHistoryManager>();
        }
        if (manager == null) {
            return;
        }
        String head = "00000000000000000000";
        String key = "00000000000000000000" + manager.getSequence();
        key = key.substring(key.length() - "00000000000000000000".length());
        map.put(key, manager);
        Object tree = manager.getHistoryTree();
        if (tree instanceof ObjectHistoryManager) {
            ObjectHistoryManager.putAllOfHisDataToHashmap(map, (ObjectHistoryManager)manager.getHistoryTree());
        }
    }
}

