/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.util;

import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Document;
import jp.sbi.celldesigner.database.PathwayEntry;

public class IncrementalSearch
implements DocumentListener {
    protected JTable tableContent;
    protected AbstractTableModel dataModel;
    protected Vector<PathwayEntry> modelList;
    protected Vector<PathwayEntry> modelViewList;
    protected String query;

    public IncrementalSearch(JTable jtable, Vector<PathwayEntry> mList, Vector<PathwayEntry> mViewList) {
        this.modelList = mList;
        this.modelViewList = mViewList;
        this.tableContent = jtable;
        this.dataModel = (AbstractTableModel)jtable.getModel();
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.runUpdateSearch(evt.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.runNewSearch(evt.getDocument());
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.runNewSearch(evt.getDocument());
    }

    private void runUpdateSearch(Document query_doc) {
        try {
            this.query = query_doc.getText(0, query_doc.getLength()).toLowerCase();
            int i = this.dataModel.getRowCount() - 1;
            while (i >= 0) {
                String strName = this.modelViewList.get(i).getName().toLowerCase();
                if (!strName.contains(this.query)) {
                    this.modelViewList.remove(i);
                    this.dataModel.fireTableRowsDeleted(i, i);
                }
                --i;
            }
            this.continueSearch();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void runNewSearch(Document query_doc) {
        try {
            this.query = query_doc.getText(0, query_doc.getLength()).toLowerCase();
            this.runNewSearch(this.query);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void runNewSearch(String query) {
        this.modelViewList.clear();
        for (PathwayEntry m : this.modelList) {
            this.modelViewList.add(m);
        }
        if (query.equals("")) {
            this.dataModel.fireTableDataChanged();
        } else {
            int i = this.modelList.size() - 1;
            while (i >= 0) {
                String strName = this.modelList.get(i).getName().toLowerCase();
                if (!strName.contains(query)) {
                    this.modelViewList.remove(i);
                    this.dataModel.fireTableRowsDeleted(i, i);
                }
                --i;
            }
        }
        this.continueSearch();
    }

    private void continueSearch() {
    }
}

